/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.freehep.util.io.RunLength;

public class RunLengthInputStream
extends InputStream
implements RunLength {
    private int[] buffer = new int[128];
    private int index;
    private int count;
    private InputStream in;

    public RunLengthInputStream(InputStream inputStream) {
        this.in = inputStream;
        this.index = 0;
        this.count = 0;
    }

    public int read() throws IOException {
        if (!(this.index < this.count && this.index <= 128 || this.fillBuffer())) {
            return -1;
        }
        int n2 = this.buffer[this.index];
        ++this.index;
        return n2 & 0xFF;
    }

    private boolean fillBuffer() throws IOException {
        this.count = this.in.read();
        if (this.end(this.count)) {
            return false;
        }
        if (this.count < 128) {
            ++this.count;
            for (int i2 = 0; i2 < this.count; ++i2) {
                this.buffer[i2] = this.in.read();
                if (!this.end(this.buffer[i2])) continue;
                return false;
            }
        } else {
            this.count = 257 - this.count;
            int n2 = this.in.read();
            if (this.end(n2)) {
                return false;
            }
            for (int i3 = 0; i3 < this.count; ++i3) {
                this.buffer[i3] = n2;
            }
        }
        this.index = 0;
        return true;
    }

    private boolean end(int n2) {
        return n2 < 0 || n2 == 128;
    }
}

