/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.CellPoint;
import SharpTools.CellRange;
import SharpTools.Config;
import SharpTools.Database;
import SharpTools.NewFileDialog;
import SharpTools.PasswordDialog;
import SharpTools.RecentFileListener;
import SharpTools.SharpOptionPane;
import SharpTools.SharpTableModel;
import SharpTools.SharpTools;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FileOp
implements ActionListener,
Printable {
    private static final int UNNAMED = 0;
    private static final int FILE = 1;
    private static final int DATABASE = 2;
    private int openType = 0;
    private int maxNumPage = 1;
    private boolean columnOverflow;
    private StringTokenizer tokenizer;
    private PrintStream out;
    private BufferedReader in;
    private SharpTools sharp;
    private JTable table;
    private SharpTableModel tableModel;
    private File file;
    private String password;
    private JFileChooser fileChooser;
    private static SharpFileFilter filter;
    final ImageIcon newIcon = new ImageIcon(this.getClass().getResource("/images/new32.gif"));
    final ImageIcon openIcon = new ImageIcon(this.getClass().getResource("/images/open.gif"));
    final ImageIcon saveIcon = new ImageIcon(this.getClass().getResource("/images/save32.gif"));
    private static final String extname = ".csv";

    public FileOp(SharpTools gui) {
        this.sharp = gui;
        this.table = gui.getTable();
        this.tableModel = gui.getTableModel();
        this.fileChooser = new JFileChooser(new File("."));
        filter = new SharpFileFilter();
        this.fileChooser.addChoosableFileFilter(filter);
        this.sharp.setTitle(SharpTools.translation.getProperty("Untitled_-_Sharp_Tools_Spreadsheet"));
        this.columnOverflow = false;
        this.table.registerKeyboardAction(this, SharpTools.translation.getProperty("New"), KeyStroke.getKeyStroke(78, 2, false), 0);
        this.table.registerKeyboardAction(this, SharpTools.translation.getProperty("OpenFile"), KeyStroke.getKeyStroke(79, 2, false), 0);
        this.table.registerKeyboardAction(this, SharpTools.translation.getProperty("OpenDb"), KeyStroke.getKeyStroke(68, 2, false), 0);
        this.table.registerKeyboardAction(this, SharpTools.translation.getProperty("Save"), KeyStroke.getKeyStroke(83, 2, false), 0);
        this.table.registerKeyboardAction(this, SharpTools.translation.getProperty("Print"), KeyStroke.getKeyStroke(80, 2, false), 0);
        this.table.registerKeyboardAction(this, SharpTools.translation.getProperty("Exit"), KeyStroke.getKeyStroke(69, 2, false), 0);
    }

    public int queryForSave() {
        String filename = "Untitled";
        if (this.file != null) {
            filename = this.file.getName();
        }
        int choice = SharpOptionPane.showOptionDialog(this.sharp, "Do you want to save the changes you made to \"" + filename + "\"?", "Save", 1, 3, this.saveIcon);
        return choice;
    }

    public void newFile() {
        int choice = this.tableModel.isModified() ? this.queryForSave() : 1;
        switch (choice) {
            case 0: {
                this.saveFile();
            }
            case 1: {
                FileOp fileOp = this;
                Config config = fileOp.sharp.getConfig();
                NewFileDialog dialog = new NewFileDialog(this.sharp, config.getInt("ROWS"), config.getInt("COLUMNS"));
                dialog.setLocationRelativeTo(this.sharp);
                dialog.setVisible(true);
                if (dialog.isCancelled()) {
                    return;
                }
                int row = dialog.getRows();
                int col = dialog.getColumns();
                this.file = null;
                this.sharp.setTitle(SharpTools.translation.getProperty("Untitled_-_Sharp_Tools_Spreadsheet"));
                this.sharp.newTableModel(row, col);
                this.tableModel = this.sharp.getTableModel();
                this.setPasswordValue(this.password);
            }
        }
    }

    public void saveFile() {
        if (this.tableModel.isModified()) {
            if (this.file == null) {
                this.saveAsFile();
            } else {
                this.saveTableModel();
            }
        }
    }

    public void saveAsFile() {
        int choice = this.fileChooser.showSaveDialog(this.sharp);
        if (choice == 0) {
            String path;
            File selectedfile = this.fileChooser.getSelectedFile();
            this.fileChooser = new JFileChooser(selectedfile.getParentFile());
            this.fileChooser.addChoosableFileFilter(filter);
            try {
                path = selectedfile.getCanonicalPath();
            }
            catch (IOException e) {
                this.fileOpError(SharpTools.translation.getProperty("Save"), SharpTools.translation.getProperty("Unexpected_error"));
                return;
            }
            if (!path.endsWith(extname)) {
                selectedfile = new File(path + extname);
            }
            if (selectedfile.exists() && (choice = SharpOptionPane.showOptionDialog(this.sharp, SharpTools.translation.getProperty("File_already_exists") + "  (" + selectedfile.getName() + ")\n\n" + SharpTools.translation.getProperty("Do_you_want_to_overwrite_it"), SharpTools.translation.getProperty("Save"), 0, 2, this.saveIcon, 1)) != 0) {
                return;
            }
            this.saveTableModel(selectedfile);
        }
    }

    public void openFile() {
        int choice = this.tableModel.isModified() ? this.queryForSave() : 1;
        switch (choice) {
            case 0: {
                this.saveFile();
            }
            case 1: {
                int userChoice = this.fileChooser.showOpenDialog(this.sharp);
                if (userChoice != 0) break;
                File selectedfile = this.fileChooser.getSelectedFile();
                this.fileChooser = new JFileChooser(selectedfile.getParentFile());
                this.fileChooser.addChoosableFileFilter(filter);
                this.openTableModel(selectedfile);
            }
        }
    }

    public boolean closeFile() {
        int choice = this.tableModel.isModified() ? this.queryForSave() : 1;
        switch (choice) {
            case 2: {
                return false;
            }
            case 0: {
                this.saveFile();
            }
        }
        return true;
    }

    public void saveTableModel(File aFile) {
        try {
            this.out = new PrintStream(new FileOutputStream(aFile));
            int rowCount = this.tableModel.getRowCount();
            int colCount = this.tableModel.getColumnCount();
            if (this.password != null && this.password.length() > 0) {
                this.out.println("Password: " + this.password);
            }
            this.out.print(this.tableModel.toString());
            this.out.flush();
            this.file = aFile;
            this.tableModel.setPasswordModified(false);
            this.tableModel.setModified(false);
            this.addRecentFile(this.file);
            String title = this.file.getName();
            if (title.endsWith(extname)) {
                title = title.substring(0, title.length() - 4);
            }
            this.sharp.setTitle(title + "   " + SharpTools.translation.getProperty("Sharp_Tools_Spreadsheet"));
        }
        catch (FileNotFoundException e) {
            this.fileOpError(SharpTools.translation.getProperty("Save"), SharpTools.translation.getProperty("File_cannot_be_created") + "  : " + aFile.getName());
        }
        catch (IOException e) {
            this.fileOpError(SharpTools.translation.getProperty("Save"), SharpTools.translation.getProperty("IO_error_in_saving  : " + aFile.getName() + " !"));
        }
    }

    public void saveTableModel() {
        this.saveTableModel(this.file);
    }

    public void openTableModel(File aFile) {
        StringBuffer textBuf = new StringBuffer();
        String password = null;
        try {
            this.in = new BufferedReader(new FileReader(aFile));
            String line = this.in.readLine();
            if (line.indexOf(9) == -1 && line.startsWith("Password: ")) {
                password = line.substring(10);
                if (!this.verifyPassword(password)) {
                    return;
                }
            } else {
                textBuf.append(line);
                textBuf.append("\n");
            }
            while ((line = this.in.readLine()) != null) {
                textBuf.append(line);
                textBuf.append("\n");
            }
            this.setPasswordValue(password);
            String text = textBuf.toString();
            CellPoint size = SharpTableModel.getSize(text);
            this.sharp.newTableModel(size.getRow(), size.getCol());
            this.tableModel = this.sharp.getTableModel();
            this.tableModel.fromString(text, 0, 0, new CellRange(SharpTools.baseRow, size.getRow(), SharpTools.baseCol, size.getCol()));
            this.file = aFile;
            String title = this.file.getName();
            if (title.endsWith(extname)) {
                title = title.substring(0, title.length() - 4);
            }
            this.sharp.setTitle(title + " - " + SharpTools.translation.getProperty("Sharp_Tools_Spreadsheet"));
            this.addRecentFile(this.file);
        }
        catch (FileNotFoundException e) {
            this.fileOpError(SharpTools.translation.getProperty("Open"), SharpTools.translation.getProperty("File_not_found") + " : " + aFile.getName());
        }
        catch (IOException e) {
            this.fileOpError(SharpTools.translation.getProperty("Open"), SharpTools.translation.getProperty("IO_error_in_opening") + " : " + aFile.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getRecentFile(int index) {
        Config config = SharpTools.getConfig();
        return config.get("RECENTFILE" + String.valueOf(index));
    }

    private void setRecentFile(int index, String s) {
        Config config = SharpTools.getConfig();
        config.set("RECENTFILE" + String.valueOf(index), s);
    }

    private void moveToFront(int index) {
        if (index <= 0) {
            return;
        }
        String frontName = this.getRecentFile(index);
        for (int i = index; i > 0; --i) {
            this.setRecentFile(i, this.getRecentFile(i - 1));
        }
        this.setRecentFile(0, frontName);
    }

    private void addRecentFile(File file) {
        try {
            String filename = file.getCanonicalPath();
            int total = SharpTools.getConfig().getInt("RECENTFILELIST");
            for (int i = 0; i < total; ++i) {
                if (!filename.equals(this.getRecentFile(i))) continue;
                this.moveToFront(i);
                return;
            }
            this.setRecentFile(total - 1, filename);
            this.moveToFront(total - 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createRecentFilesMenu(JMenu menu) {
        Config config = SharpTools.getConfig();
        menu.removeAll();
        try {
            for (int i = 0; i < config.getInt("RECENTFILELIST"); ++i) {
                String filename = this.getRecentFile(i);
                if (filename.length() <= 0) continue;
                File file = new File(filename);
                JMenuItem item = new JMenuItem(file.getName(), this.openIcon);
                item.addActionListener(new RecentFileListener(file, this));
                menu.add(item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setPasswordValue(String newPassword) {
        this.password = newPassword;
        this.sharp.checkPasswordState();
    }

    public void printData() {
        FileOp fileOp = this;
        this.columnOverflow = false;
        try {
            PrinterJob prnJob = PrinterJob.getPrinterJob();
            prnJob.setPrintable(fileOp);
            if (!prnJob.printDialog()) {
                return;
            }
            this.maxNumPage = 1;
            prnJob.print();
        }
        catch (PrinterException e) {
            e.printStackTrace();
            this.fileOpError(SharpTools.translation.getProperty("Print"), SharpTools.translation.getProperty("Printing_error") + " : " + e.toString());
        }
    }

    public int print(Graphics pg, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int nCol;
        if (pageIndex >= this.maxNumPage) {
            return 1;
        }
        pg.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        int wPage = 0;
        int hPage = 0;
        if (pageFormat.getOrientation() == 1) {
            wPage = (int)pageFormat.getImageableWidth();
            hPage = (int)pageFormat.getImageableHeight();
            wPage = 550;
            hPage = 950;
        } else {
            wPage = (int)pageFormat.getImageableWidth();
            wPage += wPage / 2;
            hPage = (int)pageFormat.getImageableHeight();
            wPage = 950;
            hPage = 550;
            pg.setClip(0, 0, wPage, hPage);
        }
        int y = 0;
        pg.setColor(Color.black);
        Font fn = pg.getFont().deriveFont(1);
        FontMetrics fm = pg.getFontMetrics();
        y += fm.getAscent();
        if (this.getFile() == null) {
            pg.drawString("Untitled File", 0, y);
        } else {
            pg.drawString(this.getFile().getName(), 0, y);
        }
        y += 20;
        TableColumnModel colModel = this.table.getColumnModel();
        int nColumns = colModel.getColumnCount();
        int[] x = new int[nColumns];
        x[0] = 0;
        int h = fm.getAscent();
        y += h;
        for (nCol = 1; nCol < nColumns; ++nCol) {
            TableColumn tk = colModel.getColumn(nCol);
            int width = tk.getWidth();
            if (x[nCol] + width > wPage) {
                nColumns = nCol;
                if (this.columnOverflow) break;
                this.fileOpError(SharpTools.translation.getProperty("Print"), SharpTools.translation.getProperty("Table_width_exceeds_printed_width"));
                this.columnOverflow = true;
                break;
            }
            if (nCol + 1 < nColumns) {
                x[nCol + 1] = x[nCol] + width;
            }
            String title = (String)tk.getIdentifier();
        }
        pg.setFont(this.table.getFont());
        fm = pg.getFontMetrics();
        int header = y;
        h = fm.getHeight();
        int rowH = Math.max((int)((double)h * 1.5), 10);
        int rowPerPage = (hPage - header) / rowH;
        this.maxNumPage = Math.max((int)Math.ceil((double)this.table.getRowCount() / (double)rowPerPage), 1);
        int iniRow = pageIndex * rowPerPage;
        int endRow = Math.min(this.table.getRowCount(), iniRow + rowPerPage);
        for (int nRow = iniRow + 1; nRow < endRow; ++nRow) {
            y += h;
            for (nCol = 1; nCol < nColumns; ++nCol) {
                int col = this.table.getColumnModel().getColumn(nCol).getModelIndex();
                String str = this.tableModel.getCellAt(nRow, nCol).getValue().toString();
                pg.setColor(Color.black);
                pg.drawString(str, x[nCol], y);
            }
        }
        System.gc();
        return 0;
    }

    public File getFile() {
        return this.file;
    }

    public boolean hasPassword() {
        return this.password != null && this.password.length() > 0;
    }

    public void setPassword() {
        PasswordDialog passwordDialog = new PasswordDialog(this.sharp, null);
        passwordDialog.setVisible(true);
        String text = passwordDialog.getValidatedText();
        if (text != null) {
            this.setPasswordValue(text);
            this.tableModel.setPasswordModified(true);
        }
        this.table.requestFocus();
    }

    private boolean verifyPassword(String password) {
        PasswordDialog passwordDialog = new PasswordDialog(this.sharp, password);
        passwordDialog.pack();
        passwordDialog.setLocationRelativeTo(this.sharp);
        passwordDialog.setVisible(true);
        String text = passwordDialog.getValidatedText();
        this.table.requestFocus();
        return text != null;
    }

    private void fileOpError(String op, String error) {
        SharpOptionPane.showMessageDialog(this.sharp, error, op, 0, null);
        this.table.requestFocus();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().compareTo(SharpTools.translation.getProperty("New")) == 0) {
            this.newFile();
        } else if (e.getActionCommand().compareTo(SharpTools.translation.getProperty("OpenFile")) == 0) {
            this.openFile();
        } else if (e.getActionCommand().compareTo(SharpTools.translation.getProperty("OpenDb")) == 0) {
            this.openDb();
        } else if (e.getActionCommand().compareTo(SharpTools.translation.getProperty("Save")) == 0) {
            this.saveFile();
        } else if (e.getActionCommand().compareTo(SharpTools.translation.getProperty("Print")) == 0) {
            this.printData();
        } else if (e.getActionCommand().compareTo(SharpTools.translation.getProperty("Exit")) == 0) {
            this.sharp.exit();
        }
    }

    public void openDb() {
        int choice = this.tableModel.isModified() ? this.queryForSave() : 1;
        switch (choice) {
            case 0: {
                this.saveFile();
            }
            case 1: {
                Database db = new Database(this.sharp);
                db.connectDb();
            }
        }
    }

    class SharpFileFilter
    extends FileFilter {
        SharpFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().endsWith(FileOp.extname);
        }

        public String getDescription() {
            return SharpTools.translation.getProperty("Sharp_Tools_Spreadsheet");
        }
    }
}

