/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.FunctionListListener;
import SharpTools.SharpOptionPane;
import SharpTools.SharpTools;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class HelpOp {
    public static Properties translation = SharpTools.translation;
    private JEditorPane htmlPane;
    private JScrollPane scrollPane;
    private JFrame frame;
    private Container container;
    private WindowListener exitListener;
    private HyperlinkListener linkListener;
    private URL url;
    static final String message = "<html><font size=3 color=black><p><font size=+1 color=blue><b>Sharp Tools Spreadsheet</b></font> Version 1.41</p><p><p>a product of the Sharp Tools Software Engineering Team<p>Copyright (c) 2000-2002<p><p><font color=green><b>Credits:</b><font></p><ul><li>Hua Zhong</li><li>Ricky Chin</li><li>Daniel Goldberg</li><li>Daniel Medina</li><li>Andrei Scudder</li></ul></p><font color=blue><u><p>http://www.cs.columbia.edu/sharptools/</p><p>mailto:sharp@cs.columbia.edu</p></u></font></font><p>5/2009 Converted into an Applet for WIMS usage";

    public HelpOp(URL url) {
        this.frame = new JFrame("Help Browser: " + url);
        this.container = this.frame.getContentPane();
        this.container.setLayout(new BorderLayout());
        try {
            this.htmlPane = new JEditorPane(url);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.htmlPane.setEditable(false);
        this.linkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                URL newURL = e.getURL();
                if (newURL == null) {
                    return;
                }
                Document currentDocument = HelpOp.this.htmlPane.getDocument();
                try {
                    HelpOp.this.htmlPane.setPage(newURL);
                }
                catch (IOException ex) {
                    HelpOp.this.htmlPane.setDocument(currentDocument);
                }
            }
        };
        this.htmlPane.addHyperlinkListener(this.linkListener);
        this.scrollPane = new JScrollPane(this.htmlPane);
        this.container.add(this.scrollPane);
        this.scrollPane.setPreferredSize(new Dimension(500, 500));
        this.exitListener = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Window window = e.getWindow();
                window.setVisible(false);
                window.dispose();
            }
        };
        this.frame.addWindowListener(this.exitListener);
        this.frame.pack();
        this.frame.show();
    }

    static void showAboutBox(JFrame frame) {
        SharpOptionPane.showMessageDialog(frame, message, translation.getProperty("About_SharpTools"), 1, SharpTools.getImageIcon("images/wims.gif"));
    }

    public static JComponent createFunctionListComponent(JFrame frame, JTable table) {
        JPanel comboxPanel = new JPanel();
        comboxPanel.setLayout(new BorderLayout());
        String[] funcNames = new String[]{translation.getProperty("Functions"), "ABS", "AVERAGE", "COUNT", "E", "INT", "LOG", "MAX", "MEANDEV", "MEDIAN", "MIN", "PI", "RANGE", "ROUND", "SQRT", "SUM", "STDDEV", "SIN", "COS", "TAN", "ASIN", "ACOS", "ATAN"};
        JComboBox<String> funcList = new JComboBox<String>(funcNames);
        Dimension combodim = funcList.getSize();
        funcList.setPreferredSize(new Dimension(100, (int)combodim.getHeight()));
        comboxPanel.add(funcList, "West");
        funcList.addActionListener(new FunctionListListener(frame, table));
        return comboxPanel;
    }
}

