/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.BitmapInfo;
import org.freehep.graphicsio.emf.gdi.BitmapInfoHeader;
import org.freehep.graphicsio.emf.gdi.BlendFunction;
import org.freehep.graphicsio.raw.RawImageWriteParam;
import org.freehep.util.UserProperties;
import org.freehep.util.io.NoCloseOutputStream;

public class AlphaBlend
extends EMFTag
implements EMFConstants {
    public static final int size = 108;
    private Rectangle bounds;
    private int x;
    private int y;
    private int width;
    private int height;
    private BlendFunction dwROP;
    private int xSrc;
    private int ySrc;
    private AffineTransform transform;
    private Color bkg;
    private int usage;
    private BitmapInfo bmi;
    private RenderedImage image;

    public AlphaBlend() {
        super(114, 1);
    }

    public AlphaBlend(Rectangle rectangle, int n2, int n3, int n4, int n5, AffineTransform affineTransform, RenderedImage renderedImage, Color color) {
        this();
        this.bounds = rectangle;
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
        this.dwROP = new BlendFunction(0, 0, 255, 1);
        this.xSrc = 0;
        this.ySrc = 0;
        this.transform = affineTransform;
        this.bkg = color == null ? new Color(0, 0, 0, 0) : color;
        this.usage = 0;
        this.image = renderedImage;
        this.bmi = null;
    }

    public EMFTag read(int n2, EMFInputStream eMFInputStream, int n3) throws IOException {
        AlphaBlend alphaBlend = new AlphaBlend();
        alphaBlend.bounds = eMFInputStream.readRECTL();
        alphaBlend.x = eMFInputStream.readLONG();
        alphaBlend.y = eMFInputStream.readLONG();
        alphaBlend.width = eMFInputStream.readLONG();
        alphaBlend.height = eMFInputStream.readLONG();
        alphaBlend.dwROP = new BlendFunction(eMFInputStream);
        alphaBlend.xSrc = eMFInputStream.readLONG();
        alphaBlend.ySrc = eMFInputStream.readLONG();
        alphaBlend.transform = eMFInputStream.readXFORM();
        alphaBlend.bkg = eMFInputStream.readCOLORREF();
        alphaBlend.usage = eMFInputStream.readDWORD();
        eMFInputStream.readDWORD();
        int n4 = eMFInputStream.readDWORD();
        eMFInputStream.readDWORD();
        int n5 = eMFInputStream.readDWORD();
        eMFInputStream.readLONG();
        eMFInputStream.readLONG();
        this.bmi = n4 > 0 ? new BitmapInfo(eMFInputStream) : null;
        eMFInputStream.readUnsignedByte(n5);
        return alphaBlend;
    }

    public void write(int n2, EMFOutputStream eMFOutputStream) throws IOException {
        eMFOutputStream.writeRECTL(this.bounds);
        eMFOutputStream.writeLONG(this.x);
        eMFOutputStream.writeLONG(this.y);
        eMFOutputStream.writeLONG(this.width);
        eMFOutputStream.writeLONG(this.height);
        this.dwROP.write(eMFOutputStream);
        eMFOutputStream.writeLONG(this.xSrc);
        eMFOutputStream.writeLONG(this.ySrc);
        eMFOutputStream.writeXFORM(this.transform);
        eMFOutputStream.writeCOLORREF(this.bkg);
        eMFOutputStream.writeDWORD(this.usage);
        eMFOutputStream.writeDWORD(108);
        eMFOutputStream.writeDWORD(40);
        eMFOutputStream.writeDWORD(148);
        eMFOutputStream.pushBuffer();
        int n3 = 0;
        UserProperties userProperties = new UserProperties();
        userProperties.setProperty(RawImageWriteParam.BACKGROUND, this.bkg);
        userProperties.setProperty(RawImageWriteParam.CODE, "*BGRA");
        userProperties.setProperty(RawImageWriteParam.PAD, 1);
        ImageGraphics2D.writeImage(this.image, "raw", (Properties)userProperties, (OutputStream)new NoCloseOutputStream(eMFOutputStream));
        int n4 = eMFOutputStream.popBuffer();
        eMFOutputStream.writeDWORD(n4);
        eMFOutputStream.writeLONG(this.image.getWidth());
        eMFOutputStream.writeLONG(this.image.getHeight());
        BitmapInfoHeader bitmapInfoHeader = new BitmapInfoHeader(this.image.getWidth(), this.image.getHeight(), 32, n3, n4, 0, 0, 0, 0);
        this.bmi = new BitmapInfo(bitmapInfoHeader);
        this.bmi.write(eMFOutputStream);
        eMFOutputStream.append();
    }

    public String toString() {
        return super.toString() + "\n" + "  bounds: " + this.bounds + "\n" + "  x, y, w, h: " + this.x + " " + this.y + " " + this.width + " " + this.height + "\n" + "  dwROP: " + this.dwROP + "\n" + "  xSrc, ySrc: " + this.xSrc + " " + this.ySrc + "\n" + "  transform: " + this.transform + "\n" + "  bkg: " + this.bkg + "\n" + "  usage: " + this.usage + "\n" + (this.bmi != null ? this.bmi.toString() : "  bitmap: null");
    }
}

