/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.help;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import rene.gui.Global;
import rene.util.MyVector;
import rene.util.sort.SortObject;
import rene.util.sort.Sorter;
import rene.zirkel.help.Keyword;
import rene.zirkel.help.Topic;

public class Translator {
    BufferedReader in;
    PrintWriter out;
    String line;
    Hashtable Headers;
    Hashtable Keywords;
    Hashtable Aliases;
    Hashtable NextTopic;

    public Translator(String string, String string2) {
        if (string2 != null) {
            Locale.setDefault(new Locale(string2, ""));
        }
        Global.initBundle("rene/zirkel/docs/ZirkelProperties");
        String string3 = Global.name("codepage.help", "default");
        try {
            this.Headers = new Hashtable();
            this.Aliases = new Hashtable();
            this.NextTopic = new Hashtable();
            this.in = string3.equals("default") ? new BufferedReader(new InputStreamReader(new FileInputStream(string))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), string3));
            this.line = this.in.readLine();
            String string4 = "";
            while (this.line != null) {
                if (this.line.startsWith(".")) {
                    String string5 = this.addHeader();
                    if (!string4.equals("") && !string5.equals("")) {
                        this.NextTopic.put(string4, string5);
                    }
                    if (string5.equals("")) continue;
                    string4 = string5;
                    continue;
                }
                this.line = this.in.readLine();
            }
            this.in.close();
            this.Keywords = new Hashtable();
            this.in = string3.equals("default") ? new BufferedReader(new InputStreamReader(new FileInputStream(string))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), string3));
            this.line = this.in.readLine();
            while (this.line != null) {
                if (this.line.startsWith(".")) {
                    this.writeFile();
                    continue;
                }
                this.line = this.in.readLine();
            }
            this.in.close();
            this.writeKeywords();
            this.writeTopics();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String replace(String string, String string2, String string3) {
        if (string != null) {
            int n = string2.length();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = -1;
            int n3 = 0;
            while ((n2 = string.indexOf(string2, n3)) != -1) {
                stringBuffer.append(string.substring(n3, n2));
                stringBuffer.append(string3);
                n3 = n2 + n;
            }
            stringBuffer.append(string.substring(n3));
            return stringBuffer.toString();
        }
        return "";
    }

    public String addHeader() throws IOException {
        Object object;
        String string = this.line.substring(1);
        int n = string.indexOf(" ");
        if (n > 0) {
            object = new StringTokenizer(string.substring(n + 1));
            string = string.substring(0, n);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                this.Aliases.put(string2, string);
            }
        }
        this.line = this.in.readLine();
        while (this.line != null && this.line.startsWith(".related")) {
            this.line = this.in.readLine();
        }
        if (this.line == null) {
            return "";
        }
        object = Translator.replace(this.line, "__", "");
        this.Headers.put(string, object);
        while (this.line != null && !this.line.startsWith(".")) {
            this.line = this.in.readLine();
        }
        return string;
    }

    public void writeFile() throws IOException {
        String string;
        Object object;
        String string2 = this.line.substring(1);
        int n = string2.indexOf(" ");
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        this.out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2 + ".html"), "utf-8"));
        this.writeHeader(this.out);
        this.line = this.in.readLine();
        String string3 = "";
        while (this.line != null && this.line.startsWith(".related")) {
            string3 = string3 + this.line.substring(".related".length());
            this.line = this.in.readLine();
        }
        if (this.line == null) {
            return;
        }
        this.out.println("<h2>" + this.extractKeywords(this.line, string2) + "</h2>");
        this.line = this.in.readLine();
        boolean bl = false;
        boolean bl2 = true;
        while (this.line != null && !this.line.startsWith(".")) {
            if (this.line.trim().equals("")) {
                if (bl) {
                    this.out.println("</p>");
                }
                bl2 = true;
                while (this.line != null && (this.line.trim().equals("") || this.line.startsWith("->") || this.line.startsWith("//image "))) {
                    if (this.line.startsWith("//image ")) {
                        object = this.line.substring("//image ".length());
                        this.out.println("<p align=\"center\"><img src=\"" + (String)object + "\"/></p>");
                    }
                    this.line = this.in.readLine();
                }
                this.out.println("<p>");
                bl = true;
                continue;
            }
            if (this.line.startsWith(" ") && !bl2) {
                this.out.println("<br />");
            } else {
                bl2 = false;
            }
            if (this.line.startsWith("//image+ ")) {
                object = this.line.substring("//image+ ".length());
                this.out.println("<img align=\"right\" src=\"" + (String)object + "\"/>");
            } else if (this.line.startsWith("//image- ")) {
                object = this.line.substring("//image+ ".length());
                this.out.println("<img align=\"left\" src=\"" + (String)object + "\"/>");
            } else {
                this.out.println(this.extractKeywords(this.line.trim(), string2));
            }
            this.line = this.in.readLine();
        }
        if (bl) {
            this.out.println("</p>");
        }
        this.out.println("<p>");
        this.out.print(Global.name("help.related", "Related Topics") + ": ");
        object = new StringTokenizer(string3, " ");
        boolean bl3 = true;
        while (((StringTokenizer)object).hasMoreElements()) {
            string = ((StringTokenizer)object).nextToken();
            String string4 = "";
            try {
                if (this.Headers.get(string) != null) {
                    string4 = (String)this.Headers.get(string);
                } else if (this.Headers.get((String)this.Aliases.get(string)) != null) {
                    string4 = (String)this.Headers.get((String)this.Aliases.get(string));
                }
            }
            catch (Exception exception) {
                System.out.println(string + " missing in " + string2);
            }
            if (!bl3) {
                this.out.println(", ");
            }
            this.out.print("<a href=\"" + string + ".html\">" + string4 + "</a>");
            bl3 = false;
        }
        this.out.println();
        this.out.println("</p>");
        if (this.NextTopic.get(string2) != null) {
            this.out.println("<p>");
            this.out.print(Global.name("help.nexttopic", "NextTopic") + ": ");
            string = (String)this.NextTopic.get(string2);
            this.out.println("<a href=\"" + string + ".html\">" + (String)this.Headers.get(string) + "</a>");
            this.out.println("</p>");
        }
        this.writeFooter(this.out);
        this.out.close();
    }

    public String extractKeywords(String string, String string2) {
        string = string.replace('\u00df', ' ');
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("<", "&lt;");
        String string3 = "";
        int n = string.indexOf("__");
        if (n < 0) {
            return string;
        }
        while (n >= 0) {
            string3 = string3 + string.substring(0, n) + "<b>";
            if ((n = (string = string.substring(n + 2)).indexOf("__")) < 0) {
                return string3 + string + "</b>";
            }
            String string4 = string.substring(0, n);
            this.addKeyword(string4, string2);
            string3 = string3 + string4 + "</b>";
            string = string.substring(n + 2);
            n = string.indexOf("__");
        }
        return string3 + string;
    }

    public void addKeyword(String string, String string2) {
        if (this.Keywords.get(string.toLowerCase()) == null) {
            Keyword keyword = new Keyword(string);
            keyword.addTopic(string2);
            this.Keywords.put(string.toLowerCase(), keyword);
        } else {
            Keyword keyword = (Keyword)this.Keywords.get(string.toLowerCase());
            keyword.addTopic(string2);
        }
    }

    public void writeKeywords() throws IOException {
        Object[] objectArray;
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("keywords.html"), "utf-8"));
        this.writeHeader(printWriter);
        Enumeration enumeration = this.Keywords.elements();
        MyVector myVector = new MyVector();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            myVector.addElement(objectArray);
        }
        objectArray = new Keyword[myVector.size()];
        myVector.copyInto(objectArray);
        Sorter.sort((SortObject[])objectArray, myVector.size());
        printWriter.println("<p>");
        char c2 = '\u0000';
        for (int i = 0; i < objectArray.length; ++i) {
            char c3 = Character.toUpperCase(((Keyword)objectArray[i]).K.charAt(0));
            if (c3 != c2) {
                c2 = c3;
                printWriter.println("</p>");
                printWriter.println("<p><b>" + c2 + "</b></p>");
                printWriter.println("<p>");
            }
            String string = ((Keyword)objectArray[i]).K;
            string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
            printWriter.print(string);
            for (int j = 0; j < ((Keyword)objectArray[i]).V.size(); ++j) {
                String string2 = (String)((Keyword)objectArray[i]).V.elementAt(j);
                if (j == 0) {
                    printWriter.print(": ");
                } else {
                    printWriter.print(", ");
                }
                printWriter.print("<a href=\"" + string2 + ".html\">" + (String)this.Headers.get(string2) + "</a>");
            }
            printWriter.print("<br />");
        }
        printWriter.println("</p>");
        this.writeFooter(printWriter);
        printWriter.close();
    }

    public void writeTopics() throws IOException {
        Object[] objectArray;
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("topics.html"), "utf-8"));
        this.writeHeader(printWriter);
        printWriter.println("<p>");
        Enumeration enumeration = this.Headers.keys();
        MyVector myVector = new MyVector();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (this.Headers.get(objectArray) == null) continue;
            myVector.addElement(new Topic((String)objectArray, (String)this.Headers.get(objectArray)));
        }
        objectArray = new Topic[myVector.size()];
        myVector.copyInto(objectArray);
        Sorter.sort((SortObject[])objectArray, myVector.size());
        for (int i = 0; i < objectArray.length; ++i) {
            printWriter.println("<a href=\"" + ((Topic)objectArray[i]).T + ".html\">" + ((Topic)objectArray[i]).D + "</a><br />");
        }
        printWriter.println("</p>");
        this.writeFooter(printWriter);
        printWriter.close();
    }

    public void writeHeader(PrintWriter printWriter) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("header.dat"), "UTF-8"));
        this.copy(bufferedReader, printWriter);
        bufferedReader.close();
    }

    public void writeFooter(PrintWriter printWriter) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("footer.dat"), "UTF-8"));
        this.copy(bufferedReader, printWriter);
        bufferedReader.close();
    }

    public void copy(BufferedReader bufferedReader, PrintWriter printWriter) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            printWriter.println(string);
        }
        return;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("usage: java -cp zirkel.jar rene.helptohtmt.Translator source language");
        } else {
            new Translator(stringArray[0], stringArray[1]);
        }
    }
}

