/*
 * dlls/rsaenh/des.c
 * DES functions
 *
 * Copyright 2004 Michael Jung
 * Based on public domain code by Tom St Denis (tomstdenis@iahu.ca)
 * and Dobes Vandermeer.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public 
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

/*
 * This file contains code from the LibTomCrypt cryptographic 
 * library written by Tom St Denis (tomstdenis@iahu.ca). LibTomCrypt
 * is in the public domain. The code in this file is tailored to
 * special requirements. Take a look at http://libtomcrypt.org for the
 * original version. 
 */

#include "tomcrypt.h"

#define EN0 0 
#define DE1 1

static const ulong32 bytebit[8] =
{
    0200, 0100, 040, 020, 010, 04, 02, 01 
};

static const ulong32 bigbyte[24] =
{
    0x800000UL,  0x400000UL,  0x200000UL,  0x100000UL,
    0x80000UL,   0x40000UL,   0x20000UL,   0x10000UL,
    0x8000UL,    0x4000UL,    0x2000UL,    0x1000UL,
    0x800UL,     0x400UL,     0x200UL,     0x100UL,
    0x80UL,      0x40UL,      0x20UL,      0x10UL,
    0x8UL,       0x4UL,       0x2UL,       0x1L 
};

/* Use the key schedule specific in the standard (ANSI X3.92-1981) */

static const unsigned char pc1[56] = {
    56, 48, 40, 32, 24, 16,  8,  0, 57, 49, 41, 33, 25, 17,  
     9,  1, 58, 50, 42, 34, 26, 18, 10,  2, 59, 51, 43, 35, 
    62, 54, 46, 38, 30, 22, 14,  6, 61, 53, 45, 37, 29, 21,
    13,  5, 60, 52, 44, 36, 28, 20, 12,  4, 27, 19, 11,  3 
};

static const unsigned char totrot[16] = {
    1,   2,  4,  6,
    8,  10, 12, 14, 
    15, 17, 19, 21, 
    23, 25, 27, 28
};

static const unsigned char pc2[48] = {
    13, 16, 10, 23,  0,  4,      2, 27, 14,  5, 20,  9,
    22, 18, 11,  3, 25,  7,     15,  6, 26, 19, 12,  1,
    40, 51, 30, 36, 46, 54,     29, 39, 50, 44, 32, 47,
    43, 48, 38, 55, 33, 52,     45, 41, 49, 35, 28, 31
};


static const ulong32 SP1[64] =
{
    0x01010400UL, 0x00000000UL, 0x00010000UL, 0x01010404UL,
    0x01010004UL, 0x00010404UL, 0x00000004UL, 0x00010000UL,
    0x00000400UL, 0x01010400UL, 0x01010404UL, 0x00000400UL,
    0x01000404UL, 0x01010004UL, 0x01000000UL, 0x00000004UL,
    0x00000404UL, 0x01000400UL, 0x01000400UL, 0x00010400UL,
    0x00010400UL, 0x01010000UL, 0x01010000UL, 0x01000404UL,
    0x00010004UL, 0x01000004UL, 0x01000004UL, 0x00010004UL,
    0x00000000UL, 0x00000404UL, 0x00010404UL, 0x01000000UL,
    0x00010000UL, 0x01010404UL, 0x00000004UL, 0x01010000UL,
    0x01010400UL, 0x01000000UL, 0x01000000UL, 0x00000400UL,
    0x01010004UL, 0x00010000UL, 0x00010400UL, 0x01000004UL,
    0x00000400UL, 0x00000004UL, 0x01000404UL, 0x00010404UL,
    0x01010404UL, 0x00010004UL, 0x01010000UL, 0x01000404UL,
    0x01000004UL, 0x00000404UL, 0x00010404UL, 0x01010400UL,
    0x00000404UL, 0x01000400UL, 0x01000400UL, 0x00000000UL,
    0x00010004UL, 0x00010400UL, 0x00000000UL, 0x01010004UL
};

static const ulong32 SP2[64] =
{
    0x80108020UL, 0x80008000UL, 0x00008000UL, 0x00108020UL,
    0x00100000UL, 0x00000020UL, 0x80100020UL, 0x80008020UL,
    0x80000020UL, 0x80108020UL, 0x80108000UL, 0x80000000UL,
    0x80008000UL, 0x00100000UL, 0x00000020UL, 0x80100020UL,
    0x00108000UL, 0x00100020UL, 0x80008020UL, 0x00000000UL,
    0x80000000UL, 0x00008000UL, 0x00108020UL, 0x80100000UL,
    0x00100020UL, 0x80000020UL, 0x00000000UL, 0x00108000UL,
    0x00008020UL, 0x80108000UL, 0x80100000UL, 0x00008020UL,
    0x00000000UL, 0x00108020UL, 0x80100020UL, 0x00100000UL,
    0x80008020UL, 0x80100000UL, 0x80108000UL, 0x00008000UL,
    0x80100000UL, 0x80008000UL, 0x00000020UL, 0x80108020UL,
    0x00108020UL, 0x00000020UL, 0x00008000UL, 0x80000000UL,
    0x00008020UL, 0x80108000UL, 0x00100000UL, 0x80000020UL,
    0x00100020UL, 0x80008020UL, 0x80000020UL, 0x00100020UL,
    0x00108000UL, 0x00000000UL, 0x80008000UL, 0x00008020UL,
    0x80000000UL, 0x80100020UL, 0x80108020UL, 0x00108000UL
};

static const ulong32 SP3[64] =
{
    0x00000208UL, 0x08020200UL, 0x00000000UL, 0x08020008UL,
    0x08000200UL, 0x00000000UL, 0x00020208UL, 0x08000200UL,
    0x00020008UL, 0x08000008UL, 0x08000008UL, 0x00020000UL,
    0x08020208UL, 0x00020008UL, 0x08020000UL, 0x00000208UL,
    0x08000000UL, 0x00000008UL, 0x08020200UL, 0x00000200UL,
    0x00020200UL, 0x08020000UL, 0x08020008UL, 0x00020208UL,
    0x08000208UL, 0x00020200UL, 0x00020000UL, 0x08000208UL,
    0x00000008UL, 0x08020208UL, 0x00000200UL, 0x08000000UL,
    0x08020200UL, 0x08000000UL, 0x00020008UL, 0x00000208UL,
    0x00020000UL, 0x08020200UL, 0x08000200UL, 0x00000000UL,
    0x00000200UL, 0x00020008UL, 0x08020208UL, 0x08000200UL,
    0x08000008UL, 0x00000200UL, 0x00000000UL, 0x08020008UL,
    0x08000208UL, 0x00020000UL, 0x08000000UL, 0x08020208UL,
    0x00000008UL, 0x00020208UL, 0x00020200UL, 0x08000008UL,
    0x08020000UL, 0x08000208UL, 0x00000208UL, 0x08020000UL,
    0x00020208UL, 0x00000008UL, 0x08020008UL, 0x00020200UL
};

static const ulong32 SP4[64] =
{
    0x00802001UL, 0x00002081UL, 0x00002081UL, 0x00000080UL,
    0x00802080UL, 0x00800081UL, 0x00800001UL, 0x00002001UL,
    0x00000000UL, 0x00802000UL, 0x00802000UL, 0x00802081UL,
    0x00000081UL, 0x00000000UL, 0x00800080UL, 0x00800001UL,
    0x00000001UL, 0x00002000UL, 0x00800000UL, 0x00802001UL,
    0x00000080UL, 0x00800000UL, 0x00002001UL, 0x00002080UL,
    0x00800081UL, 0x00000001UL, 0x00002080UL, 0x00800080UL,
    0x00002000UL, 0x00802080UL, 0x00802081UL, 0x00000081UL,
    0x00800080UL, 0x00800001UL, 0x00802000UL, 0x00802081UL,
    0x00000081UL, 0x00000000UL, 0x00000000UL, 0x00802000UL,
    0x00002080UL, 0x00800080UL, 0x00800081UL, 0x00000001UL,
    0x00802001UL, 0x00002081UL, 0x00002081UL, 0x00000080UL,
    0x00802081UL, 0x00000081UL, 0x00000001UL, 0x00002000UL,
    0x00800001UL, 0x00002001UL, 0x00802080UL, 0x00800081UL,
    0x00002001UL, 0x00002080UL, 0x00800000UL, 0x00802001UL,
    0x00000080UL, 0x00800000UL, 0x00002000UL, 0x00802080UL
};

static const ulong32 SP5[64] =
{
    0x00000100UL, 0x02080100UL, 0x02080000UL, 0x42000100UL,
    0x00080000UL, 0x00000100UL, 0x40000000UL, 0x02080000UL,
    0x40080100UL, 0x00080000UL, 0x02000100UL, 0x40080100UL,
    0x42000100UL, 0x42080000UL, 0x00080100UL, 0x40000000UL,
    0x02000000UL, 0x40080000UL, 0x40080000UL, 0x00000000UL,
    0x40000100UL, 0x42080100UL, 0x42080100UL, 0x02000100UL,
    0x42080000UL, 0x40000100UL, 0x00000000UL, 0x42000000UL,
    0x02080100UL, 0x02000000UL, 0x42000000UL, 0x00080100UL,
    0x00080000UL, 0x42000100UL, 0x00000100UL, 0x02000000UL,
    0x40000000UL, 0x02080000UL, 0x42000100UL, 0x40080100UL,
    0x02000100UL, 0x40000000UL, 0x42080000UL, 0x02080100UL,
    0x40080100UL, 0x00000100UL, 0x02000000UL, 0x42080000UL,
    0x42080100UL, 0x00080100UL, 0x42000000UL, 0x42080100UL,
    0x02080000UL, 0x00000000UL, 0x40080000UL, 0x42000000UL,
    0x00080100UL, 0x02000100UL, 0x40000100UL, 0x00080000UL,
    0x00000000UL, 0x40080000UL, 0x02080100UL, 0x40000100UL
};

static const ulong32 SP6[64] =
{
    0x20000010UL, 0x20400000UL, 0x00004000UL, 0x20404010UL,
    0x20400000UL, 0x00000010UL, 0x20404010UL, 0x00400000UL,
    0x20004000UL, 0x00404010UL, 0x00400000UL, 0x20000010UL,
    0x00400010UL, 0x20004000UL, 0x20000000UL, 0x00004010UL,
    0x00000000UL, 0x00400010UL, 0x20004010UL, 0x00004000UL,
    0x00404000UL, 0x20004010UL, 0x00000010UL, 0x20400010UL,
    0x20400010UL, 0x00000000UL, 0x00404010UL, 0x20404000UL,
    0x00004010UL, 0x00404000UL, 0x20404000UL, 0x20000000UL,
    0x20004000UL, 0x00000010UL, 0x20400010UL, 0x00404000UL,
    0x20404010UL, 0x00400000UL, 0x00004010UL, 0x20000010UL,
    0x00400000UL, 0x20004000UL, 0x20000000UL, 0x00004010UL,
    0x20000010UL, 0x20404010UL, 0x00404000UL, 0x20400000UL,
    0x00404010UL, 0x20404000UL, 0x00000000UL, 0x20400010UL,
    0x00000010UL, 0x00004000UL, 0x20400000UL, 0x00404010UL,
    0x00004000UL, 0x00400010UL, 0x20004010UL, 0x00000000UL,
    0x20404000UL, 0x20000000UL, 0x00400010UL, 0x20004010UL
};

static const ulong32 SP7[64] =
{
    0x00200000UL, 0x04200002UL, 0x04000802UL, 0x00000000UL,
    0x00000800UL, 0x04000802UL, 0x00200802UL, 0x04200800UL,
    0x04200802UL, 0x00200000UL, 0x00000000UL, 0x04000002UL,
    0x00000002UL, 0x04000000UL, 0x04200002UL, 0x00000802UL,
    0x04000800UL, 0x00200802UL, 0x00200002UL, 0x04000800UL,
    0x04000002UL, 0x04200000UL, 0x04200800UL, 0x00200002UL,
    0x04200000UL, 0x00000800UL, 0x00000802UL, 0x04200802UL,
    0x00200800UL, 0x00000002UL, 0x04000000UL, 0x00200800UL,
    0x04000000UL, 0x00200800UL, 0x00200000UL, 0x04000802UL,
    0x04000802UL, 0x04200002UL, 0x04200002UL, 0x00000002UL,
    0x00200002UL, 0x04000000UL, 0x04000800UL, 0x00200000UL,
    0x04200800UL, 0x00000802UL, 0x00200802UL, 0x04200800UL,
    0x00000802UL, 0x04000002UL, 0x04200802UL, 0x04200000UL,
    0x00200800UL, 0x00000000UL, 0x00000002UL, 0x04200802UL,
    0x00000000UL, 0x00200802UL, 0x04200000UL, 0x00000800UL,
    0x04000002UL, 0x04000800UL, 0x00000800UL, 0x00200002UL
};

static const ulong32 SP8[64] =
{
    0x10001040UL, 0x00001000UL, 0x00040000UL, 0x10041040UL,
    0x10000000UL, 0x10001040UL, 0x00000040UL, 0x10000000UL,
    0x00040040UL, 0x10040000UL, 0x10041040UL, 0x00041000UL,
    0x10041000UL, 0x00041040UL, 0x00001000UL, 0x00000040UL,
    0x10040000UL, 0x10000040UL, 0x10001000UL, 0x00001040UL,
    0x00041000UL, 0x00040040UL, 0x10040040UL, 0x10041000UL,
    0x00001040UL, 0x00000000UL, 0x00000000UL, 0x10040040UL,
    0x10000040UL, 0x10001000UL, 0x00041040UL, 0x00040000UL,
    0x00041040UL, 0x00040000UL, 0x10041000UL, 0x00001000UL,
    0x00000040UL, 0x10040040UL, 0x00001000UL, 0x00041040UL,
    0x10001000UL, 0x00000040UL, 0x10000040UL, 0x10040000UL,
    0x10040040UL, 0x10000000UL, 0x00040000UL, 0x10001040UL,
    0x00000000UL, 0x10041040UL, 0x00040040UL, 0x10000040UL,
    0x10040000UL, 0x10001000UL, 0x10001040UL, 0x00000000UL,
    0x10041040UL, 0x00041000UL, 0x00041000UL, 0x00001040UL,
    0x00001040UL, 0x00040040UL, 0x10000000UL, 0x10041000UL
};

static const ulong64 des_ip[8][256] = {

{ CONST64(0x00000000,0x00000000), CONST64(0x00000010,0x00000000), CONST64(0x00000000,0x00000010), CONST64(0x00000010,0x00000010),
  CONST64(0x00001000,0x00000000), CONST64(0x00001010,0x00000000), CONST64(0x00001000,0x00000010), CONST64(0x00001010,0x00000010),
  CONST64(0x00000000,0x00001000), CONST64(0x00000010,0x00001000), CONST64(0x00000000,0x00001010), CONST64(0x00000010,0x00001010),
  CONST64(0x00001000,0x00001000), CONST64(0x00001010,0x00001000), CONST64(0x00001000,0x00001010), CONST64(0x00001010,0x00001010),
  CONST64(0x00100000,0x00000000), CONST64(0x00100010,0x00000000), CONST64(0x00100000,0x00000010), CONST64(0x00100010,0x00000010),
  CONST64(0x00101000,0x00000000), CONST64(0x00101010,0x00000000), CONST64(0x00101000,0x00000010), CONST64(0x00101010,0x00000010),
  CONST64(0x00100000,0x00001000), CONST64(0x00100010,0x00001000), CONST64(0x00100000,0x00001010), CONST64(0x00100010,0x00001010),
  CONST64(0x00101000,0x00001000), CONST64(0x00101010,0x00001000), CONST64(0x00101000,0x00001010), CONST64(0x00101010,0x00001010),
  CONST64(0x00000000,0x00100000), CONST64(0x00000010,0x00100000), CONST64(0x00000000,0x00100010), CONST64(0x00000010,0x00100010),
  CONST64(0x00001000,0x00100000), CONST64(0x00001010,0x00100000), CONST64(0x00001000,0x00100010), CONST64(0x00001010,0x00100010),
  CONST64(0x00000000,0x00101000), CONST64(0x00000010,0x00101000), CONST64(0x00000000,0x00101010), CONST64(0x00000010,0x00101010),
  CONST64(0x00001000,0x00101000), CONST64(0x00001010,0x00101000), CONST64(0x00001000,0x00101010), CONST64(0x00001010,0x00101010),
  CONST64(0x00100000,0x00100000), CONST64(0x00100010,0x00100000), CONST64(0x00100000,0x00100010), CONST64(0x00100010,0x00100010),
  CONST64(0x00101000,0x00100000), CONST64(0x00101010,0x00100000), CONST64(0x00101000,0x00100010), CONST64(0x00101010,0x00100010),
  CONST64(0x00100000,0x00101000), CONST64(0x00100010,0x00101000), CONST64(0x00100000,0x00101010), CONST64(0x00100010,0x00101010),
  CONST64(0x00101000,0x00101000), CONST64(0x00101010,0x00101000), CONST64(0x00101000,0x00101010), CONST64(0x00101010,0x00101010),
  CONST64(0x10000000,0x00000000), CONST64(0x10000010,0x00000000), CONST64(0x10000000,0x00000010), CONST64(0x10000010,0x00000010),
  CONST64(0x10001000,0x00000000), CONST64(0x10001010,0x00000000), CONST64(0x10001000,0x00000010), CONST64(0x10001010,0x00000010),
  CONST64(0x10000000,0x00001000), CONST64(0x10000010,0x00001000), CONST64(0x10000000,0x00001010), CONST64(0x10000010,0x00001010),
  CONST64(0x10001000,0x00001000), CONST64(0x10001010,0x00001000), CONST64(0x10001000,0x00001010), CONST64(0x10001010,0x00001010),
  CONST64(0x10100000,0x00000000), CONST64(0x10100010,0x00000000), CONST64(0x10100000,0x00000010), CONST64(0x10100010,0x00000010),
  CONST64(0x10101000,0x00000000), CONST64(0x10101010,0x00000000), CONST64(0x10101000,0x00000010), CONST64(0x10101010,0x00000010),
  CONST64(0x10100000,0x00001000), CONST64(0x10100010,0x00001000), CONST64(0x10100000,0x00001010), CONST64(0x10100010,0x00001010),
  CONST64(0x10101000,0x00001000), CONST64(0x10101010,0x00001000), CONST64(0x10101000,0x00001010), CONST64(0x10101010,0x00001010),
  CONST64(0x10000000,0x00100000), CONST64(0x10000010,0x00100000), CONST64(0x10000000,0x00100010), CONST64(0x10000010,0x00100010),
  CONST64(0x10001000,0x00100000), CONST64(0x10001010,0x00100000), CONST64(0x10001000,0x00100010), CONST64(0x10001010,0x00100010),
  CONST64(0x10000000,0x00101000), CONST64(0x10000010,0x00101000), CONST64(0x10000000,0x00101010), CONST64(0x10000010,0x00101010),
  CONST64(0x10001000,0x00101000), CONST64(0x10001010,0x00101000), CONST64(0x10001000,0x00101010), CONST64(0x10001010,0x00101010),
  CONST64(0x10100000,0x00100000), CONST64(0x10100010,0x00100000), CONST64(0x10100000,0x00100010), CONST64(0x10100010,0x00100010),
  CONST64(0x10101000,0x00100000), CONST64(0x10101010,0x00100000), CONST64(0x10101000,0x00100010), CONST64(0x10101010,0x00100010),
  CONST64(0x10100000,0x00101000), CONST64(0x10100010,0x00101000), CONST64(0x10100000,0x00101010), CONST64(0x10100010,0x00101010),
  CONST64(0x10101000,0x00101000), CONST64(0x10101010,0x00101000), CONST64(0x10101000,0x00101010), CONST64(0x10101010,0x00101010),
  CONST64(0x00000000,0x10000000), CONST64(0x00000010,0x10000000), CONST64(0x00000000,0x10000010), CONST64(0x00000010,0x10000010),
  CONST64(0x00001000,0x10000000), CONST64(0x00001010,0x10000000), CONST64(0x00001000,0x10000010), CONST64(0x00001010,0x10000010),
  CONST64(0x00000000,0x10001000), CONST64(0x00000010,0x10001000), CONST64(0x00000000,0x10001010), CONST64(0x00000010,0x10001010),
  CONST64(0x00001000,0x10001000), CONST64(0x00001010,0x10001000), CONST64(0x00001000,0x10001010), CONST64(0x00001010,0x10001010),
  CONST64(0x00100000,0x10000000), CONST64(0x00100010,0x10000000), CONST64(0x00100000,0x10000010), CONST64(0x00100010,0x10000010),
  CONST64(0x00101000,0x10000000), CONST64(0x00101010,0x10000000), CONST64(0x00101000,0x10000010), CONST64(0x00101010,0x10000010),
  CONST64(0x00100000,0x10001000), CONST64(0x00100010,0x10001000), CONST64(0x00100000,0x10001010), CONST64(0x00100010,0x10001010),
  CONST64(0x00101000,0x10001000), CONST64(0x00101010,0x10001000), CONST64(0x00101000,0x10001010), CONST64(0x00101010,0x10001010),
  CONST64(0x00000000,0x10100000), CONST64(0x00000010,0x10100000), CONST64(0x00000000,0x10100010), CONST64(0x00000010,0x10100010),
  CONST64(0x00001000,0x10100000), CONST64(0x00001010,0x10100000), CONST64(0x00001000,0x10100010), CONST64(0x00001010,0x10100010),
  CONST64(0x00000000,0x10101000), CONST64(0x00000010,0x10101000), CONST64(0x00000000,0x10101010), CONST64(0x00000010,0x10101010),
  CONST64(0x00001000,0x10101000), CONST64(0x00001010,0x10101000), CONST64(0x00001000,0x10101010), CONST64(0x00001010,0x10101010),
  CONST64(0x00100000,0x10100000), CONST64(0x00100010,0x10100000), CONST64(0x00100000,0x10100010), CONST64(0x00100010,0x10100010),
  CONST64(0x00101000,0x10100000), CONST64(0x00101010,0x10100000), CONST64(0x00101000,0x10100010), CONST64(0x00101010,0x10100010),
  CONST64(0x00100000,0x10101000), CONST64(0x00100010,0x10101000), CONST64(0x00100000,0x10101010), CONST64(0x00100010,0x10101010),
  CONST64(0x00101000,0x10101000), CONST64(0x00101010,0x10101000), CONST64(0x00101000,0x10101010), CONST64(0x00101010,0x10101010),
  CONST64(0x10000000,0x10000000), CONST64(0x10000010,0x10000000), CONST64(0x10000000,0x10000010), CONST64(0x10000010,0x10000010),
  CONST64(0x10001000,0x10000000), CONST64(0x10001010,0x10000000), CONST64(0x10001000,0x10000010), CONST64(0x10001010,0x10000010),
  CONST64(0x10000000,0x10001000), CONST64(0x10000010,0x10001000), CONST64(0x10000000,0x10001010), CONST64(0x10000010,0x10001010),
  CONST64(0x10001000,0x10001000), CONST64(0x10001010,0x10001000), CONST64(0x10001000,0x10001010), CONST64(0x10001010,0x10001010),
  CONST64(0x10100000,0x10000000), CONST64(0x10100010,0x10000000), CONST64(0x10100000,0x10000010), CONST64(0x10100010,0x10000010),
  CONST64(0x10101000,0x10000000), CONST64(0x10101010,0x10000000), CONST64(0x10101000,0x10000010), CONST64(0x10101010,0x10000010),
  CONST64(0x10100000,0x10001000), CONST64(0x10100010,0x10001000), CONST64(0x10100000,0x10001010), CONST64(0x10100010,0x10001010),
  CONST64(0x10101000,0x10001000), CONST64(0x10101010,0x10001000), CONST64(0x10101000,0x10001010), CONST64(0x10101010,0x10001010),
  CONST64(0x10000000,0x10100000), CONST64(0x10000010,0x10100000), CONST64(0x10000000,0x10100010), CONST64(0x10000010,0x10100010),
  CONST64(0x10001000,0x10100000), CONST64(0x10001010,0x10100000), CONST64(0x10001000,0x10100010), CONST64(0x10001010,0x10100010),
  CONST64(0x10000000,0x10101000), CONST64(0x10000010,0x10101000), CONST64(0x10000000,0x10101010), CONST64(0x10000010,0x10101010),
  CONST64(0x10001000,0x10101000), CONST64(0x10001010,0x10101000), CONST64(0x10001000,0x10101010), CONST64(0x10001010,0x10101010),
  CONST64(0x10100000,0x10100000), CONST64(0x10100010,0x10100000), CONST64(0x10100000,0x10100010), CONST64(0x10100010,0x10100010),
  CONST64(0x10101000,0x10100000), CONST64(0x10101010,0x10100000), CONST64(0x10101000,0x10100010), CONST64(0x10101010,0x10100010),
  CONST64(0x10100000,0x10101000), CONST64(0x10100010,0x10101000), CONST64(0x10100000,0x10101010), CONST64(0x10100010,0x10101010),
  CONST64(0x10101000,0x10101000), CONST64(0x10101010,0x10101000), CONST64(0x10101000,0x10101010), CONST64(0x10101010,0x10101010)
  },
{ CONST64(0x00000000,0x00000000), CONST64(0x00000008,0x00000000), CONST64(0x00000000,0x00000008), CONST64(0x00000008,0x00000008),
  CONST64(0x00000800,0x00000000), CONST64(0x00000808,0x00000000), CONST64(0x00000800,0x00000008), CONST64(0x00000808,0x00000008),
  CONST64(0x00000000,0x00000800), CONST64(0x00000008,0x00000800), CONST64(0x00000000,0x00000808), CONST64(0x00000008,0x00000808),
  CONST64(0x00000800,0x00000800), CONST64(0x00000808,0x00000800), CONST64(0x00000800,0x00000808), CONST64(0x00000808,0x00000808),
  CONST64(0x00080000,0x00000000), CONST64(0x00080008,0x00000000), CONST64(0x00080000,0x00000008), CONST64(0x00080008,0x00000008),
  CONST64(0x00080800,0x00000000), CONST64(0x00080808,0x00000000), CONST64(0x00080800,0x00000008), CONST64(0x00080808,0x00000008),
  CONST64(0x00080000,0x00000800), CONST64(0x00080008,0x00000800), CONST64(0x00080000,0x00000808), CONST64(0x00080008,0x00000808),
  CONST64(0x00080800,0x00000800), CONST64(0x00080808,0x00000800), CONST64(0x00080800,0x00000808), CONST64(0x00080808,0x00000808),
  CONST64(0x00000000,0x00080000), CONST64(0x00000008,0x00080000), CONST64(0x00000000,0x00080008), CONST64(0x00000008,0x00080008),
  CONST64(0x00000800,0x00080000), CONST64(0x00000808,0x00080000), CONST64(0x00000800,0x00080008), CONST64(0x00000808,0x00080008),
  CONST64(0x00000000,0x00080800), CONST64(0x00000008,0x00080800), CONST64(0x00000000,0x00080808), CONST64(0x00000008,0x00080808),
  CONST64(0x00000800,0x00080800), CONST64(0x00000808,0x00080800), CONST64(0x00000800,0x00080808), CONST64(0x00000808,0x00080808),
  CONST64(0x00080000,0x00080000), CONST64(0x00080008,0x00080000), CONST64(0x00080000,0x00080008), CONST64(0x00080008,0x00080008),
  CONST64(0x00080800,0x00080000), CONST64(0x00080808,0x00080000), CONST64(0x00080800,0x00080008), CONST64(0x00080808,0x00080008),
  CONST64(0x00080000,0x00080800), CONST64(0x00080008,0x00080800), CONST64(0x00080000,0x00080808), CONST64(0x00080008,0x00080808),
  CONST64(0x00080800,0x00080800), CONST64(0x00080808,0x00080800), CONST64(0x00080800,0x00080808), CONST64(0x00080808,0x00080808),
  CONST64(0x08000000,0x00000000), CONST64(0x08000008,0x00000000), CONST64(0x08000000,0x00000008), CONST64(0x08000008,0x00000008),
  CONST64(0x08000800,0x00000000), CONST64(0x08000808,0x00000000), CONST64(0x08000800,0x00000008), CONST64(0x08000808,0x00000008),
  CONST64(0x08000000,0x00000800), CONST64(0x08000008,0x00000800), CONST64(0x08000000,0x00000808), CONST64(0x08000008,0x00000808),
  CONST64(0x08000800,0x00000800), CONST64(0x08000808,0x00000800), CONST64(0x08000800,0x00000808), CONST64(0x08000808,0x00000808),
  CONST64(0x08080000,0x00000000), CONST64(0x08080008,0x00000000), CONST64(0x08080000,0x00000008), CONST64(0x08080008,0x00000008),
  CONST64(0x08080800,0x00000000), CONST64(0x08080808,0x00000000), CONST64(0x08080800,0x00000008), CONST64(0x08080808,0x00000008),
  CONST64(0x08080000,0x00000800), CONST64(0x08080008,0x00000800), CONST64(0x08080000,0x00000808), CONST64(0x08080008,0x00000808),
  CONST64(0x08080800,0x00000800), CONST64(0x08080808,0x00000800), CONST64(0x08080800,0x00000808), CONST64(0x08080808,0x00000808),
  CONST64(0x08000000,0x00080000), CONST64(0x08000008,0x00080000), CONST64(0x08000000,0x00080008), CONST64(0x08000008,0x00080008),
  CONST64(0x08000800,0x00080000), CONST64(0x08000808,0x00080000), CONST64(0x08000800,0x00080008), CONST64(0x08000808,0x00080008),
  CONST64(0x08000000,0x00080800), CONST64(0x08000008,0x00080800), CONST64(0x08000000,0x00080808), CONST64(0x08000008,0x00080808),
  CONST64(0x08000800,0x00080800), CONST64(0x08000808,0x00080800), CONST64(0x08000800,0x00080808), CONST64(0x08000808,0x00080808),
  CONST64(0x08080000,0x00080000), CONST64(0x08080008,0x00080000), CONST64(0x08080000,0x00080008), CONST64(0x08080008,0x00080008),
  CONST64(0x08080800,0x00080000), CONST64(0x08080808,0x00080000), CONST64(0x08080800,0x00080008), CONST64(0x08080808,0x00080008),
  CONST64(0x08080000,0x00080800), CONST64(0x08080008,0x00080800), CONST64(0x08080000,0x00080808), CONST64(0x08080008,0x00080808),
  CONST64(0x08080800,0x00080800), CONST64(0x08080808,0x00080800), CONST64(0x08080800,0x00080808), CONST64(0x08080808,0x00080808),
  CONST64(0x00000000,0x08000000), CONST64(0x00000008,0x08000000), CONST64(0x00000000,0x08000008), CONST64(0x00000008,0x08000008),
  CONST64(0x00000800,0x08000000), CONST64(0x00000808,0x08000000), CONST64(0x00000800,0x08000008), CONST64(0x00000808,0x08000008),
  CONST64(0x00000000,0x08000800), CONST64(0x00000008,0x08000800), CONST64(0x00000000,0x08000808), CONST64(0x00000008,0x08000808),
  CONST64(0x00000800,0x08000800), CONST64(0x00000808,0x08000800), CONST64(0x00000800,0x08000808), CONST64(0x00000808,0x08000808),
  CONST64(0x00080000,0x08000000), CONST64(0x00080008,0x08000000), CONST64(0x00080000,0x08000008), CONST64(0x00080008,0x08000008),
  CONST64(0x00080800,0x08000000), CONST64(0x00080808,0x08000000), CONST64(0x00080800,0x08000008), CONST64(0x00080808,0x08000008),
  CONST64(0x00080000,0x08000800), CONST64(0x00080008,0x08000800), CONST64(0x00080000,0x08000808), CONST64(0x00080008,0x08000808),
  CONST64(0x00080800,0x08000800), CONST64(0x00080808,0x08000800), CONST64(0x00080800,0x08000808), CONST64(0x00080808,0x08000808),
  CONST64(0x00000000,0x08080000), CONST64(0x00000008,0x08080000), CONST64(0x00000000,0x08080008), CONST64(0x00000008,0x08080008),
  CONST64(0x00000800,0x08080000), CONST64(0x00000808,0x08080000), CONST64(0x00000800,0x08080008), CONST64(0x00000808,0x08080008),
  CONST64(0x00000000,0x08080800), CONST64(0x00000008,0x08080800), CONST64(0x00000000,0x08080808), CONST64(0x00000008,0x08080808),
  CONST64(0x00000800,0x08080800), CONST64(0x00000808,0x08080800), CONST64(0x00000800,0x08080808), CONST64(0x00000808,0x08080808),
  CONST64(0x00080000,0x08080000), CONST64(0x00080008,0x08080000), CONST64(0x00080000,0x08080008), CONST64(0x00080008,0x08080008),
  CONST64(0x00080800,0x08080000), CONST64(0x00080808,0x08080000), CONST64(0x00080800,0x08080008), CONST64(0x00080808,0x08080008),
  CONST64(0x00080000,0x08080800), CONST64(0x00080008,0x08080800), CONST64(0x00080000,0x08080808), CONST64(0x00080008,0x08080808),
  CONST64(0x00080800,0x08080800), CONST64(0x00080808,0x08080800), CONST64(0x00080800,0x08080808), CONST64(0x00080808,0x08080808),
  CONST64(0x08000000,0x08000000), CONST64(0x08000008,0x08000000), CONST64(0x08000000,0x08000008), CONST64(0x08000008,0x08000008),
  CONST64(0x08000800,0x08000000), CONST64(0x08000808,0x08000000), CONST64(0x08000800,0x08000008), CONST64(0x08000808,0x08000008),
  CONST64(0x08000000,0x08000800), CONST64(0x08000008,0x08000800), CONST64(0x08000000,0x08000808), CONST64(0x08000008,0x08000808),
  CONST64(0x08000800,0x08000800), CONST64(0x08000808,0x08000800), CONST64(0x08000800,0x08000808), CONST64(0x08000808,0x08000808),
  CONST64(0x08080000,0x08000000), CONST64(0x08080008,0x08000000), CONST64(0x08080000,0x08000008), CONST64(0x08080008,0x08000008),
  CONST64(0x08080800,0x08000000), CONST64(0x08080808,0x08000000), CONST64(0x08080800,0x08000008), CONST64(0x08080808,0x08000008),
  CONST64(0x08080000,0x08000800), CONST64(0x08080008,0x08000800), CONST64(0x08080000,0x08000808), CONST64(0x08080008,0x08000808),
  CONST64(0x08080800,0x08000800), CONST64(0x08080808,0x08000800), CONST64(0x08080800,0x08000808), CONST64(0x08080808,0x08000808),
  CONST64(0x08000000,0x08080000), CONST64(0x08000008,0x08080000), CONST64(0x08000000,0x08080008), CONST64(0x08000008,0x08080008),
  CONST64(0x08000800,0x08080000), CONST64(0x08000808,0x08080000), CONST64(0x08000800,0x08080008), CONST64(0x08000808,0x08080008),
  CONST64(0x08000000,0x08080800), CONST64(0x08000008,0x08080800), CONST64(0x08000000,0x08080808), CONST64(0x08000008,0x08080808),
  CONST64(0x08000800,0x08080800), CONST64(0x08000808,0x08080800), CONST64(0x08000800,0x08080808), CONST64(0x08000808,0x08080808),
  CONST64(0x08080000,0x08080000), CONST64(0x08080008,0x08080000), CONST64(0x08080000,0x08080008), CONST64(0x08080008,0x08080008),
  CONST64(0x08080800,0x08080000), CONST64(0x08080808,0x08080000), CONST64(0x08080800,0x08080008), CONST64(0x08080808,0x08080008),
  CONST64(0x08080000,0x08080800), CONST64(0x08080008,0x08080800), CONST64(0x08080000,0x08080808), CONST64(0x08080008,0x08080808),
  CONST64(0x08080800,0x08080800), CONST64(0x08080808,0x08080800), CONST64(0x08080800,0x08080808), CONST64(0x08080808,0x08080808)
  },
{ CONST64(0x00000000,0x00000000), CONST64(0x00000004,0x00000000), CONST64(0x00000000,0x00000004), CONST64(0x00000004,0x00000004),
  CONST64(0x00000400,0x00000000), CONST64(0x00000404,0x00000000), CONST64(0x00000400,0x00000004), CONST64(0x00000404,0x00000004),
  CONST64(0x00000000,0x00000400), CONST64(0x00000004,0x00000400), CONST64(0x00000000,0x00000404), CONST64(0x00000004,0x00000404),
  CONST64(0x00000400,0x00000400), CONST64(0x00000404,0x00000400), CONST64(0x00000400,0x00000404), CONST64(0x00000404,0x00000404),
  CONST64(0x00040000,0x00000000), CONST64(0x00040004,0x00000000), CONST64(0x00040000,0x00000004), CONST64(0x00040004,0x00000004),
  CONST64(0x00040400,0x00000000), CONST64(0x00040404,0x00000000), CONST64(0x00040400,0x00000004), CONST64(0x00040404,0x00000004),
  CONST64(0x00040000,0x00000400), CONST64(0x00040004,0x00000400), CONST64(0x00040000,0x00000404), CONST64(0x00040004,0x00000404),
  CONST64(0x00040400,0x00000400), CONST64(0x00040404,0x00000400), CONST64(0x00040400,0x00000404), CONST64(0x00040404,0x00000404),
  CONST64(0x00000000,0x00040000), CONST64(0x00000004,0x00040000), CONST64(0x00000000,0x00040004), CONST64(0x00000004,0x00040004),
  CONST64(0x00000400,0x00040000), CONST64(0x00000404,0x00040000), CONST64(0x00000400,0x00040004), CONST64(0x00000404,0x00040004),
  CONST64(0x00000000,0x00040400), CONST64(0x00000004,0x00040400), CONST64(0x00000000,0x00040404), CONST64(0x00000004,0x00040404),
  CONST64(0x00000400,0x00040400), CONST64(0x00000404,0x00040400), CONST64(0x00000400,0x00040404), CONST64(0x00000404,0x00040404),
  CONST64(0x00040000,0x00040000), CONST64(0x00040004,0x00040000), CONST64(0x00040000,0x00040004), CONST64(0x00040004,0x00040004),
  CONST64(0x00040400,0x00040000), CONST64(0x00040404,0x00040000), CONST64(0x00040400,0x00040004), CONST64(0x00040404,0x00040004),
  CONST64(0x00040000,0x00040400), CONST64(0x00040004,0x00040400), CONST64(0x00040000,0x00040404), CONST64(0x00040004,0x00040404),
  CONST64(0x00040400,0x00040400), CONST64(0x00040404,0x00040400), CONST64(0x00040400,0x00040404), CONST64(0x00040404,0x00040404),
  CONST64(0x04000000,0x00000000), CONST64(0x04000004,0x00000000), CONST64(0x04000000,0x00000004), CONST64(0x04000004,0x00000004),
  CONST64(0x04000400,0x00000000), CONST64(0x04000404,0x00000000), CONST64(0x04000400,0x00000004), CONST64(0x04000404,0x00000004),
  CONST64(0x04000000,0x00000400), CONST64(0x04000004,0x00000400), CONST64(0x04000000,0x00000404), CONST64(0x04000004,0x00000404),
  CONST64(0x04000400,0x00000400), CONST64(0x04000404,0x00000400), CONST64(0x04000400,0x00000404), CONST64(0x04000404,0x00000404),
  CONST64(0x04040000,0x00000000), CONST64(0x04040004,0x00000000), CONST64(0x04040000,0x00000004), CONST64(0x04040004,0x00000004),
  CONST64(0x04040400,0x00000000), CONST64(0x04040404,0x00000000), CONST64(0x04040400,0x00000004), CONST64(0x04040404,0x00000004),
  CONST64(0x04040000,0x00000400), CONST64(0x04040004,0x00000400), CONST64(0x04040000,0x00000404), CONST64(0x04040004,0x00000404),
  CONST64(0x04040400,0x00000400), CONST64(0x04040404,0x00000400), CONST64(0x04040400,0x00000404), CONST64(0x04040404,0x00000404),
  CONST64(0x04000000,0x00040000), CONST64(0x04000004,0x00040000), CONST64(0x04000000,0x00040004), CONST64(0x04000004,0x00040004),
  CONST64(0x04000400,0x00040000), CONST64(0x04000404,0x00040000), CONST64(0x04000400,0x00040004), CONST64(0x04000404,0x00040004),
  CONST64(0x04000000,0x00040400), CONST64(0x04000004,0x00040400), CONST64(0x04000000,0x00040404), CONST64(0x04000004,0x00040404),
  CONST64(0x04000400,0x00040400), CONST64(0x04000404,0x00040400), CONST64(0x04000400,0x00040404), CONST64(0x04000404,0x00040404),
  CONST64(0x04040000,0x00040000), CONST64(0x04040004,0x00040000), CONST64(0x04040000,0x00040004), CONST64(0x04040004,0x00040004),
  CONST64(0x04040400,0x00040000), CONST64(0x04040404,0x00040000), CONST64(0x04040400,0x00040004), CONST64(0x04040404,0x00040004),
  CONST64(0x04040000,0x00040400), CONST64(0x04040004,0x00040400), CONST64(0x04040000,0x00040404), CONST64(0x04040004,0x00040404),
  CONST64(0x04040400,0x00040400), CONST64(0x04040404,0x00040400), CONST64(0x04040400,0x00040404), CONST64(0x04040404,0x00040404),
  CONST64(0x00000000,0x04000000), CONST64(0x00000004,0x04000000), CONST64(0x00000000,0x04000004), CONST64(0x00000004,0x04000004),
  CONST64(0x00000400,0x04000000), CONST64(0x00000404,0x04000000), CONST64(0x00000400,0x04000004), CONST64(0x00000404,0x04000004),
  CONST64(0x00000000,0x04000400), CONST64(0x00000004,0x04000400), CONST64(0x00000000,0x04000404), CONST64(0x00000004,0x04000404),
  CONST64(0x00000400,0x04000400), CONST64(0x00000404,0x04000400), CONST64(0x00000400,0x04000404), CONST64(0x00000404,0x04000404),
  CONST64(0x00040000,0x04000000), CONST64(0x00040004,0x04000000), CONST64(0x00040000,0x04000004), CONST64(0x00040004,0x04000004),
  CONST64(0x00040400,0x04000000), CONST64(0x00040404,0x04000000), CONST64(0x00040400,0x04000004), CONST64(0x00040404,0x04000004),
  CONST64(0x00040000,0x04000400), CONST64(0x00040004,0x04000400), CONST64(0x00040000,0x04000404), CONST64(0x00040004,0x04000404),
  CONST64(0x00040400,0x04000400), CONST64(0x00040404,0x04000400), CONST64(0x00040400,0x04000404), CONST64(0x00040404,0x04000404),
  CONST64(0x00000000,0x04040000), CONST64(0x00000004,0x04040000), CONST64(0x00000000,0x04040004), CONST64(0x00000004,0x04040004),
  CONST64(0x00000400,0x04040000), CONST64(0x00000404,0x04040000), CONST64(0x00000400,0x04040004), CONST64(0x00000404,0x04040004),
  CONST64(0x00000000,0x04040400), CONST64(0x00000004,0x04040400), CONST64(0x00000000,0x04040404), CONST64(0x00000004,0x04040404),
  CONST64(0x00000400,0x04040400), CONST64(0x00000404,0x04040400), CONST64(0x00000400,0x04040404), CONST64(0x00000404,0x04040404),
  CONST64(0x00040000,0x04040000), CONST64(0x00040004,0x04040000), CONST64(0x00040000,0x04040004), CONST64(0x00040004,0x04040004),
  CONST64(0x00040400,0x04040000), CONST64(0x00040404,0x04040000), CONST64(0x00040400,0x04040004), CONST64(0x00040404,0x04040004),
  CONST64(0x00040000,0x04040400), CONST64(0x00040004,0x04040400), CONST64(0x00040000,0x04040404), CONST64(0x00040004,0x04040404),
  CONST64(0x00040400,0x04040400), CONST64(0x00040404,0x04040400), CONST64(0x00040400,0x04040404), CONST64(0x00040404,0x04040404),
  CONST64(0x04000000,0x04000000), CONST64(0x04000004,0x04000000), CONST64(0x04000000,0x04000004), CONST64(0x04000004,0x04000004),
  CONST64(0x04000400,0x04000000), CONST64(0x04000404,0x04000000), CONST64(0x04000400,0x04000004), CONST64(0x04000404,0x04000004),
  CONST64(0x04000000,0x04000400), CONST64(0x04000004,0x04000400), CONST64(0x04000000,0x04000404), CONST64(0x04000004,0x04000404),
  CONST64(0x04000400,0x04000400), CONST64(0x04000404,0x04000400), CONST64(0x04000400,0x04000404), CONST64(0x04000404,0x04000404),
  CONST64(0x04040000,0x04000000), CONST64(0x04040004,0x04000000), CONST64(0x04040000,0x04000004), CONST64(0x04040004,0x04000004),
  CONST64(0x04040400,0x04000000), CONST64(0x04040404,0x04000000), CONST64(0x04040400,0x04000004), CONST64(0x04040404,0x04000004),
  CONST64(0x04040000,0x04000400), CONST64(0x04040004,0x04000400), CONST64(0x04040000,0x04000404), CONST64(0x04040004,0x04000404),
  CONST64(0x04040400,0x04000400), CONST64(0x04040404,0x04000400), CONST64(0x04040400,0x04000404), CONST64(0x04040404,0x04000404),
  CONST64(0x04000000,0x04040000), CONST64(0x04000004,0x04040000), CONST64(0x04000000,0x04040004), CONST64(0x04000004,0x04040004),
  CONST64(0x04000400,0x04040000), CONST64(0x04000404,0x04040000), CONST64(0x04000400,0x04040004), CONST64(0x04000404,0x04040004),
  CONST64(0x04000000,0x04040400), CONST64(0x04000004,0x04040400), CONST64(0x04000000,0x04040404), CONST64(0x04000004,0x04040404),
  CONST64(0x04000400,0x04040400), CONST64(0x04000404,0x04040400), CONST64(0x04000400,0x04040404), CONST64(0x04000404,0x04040404),
  CONST64(0x04040000,0x04040000), CONST64(0x04040004,0x04040000), CONST64(0x04040000,0x04040004), CONST64(0x04040004,0x04040004),
  CONST64(0x04040400,0x04040000), CONST64(0x04040404,0x04040000), CONST64(0x04040400,0x04040004), CONST64(0x04040404,0x04040004),
  CONST64(0x04040000,0x04040400), CONST64(0x04040004,0x04040400), CONST64(0x04040000,0x04040404), CONST64(0x04040004,0x04040404),
  CONST64(0x04040400,0x04040400), CONST64(0x04040404,0x04040400), CONST64(0x04040400,0x04040404), CONST64(0x04040404,0x04040404)
  },
{ CONST64(0x00000000,0x00000000), CONST64(0x00000002,0x00000000), CONST64(0x00000000,0x00000002), CONST64(0x00000002,0x00000002),
  CONST64(0x00000200,0x00000000), CONST64(0x00000202,0x00000000), CONST64(0x00000200,0x00000002), CONST64(0x00000202,0x00000002),
  CONST64(0x00000000,0x00000200), CONST64(0x00000002,0x00000200), CONST64(0x00000000,0x00000202), CONST64(0x00000002,0x00000202),
  CONST64(0x00000200,0x00000200), CONST64(0x00000202,0x00000200), CONST64(0x00000200,0x00000202), CONST64(0x00000202,0x00000202),
  CONST64(0x00020000,0x00000000), CONST64(0x00020002,0x00000000), CONST64(0x00020000,0x00000002), CONST64(0x00020002,0x00000002),
  CONST64(0x00020200,0x00000000), CONST64(0x00020202,0x00000000), CONST64(0x00020200,0x00000002), CONST64(0x00020202,0x00000002),
  CONST64(0x00020000,0x00000200), CONST64(0x00020002,0x00000200), CONST64(0x00020000,0x00000202), CONST64(0x00020002,0x00000202),
  CONST64(0x00020200,0x00000200), CONST64(0x00020202,0x00000200), CONST64(0x00020200,0x00000202), CONST64(0x00020202,0x00000202),
  CONST64(0x00000000,0x00020000), CONST64(0x00000002,0x00020000), CONST64(0x00000000,0x00020002), CONST64(0x00000002,0x00020002),
  CONST64(0x00000200,0x00020000), CONST64(0x00000202,0x00020000), CONST64(0x00000200,0x00020002), CONST64(0x00000202,0x00020002),
  CONST64(0x00000000,0x00020200), CONST64(0x00000002,0x00020200), CONST64(0x00000000,0x00020202), CONST64(0x00000002,0x00020202),
  CONST64(0x00000200,0x00020200), CONST64(0x00000202,0x00020200), CONST64(0x00000200,0x00020202), CONST64(0x00000202,0x00020202),
  CONST64(0x00020000,0x00020000), CONST64(0x00020002,0x00020000), CONST64(0x00020000,0x00020002), CONST64(0x00020002,0x00020002),
  CONST64(0x00020200,0x00020000), CONST64(0x00020202,0x00020000), CONST64(0x00020200,0x00020002), CONST64(0x00020202,0x00020002),
  CONST64(0x00020000,0x00020200), CONST64(0x00020002,0x00020200), CONST64(0x00020000,0x00020202), CONST64(0x00020002,0x00020202),
  CONST64(0x00020200,0x00020200), CONST64(0x00020202,0x00020200), CONST64(0x00020200,0x00020202), CONST64(0x00020202,0x00020202),
  CONST64(0x02000000,0x00000000), CONST64(0x02000002,0x00000000), CONST64(0x02000000,0x00000002), CONST64(0x02000002,0x00000002),
  CONST64(0x02000200,0x00000000), CONST64(0x02000202,0x00000000), CONST64(0x02000200,0x00000002), CONST64(0x02000202,0x00000002),
  CONST64(0x02000000,0x00000200), CONST64(0x02000002,0x00000200), CONST64(0x02000000,0x00000202), CONST64(0x02000002,0x00000202),
  CONST64(0x02000200,0x00000200), CONST64(0x02000202,0x00000200), CONST64(0x02000200,0x00000202), CONST64(0x02000202,0x00000202),
  CONST64(0x02020000,0x00000000), CONST64(0x02020002,0x00000000), CONST64(0x02020000,0x00000002), CONST64(0x02020002,0x00000002),
  CONST64(0x02020200,0x00000000), CONST64(0x02020202,0x00000000), CONST64(0x02020200,0x00000002), CONST64(0x02020202,0x00000002),
  CONST64(0x02020000,0x00000200), CONST64(0x02020002,0x00000200), CONST64(0x02020000,0x00000202), CONST64(0x02020002,0x00000202),
  CONST64(0x02020200,0x00000200), CONST64(0x02020202,0x00000200), CONST64(0x02020200,0x00000202), CONST64(0x02020202,0x00000202),
  CONST64(0x02000000,0x00020000), CONST64(0x02000002,0x00020000), CONST64(0x02000000,0x00020002), CONST64(0x02000002,0x00020002),
  CONST64(0x02000200,0x00020000), CONST64(0x02000202,0x00020000), CONST64(0x02000200,0x00020002), CONST64(0x02000202,0x00020002),
  CONST64(0x02000000,0x00020200), CONST64(0x02000002,0x00020200), CONST64(0x02000000,0x00020202), CONST64(0x02000002,0x00020202),
  CONST64(0x02000200,0x00020200), CONST64(0x02000202,0x00020200), CONST64(0x02000200,0x00020202), CONST64(0x02000202,0x00020202),
  CONST64(0x02020000,0x00020000), CONST64(0x02020002,0x00020000), CONST64(0x02020000,0x00020002), CONST64(0x02020002,0x00020002),
  CONST64(0x02020200,0x00020000), CONST64(0x02020202,0x00020000), CONST64(0x02020200,0x00020002), CONST64(0x02020202,0x00020002),
  CONST64(0x02020000,0x00020200), CONST64(0x02020002,0x00020200), CONST64(0x02020000,0x00020202), CONST64(0x02020002,0x00020202),
  CONST64(0x02020200,0x00020200), CONST64(0x02020202,0x00020200), CONST64(0x02020200,0x00020202), CONST64(0x02020202,0x00020202),
  CONST64(0x00000000,0x02000000), CONST64(0x00000002,0x02000000), CONST64(0x00000000,0x02000002), CONST64(0x00000002,0x02000002),
  CONST64(0x00000200,0x02000000), CONST64(0x00000202,0x02000000), CONST64(0x00000200,0x02000002), CONST64(0x00000202,0x02000002),
  CONST64(0x00000000,0x02000200), CONST64(0x00000002,0x02000200), CONST64(0x00000000,0x02000202), CONST64(0x00000002,0x02000202),
  CONST64(0x00000200,0x02000200), CONST64(0x00000202,0x02000200), CONST64(0x00000200,0x02000202), CONST64(0x00000202,0x02000202),
  CONST64(0x00020000,0x02000000), CONST64(0x00020002,0x02000000), CONST64(0x00020000,0x02000002), CONST64(0x00020002,0x02000002),
  CONST64(0x00020200,0x02000000), CONST64(0x00020202,0x02000000), CONST64(0x00020200,0x02000002), CONST64(0x00020202,0x02000002),
  CONST64(0x00020000,0x02000200), CONST64(0x00020002,0x02000200), CONST64(0x00020000,0x02000202), CONST64(0x00020002,0x02000202),
  CONST64(0x00020200,0x02000200), CONST64(0x00020202,0x02000200), CONST64(0x00020200,0x02000202), CONST64(0x00020202,0x02000202),
  CONST64(0x00000000,0x02020000), CONST64(0x00000002,0x02020000), CONST64(0x00000000,0x02020002), CONST64(0x00000002,0x02020002),
  CONST64(0x00000200,0x02020000), CONST64(0x00000202,0x02020000), CONST64(0x00000200,0x02020002), CONST64(0x00000202,0x02020002),
  CONST64(0x00000000,0x02020200), CONST64(0x00000002,0x02020200), CONST64(0x00000000,0x02020202), CONST64(0x00000002,0x02020202),
  CONST64(0x00000200,0x02020200), CONST64(0x00000202,0x02020200), CONST64(0x00000200,0x02020202), CONST64(0x00000202,0x02020202),
  CONST64(0x00020000,0x02020000), CONST64(0x00020002,0x02020000), CONST64(0x00020000,0x02020002), CONST64(0x00020002,0x02020002),
  CONST64(0x00020200,0x02020000), CONST64(0x00020202,0x02020000), CONST64(0x00020200,0x02020002), CONST64(0x00020202,0x02020002),
  CONST64(0x00020000,0x02020200), CONST64(0x00020002,0x02020200), CONST64(0x00020000,0x02020202), CONST64(0x00020002,0x02020202),
  CONST64(0x00020200,0x02020200), CONST64(0x00020202,0x02020200), CONST64(0x00020200,0x02020202), CONST64(0x00020202,0x02020202),
  CONST64(0x02000000,0x02000000), CONST64(0x02000002,0x02000000), CONST64(0x02000000,0x02000002), CONST64(0x02000002,0x02000002),
  CONST64(0x02000200,0x02000000), CONST64(0x02000202,0x02000000), CONST64(0x02000200,0x02000002), CONST64(0x02000202,0x02000002),
  CONST64(0x02000000,0x02000200), CONST64(0x02000002,0x02000200), CONST64(0x02000000,0x02000202), CONST64(0x02000002,0x02000202),
  CONST64(0x02000200,0x02000200), CONST64(0x02000202,0x02000200), CONST64(0x02000200,0x02000202), CONST64(0x02000202,0x02000202),
  CONST64(0x02020000,0x02000000), CONST64(0x02020002,0x02000000), CONST64(0x02020000,0x02000002), CONST64(0x02020002,0x02000002),
  CONST64(0x02020200,0x02000000), CONST64(0x02020202,0x02000000), CONST64(0x02020200,0x02000002), CONST64(0x02020202,0x02000002),
  CONST64(0x02020000,0x02000200), CONST64(0x02020002,0x02000200), CONST64(0x02020000,0x02000202), CONST64(0x02020002,0x02000202),
  CONST64(0x02020200,0x02000200), CONST64(0x02020202,0x02000200), CONST64(0x02020200,0x02000202), CONST64(0x02020202,0x02000202),
  CONST64(0x02000000,0x02020000), CONST64(0x02000002,0x02020000), CONST64(0x02000000,0x02020002), CONST64(0x02000002,0x02020002),
  CONST64(0x02000200,0x02020000), CONST64(0x02000202,0x02020000), CONST64(0x02000200,0x02020002), CONST64(0x02000202,0x02020002),
  CONST64(0x02000000,0x02020200), CONST64(0x02000002,0x02020200), CONST64(0x02000000,0x02020202), CONST64(0x02000002,0x02020202),
  CONST64(0x02000200,0x02020200), CONST64(0x02000202,0x02020200), CONST64(0x02000200,0x02020202), CONST64(0x02000202,0x02020202),
  CONST64(0x02020000,0x02020000), CONST64(0x02020002,0x02020000), CONST64(0x02020000,0x02020002), CONST64(0x02020002,0x02020002),
  CONST64(0x02020200,0x02020000), CONST64(0x02020202,0x02020000), CONST64(0x02020200,0x02020002), CONST64(0x02020202,0x02020002),
  CONST64(0x02020000,0x02020200), CONST64(0x02020002,0x02020200), CONST64(0x02020000,0x02020202), CONST64(0x02020002,0x02020202),
  CONST64(0x02020200,0x02020200), CONST64(0x02020202,0x02020200), CONST64(0x02020200,0x02020202), CONST64(0x02020202,0x02020202)
  },
{ CONST64(0x00000000,0x00000000), CONST64(0x00000100,0x00000000), CONST64(0x00000000,0x00000100), CONST64(0x00000100,0x00000100),
  CONST64(0x00010000,0x00000000), CONST64(0x00010100,0x00000000), CONST64(0x00010000,0x00000100), CONST64(0x00010100,0x00000100),
  CONST64(0x00000000,0x00010000), CONST64(0x00000100,0x00010000), CONST64(0x00000000,0x00010100), CONST64(0x00000100,0x00010100),
  CONST64(0x00010000,0x00010000), CONST64(0x00010100,0x00010000), CONST64(0x00010000,0x00010100), CONST64(0x00010100,0x00010100),
  CONST64(0x01000000,0x00000000), CONST64(0x01000100,0x00000000), CONST64(0x01000000,0x00000100), CONST64(0x01000100,0x00000100),
  CONST64(0x01010000,0x00000000), CONST64(0x01010100,0x00000000), CONST64(0x01010000,0x00000100), CONST64(0x01010100,0x00000100),
  CONST64(0x01000000,0x00010000), CONST64(0x01000100,0x00010000), CONST64(0x01000000,0x00010100), CONST64(0x01000100,0x00010100),
  CONST64(0x01010000,0x00010000), CONST64(0x01010100,0x00010000), CONST64(0x01010000,0x00010100), CONST64(0x01010100,0x00010100),
  CONST64(0x00000000,0x01000000), CONST64(0x00000100,0x01000000), CONST64(0x00000000,0x01000100), CONST64(0x00000100,0x01000100),
  CONST64(0x00010000,0x01000000), CONST64(0x00010100,0x01000000), CONST64(0x00010000,0x01000100), CONST64(0x00010100,0x01000100),
  CONST64(0x00000000,0x01010000), CONST64(0x00000100,0x01010000), CONST64(0x00000000,0x01010100), CONST64(0x00000100,0x01010100),
  CONST64(0x00010000,0x01010000), CONST64(0x00010100,0x01010000), CONST64(0x00010000,0x01010100), CONST64(0x00010100,0x01010100),
  CONST64(0x01000000,0x01000000), CONST64(0x01000100,0x01000000), CONST64(0x01000000,0x01000100), CONST64(0x01000100,0x01000100),
  CONST64(0x01010000,0x01000000), CONST64(0x01010100,0x01000000), CONST64(0x01010000,0x01000100), CONST64(0x01010100,0x01000100),
  CONST64(0x01000000,0x01010000), CONST64(0x01000100,0x01010000), CONST64(0x01000000,0x01010100), CONST64(0x01000100,0x01010100),
  CONST64(0x01010000,0x01010000), CONST64(0x01010100,0x01010000), CONST64(0x01010000,0x01010100), CONST64(0x01010100,0x01010100),
  CONST64(0x00000001,0x00000000), CONST64(0x00000101,0x00000000), CONST64(0x00000001,0x00000100), CONST64(0x00000101,0x00000100),
  CONST64(0x00010001,0x00000000), CONST64(0x00010101,0x00000000), CONST64(0x00010001,0x00000100), CONST64(0x00010101,0x00000100),
  CONST64(0x00000001,0x00010000), CONST64(0x00000101,0x00010000), CONST64(0x00000001,0x00010100), CONST64(0x00000101,0x00010100),
  CONST64(0x00010001,0x00010000), CONST64(0x00010101,0x00010000), CONST64(0x00010001,0x00010100), CONST64(0x00010101,0x00010100),
  CONST64(0x01000001,0x00000000), CONST64(0x01000101,0x00000000), CONST64(0x01000001,0x00000100), CONST64(0x01000101,0x00000100),
  CONST64(0x01010001,0x00000000), CONST64(0x01010101,0x00000000), CONST64(0x01010001,0x00000100), CONST64(0x01010101,0x00000100),
  CONST64(0x01000001,0x00010000), CONST64(0x01000101,0x00010000), CONST64(0x01000001,0x00010100), CONST64(0x01000101,0x00010100),
  CONST64(0x01010001,0x00010000), CONST64(0x01010101,0x00010000), CONST64(0x01010001,0x00010100), CONST64(0x01010101,0x00010100),
  CONST64(0x00000001,0x01000000), CONST64(0x00000101,0x01000000), CONST64(0x00000001,0x01000100), CONST64(0x00000101,0x01000100),
  CONST64(0x00010001,0x01000000), CONST64(0x00010101,0x01000000), CONST64(0x00010001,0x01000100), CONST64(0x00010101,0x01000100),
  CONST64(0x00000001,0x01010000), CONST64(0x00000101,0x01010000), CONST64(0x00000001,0x01010100), CONST64(0x00000101,0x01010100),
  CONST64(0x00010001,0x01010000), CONST64(0x00010101,0x01010000), CONST64(0x00010001,0x01010100), CONST64(0x00010101,0x01010100),
  CONST64(0x01000001,0x01000000), CONST64(0x01000101,0x01000000), CONST64(0x01000001,0x01000100), CONST64(0x01000101,0x01000100),
  CONST64(0x01010001,0x01000000), CONST64(0x01010101,0x01000000), CONST64(0x01010001,0x01000100), CONST64(0x01010101,0x01000100),
  CONST64(0x01000001,0x01010000), CONST64(0x01000101,0x01010000), CONST64(0x01000001,0x01010100), CONST64(0x01000101,0x01010100),
  CONST64(0x01010001,0x01010000), CONST64(0x01010101,0x01010000), CONST64(0x01010001,0x01010100), CONST64(0x01010101,0x01010100),
  CONST64(0x00000000,0x00000001), CONST64(0x00000100,0x00000001), CONST64(0x00000000,0x00000101), CONST64(0x00000100,0x00000101),
  CONST64(0x00010000,0x00000001), CONST64(0x00010100,0x00000001), CONST64(0x00010000,0x00000101), CONST64(0x00010100,0x00000101),
  CONST64(0x00000000,0x00010001), CONST64(0x00000100,0x00010001), CONST64(0x00000000,0x00010101), CONST64(0x00000100,0x00010101),
  CONST64(0x00010000,0x00010001), CONST64(0x00010100,0x00010001), CONST64(0x00010000,0x00010101), CONST64(0x00010100,0x00010101),
  CONST64(0x01000000,0x00000001), CONST64(0x01000100,0x00000001), CONST64(0x01000000,0x00000101), CONST64(0x01000100,0x00000101),
  CONST64(0x01010000,0x00000001), CONST64(0x01010100,0x00000001), CONST64(0x01010000,0x00000101), CONST64(0x01010100,0x00000101),
  CONST64(0x01000000,0x00010001), CONST64(0x01000100,0x00010001), CONST64(0x01000000,0x00010101), CONST64(0x01000100,0x00010101),
  CONST64(0x01010000,0x00010001), CONST64(0x01010100,0x00010001), CONST64(0x01010000,0x00010101), CONST64(0x01010100,0x00010101),
  CONST64(0x00000000,0x01000001), CONST64(0x00000100,0x01000001), CONST64(0x00000000,0x01000101), CONST64(0x00000100,0x01000101),
  CONST64(0x00010000,0x01000001), CONST64(0x00010100,0x01000001), CONST64(0x00010000,0x01000101), CONST64(0x00010100,0x01000101),
  CONST64(0x00000000,0x01010001), CONST64(0x00000100,0x01010001), CONST64(0x00000000,0x01010101), CONST64(0x00000100,0x01010101),
  CONST64(0x00010000,0x01010001), CONST64(0x00010100,0x01010001), CONST64(0x00010000,0x01010101), CONST64(0x00010100,0x01010101),
  CONST64(0x01000000,0x01000001), CONST64(0x01000100,0x01000001), CONST64(0x01000000,0x01000101), CONST64(0x01000100,0x01000101),
  CONST64(0x01010000,0x01000001), CONST64(0x01010100,0x01000001), CONST64(0x01010000,0x01000101), CONST64(0x01010100,0x01000101),
  CONST64(0x01000000,0x01010001), CONST64(0x01000100,0x01010001), CONST64(0x01000000,0x01010101), CONST64(0x01000100,0x01010101),
  CONST64(0x01010000,0x01010001), CONST64(0x01010100,0x01010001), CONST64(0x01010000,0x01010101), CONST64(0x01010100,0x01010101),
  CONST64(0x00000001,0x00000001), CONST64(0x00000101,0x00000001), CONST64(0x00000001,0x00000101), CONST64(0x00000101,0x00000101),
  CONST64(0x00010001,0x00000001), CONST64(0x00010101,0x00000001), CONST64(0x00010001,0x00000101), CONST64(0x00010101,0x00000101),
  CONST64(0x00000001,0x00010001), CONST64(0x00000101,0x00010001), CONST64(0x00000001,0x00010101), CONST64(0x00000101,0x00010101),
  CONST64(0x00010001,0x00010001), CONST64(0x00010101,0x00010001), CONST64(0x00010001,0x00010101), CONST64(0x00010101,0x00010101),
  CONST64(0x01000001,0x00000001), CONST64(0x01000101,0x00000001), CONST64(0x01000001,0x00000101), CONST64(0x01000101,0x00000101),
  CONST64(0x01010001,0x00000001), CONST64(0x01010101,0x00000001), CONST64(0x01010001,0x00000101), CONST64(0x01010101,0x00000101),
  CONST64(0x01000001,0x00010001), CONST64(0x01000101,0x00010001), CONST64(0x01000001,0x00010101), CONST64(0x01000101,0x00010101),
  CONST64(0x01010001,0x00010001), CONST64(0x01010101,0x00010001), CONST64(0x01010001,0x00010101), CONST64(0x01010101,0x00010101),
  CONST64(0x00000001,0x01000001), CONST64(0x00000101,0x01000001), CONST64(0x00000001,0x01000101), CONST64(0x00000101,0x01000101),
  CONST64(0x00010001,0x01000001), CONST64(0x00010101,0x01000001), CONST64(0x00010001,0x01000101), CONST64(0x00010101,0x01000101),
  CONST64(0x00000001,0x01010001), CONST64(0x00000101,0x01010001), CONST64(0x00000001,0x01010101), CONST64(0x00000101,0x01010101),
  CONST64(0x00010001,0x01010001), CONST64(0x00010101,0x01010001), CONST64(0x00010001,0x01010101), CONST64(0x00010101,0x01010101),
  CONST64(0x01000001,0x01000001), CONST64(0x01000101,0x01000001), CONST64(0x01000001,0x01000101), CONST64(0x01000101,0x01000101),
  CONST64(0x01010001,0x01000001), CONST64(0x01010101,0x01000001), CONST64(0x01010001,0x01000101), CONST64(0x01010101,0x01000101),
  CONST64(0x01000001,0x01010001), CONST64(0x01000101,0x01010001), CONST64(0x01000001,0x01010101), CONST64(0x01000101,0x01010101),
  CONST64(0x01010001,0x01010001), CONST64(0x01010101,0x01010001), CONST64(0x01010001,0x01010101), CONST64(0x01010101,0x01010101)
  },
{ CONST64(0x00000000,0x00000000), CONST64(0x00000080,0x00000000), CONST64(0x00000000,0x00000080), CONST64(0x00000080,0x00000080),
  CONST64(0x00008000,0x00000000), CONST64(0x00008080,0x00000000), CONST64(0x00008000,0x00000080), CONST64(0x00008080,0x00000080),
  CONST64(0x00000000,0x00008000), CONST64(0x00000080,0x00008000), CONST64(0x00000000,0x00008080), CONST64(0x00000080,0x00008080),
  CONST64(0x00008000,0x00008000), CONST64(0x00008080,0x00008000), CONST64(0x00008000,0x00008080), CONST64(0x00008080,0x00008080),
  CONST64(0x00800000,0x00000000), CONST64(0x00800080,0x00000000), CONST64(0x00800000,0x00000080), CONST64(0x00800080,0x00000080),
  CONST64(0x00808000,0x00000000), CONST64(0x00808080,0x00000000), CONST64(0x00808000,0x00000080), CONST64(0x00808080,0x00000080),
  CONST64(0x00800000,0x00008000), CONST64(0x00800080,0x00008000), CONST64(0x00800000,0x00008080), CONST64(0x00800080,0x00008080),
  CONST64(0x00808000,0x00008000), CONST64(0x00808080,0x00008000), CONST64(0x00808000,0x00008080), CONST64(0x00808080,0x00008080),
  CONST64(0x00000000,0x00800000), CONST64(0x00000080,0x00800000), CONST64(0x00000000,0x00800080), CONST64(0x00000080,0x00800080),
  CONST64(0x00008000,0x00800000), CONST64(0x00008080,0x00800000), CONST64(0x00008000,0x00800080), CONST64(0x00008080,0x00800080),
  CONST64(0x00000000,0x00808000), CONST64(0x00000080,0x00808000), CONST64(0x00000000,0x00808080), CONST64(0x00000080,0x00808080),
  CONST64(0x00008000,0x00808000), CONST64(0x00008080,0x00808000), CONST64(0x00008000,0x00808080), CONST64(0x00008080,0x00808080),
  CONST64(0x00800000,0x00800000), CONST64(0x00800080,0x00800000), CONST64(0x00800000,0x00800080), CONST64(0x00800080,0x00800080),
  CONST64(0x00808000,0x00800000), CONST64(0x00808080,0x00800000), CONST64(0x00808000,0x00800080), CONST64(0x00808080,0x00800080),
  CONST64(0x00800000,0x00808000), CONST64(0x00800080,0x00808000), CONST64(0x00800000,0x00808080), CONST64(0x00800080,0x00808080),
  CONST64(0x00808000,0x00808000), CONST64(0x00808080,0x00808000), CONST64(0x00808000,0x00808080), CONST64(0x00808080,0x00808080),
  CONST64(0x80000000,0x00000000), CONST64(0x80000080,0x00000000), CONST64(0x80000000,0x00000080), CONST64(0x80000080,0x00000080),
  CONST64(0x80008000,0x00000000), CONST64(0x80008080,0x00000000), CONST64(0x80008000,0x00000080), CONST64(0x80008080,0x00000080),
  CONST64(0x80000000,0x00008000), CONST64(0x80000080,0x00008000), CONST64(0x80000000,0x00008080), CONST64(0x80000080,0x00008080),
  CONST64(0x80008000,0x00008000), CONST64(0x80008080,0x00008000), CONST64(0x80008000,0x00008080), CONST64(0x80008080,0x00008080),
  CONST64(0x80800000,0x00000000), CONST64(0x80800080,0x00000000), CONST64(0x80800000,0x00000080), CONST64(0x80800080,0x00000080),
  CONST64(0x80808000,0x00000000), CONST64(0x80808080,0x00000000), CONST64(0x80808000,0x00000080), CONST64(0x80808080,0x00000080),
  CONST64(0x80800000,0x00008000), CONST64(0x80800080,0x00008000), CONST64(0x80800000,0x00008080), CONST64(0x80800080,0x00008080),
  CONST64(0x80808000,0x00008000), CONST64(0x80808080,0x00008000), CONST64(0x80808000,0x00008080), CONST64(0x80808080,0x00008080),
  CONST64(0x80000000,0x00800000), CONST64(0x80000080,0x00800000), CONST64(0x80000000,0x00800080), CONST64(0x80000080,0x00800080),
  CONST64(0x80008000,0x00800000), CONST64(0x80008080,0x00800000), CONST64(0x80008000,0x00800080), CONST64(0x80008080,0x00800080),
  CONST64(0x80000000,0x00808000), CONST64(0x80000080,0x00808000), CONST64(0x80000000,0x00808080), CONST64(0x80000080,0x00808080),
  CONST64(0x80008000,0x00808000), CONST64(0x80008080,0x00808000), CONST64(0x80008000,0x00808080), CONST64(0x80008080,0x00808080),
  CONST64(0x80800000,0x00800000), CONST64(0x80800080,0x00800000), CONST64(0x80800000,0x00800080), CONST64(0x80800080,0x00800080),
  CONST64(0x80808000,0x00800000), CONST64(0x80808080,0x00800000), CONST64(0x80808000,0x00800080), CONST64(0x80808080,0x00800080),
  CONST64(0x80800000,0x00808000), CONST64(0x80800080,0x00808000), CONST64(0x80800000,0x00808080), CONST64(0x80800080,0x00808080),
  CONST64(0x80808000,0x00808000), CONST64(0x80808080,0x00808000), CONST64(0x80808000,0x00808080), CONST64(0x80808080,0x00808080),
  CONST64(0x00000000,0x80000000), CONST64(0x00000080,0x80000000), CONST64(0x00000000,0x80000080), CONST64(0x00000080,0x80000080),
  CONST64(0x00008000,0x80000000), CONST64(0x00008080,0x80000000), CONST64(0x00008000,0x80000080), CONST64(0x00008080,0x80000080),
  CONST64(0x00000000,0x80008000), CONST64(0x00000080,0x80008000), CONST64(0x00000000,0x80008080), CONST64(0x00000080,0x80008080),
  CONST64(0x00008000,0x80008000), CONST64(0x00008080,0x80008000), CONST64(0x00008000,0x80008080), CONST64(0x00008080,0x80008080),
  CONST64(0x00800000,0x80000000), CONST64(0x00800080,0x80000000), CONST64(0x00800000,0x80000080), CONST64(0x00800080,0x80000080),
  CONST64(0x00808000,0x80000000), CONST64(0x00808080,0x80000000), CONST64(0x00808000,0x80000080), CONST64(0x00808080,0x80000080),
  CONST64(0x00800000,0x80008000), CONST64(0x00800080,0x80008000), CONST64(0x00800000,0x80008080), CONST64(0x00800080,0x80008080),
  CONST64(0x00808000,0x80008000), CONST64(0x00808080,0x80008000), CONST64(0x00808000,0x80008080), CONST64(0x00808080,0x80008080),
  CONST64(0x00000000,0x80800000), CONST64(0x00000080,0x80800000), CONST64(0x00000000,0x80800080), CONST64(0x00000080,0x80800080),
  CONST64(0x00008000,0x80800000), CONST64(0x00008080,0x80800000), CONST64(0x00008000,0x80800080), CONST64(0x00008080,0x80800080),
  CONST64(0x00000000,0x80808000), CONST64(0x00000080,0x80808000), CONST64(0x00000000,0x80808080), CONST64(0x00000080,0x80808080),
  CONST64(0x00008000,0x80808000), CONST64(0x00008080,0x80808000), CONST64(0x00008000,0x80808080), CONST64(0x00008080,0x80808080),
  CONST64(0x00800000,0x80800000), CONST64(0x00800080,0x80800000), CONST64(0x00800000,0x80800080), CONST64(0x00800080,0x80800080),
  CONST64(0x00808000,0x80800000), CONST64(0x00808080,0x80800000), CONST64(0x00808000,0x80800080), CONST64(0x00808080,0x80800080),
  CONST64(0x00800000,0x80808000), CONST64(0x00800080,0x80808000), CONST64(0x00800000,0x80808080), CONST64(0x00800080,0x80808080),
  CONST64(0x00808000,0x80808000), CONST64(0x00808080,0x80808000), CONST64(0x00808000,0x80808080), CONST64(0x00808080,0x80808080),
  CONST64(0x80000000,0x80000000), CONST64(0x80000080,0x80000000), CONST64(0x80000000,0x80000080), CONST64(0x80000080,0x80000080),
  CONST64(0x80008000,0x80000000), CONST64(0x80008080,0x80000000), CONST64(0x80008000,0x80000080), CONST64(0x80008080,0x80000080),
  CONST64(0x80000000,0x80008000), CONST64(0x80000080,0x80008000), CONST64(0x80000000,0x80008080), CONST64(0x80000080,0x80008080),
  CONST64(0x80008000,0x80008000), CONST64(0x80008080,0x80008000), CONST64(0x80008000,0x80008080), CONST64(0x80008080,0x80008080),
  CONST64(0x80800000,0x80000000), CONST64(0x80800080,0x80000000), CONST64(0x80800000,0x80000080), CONST64(0x80800080,0x80000080),
  CONST64(0x80808000,0x80000000), CONST64(0x80808080,0x80000000), CONST64(0x80808000,0x80000080), CONST64(0x80808080,0x80000080),
  CONST64(0x80800000,0x80008000), CONST64(0x80800080,0x80008000), CONST64(0x80800000,0x80008080), CONST64(0x80800080,0x80008080),
  CONST64(0x80808000,0x80008000), CONST64(0x80808080,0x80008000), CONST64(0x80808000,0x80008080), CONST64(0x80808080,0x80008080),
  CONST64(0x80000000,0x80800000), CONST64(0x80000080,0x80800000), CONST64(0x80000000,0x80800080), CONST64(0x80000080,0x80800080),
  CONST64(0x80008000,0x80800000), CONST64(0x80008080,0x80800000), CONST64(0x80008000,0x80800080), CONST64(0x80008080,0x80800080),
  CONST64(0x80000000,0x80808000), CONST64(0x80000080,0x80808000), CONST64(0x80000000,0x80808080), CONST64(0x80000080,0x80808080),
  CONST64(0x80008000,0x80808000), CONST64(0x80008080,0x80808000), CONST64(0x80008000,0x80808080), CONST64(0x80008080,0x80808080),
  CONST64(0x80800000,0x80800000), CONST64(0x80800080,0x80800000), CONST64(0x80800000,0x80800080), CONST64(0x80800080,0x80800080),
  CONST64(0x80808000,0x80800000), CONST64(0x80808080,0x80800000), CONST64(0x80808000,0x80800080), CONST64(0x80808080,0x80800080),
  CONST64(0x80800000,0x80808000), CONST64(0x80800080,0x80808000), CONST64(0x80800000,0x80808080), CONST64(0x80800080,0x80808080),
  CONST64(0x80808000,0x80808000), CONST64(0x80808080,0x80808000), CONST64(0x80808000,0x80808080), CONST64(0x80808080,0x80808080)
  },
{ CONST64(0x00000000,0x00000000), CONST64(0x00000040,0x00000000), CONST64(0x00000000,0x00000040), CONST64(0x00000040,0x00000040),
  CONST64(0x00004000,0x00000000), CONST64(0x00004040,0x00000000), CONST64(0x00004000,0x00000040), CONST64(0x00004040,0x00000040),
  CONST64(0x00000000,0x00004000), CONST64(0x00000040,0x00004000), CONST64(0x00000000,0x00004040), CONST64(0x00000040,0x00004040),
  CONST64(0x00004000,0x00004000), CONST64(0x00004040,0x00004000), CONST64(0x00004000,0x00004040), CONST64(0x00004040,0x00004040),
  CONST64(0x00400000,0x00000000), CONST64(0x00400040,0x00000000), CONST64(0x00400000,0x00000040), CONST64(0x00400040,0x00000040),
  CONST64(0x00404000,0x00000000), CONST64(0x00404040,0x00000000), CONST64(0x00404000,0x00000040), CONST64(0x00404040,0x00000040),
  CONST64(0x00400000,0x00004000), CONST64(0x00400040,0x00004000), CONST64(0x00400000,0x00004040), CONST64(0x00400040,0x00004040),
  CONST64(0x00404000,0x00004000), CONST64(0x00404040,0x00004000), CONST64(0x00404000,0x00004040), CONST64(0x00404040,0x00004040),
  CONST64(0x00000000,0x00400000), CONST64(0x00000040,0x00400000), CONST64(0x00000000,0x00400040), CONST64(0x00000040,0x00400040),
  CONST64(0x00004000,0x00400000), CONST64(0x00004040,0x00400000), CONST64(0x00004000,0x00400040), CONST64(0x00004040,0x00400040),
  CONST64(0x00000000,0x00404000), CONST64(0x00000040,0x00404000), CONST64(0x00000000,0x00404040), CONST64(0x00000040,0x00404040),
  CONST64(0x00004000,0x00404000), CONST64(0x00004040,0x00404000), CONST64(0x00004000,0x00404040), CONST64(0x00004040,0x00404040),
  CONST64(0x00400000,0x00400000), CONST64(0x00400040,0x00400000), CONST64(0x00400000,0x00400040), CONST64(0x00400040,0x00400040),
  CONST64(0x00404000,0x00400000), CONST64(0x00404040,0x00400000), CONST64(0x00404000,0x00400040), CONST64(0x00404040,0x00400040),
  CONST64(0x00400000,0x00404000), CONST64(0x00400040,0x00404000), CONST64(0x00400000,0x00404040), CONST64(0x00400040,0x00404040),
  CONST64(0x00404000,0x00404000), CONST64(0x00404040,0x00404000), CONST64(0x00404000,0x00404040), CONST64(0x00404040,0x00404040),
  CONST64(0x40000000,0x00000000), CONST64(0x40000040,0x00000000), CONST64(0x40000000,0x00000040), CONST64(0x40000040,0x00000040),
  CONST64(0x40004000,0x00000000), CONST64(0x40004040,0x00000000), CONST64(0x40004000,0x00000040), CONST64(0x40004040,0x00000040),
  CONST64(0x40000000,0x00004000), CONST64(0x40000040,0x00004000), CONST64(0x40000000,0x00004040), CONST64(0x40000040,0x00004040),
  CONST64(0x40004000,0x00004000), CONST64(0x40004040,0x00004000), CONST64(0x40004000,0x00004040), CONST64(0x40004040,0x00004040),
  CONST64(0x40400000,0x00000000), CONST64(0x40400040,0x00000000), CONST64(0x40400000,0x00000040), CONST64(0x40400040,0x00000040),
  CONST64(0x40404000,0x00000000), CONST64(0x40404040,0x00000000), CONST64(0x40404000,0x00000040), CONST64(0x40404040,0x00000040),
  CONST64(0x40400000,0x00004000), CONST64(0x40400040,0x00004000), CONST64(0x40400000,0x00004040), CONST64(0x40400040,0x00004040),
  CONST64(0x40404000,0x00004000), CONST64(0x40404040,0x00004000), CONST64(0x40404000,0x00004040), CONST64(0x40404040,0x00004040),
  CONST64(0x40000000,0x00400000), CONST64(0x40000040,0x00400000), CONST64(0x40000000,0x00400040), CONST64(0x40000040,0x00400040),
  CONST64(0x40004000,0x00400000), CONST64(0x40004040,0x00400000), CONST64(0x40004000,0x00400040), CONST64(0x40004040,0x00400040),
  CONST64(0x40000000,0x00404000), CONST64(0x40000040,0x00404000), CONST64(0x40000000,0x00404040), CONST64(0x40000040,0x00404040),
  CONST64(0x40004000,0x00404000), CONST64(0x40004040,0x00404000), CONST64(0x40004000,0x00404040), CONST64(0x40004040,0x00404040),
  CONST64(0x40400000,0x00400000), CONST64(0x40400040,0x00400000), CONST64(0x40400000,0x00400040), CONST64(0x40400040,0x00400040),
  CONST64(0x40404000,0x00400000), CONST64(0x40404040,0x00400000), CONST64(0x40404000,0x00400040), CONST64(0x40404040,0x00400040),
  CONST64(0x40400000,0x00404000), CONST64(0x40400040,0x00404000), CONST64(0x40400000,0x00404040), CONST64(0x40400040,0x00404040),
  CONST64(0x40404000,0x00404000), CONST64(0x40404040,0x00404000), CONST64(0x40404000,0x00404040), CONST64(0x40404040,0x00404040),
  CONST64(0x00000000,0x40000000), CONST64(0x00000040,0x40000000), CONST64(0x00000000,0x40000040), CONST64(0x00000040,0x40000040),
  CONST64(0x00004000,0x40000000), CONST64(0x00004040,0x40000000), CONST64(0x00004000,0x40000040), CONST64(0x00004040,0x40000040),
  CONST64(0x00000000,0x40004000), CONST64(0x00000040,0x40004000), CONST64(0x00000000,0x40004040), CONST64(0x00000040,0x40004040),
  CONST64(0x00004000,0x40004000), CONST64(0x00004040,0x40004000), CONST64(0x00004000,0x40004040), CONST64(0x00004040,0x40004040),
  CONST64(0x00400000,0x40000000), CONST64(0x00400040,0x40000000), CONST64(0x00400000,0x40000040), CONST64(0x00400040,0x40000040),
  CONST64(0x00404000,0x40000000), CONST64(0x00404040,0x40000000), CONST64(0x00404000,0x40000040), CONST64(0x00404040,0x40000040),
  CONST64(0x00400000,0x40004000), CONST64(0x00400040,0x40004000), CONST64(0x00400000,0x40004040), CONST64(0x00400040,0x40004040),
  CONST64(0x00404000,0x40004000), CONST64(0x00404040,0x40004000), CONST64(0x00404000,0x40004040), CONST64(0x00404040,0x40004040),
  CONST64(0x00000000,0x40400000), CONST64(0x00000040,0x40400000), CONST64(0x00000000,0x40400040), CONST64(0x00000040,0x40400040),
  CONST64(0x00004000,0x40400000), CONST64(0x00004040,0x40400000), CONST64(0x00004000,0x40400040), CONST64(0x00004040,0x40400040),
  CONST64(0x00000000,0x40404000), CONST64(0x00000040,0x40404000), CONST64(0x00000000,0x40404040), CONST64(0x00000040,0x40404040),
  CONST64(0x00004000,0x40404000), CONST64(0x00004040,0x40404000), CONST64(0x00004000,0x40404040), CONST64(0x00004040,0x40404040),
  CONST64(0x00400000,0x40400000), CONST64(0x00400040,0x40400000), CONST64(0x00400000,0x40400040), CONST64(0x00400040,0x40400040),
  CONST64(0x00404000,0x40400000), CONST64(0x00404040,0x40400000), CONST64(0x00404000,0x40400040), CONST64(0x00404040,0x40400040),
  CONST64(0x00400000,0x40404000), CONST64(0x00400040,0x40404000), CONST64(0x00400000,0x40404040), CONST64(0x00400040,0x40404040),
  CONST64(0x00404000,0x40404000), CONST64(0x00404040,0x40404000), CONST64(0x00404000,0x40404040), CONST64(0x00404040,0x40404040),
  CONST64(0x40000000,0x40000000), CONST64(0x40000040,0x40000000), CONST64(0x40000000,0x40000040), CONST64(0x40000040,0x40000040),
  CONST64(0x40004000,0x40000000), CONST64(0x40004040,0x40000000), CONST64(0x40004000,0x40000040), CONST64(0x40004040,0x40000040),
  CONST64(0x40000000,0x40004000), CONST64(0x40000040,0x40004000), CONST64(0x40000000,0x40004040), CONST64(0x40000040,0x40004040),
  CONST64(0x40004000,0x40004000), CONST64(0x40004040,0x40004000), CONST64(0x40004000,0x40004040), CONST64(0x40004040,0x40004040),
  CONST64(0x40400000,0x40000000), CONST64(0x40400040,0x40000000), CONST64(0x40400000,0x40000040), CONST64(0x40400040,0x40000040),
  CONST64(0x40404000,0x40000000), CONST64(0x40404040,0x40000000), CONST64(0x40404000,0x40000040), CONST64(0x40404040,0x40000040),
  CONST64(0x40400000,0x40004000), CONST64(0x40400040,0x40004000), CONST64(0x40400000,0x40004040), CONST64(0x40400040,0x40004040),
  CONST64(0x40404000,0x40004000), CONST64(0x40404040,0x40004000), CONST64(0x40404000,0x40004040), CONST64(0x40404040,0x40004040),
  CONST64(0x40000000,0x40400000), CONST64(0x40000040,0x40400000), CONST64(0x40000000,0x40400040), CONST64(0x40000040,0x40400040),
  CONST64(0x40004000,0x40400000), CONST64(0x40004040,0x40400000), CONST64(0x40004000,0x40400040), CONST64(0x40004040,0x40400040),
  CONST64(0x40000000,0x40404000), CONST64(0x40000040,0x40404000), CONST64(0x40000000,0x40404040), CONST64(0x40000040,0x40404040),
  CONST64(0x40004000,0x40404000), CONST64(0x40004040,0x40404000), CONST64(0x40004000,0x40404040), CONST64(0x40004040,0x40404040),
  CONST64(0x40400000,0x40400000), CONST64(0x40400040,0x40400000), CONST64(0x40400000,0x40400040), CONST64(0x40400040,0x40400040),
  CONST64(0x40404000,0x40400000), CONST64(0x40404040,0x40400000), CONST64(0x40404000,0x40400040), CONST64(0x40404040,0x40400040),
  CONST64(0x40400000,0x40404000), CONST64(0x40400040,0x40404000), CONST64(0x40400000,0x40404040), CONST64(0x40400040,0x40404040),
  CONST64(0x40404000,0x40404000), CONST64(0x40404040,0x40404000), CONST64(0x40404000,0x40404040), CONST64(0x40404040,0x40404040)
  },
{ CONST64(0x00000000,0x00000000), CONST64(0x00000020,0x00000000), CONST64(0x00000000,0x00000020), CONST64(0x00000020,0x00000020),
  CONST64(0x00002000,0x00000000), CONST64(0x00002020,0x00000000), CONST64(0x00002000,0x00000020), CONST64(0x00002020,0x00000020),
  CONST64(0x00000000,0x00002000), CONST64(0x00000020,0x00002000), CONST64(0x00000000,0x00002020), CONST64(0x00000020,0x00002020),
  CONST64(0x00002000,0x00002000), CONST64(0x00002020,0x00002000), CONST64(0x00002000,0x00002020), CONST64(0x00002020,0x00002020),
  CONST64(0x00200000,0x00000000), CONST64(0x00200020,0x00000000), CONST64(0x00200000,0x00000020), CONST64(0x00200020,0x00000020),
  CONST64(0x00202000,0x00000000), CONST64(0x00202020,0x00000000), CONST64(0x00202000,0x00000020), CONST64(0x00202020,0x00000020),
  CONST64(0x00200000,0x00002000), CONST64(0x00200020,0x00002000), CONST64(0x00200000,0x00002020), CONST64(0x00200020,0x00002020),
  CONST64(0x00202000,0x00002000), CONST64(0x00202020,0x00002000), CONST64(0x00202000,0x00002020), CONST64(0x00202020,0x00002020),
  CONST64(0x00000000,0x00200000), CONST64(0x00000020,0x00200000), CONST64(0x00000000,0x00200020), CONST64(0x00000020,0x00200020),
  CONST64(0x00002000,0x00200000), CONST64(0x00002020,0x00200000), CONST64(0x00002000,0x00200020), CONST64(0x00002020,0x00200020),
  CONST64(0x00000000,0x00202000), CONST64(0x00000020,0x00202000), CONST64(0x00000000,0x00202020), CONST64(0x00000020,0x00202020),
  CONST64(0x00002000,0x00202000), CONST64(0x00002020,0x00202000), CONST64(0x00002000,0x00202020), CONST64(0x00002020,0x00202020),
  CONST64(0x00200000,0x00200000), CONST64(0x00200020,0x00200000), CONST64(0x00200000,0x00200020), CONST64(0x00200020,0x00200020),
  CONST64(0x00202000,0x00200000), CONST64(0x00202020,0x00200000), CONST64(0x00202000,0x00200020), CONST64(0x00202020,0x00200020),
  CONST64(0x00200000,0x00202000), CONST64(0x00200020,0x00202000), CONST64(0x00200000,0x00202020), CONST64(0x00200020,0x00202020),
  CONST64(0x00202000,0x00202000), CONST64(0x00202020,0x00202000), CONST64(0x00202000,0x00202020), CONST64(0x00202020,0x00202020),
  CONST64(0x20000000,0x00000000), CONST64(0x20000020,0x00000000), CONST64(0x20000000,0x00000020), CONST64(0x20000020,0x00000020),
  CONST64(0x20002000,0x00000000), CONST64(0x20002020,0x00000000), CONST64(0x20002000,0x00000020), CONST64(0x20002020,0x00000020),
  CONST64(0x20000000,0x00002000), CONST64(0x20000020,0x00002000), CONST64(0x20000000,0x00002020), CONST64(0x20000020,0x00002020),
  CONST64(0x20002000,0x00002000), CONST64(0x20002020,0x00002000), CONST64(0x20002000,0x00002020), CONST64(0x20002020,0x00002020),
  CONST64(0x20200000,0x00000000), CONST64(0x20200020,0x00000000), CONST64(0x20200000,0x00000020), CONST64(0x20200020,0x00000020),
  CONST64(0x20202000,0x00000000), CONST64(0x20202020,0x00000000), CONST64(0x20202000,0x00000020), CONST64(0x20202020,0x00000020),
  CONST64(0x20200000,0x00002000), CONST64(0x20200020,0x00002000), CONST64(0x20200000,0x00002020), CONST64(0x20200020,0x00002020),
  CONST64(0x20202000,0x00002000), CONST64(0x20202020,0x00002000), CONST64(0x20202000,0x00002020), CONST64(0x20202020,0x00002020),
  CONST64(0x20000000,0x00200000), CONST64(0x20000020,0x00200000), CONST64(0x20000000,0x00200020), CONST64(0x20000020,0x00200020),
  CONST64(0x20002000,0x00200000), CONST64(0x20002020,0x00200000), CONST64(0x20002000,0x00200020), CONST64(0x20002020,0x00200020),
  CONST64(0x20000000,0x00202000), CONST64(0x20000020,0x00202000), CONST64(0x20000000,0x00202020), CONST64(0x20000020,0x00202020),
  CONST64(0x20002000,0x00202000), CONST64(0x20002020,0x00202000), CONST64(0x20002000,0x00202020), CONST64(0x20002020,0x00202020),
  CONST64(0x20200000,0x00200000), CONST64(0x20200020,0x00200000), CONST64(0x20200000,0x00200020), CONST64(0x20200020,0x00200020),
  CONST64(0x20202000,0x00200000), CONST64(0x20202020,0x00200000), CONST64(0x20202000,0x00200020), CONST64(0x20202020,0x00200020),
  CONST64(0x20200000,0x00202000), CONST64(0x20200020,0x00202000), CONST64(0x20200000,0x00202020), CONST64(0x20200020,0x00202020),
  CONST64(0x20202000,0x00202000), CONST64(0x20202020,0x00202000), CONST64(0x20202000,0x00202020), CONST64(0x20202020,0x00202020),
  CONST64(0x00000000,0x20000000), CONST64(0x00000020,0x20000000), CONST64(0x00000000,0x20000020), CONST64(0x00000020,0x20000020),
  CONST64(0x00002000,0x20000000), CONST64(0x00002020,0x20000000), CONST64(0x00002000,0x20000020), CONST64(0x00002020,0x20000020),
  CONST64(0x00000000,0x20002000), CONST64(0x00000020,0x20002000), CONST64(0x00000000,0x20002020), CONST64(0x00000020,0x20002020),
  CONST64(0x00002000,0x20002000), CONST64(0x00002020,0x20002000), CONST64(0x00002000,0x20002020), CONST64(0x00002020,0x20002020),
  CONST64(0x00200000,0x20000000), CONST64(0x00200020,0x20000000), CONST64(0x00200000,0x20000020), CONST64(0x00200020,0x20000020),
  CONST64(0x00202000,0x20000000), CONST64(0x00202020,0x20000000), CONST64(0x00202000,0x20000020), CONST64(0x00202020,0x20000020),
  CONST64(0x00200000,0x20002000), CONST64(0x00200020,0x20002000), CONST64(0x00200000,0x20002020), CONST64(0x00200020,0x20002020),
  CONST64(0x00202000,0x20002000), CONST64(0x00202020,0x20002000), CONST64(0x00202000,0x20002020), CONST64(0x00202020,0x20002020),
  CONST64(0x00000000,0x20200000), CONST64(0x00000020,0x20200000), CONST64(0x00000000,0x20200020), CONST64(0x00000020,0x20200020),
  CONST64(0x00002000,0x20200000), CONST64(0x00002020,0x20200000), CONST64(0x00002000,0x20200020), CONST64(0x00002020,0x20200020),
  CONST64(0x00000000,0x20202000), CONST64(0x00000020,0x20202000), CONST64(0x00000000,0x20202020), CONST64(0x00000020,0x20202020),
  CONST64(0x00002000,0x20202000), CONST64(0x00002020,0x20202000), CONST64(0x00002000,0x20202020), CONST64(0x00002020,0x20202020),
  CONST64(0x00200000,0x20200000), CONST64(0x00200020,0x20200000), CONST64(0x00200000,0x20200020), CONST64(0x00200020,0x20200020),
  CONST64(0x00202000,0x20200000), CONST64(0x00202020,0x20200000), CONST64(0x00202000,0x20200020), CONST64(0x00202020,0x20200020),
  CONST64(0x00200000,0x20202000), CONST64(0x00200020,0x20202000), CONST64(0x00200000,0x20202020), CONST64(0x00200020,0x20202020),
  CONST64(0x00202000,0x20202000), CONST64(0x00202020,0x20202000), CONST64(0x00202000,0x20202020), CONST64(0x00202020,0x20202020),
  CONST64(0x20000000,0x20000000), CONST64(0x20000020,0x20000000), CONST64(0x20000000,0x20000020), CONST64(0x20000020,0x20000020),
  CONST64(0x20002000,0x20000000), CONST64(0x20002020,0x20000000), CONST64(0x20002000,0x20000020), CONST64(0x20002020,0x20000020),
  CONST64(0x20000000,0x20002000), CONST64(0x20000020,0x20002000), CONST64(0x20000000,0x20002020), CONST64(0x20000020,0x20002020),
  CONST64(0x20002000,0x20002000), CONST64(0x20002020,0x20002000), CONST64(0x20002000,0x20002020), CONST64(0x20002020,0x20002020),
  CONST64(0x20200000,0x20000000), CONST64(0x20200020,0x20000000), CONST64(0x20200000,0x20000020), CONST64(0x20200020,0x20000020),
  CONST64(0x20202000,0x20000000), CONST64(0x20202020,0x20000000), CONST64(0x20202000,0x20000020), CONST64(0x20202020,0x20000020),
  CONST64(0x20200000,0x20002000), CONST64(0x20200020,0x20002000), CONST64(0x20200000,0x20002020), CONST64(0x20200020,0x20002020),
  CONST64(0x20202000,0x20002000), CONST64(0x20202020,0x20002000), CONST64(0x20202000,0x20002020), CONST64(0x20202020,0x20002020),
  CONST64(0x20000000,0x20200000), CONST64(0x20000020,0x20200000), CONST64(0x20000000,0x20200020), CONST64(0x20000020,0x20200020),
  CONST64(0x20002000,0x20200000), CONST64(0x20002020,0x20200000), CONST64(0x20002000,0x20200020), CONST64(0x20002020,0x20200020),
  CONST64(0x20000000,0x20202000), CONST64(0x20000020,0x20202000), CONST64(0x20000000,0x20202020), CONST64(0x20000020,0x20202020),
  CONST64(0x20002000,0x20202000), CONST64(0x20002020,0x20202000), CONST64(0x20002000,0x20202020), CONST64(0x20002020,0x20202020),
  CONST64(0x20200000,0x20200000), CONST64(0x20200020,0x20200000), CONST64(0x20200000,0x20200020), CONST64(0x20200020,0x20200020),
  CONST64(0x20202000,0x20200000), CONST64(0x20202020,0x20200000), CONST64(0x20202000,0x20200020), CONST64(0x20202020,0x20200020),
  CONST64(0x20200000,0x20202000), CONST64(0x20200020,0x20202000), CONST64(0x20200000,0x20202020), CONST64(0x20200020,0x20202020),
  CONST64(0x20202000,0x20202000), CONST64(0x20202020,0x20202000), CONST64(0x20202000,0x20202020), CONST64(0x20202020,0x20202020)
  }};

static const ulong64 des_fp[8][256] = {

{ CONST64(0x00000000,0x00000000), CONST64(0x00000080,0x00000000), CONST64(0x00000000,0x02000000), CONST64(0x00000080,0x02000000),
  CONST64(0x00000000,0x00020000), CONST64(0x00000080,0x00020000), CONST64(0x00000000,0x02020000), CONST64(0x00000080,0x02020000),
  CONST64(0x00000000,0x00000200), CONST64(0x00000080,0x00000200), CONST64(0x00000000,0x02000200), CONST64(0x00000080,0x02000200),
  CONST64(0x00000000,0x00020200), CONST64(0x00000080,0x00020200), CONST64(0x00000000,0x02020200), CONST64(0x00000080,0x02020200),
  CONST64(0x00000000,0x00000002), CONST64(0x00000080,0x00000002), CONST64(0x00000000,0x02000002), CONST64(0x00000080,0x02000002),
  CONST64(0x00000000,0x00020002), CONST64(0x00000080,0x00020002), CONST64(0x00000000,0x02020002), CONST64(0x00000080,0x02020002),
  CONST64(0x00000000,0x00000202), CONST64(0x00000080,0x00000202), CONST64(0x00000000,0x02000202), CONST64(0x00000080,0x02000202),
  CONST64(0x00000000,0x00020202), CONST64(0x00000080,0x00020202), CONST64(0x00000000,0x02020202), CONST64(0x00000080,0x02020202),
  CONST64(0x02000000,0x00000000), CONST64(0x02000080,0x00000000), CONST64(0x02000000,0x02000000), CONST64(0x02000080,0x02000000),
  CONST64(0x02000000,0x00020000), CONST64(0x02000080,0x00020000), CONST64(0x02000000,0x02020000), CONST64(0x02000080,0x02020000),
  CONST64(0x02000000,0x00000200), CONST64(0x02000080,0x00000200), CONST64(0x02000000,0x02000200), CONST64(0x02000080,0x02000200),
  CONST64(0x02000000,0x00020200), CONST64(0x02000080,0x00020200), CONST64(0x02000000,0x02020200), CONST64(0x02000080,0x02020200),
  CONST64(0x02000000,0x00000002), CONST64(0x02000080,0x00000002), CONST64(0x02000000,0x02000002), CONST64(0x02000080,0x02000002),
  CONST64(0x02000000,0x00020002), CONST64(0x02000080,0x00020002), CONST64(0x02000000,0x02020002), CONST64(0x02000080,0x02020002),
  CONST64(0x02000000,0x00000202), CONST64(0x02000080,0x00000202), CONST64(0x02000000,0x02000202), CONST64(0x02000080,0x02000202),
  CONST64(0x02000000,0x00020202), CONST64(0x02000080,0x00020202), CONST64(0x02000000,0x02020202), CONST64(0x02000080,0x02020202),
  CONST64(0x00020000,0x00000000), CONST64(0x00020080,0x00000000), CONST64(0x00020000,0x02000000), CONST64(0x00020080,0x02000000),
  CONST64(0x00020000,0x00020000), CONST64(0x00020080,0x00020000), CONST64(0x00020000,0x02020000), CONST64(0x00020080,0x02020000),
  CONST64(0x00020000,0x00000200), CONST64(0x00020080,0x00000200), CONST64(0x00020000,0x02000200), CONST64(0x00020080,0x02000200),
  CONST64(0x00020000,0x00020200), CONST64(0x00020080,0x00020200), CONST64(0x00020000,0x02020200), CONST64(0x00020080,0x02020200),
  CONST64(0x00020000,0x00000002), CONST64(0x00020080,0x00000002), CONST64(0x00020000,0x02000002), CONST64(0x00020080,0x02000002),
  CONST64(0x00020000,0x00020002), CONST64(0x00020080,0x00020002), CONST64(0x00020000,0x02020002), CONST64(0x00020080,0x02020002),
  CONST64(0x00020000,0x00000202), CONST64(0x00020080,0x00000202), CONST64(0x00020000,0x02000202), CONST64(0x00020080,0x02000202),
  CONST64(0x00020000,0x00020202), CONST64(0x00020080,0x00020202), CONST64(0x00020000,0x02020202), CONST64(0x00020080,0x02020202),
  CONST64(0x02020000,0x00000000), CONST64(0x02020080,0x00000000), CONST64(0x02020000,0x02000000), CONST64(0x02020080,0x02000000),
  CONST64(0x02020000,0x00020000), CONST64(0x02020080,0x00020000), CONST64(0x02020000,0x02020000), CONST64(0x02020080,0x02020000),
  CONST64(0x02020000,0x00000200), CONST64(0x02020080,0x00000200), CONST64(0x02020000,0x02000200), CONST64(0x02020080,0x02000200),
  CONST64(0x02020000,0x00020200), CONST64(0x02020080,0x00020200), CONST64(0x02020000,0x02020200), CONST64(0x02020080,0x02020200),
  CONST64(0x02020000,0x00000002), CONST64(0x02020080,0x00000002), CONST64(0x02020000,0x02000002), CONST64(0x02020080,0x02000002),
  CONST64(0x02020000,0x00020002), CONST64(0x02020080,0x00020002), CONST64(0x02020000,0x02020002), CONST64(0x02020080,0x02020002),
  CONST64(0x02020000,0x00000202), CONST64(0x02020080,0x00000202), CONST64(0x02020000,0x02000202), CONST64(0x02020080,0x02000202),
  CONST64(0x02020000,0x00020202), CONST64(0x02020080,0x00020202), CONST64(0x02020000,0x02020202), CONST64(0x02020080,0x02020202),
  CONST64(0x00000200,0x00000000), CONST64(0x00000280,0x00000000), CONST64(0x00000200,0x02000000), CONST64(0x00000280,0x02000000),
  CONST64(0x00000200,0x00020000), CONST64(0x00000280,0x00020000), CONST64(0x00000200,0x02020000), CONST64(0x00000280,0x02020000),
  CONST64(0x00000200,0x00000200), CONST64(0x00000280,0x00000200), CONST64(0x00000200,0x02000200), CONST64(0x00000280,0x02000200),
  CONST64(0x00000200,0x00020200), CONST64(0x00000280,0x00020200), CONST64(0x00000200,0x02020200), CONST64(0x00000280,0x02020200),
  CONST64(0x00000200,0x00000002), CONST64(0x00000280,0x00000002), CONST64(0x00000200,0x02000002), CONST64(0x00000280,0x02000002),
  CONST64(0x00000200,0x00020002), CONST64(0x00000280,0x00020002), CONST64(0x00000200,0x02020002), CONST64(0x00000280,0x02020002),
  CONST64(0x00000200,0x00000202), CONST64(0x00000280,0x00000202), CONST64(0x00000200,0x02000202), CONST64(0x00000280,0x02000202),
  CONST64(0x00000200,0x00020202), CONST64(0x00000280,0x00020202), CONST64(0x00000200,0x02020202), CONST64(0x00000280,0x02020202),
  CONST64(0x02000200,0x00000000), CONST64(0x02000280,0x00000000), CONST64(0x02000200,0x02000000), CONST64(0x02000280,0x02000000),
  CONST64(0x02000200,0x00020000), CONST64(0x02000280,0x00020000), CONST64(0x02000200,0x02020000), CONST64(0x02000280,0x02020000),
  CONST64(0x02000200,0x00000200), CONST64(0x02000280,0x00000200), CONST64(0x02000200,0x02000200), CONST64(0x02000280,0x02000200),
  CONST64(0x02000200,0x00020200), CONST64(0x02000280,0x00020200), CONST64(0x02000200,0x02020200), CONST64(0x02000280,0x02020200),
  CONST64(0x02000200,0x00000002), CONST64(0x02000280,0x00000002), CONST64(0x02000200,0x02000002), CONST64(0x02000280,0x02000002),
  CONST64(0x02000200,0x00020002), CONST64(0x02000280,0x00020002), CONST64(0x02000200,0x02020002), CONST64(0x02000280,0x02020002),
  CONST64(0x02000200,0x00000202), CONST64(0x02000280,0x00000202), CONST64(0x02000200,0x02000202), CONST64(0x02000280,0x02000202),
  CONST64(0x02000200,0x00020202), CONST64(0x02000280,0x00020202), CONST64(0x02000200,0x02020202), CONST64(0x02000280,0x02020202),
  CONST64(0x00020200,0x00000000), CONST64(0x00020280,0x00000000), CONST64(0x00020200,0x02000000), CONST64(0x00020280,0x02000000),
  CONST64(0x00020200,0x00020000), CONST64(0x00020280,0x00020000), CONST64(0x00020200,0x02020000), CONST64(0x00020280,0x02020000),
  CONST64(0x00020200,0x00000200), CONST64(0x00020280,0x00000200), CONST64(0x00020200,0x02000200), CONST64(0x00020280,0x02000200),
  CONST64(0x00020200,0x00020200), CONST64(0x00020280,0x00020200), CONST64(0x00020200,0x02020200), CONST64(0x00020280,0x02020200),
  CONST64(0x00020200,0x00000002), CONST64(0x00020280,0x00000002), CONST64(0x00020200,0x02000002), CONST64(0x00020280,0x02000002),
  CONST64(0x00020200,0x00020002), CONST64(0x00020280,0x00020002), CONST64(0x00020200,0x02020002), CONST64(0x00020280,0x02020002),
  CONST64(0x00020200,0x00000202), CONST64(0x00020280,0x00000202), CONST64(0x00020200,0x02000202), CONST64(0x00020280,0x02000202),
  CONST64(0x00020200,0x00020202), CONST64(0x00020280,0x00020202), CONST64(0x00020200,0x02020202), CONST64(0x00020280,0x02020202),
  CONST64(0x02020200,0x00000000), CONST64(0x02020280,0x00000000), CONST64(0x02020200,0x02000000), CONST64(0x02020280,0x02000000),
  CONST64(0x02020200,0x00020000), CONST64(0x02020280,0x00020000), CONST64(0x02020200,0x02020000), CONST64(0x02020280,0x02020000),
  CONST64(0x02020200,0x00000200), CONST64(0x02020280,0x00000200), CONST64(0x02020200,0x02000200), CONST64(0x02020280,0x02000200),
  CONST64(0x02020200,0x00020200), CONST64(0x02020280,0x00020200), CONST64(0x02020200,0x02020200), CONST64(0x02020280,0x02020200),
  CONST64(0x02020200,0x00000002), CONST64(0x02020280,0x00000002), CONST64(0x02020200,0x02000002), CONST64(0x02020280,0x02000002),
  CONST64(0x02020200,0x00020002), CONST64(0x02020280,0x00020002), CONST64(0x02020200,0x02020002), CONST64(0x02020280,0x02020002),
  CONST64(0x02020200,0x00000202), CONST64(0x02020280,0x00000202), CONST64(0x02020200,0x02000202), CONST64(0x02020280,0x02000202),
  CONST64(0x02020200,0x00020202), CONST64(0x02020280,0x00020202), CONST64(0x02020200,0x02020202), CONST64(0x02020280,0x02020202)
  },
{ CONST64(0x00000000,0x00000000), CONST64(0x00000002,0x00000000), CONST64(0x00000000,0x08000000), CONST64(0x00000002,0x08000000),
  CONST64(0x00000000,0x00080000), CONST64(0x00000002,0x00080000), CONST64(0x00000000,0x08080000), CONST64(0x00000002,0x08080000),
  CONST64(0x00000000,0x00000800), CONST64(0x00000002,0x00000800), CONST64(0x00000000,0x08000800), CONST64(0x00000002,0x08000800),
  CONST64(0x00000000,0x00080800), CONST64(0x00000002,0x00080800), CONST64(0x00000000,0x08080800), CONST64(0x00000002,0x08080800),
  CONST64(0x00000000,0x00000008), CONST64(0x00000002,0x00000008), CONST64(0x00000000,0x08000008), CONST64(0x00000002,0x08000008),
  CONST64(0x00000000,0x00080008), CONST64(0x00000002,0x00080008), CONST64(0x00000000,0x08080008), CONST64(0x00000002,0x08080008),
  CONST64(0x00000000,0x00000808), CONST64(0x00000002,0x00000808), CONST64(0x00000000,0x08000808), CONST64(0x00000002,0x08000808),
  CONST64(0x00000000,0x00080808), CONST64(0x00000002,0x00080808), CONST64(0x00000000,0x08080808), CONST64(0x00000002,0x08080808),
  CONST64(0x08000000,0x00000000), CONST64(0x08000002,0x00000000), CONST64(0x08000000,0x08000000), CONST64(0x08000002,0x08000000),
  CONST64(0x08000000,0x00080000), CONST64(0x08000002,0x00080000), CONST64(0x08000000,0x08080000), CONST64(0x08000002,0x08080000),
  CONST64(0x08000000,0x00000800), CONST64(0x08000002,0x00000800), CONST64(0x08000000,0x08000800), CONST64(0x08000002,0x08000800),
  CONST64(0x08000000,0x00080800), CONST64(0x08000002,0x00080800), CONST64(0x08000000,0x08080800), CONST64(0x08000002,0x08080800),
  CONST64(0x08000000,0x00000008), CONST64(0x08000002,0x00000008), CONST64(0x08000000,0x08000008), CONST64(0x08000002,0x08000008),
  CONST64(0x08000000,0x00080008), CONST64(0x08000002,0x00080008), CONST64(0x08000000,0x08080008), CONST64(0x08000002,0x08080008),
  CONST64(0x08000000,0x00000808), CONST64(0x08000002,0x00000808), CONST64(0x08000000,0x08000808), CONST64(0x08000002,0x08000808),
  CONST64(0x08000000,0x00080808), CONST64(0x08000002,0x00080808), CONST64(0x08000000,0x08080808), CONST64(0x08000002,0x08080808),
  CONST64(0x00080000,0x00000000), CONST64(0x00080002,0x00000000), CONST64(0x00080000,0x08000000), CONST64(0x00080002,0x08000000),
  CONST64(0x00080000,0x00080000), CONST64(0x00080002,0x00080000), CONST64(0x00080000,0x08080000), CONST64(0x00080002,0x08080000),
  CONST64(0x00080000,0x00000800), CONST64(0x00080002,0x00000800), CONST64(0x00080000,0x08000800), CONST64(0x00080002,0x08000800),
  CONST64(0x00080000,0x00080800), CONST64(0x00080002,0x00080800), CONST64(0x00080000,0x08080800), CONST64(0x00080002,0x08080800),
  CONST64(0x00080000,0x00000008), CONST64(0x00080002,0x00000008), CONST64(0x00080000,0x08000008), CONST64(0x00080002,0x08000008),
  CONST64(0x00080000,0x00080008), CONST64(0x00080002,0x00080008), CONST64(0x00080000,0x08080008), CONST64(0x00080002,0x08080008),
  CONST64(0x00080000,0x00000808), CONST64(0x00080002,0x00000808), CONST64(0x00080000,0x08000808), CONST64(0x00080002,0x08000808),
  CONST64(0x00080000,0x00080808), CONST64(0x00080002,0x00080808), CONST64(0x00080000,0x08080808), CONST64(0x00080002,0x08080808),
  CONST64(0x08080000,0x00000000), CONST64(0x08080002,0x00000000), CONST64(0x08080000,0x08000000), CONST64(0x08080002,0x08000000),
  CONST64(0x08080000,0x00080000), CONST64(0x08080002,0x00080000), CONST64(0x08080000,0x08080000), CONST64(0x08080002,0x08080000),
  CONST64(0x08080000,0x00000800), CONST64(0x08080002,0x00000800), CONST64(0x08080000,0x08000800), CONST64(0x08080002,0x08000800),
  CONST64(0x08080000,0x00080800), CONST64(0x08080002,0x00080800), CONST64(0x08080000,0x08080800), CONST64(0x08080002,0x08080800),
  CONST64(0x08080000,0x00000008), CONST64(0x08080002,0x00000008), CONST64(0x08080000,0x08000008), CONST64(0x08080002,0x08000008),
  CONST64(0x08080000,0x00080008), CONST64(0x08080002,0x00080008), CONST64(0x08080000,0x08080008), CONST64(0x08080002,0x08080008),
  CONST64(0x08080000,0x00000808), CONST64(0x08080002,0x00000808), CONST64(0x08080000,0x08000808), CONST64(0x08080002,0x08000808),
  CONST64(0x08080000,0x00080808), CONST64(0x08080002,0x00080808), CONST64(0x08080000,0x08080808), CONST64(0x08080002,0x08080808),
  CONST64(0x00000800,0x00000000), CONST64(0x00000802,0x00000000), CONST64(0x00000800,0x08000000), CONST64(0x00000802,0x08000000),
  CONST64(0x00000800,0x00080000), CONST64(0x00000802,0x00080000), CONST64(0x00000800,0x08080000), CONST64(0x00000802,0x08080000),
  CONST64(0x00000800,0x00000800), CONST64(0x00000802,0x00000800), CONST64(0x00000800,0x08000800), CONST64(0x00000802,0x08000800),
  CONST64(0x00000800,0x00080800), CONST64(0x00000802,0x00080800), CONST64(0x00000800,0x08080800), CONST64(0x00000802,0x08080800),
  CONST64(0x00000800,0x00000008), CONST64(0x00000802,0x00000008), CONST64(0x00000800,0x08000008), CONST64(0x00000802,0x08000008),
  CONST64(0x00000800,0x00080008), CONST64(0x00000802,0x00080008), CONST64(0x00000800,0x08080008), CONST64(0x00000802,0x08080008),
  CONST64(0x00000800,0x00000808), CONST64(0x00000802,0x00000808), CONST64(0x00000800,0x08000808), CONST64(0x00000802,0x08000808),
  CONST64(0x00000800,0x00080808), CONST64(0x00000802,0x00080808), CONST64(0x00000800,0x08080808), CONST64(0x00000802,0x08080808),
  CONST64(0x08000800,0x00000000), CONST64(0x08000802,0x00000000), CONST64(0x08000800,0x08000000), CONST64(0x08000802,0x08000000),
  CONST64(0x08000800,0x00080000), CONST64(0x08000802,0x00080000), CONST64(0x08000800,0x08080000), CONST64(0x08000802,0x08080000),
  CONST64(0x08000800,0x00000800), CONST64(0x08000802,0x00000800), CONST64(0x08000800,0x08000800), CONST64(0x08000802,0x08000800),
  CONST64(0x08000800,0x00080800), CONST64(0x08000802,0x00080800), CONST64(0x08000800,0x08080800), CONST64(0x08000802,0x08080800),
  CONST64(0x08000800,0x00000008), CONST64(0x08000802,0x00000008), CONST64(0x08000800,0x08000008), CONST64(0x08000802,0x08000008),
  CONST64(0x08000800,0x00080008), CONST64(0x08000802,0x00080008), CONST64(0x08000800,0x08080008), CONST64(0x08000802,0x08080008),
  CONST64(0x08000800,0x00000808), CONST64(0x08000802,0x00000808), CONST64(0x08000800,0x08000808), CONST64(0x08000802,0x08000808),
  CONST64(0x08000800,0x00080808), CONST64(0x08000802,0x00080808), CONST64(0x08000800,0x08080808), CONST64(0x08000802,0x08080808),
  CONST64(0x00080800,0x00000000), CONST64(0x00080802,0x00000000), CONST64(0x00080800,0x08000000), CONST64(0x00080802,0x08000000),
  CONST64(0x00080800,0x00080000), CONST64(0x00080802,0x00080000), CONST64(0x00080800,0x08080000), CONST64(0x00080802,0x08080000),
  CONST64(0x00080800,0x00000800), CONST64(0x00080802,0x00000800), CONST64(0x00080800,0x08000800), CONST64(0x00080802,0x08000800),
  CONST64(0x00080800,0x00080800), CONST64(0x00080802,0x00080800), CONST64(0x00080800,0x08080800), CONST64(0x00080802,0x08080800),
  CONST64(0x00080800,0x00000008), CONST64(0x00080802,0x00000008), CONST64(0x00080800,0x08000008), CONST64(0x00080802,0x08000008),
  CONST64(0x00080800,0x00080008), CONST64(0x00080802,0x00080008), CONST64(0x00080800,0x08080008), CONST64(0x00080802,0x08080008),
  CONST64(0x00080800,0x00000808), CONST64(0x00080802,0x00000808), CONST64(0x00080800,0x08000808), CONST64(0x00080802,0x08000808),
  CONST64(0x00080800,0x00080808), CONST64(0x00080802,0x00080808), CONST64(0x00080800,0x08080808), CONST64(0x00080802,0x08080808),
  CONST64(0x08080800,0x00000000), CONST64(0x08080802,0x00000000), CONST64(0x08080800,0x08000000), CONST64(0x08080802,0x08000000),
  CONST64(0x08080800,0x00080000), CONST64(0x08080802,0x00080000), CONST64(0x08080800,0x08080000), CONST64(0x08080802,0x08080000),
  CONST64(0x08080800,0x00000800), CONST64(0x08080802,0x00000800), CONST64(0x08080800,0x08000800), CONST64(0x08080802,0x08000800),
  CONST64(0x08080800,0x00080800), CONST64(0x08080802,0x00080800), CONST64(0x08080800,0x08080800), CONST64(0x08080802,0x08080800),
  CONST64(0x08080800,0x00000008), CONST64(0x08080802,0x00000008), CONST64(0x08080800,0x08000008), CONST64(0x08080802,0x08000008),
  CONST64(0x08080800,0x00080008), CONST64(0x08080802,0x00080008), CONST64(0x08080800,0x08080008), CONST64(0x08080802,0x08080008),
  CONST64(0x08080800,0x00000808), CONST64(0x08080802,0x00000808), CONST64(0x08080800,0x08000808), CONST64(0x08080802,0x08000808),
  CONST64(0x08080800,0x00080808), CONST64(0x08080802,0x00080808), CONST64(0x08080800,0x08080808), CONST64(0x08080802,0x08080808)
  },
{ CONST64(0x00000000,0x00000000), CONST64(0x00000008,0x00000000), CONST64(0x00000000,0x20000000), CONST64(0x00000008,0x20000000),
  CONST64(0x00000000,0x00200000), CONST64(0x00000008,0x00200000), CONST64(0x00000000,0x20200000), CONST64(0x00000008,0x20200000),
  CONST64(0x00000000,0x00002000), CONST64(0x00000008,0x00002000), CONST64(0x00000000,0x20002000), CONST64(0x00000008,0x20002000),
  CONST64(0x00000000,0x00202000), CONST64(0x00000008,0x00202000), CONST64(0x00000000,0x20202000), CONST64(0x00000008,0x20202000),
  CONST64(0x00000000,0x00000020), CONST64(0x00000008,0x00000020), CONST64(0x00000000,0x20000020), CONST64(0x00000008,0x20000020),
  CONST64(0x00000000,0x00200020), CONST64(0x00000008,0x00200020), CONST64(0x00000000,0x20200020), CONST64(0x00000008,0x20200020),
  CONST64(0x00000000,0x00002020), CONST64(0x00000008,0x00002020), CONST64(0x00000000,0x20002020), CONST64(0x00000008,0x20002020),
  CONST64(0x00000000,0x00202020), CONST64(0x00000008,0x00202020), CONST64(0x00000000,0x20202020), CONST64(0x00000008,0x20202020),
  CONST64(0x20000000,0x00000000), CONST64(0x20000008,0x00000000), CONST64(0x20000000,0x20000000), CONST64(0x20000008,0x20000000),
  CONST64(0x20000000,0x00200000), CONST64(0x20000008,0x00200000), CONST64(0x20000000,0x20200000), CONST64(0x20000008,0x20200000),
  CONST64(0x20000000,0x00002000), CONST64(0x20000008,0x00002000), CONST64(0x20000000,0x20002000), CONST64(0x20000008,0x20002000),
  CONST64(0x20000000,0x00202000), CONST64(0x20000008,0x00202000), CONST64(0x20000000,0x20202000), CONST64(0x20000008,0x20202000),
  CONST64(0x20000000,0x00000020), CONST64(0x20000008,0x00000020), CONST64(0x20000000,0x20000020), CONST64(0x20000008,0x20000020),
  CONST64(0x20000000,0x00200020), CONST64(0x20000008,0x00200020), CONST64(0x20000000,0x20200020), CONST64(0x20000008,0x20200020),
  CONST64(0x20000000,0x00002020), CONST64(0x20000008,0x00002020), CONST64(0x20000000,0x20002020), CONST64(0x20000008,0x20002020),
  CONST64(0x20000000,0x00202020), CONST64(0x20000008,0x00202020), CONST64(0x20000000,0x20202020), CONST64(0x20000008,0x20202020),
  CONST64(0x00200000,0x00000000), CONST64(0x00200008,0x00000000), CONST64(0x00200000,0x20000000), CONST64(0x00200008,0x20000000),
  CONST64(0x00200000,0x00200000), CONST64(0x00200008,0x00200000), CONST64(0x00200000,0x20200000), CONST64(0x00200008,0x20200000),
  CONST64(0x00200000,0x00002000), CONST64(0x00200008,0x00002000), CONST64(0x00200000,0x20002000), CONST64(0x00200008,0x20002000),
  CONST64(0x00200000,0x00202000), CONST64(0x00200008,0x00202000), CONST64(0x00200000,0x20202000), CONST64(0x00200008,0x20202000),
  CONST64(0x00200000,0x00000020), CONST64(0x00200008,0x00000020), CONST64(0x00200000,0x20000020), CONST64(0x00200008,0x20000020),
  CONST64(0x00200000,0x00200020), CONST64(0x00200008,0x00200020), CONST64(0x00200000,0x20200020), CONST64(0x00200008,0x20200020),
  CONST64(0x00200000,0x00002020), CONST64(0x00200008,0x00002020), CONST64(0x00200000,0x20002020), CONST64(0x00200008,0x20002020),
  CONST64(0x00200000,0x00202020), CONST64(0x00200008,0x00202020), CONST64(0x00200000,0x20202020), CONST64(0x00200008,0x20202020),
  CONST64(0x20200000,0x00000000), CONST64(0x20200008,0x00000000), CONST64(0x20200000,0x20000000), CONST64(0x20200008,0x20000000),
  CONST64(0x20200000,0x00200000), CONST64(0x20200008,0x00200000), CONST64(0x20200000,0x20200000), CONST64(0x20200008,0x20200000),
  CONST64(0x20200000,0x00002000), CONST64(0x20200008,0x00002000), CONST64(0x20200000,0x20002000), CONST64(0x20200008,0x20002000),
  CONST64(0x20200000,0x00202000), CONST64(0x20200008,0x00202000), CONST64(0x20200000,0x20202000), CONST64(0x20200008,0x20202000),
  CONST64(0x20200000,0x00000020), CONST64(0x20200008,0x00000020), CONST64(0x20200000,0x20000020), CONST64(0x20200008,0x20000020),
  CONST64(0x20200000,0x00200020), CONST64(0x20200008,0x00200020), CONST64(0x20200000,0x20200020), CONST64(0x20200008,0x20200020),
  CONST64(0x20200000,0x00002020), CONST64(0x20200008,0x00002020), CONST64(0x20200000,0x20002020), CONST64(0x20200008,0x20002020),
  CONST64(0x20200000,0x00202020), CONST64(0x20200008,0x00202020), CONST64(0x20200000,0x20202020), CONST64(0x20200008,0x20202020),
  CONST64(0x00002000,0x00000000), CONST64(0x00002008,0x00000000), CONST64(0x00002000,0x20000000), CONST64(0x00002008,0x20000000),
  CONST64(0x00002000,0x00200000), CONST64(0x00002008,0x00200000), CONST64(0x00002000,0x20200000), CONST64(0x00002008,0x20200000),
  CONST64(0x00002000,0x00002000), CONST64(0x00002008,0x00002000), CONST64(0x00002000,0x20002000), CONST64(0x00002008,0x20002000),
  CONST64(0x00002000,0x00202000), CONST64(0x00002008,0x00202000), CONST64(0x00002000,0x20202000), CONST64(0x00002008,0x20202000),
  CONST64(0x00002000,0x00000020), CONST64(0x00002008,0x00000020), CONST64(0x00002000,0x20000020), CONST64(0x00002008,0x20000020),
  CONST64(0x00002000,0x00200020), CONST64(0x00002008,0x00200020), CONST64(0x00002000,0x20200020), CONST64(0x00002008,0x20200020),
  CONST64(0x00002000,0x00002020), CONST64(0x00002008,0x00002020), CONST64(0x00002000,0x20002020), CONST64(0x00002008,0x20002020),
  CONST64(0x00002000,0x00202020), CONST64(0x00002008,0x00202020), CONST64(0x00002000,0x20202020), CONST64(0x00002008,0x20202020),
  CONST64(0x20002000,0x00000000), CONST64(0x20002008,0x00000000), CONST64(0x20002000,0x20000000), CONST64(0x20002008,0x20000000),
  CONST64(0x20002000,0x00200000), CONST64(0x20002008,0x00200000), CONST64(0x20002000,0x20200000), CONST64(0x20002008,0x20200000),
  CONST64(0x20002000,0x00002000), CONST64(0x20002008,0x00002000), CONST64(0x20002000,0x20002000), CONST64(0x20002008,0x20002000),
  CONST64(0x20002000,0x00202000), CONST64(0x20002008,0x00202000), CONST64(0x20002000,0x20202000), CONST64(0x20002008,0x20202000),
  CONST64(0x20002000,0x00000020), CONST64(0x20002008,0x00000020), CONST64(0x20002000,0x20000020), CONST64(0x20002008,0x20000020),
  CONST64(0x20002000,0x00200020), CONST64(0x20002008,0x00200020), CONST64(0x20002000,0x20200020), CONST64(0x20002008,0x20200020),
  CONST64(0x20002000,0x00002020), CONST64(0x20002008,0x00002020), CONST64(0x20002000,0x20002020), CONST64(0x20002008,0x20002020),
  CONST64(0x20002000,0x00202020), CONST64(0x20002008,0x00202020), CONST64(0x20002000,0x20202020), CONST64(0x20002008,0x20202020),
  CONST64(0x00202000,0x00000000), CONST64(0x00202008,0x00000000), CONST64(0x00202000,0x20000000), CONST64(0x00202008,0x20000000),
  CONST64(0x00202000,0x00200000), CONST64(0x00202008,0x00200000), CONST64(0x00202000,0x20200000), CONST64(0x00202008,0x20200000),
  CONST64(0x00202000,0x00002000), CONST64(0x00202008,0x00002000), CONST64(0x00202000,0x20002000), CONST64(0x00202008,0x20002000),
  CONST64(0x00202000,0x00202000), CONST64(0x00202008,0x00202000), CONST64(0x00202000,0x20202000), CONST64(0x00202008,0x20202000),
  CONST64(0x00202000,0x00000020), CONST64(0x00202008,0x00000020), CONST64(0x00202000,0x20000020), CONST64(0x00202008,0x20000020),
  CONST64(0x00202000,0x00200020), CONST64(0x00202008,0x00200020), CONST64(0x00202000,0x20200020), CONST64(0x00202008,0x20200020),
  CONST64(0x00202000,0x00002020), CONST64(0x00202008,0x00002020), CONST64(0x00202000,0x20002020), CONST64(0x00202008,0x20002020),
  CONST64(0x00202000,0x00202020), CONST64(0x00202008,0x00202020), CONST64(0x00202000,0x20202020), CONST64(0x00202008,0x20202020),
  CONST64(0x20202000,0x00000000), CONST64(0x20202008,0x00000000), CONST64(0x20202000,0x20000000), CONST64(0x20202008,0x20000000),
  CONST64(0x20202000,0x00200000), CONST64(0x20202008,0x00200000), CONST64(0x20202000,0x20200000), CONST64(0x20202008,0x20200000),
  CONST64(0x20202000,0x00002000), CONST64(0x20202008,0x00002000), CONST64(0x20202000,0x20002000), CONST64(0x20202008,0x20002000),
  CONST64(0x20202000,0x00202000), CONST64(0x20202008,0x00202000), CONST64(0x20202000,0x20202000), CONST64(0x20202008,0x20202000),
  CONST64(0x20202000,0x00000020), CONST64(0x20202008,0x00000020), CONST64(0x20202000,0x20000020), CONST64(0x20202008,0x20000020),
  CONST64(0x20202000,0x00200020), CONST64(0x20202008,0x00200020), CONST64(0x20202000,0x20200020), CONST64(0x20202008,0x20200020),
  CONST64(0x20202000,0x00002020), CONST64(0x20202008,0x00002020), CONST64(0x20202000,0x20002020), CONST64(0x20202008,0x20002020),
  CONST64(0x20202000,0x00202020), CONST64(0x20202008,0x00202020), CONST64(0x20202000,0x20202020), CONST64(0x20202008,0x20202020)
  },
{ CONST64(0x00000000,0x00000000), CONST64(0x00000020,0x00000000), CONST64(0x00000000,0x80000000), CONST64(0x00000020,0x80000000),
  CONST64(0x00000000,0x00800000), CONST64(0x00000020,0x00800000), CONST64(0x00000000,0x80800000), CONST64(0x00000020,0x80800000),
  CONST64(0x00000000,0x00008000), CONST64(0x00000020,0x00008000), CONST64(0x00000000,0x80008000), CONST64(0x00000020,0x80008000),
  CONST64(0x00000000,0x00808000), CONST64(0x00000020,0x00808000), CONST64(0x00000000,0x80808000), CONST64(0x00000020,0x80808000),
  CONST64(0x00000000,0x00000080), CONST64(0x00000020,0x00000080), CONST64(0x00000000,0x80000080), CONST64(0x00000020,0x80000080),
  CONST64(0x00000000,0x00800080), CONST64(0x00000020,0x00800080), CONST64(0x00000000,0x80800080), CONST64(0x00000020,0x80800080),
  CONST64(0x00000000,0x00008080), CONST64(0x00000020,0x00008080), CONST64(0x00000000,0x80008080), CONST64(0x00000020,0x80008080),
  CONST64(0x00000000,0x00808080), CONST64(0x00000020,0x00808080), CONST64(0x00000000,0x80808080), CONST64(0x00000020,0x80808080),
  CONST64(0x80000000,0x00000000), CONST64(0x80000020,0x00000000), CONST64(0x80000000,0x80000000), CONST64(0x80000020,0x80000000),
  CONST64(0x80000000,0x00800000), CONST64(0x80000020,0x00800000), CONST64(0x80000000,0x80800000), CONST64(0x80000020,0x80800000),
  CONST64(0x80000000,0x00008000), CONST64(0x80000020,0x00008000), CONST64(0x80000000,0x80008000), CONST64(0x80000020,0x80008000),
  CONST64(0x80000000,0x00808000), CONST64(0x80000020,0x00808000), CONST64(0x80000000,0x80808000), CONST64(0x80000020,0x80808000),
  CONST64(0x80000000,0x00000080), CONST64(0x80000020,0x00000080), CONST64(0x80000000,0x80000080), CONST64(0x80000020,0x80000080),
  CONST64(0x80000000,0x00800080), CONST64(0x80000020,0x00800080), CONST64(0x80000000,0x80800080), CONST64(0x80000020,0x80800080),
  CONST64(0x80000000,0x00008080), CONST64(0x80000020,0x00008080), CONST64(0x80000000,0x80008080), CONST64(0x80000020,0x80008080),
  CONST64(0x80000000,0x00808080), CONST64(0x80000020,0x00808080), CONST64(0x80000000,0x80808080), CONST64(0x80000020,0x80808080),
  CONST64(0x00800000,0x00000000), CONST64(0x00800020,0x00000000), CONST64(0x00800000,0x80000000), CONST64(0x00800020,0x80000000),
  CONST64(0x00800000,0x00800000), CONST64(0x00800020,0x00800000), CONST64(0x00800000,0x80800000), CONST64(0x00800020,0x80800000),
  CONST64(0x00800000,0x00008000), CONST64(0x00800020,0x00008000), CONST64(0x00800000,0x80008000), CONST64(0x00800020,0x80008000),
  CONST64(0x00800000,0x00808000), CONST64(0x00800020,0x00808000), CONST64(0x00800000,0x80808000), CONST64(0x00800020,0x80808000),
  CONST64(0x00800000,0x00000080), CONST64(0x00800020,0x00000080), CONST64(0x00800000,0x80000080), CONST64(0x00800020,0x80000080),
  CONST64(0x00800000,0x00800080), CONST64(0x00800020,0x00800080), CONST64(0x00800000,0x80800080), CONST64(0x00800020,0x80800080),
  CONST64(0x00800000,0x00008080), CONST64(0x00800020,0x00008080), CONST64(0x00800000,0x80008080), CONST64(0x00800020,0x80008080),
  CONST64(0x00800000,0x00808080), CONST64(0x00800020,0x00808080), CONST64(0x00800000,0x80808080), CONST64(0x00800020,0x80808080),
  CONST64(0x80800000,0x00000000), CONST64(0x80800020,0x00000000), CONST64(0x80800000,0x80000000), CONST64(0x80800020,0x80000000),
  CONST64(0x80800000,0x00800000), CONST64(0x80800020,0x00800000), CONST64(0x80800000,0x80800000), CONST64(0x80800020,0x80800000),
  CONST64(0x80800000,0x00008000), CONST64(0x80800020,0x00008000), CONST64(0x80800000,0x80008000), CONST64(0x80800020,0x80008000),
  CONST64(0x80800000,0x00808000), CONST64(0x80800020,0x00808000), CONST64(0x80800000,0x80808000), CONST64(0x80800020,0x80808000),
  CONST64(0x80800000,0x00000080), CONST64(0x80800020,0x00000080), CONST64(0x80800000,0x80000080), CONST64(0x80800020,0x80000080),
  CONST64(0x80800000,0x00800080), CONST64(0x80800020,0x00800080), CONST64(0x80800000,0x80800080), CONST64(0x80800020,0x80800080),
  CONST64(0x80800000,0x00008080), CONST64(0x80800020,0x00008080), CONST64(0x80800000,0x80008080), CONST64(0x80800020,0x80008080),
  CONST64(0x80800000,0x00808080), CONST64(0x80800020,0x00808080), CONST64(0x80800000,0x80808080), CONST64(0x80800020,0x80808080),
  CONST64(0x00008000,0x00000000), CONST64(0x00008020,0x00000000), CONST64(0x00008000,0x80000000), CONST64(0x00008020,0x80000000),
  CONST64(0x00008000,0x00800000), CONST64(0x00008020,0x00800000), CONST64(0x00008000,0x80800000), CONST64(0x00008020,0x80800000),
  CONST64(0x00008000,0x00008000), CONST64(0x00008020,0x00008000), CONST64(0x00008000,0x80008000), CONST64(0x00008020,0x80008000),
  CONST64(0x00008000,0x00808000), CONST64(0x00008020,0x00808000), CONST64(0x00008000,0x80808000), CONST64(0x00008020,0x80808000),
  CONST64(0x00008000,0x00000080), CONST64(0x00008020,0x00000080), CONST64(0x00008000,0x80000080), CONST64(0x00008020,0x80000080),
  CONST64(0x00008000,0x00800080), CONST64(0x00008020,0x00800080), CONST64(0x00008000,0x80800080), CONST64(0x00008020,0x80800080),
  CONST64(0x00008000,0x00008080), CONST64(0x00008020,0x00008080), CONST64(0x00008000,0x80008080), CONST64(0x00008020,0x80008080),
  CONST64(0x00008000,0x00808080), CONST64(0x00008020,0x00808080), CONST64(0x00008000,0x80808080), CONST64(0x00008020,0x80808080),
  CONST64(0x80008000,0x00000000), CONST64(0x80008020,0x00000000), CONST64(0x80008000,0x80000000), CONST64(0x80008020,0x80000000),
  CONST64(0x80008000,0x00800000), CONST64(0x80008020,0x00800000), CONST64(0x80008000,0x80800000), CONST64(0x80008020,0x80800000),
  CONST64(0x80008000,0x00008000), CONST64(0x80008020,0x00008000), CONST64(0x80008000,0x80008000), CONST64(0x80008020,0x80008000),
  CONST64(0x80008000,0x00808000), CONST64(0x80008020,0x00808000), CONST64(0x80008000,0x80808000), CONST64(0x80008020,0x80808000),
  CONST64(0x80008000,0x00000080), CONST64(0x80008020,0x00000080), CONST64(0x80008000,0x80000080), CONST64(0x80008020,0x80000080),
  CONST64(0x80008000,0x00800080), CONST64(0x80008020,0x00800080), CONST64(0x80008000,0x80800080), CONST64(0x80008020,0x80800080),
  CONST64(0x80008000,0x00008080), CONST64(0x80008020,0x00008080), CONST64(0x80008000,0x80008080), CONST64(0x80008020,0x80008080),
  CONST64(0x80008000,0x00808080), CONST64(0x80008020,0x00808080), CONST64(0x80008000,0x80808080), CONST64(0x80008020,0x80808080),
  CONST64(0x00808000,0x00000000), CONST64(0x00808020,0x00000000), CONST64(0x00808000,0x80000000), CONST64(0x00808020,0x80000000),
  CONST64(0x00808000,0x00800000), CONST64(0x00808020,0x00800000), CONST64(0x00808000,0x80800000), CONST64(0x00808020,0x80800000),
  CONST64(0x00808000,0x00008000), CONST64(0x00808020,0x00008000), CONST64(0x00808000,0x80008000), CONST64(0x00808020,0x80008000),
  CONST64(0x00808000,0x00808000), CONST64(0x00808020,0x00808000), CONST64(0x00808000,0x80808000), CONST64(0x00808020,0x80808000),
  CONST64(0x00808000,0x00000080), CONST64(0x00808020,0x00000080), CONST64(0x00808000,0x80000080), CONST64(0x00808020,0x80000080),
  CONST64(0x00808000,0x00800080), CONST64(0x00808020,0x00800080), CONST64(0x00808000,0x80800080), CONST64(0x00808020,0x80800080),
  CONST64(0x00808000,0x00008080), CONST64(0x00808020,0x00008080), CONST64(0x00808000,0x80008080), CONST64(0x00808020,0x80008080),
  CONST64(0x00808000,0x00808080), CONST64(0x00808020,0x00808080), CONST64(0x00808000,0x80808080), CONST64(0x00808020,0x80808080),
  CONST64(0x80808000,0x00000000), CONST64(0x80808020,0x00000000), CONST64(0x80808000,0x80000000), CONST64(0x80808020,0x80000000),
  CONST64(0x80808000,0x00800000), CONST64(0x80808020,0x00800000), CONST64(0x80808000,0x80800000), CONST64(0x80808020,0x80800000),
  CONST64(0x80808000,0x00008000), CONST64(0x80808020,0x00008000), CONST64(0x80808000,0x80008000), CONST64(0x80808020,0x80008000),
  CONST64(0x80808000,0x00808000), CONST64(0x80808020,0x00808000), CONST64(0x80808000,0x80808000), CONST64(0x80808020,0x80808000),
  CONST64(0x80808000,0x00000080), CONST64(0x80808020,0x00000080), CONST64(0x80808000,0x80000080), CONST64(0x80808020,0x80000080),
  CONST64(0x80808000,0x00800080), CONST64(0x80808020,0x00800080), CONST64(0x80808000,0x80800080), CONST64(0x80808020,0x80800080),
  CONST64(0x80808000,0x00008080), CONST64(0x80808020,0x00008080), CONST64(0x80808000,0x80008080), CONST64(0x80808020,0x80008080),
  CONST64(0x80808000,0x00808080), CONST64(0x80808020,0x00808080), CONST64(0x80808000,0x80808080), CONST64(0x80808020,0x80808080)
  },
{ CONST64(0x00000000,0x00000000), CONST64(0x00000040,0x00000000), CONST64(0x00000000,0x01000000), CONST64(0x00000040,0x01000000),
  CONST64(0x00000000,0x00010000), CONST64(0x00000040,0x00010000), CONST64(0x00000000,0x01010000), CONST64(0x00000040,0x01010000),
  CONST64(0x00000000,0x00000100), CONST64(0x00000040,0x00000100), CONST64(0x00000000,0x01000100), CONST64(0x00000040,0x01000100),
  CONST64(0x00000000,0x00010100), CONST64(0x00000040,0x00010100), CONST64(0x00000000,0x01010100), CONST64(0x00000040,0x01010100),
  CONST64(0x00000000,0x00000001), CONST64(0x00000040,0x00000001), CONST64(0x00000000,0x01000001), CONST64(0x00000040,0x01000001),
  CONST64(0x00000000,0x00010001), CONST64(0x00000040,0x00010001), CONST64(0x00000000,0x01010001), CONST64(0x00000040,0x01010001),
  CONST64(0x00000000,0x00000101), CONST64(0x00000040,0x00000101), CONST64(0x00000000,0x01000101), CONST64(0x00000040,0x01000101),
  CONST64(0x00000000,0x00010101), CONST64(0x00000040,0x00010101), CONST64(0x00000000,0x01010101), CONST64(0x00000040,0x01010101),
  CONST64(0x01000000,0x00000000), CONST64(0x01000040,0x00000000), CONST64(0x01000000,0x01000000), CONST64(0x01000040,0x01000000),
  CONST64(0x01000000,0x00010000), CONST64(0x01000040,0x00010000), CONST64(0x01000000,0x01010000), CONST64(0x01000040,0x01010000),
  CONST64(0x01000000,0x00000100), CONST64(0x01000040,0x00000100), CONST64(0x01000000,0x01000100), CONST64(0x01000040,0x01000100),
  CONST64(0x01000000,0x00010100), CONST64(0x01000040,0x00010100), CONST64(0x01000000,0x01010100), CONST64(0x01000040,0x01010100),
  CONST64(0x01000000,0x00000001), CONST64(0x01000040,0x00000001), CONST64(0x01000000,0x01000001), CONST64(0x01000040,0x01000001),
  CONST64(0x01000000,0x00010001), CONST64(0x01000040,0x00010001), CONST64(0x01000000,0x01010001), CONST64(0x01000040,0x01010001),
  CONST64(0x01000000,0x00000101), CONST64(0x01000040,0x00000101), CONST64(0x01000000,0x01000101), CONST64(0x01000040,0x01000101),
  CONST64(0x01000000,0x00010101), CONST64(0x01000040,0x00010101), CONST64(0x01000000,0x01010101), CONST64(0x01000040,0x01010101),
  CONST64(0x00010000,0x00000000), CONST64(0x00010040,0x00000000), CONST64(0x00010000,0x01000000), CONST64(0x00010040,0x01000000),
  CONST64(0x00010000,0x00010000), CONST64(0x00010040,0x00010000), CONST64(0x00010000,0x01010000), CONST64(0x00010040,0x01010000),
  CONST64(0x00010000,0x00000100), CONST64(0x00010040,0x00000100), CONST64(0x00010000,0x01000100), CONST64(0x00010040,0x01000100),
  CONST64(0x00010000,0x00010100), CONST64(0x00010040,0x00010100), CONST64(0x00010000,0x01010100), CONST64(0x00010040,0x01010100),
  CONST64(0x00010000,0x00000001), CONST64(0x00010040,0x00000001), CONST64(0x00010000,0x01000001), CONST64(0x00010040,0x01000001),
  CONST64(0x00010000,0x00010001), CONST64(0x00010040,0x00010001), CONST64(0x00010000,0x01010001), CONST64(0x00010040,0x01010001),
  CONST64(0x00010000,0x00000101), CONST64(0x00010040,0x00000101), CONST64(0x00010000,0x01000101), CONST64(0x00010040,0x01000101),
  CONST64(0x00010000,0x00010101), CONST64(0x00010040,0x00010101), CONST64(0x00010000,0x01010101), CONST64(0x00010040,0x01010101),
  CONST64(0x01010000,0x00000000), CONST64(0x01010040,0x00000000), CONST64(0x01010000,0x01000000), CONST64(0x01010040,0x01000000),
  CONST64(0x01010000,0x00010000), CONST64(0x01010040,0x00010000), CONST64(0x01010000,0x01010000), CONST64(0x01010040,0x01010000),
  CONST64(0x01010000,0x00000100), CONST64(0x01010040,0x00000100), CONST64(0x01010000,0x01000100), CONST64(0x01010040,0x01000100),
  CONST64(0x01010000,0x00010100), CONST64(0x01010040,0x00010100), CONST64(0x01010000,0x01010100), CONST64(0x01010040,0x01010100),
  CONST64(0x01010000,0x00000001), CONST64(0x01010040,0x00000001), CONST64(0x01010000,0x01000001), CONST64(0x01010040,0x01000001),
  CONST64(0x01010000,0x00010001), CONST64(0x01010040,0x00010001), CONST64(0x01010000,0x01010001), CONST64(0x01010040,0x01010001),
  CONST64(0x01010000,0x00000101), CONST64(0x01010040,0x00000101), CONST64(0x01010000,0x01000101), CONST64(0x01010040,0x01000101),
  CONST64(0x01010000,0x00010101), CONST64(0x01010040,0x00010101), CONST64(0x01010000,0x01010101), CONST64(0x01010040,0x01010101),
  CONST64(0x00000100,0x00000000), CONST64(0x00000140,0x00000000), CONST64(0x00000100,0x01000000), CONST64(0x00000140,0x01000000),
  CONST64(0x00000100,0x00010000), CONST64(0x00000140,0x00010000), CONST64(0x00000100,0x01010000), CONST64(0x00000140,0x01010000),
  CONST64(0x00000100,0x00000100), CONST64(0x00000140,0x00000100), CONST64(0x00000100,0x01000100), CONST64(0x00000140,0x01000100),
  CONST64(0x00000100,0x00010100), CONST64(0x00000140,0x00010100), CONST64(0x00000100,0x01010100), CONST64(0x00000140,0x01010100),
  CONST64(0x00000100,0x00000001), CONST64(0x00000140,0x00000001), CONST64(0x00000100,0x01000001), CONST64(0x00000140,0x01000001),
  CONST64(0x00000100,0x00010001), CONST64(0x00000140,0x00010001), CONST64(0x00000100,0x01010001), CONST64(0x00000140,0x01010001),
  CONST64(0x00000100,0x00000101), CONST64(0x00000140,0x00000101), CONST64(0x00000100,0x01000101), CONST64(0x00000140,0x01000101),
  CONST64(0x00000100,0x00010101), CONST64(0x00000140,0x00010101), CONST64(0x00000100,0x01010101), CONST64(0x00000140,0x01010101),
  CONST64(0x01000100,0x00000000), CONST64(0x01000140,0x00000000), CONST64(0x01000100,0x01000000), CONST64(0x01000140,0x01000000),
  CONST64(0x01000100,0x00010000), CONST64(0x01000140,0x00010000), CONST64(0x01000100,0x01010000), CONST64(0x01000140,0x01010000),
  CONST64(0x01000100,0x00000100), CONST64(0x01000140,0x00000100), CONST64(0x01000100,0x01000100), CONST64(0x01000140,0x01000100),
  CONST64(0x01000100,0x00010100), CONST64(0x01000140,0x00010100), CONST64(0x01000100,0x01010100), CONST64(0x01000140,0x01010100),
  CONST64(0x01000100,0x00000001), CONST64(0x01000140,0x00000001), CONST64(0x01000100,0x01000001), CONST64(0x01000140,0x01000001),
  CONST64(0x01000100,0x00010001), CONST64(0x01000140,0x00010001), CONST64(0x01000100,0x01010001), CONST64(0x01000140,0x01010001),
  CONST64(0x01000100,0x00000101), CONST64(0x01000140,0x00000101), CONST64(0x01000100,0x01000101), CONST64(0x01000140,0x01000101),
  CONST64(0x01000100,0x00010101), CONST64(0x01000140,0x00010101), CONST64(0x01000100,0x01010101), CONST64(0x01000140,0x01010101),
  CONST64(0x00010100,0x00000000), CONST64(0x00010140,0x00000000), CONST64(0x00010100,0x01000000), CONST64(0x00010140,0x01000000),
  CONST64(0x00010100,0x00010000), CONST64(0x00010140,0x00010000), CONST64(0x00010100,0x01010000), CONST64(0x00010140,0x01010000),
  CONST64(0x00010100,0x00000100), CONST64(0x00010140,0x00000100), CONST64(0x00010100,0x01000100), CONST64(0x00010140,0x01000100),
  CONST64(0x00010100,0x00010100), CONST64(0x00010140,0x00010100), CONST64(0x00010100,0x01010100), CONST64(0x00010140,0x01010100),
  CONST64(0x00010100,0x00000001), CONST64(0x00010140,0x00000001), CONST64(0x00010100,0x01000001), CONST64(0x00010140,0x01000001),
  CONST64(0x00010100,0x00010001), CONST64(0x00010140,0x00010001), CONST64(0x00010100,0x01010001), CONST64(0x00010140,0x01010001),
  CONST64(0x00010100,0x00000101), CONST64(0x00010140,0x00000101), CONST64(0x00010100,0x01000101), CONST64(0x00010140,0x01000101),
  CONST64(0x00010100,0x00010101), CONST64(0x00010140,0x00010101), CONST64(0x00010100,0x01010101), CONST64(0x00010140,0x01010101),
  CONST64(0x01010100,0x00000000), CONST64(0x01010140,0x00000000), CONST64(0x01010100,0x01000000), CONST64(0x01010140,0x01000000),
  CONST64(0x01010100,0x00010000), CONST64(0x01010140,0x00010000), CONST64(0x01010100,0x01010000), CONST64(0x01010140,0x01010000),
  CONST64(0x01010100,0x00000100), CONST64(0x01010140,0x00000100), CONST64(0x01010100,0x01000100), CONST64(0x01010140,0x01000100),
  CONST64(0x01010100,0x00010100), CONST64(0x01010140,0x00010100), CONST64(0x01010100,0x01010100), CONST64(0x01010140,0x01010100),
  CONST64(0x01010100,0x00000001), CONST64(0x01010140,0x00000001), CONST64(0x01010100,0x01000001), CONST64(0x01010140,0x01000001),
  CONST64(0x01010100,0x00010001), CONST64(0x01010140,0x00010001), CONST64(0x01010100,0x01010001), CONST64(0x01010140,0x01010001),
  CONST64(0x01010100,0x00000101), CONST64(0x01010140,0x00000101), CONST64(0x01010100,0x01000101), CONST64(0x01010140,0x01000101),
  CONST64(0x01010100,0x00010101), CONST64(0x01010140,0x00010101), CONST64(0x01010100,0x01010101), CONST64(0x01010140,0x01010101)
  },
{ CONST64(0x00000000,0x00000000), CONST64(0x00000001,0x00000000), CONST64(0x00000000,0x04000000), CONST64(0x00000001,0x04000000),
  CONST64(0x00000000,0x00040000), CONST64(0x00000001,0x00040000), CONST64(0x00000000,0x04040000), CONST64(0x00000001,0x04040000),
  CONST64(0x00000000,0x00000400), CONST64(0x00000001,0x00000400), CONST64(0x00000000,0x04000400), CONST64(0x00000001,0x04000400),
  CONST64(0x00000000,0x00040400), CONST64(0x00000001,0x00040400), CONST64(0x00000000,0x04040400), CONST64(0x00000001,0x04040400),
  CONST64(0x00000000,0x00000004), CONST64(0x00000001,0x00000004), CONST64(0x00000000,0x04000004), CONST64(0x00000001,0x04000004),
  CONST64(0x00000000,0x00040004), CONST64(0x00000001,0x00040004), CONST64(0x00000000,0x04040004), CONST64(0x00000001,0x04040004),
  CONST64(0x00000000,0x00000404), CONST64(0x00000001,0x00000404), CONST64(0x00000000,0x04000404), CONST64(0x00000001,0x04000404),
  CONST64(0x00000000,0x00040404), CONST64(0x00000001,0x00040404), CONST64(0x00000000,0x04040404), CONST64(0x00000001,0x04040404),
  CONST64(0x04000000,0x00000000), CONST64(0x04000001,0x00000000), CONST64(0x04000000,0x04000000), CONST64(0x04000001,0x04000000),
  CONST64(0x04000000,0x00040000), CONST64(0x04000001,0x00040000), CONST64(0x04000000,0x04040000), CONST64(0x04000001,0x04040000),
  CONST64(0x04000000,0x00000400), CONST64(0x04000001,0x00000400), CONST64(0x04000000,0x04000400), CONST64(0x04000001,0x04000400),
  CONST64(0x04000000,0x00040400), CONST64(0x04000001,0x00040400), CONST64(0x04000000,0x04040400), CONST64(0x04000001,0x04040400),
  CONST64(0x04000000,0x00000004), CONST64(0x04000001,0x00000004), CONST64(0x04000000,0x04000004), CONST64(0x04000001,0x04000004),
  CONST64(0x04000000,0x00040004), CONST64(0x04000001,0x00040004), CONST64(0x04000000,0x04040004), CONST64(0x04000001,0x04040004),
  CONST64(0x04000000,0x00000404), CONST64(0x04000001,0x00000404), CONST64(0x04000000,0x04000404), CONST64(0x04000001,0x04000404),
  CONST64(0x04000000,0x00040404), CONST64(0x04000001,0x00040404), CONST64(0x04000000,0x04040404), CONST64(0x04000001,0x04040404),
  CONST64(0x00040000,0x00000000), CONST64(0x00040001,0x00000000), CONST64(0x00040000,0x04000000), CONST64(0x00040001,0x04000000),
  CONST64(0x00040000,0x00040000), CONST64(0x00040001,0x00040000), CONST64(0x00040000,0x04040000), CONST64(0x00040001,0x04040000),
  CONST64(0x00040000,0x00000400), CONST64(0x00040001,0x00000400), CONST64(0x00040000,0x04000400), CONST64(0x00040001,0x04000400),
  CONST64(0x00040000,0x00040400), CONST64(0x00040001,0x00040400), CONST64(0x00040000,0x04040400), CONST64(0x00040001,0x04040400),
  CONST64(0x00040000,0x00000004), CONST64(0x00040001,0x00000004), CONST64(0x00040000,0x04000004), CONST64(0x00040001,0x04000004),
  CONST64(0x00040000,0x00040004), CONST64(0x00040001,0x00040004), CONST64(0x00040000,0x04040004), CONST64(0x00040001,0x04040004),
  CONST64(0x00040000,0x00000404), CONST64(0x00040001,0x00000404), CONST64(0x00040000,0x04000404), CONST64(0x00040001,0x04000404),
  CONST64(0x00040000,0x00040404), CONST64(0x00040001,0x00040404), CONST64(0x00040000,0x04040404), CONST64(0x00040001,0x04040404),
  CONST64(0x04040000,0x00000000), CONST64(0x04040001,0x00000000), CONST64(0x04040000,0x04000000), CONST64(0x04040001,0x04000000),
  CONST64(0x04040000,0x00040000), CONST64(0x04040001,0x00040000), CONST64(0x04040000,0x04040000), CONST64(0x04040001,0x04040000),
  CONST64(0x04040000,0x00000400), CONST64(0x04040001,0x00000400), CONST64(0x04040000,0x04000400), CONST64(0x04040001,0x04000400),
  CONST64(0x04040000,0x00040400), CONST64(0x04040001,0x00040400), CONST64(0x04040000,0x04040400), CONST64(0x04040001,0x04040400),
  CONST64(0x04040000,0x00000004), CONST64(0x04040001,0x00000004), CONST64(0x04040000,0x04000004), CONST64(0x04040001,0x04000004),
  CONST64(0x04040000,0x00040004), CONST64(0x04040001,0x00040004), CONST64(0x04040000,0x04040004), CONST64(0x04040001,0x04040004),
  CONST64(0x04040000,0x00000404), CONST64(0x04040001,0x00000404), CONST64(0x04040000,0x04000404), CONST64(0x04040001,0x04000404),
  CONST64(0x04040000,0x00040404), CONST64(0x04040001,0x00040404), CONST64(0x04040000,0x04040404), CONST64(0x04040001,0x04040404),
  CONST64(0x00000400,0x00000000), CONST64(0x00000401,0x00000000), CONST64(0x00000400,0x04000000), CONST64(0x00000401,0x04000000),
  CONST64(0x00000400,0x00040000), CONST64(0x00000401,0x00040000), CONST64(0x00000400,0x04040000), CONST64(0x00000401,0x04040000),
  CONST64(0x00000400,0x00000400), CONST64(0x00000401,0x00000400), CONST64(0x00000400,0x04000400), CONST64(0x00000401,0x04000400),
  CONST64(0x00000400,0x00040400), CONST64(0x00000401,0x00040400), CONST64(0x00000400,0x04040400), CONST64(0x00000401,0x04040400),
  CONST64(0x00000400,0x00000004), CONST64(0x00000401,0x00000004), CONST64(0x00000400,0x04000004), CONST64(0x00000401,0x04000004),
  CONST64(0x00000400,0x00040004), CONST64(0x00000401,0x00040004), CONST64(0x00000400,0x04040004), CONST64(0x00000401,0x04040004),
  CONST64(0x00000400,0x00000404), CONST64(0x00000401,0x00000404), CONST64(0x00000400,0x04000404), CONST64(0x00000401,0x04000404),
  CONST64(0x00000400,0x00040404), CONST64(0x00000401,0x00040404), CONST64(0x00000400,0x04040404), CONST64(0x00000401,0x04040404),
  CONST64(0x04000400,0x00000000), CONST64(0x04000401,0x00000000), CONST64(0x04000400,0x04000000), CONST64(0x04000401,0x04000000),
  CONST64(0x04000400,0x00040000), CONST64(0x04000401,0x00040000), CONST64(0x04000400,0x04040000), CONST64(0x04000401,0x04040000),
  CONST64(0x04000400,0x00000400), CONST64(0x04000401,0x00000400), CONST64(0x04000400,0x04000400), CONST64(0x04000401,0x04000400),
  CONST64(0x04000400,0x00040400), CONST64(0x04000401,0x00040400), CONST64(0x04000400,0x04040400), CONST64(0x04000401,0x04040400),
  CONST64(0x04000400,0x00000004), CONST64(0x04000401,0x00000004), CONST64(0x04000400,0x04000004), CONST64(0x04000401,0x04000004),
  CONST64(0x04000400,0x00040004), CONST64(0x04000401,0x00040004), CONST64(0x04000400,0x04040004), CONST64(0x04000401,0x04040004),
  CONST64(0x04000400,0x00000404), CONST64(0x04000401,0x00000404), CONST64(0x04000400,0x04000404), CONST64(0x04000401,0x04000404),
  CONST64(0x04000400,0x00040404), CONST64(0x04000401,0x00040404), CONST64(0x04000400,0x04040404), CONST64(0x04000401,0x04040404),
  CONST64(0x00040400,0x00000000), CONST64(0x00040401,0x00000000), CONST64(0x00040400,0x04000000), CONST64(0x00040401,0x04000000),
  CONST64(0x00040400,0x00040000), CONST64(0x00040401,0x00040000), CONST64(0x00040400,0x04040000), CONST64(0x00040401,0x04040000),
  CONST64(0x00040400,0x00000400), CONST64(0x00040401,0x00000400), CONST64(0x00040400,0x04000400), CONST64(0x00040401,0x04000400),
  CONST64(0x00040400,0x00040400), CONST64(0x00040401,0x00040400), CONST64(0x00040400,0x04040400), CONST64(0x00040401,0x04040400),
  CONST64(0x00040400,0x00000004), CONST64(0x00040401,0x00000004), CONST64(0x00040400,0x04000004), CONST64(0x00040401,0x04000004),
  CONST64(0x00040400,0x00040004), CONST64(0x00040401,0x00040004), CONST64(0x00040400,0x04040004), CONST64(0x00040401,0x04040004),
  CONST64(0x00040400,0x00000404), CONST64(0x00040401,0x00000404), CONST64(0x00040400,0x04000404), CONST64(0x00040401,0x04000404),
  CONST64(0x00040400,0x00040404), CONST64(0x00040401,0x00040404), CONST64(0x00040400,0x04040404), CONST64(0x00040401,0x04040404),
  CONST64(0x04040400,0x00000000), CONST64(0x04040401,0x00000000), CONST64(0x04040400,0x04000000), CONST64(0x04040401,0x04000000),
  CONST64(0x04040400,0x00040000), CONST64(0x04040401,0x00040000), CONST64(0x04040400,0x04040000), CONST64(0x04040401,0x04040000),
  CONST64(0x04040400,0x00000400), CONST64(0x04040401,0x00000400), CONST64(0x04040400,0x04000400), CONST64(0x04040401,0x04000400),
  CONST64(0x04040400,0x00040400), CONST64(0x04040401,0x00040400), CONST64(0x04040400,0x04040400), CONST64(0x04040401,0x04040400),
  CONST64(0x04040400,0x00000004), CONST64(0x04040401,0x00000004), CONST64(0x04040400,0x04000004), CONST64(0x04040401,0x04000004),
  CONST64(0x04040400,0x00040004), CONST64(0x04040401,0x00040004), CONST64(0x04040400,0x04040004), CONST64(0x04040401,0x04040004),
  CONST64(0x04040400,0x00000404), CONST64(0x04040401,0x00000404), CONST64(0x04040400,0x04000404), CONST64(0x04040401,0x04000404),
  CONST64(0x04040400,0x00040404), CONST64(0x04040401,0x00040404), CONST64(0x04040400,0x04040404), CONST64(0x04040401,0x04040404)
  },
{ CONST64(0x00000000,0x00000000), CONST64(0x00000004,0x00000000), CONST64(0x00000000,0x10000000), CONST64(0x00000004,0x10000000),
  CONST64(0x00000000,0x00100000), CONST64(0x00000004,0x00100000), CONST64(0x00000000,0x10100000), CONST64(0x00000004,0x10100000),
  CONST64(0x00000000,0x00001000), CONST64(0x00000004,0x00001000), CONST64(0x00000000,0x10001000), CONST64(0x00000004,0x10001000),
  CONST64(0x00000000,0x00101000), CONST64(0x00000004,0x00101000), CONST64(0x00000000,0x10101000), CONST64(0x00000004,0x10101000),
  CONST64(0x00000000,0x00000010), CONST64(0x00000004,0x00000010), CONST64(0x00000000,0x10000010), CONST64(0x00000004,0x10000010),
  CONST64(0x00000000,0x00100010), CONST64(0x00000004,0x00100010), CONST64(0x00000000,0x10100010), CONST64(0x00000004,0x10100010),
  CONST64(0x00000000,0x00001010), CONST64(0x00000004,0x00001010), CONST64(0x00000000,0x10001010), CONST64(0x00000004,0x10001010),
  CONST64(0x00000000,0x00101010), CONST64(0x00000004,0x00101010), CONST64(0x00000000,0x10101010), CONST64(0x00000004,0x10101010),
  CONST64(0x10000000,0x00000000), CONST64(0x10000004,0x00000000), CONST64(0x10000000,0x10000000), CONST64(0x10000004,0x10000000),
  CONST64(0x10000000,0x00100000), CONST64(0x10000004,0x00100000), CONST64(0x10000000,0x10100000), CONST64(0x10000004,0x10100000),
  CONST64(0x10000000,0x00001000), CONST64(0x10000004,0x00001000), CONST64(0x10000000,0x10001000), CONST64(0x10000004,0x10001000),
  CONST64(0x10000000,0x00101000), CONST64(0x10000004,0x00101000), CONST64(0x10000000,0x10101000), CONST64(0x10000004,0x10101000),
  CONST64(0x10000000,0x00000010), CONST64(0x10000004,0x00000010), CONST64(0x10000000,0x10000010), CONST64(0x10000004,0x10000010),
  CONST64(0x10000000,0x00100010), CONST64(0x10000004,0x00100010), CONST64(0x10000000,0x10100010), CONST64(0x10000004,0x10100010),
  CONST64(0x10000000,0x00001010), CONST64(0x10000004,0x00001010), CONST64(0x10000000,0x10001010), CONST64(0x10000004,0x10001010),
  CONST64(0x10000000,0x00101010), CONST64(0x10000004,0x00101010), CONST64(0x10000000,0x10101010), CONST64(0x10000004,0x10101010),
  CONST64(0x00100000,0x00000000), CONST64(0x00100004,0x00000000), CONST64(0x00100000,0x10000000), CONST64(0x00100004,0x10000000),
  CONST64(0x00100000,0x00100000), CONST64(0x00100004,0x00100000), CONST64(0x00100000,0x10100000), CONST64(0x00100004,0x10100000),
  CONST64(0x00100000,0x00001000), CONST64(0x00100004,0x00001000), CONST64(0x00100000,0x10001000), CONST64(0x00100004,0x10001000),
  CONST64(0x00100000,0x00101000), CONST64(0x00100004,0x00101000), CONST64(0x00100000,0x10101000), CONST64(0x00100004,0x10101000),
  CONST64(0x00100000,0x00000010), CONST64(0x00100004,0x00000010), CONST64(0x00100000,0x10000010), CONST64(0x00100004,0x10000010),
  CONST64(0x00100000,0x00100010), CONST64(0x00100004,0x00100010), CONST64(0x00100000,0x10100010), CONST64(0x00100004,0x10100010),
  CONST64(0x00100000,0x00001010), CONST64(0x00100004,0x00001010), CONST64(0x00100000,0x10001010), CONST64(0x00100004,0x10001010),
  CONST64(0x00100000,0x00101010), CONST64(0x00100004,0x00101010), CONST64(0x00100000,0x10101010), CONST64(0x00100004,0x10101010),
  CONST64(0x10100000,0x00000000), CONST64(0x10100004,0x00000000), CONST64(0x10100000,0x10000000), CONST64(0x10100004,0x10000000),
  CONST64(0x10100000,0x00100000), CONST64(0x10100004,0x00100000), CONST64(0x10100000,0x10100000), CONST64(0x10100004,0x10100000),
  CONST64(0x10100000,0x00001000), CONST64(0x10100004,0x00001000), CONST64(0x10100000,0x10001000), CONST64(0x10100004,0x10001000),
  CONST64(0x10100000,0x00101000), CONST64(0x10100004,0x00101000), CONST64(0x10100000,0x10101000), CONST64(0x10100004,0x10101000),
  CONST64(0x10100000,0x00000010), CONST64(0x10100004,0x00000010), CONST64(0x10100000,0x10000010), CONST64(0x10100004,0x10000010),
  CONST64(0x10100000,0x00100010), CONST64(0x10100004,0x00100010), CONST64(0x10100000,0x10100010), CONST64(0x10100004,0x10100010),
  CONST64(0x10100000,0x00001010), CONST64(0x10100004,0x00001010), CONST64(0x10100000,0x10001010), CONST64(0x10100004,0x10001010),
  CONST64(0x10100000,0x00101010), CONST64(0x10100004,0x00101010), CONST64(0x10100000,0x10101010), CONST64(0x10100004,0x10101010),
  CONST64(0x00001000,0x00000000), CONST64(0x00001004,0x00000000), CONST64(0x00001000,0x10000000), CONST64(0x00001004,0x10000000),
  CONST64(0x00001000,0x00100000), CONST64(0x00001004,0x00100000), CONST64(0x00001000,0x10100000), CONST64(0x00001004,0x10100000),
  CONST64(0x00001000,0x00001000), CONST64(0x00001004,0x00001000), CONST64(0x00001000,0x10001000), CONST64(0x00001004,0x10001000),
  CONST64(0x00001000,0x00101000), CONST64(0x00001004,0x00101000), CONST64(0x00001000,0x10101000), CONST64(0x00001004,0x10101000),
  CONST64(0x00001000,0x00000010), CONST64(0x00001004,0x00000010), CONST64(0x00001000,0x10000010), CONST64(0x00001004,0x10000010),
  CONST64(0x00001000,0x00100010), CONST64(0x00001004,0x00100010), CONST64(0x00001000,0x10100010), CONST64(0x00001004,0x10100010),
  CONST64(0x00001000,0x00001010), CONST64(0x00001004,0x00001010), CONST64(0x00001000,0x10001010), CONST64(0x00001004,0x10001010),
  CONST64(0x00001000,0x00101010), CONST64(0x00001004,0x00101010), CONST64(0x00001000,0x10101010), CONST64(0x00001004,0x10101010),
  CONST64(0x10001000,0x00000000), CONST64(0x10001004,0x00000000), CONST64(0x10001000,0x10000000), CONST64(0x10001004,0x10000000),
  CONST64(0x10001000,0x00100000), CONST64(0x10001004,0x00100000), CONST64(0x10001000,0x10100000), CONST64(0x10001004,0x10100000),
  CONST64(0x10001000,0x00001000), CONST64(0x10001004,0x00001000), CONST64(0x10001000,0x10001000), CONST64(0x10001004,0x10001000),
  CONST64(0x10001000,0x00101000), CONST64(0x10001004,0x00101000), CONST64(0x10001000,0x10101000), CONST64(0x10001004,0x10101000),
  CONST64(0x10001000,0x00000010), CONST64(0x10001004,0x00000010), CONST64(0x10001000,0x10000010), CONST64(0x10001004,0x10000010),
  CONST64(0x10001000,0x00100010), CONST64(0x10001004,0x00100010), CONST64(0x10001000,0x10100010), CONST64(0x10001004,0x10100010),
  CONST64(0x10001000,0x00001010), CONST64(0x10001004,0x00001010), CONST64(0x10001000,0x10001010), CONST64(0x10001004,0x10001010),
  CONST64(0x10001000,0x00101010), CONST64(0x10001004,0x00101010), CONST64(0x10001000,0x10101010), CONST64(0x10001004,0x10101010),
  CONST64(0x00101000,0x00000000), CONST64(0x00101004,0x00000000), CONST64(0x00101000,0x10000000), CONST64(0x00101004,0x10000000),
  CONST64(0x00101000,0x00100000), CONST64(0x00101004,0x00100000), CONST64(0x00101000,0x10100000), CONST64(0x00101004,0x10100000),
  CONST64(0x00101000,0x00001000), CONST64(0x00101004,0x00001000), CONST64(0x00101000,0x10001000), CONST64(0x00101004,0x10001000),
  CONST64(0x00101000,0x00101000), CONST64(0x00101004,0x00101000), CONST64(0x00101000,0x10101000), CONST64(0x00101004,0x10101000),
  CONST64(0x00101000,0x00000010), CONST64(0x00101004,0x00000010), CONST64(0x00101000,0x10000010), CONST64(0x00101004,0x10000010),
  CONST64(0x00101000,0x00100010), CONST64(0x00101004,0x00100010), CONST64(0x00101000,0x10100010), CONST64(0x00101004,0x10100010),
  CONST64(0x00101000,0x00001010), CONST64(0x00101004,0x00001010), CONST64(0x00101000,0x10001010), CONST64(0x00101004,0x10001010),
  CONST64(0x00101000,0x00101010), CONST64(0x00101004,0x00101010), CONST64(0x00101000,0x10101010), CONST64(0x00101004,0x10101010),
  CONST64(0x10101000,0x00000000), CONST64(0x10101004,0x00000000), CONST64(0x10101000,0x10000000), CONST64(0x10101004,0x10000000),
  CONST64(0x10101000,0x00100000), CONST64(0x10101004,0x00100000), CONST64(0x10101000,0x10100000), CONST64(0x10101004,0x10100000),
  CONST64(0x10101000,0x00001000), CONST64(0x10101004,0x00001000), CONST64(0x10101000,0x10001000), CONST64(0x10101004,0x10001000),
  CONST64(0x10101000,0x00101000), CONST64(0x10101004,0x00101000), CONST64(0x10101000,0x10101000), CONST64(0x10101004,0x10101000),
  CONST64(0x10101000,0x00000010), CONST64(0x10101004,0x00000010), CONST64(0x10101000,0x10000010), CONST64(0x10101004,0x10000010),
  CONST64(0x10101000,0x00100010), CONST64(0x10101004,0x00100010), CONST64(0x10101000,0x10100010), CONST64(0x10101004,0x10100010),
  CONST64(0x10101000,0x00001010), CONST64(0x10101004,0x00001010), CONST64(0x10101000,0x10001010), CONST64(0x10101004,0x10001010),
  CONST64(0x10101000,0x00101010), CONST64(0x10101004,0x00101010), CONST64(0x10101000,0x10101010), CONST64(0x10101004,0x10101010)
  },
{ CONST64(0x00000000,0x00000000), CONST64(0x00000010,0x00000000), CONST64(0x00000000,0x40000000), CONST64(0x00000010,0x40000000),
  CONST64(0x00000000,0x00400000), CONST64(0x00000010,0x00400000), CONST64(0x00000000,0x40400000), CONST64(0x00000010,0x40400000),
  CONST64(0x00000000,0x00004000), CONST64(0x00000010,0x00004000), CONST64(0x00000000,0x40004000), CONST64(0x00000010,0x40004000),
  CONST64(0x00000000,0x00404000), CONST64(0x00000010,0x00404000), CONST64(0x00000000,0x40404000), CONST64(0x00000010,0x40404000),
  CONST64(0x00000000,0x00000040), CONST64(0x00000010,0x00000040), CONST64(0x00000000,0x40000040), CONST64(0x00000010,0x40000040),
  CONST64(0x00000000,0x00400040), CONST64(0x00000010,0x00400040), CONST64(0x00000000,0x40400040), CONST64(0x00000010,0x40400040),
  CONST64(0x00000000,0x00004040), CONST64(0x00000010,0x00004040), CONST64(0x00000000,0x40004040), CONST64(0x00000010,0x40004040),
  CONST64(0x00000000,0x00404040), CONST64(0x00000010,0x00404040), CONST64(0x00000000,0x40404040), CONST64(0x00000010,0x40404040),
  CONST64(0x40000000,0x00000000), CONST64(0x40000010,0x00000000), CONST64(0x40000000,0x40000000), CONST64(0x40000010,0x40000000),
  CONST64(0x40000000,0x00400000), CONST64(0x40000010,0x00400000), CONST64(0x40000000,0x40400000), CONST64(0x40000010,0x40400000),
  CONST64(0x40000000,0x00004000), CONST64(0x40000010,0x00004000), CONST64(0x40000000,0x40004000), CONST64(0x40000010,0x40004000),
  CONST64(0x40000000,0x00404000), CONST64(0x40000010,0x00404000), CONST64(0x40000000,0x40404000), CONST64(0x40000010,0x40404000),
  CONST64(0x40000000,0x00000040), CONST64(0x40000010,0x00000040), CONST64(0x40000000,0x40000040), CONST64(0x40000010,0x40000040),
  CONST64(0x40000000,0x00400040), CONST64(0x40000010,0x00400040), CONST64(0x40000000,0x40400040), CONST64(0x40000010,0x40400040),
  CONST64(0x40000000,0x00004040), CONST64(0x40000010,0x00004040), CONST64(0x40000000,0x40004040), CONST64(0x40000010,0x40004040),
  CONST64(0x40000000,0x00404040), CONST64(0x40000010,0x00404040), CONST64(0x40000000,0x40404040), CONST64(0x40000010,0x40404040),
  CONST64(0x00400000,0x00000000), CONST64(0x00400010,0x00000000), CONST64(0x00400000,0x40000000), CONST64(0x00400010,0x40000000),
  CONST64(0x00400000,0x00400000), CONST64(0x00400010,0x00400000), CONST64(0x00400000,0x40400000), CONST64(0x00400010,0x40400000),
  CONST64(0x00400000,0x00004000), CONST64(0x00400010,0x00004000), CONST64(0x00400000,0x40004000), CONST64(0x00400010,0x40004000),
  CONST64(0x00400000,0x00404000), CONST64(0x00400010,0x00404000), CONST64(0x00400000,0x40404000), CONST64(0x00400010,0x40404000),
  CONST64(0x00400000,0x00000040), CONST64(0x00400010,0x00000040), CONST64(0x00400000,0x40000040), CONST64(0x00400010,0x40000040),
  CONST64(0x00400000,0x00400040), CONST64(0x00400010,0x00400040), CONST64(0x00400000,0x40400040), CONST64(0x00400010,0x40400040),
  CONST64(0x00400000,0x00004040), CONST64(0x00400010,0x00004040), CONST64(0x00400000,0x40004040), CONST64(0x00400010,0x40004040),
  CONST64(0x00400000,0x00404040), CONST64(0x00400010,0x00404040), CONST64(0x00400000,0x40404040), CONST64(0x00400010,0x40404040),
  CONST64(0x40400000,0x00000000), CONST64(0x40400010,0x00000000), CONST64(0x40400000,0x40000000), CONST64(0x40400010,0x40000000),
  CONST64(0x40400000,0x00400000), CONST64(0x40400010,0x00400000), CONST64(0x40400000,0x40400000), CONST64(0x40400010,0x40400000),
  CONST64(0x40400000,0x00004000), CONST64(0x40400010,0x00004000), CONST64(0x40400000,0x40004000), CONST64(0x40400010,0x40004000),
  CONST64(0x40400000,0x00404000), CONST64(0x40400010,0x00404000), CONST64(0x40400000,0x40404000), CONST64(0x40400010,0x40404000),
  CONST64(0x40400000,0x00000040), CONST64(0x40400010,0x00000040), CONST64(0x40400000,0x40000040), CONST64(0x40400010,0x40000040),
  CONST64(0x40400000,0x00400040), CONST64(0x40400010,0x00400040), CONST64(0x40400000,0x40400040), CONST64(0x40400010,0x40400040),
  CONST64(0x40400000,0x00004040), CONST64(0x40400010,0x00004040), CONST64(0x40400000,0x40004040), CONST64(0x40400010,0x40004040),
  CONST64(0x40400000,0x00404040), CONST64(0x40400010,0x00404040), CONST64(0x40400000,0x40404040), CONST64(0x40400010,0x40404040),
  CONST64(0x00004000,0x00000000), CONST64(0x00004010,0x00000000), CONST64(0x00004000,0x40000000), CONST64(0x00004010,0x40000000),
  CONST64(0x00004000,0x00400000), CONST64(0x00004010,0x00400000), CONST64(0x00004000,0x40400000), CONST64(0x00004010,0x40400000),
  CONST64(0x00004000,0x00004000), CONST64(0x00004010,0x00004000), CONST64(0x00004000,0x40004000), CONST64(0x00004010,0x40004000),
  CONST64(0x00004000,0x00404000), CONST64(0x00004010,0x00404000), CONST64(0x00004000,0x40404000), CONST64(0x00004010,0x40404000),
  CONST64(0x00004000,0x00000040), CONST64(0x00004010,0x00000040), CONST64(0x00004000,0x40000040), CONST64(0x00004010,0x40000040),
  CONST64(0x00004000,0x00400040), CONST64(0x00004010,0x00400040), CONST64(0x00004000,0x40400040), CONST64(0x00004010,0x40400040),
  CONST64(0x00004000,0x00004040), CONST64(0x00004010,0x00004040), CONST64(0x00004000,0x40004040), CONST64(0x00004010,0x40004040),
  CONST64(0x00004000,0x00404040), CONST64(0x00004010,0x00404040), CONST64(0x00004000,0x40404040), CONST64(0x00004010,0x40404040),
  CONST64(0x40004000,0x00000000), CONST64(0x40004010,0x00000000), CONST64(0x40004000,0x40000000), CONST64(0x40004010,0x40000000),
  CONST64(0x40004000,0x00400000), CONST64(0x40004010,0x00400000), CONST64(0x40004000,0x40400000), CONST64(0x40004010,0x40400000),
  CONST64(0x40004000,0x00004000), CONST64(0x40004010,0x00004000), CONST64(0x40004000,0x40004000), CONST64(0x40004010,0x40004000),
  CONST64(0x40004000,0x00404000), CONST64(0x40004010,0x00404000), CONST64(0x40004000,0x40404000), CONST64(0x40004010,0x40404000),
  CONST64(0x40004000,0x00000040), CONST64(0x40004010,0x00000040), CONST64(0x40004000,0x40000040), CONST64(0x40004010,0x40000040),
  CONST64(0x40004000,0x00400040), CONST64(0x40004010,0x00400040), CONST64(0x40004000,0x40400040), CONST64(0x40004010,0x40400040),
  CONST64(0x40004000,0x00004040), CONST64(0x40004010,0x00004040), CONST64(0x40004000,0x40004040), CONST64(0x40004010,0x40004040),
  CONST64(0x40004000,0x00404040), CONST64(0x40004010,0x00404040), CONST64(0x40004000,0x40404040), CONST64(0x40004010,0x40404040),
  CONST64(0x00404000,0x00000000), CONST64(0x00404010,0x00000000), CONST64(0x00404000,0x40000000), CONST64(0x00404010,0x40000000),
  CONST64(0x00404000,0x00400000), CONST64(0x00404010,0x00400000), CONST64(0x00404000,0x40400000), CONST64(0x00404010,0x40400000),
  CONST64(0x00404000,0x00004000), CONST64(0x00404010,0x00004000), CONST64(0x00404000,0x40004000), CONST64(0x00404010,0x40004000),
  CONST64(0x00404000,0x00404000), CONST64(0x00404010,0x00404000), CONST64(0x00404000,0x40404000), CONST64(0x00404010,0x40404000),
  CONST64(0x00404000,0x00000040), CONST64(0x00404010,0x00000040), CONST64(0x00404000,0x40000040), CONST64(0x00404010,0x40000040),
  CONST64(0x00404000,0x00400040), CONST64(0x00404010,0x00400040), CONST64(0x00404000,0x40400040), CONST64(0x00404010,0x40400040),
  CONST64(0x00404000,0x00004040), CONST64(0x00404010,0x00004040), CONST64(0x00404000,0x40004040), CONST64(0x00404010,0x40004040),
  CONST64(0x00404000,0x00404040), CONST64(0x00404010,0x00404040), CONST64(0x00404000,0x40404040), CONST64(0x00404010,0x40404040),
  CONST64(0x40404000,0x00000000), CONST64(0x40404010,0x00000000), CONST64(0x40404000,0x40000000), CONST64(0x40404010,0x40000000),
  CONST64(0x40404000,0x00400000), CONST64(0x40404010,0x00400000), CONST64(0x40404000,0x40400000), CONST64(0x40404010,0x40400000),
  CONST64(0x40404000,0x00004000), CONST64(0x40404010,0x00004000), CONST64(0x40404000,0x40004000), CONST64(0x40404010,0x40004000),
  CONST64(0x40404000,0x00404000), CONST64(0x40404010,0x00404000), CONST64(0x40404000,0x40404000), CONST64(0x40404010,0x40404000),
  CONST64(0x40404000,0x00000040), CONST64(0x40404010,0x00000040), CONST64(0x40404000,0x40000040), CONST64(0x40404010,0x40000040),
  CONST64(0x40404000,0x00400040), CONST64(0x40404010,0x00400040), CONST64(0x40404000,0x40400040), CONST64(0x40404010,0x40400040),
  CONST64(0x40404000,0x00004040), CONST64(0x40404010,0x00004040), CONST64(0x40404000,0x40004040), CONST64(0x40404010,0x40004040),
  CONST64(0x40404000,0x00404040), CONST64(0x40404010,0x00404040), CONST64(0x40404000,0x40404040), CONST64(0x40404010,0x40404040)
  }};
  

static void cookey(const ulong32 *raw1, ulong32 *keyout);

static void deskey(const unsigned char *key, short edf, ulong32 *keyout)
{
    ulong32 i, j, l, m, n, kn[32];
    unsigned char pc1m[56], pcr[56];

    for (j=0; j < 56; j++) {
        l = (ulong32)pc1[j];
        m = l & 7;
        pc1m[j] = (unsigned char)((key[l >> 3U] & bytebit[m]) == bytebit[m] ? 1 : 0);
    }

    for (i=0; i < 16; i++) {
        if (edf == DE1) {
           m = (15 - i) << 1;
        } else {
           m = i << 1;
        }
        n = m + 1;
        kn[m] = kn[n] = 0L;
        for (j=0; j < 28; j++) {
            l = j + (ulong32)totrot[i];
            if (l < 28) {
               pcr[j] = pc1m[l];
            } else {
               pcr[j] = pc1m[l - 28];
            }
        }
        for (/*j = 28*/; j < 56; j++) {
            l = j + (ulong32)totrot[i];
            if (l < 56) {
               pcr[j] = pc1m[l];
            } else {
               pcr[j] = pc1m[l - 28];
            }
        }
        for (j=0; j < 24; j++)  {
            if ((int)pcr[(int)pc2[j]] != 0) {
               kn[m] |= bigbyte[j];
            }
            if ((int)pcr[(int)pc2[j+24]] != 0) {
               kn[n] |= bigbyte[j];
            }
        }
    }

    cookey(kn, keyout);
}

static void cookey(const ulong32 *raw1, ulong32 *keyout)
{
    ulong32 *cook;
    const ulong32 *raw0;
    ulong32 dough[32];
    int i;

    cook = dough;
    for(i=0; i < 16; i++, raw1++)
    {
        raw0 = raw1++;
        *cook    = (*raw0 & 0x00fc0000L) << 6;
        *cook   |= (*raw0 & 0x00000fc0L) << 10;
        *cook   |= (*raw1 & 0x00fc0000L) >> 10;
        *cook++ |= (*raw1 & 0x00000fc0L) >> 6;
        *cook    = (*raw0 & 0x0003f000L) << 12;
        *cook   |= (*raw0 & 0x0000003fL) << 16;
        *cook   |= (*raw1 & 0x0003f000L) >> 4;
        *cook++ |= (*raw1 & 0x0000003fL);
    }

    memcpy(keyout, dough, sizeof dough);
}

static void desfunc(ulong32 *block, const ulong32 *keys)
{
    ulong64 tmp;
    ulong32 work, right, leftt;
    int cur_round;

    leftt = block[0];
    right = block[1];

    tmp = des_ip[0][byte(leftt, 0)] ^
          des_ip[1][byte(leftt, 1)] ^
          des_ip[2][byte(leftt, 2)] ^
          des_ip[3][byte(leftt, 3)] ^
          des_ip[4][byte(right, 0)] ^
          des_ip[5][byte(right, 1)] ^
          des_ip[6][byte(right, 2)] ^
          des_ip[7][byte(right, 3)];
    leftt = (ulong32)(tmp >> 32);
    right = (ulong32)(tmp & 0xFFFFFFFFUL);

    for (cur_round = 0; cur_round < 8; cur_round++) {
        work  = ROR(right, 4) ^ *keys++;
        leftt ^= SP7[work        & 0x3fL]
              ^ SP5[(work >>  8) & 0x3fL]
              ^ SP3[(work >> 16) & 0x3fL]
              ^ SP1[(work >> 24) & 0x3fL];
        work  = right ^ *keys++;
        leftt ^= SP8[ work        & 0x3fL]
              ^  SP6[(work >>  8) & 0x3fL]
              ^  SP4[(work >> 16) & 0x3fL]
              ^  SP2[(work >> 24) & 0x3fL];

        work = ROR(leftt, 4) ^ *keys++;
        right ^= SP7[ work        & 0x3fL]
              ^  SP5[(work >>  8) & 0x3fL]
              ^  SP3[(work >> 16) & 0x3fL]
              ^  SP1[(work >> 24) & 0x3fL];
        work  = leftt ^ *keys++;
        right ^= SP8[ work        & 0x3fL]
              ^  SP6[(work >>  8) & 0x3fL]
              ^  SP4[(work >> 16) & 0x3fL]
              ^  SP2[(work >> 24) & 0x3fL];
    }

    tmp = des_fp[0][byte(leftt, 0)] ^
          des_fp[1][byte(leftt, 1)] ^
          des_fp[2][byte(leftt, 2)] ^
          des_fp[3][byte(leftt, 3)] ^
          des_fp[4][byte(right, 0)] ^
          des_fp[5][byte(right, 1)] ^
          des_fp[6][byte(right, 2)] ^
          des_fp[7][byte(right, 3)];
    leftt = (ulong32)(tmp >> 32);
    right = (ulong32)(tmp & 0xFFFFFFFFUL);
    
    block[0] = right;
    block[1] = leftt;
}

int des_setup(const unsigned char *key, int keylen, int num_rounds, des_key *des)
{
    if (num_rounds != 0 && num_rounds != 16) {
        return CRYPT_INVALID_ROUNDS;
    }

    if (keylen != 8) {
        return CRYPT_INVALID_KEYSIZE;
    }

    deskey(key, EN0, des->ek);
    deskey(key, DE1, des->dk);

    return CRYPT_OK;
}

int des3_setup(const unsigned char *key, int keylen, int num_rounds, des3_key *des3)
{
    if(num_rounds != 0 && num_rounds != 16) {
        return CRYPT_INVALID_ROUNDS;
    }

    if (keylen != 24) {
        return CRYPT_INVALID_KEYSIZE;
    }

    deskey(key,    EN0, des3->ek[0]);
    deskey(key+8,  DE1, des3->ek[1]);
    deskey(key+16, EN0, des3->ek[2]);

    deskey(key,    DE1, des3->dk[2]);
    deskey(key+8,  EN0, des3->dk[1]);
    deskey(key+16, DE1, des3->dk[0]);

    return CRYPT_OK;
}

void des_ecb_encrypt(const unsigned char *pt, unsigned char *ct, des_key *des)
{
    ulong32 work[2];
    LOAD32H(work[0], pt+0);
    LOAD32H(work[1], pt+4);
    desfunc(work, des->ek);
    STORE32H(work[0],ct+0);
    STORE32H(work[1],ct+4);
}

void des_ecb_decrypt(const unsigned char *ct, unsigned char *pt, des_key *des)
{
    ulong32 work[2];
    LOAD32H(work[0], ct+0);
    LOAD32H(work[1], ct+4);
    desfunc(work, des->dk);
    STORE32H(work[0],pt+0);
    STORE32H(work[1],pt+4);
}

void des3_ecb_encrypt(const unsigned char *pt, unsigned char *ct, des3_key *des3)
{
    ulong32 work[2];
    
    LOAD32H(work[0], pt+0);
    LOAD32H(work[1], pt+4);
    desfunc(work, des3->ek[0]);
    desfunc(work, des3->ek[1]);
    desfunc(work, des3->ek[2]);
    STORE32H(work[0],ct+0);
    STORE32H(work[1],ct+4);
}

void des3_ecb_decrypt(const unsigned char *ct, unsigned char *pt, des3_key *des3)
{
    ulong32 work[2];
    LOAD32H(work[0], ct+0);
    LOAD32H(work[1], ct+4);
    desfunc(work, des3->dk[0]);
    desfunc(work, des3->dk[1]);
    desfunc(work, des3->dk[2]);
    STORE32H(work[0],pt+0);
    STORE32H(work[1],pt+4);
}
