/* File generated automatically from tools/winapi/tests.dat; do not edit! */
/* This file can be copied, modified and distributed without restriction. */

/*
 * Unit tests for data structure packing
 */

#define WINVER 0x0501
#define _WIN32_IE 0x0501
#define _WIN32_WINNT 0x0501

#define WINE_NOWINSOCK

#include "windows.h"

#include "wine/test.h"

/***********************************************************************
 * Compatibility macros
 */

#define DWORD_PTR UINT_PTR
#define LONG_PTR INT_PTR
#define ULONG_PTR UINT_PTR

/***********************************************************************
 * Windows API extension
 */

#if defined(_MSC_VER) && (_MSC_VER >= 1300) && defined(__cplusplus)
# define _TYPE_ALIGNMENT(type) __alignof(type)
#elif defined(__GNUC__)
# define _TYPE_ALIGNMENT(type) __alignof__(type)
#else
/*
 * FIXME: May not be possible without a compiler extension
 *        (if type is not just a name that is, otherwise the normal
 *         TYPE_ALIGNMENT can be used)
 */
#endif

#if defined(TYPE_ALIGNMENT) && defined(_MSC_VER) && _MSC_VER >= 800 && !defined(__cplusplus)
#pragma warning(disable:4116)
#endif

#if !defined(TYPE_ALIGNMENT) && defined(_TYPE_ALIGNMENT)
# define TYPE_ALIGNMENT _TYPE_ALIGNMENT
#endif

/***********************************************************************
 * Test helper macros
 */

#define TEST_TYPE_SIZE(type, size)             C_ASSERT(sizeof(type) == size);

#ifdef TYPE_ALIGNMENT
# define TEST_TYPE_ALIGN(type, align)          C_ASSERT(TYPE_ALIGNMENT(type) == align);
#else
# define TEST_TYPE_ALIGN(type, align)
#endif

#ifdef _TYPE_ALIGNMENT
# define TEST_TARGET_ALIGN(type, align)        C_ASSERT(_TYPE_ALIGNMENT(*(type)0) == align);
# define TEST_FIELD_ALIGN(type, field, align)  C_ASSERT(_TYPE_ALIGNMENT(((type*)0)->field) == align);
#else
# define TEST_TARGET_ALIGN(type, align)
# define TEST_FIELD_ALIGN(type, field, align)
#endif

#define TEST_FIELD_OFFSET(type, field, offset) C_ASSERT(FIELD_OFFSET(type, field) == offset);

#define TEST_TARGET_SIZE(type, size)            TEST_TYPE_SIZE(*(type)0, size)
#define TEST_FIELD_SIZE(type, field, size)      TEST_TYPE_SIZE((((type*)0)->field), size)
#define TEST_TYPE_SIGNED(type)                  C_ASSERT((type) -1 < 0);
#define TEST_TYPE_UNSIGNED(type)                C_ASSERT((type) -1 > 0);


#ifdef _WIN64

static void test_pack_ACCESSTIMEOUT(void)
{
    /* ACCESSTIMEOUT */
    TEST_TYPE_SIZE   (ACCESSTIMEOUT, 12)
    TEST_TYPE_ALIGN  (ACCESSTIMEOUT, 4)
    TEST_FIELD_SIZE  (ACCESSTIMEOUT, cbSize, 4)
    TEST_FIELD_ALIGN (ACCESSTIMEOUT, cbSize, 4)
    TEST_FIELD_OFFSET(ACCESSTIMEOUT, cbSize, 0)
    TEST_FIELD_SIZE  (ACCESSTIMEOUT, dwFlags, 4)
    TEST_FIELD_ALIGN (ACCESSTIMEOUT, dwFlags, 4)
    TEST_FIELD_OFFSET(ACCESSTIMEOUT, dwFlags, 4)
    TEST_FIELD_SIZE  (ACCESSTIMEOUT, iTimeOutMSec, 4)
    TEST_FIELD_ALIGN (ACCESSTIMEOUT, iTimeOutMSec, 4)
    TEST_FIELD_OFFSET(ACCESSTIMEOUT, iTimeOutMSec, 8)
}

static void test_pack_ANIMATIONINFO(void)
{
    /* ANIMATIONINFO */
    TEST_TYPE_SIZE   (ANIMATIONINFO, 8)
    TEST_TYPE_ALIGN  (ANIMATIONINFO, 4)
    TEST_FIELD_SIZE  (ANIMATIONINFO, cbSize, 4)
    TEST_FIELD_ALIGN (ANIMATIONINFO, cbSize, 4)
    TEST_FIELD_OFFSET(ANIMATIONINFO, cbSize, 0)
    TEST_FIELD_SIZE  (ANIMATIONINFO, iMinAnimate, 4)
    TEST_FIELD_ALIGN (ANIMATIONINFO, iMinAnimate, 4)
    TEST_FIELD_OFFSET(ANIMATIONINFO, iMinAnimate, 4)
}

static void test_pack_CBTACTIVATESTRUCT(void)
{
    /* CBTACTIVATESTRUCT */
    TEST_TYPE_SIZE   (CBTACTIVATESTRUCT, 16)
    TEST_TYPE_ALIGN  (CBTACTIVATESTRUCT, 8)
    TEST_FIELD_SIZE  (CBTACTIVATESTRUCT, fMouse, 4)
    TEST_FIELD_ALIGN (CBTACTIVATESTRUCT, fMouse, 4)
    TEST_FIELD_OFFSET(CBTACTIVATESTRUCT, fMouse, 0)
    TEST_FIELD_SIZE  (CBTACTIVATESTRUCT, hWndActive, 8)
    TEST_FIELD_ALIGN (CBTACTIVATESTRUCT, hWndActive, 8)
    TEST_FIELD_OFFSET(CBTACTIVATESTRUCT, hWndActive, 8)
}

static void test_pack_CBT_CREATEWNDA(void)
{
    /* CBT_CREATEWNDA */
    TEST_TYPE_SIZE   (CBT_CREATEWNDA, 16)
    TEST_TYPE_ALIGN  (CBT_CREATEWNDA, 8)
    TEST_FIELD_SIZE  (CBT_CREATEWNDA, lpcs, 8)
    TEST_FIELD_ALIGN (CBT_CREATEWNDA, lpcs, 8)
    TEST_FIELD_OFFSET(CBT_CREATEWNDA, lpcs, 0)
    TEST_FIELD_SIZE  (CBT_CREATEWNDA, hwndInsertAfter, 8)
    TEST_FIELD_ALIGN (CBT_CREATEWNDA, hwndInsertAfter, 8)
    TEST_FIELD_OFFSET(CBT_CREATEWNDA, hwndInsertAfter, 8)
}

static void test_pack_CBT_CREATEWNDW(void)
{
    /* CBT_CREATEWNDW */
    TEST_TYPE_SIZE   (CBT_CREATEWNDW, 16)
    TEST_TYPE_ALIGN  (CBT_CREATEWNDW, 8)
    TEST_FIELD_SIZE  (CBT_CREATEWNDW, lpcs, 8)
    TEST_FIELD_ALIGN (CBT_CREATEWNDW, lpcs, 8)
    TEST_FIELD_OFFSET(CBT_CREATEWNDW, lpcs, 0)
    TEST_FIELD_SIZE  (CBT_CREATEWNDW, hwndInsertAfter, 8)
    TEST_FIELD_ALIGN (CBT_CREATEWNDW, hwndInsertAfter, 8)
    TEST_FIELD_OFFSET(CBT_CREATEWNDW, hwndInsertAfter, 8)
}

static void test_pack_CLIENTCREATESTRUCT(void)
{
    /* CLIENTCREATESTRUCT */
    TEST_TYPE_SIZE   (CLIENTCREATESTRUCT, 16)
    TEST_TYPE_ALIGN  (CLIENTCREATESTRUCT, 8)
    TEST_FIELD_SIZE  (CLIENTCREATESTRUCT, hWindowMenu, 8)
    TEST_FIELD_ALIGN (CLIENTCREATESTRUCT, hWindowMenu, 8)
    TEST_FIELD_OFFSET(CLIENTCREATESTRUCT, hWindowMenu, 0)
    TEST_FIELD_SIZE  (CLIENTCREATESTRUCT, idFirstChild, 4)
    TEST_FIELD_ALIGN (CLIENTCREATESTRUCT, idFirstChild, 4)
    TEST_FIELD_OFFSET(CLIENTCREATESTRUCT, idFirstChild, 8)
}

static void test_pack_COMBOBOXINFO(void)
{
    /* COMBOBOXINFO */
    TEST_TYPE_SIZE   (COMBOBOXINFO, 64)
    TEST_TYPE_ALIGN  (COMBOBOXINFO, 8)
    TEST_FIELD_SIZE  (COMBOBOXINFO, cbSize, 4)
    TEST_FIELD_ALIGN (COMBOBOXINFO, cbSize, 4)
    TEST_FIELD_OFFSET(COMBOBOXINFO, cbSize, 0)
    TEST_FIELD_SIZE  (COMBOBOXINFO, rcItem, 16)
    TEST_FIELD_ALIGN (COMBOBOXINFO, rcItem, 4)
    TEST_FIELD_OFFSET(COMBOBOXINFO, rcItem, 4)
    TEST_FIELD_SIZE  (COMBOBOXINFO, rcButton, 16)
    TEST_FIELD_ALIGN (COMBOBOXINFO, rcButton, 4)
    TEST_FIELD_OFFSET(COMBOBOXINFO, rcButton, 20)
    TEST_FIELD_SIZE  (COMBOBOXINFO, stateButton, 4)
    TEST_FIELD_ALIGN (COMBOBOXINFO, stateButton, 4)
    TEST_FIELD_OFFSET(COMBOBOXINFO, stateButton, 36)
    TEST_FIELD_SIZE  (COMBOBOXINFO, hwndCombo, 8)
    TEST_FIELD_ALIGN (COMBOBOXINFO, hwndCombo, 8)
    TEST_FIELD_OFFSET(COMBOBOXINFO, hwndCombo, 40)
    TEST_FIELD_SIZE  (COMBOBOXINFO, hwndItem, 8)
    TEST_FIELD_ALIGN (COMBOBOXINFO, hwndItem, 8)
    TEST_FIELD_OFFSET(COMBOBOXINFO, hwndItem, 48)
    TEST_FIELD_SIZE  (COMBOBOXINFO, hwndList, 8)
    TEST_FIELD_ALIGN (COMBOBOXINFO, hwndList, 8)
    TEST_FIELD_OFFSET(COMBOBOXINFO, hwndList, 56)
}

static void test_pack_COMPAREITEMSTRUCT(void)
{
    /* COMPAREITEMSTRUCT */
    TEST_TYPE_SIZE   (COMPAREITEMSTRUCT, 56)
    TEST_TYPE_ALIGN  (COMPAREITEMSTRUCT, 8)
    TEST_FIELD_SIZE  (COMPAREITEMSTRUCT, CtlType, 4)
    TEST_FIELD_ALIGN (COMPAREITEMSTRUCT, CtlType, 4)
    TEST_FIELD_OFFSET(COMPAREITEMSTRUCT, CtlType, 0)
    TEST_FIELD_SIZE  (COMPAREITEMSTRUCT, CtlID, 4)
    TEST_FIELD_ALIGN (COMPAREITEMSTRUCT, CtlID, 4)
    TEST_FIELD_OFFSET(COMPAREITEMSTRUCT, CtlID, 4)
    TEST_FIELD_SIZE  (COMPAREITEMSTRUCT, hwndItem, 8)
    TEST_FIELD_ALIGN (COMPAREITEMSTRUCT, hwndItem, 8)
    TEST_FIELD_OFFSET(COMPAREITEMSTRUCT, hwndItem, 8)
    TEST_FIELD_SIZE  (COMPAREITEMSTRUCT, itemID1, 4)
    TEST_FIELD_ALIGN (COMPAREITEMSTRUCT, itemID1, 4)
    TEST_FIELD_OFFSET(COMPAREITEMSTRUCT, itemID1, 16)
    TEST_FIELD_SIZE  (COMPAREITEMSTRUCT, itemData1, 8)
    TEST_FIELD_ALIGN (COMPAREITEMSTRUCT, itemData1, 8)
    TEST_FIELD_OFFSET(COMPAREITEMSTRUCT, itemData1, 24)
    TEST_FIELD_SIZE  (COMPAREITEMSTRUCT, itemID2, 4)
    TEST_FIELD_ALIGN (COMPAREITEMSTRUCT, itemID2, 4)
    TEST_FIELD_OFFSET(COMPAREITEMSTRUCT, itemID2, 32)
    TEST_FIELD_SIZE  (COMPAREITEMSTRUCT, itemData2, 8)
    TEST_FIELD_ALIGN (COMPAREITEMSTRUCT, itemData2, 8)
    TEST_FIELD_OFFSET(COMPAREITEMSTRUCT, itemData2, 40)
    TEST_FIELD_SIZE  (COMPAREITEMSTRUCT, dwLocaleId, 4)
    TEST_FIELD_ALIGN (COMPAREITEMSTRUCT, dwLocaleId, 4)
    TEST_FIELD_OFFSET(COMPAREITEMSTRUCT, dwLocaleId, 48)
}

static void test_pack_COPYDATASTRUCT(void)
{
    /* COPYDATASTRUCT */
    TEST_TYPE_SIZE   (COPYDATASTRUCT, 24)
    TEST_TYPE_ALIGN  (COPYDATASTRUCT, 8)
    TEST_FIELD_SIZE  (COPYDATASTRUCT, dwData, 8)
    TEST_FIELD_ALIGN (COPYDATASTRUCT, dwData, 8)
    TEST_FIELD_OFFSET(COPYDATASTRUCT, dwData, 0)
    TEST_FIELD_SIZE  (COPYDATASTRUCT, cbData, 4)
    TEST_FIELD_ALIGN (COPYDATASTRUCT, cbData, 4)
    TEST_FIELD_OFFSET(COPYDATASTRUCT, cbData, 8)
    TEST_FIELD_SIZE  (COPYDATASTRUCT, lpData, 8)
    TEST_FIELD_ALIGN (COPYDATASTRUCT, lpData, 8)
    TEST_FIELD_OFFSET(COPYDATASTRUCT, lpData, 16)
}

static void test_pack_CREATESTRUCTA(void)
{
    /* CREATESTRUCTA */
    TEST_TYPE_SIZE   (CREATESTRUCTA, 80)
    TEST_TYPE_ALIGN  (CREATESTRUCTA, 8)
    TEST_FIELD_SIZE  (CREATESTRUCTA, lpCreateParams, 8)
    TEST_FIELD_ALIGN (CREATESTRUCTA, lpCreateParams, 8)
    TEST_FIELD_OFFSET(CREATESTRUCTA, lpCreateParams, 0)
    TEST_FIELD_SIZE  (CREATESTRUCTA, hInstance, 8)
    TEST_FIELD_ALIGN (CREATESTRUCTA, hInstance, 8)
    TEST_FIELD_OFFSET(CREATESTRUCTA, hInstance, 8)
    TEST_FIELD_SIZE  (CREATESTRUCTA, hMenu, 8)
    TEST_FIELD_ALIGN (CREATESTRUCTA, hMenu, 8)
    TEST_FIELD_OFFSET(CREATESTRUCTA, hMenu, 16)
    TEST_FIELD_SIZE  (CREATESTRUCTA, hwndParent, 8)
    TEST_FIELD_ALIGN (CREATESTRUCTA, hwndParent, 8)
    TEST_FIELD_OFFSET(CREATESTRUCTA, hwndParent, 24)
    TEST_FIELD_SIZE  (CREATESTRUCTA, cy, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTA, cy, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTA, cy, 32)
    TEST_FIELD_SIZE  (CREATESTRUCTA, cx, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTA, cx, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTA, cx, 36)
    TEST_FIELD_SIZE  (CREATESTRUCTA, y, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTA, y, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTA, y, 40)
    TEST_FIELD_SIZE  (CREATESTRUCTA, x, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTA, x, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTA, x, 44)
    TEST_FIELD_SIZE  (CREATESTRUCTA, style, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTA, style, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTA, style, 48)
    TEST_FIELD_SIZE  (CREATESTRUCTA, lpszName, 8)
    TEST_FIELD_ALIGN (CREATESTRUCTA, lpszName, 8)
    TEST_FIELD_OFFSET(CREATESTRUCTA, lpszName, 56)
    TEST_FIELD_SIZE  (CREATESTRUCTA, lpszClass, 8)
    TEST_FIELD_ALIGN (CREATESTRUCTA, lpszClass, 8)
    TEST_FIELD_OFFSET(CREATESTRUCTA, lpszClass, 64)
    TEST_FIELD_SIZE  (CREATESTRUCTA, dwExStyle, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTA, dwExStyle, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTA, dwExStyle, 72)
}

static void test_pack_CREATESTRUCTW(void)
{
    /* CREATESTRUCTW */
    TEST_TYPE_SIZE   (CREATESTRUCTW, 80)
    TEST_TYPE_ALIGN  (CREATESTRUCTW, 8)
    TEST_FIELD_SIZE  (CREATESTRUCTW, lpCreateParams, 8)
    TEST_FIELD_ALIGN (CREATESTRUCTW, lpCreateParams, 8)
    TEST_FIELD_OFFSET(CREATESTRUCTW, lpCreateParams, 0)
    TEST_FIELD_SIZE  (CREATESTRUCTW, hInstance, 8)
    TEST_FIELD_ALIGN (CREATESTRUCTW, hInstance, 8)
    TEST_FIELD_OFFSET(CREATESTRUCTW, hInstance, 8)
    TEST_FIELD_SIZE  (CREATESTRUCTW, hMenu, 8)
    TEST_FIELD_ALIGN (CREATESTRUCTW, hMenu, 8)
    TEST_FIELD_OFFSET(CREATESTRUCTW, hMenu, 16)
    TEST_FIELD_SIZE  (CREATESTRUCTW, hwndParent, 8)
    TEST_FIELD_ALIGN (CREATESTRUCTW, hwndParent, 8)
    TEST_FIELD_OFFSET(CREATESTRUCTW, hwndParent, 24)
    TEST_FIELD_SIZE  (CREATESTRUCTW, cy, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTW, cy, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTW, cy, 32)
    TEST_FIELD_SIZE  (CREATESTRUCTW, cx, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTW, cx, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTW, cx, 36)
    TEST_FIELD_SIZE  (CREATESTRUCTW, y, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTW, y, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTW, y, 40)
    TEST_FIELD_SIZE  (CREATESTRUCTW, x, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTW, x, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTW, x, 44)
    TEST_FIELD_SIZE  (CREATESTRUCTW, style, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTW, style, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTW, style, 48)
    TEST_FIELD_SIZE  (CREATESTRUCTW, lpszName, 8)
    TEST_FIELD_ALIGN (CREATESTRUCTW, lpszName, 8)
    TEST_FIELD_OFFSET(CREATESTRUCTW, lpszName, 56)
    TEST_FIELD_SIZE  (CREATESTRUCTW, lpszClass, 8)
    TEST_FIELD_ALIGN (CREATESTRUCTW, lpszClass, 8)
    TEST_FIELD_OFFSET(CREATESTRUCTW, lpszClass, 64)
    TEST_FIELD_SIZE  (CREATESTRUCTW, dwExStyle, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTW, dwExStyle, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTW, dwExStyle, 72)
}

static void test_pack_CURSORINFO(void)
{
    /* CURSORINFO */
    TEST_TYPE_SIZE   (CURSORINFO, 24)
    TEST_TYPE_ALIGN  (CURSORINFO, 8)
    TEST_FIELD_SIZE  (CURSORINFO, cbSize, 4)
    TEST_FIELD_ALIGN (CURSORINFO, cbSize, 4)
    TEST_FIELD_OFFSET(CURSORINFO, cbSize, 0)
    TEST_FIELD_SIZE  (CURSORINFO, flags, 4)
    TEST_FIELD_ALIGN (CURSORINFO, flags, 4)
    TEST_FIELD_OFFSET(CURSORINFO, flags, 4)
    TEST_FIELD_SIZE  (CURSORINFO, hCursor, 8)
    TEST_FIELD_ALIGN (CURSORINFO, hCursor, 8)
    TEST_FIELD_OFFSET(CURSORINFO, hCursor, 8)
    TEST_FIELD_SIZE  (CURSORINFO, ptScreenPos, 8)
    TEST_FIELD_ALIGN (CURSORINFO, ptScreenPos, 4)
    TEST_FIELD_OFFSET(CURSORINFO, ptScreenPos, 16)
}

static void test_pack_CWPRETSTRUCT(void)
{
    /* CWPRETSTRUCT */
    TEST_TYPE_SIZE   (CWPRETSTRUCT, 40)
    TEST_TYPE_ALIGN  (CWPRETSTRUCT, 8)
    TEST_FIELD_SIZE  (CWPRETSTRUCT, lResult, 8)
    TEST_FIELD_ALIGN (CWPRETSTRUCT, lResult, 8)
    TEST_FIELD_OFFSET(CWPRETSTRUCT, lResult, 0)
    TEST_FIELD_SIZE  (CWPRETSTRUCT, lParam, 8)
    TEST_FIELD_ALIGN (CWPRETSTRUCT, lParam, 8)
    TEST_FIELD_OFFSET(CWPRETSTRUCT, lParam, 8)
    TEST_FIELD_SIZE  (CWPRETSTRUCT, wParam, 8)
    TEST_FIELD_ALIGN (CWPRETSTRUCT, wParam, 8)
    TEST_FIELD_OFFSET(CWPRETSTRUCT, wParam, 16)
    TEST_FIELD_SIZE  (CWPRETSTRUCT, message, 4)
    TEST_FIELD_ALIGN (CWPRETSTRUCT, message, 4)
    TEST_FIELD_OFFSET(CWPRETSTRUCT, message, 24)
    TEST_FIELD_SIZE  (CWPRETSTRUCT, hwnd, 8)
    TEST_FIELD_ALIGN (CWPRETSTRUCT, hwnd, 8)
    TEST_FIELD_OFFSET(CWPRETSTRUCT, hwnd, 32)
}

static void test_pack_CWPSTRUCT(void)
{
    /* CWPSTRUCT */
    TEST_TYPE_SIZE   (CWPSTRUCT, 32)
    TEST_TYPE_ALIGN  (CWPSTRUCT, 8)
    TEST_FIELD_SIZE  (CWPSTRUCT, lParam, 8)
    TEST_FIELD_ALIGN (CWPSTRUCT, lParam, 8)
    TEST_FIELD_OFFSET(CWPSTRUCT, lParam, 0)
    TEST_FIELD_SIZE  (CWPSTRUCT, wParam, 8)
    TEST_FIELD_ALIGN (CWPSTRUCT, wParam, 8)
    TEST_FIELD_OFFSET(CWPSTRUCT, wParam, 8)
    TEST_FIELD_SIZE  (CWPSTRUCT, message, 4)
    TEST_FIELD_ALIGN (CWPSTRUCT, message, 4)
    TEST_FIELD_OFFSET(CWPSTRUCT, message, 16)
    TEST_FIELD_SIZE  (CWPSTRUCT, hwnd, 8)
    TEST_FIELD_ALIGN (CWPSTRUCT, hwnd, 8)
    TEST_FIELD_OFFSET(CWPSTRUCT, hwnd, 24)
}

static void test_pack_DEBUGHOOKINFO(void)
{
    /* DEBUGHOOKINFO */
    TEST_TYPE_SIZE   (DEBUGHOOKINFO, 32)
    TEST_TYPE_ALIGN  (DEBUGHOOKINFO, 8)
    TEST_FIELD_SIZE  (DEBUGHOOKINFO, idThread, 4)
    TEST_FIELD_ALIGN (DEBUGHOOKINFO, idThread, 4)
    TEST_FIELD_OFFSET(DEBUGHOOKINFO, idThread, 0)
    TEST_FIELD_SIZE  (DEBUGHOOKINFO, idThreadInstaller, 4)
    TEST_FIELD_ALIGN (DEBUGHOOKINFO, idThreadInstaller, 4)
    TEST_FIELD_OFFSET(DEBUGHOOKINFO, idThreadInstaller, 4)
    TEST_FIELD_SIZE  (DEBUGHOOKINFO, lParam, 8)
    TEST_FIELD_ALIGN (DEBUGHOOKINFO, lParam, 8)
    TEST_FIELD_OFFSET(DEBUGHOOKINFO, lParam, 8)
    TEST_FIELD_SIZE  (DEBUGHOOKINFO, wParam, 8)
    TEST_FIELD_ALIGN (DEBUGHOOKINFO, wParam, 8)
    TEST_FIELD_OFFSET(DEBUGHOOKINFO, wParam, 16)
    TEST_FIELD_SIZE  (DEBUGHOOKINFO, code, 4)
    TEST_FIELD_ALIGN (DEBUGHOOKINFO, code, 4)
    TEST_FIELD_OFFSET(DEBUGHOOKINFO, code, 24)
}

static void test_pack_DELETEITEMSTRUCT(void)
{
    /* DELETEITEMSTRUCT */
    TEST_TYPE_SIZE   (DELETEITEMSTRUCT, 32)
    TEST_TYPE_ALIGN  (DELETEITEMSTRUCT, 8)
    TEST_FIELD_SIZE  (DELETEITEMSTRUCT, CtlType, 4)
    TEST_FIELD_ALIGN (DELETEITEMSTRUCT, CtlType, 4)
    TEST_FIELD_OFFSET(DELETEITEMSTRUCT, CtlType, 0)
    TEST_FIELD_SIZE  (DELETEITEMSTRUCT, CtlID, 4)
    TEST_FIELD_ALIGN (DELETEITEMSTRUCT, CtlID, 4)
    TEST_FIELD_OFFSET(DELETEITEMSTRUCT, CtlID, 4)
    TEST_FIELD_SIZE  (DELETEITEMSTRUCT, itemID, 4)
    TEST_FIELD_ALIGN (DELETEITEMSTRUCT, itemID, 4)
    TEST_FIELD_OFFSET(DELETEITEMSTRUCT, itemID, 8)
    TEST_FIELD_SIZE  (DELETEITEMSTRUCT, hwndItem, 8)
    TEST_FIELD_ALIGN (DELETEITEMSTRUCT, hwndItem, 8)
    TEST_FIELD_OFFSET(DELETEITEMSTRUCT, hwndItem, 16)
    TEST_FIELD_SIZE  (DELETEITEMSTRUCT, itemData, 8)
    TEST_FIELD_ALIGN (DELETEITEMSTRUCT, itemData, 8)
    TEST_FIELD_OFFSET(DELETEITEMSTRUCT, itemData, 24)
}

static void test_pack_DESKTOPENUMPROCA(void)
{
    /* DESKTOPENUMPROCA */
    TEST_TYPE_SIZE   (DESKTOPENUMPROCA, 8)
    TEST_TYPE_ALIGN  (DESKTOPENUMPROCA, 8)
}

static void test_pack_DESKTOPENUMPROCW(void)
{
    /* DESKTOPENUMPROCW */
    TEST_TYPE_SIZE   (DESKTOPENUMPROCW, 8)
    TEST_TYPE_ALIGN  (DESKTOPENUMPROCW, 8)
}

static void test_pack_DLGITEMTEMPLATE(void)
{
    /* DLGITEMTEMPLATE (pack 2) */
    TEST_TYPE_SIZE   (DLGITEMTEMPLATE, 18)
    TEST_TYPE_ALIGN  (DLGITEMTEMPLATE, 2)
    TEST_FIELD_SIZE  (DLGITEMTEMPLATE, style, 4)
    TEST_FIELD_ALIGN (DLGITEMTEMPLATE, style, 2)
    TEST_FIELD_OFFSET(DLGITEMTEMPLATE, style, 0)
    TEST_FIELD_SIZE  (DLGITEMTEMPLATE, dwExtendedStyle, 4)
    TEST_FIELD_ALIGN (DLGITEMTEMPLATE, dwExtendedStyle, 2)
    TEST_FIELD_OFFSET(DLGITEMTEMPLATE, dwExtendedStyle, 4)
    TEST_FIELD_SIZE  (DLGITEMTEMPLATE, x, 2)
    TEST_FIELD_ALIGN (DLGITEMTEMPLATE, x, 2)
    TEST_FIELD_OFFSET(DLGITEMTEMPLATE, x, 8)
    TEST_FIELD_SIZE  (DLGITEMTEMPLATE, y, 2)
    TEST_FIELD_ALIGN (DLGITEMTEMPLATE, y, 2)
    TEST_FIELD_OFFSET(DLGITEMTEMPLATE, y, 10)
    TEST_FIELD_SIZE  (DLGITEMTEMPLATE, cx, 2)
    TEST_FIELD_ALIGN (DLGITEMTEMPLATE, cx, 2)
    TEST_FIELD_OFFSET(DLGITEMTEMPLATE, cx, 12)
    TEST_FIELD_SIZE  (DLGITEMTEMPLATE, cy, 2)
    TEST_FIELD_ALIGN (DLGITEMTEMPLATE, cy, 2)
    TEST_FIELD_OFFSET(DLGITEMTEMPLATE, cy, 14)
    TEST_FIELD_SIZE  (DLGITEMTEMPLATE, id, 2)
    TEST_FIELD_ALIGN (DLGITEMTEMPLATE, id, 2)
    TEST_FIELD_OFFSET(DLGITEMTEMPLATE, id, 16)
}

static void test_pack_DLGPROC(void)
{
    /* DLGPROC */
    TEST_TYPE_SIZE   (DLGPROC, 8)
    TEST_TYPE_ALIGN  (DLGPROC, 8)
}

static void test_pack_DLGTEMPLATE(void)
{
    /* DLGTEMPLATE (pack 2) */
    TEST_TYPE_SIZE   (DLGTEMPLATE, 18)
    TEST_TYPE_ALIGN  (DLGTEMPLATE, 2)
    TEST_FIELD_SIZE  (DLGTEMPLATE, style, 4)
    TEST_FIELD_ALIGN (DLGTEMPLATE, style, 2)
    TEST_FIELD_OFFSET(DLGTEMPLATE, style, 0)
    TEST_FIELD_SIZE  (DLGTEMPLATE, dwExtendedStyle, 4)
    TEST_FIELD_ALIGN (DLGTEMPLATE, dwExtendedStyle, 2)
    TEST_FIELD_OFFSET(DLGTEMPLATE, dwExtendedStyle, 4)
    TEST_FIELD_SIZE  (DLGTEMPLATE, cdit, 2)
    TEST_FIELD_ALIGN (DLGTEMPLATE, cdit, 2)
    TEST_FIELD_OFFSET(DLGTEMPLATE, cdit, 8)
    TEST_FIELD_SIZE  (DLGTEMPLATE, x, 2)
    TEST_FIELD_ALIGN (DLGTEMPLATE, x, 2)
    TEST_FIELD_OFFSET(DLGTEMPLATE, x, 10)
    TEST_FIELD_SIZE  (DLGTEMPLATE, y, 2)
    TEST_FIELD_ALIGN (DLGTEMPLATE, y, 2)
    TEST_FIELD_OFFSET(DLGTEMPLATE, y, 12)
    TEST_FIELD_SIZE  (DLGTEMPLATE, cx, 2)
    TEST_FIELD_ALIGN (DLGTEMPLATE, cx, 2)
    TEST_FIELD_OFFSET(DLGTEMPLATE, cx, 14)
    TEST_FIELD_SIZE  (DLGTEMPLATE, cy, 2)
    TEST_FIELD_ALIGN (DLGTEMPLATE, cy, 2)
    TEST_FIELD_OFFSET(DLGTEMPLATE, cy, 16)
}

static void test_pack_DRAWITEMSTRUCT(void)
{
    /* DRAWITEMSTRUCT */
    TEST_TYPE_SIZE   (DRAWITEMSTRUCT, 64)
    TEST_TYPE_ALIGN  (DRAWITEMSTRUCT, 8)
    TEST_FIELD_SIZE  (DRAWITEMSTRUCT, CtlType, 4)
    TEST_FIELD_ALIGN (DRAWITEMSTRUCT, CtlType, 4)
    TEST_FIELD_OFFSET(DRAWITEMSTRUCT, CtlType, 0)
    TEST_FIELD_SIZE  (DRAWITEMSTRUCT, CtlID, 4)
    TEST_FIELD_ALIGN (DRAWITEMSTRUCT, CtlID, 4)
    TEST_FIELD_OFFSET(DRAWITEMSTRUCT, CtlID, 4)
    TEST_FIELD_SIZE  (DRAWITEMSTRUCT, itemID, 4)
    TEST_FIELD_ALIGN (DRAWITEMSTRUCT, itemID, 4)
    TEST_FIELD_OFFSET(DRAWITEMSTRUCT, itemID, 8)
    TEST_FIELD_SIZE  (DRAWITEMSTRUCT, itemAction, 4)
    TEST_FIELD_ALIGN (DRAWITEMSTRUCT, itemAction, 4)
    TEST_FIELD_OFFSET(DRAWITEMSTRUCT, itemAction, 12)
    TEST_FIELD_SIZE  (DRAWITEMSTRUCT, itemState, 4)
    TEST_FIELD_ALIGN (DRAWITEMSTRUCT, itemState, 4)
    TEST_FIELD_OFFSET(DRAWITEMSTRUCT, itemState, 16)
    TEST_FIELD_SIZE  (DRAWITEMSTRUCT, hwndItem, 8)
    TEST_FIELD_ALIGN (DRAWITEMSTRUCT, hwndItem, 8)
    TEST_FIELD_OFFSET(DRAWITEMSTRUCT, hwndItem, 24)
    TEST_FIELD_SIZE  (DRAWITEMSTRUCT, hDC, 8)
    TEST_FIELD_ALIGN (DRAWITEMSTRUCT, hDC, 8)
    TEST_FIELD_OFFSET(DRAWITEMSTRUCT, hDC, 32)
    TEST_FIELD_SIZE  (DRAWITEMSTRUCT, rcItem, 16)
    TEST_FIELD_ALIGN (DRAWITEMSTRUCT, rcItem, 4)
    TEST_FIELD_OFFSET(DRAWITEMSTRUCT, rcItem, 40)
    TEST_FIELD_SIZE  (DRAWITEMSTRUCT, itemData, 8)
    TEST_FIELD_ALIGN (DRAWITEMSTRUCT, itemData, 8)
    TEST_FIELD_OFFSET(DRAWITEMSTRUCT, itemData, 56)
}

static void test_pack_DRAWSTATEPROC(void)
{
    /* DRAWSTATEPROC */
    TEST_TYPE_SIZE   (DRAWSTATEPROC, 8)
    TEST_TYPE_ALIGN  (DRAWSTATEPROC, 8)
}

static void test_pack_DRAWTEXTPARAMS(void)
{
    /* DRAWTEXTPARAMS */
    TEST_TYPE_SIZE   (DRAWTEXTPARAMS, 20)
    TEST_TYPE_ALIGN  (DRAWTEXTPARAMS, 4)
    TEST_FIELD_SIZE  (DRAWTEXTPARAMS, cbSize, 4)
    TEST_FIELD_ALIGN (DRAWTEXTPARAMS, cbSize, 4)
    TEST_FIELD_OFFSET(DRAWTEXTPARAMS, cbSize, 0)
    TEST_FIELD_SIZE  (DRAWTEXTPARAMS, iTabLength, 4)
    TEST_FIELD_ALIGN (DRAWTEXTPARAMS, iTabLength, 4)
    TEST_FIELD_OFFSET(DRAWTEXTPARAMS, iTabLength, 4)
    TEST_FIELD_SIZE  (DRAWTEXTPARAMS, iLeftMargin, 4)
    TEST_FIELD_ALIGN (DRAWTEXTPARAMS, iLeftMargin, 4)
    TEST_FIELD_OFFSET(DRAWTEXTPARAMS, iLeftMargin, 8)
    TEST_FIELD_SIZE  (DRAWTEXTPARAMS, iRightMargin, 4)
    TEST_FIELD_ALIGN (DRAWTEXTPARAMS, iRightMargin, 4)
    TEST_FIELD_OFFSET(DRAWTEXTPARAMS, iRightMargin, 12)
    TEST_FIELD_SIZE  (DRAWTEXTPARAMS, uiLengthDrawn, 4)
    TEST_FIELD_ALIGN (DRAWTEXTPARAMS, uiLengthDrawn, 4)
    TEST_FIELD_OFFSET(DRAWTEXTPARAMS, uiLengthDrawn, 16)
}

static void test_pack_EDITWORDBREAKPROCA(void)
{
    /* EDITWORDBREAKPROCA */
    TEST_TYPE_SIZE   (EDITWORDBREAKPROCA, 8)
    TEST_TYPE_ALIGN  (EDITWORDBREAKPROCA, 8)
}

static void test_pack_EDITWORDBREAKPROCW(void)
{
    /* EDITWORDBREAKPROCW */
    TEST_TYPE_SIZE   (EDITWORDBREAKPROCW, 8)
    TEST_TYPE_ALIGN  (EDITWORDBREAKPROCW, 8)
}

static void test_pack_EVENTMSG(void)
{
    /* EVENTMSG */
    TEST_TYPE_SIZE   (EVENTMSG, 24)
    TEST_TYPE_ALIGN  (EVENTMSG, 8)
    TEST_FIELD_SIZE  (EVENTMSG, message, 4)
    TEST_FIELD_ALIGN (EVENTMSG, message, 4)
    TEST_FIELD_OFFSET(EVENTMSG, message, 0)
    TEST_FIELD_SIZE  (EVENTMSG, paramL, 4)
    TEST_FIELD_ALIGN (EVENTMSG, paramL, 4)
    TEST_FIELD_OFFSET(EVENTMSG, paramL, 4)
    TEST_FIELD_SIZE  (EVENTMSG, paramH, 4)
    TEST_FIELD_ALIGN (EVENTMSG, paramH, 4)
    TEST_FIELD_OFFSET(EVENTMSG, paramH, 8)
    TEST_FIELD_SIZE  (EVENTMSG, time, 4)
    TEST_FIELD_ALIGN (EVENTMSG, time, 4)
    TEST_FIELD_OFFSET(EVENTMSG, time, 12)
    TEST_FIELD_SIZE  (EVENTMSG, hwnd, 8)
    TEST_FIELD_ALIGN (EVENTMSG, hwnd, 8)
    TEST_FIELD_OFFSET(EVENTMSG, hwnd, 16)
}

static void test_pack_FILTERKEYS(void)
{
    /* FILTERKEYS */
    TEST_TYPE_SIZE   (FILTERKEYS, 24)
    TEST_TYPE_ALIGN  (FILTERKEYS, 4)
    TEST_FIELD_SIZE  (FILTERKEYS, cbSize, 4)
    TEST_FIELD_ALIGN (FILTERKEYS, cbSize, 4)
    TEST_FIELD_OFFSET(FILTERKEYS, cbSize, 0)
    TEST_FIELD_SIZE  (FILTERKEYS, dwFlags, 4)
    TEST_FIELD_ALIGN (FILTERKEYS, dwFlags, 4)
    TEST_FIELD_OFFSET(FILTERKEYS, dwFlags, 4)
    TEST_FIELD_SIZE  (FILTERKEYS, iWaitMSec, 4)
    TEST_FIELD_ALIGN (FILTERKEYS, iWaitMSec, 4)
    TEST_FIELD_OFFSET(FILTERKEYS, iWaitMSec, 8)
    TEST_FIELD_SIZE  (FILTERKEYS, iDelayMSec, 4)
    TEST_FIELD_ALIGN (FILTERKEYS, iDelayMSec, 4)
    TEST_FIELD_OFFSET(FILTERKEYS, iDelayMSec, 12)
    TEST_FIELD_SIZE  (FILTERKEYS, iRepeatMSec, 4)
    TEST_FIELD_ALIGN (FILTERKEYS, iRepeatMSec, 4)
    TEST_FIELD_OFFSET(FILTERKEYS, iRepeatMSec, 16)
    TEST_FIELD_SIZE  (FILTERKEYS, iBounceMSec, 4)
    TEST_FIELD_ALIGN (FILTERKEYS, iBounceMSec, 4)
    TEST_FIELD_OFFSET(FILTERKEYS, iBounceMSec, 20)
}

static void test_pack_FLASHWINFO(void)
{
    /* FLASHWINFO */
    TEST_TYPE_SIZE   (FLASHWINFO, 32)
    TEST_TYPE_ALIGN  (FLASHWINFO, 8)
    TEST_FIELD_SIZE  (FLASHWINFO, cbSize, 4)
    TEST_FIELD_ALIGN (FLASHWINFO, cbSize, 4)
    TEST_FIELD_OFFSET(FLASHWINFO, cbSize, 0)
    TEST_FIELD_SIZE  (FLASHWINFO, hwnd, 8)
    TEST_FIELD_ALIGN (FLASHWINFO, hwnd, 8)
    TEST_FIELD_OFFSET(FLASHWINFO, hwnd, 8)
    TEST_FIELD_SIZE  (FLASHWINFO, dwFlags, 4)
    TEST_FIELD_ALIGN (FLASHWINFO, dwFlags, 4)
    TEST_FIELD_OFFSET(FLASHWINFO, dwFlags, 16)
    TEST_FIELD_SIZE  (FLASHWINFO, uCount, 4)
    TEST_FIELD_ALIGN (FLASHWINFO, uCount, 4)
    TEST_FIELD_OFFSET(FLASHWINFO, uCount, 20)
    TEST_FIELD_SIZE  (FLASHWINFO, dwTimeout, 4)
    TEST_FIELD_ALIGN (FLASHWINFO, dwTimeout, 4)
    TEST_FIELD_OFFSET(FLASHWINFO, dwTimeout, 24)
}

static void test_pack_GRAYSTRINGPROC(void)
{
    /* GRAYSTRINGPROC */
    TEST_TYPE_SIZE   (GRAYSTRINGPROC, 8)
    TEST_TYPE_ALIGN  (GRAYSTRINGPROC, 8)
}

static void test_pack_GUITHREADINFO(void)
{
    /* GUITHREADINFO */
    TEST_TYPE_SIZE   (GUITHREADINFO, 72)
    TEST_TYPE_ALIGN  (GUITHREADINFO, 8)
    TEST_FIELD_SIZE  (GUITHREADINFO, cbSize, 4)
    TEST_FIELD_ALIGN (GUITHREADINFO, cbSize, 4)
    TEST_FIELD_OFFSET(GUITHREADINFO, cbSize, 0)
    TEST_FIELD_SIZE  (GUITHREADINFO, flags, 4)
    TEST_FIELD_ALIGN (GUITHREADINFO, flags, 4)
    TEST_FIELD_OFFSET(GUITHREADINFO, flags, 4)
    TEST_FIELD_SIZE  (GUITHREADINFO, hwndActive, 8)
    TEST_FIELD_ALIGN (GUITHREADINFO, hwndActive, 8)
    TEST_FIELD_OFFSET(GUITHREADINFO, hwndActive, 8)
    TEST_FIELD_SIZE  (GUITHREADINFO, hwndFocus, 8)
    TEST_FIELD_ALIGN (GUITHREADINFO, hwndFocus, 8)
    TEST_FIELD_OFFSET(GUITHREADINFO, hwndFocus, 16)
    TEST_FIELD_SIZE  (GUITHREADINFO, hwndCapture, 8)
    TEST_FIELD_ALIGN (GUITHREADINFO, hwndCapture, 8)
    TEST_FIELD_OFFSET(GUITHREADINFO, hwndCapture, 24)
    TEST_FIELD_SIZE  (GUITHREADINFO, hwndMenuOwner, 8)
    TEST_FIELD_ALIGN (GUITHREADINFO, hwndMenuOwner, 8)
    TEST_FIELD_OFFSET(GUITHREADINFO, hwndMenuOwner, 32)
    TEST_FIELD_SIZE  (GUITHREADINFO, hwndMoveSize, 8)
    TEST_FIELD_ALIGN (GUITHREADINFO, hwndMoveSize, 8)
    TEST_FIELD_OFFSET(GUITHREADINFO, hwndMoveSize, 40)
    TEST_FIELD_SIZE  (GUITHREADINFO, hwndCaret, 8)
    TEST_FIELD_ALIGN (GUITHREADINFO, hwndCaret, 8)
    TEST_FIELD_OFFSET(GUITHREADINFO, hwndCaret, 48)
    TEST_FIELD_SIZE  (GUITHREADINFO, rcCaret, 16)
    TEST_FIELD_ALIGN (GUITHREADINFO, rcCaret, 4)
    TEST_FIELD_OFFSET(GUITHREADINFO, rcCaret, 56)
}

static void test_pack_HARDWAREHOOKSTRUCT(void)
{
    /* HARDWAREHOOKSTRUCT */
    TEST_TYPE_SIZE   (HARDWAREHOOKSTRUCT, 32)
    TEST_TYPE_ALIGN  (HARDWAREHOOKSTRUCT, 8)
    TEST_FIELD_SIZE  (HARDWAREHOOKSTRUCT, hwnd, 8)
    TEST_FIELD_ALIGN (HARDWAREHOOKSTRUCT, hwnd, 8)
    TEST_FIELD_OFFSET(HARDWAREHOOKSTRUCT, hwnd, 0)
    TEST_FIELD_SIZE  (HARDWAREHOOKSTRUCT, message, 4)
    TEST_FIELD_ALIGN (HARDWAREHOOKSTRUCT, message, 4)
    TEST_FIELD_OFFSET(HARDWAREHOOKSTRUCT, message, 8)
    TEST_FIELD_SIZE  (HARDWAREHOOKSTRUCT, wParam, 8)
    TEST_FIELD_ALIGN (HARDWAREHOOKSTRUCT, wParam, 8)
    TEST_FIELD_OFFSET(HARDWAREHOOKSTRUCT, wParam, 16)
    TEST_FIELD_SIZE  (HARDWAREHOOKSTRUCT, lParam, 8)
    TEST_FIELD_ALIGN (HARDWAREHOOKSTRUCT, lParam, 8)
    TEST_FIELD_OFFSET(HARDWAREHOOKSTRUCT, lParam, 24)
}

static void test_pack_HARDWAREINPUT(void)
{
    /* HARDWAREINPUT */
    TEST_TYPE_SIZE   (HARDWAREINPUT, 8)
    TEST_TYPE_ALIGN  (HARDWAREINPUT, 4)
    TEST_FIELD_SIZE  (HARDWAREINPUT, uMsg, 4)
    TEST_FIELD_ALIGN (HARDWAREINPUT, uMsg, 4)
    TEST_FIELD_OFFSET(HARDWAREINPUT, uMsg, 0)
    TEST_FIELD_SIZE  (HARDWAREINPUT, wParamL, 2)
    TEST_FIELD_ALIGN (HARDWAREINPUT, wParamL, 2)
    TEST_FIELD_OFFSET(HARDWAREINPUT, wParamL, 4)
    TEST_FIELD_SIZE  (HARDWAREINPUT, wParamH, 2)
    TEST_FIELD_ALIGN (HARDWAREINPUT, wParamH, 2)
    TEST_FIELD_OFFSET(HARDWAREINPUT, wParamH, 6)
}

static void test_pack_HDEVNOTIFY(void)
{
    /* HDEVNOTIFY */
    TEST_TYPE_SIZE   (HDEVNOTIFY, 8)
    TEST_TYPE_ALIGN  (HDEVNOTIFY, 8)
}

static void test_pack_HDWP(void)
{
    /* HDWP */
    TEST_TYPE_SIZE   (HDWP, 8)
    TEST_TYPE_ALIGN  (HDWP, 8)
}

static void test_pack_HELPINFO(void)
{
    /* HELPINFO */
    TEST_TYPE_SIZE   (HELPINFO, 40)
    TEST_TYPE_ALIGN  (HELPINFO, 8)
    TEST_FIELD_SIZE  (HELPINFO, cbSize, 4)
    TEST_FIELD_ALIGN (HELPINFO, cbSize, 4)
    TEST_FIELD_OFFSET(HELPINFO, cbSize, 0)
    TEST_FIELD_SIZE  (HELPINFO, iContextType, 4)
    TEST_FIELD_ALIGN (HELPINFO, iContextType, 4)
    TEST_FIELD_OFFSET(HELPINFO, iContextType, 4)
    TEST_FIELD_SIZE  (HELPINFO, iCtrlId, 4)
    TEST_FIELD_ALIGN (HELPINFO, iCtrlId, 4)
    TEST_FIELD_OFFSET(HELPINFO, iCtrlId, 8)
    TEST_FIELD_SIZE  (HELPINFO, hItemHandle, 8)
    TEST_FIELD_ALIGN (HELPINFO, hItemHandle, 8)
    TEST_FIELD_OFFSET(HELPINFO, hItemHandle, 16)
    TEST_FIELD_SIZE  (HELPINFO, dwContextId, 8)
    TEST_FIELD_ALIGN (HELPINFO, dwContextId, 8)
    TEST_FIELD_OFFSET(HELPINFO, dwContextId, 24)
    TEST_FIELD_SIZE  (HELPINFO, MousePos, 8)
    TEST_FIELD_ALIGN (HELPINFO, MousePos, 4)
    TEST_FIELD_OFFSET(HELPINFO, MousePos, 32)
}

static void test_pack_HELPWININFOA(void)
{
    /* HELPWININFOA */
    TEST_TYPE_SIZE   (HELPWININFOA, 28)
    TEST_TYPE_ALIGN  (HELPWININFOA, 4)
    TEST_FIELD_SIZE  (HELPWININFOA, wStructSize, 4)
    TEST_FIELD_ALIGN (HELPWININFOA, wStructSize, 4)
    TEST_FIELD_OFFSET(HELPWININFOA, wStructSize, 0)
    TEST_FIELD_SIZE  (HELPWININFOA, x, 4)
    TEST_FIELD_ALIGN (HELPWININFOA, x, 4)
    TEST_FIELD_OFFSET(HELPWININFOA, x, 4)
    TEST_FIELD_SIZE  (HELPWININFOA, y, 4)
    TEST_FIELD_ALIGN (HELPWININFOA, y, 4)
    TEST_FIELD_OFFSET(HELPWININFOA, y, 8)
    TEST_FIELD_SIZE  (HELPWININFOA, dx, 4)
    TEST_FIELD_ALIGN (HELPWININFOA, dx, 4)
    TEST_FIELD_OFFSET(HELPWININFOA, dx, 12)
    TEST_FIELD_SIZE  (HELPWININFOA, dy, 4)
    TEST_FIELD_ALIGN (HELPWININFOA, dy, 4)
    TEST_FIELD_OFFSET(HELPWININFOA, dy, 16)
    TEST_FIELD_SIZE  (HELPWININFOA, wMax, 4)
    TEST_FIELD_ALIGN (HELPWININFOA, wMax, 4)
    TEST_FIELD_OFFSET(HELPWININFOA, wMax, 20)
    TEST_FIELD_SIZE  (HELPWININFOA, rgchMember, 2)
    TEST_FIELD_ALIGN (HELPWININFOA, rgchMember, 1)
    TEST_FIELD_OFFSET(HELPWININFOA, rgchMember, 24)
}

static void test_pack_HELPWININFOW(void)
{
    /* HELPWININFOW */
    TEST_TYPE_SIZE   (HELPWININFOW, 28)
    TEST_TYPE_ALIGN  (HELPWININFOW, 4)
    TEST_FIELD_SIZE  (HELPWININFOW, wStructSize, 4)
    TEST_FIELD_ALIGN (HELPWININFOW, wStructSize, 4)
    TEST_FIELD_OFFSET(HELPWININFOW, wStructSize, 0)
    TEST_FIELD_SIZE  (HELPWININFOW, x, 4)
    TEST_FIELD_ALIGN (HELPWININFOW, x, 4)
    TEST_FIELD_OFFSET(HELPWININFOW, x, 4)
    TEST_FIELD_SIZE  (HELPWININFOW, y, 4)
    TEST_FIELD_ALIGN (HELPWININFOW, y, 4)
    TEST_FIELD_OFFSET(HELPWININFOW, y, 8)
    TEST_FIELD_SIZE  (HELPWININFOW, dx, 4)
    TEST_FIELD_ALIGN (HELPWININFOW, dx, 4)
    TEST_FIELD_OFFSET(HELPWININFOW, dx, 12)
    TEST_FIELD_SIZE  (HELPWININFOW, dy, 4)
    TEST_FIELD_ALIGN (HELPWININFOW, dy, 4)
    TEST_FIELD_OFFSET(HELPWININFOW, dy, 16)
    TEST_FIELD_SIZE  (HELPWININFOW, wMax, 4)
    TEST_FIELD_ALIGN (HELPWININFOW, wMax, 4)
    TEST_FIELD_OFFSET(HELPWININFOW, wMax, 20)
    TEST_FIELD_SIZE  (HELPWININFOW, rgchMember, 4)
    TEST_FIELD_ALIGN (HELPWININFOW, rgchMember, 2)
    TEST_FIELD_OFFSET(HELPWININFOW, rgchMember, 24)
}

static void test_pack_HIGHCONTRASTA(void)
{
    /* HIGHCONTRASTA */
    TEST_TYPE_SIZE   (HIGHCONTRASTA, 16)
    TEST_TYPE_ALIGN  (HIGHCONTRASTA, 8)
    TEST_FIELD_SIZE  (HIGHCONTRASTA, cbSize, 4)
    TEST_FIELD_ALIGN (HIGHCONTRASTA, cbSize, 4)
    TEST_FIELD_OFFSET(HIGHCONTRASTA, cbSize, 0)
    TEST_FIELD_SIZE  (HIGHCONTRASTA, dwFlags, 4)
    TEST_FIELD_ALIGN (HIGHCONTRASTA, dwFlags, 4)
    TEST_FIELD_OFFSET(HIGHCONTRASTA, dwFlags, 4)
    TEST_FIELD_SIZE  (HIGHCONTRASTA, lpszDefaultScheme, 8)
    TEST_FIELD_ALIGN (HIGHCONTRASTA, lpszDefaultScheme, 8)
    TEST_FIELD_OFFSET(HIGHCONTRASTA, lpszDefaultScheme, 8)
}

static void test_pack_HIGHCONTRASTW(void)
{
    /* HIGHCONTRASTW */
    TEST_TYPE_SIZE   (HIGHCONTRASTW, 16)
    TEST_TYPE_ALIGN  (HIGHCONTRASTW, 8)
    TEST_FIELD_SIZE  (HIGHCONTRASTW, cbSize, 4)
    TEST_FIELD_ALIGN (HIGHCONTRASTW, cbSize, 4)
    TEST_FIELD_OFFSET(HIGHCONTRASTW, cbSize, 0)
    TEST_FIELD_SIZE  (HIGHCONTRASTW, dwFlags, 4)
    TEST_FIELD_ALIGN (HIGHCONTRASTW, dwFlags, 4)
    TEST_FIELD_OFFSET(HIGHCONTRASTW, dwFlags, 4)
    TEST_FIELD_SIZE  (HIGHCONTRASTW, lpszDefaultScheme, 8)
    TEST_FIELD_ALIGN (HIGHCONTRASTW, lpszDefaultScheme, 8)
    TEST_FIELD_OFFSET(HIGHCONTRASTW, lpszDefaultScheme, 8)
}

static void test_pack_HOOKPROC(void)
{
    /* HOOKPROC */
    TEST_TYPE_SIZE   (HOOKPROC, 8)
    TEST_TYPE_ALIGN  (HOOKPROC, 8)
}

static void test_pack_ICONINFO(void)
{
    /* ICONINFO */
    TEST_TYPE_SIZE   (ICONINFO, 32)
    TEST_TYPE_ALIGN  (ICONINFO, 8)
    TEST_FIELD_SIZE  (ICONINFO, fIcon, 4)
    TEST_FIELD_ALIGN (ICONINFO, fIcon, 4)
    TEST_FIELD_OFFSET(ICONINFO, fIcon, 0)
    TEST_FIELD_SIZE  (ICONINFO, xHotspot, 4)
    TEST_FIELD_ALIGN (ICONINFO, xHotspot, 4)
    TEST_FIELD_OFFSET(ICONINFO, xHotspot, 4)
    TEST_FIELD_SIZE  (ICONINFO, yHotspot, 4)
    TEST_FIELD_ALIGN (ICONINFO, yHotspot, 4)
    TEST_FIELD_OFFSET(ICONINFO, yHotspot, 8)
    TEST_FIELD_SIZE  (ICONINFO, hbmMask, 8)
    TEST_FIELD_ALIGN (ICONINFO, hbmMask, 8)
    TEST_FIELD_OFFSET(ICONINFO, hbmMask, 16)
    TEST_FIELD_SIZE  (ICONINFO, hbmColor, 8)
    TEST_FIELD_ALIGN (ICONINFO, hbmColor, 8)
    TEST_FIELD_OFFSET(ICONINFO, hbmColor, 24)
}

static void test_pack_ICONMETRICSA(void)
{
    /* ICONMETRICSA */
    TEST_TYPE_SIZE   (ICONMETRICSA, 76)
    TEST_TYPE_ALIGN  (ICONMETRICSA, 4)
    TEST_FIELD_SIZE  (ICONMETRICSA, cbSize, 4)
    TEST_FIELD_ALIGN (ICONMETRICSA, cbSize, 4)
    TEST_FIELD_OFFSET(ICONMETRICSA, cbSize, 0)
    TEST_FIELD_SIZE  (ICONMETRICSA, iHorzSpacing, 4)
    TEST_FIELD_ALIGN (ICONMETRICSA, iHorzSpacing, 4)
    TEST_FIELD_OFFSET(ICONMETRICSA, iHorzSpacing, 4)
    TEST_FIELD_SIZE  (ICONMETRICSA, iVertSpacing, 4)
    TEST_FIELD_ALIGN (ICONMETRICSA, iVertSpacing, 4)
    TEST_FIELD_OFFSET(ICONMETRICSA, iVertSpacing, 8)
    TEST_FIELD_SIZE  (ICONMETRICSA, iTitleWrap, 4)
    TEST_FIELD_ALIGN (ICONMETRICSA, iTitleWrap, 4)
    TEST_FIELD_OFFSET(ICONMETRICSA, iTitleWrap, 12)
    TEST_FIELD_SIZE  (ICONMETRICSA, lfFont, 60)
    TEST_FIELD_ALIGN (ICONMETRICSA, lfFont, 4)
    TEST_FIELD_OFFSET(ICONMETRICSA, lfFont, 16)
}

static void test_pack_ICONMETRICSW(void)
{
    /* ICONMETRICSW */
    TEST_TYPE_SIZE   (ICONMETRICSW, 108)
    TEST_TYPE_ALIGN  (ICONMETRICSW, 4)
    TEST_FIELD_SIZE  (ICONMETRICSW, cbSize, 4)
    TEST_FIELD_ALIGN (ICONMETRICSW, cbSize, 4)
    TEST_FIELD_OFFSET(ICONMETRICSW, cbSize, 0)
    TEST_FIELD_SIZE  (ICONMETRICSW, iHorzSpacing, 4)
    TEST_FIELD_ALIGN (ICONMETRICSW, iHorzSpacing, 4)
    TEST_FIELD_OFFSET(ICONMETRICSW, iHorzSpacing, 4)
    TEST_FIELD_SIZE  (ICONMETRICSW, iVertSpacing, 4)
    TEST_FIELD_ALIGN (ICONMETRICSW, iVertSpacing, 4)
    TEST_FIELD_OFFSET(ICONMETRICSW, iVertSpacing, 8)
    TEST_FIELD_SIZE  (ICONMETRICSW, iTitleWrap, 4)
    TEST_FIELD_ALIGN (ICONMETRICSW, iTitleWrap, 4)
    TEST_FIELD_OFFSET(ICONMETRICSW, iTitleWrap, 12)
    TEST_FIELD_SIZE  (ICONMETRICSW, lfFont, 92)
    TEST_FIELD_ALIGN (ICONMETRICSW, lfFont, 4)
    TEST_FIELD_OFFSET(ICONMETRICSW, lfFont, 16)
}

static void test_pack_INPUT(void)
{
    /* INPUT */
    TEST_FIELD_SIZE  (INPUT, type, 4)
    TEST_FIELD_ALIGN (INPUT, type, 4)
    TEST_FIELD_OFFSET(INPUT, type, 0)
}

static void test_pack_KBDLLHOOKSTRUCT(void)
{
    /* KBDLLHOOKSTRUCT */
    TEST_TYPE_SIZE   (KBDLLHOOKSTRUCT, 24)
    TEST_TYPE_ALIGN  (KBDLLHOOKSTRUCT, 8)
    TEST_FIELD_SIZE  (KBDLLHOOKSTRUCT, vkCode, 4)
    TEST_FIELD_ALIGN (KBDLLHOOKSTRUCT, vkCode, 4)
    TEST_FIELD_OFFSET(KBDLLHOOKSTRUCT, vkCode, 0)
    TEST_FIELD_SIZE  (KBDLLHOOKSTRUCT, scanCode, 4)
    TEST_FIELD_ALIGN (KBDLLHOOKSTRUCT, scanCode, 4)
    TEST_FIELD_OFFSET(KBDLLHOOKSTRUCT, scanCode, 4)
    TEST_FIELD_SIZE  (KBDLLHOOKSTRUCT, flags, 4)
    TEST_FIELD_ALIGN (KBDLLHOOKSTRUCT, flags, 4)
    TEST_FIELD_OFFSET(KBDLLHOOKSTRUCT, flags, 8)
    TEST_FIELD_SIZE  (KBDLLHOOKSTRUCT, time, 4)
    TEST_FIELD_ALIGN (KBDLLHOOKSTRUCT, time, 4)
    TEST_FIELD_OFFSET(KBDLLHOOKSTRUCT, time, 12)
    TEST_FIELD_SIZE  (KBDLLHOOKSTRUCT, dwExtraInfo, 8)
    TEST_FIELD_ALIGN (KBDLLHOOKSTRUCT, dwExtraInfo, 8)
    TEST_FIELD_OFFSET(KBDLLHOOKSTRUCT, dwExtraInfo, 16)
}

static void test_pack_KEYBDINPUT(void)
{
    /* KEYBDINPUT */
    TEST_TYPE_SIZE   (KEYBDINPUT, 24)
    TEST_TYPE_ALIGN  (KEYBDINPUT, 8)
    TEST_FIELD_SIZE  (KEYBDINPUT, wVk, 2)
    TEST_FIELD_ALIGN (KEYBDINPUT, wVk, 2)
    TEST_FIELD_OFFSET(KEYBDINPUT, wVk, 0)
    TEST_FIELD_SIZE  (KEYBDINPUT, wScan, 2)
    TEST_FIELD_ALIGN (KEYBDINPUT, wScan, 2)
    TEST_FIELD_OFFSET(KEYBDINPUT, wScan, 2)
    TEST_FIELD_SIZE  (KEYBDINPUT, dwFlags, 4)
    TEST_FIELD_ALIGN (KEYBDINPUT, dwFlags, 4)
    TEST_FIELD_OFFSET(KEYBDINPUT, dwFlags, 4)
    TEST_FIELD_SIZE  (KEYBDINPUT, time, 4)
    TEST_FIELD_ALIGN (KEYBDINPUT, time, 4)
    TEST_FIELD_OFFSET(KEYBDINPUT, time, 8)
    TEST_FIELD_SIZE  (KEYBDINPUT, dwExtraInfo, 8)
    TEST_FIELD_ALIGN (KEYBDINPUT, dwExtraInfo, 8)
    TEST_FIELD_OFFSET(KEYBDINPUT, dwExtraInfo, 16)
}

static void test_pack_LPACCESSTIMEOUT(void)
{
    /* LPACCESSTIMEOUT */
    TEST_TYPE_SIZE   (LPACCESSTIMEOUT, 8)
    TEST_TYPE_ALIGN  (LPACCESSTIMEOUT, 8)
    TEST_TARGET_SIZE (LPACCESSTIMEOUT, 12)
    TEST_TARGET_ALIGN(LPACCESSTIMEOUT, 4)
}

static void test_pack_LPANIMATIONINFO(void)
{
    /* LPANIMATIONINFO */
    TEST_TYPE_SIZE   (LPANIMATIONINFO, 8)
    TEST_TYPE_ALIGN  (LPANIMATIONINFO, 8)
    TEST_TARGET_SIZE (LPANIMATIONINFO, 8)
    TEST_TARGET_ALIGN(LPANIMATIONINFO, 4)
}

static void test_pack_LPCBTACTIVATESTRUCT(void)
{
    /* LPCBTACTIVATESTRUCT */
    TEST_TYPE_SIZE   (LPCBTACTIVATESTRUCT, 8)
    TEST_TYPE_ALIGN  (LPCBTACTIVATESTRUCT, 8)
    TEST_TARGET_SIZE (LPCBTACTIVATESTRUCT, 16)
    TEST_TARGET_ALIGN(LPCBTACTIVATESTRUCT, 8)
}

static void test_pack_LPCBT_CREATEWNDA(void)
{
    /* LPCBT_CREATEWNDA */
    TEST_TYPE_SIZE   (LPCBT_CREATEWNDA, 8)
    TEST_TYPE_ALIGN  (LPCBT_CREATEWNDA, 8)
    TEST_TARGET_SIZE (LPCBT_CREATEWNDA, 16)
    TEST_TARGET_ALIGN(LPCBT_CREATEWNDA, 8)
}

static void test_pack_LPCBT_CREATEWNDW(void)
{
    /* LPCBT_CREATEWNDW */
    TEST_TYPE_SIZE   (LPCBT_CREATEWNDW, 8)
    TEST_TYPE_ALIGN  (LPCBT_CREATEWNDW, 8)
    TEST_TARGET_SIZE (LPCBT_CREATEWNDW, 16)
    TEST_TARGET_ALIGN(LPCBT_CREATEWNDW, 8)
}

static void test_pack_LPCDLGTEMPLATEA(void)
{
    /* LPCDLGTEMPLATEA */
    TEST_TYPE_SIZE   (LPCDLGTEMPLATEA, 8)
    TEST_TYPE_ALIGN  (LPCDLGTEMPLATEA, 8)
    TEST_TARGET_SIZE (LPCDLGTEMPLATEA, 18)
    TEST_TARGET_ALIGN(LPCDLGTEMPLATEA, 2)
}

static void test_pack_LPCDLGTEMPLATEW(void)
{
    /* LPCDLGTEMPLATEW */
    TEST_TYPE_SIZE   (LPCDLGTEMPLATEW, 8)
    TEST_TYPE_ALIGN  (LPCDLGTEMPLATEW, 8)
    TEST_TARGET_SIZE (LPCDLGTEMPLATEW, 18)
    TEST_TARGET_ALIGN(LPCDLGTEMPLATEW, 2)
}

static void test_pack_LPCLIENTCREATESTRUCT(void)
{
    /* LPCLIENTCREATESTRUCT */
    TEST_TYPE_SIZE   (LPCLIENTCREATESTRUCT, 8)
    TEST_TYPE_ALIGN  (LPCLIENTCREATESTRUCT, 8)
    TEST_TARGET_SIZE (LPCLIENTCREATESTRUCT, 16)
    TEST_TARGET_ALIGN(LPCLIENTCREATESTRUCT, 8)
}

static void test_pack_LPCMENUINFO(void)
{
    /* LPCMENUINFO */
    TEST_TYPE_SIZE   (LPCMENUINFO, 8)
    TEST_TYPE_ALIGN  (LPCMENUINFO, 8)
    TEST_TARGET_SIZE (LPCMENUINFO, 40)
    TEST_TARGET_ALIGN(LPCMENUINFO, 8)
}

static void test_pack_LPCMENUITEMINFOA(void)
{
    /* LPCMENUITEMINFOA */
    TEST_TYPE_SIZE   (LPCMENUITEMINFOA, 8)
    TEST_TYPE_ALIGN  (LPCMENUITEMINFOA, 8)
    TEST_TARGET_SIZE (LPCMENUITEMINFOA, 80)
    TEST_TARGET_ALIGN(LPCMENUITEMINFOA, 8)
}

static void test_pack_LPCMENUITEMINFOW(void)
{
    /* LPCMENUITEMINFOW */
    TEST_TYPE_SIZE   (LPCMENUITEMINFOW, 8)
    TEST_TYPE_ALIGN  (LPCMENUITEMINFOW, 8)
    TEST_TARGET_SIZE (LPCMENUITEMINFOW, 80)
    TEST_TARGET_ALIGN(LPCMENUITEMINFOW, 8)
}

static void test_pack_LPCOMBOBOXINFO(void)
{
    /* LPCOMBOBOXINFO */
    TEST_TYPE_SIZE   (LPCOMBOBOXINFO, 8)
    TEST_TYPE_ALIGN  (LPCOMBOBOXINFO, 8)
    TEST_TARGET_SIZE (LPCOMBOBOXINFO, 64)
    TEST_TARGET_ALIGN(LPCOMBOBOXINFO, 8)
}

static void test_pack_LPCOMPAREITEMSTRUCT(void)
{
    /* LPCOMPAREITEMSTRUCT */
    TEST_TYPE_SIZE   (LPCOMPAREITEMSTRUCT, 8)
    TEST_TYPE_ALIGN  (LPCOMPAREITEMSTRUCT, 8)
    TEST_TARGET_SIZE (LPCOMPAREITEMSTRUCT, 56)
    TEST_TARGET_ALIGN(LPCOMPAREITEMSTRUCT, 8)
}

static void test_pack_LPCREATESTRUCTA(void)
{
    /* LPCREATESTRUCTA */
    TEST_TYPE_SIZE   (LPCREATESTRUCTA, 8)
    TEST_TYPE_ALIGN  (LPCREATESTRUCTA, 8)
    TEST_TARGET_SIZE (LPCREATESTRUCTA, 80)
    TEST_TARGET_ALIGN(LPCREATESTRUCTA, 8)
}

static void test_pack_LPCREATESTRUCTW(void)
{
    /* LPCREATESTRUCTW */
    TEST_TYPE_SIZE   (LPCREATESTRUCTW, 8)
    TEST_TYPE_ALIGN  (LPCREATESTRUCTW, 8)
    TEST_TARGET_SIZE (LPCREATESTRUCTW, 80)
    TEST_TARGET_ALIGN(LPCREATESTRUCTW, 8)
}

static void test_pack_LPCSCROLLINFO(void)
{
    /* LPCSCROLLINFO */
    TEST_TYPE_SIZE   (LPCSCROLLINFO, 8)
    TEST_TYPE_ALIGN  (LPCSCROLLINFO, 8)
    TEST_TARGET_SIZE (LPCSCROLLINFO, 28)
    TEST_TARGET_ALIGN(LPCSCROLLINFO, 4)
}

static void test_pack_LPCURSORINFO(void)
{
    /* LPCURSORINFO */
    TEST_TYPE_SIZE   (LPCURSORINFO, 8)
    TEST_TYPE_ALIGN  (LPCURSORINFO, 8)
    TEST_TARGET_SIZE (LPCURSORINFO, 24)
    TEST_TARGET_ALIGN(LPCURSORINFO, 8)
}

static void test_pack_LPCWPRETSTRUCT(void)
{
    /* LPCWPRETSTRUCT */
    TEST_TYPE_SIZE   (LPCWPRETSTRUCT, 8)
    TEST_TYPE_ALIGN  (LPCWPRETSTRUCT, 8)
    TEST_TARGET_SIZE (LPCWPRETSTRUCT, 40)
    TEST_TARGET_ALIGN(LPCWPRETSTRUCT, 8)
}

static void test_pack_LPCWPSTRUCT(void)
{
    /* LPCWPSTRUCT */
    TEST_TYPE_SIZE   (LPCWPSTRUCT, 8)
    TEST_TYPE_ALIGN  (LPCWPSTRUCT, 8)
    TEST_TARGET_SIZE (LPCWPSTRUCT, 32)
    TEST_TARGET_ALIGN(LPCWPSTRUCT, 8)
}

static void test_pack_LPDEBUGHOOKINFO(void)
{
    /* LPDEBUGHOOKINFO */
    TEST_TYPE_SIZE   (LPDEBUGHOOKINFO, 8)
    TEST_TYPE_ALIGN  (LPDEBUGHOOKINFO, 8)
    TEST_TARGET_SIZE (LPDEBUGHOOKINFO, 32)
    TEST_TARGET_ALIGN(LPDEBUGHOOKINFO, 8)
}

static void test_pack_LPDELETEITEMSTRUCT(void)
{
    /* LPDELETEITEMSTRUCT */
    TEST_TYPE_SIZE   (LPDELETEITEMSTRUCT, 8)
    TEST_TYPE_ALIGN  (LPDELETEITEMSTRUCT, 8)
    TEST_TARGET_SIZE (LPDELETEITEMSTRUCT, 32)
    TEST_TARGET_ALIGN(LPDELETEITEMSTRUCT, 8)
}

static void test_pack_LPDLGITEMTEMPLATEA(void)
{
    /* LPDLGITEMTEMPLATEA */
    TEST_TYPE_SIZE   (LPDLGITEMTEMPLATEA, 8)
    TEST_TYPE_ALIGN  (LPDLGITEMTEMPLATEA, 8)
    TEST_TARGET_SIZE (LPDLGITEMTEMPLATEA, 18)
    TEST_TARGET_ALIGN(LPDLGITEMTEMPLATEA, 2)
}

static void test_pack_LPDLGITEMTEMPLATEW(void)
{
    /* LPDLGITEMTEMPLATEW */
    TEST_TYPE_SIZE   (LPDLGITEMTEMPLATEW, 8)
    TEST_TYPE_ALIGN  (LPDLGITEMTEMPLATEW, 8)
    TEST_TARGET_SIZE (LPDLGITEMTEMPLATEW, 18)
    TEST_TARGET_ALIGN(LPDLGITEMTEMPLATEW, 2)
}

static void test_pack_LPDLGTEMPLATEA(void)
{
    /* LPDLGTEMPLATEA */
    TEST_TYPE_SIZE   (LPDLGTEMPLATEA, 8)
    TEST_TYPE_ALIGN  (LPDLGTEMPLATEA, 8)
    TEST_TARGET_SIZE (LPDLGTEMPLATEA, 18)
    TEST_TARGET_ALIGN(LPDLGTEMPLATEA, 2)
}

static void test_pack_LPDLGTEMPLATEW(void)
{
    /* LPDLGTEMPLATEW */
    TEST_TYPE_SIZE   (LPDLGTEMPLATEW, 8)
    TEST_TYPE_ALIGN  (LPDLGTEMPLATEW, 8)
    TEST_TARGET_SIZE (LPDLGTEMPLATEW, 18)
    TEST_TARGET_ALIGN(LPDLGTEMPLATEW, 2)
}

static void test_pack_LPDRAWITEMSTRUCT(void)
{
    /* LPDRAWITEMSTRUCT */
    TEST_TYPE_SIZE   (LPDRAWITEMSTRUCT, 8)
    TEST_TYPE_ALIGN  (LPDRAWITEMSTRUCT, 8)
    TEST_TARGET_SIZE (LPDRAWITEMSTRUCT, 64)
    TEST_TARGET_ALIGN(LPDRAWITEMSTRUCT, 8)
}

static void test_pack_LPDRAWTEXTPARAMS(void)
{
    /* LPDRAWTEXTPARAMS */
    TEST_TYPE_SIZE   (LPDRAWTEXTPARAMS, 8)
    TEST_TYPE_ALIGN  (LPDRAWTEXTPARAMS, 8)
    TEST_TARGET_SIZE (LPDRAWTEXTPARAMS, 20)
    TEST_TARGET_ALIGN(LPDRAWTEXTPARAMS, 4)
}

static void test_pack_LPEVENTMSG(void)
{
    /* LPEVENTMSG */
    TEST_TYPE_SIZE   (LPEVENTMSG, 8)
    TEST_TYPE_ALIGN  (LPEVENTMSG, 8)
    TEST_TARGET_SIZE (LPEVENTMSG, 24)
    TEST_TARGET_ALIGN(LPEVENTMSG, 8)
}

static void test_pack_LPFILTERKEYS(void)
{
    /* LPFILTERKEYS */
    TEST_TYPE_SIZE   (LPFILTERKEYS, 8)
    TEST_TYPE_ALIGN  (LPFILTERKEYS, 8)
    TEST_TARGET_SIZE (LPFILTERKEYS, 24)
    TEST_TARGET_ALIGN(LPFILTERKEYS, 4)
}

static void test_pack_LPGUITHREADINFO(void)
{
    /* LPGUITHREADINFO */
    TEST_TYPE_SIZE   (LPGUITHREADINFO, 8)
    TEST_TYPE_ALIGN  (LPGUITHREADINFO, 8)
    TEST_TARGET_SIZE (LPGUITHREADINFO, 72)
    TEST_TARGET_ALIGN(LPGUITHREADINFO, 8)
}

static void test_pack_LPHARDWAREHOOKSTRUCT(void)
{
    /* LPHARDWAREHOOKSTRUCT */
    TEST_TYPE_SIZE   (LPHARDWAREHOOKSTRUCT, 8)
    TEST_TYPE_ALIGN  (LPHARDWAREHOOKSTRUCT, 8)
    TEST_TARGET_SIZE (LPHARDWAREHOOKSTRUCT, 32)
    TEST_TARGET_ALIGN(LPHARDWAREHOOKSTRUCT, 8)
}

static void test_pack_LPHARDWAREINPUT(void)
{
    /* LPHARDWAREINPUT */
    TEST_TYPE_SIZE   (LPHARDWAREINPUT, 8)
    TEST_TYPE_ALIGN  (LPHARDWAREINPUT, 8)
    TEST_TARGET_SIZE (LPHARDWAREINPUT, 8)
    TEST_TARGET_ALIGN(LPHARDWAREINPUT, 4)
}

static void test_pack_LPHELPINFO(void)
{
    /* LPHELPINFO */
    TEST_TYPE_SIZE   (LPHELPINFO, 8)
    TEST_TYPE_ALIGN  (LPHELPINFO, 8)
    TEST_TARGET_SIZE (LPHELPINFO, 40)
    TEST_TARGET_ALIGN(LPHELPINFO, 8)
}

static void test_pack_LPHELPWININFOA(void)
{
    /* LPHELPWININFOA */
    TEST_TYPE_SIZE   (LPHELPWININFOA, 8)
    TEST_TYPE_ALIGN  (LPHELPWININFOA, 8)
    TEST_TARGET_SIZE (LPHELPWININFOA, 28)
    TEST_TARGET_ALIGN(LPHELPWININFOA, 4)
}

static void test_pack_LPHELPWININFOW(void)
{
    /* LPHELPWININFOW */
    TEST_TYPE_SIZE   (LPHELPWININFOW, 8)
    TEST_TYPE_ALIGN  (LPHELPWININFOW, 8)
    TEST_TARGET_SIZE (LPHELPWININFOW, 28)
    TEST_TARGET_ALIGN(LPHELPWININFOW, 4)
}

static void test_pack_LPHIGHCONTRASTA(void)
{
    /* LPHIGHCONTRASTA */
    TEST_TYPE_SIZE   (LPHIGHCONTRASTA, 8)
    TEST_TYPE_ALIGN  (LPHIGHCONTRASTA, 8)
    TEST_TARGET_SIZE (LPHIGHCONTRASTA, 16)
    TEST_TARGET_ALIGN(LPHIGHCONTRASTA, 8)
}

static void test_pack_LPHIGHCONTRASTW(void)
{
    /* LPHIGHCONTRASTW */
    TEST_TYPE_SIZE   (LPHIGHCONTRASTW, 8)
    TEST_TYPE_ALIGN  (LPHIGHCONTRASTW, 8)
    TEST_TARGET_SIZE (LPHIGHCONTRASTW, 16)
    TEST_TARGET_ALIGN(LPHIGHCONTRASTW, 8)
}

static void test_pack_LPICONMETRICSA(void)
{
    /* LPICONMETRICSA */
    TEST_TYPE_SIZE   (LPICONMETRICSA, 8)
    TEST_TYPE_ALIGN  (LPICONMETRICSA, 8)
    TEST_TARGET_SIZE (LPICONMETRICSA, 76)
    TEST_TARGET_ALIGN(LPICONMETRICSA, 4)
}

static void test_pack_LPICONMETRICSW(void)
{
    /* LPICONMETRICSW */
    TEST_TYPE_SIZE   (LPICONMETRICSW, 8)
    TEST_TYPE_ALIGN  (LPICONMETRICSW, 8)
    TEST_TARGET_SIZE (LPICONMETRICSW, 108)
    TEST_TARGET_ALIGN(LPICONMETRICSW, 4)
}

static void test_pack_LPINPUT(void)
{
    /* LPINPUT */
    TEST_TYPE_SIZE   (LPINPUT, 8)
    TEST_TYPE_ALIGN  (LPINPUT, 8)
}

static void test_pack_LPKBDLLHOOKSTRUCT(void)
{
    /* LPKBDLLHOOKSTRUCT */
    TEST_TYPE_SIZE   (LPKBDLLHOOKSTRUCT, 8)
    TEST_TYPE_ALIGN  (LPKBDLLHOOKSTRUCT, 8)
    TEST_TARGET_SIZE (LPKBDLLHOOKSTRUCT, 24)
    TEST_TARGET_ALIGN(LPKBDLLHOOKSTRUCT, 8)
}

static void test_pack_LPKEYBDINPUT(void)
{
    /* LPKEYBDINPUT */
    TEST_TYPE_SIZE   (LPKEYBDINPUT, 8)
    TEST_TYPE_ALIGN  (LPKEYBDINPUT, 8)
    TEST_TARGET_SIZE (LPKEYBDINPUT, 24)
    TEST_TARGET_ALIGN(LPKEYBDINPUT, 8)
}

static void test_pack_LPMDICREATESTRUCTA(void)
{
    /* LPMDICREATESTRUCTA */
    TEST_TYPE_SIZE   (LPMDICREATESTRUCTA, 8)
    TEST_TYPE_ALIGN  (LPMDICREATESTRUCTA, 8)
    TEST_TARGET_SIZE (LPMDICREATESTRUCTA, 56)
    TEST_TARGET_ALIGN(LPMDICREATESTRUCTA, 8)
}

static void test_pack_LPMDICREATESTRUCTW(void)
{
    /* LPMDICREATESTRUCTW */
    TEST_TYPE_SIZE   (LPMDICREATESTRUCTW, 8)
    TEST_TYPE_ALIGN  (LPMDICREATESTRUCTW, 8)
    TEST_TARGET_SIZE (LPMDICREATESTRUCTW, 56)
    TEST_TARGET_ALIGN(LPMDICREATESTRUCTW, 8)
}

static void test_pack_LPMDINEXTMENU(void)
{
    /* LPMDINEXTMENU */
    TEST_TYPE_SIZE   (LPMDINEXTMENU, 8)
    TEST_TYPE_ALIGN  (LPMDINEXTMENU, 8)
    TEST_TARGET_SIZE (LPMDINEXTMENU, 24)
    TEST_TARGET_ALIGN(LPMDINEXTMENU, 8)
}

static void test_pack_LPMEASUREITEMSTRUCT(void)
{
    /* LPMEASUREITEMSTRUCT */
    TEST_TYPE_SIZE   (LPMEASUREITEMSTRUCT, 8)
    TEST_TYPE_ALIGN  (LPMEASUREITEMSTRUCT, 8)
    TEST_TARGET_SIZE (LPMEASUREITEMSTRUCT, 32)
    TEST_TARGET_ALIGN(LPMEASUREITEMSTRUCT, 8)
}

static void test_pack_LPMENUINFO(void)
{
    /* LPMENUINFO */
    TEST_TYPE_SIZE   (LPMENUINFO, 8)
    TEST_TYPE_ALIGN  (LPMENUINFO, 8)
    TEST_TARGET_SIZE (LPMENUINFO, 40)
    TEST_TARGET_ALIGN(LPMENUINFO, 8)
}

static void test_pack_LPMENUITEMINFOA(void)
{
    /* LPMENUITEMINFOA */
    TEST_TYPE_SIZE   (LPMENUITEMINFOA, 8)
    TEST_TYPE_ALIGN  (LPMENUITEMINFOA, 8)
    TEST_TARGET_SIZE (LPMENUITEMINFOA, 80)
    TEST_TARGET_ALIGN(LPMENUITEMINFOA, 8)
}

static void test_pack_LPMENUITEMINFOW(void)
{
    /* LPMENUITEMINFOW */
    TEST_TYPE_SIZE   (LPMENUITEMINFOW, 8)
    TEST_TYPE_ALIGN  (LPMENUITEMINFOW, 8)
    TEST_TARGET_SIZE (LPMENUITEMINFOW, 80)
    TEST_TARGET_ALIGN(LPMENUITEMINFOW, 8)
}

static void test_pack_LPMINIMIZEDMETRICS(void)
{
    /* LPMINIMIZEDMETRICS */
    TEST_TYPE_SIZE   (LPMINIMIZEDMETRICS, 8)
    TEST_TYPE_ALIGN  (LPMINIMIZEDMETRICS, 8)
    TEST_TARGET_SIZE (LPMINIMIZEDMETRICS, 20)
    TEST_TARGET_ALIGN(LPMINIMIZEDMETRICS, 4)
}

static void test_pack_LPMINMAXINFO(void)
{
    /* LPMINMAXINFO */
    TEST_TYPE_SIZE   (LPMINMAXINFO, 8)
    TEST_TYPE_ALIGN  (LPMINMAXINFO, 8)
    TEST_TARGET_SIZE (LPMINMAXINFO, 40)
    TEST_TARGET_ALIGN(LPMINMAXINFO, 4)
}

static void test_pack_LPMONITORINFO(void)
{
    /* LPMONITORINFO */
    TEST_TYPE_SIZE   (LPMONITORINFO, 8)
    TEST_TYPE_ALIGN  (LPMONITORINFO, 8)
    TEST_TARGET_SIZE (LPMONITORINFO, 40)
    TEST_TARGET_ALIGN(LPMONITORINFO, 4)
}

static void test_pack_LPMONITORINFOEXA(void)
{
    /* LPMONITORINFOEXA */
    TEST_TYPE_SIZE   (LPMONITORINFOEXA, 8)
    TEST_TYPE_ALIGN  (LPMONITORINFOEXA, 8)
    TEST_TARGET_SIZE (LPMONITORINFOEXA, 72)
    TEST_TARGET_ALIGN(LPMONITORINFOEXA, 4)
}

static void test_pack_LPMONITORINFOEXW(void)
{
    /* LPMONITORINFOEXW */
    TEST_TYPE_SIZE   (LPMONITORINFOEXW, 8)
    TEST_TYPE_ALIGN  (LPMONITORINFOEXW, 8)
    TEST_TARGET_SIZE (LPMONITORINFOEXW, 104)
    TEST_TARGET_ALIGN(LPMONITORINFOEXW, 4)
}

static void test_pack_LPMOUSEHOOKSTRUCT(void)
{
    /* LPMOUSEHOOKSTRUCT */
    TEST_TYPE_SIZE   (LPMOUSEHOOKSTRUCT, 8)
    TEST_TYPE_ALIGN  (LPMOUSEHOOKSTRUCT, 8)
    TEST_TARGET_SIZE (LPMOUSEHOOKSTRUCT, 32)
    TEST_TARGET_ALIGN(LPMOUSEHOOKSTRUCT, 8)
}

static void test_pack_LPMOUSEINPUT(void)
{
    /* LPMOUSEINPUT */
    TEST_TYPE_SIZE   (LPMOUSEINPUT, 8)
    TEST_TYPE_ALIGN  (LPMOUSEINPUT, 8)
    TEST_TARGET_SIZE (LPMOUSEINPUT, 32)
    TEST_TARGET_ALIGN(LPMOUSEINPUT, 8)
}

static void test_pack_LPMOUSEKEYS(void)
{
    /* LPMOUSEKEYS */
    TEST_TYPE_SIZE   (LPMOUSEKEYS, 8)
    TEST_TYPE_ALIGN  (LPMOUSEKEYS, 8)
    TEST_TARGET_SIZE (LPMOUSEKEYS, 28)
    TEST_TARGET_ALIGN(LPMOUSEKEYS, 4)
}

static void test_pack_LPMSG(void)
{
    /* LPMSG */
    TEST_TYPE_SIZE   (LPMSG, 8)
    TEST_TYPE_ALIGN  (LPMSG, 8)
    TEST_TARGET_SIZE (LPMSG, 48)
    TEST_TARGET_ALIGN(LPMSG, 8)
}

static void test_pack_LPMSGBOXPARAMSA(void)
{
    /* LPMSGBOXPARAMSA */
    TEST_TYPE_SIZE   (LPMSGBOXPARAMSA, 8)
    TEST_TYPE_ALIGN  (LPMSGBOXPARAMSA, 8)
    TEST_TARGET_SIZE (LPMSGBOXPARAMSA, 80)
    TEST_TARGET_ALIGN(LPMSGBOXPARAMSA, 8)
}

static void test_pack_LPMSGBOXPARAMSW(void)
{
    /* LPMSGBOXPARAMSW */
    TEST_TYPE_SIZE   (LPMSGBOXPARAMSW, 8)
    TEST_TYPE_ALIGN  (LPMSGBOXPARAMSW, 8)
    TEST_TARGET_SIZE (LPMSGBOXPARAMSW, 80)
    TEST_TARGET_ALIGN(LPMSGBOXPARAMSW, 8)
}

static void test_pack_LPMSLLHOOKSTRUCT(void)
{
    /* LPMSLLHOOKSTRUCT */
    TEST_TYPE_SIZE   (LPMSLLHOOKSTRUCT, 8)
    TEST_TYPE_ALIGN  (LPMSLLHOOKSTRUCT, 8)
    TEST_TARGET_SIZE (LPMSLLHOOKSTRUCT, 32)
    TEST_TARGET_ALIGN(LPMSLLHOOKSTRUCT, 8)
}

static void test_pack_LPMULTIKEYHELPA(void)
{
    /* LPMULTIKEYHELPA */
    TEST_TYPE_SIZE   (LPMULTIKEYHELPA, 8)
    TEST_TYPE_ALIGN  (LPMULTIKEYHELPA, 8)
    TEST_TARGET_SIZE (LPMULTIKEYHELPA, 8)
    TEST_TARGET_ALIGN(LPMULTIKEYHELPA, 4)
}

static void test_pack_LPMULTIKEYHELPW(void)
{
    /* LPMULTIKEYHELPW */
    TEST_TYPE_SIZE   (LPMULTIKEYHELPW, 8)
    TEST_TYPE_ALIGN  (LPMULTIKEYHELPW, 8)
    TEST_TARGET_SIZE (LPMULTIKEYHELPW, 8)
    TEST_TARGET_ALIGN(LPMULTIKEYHELPW, 4)
}

static void test_pack_LPNCCALCSIZE_PARAMS(void)
{
    /* LPNCCALCSIZE_PARAMS */
    TEST_TYPE_SIZE   (LPNCCALCSIZE_PARAMS, 8)
    TEST_TYPE_ALIGN  (LPNCCALCSIZE_PARAMS, 8)
    TEST_TARGET_SIZE (LPNCCALCSIZE_PARAMS, 56)
    TEST_TARGET_ALIGN(LPNCCALCSIZE_PARAMS, 8)
}

static void test_pack_LPNMHDR(void)
{
    /* LPNMHDR */
    TEST_TYPE_SIZE   (LPNMHDR, 8)
    TEST_TYPE_ALIGN  (LPNMHDR, 8)
    TEST_TARGET_SIZE (LPNMHDR, 24)
    TEST_TARGET_ALIGN(LPNMHDR, 8)
}

static void test_pack_LPNONCLIENTMETRICSA(void)
{
    /* LPNONCLIENTMETRICSA */
    TEST_TYPE_SIZE   (LPNONCLIENTMETRICSA, 8)
    TEST_TYPE_ALIGN  (LPNONCLIENTMETRICSA, 8)
    TEST_TARGET_SIZE (LPNONCLIENTMETRICSA, 340)
    TEST_TARGET_ALIGN(LPNONCLIENTMETRICSA, 4)
}

static void test_pack_LPNONCLIENTMETRICSW(void)
{
    /* LPNONCLIENTMETRICSW */
    TEST_TYPE_SIZE   (LPNONCLIENTMETRICSW, 8)
    TEST_TYPE_ALIGN  (LPNONCLIENTMETRICSW, 8)
    TEST_TARGET_SIZE (LPNONCLIENTMETRICSW, 500)
    TEST_TARGET_ALIGN(LPNONCLIENTMETRICSW, 4)
}

static void test_pack_LPPAINTSTRUCT(void)
{
    /* LPPAINTSTRUCT */
    TEST_TYPE_SIZE   (LPPAINTSTRUCT, 8)
    TEST_TYPE_ALIGN  (LPPAINTSTRUCT, 8)
    TEST_TARGET_SIZE (LPPAINTSTRUCT, 72)
    TEST_TARGET_ALIGN(LPPAINTSTRUCT, 8)
}

static void test_pack_LPSCROLLINFO(void)
{
    /* LPSCROLLINFO */
    TEST_TYPE_SIZE   (LPSCROLLINFO, 8)
    TEST_TYPE_ALIGN  (LPSCROLLINFO, 8)
    TEST_TARGET_SIZE (LPSCROLLINFO, 28)
    TEST_TARGET_ALIGN(LPSCROLLINFO, 4)
}

static void test_pack_LPSERIALKEYSA(void)
{
    /* LPSERIALKEYSA */
    TEST_TYPE_SIZE   (LPSERIALKEYSA, 8)
    TEST_TYPE_ALIGN  (LPSERIALKEYSA, 8)
    TEST_TARGET_SIZE (LPSERIALKEYSA, 40)
    TEST_TARGET_ALIGN(LPSERIALKEYSA, 8)
}

static void test_pack_LPSERIALKEYSW(void)
{
    /* LPSERIALKEYSW */
    TEST_TYPE_SIZE   (LPSERIALKEYSW, 8)
    TEST_TYPE_ALIGN  (LPSERIALKEYSW, 8)
    TEST_TARGET_SIZE (LPSERIALKEYSW, 40)
    TEST_TARGET_ALIGN(LPSERIALKEYSW, 8)
}

static void test_pack_LPSOUNDSENTRYA(void)
{
    /* LPSOUNDSENTRYA */
    TEST_TYPE_SIZE   (LPSOUNDSENTRYA, 8)
    TEST_TYPE_ALIGN  (LPSOUNDSENTRYA, 8)
    TEST_TARGET_SIZE (LPSOUNDSENTRYA, 56)
    TEST_TARGET_ALIGN(LPSOUNDSENTRYA, 8)
}

static void test_pack_LPSOUNDSENTRYW(void)
{
    /* LPSOUNDSENTRYW */
    TEST_TYPE_SIZE   (LPSOUNDSENTRYW, 8)
    TEST_TYPE_ALIGN  (LPSOUNDSENTRYW, 8)
    TEST_TARGET_SIZE (LPSOUNDSENTRYW, 56)
    TEST_TARGET_ALIGN(LPSOUNDSENTRYW, 8)
}

static void test_pack_LPSTICKYKEYS(void)
{
    /* LPSTICKYKEYS */
    TEST_TYPE_SIZE   (LPSTICKYKEYS, 8)
    TEST_TYPE_ALIGN  (LPSTICKYKEYS, 8)
    TEST_TARGET_SIZE (LPSTICKYKEYS, 8)
    TEST_TARGET_ALIGN(LPSTICKYKEYS, 4)
}

static void test_pack_LPSTYLESTRUCT(void)
{
    /* LPSTYLESTRUCT */
    TEST_TYPE_SIZE   (LPSTYLESTRUCT, 8)
    TEST_TYPE_ALIGN  (LPSTYLESTRUCT, 8)
    TEST_TARGET_SIZE (LPSTYLESTRUCT, 8)
    TEST_TARGET_ALIGN(LPSTYLESTRUCT, 4)
}

static void test_pack_LPTITLEBARINFO(void)
{
    /* LPTITLEBARINFO */
    TEST_TYPE_SIZE   (LPTITLEBARINFO, 8)
    TEST_TYPE_ALIGN  (LPTITLEBARINFO, 8)
    TEST_TARGET_SIZE (LPTITLEBARINFO, 44)
    TEST_TARGET_ALIGN(LPTITLEBARINFO, 4)
}

static void test_pack_LPTOGGLEKEYS(void)
{
    /* LPTOGGLEKEYS */
    TEST_TYPE_SIZE   (LPTOGGLEKEYS, 8)
    TEST_TYPE_ALIGN  (LPTOGGLEKEYS, 8)
    TEST_TARGET_SIZE (LPTOGGLEKEYS, 8)
    TEST_TARGET_ALIGN(LPTOGGLEKEYS, 4)
}

static void test_pack_LPTPMPARAMS(void)
{
    /* LPTPMPARAMS */
    TEST_TYPE_SIZE   (LPTPMPARAMS, 8)
    TEST_TYPE_ALIGN  (LPTPMPARAMS, 8)
    TEST_TARGET_SIZE (LPTPMPARAMS, 20)
    TEST_TARGET_ALIGN(LPTPMPARAMS, 4)
}

static void test_pack_LPTRACKMOUSEEVENT(void)
{
    /* LPTRACKMOUSEEVENT */
    TEST_TYPE_SIZE   (LPTRACKMOUSEEVENT, 8)
    TEST_TYPE_ALIGN  (LPTRACKMOUSEEVENT, 8)
    TEST_TARGET_SIZE (LPTRACKMOUSEEVENT, 24)
    TEST_TARGET_ALIGN(LPTRACKMOUSEEVENT, 8)
}

static void test_pack_LPWINDOWINFO(void)
{
    /* LPWINDOWINFO */
    TEST_TYPE_SIZE   (LPWINDOWINFO, 8)
    TEST_TYPE_ALIGN  (LPWINDOWINFO, 8)
    TEST_TARGET_SIZE (LPWINDOWINFO, 60)
    TEST_TARGET_ALIGN(LPWINDOWINFO, 4)
}

static void test_pack_LPWINDOWPLACEMENT(void)
{
    /* LPWINDOWPLACEMENT */
    TEST_TYPE_SIZE   (LPWINDOWPLACEMENT, 8)
    TEST_TYPE_ALIGN  (LPWINDOWPLACEMENT, 8)
    TEST_TARGET_SIZE (LPWINDOWPLACEMENT, 44)
    TEST_TARGET_ALIGN(LPWINDOWPLACEMENT, 4)
}

static void test_pack_LPWINDOWPOS(void)
{
    /* LPWINDOWPOS */
    TEST_TYPE_SIZE   (LPWINDOWPOS, 8)
    TEST_TYPE_ALIGN  (LPWINDOWPOS, 8)
    TEST_TARGET_SIZE (LPWINDOWPOS, 40)
    TEST_TARGET_ALIGN(LPWINDOWPOS, 8)
}

static void test_pack_LPWNDCLASSA(void)
{
    /* LPWNDCLASSA */
    TEST_TYPE_SIZE   (LPWNDCLASSA, 8)
    TEST_TYPE_ALIGN  (LPWNDCLASSA, 8)
    TEST_TARGET_SIZE (LPWNDCLASSA, 72)
    TEST_TARGET_ALIGN(LPWNDCLASSA, 8)
}

static void test_pack_LPWNDCLASSEXA(void)
{
    /* LPWNDCLASSEXA */
    TEST_TYPE_SIZE   (LPWNDCLASSEXA, 8)
    TEST_TYPE_ALIGN  (LPWNDCLASSEXA, 8)
    TEST_TARGET_SIZE (LPWNDCLASSEXA, 80)
    TEST_TARGET_ALIGN(LPWNDCLASSEXA, 8)
}

static void test_pack_LPWNDCLASSEXW(void)
{
    /* LPWNDCLASSEXW */
    TEST_TYPE_SIZE   (LPWNDCLASSEXW, 8)
    TEST_TYPE_ALIGN  (LPWNDCLASSEXW, 8)
    TEST_TARGET_SIZE (LPWNDCLASSEXW, 80)
    TEST_TARGET_ALIGN(LPWNDCLASSEXW, 8)
}

static void test_pack_LPWNDCLASSW(void)
{
    /* LPWNDCLASSW */
    TEST_TYPE_SIZE   (LPWNDCLASSW, 8)
    TEST_TYPE_ALIGN  (LPWNDCLASSW, 8)
    TEST_TARGET_SIZE (LPWNDCLASSW, 72)
    TEST_TARGET_ALIGN(LPWNDCLASSW, 8)
}

static void test_pack_MDICREATESTRUCTA(void)
{
    /* MDICREATESTRUCTA */
    TEST_TYPE_SIZE   (MDICREATESTRUCTA, 56)
    TEST_TYPE_ALIGN  (MDICREATESTRUCTA, 8)
    TEST_FIELD_SIZE  (MDICREATESTRUCTA, szClass, 8)
    TEST_FIELD_ALIGN (MDICREATESTRUCTA, szClass, 8)
    TEST_FIELD_OFFSET(MDICREATESTRUCTA, szClass, 0)
    TEST_FIELD_SIZE  (MDICREATESTRUCTA, szTitle, 8)
    TEST_FIELD_ALIGN (MDICREATESTRUCTA, szTitle, 8)
    TEST_FIELD_OFFSET(MDICREATESTRUCTA, szTitle, 8)
    TEST_FIELD_SIZE  (MDICREATESTRUCTA, hOwner, 8)
    TEST_FIELD_ALIGN (MDICREATESTRUCTA, hOwner, 8)
    TEST_FIELD_OFFSET(MDICREATESTRUCTA, hOwner, 16)
    TEST_FIELD_SIZE  (MDICREATESTRUCTA, x, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTA, x, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTA, x, 24)
    TEST_FIELD_SIZE  (MDICREATESTRUCTA, y, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTA, y, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTA, y, 28)
    TEST_FIELD_SIZE  (MDICREATESTRUCTA, cx, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTA, cx, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTA, cx, 32)
    TEST_FIELD_SIZE  (MDICREATESTRUCTA, cy, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTA, cy, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTA, cy, 36)
    TEST_FIELD_SIZE  (MDICREATESTRUCTA, style, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTA, style, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTA, style, 40)
    TEST_FIELD_SIZE  (MDICREATESTRUCTA, lParam, 8)
    TEST_FIELD_ALIGN (MDICREATESTRUCTA, lParam, 8)
    TEST_FIELD_OFFSET(MDICREATESTRUCTA, lParam, 48)
}

static void test_pack_MDICREATESTRUCTW(void)
{
    /* MDICREATESTRUCTW */
    TEST_TYPE_SIZE   (MDICREATESTRUCTW, 56)
    TEST_TYPE_ALIGN  (MDICREATESTRUCTW, 8)
    TEST_FIELD_SIZE  (MDICREATESTRUCTW, szClass, 8)
    TEST_FIELD_ALIGN (MDICREATESTRUCTW, szClass, 8)
    TEST_FIELD_OFFSET(MDICREATESTRUCTW, szClass, 0)
    TEST_FIELD_SIZE  (MDICREATESTRUCTW, szTitle, 8)
    TEST_FIELD_ALIGN (MDICREATESTRUCTW, szTitle, 8)
    TEST_FIELD_OFFSET(MDICREATESTRUCTW, szTitle, 8)
    TEST_FIELD_SIZE  (MDICREATESTRUCTW, hOwner, 8)
    TEST_FIELD_ALIGN (MDICREATESTRUCTW, hOwner, 8)
    TEST_FIELD_OFFSET(MDICREATESTRUCTW, hOwner, 16)
    TEST_FIELD_SIZE  (MDICREATESTRUCTW, x, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTW, x, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTW, x, 24)
    TEST_FIELD_SIZE  (MDICREATESTRUCTW, y, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTW, y, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTW, y, 28)
    TEST_FIELD_SIZE  (MDICREATESTRUCTW, cx, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTW, cx, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTW, cx, 32)
    TEST_FIELD_SIZE  (MDICREATESTRUCTW, cy, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTW, cy, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTW, cy, 36)
    TEST_FIELD_SIZE  (MDICREATESTRUCTW, style, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTW, style, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTW, style, 40)
    TEST_FIELD_SIZE  (MDICREATESTRUCTW, lParam, 8)
    TEST_FIELD_ALIGN (MDICREATESTRUCTW, lParam, 8)
    TEST_FIELD_OFFSET(MDICREATESTRUCTW, lParam, 48)
}

static void test_pack_MDINEXTMENU(void)
{
    /* MDINEXTMENU */
    TEST_TYPE_SIZE   (MDINEXTMENU, 24)
    TEST_TYPE_ALIGN  (MDINEXTMENU, 8)
    TEST_FIELD_SIZE  (MDINEXTMENU, hmenuIn, 8)
    TEST_FIELD_ALIGN (MDINEXTMENU, hmenuIn, 8)
    TEST_FIELD_OFFSET(MDINEXTMENU, hmenuIn, 0)
    TEST_FIELD_SIZE  (MDINEXTMENU, hmenuNext, 8)
    TEST_FIELD_ALIGN (MDINEXTMENU, hmenuNext, 8)
    TEST_FIELD_OFFSET(MDINEXTMENU, hmenuNext, 8)
    TEST_FIELD_SIZE  (MDINEXTMENU, hwndNext, 8)
    TEST_FIELD_ALIGN (MDINEXTMENU, hwndNext, 8)
    TEST_FIELD_OFFSET(MDINEXTMENU, hwndNext, 16)
}

static void test_pack_MEASUREITEMSTRUCT(void)
{
    /* MEASUREITEMSTRUCT */
    TEST_TYPE_SIZE   (MEASUREITEMSTRUCT, 32)
    TEST_TYPE_ALIGN  (MEASUREITEMSTRUCT, 8)
    TEST_FIELD_SIZE  (MEASUREITEMSTRUCT, CtlType, 4)
    TEST_FIELD_ALIGN (MEASUREITEMSTRUCT, CtlType, 4)
    TEST_FIELD_OFFSET(MEASUREITEMSTRUCT, CtlType, 0)
    TEST_FIELD_SIZE  (MEASUREITEMSTRUCT, CtlID, 4)
    TEST_FIELD_ALIGN (MEASUREITEMSTRUCT, CtlID, 4)
    TEST_FIELD_OFFSET(MEASUREITEMSTRUCT, CtlID, 4)
    TEST_FIELD_SIZE  (MEASUREITEMSTRUCT, itemID, 4)
    TEST_FIELD_ALIGN (MEASUREITEMSTRUCT, itemID, 4)
    TEST_FIELD_OFFSET(MEASUREITEMSTRUCT, itemID, 8)
    TEST_FIELD_SIZE  (MEASUREITEMSTRUCT, itemWidth, 4)
    TEST_FIELD_ALIGN (MEASUREITEMSTRUCT, itemWidth, 4)
    TEST_FIELD_OFFSET(MEASUREITEMSTRUCT, itemWidth, 12)
    TEST_FIELD_SIZE  (MEASUREITEMSTRUCT, itemHeight, 4)
    TEST_FIELD_ALIGN (MEASUREITEMSTRUCT, itemHeight, 4)
    TEST_FIELD_OFFSET(MEASUREITEMSTRUCT, itemHeight, 16)
    TEST_FIELD_SIZE  (MEASUREITEMSTRUCT, itemData, 8)
    TEST_FIELD_ALIGN (MEASUREITEMSTRUCT, itemData, 8)
    TEST_FIELD_OFFSET(MEASUREITEMSTRUCT, itemData, 24)
}

static void test_pack_MENUINFO(void)
{
    /* MENUINFO */
    TEST_TYPE_SIZE   (MENUINFO, 40)
    TEST_TYPE_ALIGN  (MENUINFO, 8)
    TEST_FIELD_SIZE  (MENUINFO, cbSize, 4)
    TEST_FIELD_ALIGN (MENUINFO, cbSize, 4)
    TEST_FIELD_OFFSET(MENUINFO, cbSize, 0)
    TEST_FIELD_SIZE  (MENUINFO, fMask, 4)
    TEST_FIELD_ALIGN (MENUINFO, fMask, 4)
    TEST_FIELD_OFFSET(MENUINFO, fMask, 4)
    TEST_FIELD_SIZE  (MENUINFO, dwStyle, 4)
    TEST_FIELD_ALIGN (MENUINFO, dwStyle, 4)
    TEST_FIELD_OFFSET(MENUINFO, dwStyle, 8)
    TEST_FIELD_SIZE  (MENUINFO, cyMax, 4)
    TEST_FIELD_ALIGN (MENUINFO, cyMax, 4)
    TEST_FIELD_OFFSET(MENUINFO, cyMax, 12)
    TEST_FIELD_SIZE  (MENUINFO, hbrBack, 8)
    TEST_FIELD_ALIGN (MENUINFO, hbrBack, 8)
    TEST_FIELD_OFFSET(MENUINFO, hbrBack, 16)
    TEST_FIELD_SIZE  (MENUINFO, dwContextHelpID, 4)
    TEST_FIELD_ALIGN (MENUINFO, dwContextHelpID, 4)
    TEST_FIELD_OFFSET(MENUINFO, dwContextHelpID, 24)
    TEST_FIELD_SIZE  (MENUINFO, dwMenuData, 8)
    TEST_FIELD_ALIGN (MENUINFO, dwMenuData, 8)
    TEST_FIELD_OFFSET(MENUINFO, dwMenuData, 32)
}

static void test_pack_MENUITEMINFOA(void)
{
    /* MENUITEMINFOA */
    TEST_TYPE_SIZE   (MENUITEMINFOA, 80)
    TEST_TYPE_ALIGN  (MENUITEMINFOA, 8)
    TEST_FIELD_SIZE  (MENUITEMINFOA, cbSize, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOA, cbSize, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOA, cbSize, 0)
    TEST_FIELD_SIZE  (MENUITEMINFOA, fMask, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOA, fMask, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOA, fMask, 4)
    TEST_FIELD_SIZE  (MENUITEMINFOA, fType, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOA, fType, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOA, fType, 8)
    TEST_FIELD_SIZE  (MENUITEMINFOA, fState, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOA, fState, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOA, fState, 12)
    TEST_FIELD_SIZE  (MENUITEMINFOA, wID, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOA, wID, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOA, wID, 16)
    TEST_FIELD_SIZE  (MENUITEMINFOA, hSubMenu, 8)
    TEST_FIELD_ALIGN (MENUITEMINFOA, hSubMenu, 8)
    TEST_FIELD_OFFSET(MENUITEMINFOA, hSubMenu, 24)
    TEST_FIELD_SIZE  (MENUITEMINFOA, hbmpChecked, 8)
    TEST_FIELD_ALIGN (MENUITEMINFOA, hbmpChecked, 8)
    TEST_FIELD_OFFSET(MENUITEMINFOA, hbmpChecked, 32)
    TEST_FIELD_SIZE  (MENUITEMINFOA, hbmpUnchecked, 8)
    TEST_FIELD_ALIGN (MENUITEMINFOA, hbmpUnchecked, 8)
    TEST_FIELD_OFFSET(MENUITEMINFOA, hbmpUnchecked, 40)
    TEST_FIELD_SIZE  (MENUITEMINFOA, dwItemData, 8)
    TEST_FIELD_ALIGN (MENUITEMINFOA, dwItemData, 8)
    TEST_FIELD_OFFSET(MENUITEMINFOA, dwItemData, 48)
    TEST_FIELD_SIZE  (MENUITEMINFOA, dwTypeData, 8)
    TEST_FIELD_ALIGN (MENUITEMINFOA, dwTypeData, 8)
    TEST_FIELD_OFFSET(MENUITEMINFOA, dwTypeData, 56)
    TEST_FIELD_SIZE  (MENUITEMINFOA, cch, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOA, cch, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOA, cch, 64)
    TEST_FIELD_SIZE  (MENUITEMINFOA, hbmpItem, 8)
    TEST_FIELD_ALIGN (MENUITEMINFOA, hbmpItem, 8)
    TEST_FIELD_OFFSET(MENUITEMINFOA, hbmpItem, 72)
}

static void test_pack_MENUITEMINFOW(void)
{
    /* MENUITEMINFOW */
    TEST_TYPE_SIZE   (MENUITEMINFOW, 80)
    TEST_TYPE_ALIGN  (MENUITEMINFOW, 8)
    TEST_FIELD_SIZE  (MENUITEMINFOW, cbSize, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOW, cbSize, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOW, cbSize, 0)
    TEST_FIELD_SIZE  (MENUITEMINFOW, fMask, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOW, fMask, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOW, fMask, 4)
    TEST_FIELD_SIZE  (MENUITEMINFOW, fType, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOW, fType, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOW, fType, 8)
    TEST_FIELD_SIZE  (MENUITEMINFOW, fState, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOW, fState, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOW, fState, 12)
    TEST_FIELD_SIZE  (MENUITEMINFOW, wID, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOW, wID, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOW, wID, 16)
    TEST_FIELD_SIZE  (MENUITEMINFOW, hSubMenu, 8)
    TEST_FIELD_ALIGN (MENUITEMINFOW, hSubMenu, 8)
    TEST_FIELD_OFFSET(MENUITEMINFOW, hSubMenu, 24)
    TEST_FIELD_SIZE  (MENUITEMINFOW, hbmpChecked, 8)
    TEST_FIELD_ALIGN (MENUITEMINFOW, hbmpChecked, 8)
    TEST_FIELD_OFFSET(MENUITEMINFOW, hbmpChecked, 32)
    TEST_FIELD_SIZE  (MENUITEMINFOW, hbmpUnchecked, 8)
    TEST_FIELD_ALIGN (MENUITEMINFOW, hbmpUnchecked, 8)
    TEST_FIELD_OFFSET(MENUITEMINFOW, hbmpUnchecked, 40)
    TEST_FIELD_SIZE  (MENUITEMINFOW, dwItemData, 8)
    TEST_FIELD_ALIGN (MENUITEMINFOW, dwItemData, 8)
    TEST_FIELD_OFFSET(MENUITEMINFOW, dwItemData, 48)
    TEST_FIELD_SIZE  (MENUITEMINFOW, dwTypeData, 8)
    TEST_FIELD_ALIGN (MENUITEMINFOW, dwTypeData, 8)
    TEST_FIELD_OFFSET(MENUITEMINFOW, dwTypeData, 56)
    TEST_FIELD_SIZE  (MENUITEMINFOW, cch, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOW, cch, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOW, cch, 64)
    TEST_FIELD_SIZE  (MENUITEMINFOW, hbmpItem, 8)
    TEST_FIELD_ALIGN (MENUITEMINFOW, hbmpItem, 8)
    TEST_FIELD_OFFSET(MENUITEMINFOW, hbmpItem, 72)
}

static void test_pack_MENUITEMTEMPLATE(void)
{
    /* MENUITEMTEMPLATE */
    TEST_TYPE_SIZE   (MENUITEMTEMPLATE, 6)
    TEST_TYPE_ALIGN  (MENUITEMTEMPLATE, 2)
    TEST_FIELD_SIZE  (MENUITEMTEMPLATE, mtOption, 2)
    TEST_FIELD_ALIGN (MENUITEMTEMPLATE, mtOption, 2)
    TEST_FIELD_OFFSET(MENUITEMTEMPLATE, mtOption, 0)
    TEST_FIELD_SIZE  (MENUITEMTEMPLATE, mtID, 2)
    TEST_FIELD_ALIGN (MENUITEMTEMPLATE, mtID, 2)
    TEST_FIELD_OFFSET(MENUITEMTEMPLATE, mtID, 2)
    TEST_FIELD_SIZE  (MENUITEMTEMPLATE, mtString, 2)
    TEST_FIELD_ALIGN (MENUITEMTEMPLATE, mtString, 2)
    TEST_FIELD_OFFSET(MENUITEMTEMPLATE, mtString, 4)
}

static void test_pack_MENUITEMTEMPLATEHEADER(void)
{
    /* MENUITEMTEMPLATEHEADER */
    TEST_TYPE_SIZE   (MENUITEMTEMPLATEHEADER, 4)
    TEST_TYPE_ALIGN  (MENUITEMTEMPLATEHEADER, 2)
    TEST_FIELD_SIZE  (MENUITEMTEMPLATEHEADER, versionNumber, 2)
    TEST_FIELD_ALIGN (MENUITEMTEMPLATEHEADER, versionNumber, 2)
    TEST_FIELD_OFFSET(MENUITEMTEMPLATEHEADER, versionNumber, 0)
    TEST_FIELD_SIZE  (MENUITEMTEMPLATEHEADER, offset, 2)
    TEST_FIELD_ALIGN (MENUITEMTEMPLATEHEADER, offset, 2)
    TEST_FIELD_OFFSET(MENUITEMTEMPLATEHEADER, offset, 2)
}

static void test_pack_MINIMIZEDMETRICS(void)
{
    /* MINIMIZEDMETRICS */
    TEST_TYPE_SIZE   (MINIMIZEDMETRICS, 20)
    TEST_TYPE_ALIGN  (MINIMIZEDMETRICS, 4)
    TEST_FIELD_SIZE  (MINIMIZEDMETRICS, cbSize, 4)
    TEST_FIELD_ALIGN (MINIMIZEDMETRICS, cbSize, 4)
    TEST_FIELD_OFFSET(MINIMIZEDMETRICS, cbSize, 0)
    TEST_FIELD_SIZE  (MINIMIZEDMETRICS, iWidth, 4)
    TEST_FIELD_ALIGN (MINIMIZEDMETRICS, iWidth, 4)
    TEST_FIELD_OFFSET(MINIMIZEDMETRICS, iWidth, 4)
    TEST_FIELD_SIZE  (MINIMIZEDMETRICS, iHorzGap, 4)
    TEST_FIELD_ALIGN (MINIMIZEDMETRICS, iHorzGap, 4)
    TEST_FIELD_OFFSET(MINIMIZEDMETRICS, iHorzGap, 8)
    TEST_FIELD_SIZE  (MINIMIZEDMETRICS, iVertGap, 4)
    TEST_FIELD_ALIGN (MINIMIZEDMETRICS, iVertGap, 4)
    TEST_FIELD_OFFSET(MINIMIZEDMETRICS, iVertGap, 12)
    TEST_FIELD_SIZE  (MINIMIZEDMETRICS, iArrange, 4)
    TEST_FIELD_ALIGN (MINIMIZEDMETRICS, iArrange, 4)
    TEST_FIELD_OFFSET(MINIMIZEDMETRICS, iArrange, 16)
}

static void test_pack_MINMAXINFO(void)
{
    /* MINMAXINFO */
    TEST_TYPE_SIZE   (MINMAXINFO, 40)
    TEST_TYPE_ALIGN  (MINMAXINFO, 4)
    TEST_FIELD_SIZE  (MINMAXINFO, ptReserved, 8)
    TEST_FIELD_ALIGN (MINMAXINFO, ptReserved, 4)
    TEST_FIELD_OFFSET(MINMAXINFO, ptReserved, 0)
    TEST_FIELD_SIZE  (MINMAXINFO, ptMaxSize, 8)
    TEST_FIELD_ALIGN (MINMAXINFO, ptMaxSize, 4)
    TEST_FIELD_OFFSET(MINMAXINFO, ptMaxSize, 8)
    TEST_FIELD_SIZE  (MINMAXINFO, ptMaxPosition, 8)
    TEST_FIELD_ALIGN (MINMAXINFO, ptMaxPosition, 4)
    TEST_FIELD_OFFSET(MINMAXINFO, ptMaxPosition, 16)
    TEST_FIELD_SIZE  (MINMAXINFO, ptMinTrackSize, 8)
    TEST_FIELD_ALIGN (MINMAXINFO, ptMinTrackSize, 4)
    TEST_FIELD_OFFSET(MINMAXINFO, ptMinTrackSize, 24)
    TEST_FIELD_SIZE  (MINMAXINFO, ptMaxTrackSize, 8)
    TEST_FIELD_ALIGN (MINMAXINFO, ptMaxTrackSize, 4)
    TEST_FIELD_OFFSET(MINMAXINFO, ptMaxTrackSize, 32)
}

static void test_pack_MONITORENUMPROC(void)
{
    /* MONITORENUMPROC */
    TEST_TYPE_SIZE   (MONITORENUMPROC, 8)
    TEST_TYPE_ALIGN  (MONITORENUMPROC, 8)
}

static void test_pack_MONITORINFO(void)
{
    /* MONITORINFO */
    TEST_TYPE_SIZE   (MONITORINFO, 40)
    TEST_TYPE_ALIGN  (MONITORINFO, 4)
    TEST_FIELD_SIZE  (MONITORINFO, cbSize, 4)
    TEST_FIELD_ALIGN (MONITORINFO, cbSize, 4)
    TEST_FIELD_OFFSET(MONITORINFO, cbSize, 0)
    TEST_FIELD_SIZE  (MONITORINFO, rcMonitor, 16)
    TEST_FIELD_ALIGN (MONITORINFO, rcMonitor, 4)
    TEST_FIELD_OFFSET(MONITORINFO, rcMonitor, 4)
    TEST_FIELD_SIZE  (MONITORINFO, rcWork, 16)
    TEST_FIELD_ALIGN (MONITORINFO, rcWork, 4)
    TEST_FIELD_OFFSET(MONITORINFO, rcWork, 20)
    TEST_FIELD_SIZE  (MONITORINFO, dwFlags, 4)
    TEST_FIELD_ALIGN (MONITORINFO, dwFlags, 4)
    TEST_FIELD_OFFSET(MONITORINFO, dwFlags, 36)
}

static void test_pack_MONITORINFOEXA(void)
{
    /* MONITORINFOEXA */
    TEST_TYPE_SIZE   (MONITORINFOEXA, 72)
    TEST_TYPE_ALIGN  (MONITORINFOEXA, 4)
    TEST_FIELD_SIZE  (MONITORINFOEXA, cbSize, 4)
    TEST_FIELD_ALIGN (MONITORINFOEXA, cbSize, 4)
    TEST_FIELD_OFFSET(MONITORINFOEXA, cbSize, 0)
    TEST_FIELD_SIZE  (MONITORINFOEXA, rcMonitor, 16)
    TEST_FIELD_ALIGN (MONITORINFOEXA, rcMonitor, 4)
    TEST_FIELD_OFFSET(MONITORINFOEXA, rcMonitor, 4)
    TEST_FIELD_SIZE  (MONITORINFOEXA, rcWork, 16)
    TEST_FIELD_ALIGN (MONITORINFOEXA, rcWork, 4)
    TEST_FIELD_OFFSET(MONITORINFOEXA, rcWork, 20)
    TEST_FIELD_SIZE  (MONITORINFOEXA, dwFlags, 4)
    TEST_FIELD_ALIGN (MONITORINFOEXA, dwFlags, 4)
    TEST_FIELD_OFFSET(MONITORINFOEXA, dwFlags, 36)
    TEST_FIELD_SIZE  (MONITORINFOEXA, szDevice, 32)
    TEST_FIELD_ALIGN (MONITORINFOEXA, szDevice, 1)
    TEST_FIELD_OFFSET(MONITORINFOEXA, szDevice, 40)
}

static void test_pack_MONITORINFOEXW(void)
{
    /* MONITORINFOEXW */
    TEST_TYPE_SIZE   (MONITORINFOEXW, 104)
    TEST_TYPE_ALIGN  (MONITORINFOEXW, 4)
    TEST_FIELD_SIZE  (MONITORINFOEXW, cbSize, 4)
    TEST_FIELD_ALIGN (MONITORINFOEXW, cbSize, 4)
    TEST_FIELD_OFFSET(MONITORINFOEXW, cbSize, 0)
    TEST_FIELD_SIZE  (MONITORINFOEXW, rcMonitor, 16)
    TEST_FIELD_ALIGN (MONITORINFOEXW, rcMonitor, 4)
    TEST_FIELD_OFFSET(MONITORINFOEXW, rcMonitor, 4)
    TEST_FIELD_SIZE  (MONITORINFOEXW, rcWork, 16)
    TEST_FIELD_ALIGN (MONITORINFOEXW, rcWork, 4)
    TEST_FIELD_OFFSET(MONITORINFOEXW, rcWork, 20)
    TEST_FIELD_SIZE  (MONITORINFOEXW, dwFlags, 4)
    TEST_FIELD_ALIGN (MONITORINFOEXW, dwFlags, 4)
    TEST_FIELD_OFFSET(MONITORINFOEXW, dwFlags, 36)
    TEST_FIELD_SIZE  (MONITORINFOEXW, szDevice, 64)
    TEST_FIELD_ALIGN (MONITORINFOEXW, szDevice, 2)
    TEST_FIELD_OFFSET(MONITORINFOEXW, szDevice, 40)
}

static void test_pack_MOUSEHOOKSTRUCT(void)
{
    /* MOUSEHOOKSTRUCT */
    TEST_TYPE_SIZE   (MOUSEHOOKSTRUCT, 32)
    TEST_TYPE_ALIGN  (MOUSEHOOKSTRUCT, 8)
    TEST_FIELD_SIZE  (MOUSEHOOKSTRUCT, pt, 8)
    TEST_FIELD_ALIGN (MOUSEHOOKSTRUCT, pt, 4)
    TEST_FIELD_OFFSET(MOUSEHOOKSTRUCT, pt, 0)
    TEST_FIELD_SIZE  (MOUSEHOOKSTRUCT, hwnd, 8)
    TEST_FIELD_ALIGN (MOUSEHOOKSTRUCT, hwnd, 8)
    TEST_FIELD_OFFSET(MOUSEHOOKSTRUCT, hwnd, 8)
    TEST_FIELD_SIZE  (MOUSEHOOKSTRUCT, wHitTestCode, 4)
    TEST_FIELD_ALIGN (MOUSEHOOKSTRUCT, wHitTestCode, 4)
    TEST_FIELD_OFFSET(MOUSEHOOKSTRUCT, wHitTestCode, 16)
    TEST_FIELD_SIZE  (MOUSEHOOKSTRUCT, dwExtraInfo, 8)
    TEST_FIELD_ALIGN (MOUSEHOOKSTRUCT, dwExtraInfo, 8)
    TEST_FIELD_OFFSET(MOUSEHOOKSTRUCT, dwExtraInfo, 24)
}

static void test_pack_MOUSEINPUT(void)
{
    /* MOUSEINPUT */
    TEST_TYPE_SIZE   (MOUSEINPUT, 32)
    TEST_TYPE_ALIGN  (MOUSEINPUT, 8)
    TEST_FIELD_SIZE  (MOUSEINPUT, dx, 4)
    TEST_FIELD_ALIGN (MOUSEINPUT, dx, 4)
    TEST_FIELD_OFFSET(MOUSEINPUT, dx, 0)
    TEST_FIELD_SIZE  (MOUSEINPUT, dy, 4)
    TEST_FIELD_ALIGN (MOUSEINPUT, dy, 4)
    TEST_FIELD_OFFSET(MOUSEINPUT, dy, 4)
    TEST_FIELD_SIZE  (MOUSEINPUT, mouseData, 4)
    TEST_FIELD_ALIGN (MOUSEINPUT, mouseData, 4)
    TEST_FIELD_OFFSET(MOUSEINPUT, mouseData, 8)
    TEST_FIELD_SIZE  (MOUSEINPUT, dwFlags, 4)
    TEST_FIELD_ALIGN (MOUSEINPUT, dwFlags, 4)
    TEST_FIELD_OFFSET(MOUSEINPUT, dwFlags, 12)
    TEST_FIELD_SIZE  (MOUSEINPUT, time, 4)
    TEST_FIELD_ALIGN (MOUSEINPUT, time, 4)
    TEST_FIELD_OFFSET(MOUSEINPUT, time, 16)
    TEST_FIELD_SIZE  (MOUSEINPUT, dwExtraInfo, 8)
    TEST_FIELD_ALIGN (MOUSEINPUT, dwExtraInfo, 8)
    TEST_FIELD_OFFSET(MOUSEINPUT, dwExtraInfo, 24)
}

static void test_pack_MOUSEKEYS(void)
{
    /* MOUSEKEYS */
    TEST_TYPE_SIZE   (MOUSEKEYS, 28)
    TEST_TYPE_ALIGN  (MOUSEKEYS, 4)
    TEST_FIELD_SIZE  (MOUSEKEYS, cbSize, 4)
    TEST_FIELD_ALIGN (MOUSEKEYS, cbSize, 4)
    TEST_FIELD_OFFSET(MOUSEKEYS, cbSize, 0)
    TEST_FIELD_SIZE  (MOUSEKEYS, dwFlags, 4)
    TEST_FIELD_ALIGN (MOUSEKEYS, dwFlags, 4)
    TEST_FIELD_OFFSET(MOUSEKEYS, dwFlags, 4)
    TEST_FIELD_SIZE  (MOUSEKEYS, iMaxSpeed, 4)
    TEST_FIELD_ALIGN (MOUSEKEYS, iMaxSpeed, 4)
    TEST_FIELD_OFFSET(MOUSEKEYS, iMaxSpeed, 8)
    TEST_FIELD_SIZE  (MOUSEKEYS, iTimeToMaxSpeed, 4)
    TEST_FIELD_ALIGN (MOUSEKEYS, iTimeToMaxSpeed, 4)
    TEST_FIELD_OFFSET(MOUSEKEYS, iTimeToMaxSpeed, 12)
    TEST_FIELD_SIZE  (MOUSEKEYS, iCtrlSpeed, 4)
    TEST_FIELD_ALIGN (MOUSEKEYS, iCtrlSpeed, 4)
    TEST_FIELD_OFFSET(MOUSEKEYS, iCtrlSpeed, 16)
    TEST_FIELD_SIZE  (MOUSEKEYS, dwReserved1, 4)
    TEST_FIELD_ALIGN (MOUSEKEYS, dwReserved1, 4)
    TEST_FIELD_OFFSET(MOUSEKEYS, dwReserved1, 20)
    TEST_FIELD_SIZE  (MOUSEKEYS, dwReserved2, 4)
    TEST_FIELD_ALIGN (MOUSEKEYS, dwReserved2, 4)
    TEST_FIELD_OFFSET(MOUSEKEYS, dwReserved2, 24)
}

static void test_pack_MSG(void)
{
    /* MSG */
    TEST_TYPE_SIZE   (MSG, 48)
    TEST_TYPE_ALIGN  (MSG, 8)
    TEST_FIELD_SIZE  (MSG, hwnd, 8)
    TEST_FIELD_ALIGN (MSG, hwnd, 8)
    TEST_FIELD_OFFSET(MSG, hwnd, 0)
    TEST_FIELD_SIZE  (MSG, message, 4)
    TEST_FIELD_ALIGN (MSG, message, 4)
    TEST_FIELD_OFFSET(MSG, message, 8)
    TEST_FIELD_SIZE  (MSG, wParam, 8)
    TEST_FIELD_ALIGN (MSG, wParam, 8)
    TEST_FIELD_OFFSET(MSG, wParam, 16)
    TEST_FIELD_SIZE  (MSG, lParam, 8)
    TEST_FIELD_ALIGN (MSG, lParam, 8)
    TEST_FIELD_OFFSET(MSG, lParam, 24)
    TEST_FIELD_SIZE  (MSG, time, 4)
    TEST_FIELD_ALIGN (MSG, time, 4)
    TEST_FIELD_OFFSET(MSG, time, 32)
    TEST_FIELD_SIZE  (MSG, pt, 8)
    TEST_FIELD_ALIGN (MSG, pt, 4)
    TEST_FIELD_OFFSET(MSG, pt, 36)
}

static void test_pack_MSGBOXCALLBACK(void)
{
    /* MSGBOXCALLBACK */
    TEST_TYPE_SIZE   (MSGBOXCALLBACK, 8)
    TEST_TYPE_ALIGN  (MSGBOXCALLBACK, 8)
}

static void test_pack_MSGBOXPARAMSA(void)
{
    /* MSGBOXPARAMSA */
    TEST_TYPE_SIZE   (MSGBOXPARAMSA, 80)
    TEST_TYPE_ALIGN  (MSGBOXPARAMSA, 8)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, cbSize, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, cbSize, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, cbSize, 0)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, hwndOwner, 8)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, hwndOwner, 8)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, hwndOwner, 8)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, hInstance, 8)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, hInstance, 8)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, hInstance, 16)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, lpszText, 8)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, lpszText, 8)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, lpszText, 24)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, lpszCaption, 8)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, lpszCaption, 8)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, lpszCaption, 32)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, dwStyle, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, dwStyle, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, dwStyle, 40)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, lpszIcon, 8)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, lpszIcon, 8)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, lpszIcon, 48)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, dwContextHelpId, 8)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, dwContextHelpId, 8)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, dwContextHelpId, 56)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, lpfnMsgBoxCallback, 8)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, lpfnMsgBoxCallback, 8)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, lpfnMsgBoxCallback, 64)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, dwLanguageId, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, dwLanguageId, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, dwLanguageId, 72)
}

static void test_pack_MSGBOXPARAMSW(void)
{
    /* MSGBOXPARAMSW */
    TEST_TYPE_SIZE   (MSGBOXPARAMSW, 80)
    TEST_TYPE_ALIGN  (MSGBOXPARAMSW, 8)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, cbSize, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, cbSize, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, cbSize, 0)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, hwndOwner, 8)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, hwndOwner, 8)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, hwndOwner, 8)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, hInstance, 8)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, hInstance, 8)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, hInstance, 16)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, lpszText, 8)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, lpszText, 8)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, lpszText, 24)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, lpszCaption, 8)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, lpszCaption, 8)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, lpszCaption, 32)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, dwStyle, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, dwStyle, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, dwStyle, 40)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, lpszIcon, 8)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, lpszIcon, 8)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, lpszIcon, 48)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, dwContextHelpId, 8)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, dwContextHelpId, 8)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, dwContextHelpId, 56)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, lpfnMsgBoxCallback, 8)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, lpfnMsgBoxCallback, 8)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, lpfnMsgBoxCallback, 64)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, dwLanguageId, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, dwLanguageId, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, dwLanguageId, 72)
}

static void test_pack_MSLLHOOKSTRUCT(void)
{
    /* MSLLHOOKSTRUCT */
    TEST_TYPE_SIZE   (MSLLHOOKSTRUCT, 32)
    TEST_TYPE_ALIGN  (MSLLHOOKSTRUCT, 8)
    TEST_FIELD_SIZE  (MSLLHOOKSTRUCT, pt, 8)
    TEST_FIELD_ALIGN (MSLLHOOKSTRUCT, pt, 4)
    TEST_FIELD_OFFSET(MSLLHOOKSTRUCT, pt, 0)
    TEST_FIELD_SIZE  (MSLLHOOKSTRUCT, mouseData, 4)
    TEST_FIELD_ALIGN (MSLLHOOKSTRUCT, mouseData, 4)
    TEST_FIELD_OFFSET(MSLLHOOKSTRUCT, mouseData, 8)
    TEST_FIELD_SIZE  (MSLLHOOKSTRUCT, flags, 4)
    TEST_FIELD_ALIGN (MSLLHOOKSTRUCT, flags, 4)
    TEST_FIELD_OFFSET(MSLLHOOKSTRUCT, flags, 12)
    TEST_FIELD_SIZE  (MSLLHOOKSTRUCT, time, 4)
    TEST_FIELD_ALIGN (MSLLHOOKSTRUCT, time, 4)
    TEST_FIELD_OFFSET(MSLLHOOKSTRUCT, time, 16)
    TEST_FIELD_SIZE  (MSLLHOOKSTRUCT, dwExtraInfo, 8)
    TEST_FIELD_ALIGN (MSLLHOOKSTRUCT, dwExtraInfo, 8)
    TEST_FIELD_OFFSET(MSLLHOOKSTRUCT, dwExtraInfo, 24)
}

static void test_pack_MULTIKEYHELPA(void)
{
    /* MULTIKEYHELPA */
    TEST_TYPE_SIZE   (MULTIKEYHELPA, 8)
    TEST_TYPE_ALIGN  (MULTIKEYHELPA, 4)
    TEST_FIELD_SIZE  (MULTIKEYHELPA, mkSize, 4)
    TEST_FIELD_ALIGN (MULTIKEYHELPA, mkSize, 4)
    TEST_FIELD_OFFSET(MULTIKEYHELPA, mkSize, 0)
    TEST_FIELD_SIZE  (MULTIKEYHELPA, mkKeylist, 1)
    TEST_FIELD_ALIGN (MULTIKEYHELPA, mkKeylist, 1)
    TEST_FIELD_OFFSET(MULTIKEYHELPA, mkKeylist, 4)
    TEST_FIELD_SIZE  (MULTIKEYHELPA, szKeyphrase, 1)
    TEST_FIELD_ALIGN (MULTIKEYHELPA, szKeyphrase, 1)
    TEST_FIELD_OFFSET(MULTIKEYHELPA, szKeyphrase, 5)
}

static void test_pack_MULTIKEYHELPW(void)
{
    /* MULTIKEYHELPW */
    TEST_TYPE_SIZE   (MULTIKEYHELPW, 8)
    TEST_TYPE_ALIGN  (MULTIKEYHELPW, 4)
    TEST_FIELD_SIZE  (MULTIKEYHELPW, mkSize, 4)
    TEST_FIELD_ALIGN (MULTIKEYHELPW, mkSize, 4)
    TEST_FIELD_OFFSET(MULTIKEYHELPW, mkSize, 0)
    TEST_FIELD_SIZE  (MULTIKEYHELPW, mkKeylist, 2)
    TEST_FIELD_ALIGN (MULTIKEYHELPW, mkKeylist, 2)
    TEST_FIELD_OFFSET(MULTIKEYHELPW, mkKeylist, 4)
    TEST_FIELD_SIZE  (MULTIKEYHELPW, szKeyphrase, 2)
    TEST_FIELD_ALIGN (MULTIKEYHELPW, szKeyphrase, 2)
    TEST_FIELD_OFFSET(MULTIKEYHELPW, szKeyphrase, 6)
}

static void test_pack_NAMEENUMPROCA(void)
{
    /* NAMEENUMPROCA */
    TEST_TYPE_SIZE   (NAMEENUMPROCA, 8)
    TEST_TYPE_ALIGN  (NAMEENUMPROCA, 8)
}

static void test_pack_NAMEENUMPROCW(void)
{
    /* NAMEENUMPROCW */
    TEST_TYPE_SIZE   (NAMEENUMPROCW, 8)
    TEST_TYPE_ALIGN  (NAMEENUMPROCW, 8)
}

static void test_pack_NCCALCSIZE_PARAMS(void)
{
    /* NCCALCSIZE_PARAMS */
    TEST_TYPE_SIZE   (NCCALCSIZE_PARAMS, 56)
    TEST_TYPE_ALIGN  (NCCALCSIZE_PARAMS, 8)
    TEST_FIELD_SIZE  (NCCALCSIZE_PARAMS, rgrc, 48)
    TEST_FIELD_ALIGN (NCCALCSIZE_PARAMS, rgrc, 4)
    TEST_FIELD_OFFSET(NCCALCSIZE_PARAMS, rgrc, 0)
    TEST_FIELD_SIZE  (NCCALCSIZE_PARAMS, lppos, 8)
    TEST_FIELD_ALIGN (NCCALCSIZE_PARAMS, lppos, 8)
    TEST_FIELD_OFFSET(NCCALCSIZE_PARAMS, lppos, 48)
}

static void test_pack_NMHDR(void)
{
    /* NMHDR */
    TEST_TYPE_SIZE   (NMHDR, 24)
    TEST_TYPE_ALIGN  (NMHDR, 8)
    TEST_FIELD_SIZE  (NMHDR, hwndFrom, 8)
    TEST_FIELD_ALIGN (NMHDR, hwndFrom, 8)
    TEST_FIELD_OFFSET(NMHDR, hwndFrom, 0)
    TEST_FIELD_SIZE  (NMHDR, idFrom, 8)
    TEST_FIELD_ALIGN (NMHDR, idFrom, 8)
    TEST_FIELD_OFFSET(NMHDR, idFrom, 8)
    TEST_FIELD_SIZE  (NMHDR, code, 4)
    TEST_FIELD_ALIGN (NMHDR, code, 4)
    TEST_FIELD_OFFSET(NMHDR, code, 16)
}

static void test_pack_NONCLIENTMETRICSA(void)
{
    /* NONCLIENTMETRICSA */
    TEST_TYPE_SIZE   (NONCLIENTMETRICSA, 340)
    TEST_TYPE_ALIGN  (NONCLIENTMETRICSA, 4)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, cbSize, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, cbSize, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, cbSize, 0)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, iBorderWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, iBorderWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, iBorderWidth, 4)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, iScrollWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, iScrollWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, iScrollWidth, 8)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, iScrollHeight, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, iScrollHeight, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, iScrollHeight, 12)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, iCaptionWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, iCaptionWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, iCaptionWidth, 16)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, iCaptionHeight, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, iCaptionHeight, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, iCaptionHeight, 20)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, lfCaptionFont, 60)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, lfCaptionFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, lfCaptionFont, 24)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, iSmCaptionWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, iSmCaptionWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, iSmCaptionWidth, 84)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, iSmCaptionHeight, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, iSmCaptionHeight, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, iSmCaptionHeight, 88)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, lfSmCaptionFont, 60)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, lfSmCaptionFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, lfSmCaptionFont, 92)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, iMenuWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, iMenuWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, iMenuWidth, 152)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, iMenuHeight, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, iMenuHeight, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, iMenuHeight, 156)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, lfMenuFont, 60)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, lfMenuFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, lfMenuFont, 160)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, lfStatusFont, 60)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, lfStatusFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, lfStatusFont, 220)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, lfMessageFont, 60)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, lfMessageFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, lfMessageFont, 280)
}

static void test_pack_NONCLIENTMETRICSW(void)
{
    /* NONCLIENTMETRICSW */
    TEST_TYPE_SIZE   (NONCLIENTMETRICSW, 500)
    TEST_TYPE_ALIGN  (NONCLIENTMETRICSW, 4)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, cbSize, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, cbSize, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, cbSize, 0)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, iBorderWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, iBorderWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, iBorderWidth, 4)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, iScrollWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, iScrollWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, iScrollWidth, 8)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, iScrollHeight, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, iScrollHeight, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, iScrollHeight, 12)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, iCaptionWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, iCaptionWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, iCaptionWidth, 16)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, iCaptionHeight, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, iCaptionHeight, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, iCaptionHeight, 20)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, lfCaptionFont, 92)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, lfCaptionFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, lfCaptionFont, 24)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, iSmCaptionWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, iSmCaptionWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, iSmCaptionWidth, 116)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, iSmCaptionHeight, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, iSmCaptionHeight, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, iSmCaptionHeight, 120)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, lfSmCaptionFont, 92)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, lfSmCaptionFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, lfSmCaptionFont, 124)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, iMenuWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, iMenuWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, iMenuWidth, 216)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, iMenuHeight, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, iMenuHeight, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, iMenuHeight, 220)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, lfMenuFont, 92)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, lfMenuFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, lfMenuFont, 224)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, lfStatusFont, 92)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, lfStatusFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, lfStatusFont, 316)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, lfMessageFont, 92)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, lfMessageFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, lfMessageFont, 408)
}

static void test_pack_PAINTSTRUCT(void)
{
    /* PAINTSTRUCT */
    TEST_TYPE_SIZE   (PAINTSTRUCT, 72)
    TEST_TYPE_ALIGN  (PAINTSTRUCT, 8)
    TEST_FIELD_SIZE  (PAINTSTRUCT, hdc, 8)
    TEST_FIELD_ALIGN (PAINTSTRUCT, hdc, 8)
    TEST_FIELD_OFFSET(PAINTSTRUCT, hdc, 0)
    TEST_FIELD_SIZE  (PAINTSTRUCT, fErase, 4)
    TEST_FIELD_ALIGN (PAINTSTRUCT, fErase, 4)
    TEST_FIELD_OFFSET(PAINTSTRUCT, fErase, 8)
    TEST_FIELD_SIZE  (PAINTSTRUCT, rcPaint, 16)
    TEST_FIELD_ALIGN (PAINTSTRUCT, rcPaint, 4)
    TEST_FIELD_OFFSET(PAINTSTRUCT, rcPaint, 12)
    TEST_FIELD_SIZE  (PAINTSTRUCT, fRestore, 4)
    TEST_FIELD_ALIGN (PAINTSTRUCT, fRestore, 4)
    TEST_FIELD_OFFSET(PAINTSTRUCT, fRestore, 28)
    TEST_FIELD_SIZE  (PAINTSTRUCT, fIncUpdate, 4)
    TEST_FIELD_ALIGN (PAINTSTRUCT, fIncUpdate, 4)
    TEST_FIELD_OFFSET(PAINTSTRUCT, fIncUpdate, 32)
    TEST_FIELD_SIZE  (PAINTSTRUCT, rgbReserved, 32)
    TEST_FIELD_ALIGN (PAINTSTRUCT, rgbReserved, 1)
    TEST_FIELD_OFFSET(PAINTSTRUCT, rgbReserved, 36)
}

static void test_pack_PCOMBOBOXINFO(void)
{
    /* PCOMBOBOXINFO */
    TEST_TYPE_SIZE   (PCOMBOBOXINFO, 8)
    TEST_TYPE_ALIGN  (PCOMBOBOXINFO, 8)
    TEST_TARGET_SIZE (PCOMBOBOXINFO, 64)
    TEST_TARGET_ALIGN(PCOMBOBOXINFO, 8)
}

static void test_pack_PCOMPAREITEMSTRUCT(void)
{
    /* PCOMPAREITEMSTRUCT */
    TEST_TYPE_SIZE   (PCOMPAREITEMSTRUCT, 8)
    TEST_TYPE_ALIGN  (PCOMPAREITEMSTRUCT, 8)
    TEST_TARGET_SIZE (PCOMPAREITEMSTRUCT, 56)
    TEST_TARGET_ALIGN(PCOMPAREITEMSTRUCT, 8)
}

static void test_pack_PCOPYDATASTRUCT(void)
{
    /* PCOPYDATASTRUCT */
    TEST_TYPE_SIZE   (PCOPYDATASTRUCT, 8)
    TEST_TYPE_ALIGN  (PCOPYDATASTRUCT, 8)
    TEST_TARGET_SIZE (PCOPYDATASTRUCT, 24)
    TEST_TARGET_ALIGN(PCOPYDATASTRUCT, 8)
}

static void test_pack_PCURSORINFO(void)
{
    /* PCURSORINFO */
    TEST_TYPE_SIZE   (PCURSORINFO, 8)
    TEST_TYPE_ALIGN  (PCURSORINFO, 8)
    TEST_TARGET_SIZE (PCURSORINFO, 24)
    TEST_TARGET_ALIGN(PCURSORINFO, 8)
}

static void test_pack_PCWPRETSTRUCT(void)
{
    /* PCWPRETSTRUCT */
    TEST_TYPE_SIZE   (PCWPRETSTRUCT, 8)
    TEST_TYPE_ALIGN  (PCWPRETSTRUCT, 8)
    TEST_TARGET_SIZE (PCWPRETSTRUCT, 40)
    TEST_TARGET_ALIGN(PCWPRETSTRUCT, 8)
}

static void test_pack_PCWPSTRUCT(void)
{
    /* PCWPSTRUCT */
    TEST_TYPE_SIZE   (PCWPSTRUCT, 8)
    TEST_TYPE_ALIGN  (PCWPSTRUCT, 8)
    TEST_TARGET_SIZE (PCWPSTRUCT, 32)
    TEST_TARGET_ALIGN(PCWPSTRUCT, 8)
}

static void test_pack_PDEBUGHOOKINFO(void)
{
    /* PDEBUGHOOKINFO */
    TEST_TYPE_SIZE   (PDEBUGHOOKINFO, 8)
    TEST_TYPE_ALIGN  (PDEBUGHOOKINFO, 8)
    TEST_TARGET_SIZE (PDEBUGHOOKINFO, 32)
    TEST_TARGET_ALIGN(PDEBUGHOOKINFO, 8)
}

static void test_pack_PDELETEITEMSTRUCT(void)
{
    /* PDELETEITEMSTRUCT */
    TEST_TYPE_SIZE   (PDELETEITEMSTRUCT, 8)
    TEST_TYPE_ALIGN  (PDELETEITEMSTRUCT, 8)
    TEST_TARGET_SIZE (PDELETEITEMSTRUCT, 32)
    TEST_TARGET_ALIGN(PDELETEITEMSTRUCT, 8)
}

static void test_pack_PDLGITEMTEMPLATEA(void)
{
    /* PDLGITEMTEMPLATEA */
    TEST_TYPE_SIZE   (PDLGITEMTEMPLATEA, 8)
    TEST_TYPE_ALIGN  (PDLGITEMTEMPLATEA, 8)
    TEST_TARGET_SIZE (PDLGITEMTEMPLATEA, 18)
    TEST_TARGET_ALIGN(PDLGITEMTEMPLATEA, 2)
}

static void test_pack_PDLGITEMTEMPLATEW(void)
{
    /* PDLGITEMTEMPLATEW */
    TEST_TYPE_SIZE   (PDLGITEMTEMPLATEW, 8)
    TEST_TYPE_ALIGN  (PDLGITEMTEMPLATEW, 8)
    TEST_TARGET_SIZE (PDLGITEMTEMPLATEW, 18)
    TEST_TARGET_ALIGN(PDLGITEMTEMPLATEW, 2)
}

static void test_pack_PDRAWITEMSTRUCT(void)
{
    /* PDRAWITEMSTRUCT */
    TEST_TYPE_SIZE   (PDRAWITEMSTRUCT, 8)
    TEST_TYPE_ALIGN  (PDRAWITEMSTRUCT, 8)
    TEST_TARGET_SIZE (PDRAWITEMSTRUCT, 64)
    TEST_TARGET_ALIGN(PDRAWITEMSTRUCT, 8)
}

static void test_pack_PEVENTMSG(void)
{
    /* PEVENTMSG */
    TEST_TYPE_SIZE   (PEVENTMSG, 8)
    TEST_TYPE_ALIGN  (PEVENTMSG, 8)
    TEST_TARGET_SIZE (PEVENTMSG, 24)
    TEST_TARGET_ALIGN(PEVENTMSG, 8)
}

static void test_pack_PFLASHWINFO(void)
{
    /* PFLASHWINFO */
    TEST_TYPE_SIZE   (PFLASHWINFO, 8)
    TEST_TYPE_ALIGN  (PFLASHWINFO, 8)
    TEST_TARGET_SIZE (PFLASHWINFO, 32)
    TEST_TARGET_ALIGN(PFLASHWINFO, 8)
}

static void test_pack_PGUITHREADINFO(void)
{
    /* PGUITHREADINFO */
    TEST_TYPE_SIZE   (PGUITHREADINFO, 8)
    TEST_TYPE_ALIGN  (PGUITHREADINFO, 8)
    TEST_TARGET_SIZE (PGUITHREADINFO, 72)
    TEST_TARGET_ALIGN(PGUITHREADINFO, 8)
}

static void test_pack_PHARDWAREHOOKSTRUCT(void)
{
    /* PHARDWAREHOOKSTRUCT */
    TEST_TYPE_SIZE   (PHARDWAREHOOKSTRUCT, 8)
    TEST_TYPE_ALIGN  (PHARDWAREHOOKSTRUCT, 8)
    TEST_TARGET_SIZE (PHARDWAREHOOKSTRUCT, 32)
    TEST_TARGET_ALIGN(PHARDWAREHOOKSTRUCT, 8)
}

static void test_pack_PHARDWAREINPUT(void)
{
    /* PHARDWAREINPUT */
    TEST_TYPE_SIZE   (PHARDWAREINPUT, 8)
    TEST_TYPE_ALIGN  (PHARDWAREINPUT, 8)
    TEST_TARGET_SIZE (PHARDWAREINPUT, 8)
    TEST_TARGET_ALIGN(PHARDWAREINPUT, 4)
}

static void test_pack_PHDEVNOTIFY(void)
{
    /* PHDEVNOTIFY */
    TEST_TYPE_SIZE   (PHDEVNOTIFY, 8)
    TEST_TYPE_ALIGN  (PHDEVNOTIFY, 8)
    TEST_TARGET_SIZE (PHDEVNOTIFY, 8)
    TEST_TARGET_ALIGN(PHDEVNOTIFY, 8)
}

static void test_pack_PHELPWININFOA(void)
{
    /* PHELPWININFOA */
    TEST_TYPE_SIZE   (PHELPWININFOA, 8)
    TEST_TYPE_ALIGN  (PHELPWININFOA, 8)
    TEST_TARGET_SIZE (PHELPWININFOA, 28)
    TEST_TARGET_ALIGN(PHELPWININFOA, 4)
}

static void test_pack_PHELPWININFOW(void)
{
    /* PHELPWININFOW */
    TEST_TYPE_SIZE   (PHELPWININFOW, 8)
    TEST_TYPE_ALIGN  (PHELPWININFOW, 8)
    TEST_TARGET_SIZE (PHELPWININFOW, 28)
    TEST_TARGET_ALIGN(PHELPWININFOW, 4)
}

static void test_pack_PICONINFO(void)
{
    /* PICONINFO */
    TEST_TYPE_SIZE   (PICONINFO, 8)
    TEST_TYPE_ALIGN  (PICONINFO, 8)
    TEST_TARGET_SIZE (PICONINFO, 32)
    TEST_TARGET_ALIGN(PICONINFO, 8)
}

static void test_pack_PICONMETRICSA(void)
{
    /* PICONMETRICSA */
    TEST_TYPE_SIZE   (PICONMETRICSA, 8)
    TEST_TYPE_ALIGN  (PICONMETRICSA, 8)
    TEST_TARGET_SIZE (PICONMETRICSA, 76)
    TEST_TARGET_ALIGN(PICONMETRICSA, 4)
}

static void test_pack_PICONMETRICSW(void)
{
    /* PICONMETRICSW */
    TEST_TYPE_SIZE   (PICONMETRICSW, 8)
    TEST_TYPE_ALIGN  (PICONMETRICSW, 8)
    TEST_TARGET_SIZE (PICONMETRICSW, 108)
    TEST_TARGET_ALIGN(PICONMETRICSW, 4)
}

static void test_pack_PINPUT(void)
{
    /* PINPUT */
    TEST_TYPE_SIZE   (PINPUT, 8)
    TEST_TYPE_ALIGN  (PINPUT, 8)
}

static void test_pack_PKBDLLHOOKSTRUCT(void)
{
    /* PKBDLLHOOKSTRUCT */
    TEST_TYPE_SIZE   (PKBDLLHOOKSTRUCT, 8)
    TEST_TYPE_ALIGN  (PKBDLLHOOKSTRUCT, 8)
    TEST_TARGET_SIZE (PKBDLLHOOKSTRUCT, 24)
    TEST_TARGET_ALIGN(PKBDLLHOOKSTRUCT, 8)
}

static void test_pack_PKEYBDINPUT(void)
{
    /* PKEYBDINPUT */
    TEST_TYPE_SIZE   (PKEYBDINPUT, 8)
    TEST_TYPE_ALIGN  (PKEYBDINPUT, 8)
    TEST_TARGET_SIZE (PKEYBDINPUT, 24)
    TEST_TARGET_ALIGN(PKEYBDINPUT, 8)
}

static void test_pack_PMDINEXTMENU(void)
{
    /* PMDINEXTMENU */
    TEST_TYPE_SIZE   (PMDINEXTMENU, 8)
    TEST_TYPE_ALIGN  (PMDINEXTMENU, 8)
    TEST_TARGET_SIZE (PMDINEXTMENU, 24)
    TEST_TARGET_ALIGN(PMDINEXTMENU, 8)
}

static void test_pack_PMEASUREITEMSTRUCT(void)
{
    /* PMEASUREITEMSTRUCT */
    TEST_TYPE_SIZE   (PMEASUREITEMSTRUCT, 8)
    TEST_TYPE_ALIGN  (PMEASUREITEMSTRUCT, 8)
    TEST_TARGET_SIZE (PMEASUREITEMSTRUCT, 32)
    TEST_TARGET_ALIGN(PMEASUREITEMSTRUCT, 8)
}

static void test_pack_PMENUITEMTEMPLATE(void)
{
    /* PMENUITEMTEMPLATE */
    TEST_TYPE_SIZE   (PMENUITEMTEMPLATE, 8)
    TEST_TYPE_ALIGN  (PMENUITEMTEMPLATE, 8)
    TEST_TARGET_SIZE (PMENUITEMTEMPLATE, 6)
    TEST_TARGET_ALIGN(PMENUITEMTEMPLATE, 2)
}

static void test_pack_PMENUITEMTEMPLATEHEADER(void)
{
    /* PMENUITEMTEMPLATEHEADER */
    TEST_TYPE_SIZE   (PMENUITEMTEMPLATEHEADER, 8)
    TEST_TYPE_ALIGN  (PMENUITEMTEMPLATEHEADER, 8)
    TEST_TARGET_SIZE (PMENUITEMTEMPLATEHEADER, 4)
    TEST_TARGET_ALIGN(PMENUITEMTEMPLATEHEADER, 2)
}

static void test_pack_PMINIMIZEDMETRICS(void)
{
    /* PMINIMIZEDMETRICS */
    TEST_TYPE_SIZE   (PMINIMIZEDMETRICS, 8)
    TEST_TYPE_ALIGN  (PMINIMIZEDMETRICS, 8)
    TEST_TARGET_SIZE (PMINIMIZEDMETRICS, 20)
    TEST_TARGET_ALIGN(PMINIMIZEDMETRICS, 4)
}

static void test_pack_PMINMAXINFO(void)
{
    /* PMINMAXINFO */
    TEST_TYPE_SIZE   (PMINMAXINFO, 8)
    TEST_TYPE_ALIGN  (PMINMAXINFO, 8)
    TEST_TARGET_SIZE (PMINMAXINFO, 40)
    TEST_TARGET_ALIGN(PMINMAXINFO, 4)
}

static void test_pack_PMOUSEHOOKSTRUCT(void)
{
    /* PMOUSEHOOKSTRUCT */
    TEST_TYPE_SIZE   (PMOUSEHOOKSTRUCT, 8)
    TEST_TYPE_ALIGN  (PMOUSEHOOKSTRUCT, 8)
    TEST_TARGET_SIZE (PMOUSEHOOKSTRUCT, 32)
    TEST_TARGET_ALIGN(PMOUSEHOOKSTRUCT, 8)
}

static void test_pack_PMOUSEINPUT(void)
{
    /* PMOUSEINPUT */
    TEST_TYPE_SIZE   (PMOUSEINPUT, 8)
    TEST_TYPE_ALIGN  (PMOUSEINPUT, 8)
    TEST_TARGET_SIZE (PMOUSEINPUT, 32)
    TEST_TARGET_ALIGN(PMOUSEINPUT, 8)
}

static void test_pack_PMSG(void)
{
    /* PMSG */
    TEST_TYPE_SIZE   (PMSG, 8)
    TEST_TYPE_ALIGN  (PMSG, 8)
    TEST_TARGET_SIZE (PMSG, 48)
    TEST_TARGET_ALIGN(PMSG, 8)
}

static void test_pack_PMSGBOXPARAMSA(void)
{
    /* PMSGBOXPARAMSA */
    TEST_TYPE_SIZE   (PMSGBOXPARAMSA, 8)
    TEST_TYPE_ALIGN  (PMSGBOXPARAMSA, 8)
    TEST_TARGET_SIZE (PMSGBOXPARAMSA, 80)
    TEST_TARGET_ALIGN(PMSGBOXPARAMSA, 8)
}

static void test_pack_PMSGBOXPARAMSW(void)
{
    /* PMSGBOXPARAMSW */
    TEST_TYPE_SIZE   (PMSGBOXPARAMSW, 8)
    TEST_TYPE_ALIGN  (PMSGBOXPARAMSW, 8)
    TEST_TARGET_SIZE (PMSGBOXPARAMSW, 80)
    TEST_TARGET_ALIGN(PMSGBOXPARAMSW, 8)
}

static void test_pack_PMSLLHOOKSTRUCT(void)
{
    /* PMSLLHOOKSTRUCT */
    TEST_TYPE_SIZE   (PMSLLHOOKSTRUCT, 8)
    TEST_TYPE_ALIGN  (PMSLLHOOKSTRUCT, 8)
    TEST_TARGET_SIZE (PMSLLHOOKSTRUCT, 32)
    TEST_TARGET_ALIGN(PMSLLHOOKSTRUCT, 8)
}

static void test_pack_PMULTIKEYHELPA(void)
{
    /* PMULTIKEYHELPA */
    TEST_TYPE_SIZE   (PMULTIKEYHELPA, 8)
    TEST_TYPE_ALIGN  (PMULTIKEYHELPA, 8)
    TEST_TARGET_SIZE (PMULTIKEYHELPA, 8)
    TEST_TARGET_ALIGN(PMULTIKEYHELPA, 4)
}

static void test_pack_PMULTIKEYHELPW(void)
{
    /* PMULTIKEYHELPW */
    TEST_TYPE_SIZE   (PMULTIKEYHELPW, 8)
    TEST_TYPE_ALIGN  (PMULTIKEYHELPW, 8)
    TEST_TARGET_SIZE (PMULTIKEYHELPW, 8)
    TEST_TARGET_ALIGN(PMULTIKEYHELPW, 4)
}

static void test_pack_PNONCLIENTMETRICSA(void)
{
    /* PNONCLIENTMETRICSA */
    TEST_TYPE_SIZE   (PNONCLIENTMETRICSA, 8)
    TEST_TYPE_ALIGN  (PNONCLIENTMETRICSA, 8)
    TEST_TARGET_SIZE (PNONCLIENTMETRICSA, 340)
    TEST_TARGET_ALIGN(PNONCLIENTMETRICSA, 4)
}

static void test_pack_PNONCLIENTMETRICSW(void)
{
    /* PNONCLIENTMETRICSW */
    TEST_TYPE_SIZE   (PNONCLIENTMETRICSW, 8)
    TEST_TYPE_ALIGN  (PNONCLIENTMETRICSW, 8)
    TEST_TARGET_SIZE (PNONCLIENTMETRICSW, 500)
    TEST_TARGET_ALIGN(PNONCLIENTMETRICSW, 4)
}

static void test_pack_PPAINTSTRUCT(void)
{
    /* PPAINTSTRUCT */
    TEST_TYPE_SIZE   (PPAINTSTRUCT, 8)
    TEST_TYPE_ALIGN  (PPAINTSTRUCT, 8)
    TEST_TARGET_SIZE (PPAINTSTRUCT, 72)
    TEST_TARGET_ALIGN(PPAINTSTRUCT, 8)
}

static void test_pack_PROPENUMPROCA(void)
{
    /* PROPENUMPROCA */
    TEST_TYPE_SIZE   (PROPENUMPROCA, 8)
    TEST_TYPE_ALIGN  (PROPENUMPROCA, 8)
}

static void test_pack_PROPENUMPROCEXA(void)
{
    /* PROPENUMPROCEXA */
    TEST_TYPE_SIZE   (PROPENUMPROCEXA, 8)
    TEST_TYPE_ALIGN  (PROPENUMPROCEXA, 8)
}

static void test_pack_PROPENUMPROCEXW(void)
{
    /* PROPENUMPROCEXW */
    TEST_TYPE_SIZE   (PROPENUMPROCEXW, 8)
    TEST_TYPE_ALIGN  (PROPENUMPROCEXW, 8)
}

static void test_pack_PROPENUMPROCW(void)
{
    /* PROPENUMPROCW */
    TEST_TYPE_SIZE   (PROPENUMPROCW, 8)
    TEST_TYPE_ALIGN  (PROPENUMPROCW, 8)
}

static void test_pack_PTITLEBARINFO(void)
{
    /* PTITLEBARINFO */
    TEST_TYPE_SIZE   (PTITLEBARINFO, 8)
    TEST_TYPE_ALIGN  (PTITLEBARINFO, 8)
    TEST_TARGET_SIZE (PTITLEBARINFO, 44)
    TEST_TARGET_ALIGN(PTITLEBARINFO, 4)
}

static void test_pack_PUSEROBJECTFLAGS(void)
{
    /* PUSEROBJECTFLAGS */
    TEST_TYPE_SIZE   (PUSEROBJECTFLAGS, 8)
    TEST_TYPE_ALIGN  (PUSEROBJECTFLAGS, 8)
    TEST_TARGET_SIZE (PUSEROBJECTFLAGS, 12)
    TEST_TARGET_ALIGN(PUSEROBJECTFLAGS, 4)
}

static void test_pack_PWINDOWINFO(void)
{
    /* PWINDOWINFO */
    TEST_TYPE_SIZE   (PWINDOWINFO, 8)
    TEST_TYPE_ALIGN  (PWINDOWINFO, 8)
    TEST_TARGET_SIZE (PWINDOWINFO, 60)
    TEST_TARGET_ALIGN(PWINDOWINFO, 4)
}

static void test_pack_PWINDOWPLACEMENT(void)
{
    /* PWINDOWPLACEMENT */
    TEST_TYPE_SIZE   (PWINDOWPLACEMENT, 8)
    TEST_TYPE_ALIGN  (PWINDOWPLACEMENT, 8)
    TEST_TARGET_SIZE (PWINDOWPLACEMENT, 44)
    TEST_TARGET_ALIGN(PWINDOWPLACEMENT, 4)
}

static void test_pack_PWINDOWPOS(void)
{
    /* PWINDOWPOS */
    TEST_TYPE_SIZE   (PWINDOWPOS, 8)
    TEST_TYPE_ALIGN  (PWINDOWPOS, 8)
    TEST_TARGET_SIZE (PWINDOWPOS, 40)
    TEST_TARGET_ALIGN(PWINDOWPOS, 8)
}

static void test_pack_PWNDCLASSA(void)
{
    /* PWNDCLASSA */
    TEST_TYPE_SIZE   (PWNDCLASSA, 8)
    TEST_TYPE_ALIGN  (PWNDCLASSA, 8)
    TEST_TARGET_SIZE (PWNDCLASSA, 72)
    TEST_TARGET_ALIGN(PWNDCLASSA, 8)
}

static void test_pack_PWNDCLASSEXA(void)
{
    /* PWNDCLASSEXA */
    TEST_TYPE_SIZE   (PWNDCLASSEXA, 8)
    TEST_TYPE_ALIGN  (PWNDCLASSEXA, 8)
    TEST_TARGET_SIZE (PWNDCLASSEXA, 80)
    TEST_TARGET_ALIGN(PWNDCLASSEXA, 8)
}

static void test_pack_PWNDCLASSEXW(void)
{
    /* PWNDCLASSEXW */
    TEST_TYPE_SIZE   (PWNDCLASSEXW, 8)
    TEST_TYPE_ALIGN  (PWNDCLASSEXW, 8)
    TEST_TARGET_SIZE (PWNDCLASSEXW, 80)
    TEST_TARGET_ALIGN(PWNDCLASSEXW, 8)
}

static void test_pack_PWNDCLASSW(void)
{
    /* PWNDCLASSW */
    TEST_TYPE_SIZE   (PWNDCLASSW, 8)
    TEST_TYPE_ALIGN  (PWNDCLASSW, 8)
    TEST_TARGET_SIZE (PWNDCLASSW, 72)
    TEST_TARGET_ALIGN(PWNDCLASSW, 8)
}

static void test_pack_SCROLLINFO(void)
{
    /* SCROLLINFO */
    TEST_TYPE_SIZE   (SCROLLINFO, 28)
    TEST_TYPE_ALIGN  (SCROLLINFO, 4)
    TEST_FIELD_SIZE  (SCROLLINFO, cbSize, 4)
    TEST_FIELD_ALIGN (SCROLLINFO, cbSize, 4)
    TEST_FIELD_OFFSET(SCROLLINFO, cbSize, 0)
    TEST_FIELD_SIZE  (SCROLLINFO, fMask, 4)
    TEST_FIELD_ALIGN (SCROLLINFO, fMask, 4)
    TEST_FIELD_OFFSET(SCROLLINFO, fMask, 4)
    TEST_FIELD_SIZE  (SCROLLINFO, nMin, 4)
    TEST_FIELD_ALIGN (SCROLLINFO, nMin, 4)
    TEST_FIELD_OFFSET(SCROLLINFO, nMin, 8)
    TEST_FIELD_SIZE  (SCROLLINFO, nMax, 4)
    TEST_FIELD_ALIGN (SCROLLINFO, nMax, 4)
    TEST_FIELD_OFFSET(SCROLLINFO, nMax, 12)
    TEST_FIELD_SIZE  (SCROLLINFO, nPage, 4)
    TEST_FIELD_ALIGN (SCROLLINFO, nPage, 4)
    TEST_FIELD_OFFSET(SCROLLINFO, nPage, 16)
    TEST_FIELD_SIZE  (SCROLLINFO, nPos, 4)
    TEST_FIELD_ALIGN (SCROLLINFO, nPos, 4)
    TEST_FIELD_OFFSET(SCROLLINFO, nPos, 20)
    TEST_FIELD_SIZE  (SCROLLINFO, nTrackPos, 4)
    TEST_FIELD_ALIGN (SCROLLINFO, nTrackPos, 4)
    TEST_FIELD_OFFSET(SCROLLINFO, nTrackPos, 24)
}

static void test_pack_SENDASYNCPROC(void)
{
    /* SENDASYNCPROC */
    TEST_TYPE_SIZE   (SENDASYNCPROC, 8)
    TEST_TYPE_ALIGN  (SENDASYNCPROC, 8)
}

static void test_pack_SERIALKEYSA(void)
{
    /* SERIALKEYSA */
    TEST_TYPE_SIZE   (SERIALKEYSA, 40)
    TEST_TYPE_ALIGN  (SERIALKEYSA, 8)
    TEST_FIELD_SIZE  (SERIALKEYSA, cbSize, 4)
    TEST_FIELD_ALIGN (SERIALKEYSA, cbSize, 4)
    TEST_FIELD_OFFSET(SERIALKEYSA, cbSize, 0)
    TEST_FIELD_SIZE  (SERIALKEYSA, dwFlags, 4)
    TEST_FIELD_ALIGN (SERIALKEYSA, dwFlags, 4)
    TEST_FIELD_OFFSET(SERIALKEYSA, dwFlags, 4)
    TEST_FIELD_SIZE  (SERIALKEYSA, lpszActivePort, 8)
    TEST_FIELD_ALIGN (SERIALKEYSA, lpszActivePort, 8)
    TEST_FIELD_OFFSET(SERIALKEYSA, lpszActivePort, 8)
    TEST_FIELD_SIZE  (SERIALKEYSA, lpszPort, 8)
    TEST_FIELD_ALIGN (SERIALKEYSA, lpszPort, 8)
    TEST_FIELD_OFFSET(SERIALKEYSA, lpszPort, 16)
    TEST_FIELD_SIZE  (SERIALKEYSA, iBaudRate, 4)
    TEST_FIELD_ALIGN (SERIALKEYSA, iBaudRate, 4)
    TEST_FIELD_OFFSET(SERIALKEYSA, iBaudRate, 24)
    TEST_FIELD_SIZE  (SERIALKEYSA, iPortState, 4)
    TEST_FIELD_ALIGN (SERIALKEYSA, iPortState, 4)
    TEST_FIELD_OFFSET(SERIALKEYSA, iPortState, 28)
    TEST_FIELD_SIZE  (SERIALKEYSA, iActive, 4)
    TEST_FIELD_ALIGN (SERIALKEYSA, iActive, 4)
    TEST_FIELD_OFFSET(SERIALKEYSA, iActive, 32)
}

static void test_pack_SERIALKEYSW(void)
{
    /* SERIALKEYSW */
    TEST_TYPE_SIZE   (SERIALKEYSW, 40)
    TEST_TYPE_ALIGN  (SERIALKEYSW, 8)
    TEST_FIELD_SIZE  (SERIALKEYSW, cbSize, 4)
    TEST_FIELD_ALIGN (SERIALKEYSW, cbSize, 4)
    TEST_FIELD_OFFSET(SERIALKEYSW, cbSize, 0)
    TEST_FIELD_SIZE  (SERIALKEYSW, dwFlags, 4)
    TEST_FIELD_ALIGN (SERIALKEYSW, dwFlags, 4)
    TEST_FIELD_OFFSET(SERIALKEYSW, dwFlags, 4)
    TEST_FIELD_SIZE  (SERIALKEYSW, lpszActivePort, 8)
    TEST_FIELD_ALIGN (SERIALKEYSW, lpszActivePort, 8)
    TEST_FIELD_OFFSET(SERIALKEYSW, lpszActivePort, 8)
    TEST_FIELD_SIZE  (SERIALKEYSW, lpszPort, 8)
    TEST_FIELD_ALIGN (SERIALKEYSW, lpszPort, 8)
    TEST_FIELD_OFFSET(SERIALKEYSW, lpszPort, 16)
    TEST_FIELD_SIZE  (SERIALKEYSW, iBaudRate, 4)
    TEST_FIELD_ALIGN (SERIALKEYSW, iBaudRate, 4)
    TEST_FIELD_OFFSET(SERIALKEYSW, iBaudRate, 24)
    TEST_FIELD_SIZE  (SERIALKEYSW, iPortState, 4)
    TEST_FIELD_ALIGN (SERIALKEYSW, iPortState, 4)
    TEST_FIELD_OFFSET(SERIALKEYSW, iPortState, 28)
    TEST_FIELD_SIZE  (SERIALKEYSW, iActive, 4)
    TEST_FIELD_ALIGN (SERIALKEYSW, iActive, 4)
    TEST_FIELD_OFFSET(SERIALKEYSW, iActive, 32)
}

static void test_pack_SOUNDSENTRYA(void)
{
    /* SOUNDSENTRYA */
    TEST_TYPE_SIZE   (SOUNDSENTRYA, 56)
    TEST_TYPE_ALIGN  (SOUNDSENTRYA, 8)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, cbSize, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, cbSize, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, cbSize, 0)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, dwFlags, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, dwFlags, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, dwFlags, 4)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, iFSTextEffect, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, iFSTextEffect, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, iFSTextEffect, 8)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, iFSTextEffectMSec, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, iFSTextEffectMSec, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, iFSTextEffectMSec, 12)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, iFSTextEffectColorBits, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, iFSTextEffectColorBits, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, iFSTextEffectColorBits, 16)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, iFSGrafEffect, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, iFSGrafEffect, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, iFSGrafEffect, 20)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, iFSGrafEffectMSec, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, iFSGrafEffectMSec, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, iFSGrafEffectMSec, 24)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, iFSGrafEffectColor, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, iFSGrafEffectColor, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, iFSGrafEffectColor, 28)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, iWindowsEffect, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, iWindowsEffect, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, iWindowsEffect, 32)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, iWindowsEffectMSec, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, iWindowsEffectMSec, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, iWindowsEffectMSec, 36)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, lpszWindowsEffectDLL, 8)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, lpszWindowsEffectDLL, 8)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, lpszWindowsEffectDLL, 40)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, iWindowsEffectOrdinal, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, iWindowsEffectOrdinal, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, iWindowsEffectOrdinal, 48)
}

static void test_pack_SOUNDSENTRYW(void)
{
    /* SOUNDSENTRYW */
    TEST_TYPE_SIZE   (SOUNDSENTRYW, 56)
    TEST_TYPE_ALIGN  (SOUNDSENTRYW, 8)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, cbSize, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, cbSize, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, cbSize, 0)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, dwFlags, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, dwFlags, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, dwFlags, 4)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, iFSTextEffect, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, iFSTextEffect, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, iFSTextEffect, 8)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, iFSTextEffectMSec, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, iFSTextEffectMSec, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, iFSTextEffectMSec, 12)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, iFSTextEffectColorBits, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, iFSTextEffectColorBits, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, iFSTextEffectColorBits, 16)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, iFSGrafEffect, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, iFSGrafEffect, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, iFSGrafEffect, 20)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, iFSGrafEffectMSec, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, iFSGrafEffectMSec, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, iFSGrafEffectMSec, 24)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, iFSGrafEffectColor, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, iFSGrafEffectColor, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, iFSGrafEffectColor, 28)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, iWindowsEffect, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, iWindowsEffect, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, iWindowsEffect, 32)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, iWindowsEffectMSec, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, iWindowsEffectMSec, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, iWindowsEffectMSec, 36)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, lpszWindowsEffectDLL, 8)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, lpszWindowsEffectDLL, 8)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, lpszWindowsEffectDLL, 40)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, iWindowsEffectOrdinal, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, iWindowsEffectOrdinal, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, iWindowsEffectOrdinal, 48)
}

static void test_pack_STICKYKEYS(void)
{
    /* STICKYKEYS */
    TEST_TYPE_SIZE   (STICKYKEYS, 8)
    TEST_TYPE_ALIGN  (STICKYKEYS, 4)
    TEST_FIELD_SIZE  (STICKYKEYS, cbSize, 4)
    TEST_FIELD_ALIGN (STICKYKEYS, cbSize, 4)
    TEST_FIELD_OFFSET(STICKYKEYS, cbSize, 0)
    TEST_FIELD_SIZE  (STICKYKEYS, dwFlags, 4)
    TEST_FIELD_ALIGN (STICKYKEYS, dwFlags, 4)
    TEST_FIELD_OFFSET(STICKYKEYS, dwFlags, 4)
}

static void test_pack_STYLESTRUCT(void)
{
    /* STYLESTRUCT */
    TEST_TYPE_SIZE   (STYLESTRUCT, 8)
    TEST_TYPE_ALIGN  (STYLESTRUCT, 4)
    TEST_FIELD_SIZE  (STYLESTRUCT, styleOld, 4)
    TEST_FIELD_ALIGN (STYLESTRUCT, styleOld, 4)
    TEST_FIELD_OFFSET(STYLESTRUCT, styleOld, 0)
    TEST_FIELD_SIZE  (STYLESTRUCT, styleNew, 4)
    TEST_FIELD_ALIGN (STYLESTRUCT, styleNew, 4)
    TEST_FIELD_OFFSET(STYLESTRUCT, styleNew, 4)
}

static void test_pack_TIMERPROC(void)
{
    /* TIMERPROC */
    TEST_TYPE_SIZE   (TIMERPROC, 8)
    TEST_TYPE_ALIGN  (TIMERPROC, 8)
}

static void test_pack_TITLEBARINFO(void)
{
    /* TITLEBARINFO */
    TEST_TYPE_SIZE   (TITLEBARINFO, 44)
    TEST_TYPE_ALIGN  (TITLEBARINFO, 4)
    TEST_FIELD_SIZE  (TITLEBARINFO, cbSize, 4)
    TEST_FIELD_ALIGN (TITLEBARINFO, cbSize, 4)
    TEST_FIELD_OFFSET(TITLEBARINFO, cbSize, 0)
    TEST_FIELD_SIZE  (TITLEBARINFO, rcTitleBar, 16)
    TEST_FIELD_ALIGN (TITLEBARINFO, rcTitleBar, 4)
    TEST_FIELD_OFFSET(TITLEBARINFO, rcTitleBar, 4)
    TEST_FIELD_SIZE  (TITLEBARINFO, rgstate, 24)
    TEST_FIELD_ALIGN (TITLEBARINFO, rgstate, 4)
    TEST_FIELD_OFFSET(TITLEBARINFO, rgstate, 20)
}

static void test_pack_TOGGLEKEYS(void)
{
    /* TOGGLEKEYS */
    TEST_TYPE_SIZE   (TOGGLEKEYS, 8)
    TEST_TYPE_ALIGN  (TOGGLEKEYS, 4)
    TEST_FIELD_SIZE  (TOGGLEKEYS, cbSize, 4)
    TEST_FIELD_ALIGN (TOGGLEKEYS, cbSize, 4)
    TEST_FIELD_OFFSET(TOGGLEKEYS, cbSize, 0)
    TEST_FIELD_SIZE  (TOGGLEKEYS, dwFlags, 4)
    TEST_FIELD_ALIGN (TOGGLEKEYS, dwFlags, 4)
    TEST_FIELD_OFFSET(TOGGLEKEYS, dwFlags, 4)
}

static void test_pack_TPMPARAMS(void)
{
    /* TPMPARAMS */
    TEST_TYPE_SIZE   (TPMPARAMS, 20)
    TEST_TYPE_ALIGN  (TPMPARAMS, 4)
    TEST_FIELD_SIZE  (TPMPARAMS, cbSize, 4)
    TEST_FIELD_ALIGN (TPMPARAMS, cbSize, 4)
    TEST_FIELD_OFFSET(TPMPARAMS, cbSize, 0)
    TEST_FIELD_SIZE  (TPMPARAMS, rcExclude, 16)
    TEST_FIELD_ALIGN (TPMPARAMS, rcExclude, 4)
    TEST_FIELD_OFFSET(TPMPARAMS, rcExclude, 4)
}

static void test_pack_TRACKMOUSEEVENT(void)
{
    /* TRACKMOUSEEVENT */
    TEST_TYPE_SIZE   (TRACKMOUSEEVENT, 24)
    TEST_TYPE_ALIGN  (TRACKMOUSEEVENT, 8)
    TEST_FIELD_SIZE  (TRACKMOUSEEVENT, cbSize, 4)
    TEST_FIELD_ALIGN (TRACKMOUSEEVENT, cbSize, 4)
    TEST_FIELD_OFFSET(TRACKMOUSEEVENT, cbSize, 0)
    TEST_FIELD_SIZE  (TRACKMOUSEEVENT, dwFlags, 4)
    TEST_FIELD_ALIGN (TRACKMOUSEEVENT, dwFlags, 4)
    TEST_FIELD_OFFSET(TRACKMOUSEEVENT, dwFlags, 4)
    TEST_FIELD_SIZE  (TRACKMOUSEEVENT, hwndTrack, 8)
    TEST_FIELD_ALIGN (TRACKMOUSEEVENT, hwndTrack, 8)
    TEST_FIELD_OFFSET(TRACKMOUSEEVENT, hwndTrack, 8)
    TEST_FIELD_SIZE  (TRACKMOUSEEVENT, dwHoverTime, 4)
    TEST_FIELD_ALIGN (TRACKMOUSEEVENT, dwHoverTime, 4)
    TEST_FIELD_OFFSET(TRACKMOUSEEVENT, dwHoverTime, 16)
}

static void test_pack_USEROBJECTFLAGS(void)
{
    /* USEROBJECTFLAGS */
    TEST_TYPE_SIZE   (USEROBJECTFLAGS, 12)
    TEST_TYPE_ALIGN  (USEROBJECTFLAGS, 4)
    TEST_FIELD_SIZE  (USEROBJECTFLAGS, fInherit, 4)
    TEST_FIELD_ALIGN (USEROBJECTFLAGS, fInherit, 4)
    TEST_FIELD_OFFSET(USEROBJECTFLAGS, fInherit, 0)
    TEST_FIELD_SIZE  (USEROBJECTFLAGS, fReserved, 4)
    TEST_FIELD_ALIGN (USEROBJECTFLAGS, fReserved, 4)
    TEST_FIELD_OFFSET(USEROBJECTFLAGS, fReserved, 4)
    TEST_FIELD_SIZE  (USEROBJECTFLAGS, dwFlags, 4)
    TEST_FIELD_ALIGN (USEROBJECTFLAGS, dwFlags, 4)
    TEST_FIELD_OFFSET(USEROBJECTFLAGS, dwFlags, 8)
}

static void test_pack_WINDOWINFO(void)
{
    /* WINDOWINFO */
    TEST_TYPE_SIZE   (WINDOWINFO, 60)
    TEST_TYPE_ALIGN  (WINDOWINFO, 4)
    TEST_FIELD_SIZE  (WINDOWINFO, cbSize, 4)
    TEST_FIELD_ALIGN (WINDOWINFO, cbSize, 4)
    TEST_FIELD_OFFSET(WINDOWINFO, cbSize, 0)
    TEST_FIELD_SIZE  (WINDOWINFO, rcWindow, 16)
    TEST_FIELD_ALIGN (WINDOWINFO, rcWindow, 4)
    TEST_FIELD_OFFSET(WINDOWINFO, rcWindow, 4)
    TEST_FIELD_SIZE  (WINDOWINFO, rcClient, 16)
    TEST_FIELD_ALIGN (WINDOWINFO, rcClient, 4)
    TEST_FIELD_OFFSET(WINDOWINFO, rcClient, 20)
    TEST_FIELD_SIZE  (WINDOWINFO, dwStyle, 4)
    TEST_FIELD_ALIGN (WINDOWINFO, dwStyle, 4)
    TEST_FIELD_OFFSET(WINDOWINFO, dwStyle, 36)
    TEST_FIELD_SIZE  (WINDOWINFO, dwExStyle, 4)
    TEST_FIELD_ALIGN (WINDOWINFO, dwExStyle, 4)
    TEST_FIELD_OFFSET(WINDOWINFO, dwExStyle, 40)
    TEST_FIELD_SIZE  (WINDOWINFO, dwWindowStatus, 4)
    TEST_FIELD_ALIGN (WINDOWINFO, dwWindowStatus, 4)
    TEST_FIELD_OFFSET(WINDOWINFO, dwWindowStatus, 44)
    TEST_FIELD_SIZE  (WINDOWINFO, cxWindowBorders, 4)
    TEST_FIELD_ALIGN (WINDOWINFO, cxWindowBorders, 4)
    TEST_FIELD_OFFSET(WINDOWINFO, cxWindowBorders, 48)
    TEST_FIELD_SIZE  (WINDOWINFO, cyWindowBorders, 4)
    TEST_FIELD_ALIGN (WINDOWINFO, cyWindowBorders, 4)
    TEST_FIELD_OFFSET(WINDOWINFO, cyWindowBorders, 52)
    TEST_FIELD_SIZE  (WINDOWINFO, atomWindowType, 2)
    TEST_FIELD_ALIGN (WINDOWINFO, atomWindowType, 2)
    TEST_FIELD_OFFSET(WINDOWINFO, atomWindowType, 56)
    TEST_FIELD_SIZE  (WINDOWINFO, wCreatorVersion, 2)
    TEST_FIELD_ALIGN (WINDOWINFO, wCreatorVersion, 2)
    TEST_FIELD_OFFSET(WINDOWINFO, wCreatorVersion, 58)
}

static void test_pack_WINDOWPLACEMENT(void)
{
    /* WINDOWPLACEMENT */
    TEST_TYPE_SIZE   (WINDOWPLACEMENT, 44)
    TEST_TYPE_ALIGN  (WINDOWPLACEMENT, 4)
    TEST_FIELD_SIZE  (WINDOWPLACEMENT, length, 4)
    TEST_FIELD_ALIGN (WINDOWPLACEMENT, length, 4)
    TEST_FIELD_OFFSET(WINDOWPLACEMENT, length, 0)
    TEST_FIELD_SIZE  (WINDOWPLACEMENT, flags, 4)
    TEST_FIELD_ALIGN (WINDOWPLACEMENT, flags, 4)
    TEST_FIELD_OFFSET(WINDOWPLACEMENT, flags, 4)
    TEST_FIELD_SIZE  (WINDOWPLACEMENT, showCmd, 4)
    TEST_FIELD_ALIGN (WINDOWPLACEMENT, showCmd, 4)
    TEST_FIELD_OFFSET(WINDOWPLACEMENT, showCmd, 8)
    TEST_FIELD_SIZE  (WINDOWPLACEMENT, ptMinPosition, 8)
    TEST_FIELD_ALIGN (WINDOWPLACEMENT, ptMinPosition, 4)
    TEST_FIELD_OFFSET(WINDOWPLACEMENT, ptMinPosition, 12)
    TEST_FIELD_SIZE  (WINDOWPLACEMENT, ptMaxPosition, 8)
    TEST_FIELD_ALIGN (WINDOWPLACEMENT, ptMaxPosition, 4)
    TEST_FIELD_OFFSET(WINDOWPLACEMENT, ptMaxPosition, 20)
    TEST_FIELD_SIZE  (WINDOWPLACEMENT, rcNormalPosition, 16)
    TEST_FIELD_ALIGN (WINDOWPLACEMENT, rcNormalPosition, 4)
    TEST_FIELD_OFFSET(WINDOWPLACEMENT, rcNormalPosition, 28)
}

static void test_pack_WINDOWPOS(void)
{
    /* WINDOWPOS */
    TEST_TYPE_SIZE   (WINDOWPOS, 40)
    TEST_TYPE_ALIGN  (WINDOWPOS, 8)
    TEST_FIELD_SIZE  (WINDOWPOS, hwnd, 8)
    TEST_FIELD_ALIGN (WINDOWPOS, hwnd, 8)
    TEST_FIELD_OFFSET(WINDOWPOS, hwnd, 0)
    TEST_FIELD_SIZE  (WINDOWPOS, hwndInsertAfter, 8)
    TEST_FIELD_ALIGN (WINDOWPOS, hwndInsertAfter, 8)
    TEST_FIELD_OFFSET(WINDOWPOS, hwndInsertAfter, 8)
    TEST_FIELD_SIZE  (WINDOWPOS, x, 4)
    TEST_FIELD_ALIGN (WINDOWPOS, x, 4)
    TEST_FIELD_OFFSET(WINDOWPOS, x, 16)
    TEST_FIELD_SIZE  (WINDOWPOS, y, 4)
    TEST_FIELD_ALIGN (WINDOWPOS, y, 4)
    TEST_FIELD_OFFSET(WINDOWPOS, y, 20)
    TEST_FIELD_SIZE  (WINDOWPOS, cx, 4)
    TEST_FIELD_ALIGN (WINDOWPOS, cx, 4)
    TEST_FIELD_OFFSET(WINDOWPOS, cx, 24)
    TEST_FIELD_SIZE  (WINDOWPOS, cy, 4)
    TEST_FIELD_ALIGN (WINDOWPOS, cy, 4)
    TEST_FIELD_OFFSET(WINDOWPOS, cy, 28)
    TEST_FIELD_SIZE  (WINDOWPOS, flags, 4)
    TEST_FIELD_ALIGN (WINDOWPOS, flags, 4)
    TEST_FIELD_OFFSET(WINDOWPOS, flags, 32)
}

static void test_pack_WINEVENTPROC(void)
{
    /* WINEVENTPROC */
    TEST_TYPE_SIZE   (WINEVENTPROC, 8)
    TEST_TYPE_ALIGN  (WINEVENTPROC, 8)
}

static void test_pack_WINSTAENUMPROCA(void)
{
    /* WINSTAENUMPROCA */
    TEST_TYPE_SIZE   (WINSTAENUMPROCA, 8)
    TEST_TYPE_ALIGN  (WINSTAENUMPROCA, 8)
}

static void test_pack_WINSTAENUMPROCW(void)
{
    /* WINSTAENUMPROCW */
    TEST_TYPE_SIZE   (WINSTAENUMPROCW, 8)
    TEST_TYPE_ALIGN  (WINSTAENUMPROCW, 8)
}

static void test_pack_WNDCLASSA(void)
{
    /* WNDCLASSA */
    TEST_TYPE_SIZE   (WNDCLASSA, 72)
    TEST_TYPE_ALIGN  (WNDCLASSA, 8)
    TEST_FIELD_SIZE  (WNDCLASSA, style, 4)
    TEST_FIELD_ALIGN (WNDCLASSA, style, 4)
    TEST_FIELD_OFFSET(WNDCLASSA, style, 0)
    TEST_FIELD_SIZE  (WNDCLASSA, lpfnWndProc, 8)
    TEST_FIELD_ALIGN (WNDCLASSA, lpfnWndProc, 8)
    TEST_FIELD_OFFSET(WNDCLASSA, lpfnWndProc, 8)
    TEST_FIELD_SIZE  (WNDCLASSA, cbClsExtra, 4)
    TEST_FIELD_ALIGN (WNDCLASSA, cbClsExtra, 4)
    TEST_FIELD_OFFSET(WNDCLASSA, cbClsExtra, 16)
    TEST_FIELD_SIZE  (WNDCLASSA, cbWndExtra, 4)
    TEST_FIELD_ALIGN (WNDCLASSA, cbWndExtra, 4)
    TEST_FIELD_OFFSET(WNDCLASSA, cbWndExtra, 20)
    TEST_FIELD_SIZE  (WNDCLASSA, hInstance, 8)
    TEST_FIELD_ALIGN (WNDCLASSA, hInstance, 8)
    TEST_FIELD_OFFSET(WNDCLASSA, hInstance, 24)
    TEST_FIELD_SIZE  (WNDCLASSA, hIcon, 8)
    TEST_FIELD_ALIGN (WNDCLASSA, hIcon, 8)
    TEST_FIELD_OFFSET(WNDCLASSA, hIcon, 32)
    TEST_FIELD_SIZE  (WNDCLASSA, hCursor, 8)
    TEST_FIELD_ALIGN (WNDCLASSA, hCursor, 8)
    TEST_FIELD_OFFSET(WNDCLASSA, hCursor, 40)
    TEST_FIELD_SIZE  (WNDCLASSA, hbrBackground, 8)
    TEST_FIELD_ALIGN (WNDCLASSA, hbrBackground, 8)
    TEST_FIELD_OFFSET(WNDCLASSA, hbrBackground, 48)
    TEST_FIELD_SIZE  (WNDCLASSA, lpszMenuName, 8)
    TEST_FIELD_ALIGN (WNDCLASSA, lpszMenuName, 8)
    TEST_FIELD_OFFSET(WNDCLASSA, lpszMenuName, 56)
    TEST_FIELD_SIZE  (WNDCLASSA, lpszClassName, 8)
    TEST_FIELD_ALIGN (WNDCLASSA, lpszClassName, 8)
    TEST_FIELD_OFFSET(WNDCLASSA, lpszClassName, 64)
}

static void test_pack_WNDCLASSEXA(void)
{
    /* WNDCLASSEXA */
    TEST_TYPE_SIZE   (WNDCLASSEXA, 80)
    TEST_TYPE_ALIGN  (WNDCLASSEXA, 8)
    TEST_FIELD_SIZE  (WNDCLASSEXA, cbSize, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXA, cbSize, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXA, cbSize, 0)
    TEST_FIELD_SIZE  (WNDCLASSEXA, style, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXA, style, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXA, style, 4)
    TEST_FIELD_SIZE  (WNDCLASSEXA, lpfnWndProc, 8)
    TEST_FIELD_ALIGN (WNDCLASSEXA, lpfnWndProc, 8)
    TEST_FIELD_OFFSET(WNDCLASSEXA, lpfnWndProc, 8)
    TEST_FIELD_SIZE  (WNDCLASSEXA, cbClsExtra, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXA, cbClsExtra, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXA, cbClsExtra, 16)
    TEST_FIELD_SIZE  (WNDCLASSEXA, cbWndExtra, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXA, cbWndExtra, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXA, cbWndExtra, 20)
    TEST_FIELD_SIZE  (WNDCLASSEXA, hInstance, 8)
    TEST_FIELD_ALIGN (WNDCLASSEXA, hInstance, 8)
    TEST_FIELD_OFFSET(WNDCLASSEXA, hInstance, 24)
    TEST_FIELD_SIZE  (WNDCLASSEXA, hIcon, 8)
    TEST_FIELD_ALIGN (WNDCLASSEXA, hIcon, 8)
    TEST_FIELD_OFFSET(WNDCLASSEXA, hIcon, 32)
    TEST_FIELD_SIZE  (WNDCLASSEXA, hCursor, 8)
    TEST_FIELD_ALIGN (WNDCLASSEXA, hCursor, 8)
    TEST_FIELD_OFFSET(WNDCLASSEXA, hCursor, 40)
    TEST_FIELD_SIZE  (WNDCLASSEXA, hbrBackground, 8)
    TEST_FIELD_ALIGN (WNDCLASSEXA, hbrBackground, 8)
    TEST_FIELD_OFFSET(WNDCLASSEXA, hbrBackground, 48)
    TEST_FIELD_SIZE  (WNDCLASSEXA, lpszMenuName, 8)
    TEST_FIELD_ALIGN (WNDCLASSEXA, lpszMenuName, 8)
    TEST_FIELD_OFFSET(WNDCLASSEXA, lpszMenuName, 56)
    TEST_FIELD_SIZE  (WNDCLASSEXA, lpszClassName, 8)
    TEST_FIELD_ALIGN (WNDCLASSEXA, lpszClassName, 8)
    TEST_FIELD_OFFSET(WNDCLASSEXA, lpszClassName, 64)
    TEST_FIELD_SIZE  (WNDCLASSEXA, hIconSm, 8)
    TEST_FIELD_ALIGN (WNDCLASSEXA, hIconSm, 8)
    TEST_FIELD_OFFSET(WNDCLASSEXA, hIconSm, 72)
}

static void test_pack_WNDCLASSEXW(void)
{
    /* WNDCLASSEXW */
    TEST_TYPE_SIZE   (WNDCLASSEXW, 80)
    TEST_TYPE_ALIGN  (WNDCLASSEXW, 8)
    TEST_FIELD_SIZE  (WNDCLASSEXW, cbSize, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXW, cbSize, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXW, cbSize, 0)
    TEST_FIELD_SIZE  (WNDCLASSEXW, style, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXW, style, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXW, style, 4)
    TEST_FIELD_SIZE  (WNDCLASSEXW, lpfnWndProc, 8)
    TEST_FIELD_ALIGN (WNDCLASSEXW, lpfnWndProc, 8)
    TEST_FIELD_OFFSET(WNDCLASSEXW, lpfnWndProc, 8)
    TEST_FIELD_SIZE  (WNDCLASSEXW, cbClsExtra, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXW, cbClsExtra, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXW, cbClsExtra, 16)
    TEST_FIELD_SIZE  (WNDCLASSEXW, cbWndExtra, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXW, cbWndExtra, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXW, cbWndExtra, 20)
    TEST_FIELD_SIZE  (WNDCLASSEXW, hInstance, 8)
    TEST_FIELD_ALIGN (WNDCLASSEXW, hInstance, 8)
    TEST_FIELD_OFFSET(WNDCLASSEXW, hInstance, 24)
    TEST_FIELD_SIZE  (WNDCLASSEXW, hIcon, 8)
    TEST_FIELD_ALIGN (WNDCLASSEXW, hIcon, 8)
    TEST_FIELD_OFFSET(WNDCLASSEXW, hIcon, 32)
    TEST_FIELD_SIZE  (WNDCLASSEXW, hCursor, 8)
    TEST_FIELD_ALIGN (WNDCLASSEXW, hCursor, 8)
    TEST_FIELD_OFFSET(WNDCLASSEXW, hCursor, 40)
    TEST_FIELD_SIZE  (WNDCLASSEXW, hbrBackground, 8)
    TEST_FIELD_ALIGN (WNDCLASSEXW, hbrBackground, 8)
    TEST_FIELD_OFFSET(WNDCLASSEXW, hbrBackground, 48)
    TEST_FIELD_SIZE  (WNDCLASSEXW, lpszMenuName, 8)
    TEST_FIELD_ALIGN (WNDCLASSEXW, lpszMenuName, 8)
    TEST_FIELD_OFFSET(WNDCLASSEXW, lpszMenuName, 56)
    TEST_FIELD_SIZE  (WNDCLASSEXW, lpszClassName, 8)
    TEST_FIELD_ALIGN (WNDCLASSEXW, lpszClassName, 8)
    TEST_FIELD_OFFSET(WNDCLASSEXW, lpszClassName, 64)
    TEST_FIELD_SIZE  (WNDCLASSEXW, hIconSm, 8)
    TEST_FIELD_ALIGN (WNDCLASSEXW, hIconSm, 8)
    TEST_FIELD_OFFSET(WNDCLASSEXW, hIconSm, 72)
}

static void test_pack_WNDCLASSW(void)
{
    /* WNDCLASSW */
    TEST_TYPE_SIZE   (WNDCLASSW, 72)
    TEST_TYPE_ALIGN  (WNDCLASSW, 8)
    TEST_FIELD_SIZE  (WNDCLASSW, style, 4)
    TEST_FIELD_ALIGN (WNDCLASSW, style, 4)
    TEST_FIELD_OFFSET(WNDCLASSW, style, 0)
    TEST_FIELD_SIZE  (WNDCLASSW, lpfnWndProc, 8)
    TEST_FIELD_ALIGN (WNDCLASSW, lpfnWndProc, 8)
    TEST_FIELD_OFFSET(WNDCLASSW, lpfnWndProc, 8)
    TEST_FIELD_SIZE  (WNDCLASSW, cbClsExtra, 4)
    TEST_FIELD_ALIGN (WNDCLASSW, cbClsExtra, 4)
    TEST_FIELD_OFFSET(WNDCLASSW, cbClsExtra, 16)
    TEST_FIELD_SIZE  (WNDCLASSW, cbWndExtra, 4)
    TEST_FIELD_ALIGN (WNDCLASSW, cbWndExtra, 4)
    TEST_FIELD_OFFSET(WNDCLASSW, cbWndExtra, 20)
    TEST_FIELD_SIZE  (WNDCLASSW, hInstance, 8)
    TEST_FIELD_ALIGN (WNDCLASSW, hInstance, 8)
    TEST_FIELD_OFFSET(WNDCLASSW, hInstance, 24)
    TEST_FIELD_SIZE  (WNDCLASSW, hIcon, 8)
    TEST_FIELD_ALIGN (WNDCLASSW, hIcon, 8)
    TEST_FIELD_OFFSET(WNDCLASSW, hIcon, 32)
    TEST_FIELD_SIZE  (WNDCLASSW, hCursor, 8)
    TEST_FIELD_ALIGN (WNDCLASSW, hCursor, 8)
    TEST_FIELD_OFFSET(WNDCLASSW, hCursor, 40)
    TEST_FIELD_SIZE  (WNDCLASSW, hbrBackground, 8)
    TEST_FIELD_ALIGN (WNDCLASSW, hbrBackground, 8)
    TEST_FIELD_OFFSET(WNDCLASSW, hbrBackground, 48)
    TEST_FIELD_SIZE  (WNDCLASSW, lpszMenuName, 8)
    TEST_FIELD_ALIGN (WNDCLASSW, lpszMenuName, 8)
    TEST_FIELD_OFFSET(WNDCLASSW, lpszMenuName, 56)
    TEST_FIELD_SIZE  (WNDCLASSW, lpszClassName, 8)
    TEST_FIELD_ALIGN (WNDCLASSW, lpszClassName, 8)
    TEST_FIELD_OFFSET(WNDCLASSW, lpszClassName, 64)
}

static void test_pack_WNDENUMPROC(void)
{
    /* WNDENUMPROC */
    TEST_TYPE_SIZE   (WNDENUMPROC, 8)
    TEST_TYPE_ALIGN  (WNDENUMPROC, 8)
}

static void test_pack_WNDPROC(void)
{
    /* WNDPROC */
    TEST_TYPE_SIZE   (WNDPROC, 8)
    TEST_TYPE_ALIGN  (WNDPROC, 8)
}

#else /* _WIN64 */

static void test_pack_ACCESSTIMEOUT(void)
{
    /* ACCESSTIMEOUT */
    TEST_TYPE_SIZE   (ACCESSTIMEOUT, 12)
    TEST_TYPE_ALIGN  (ACCESSTIMEOUT, 4)
    TEST_FIELD_SIZE  (ACCESSTIMEOUT, cbSize, 4)
    TEST_FIELD_ALIGN (ACCESSTIMEOUT, cbSize, 4)
    TEST_FIELD_OFFSET(ACCESSTIMEOUT, cbSize, 0)
    TEST_FIELD_SIZE  (ACCESSTIMEOUT, dwFlags, 4)
    TEST_FIELD_ALIGN (ACCESSTIMEOUT, dwFlags, 4)
    TEST_FIELD_OFFSET(ACCESSTIMEOUT, dwFlags, 4)
    TEST_FIELD_SIZE  (ACCESSTIMEOUT, iTimeOutMSec, 4)
    TEST_FIELD_ALIGN (ACCESSTIMEOUT, iTimeOutMSec, 4)
    TEST_FIELD_OFFSET(ACCESSTIMEOUT, iTimeOutMSec, 8)
}

static void test_pack_ANIMATIONINFO(void)
{
    /* ANIMATIONINFO */
    TEST_TYPE_SIZE   (ANIMATIONINFO, 8)
    TEST_TYPE_ALIGN  (ANIMATIONINFO, 4)
    TEST_FIELD_SIZE  (ANIMATIONINFO, cbSize, 4)
    TEST_FIELD_ALIGN (ANIMATIONINFO, cbSize, 4)
    TEST_FIELD_OFFSET(ANIMATIONINFO, cbSize, 0)
    TEST_FIELD_SIZE  (ANIMATIONINFO, iMinAnimate, 4)
    TEST_FIELD_ALIGN (ANIMATIONINFO, iMinAnimate, 4)
    TEST_FIELD_OFFSET(ANIMATIONINFO, iMinAnimate, 4)
}

static void test_pack_CBTACTIVATESTRUCT(void)
{
    /* CBTACTIVATESTRUCT */
    TEST_TYPE_SIZE   (CBTACTIVATESTRUCT, 8)
    TEST_TYPE_ALIGN  (CBTACTIVATESTRUCT, 4)
    TEST_FIELD_SIZE  (CBTACTIVATESTRUCT, fMouse, 4)
    TEST_FIELD_ALIGN (CBTACTIVATESTRUCT, fMouse, 4)
    TEST_FIELD_OFFSET(CBTACTIVATESTRUCT, fMouse, 0)
    TEST_FIELD_SIZE  (CBTACTIVATESTRUCT, hWndActive, 4)
    TEST_FIELD_ALIGN (CBTACTIVATESTRUCT, hWndActive, 4)
    TEST_FIELD_OFFSET(CBTACTIVATESTRUCT, hWndActive, 4)
}

static void test_pack_CBT_CREATEWNDA(void)
{
    /* CBT_CREATEWNDA */
    TEST_TYPE_SIZE   (CBT_CREATEWNDA, 8)
    TEST_TYPE_ALIGN  (CBT_CREATEWNDA, 4)
    TEST_FIELD_SIZE  (CBT_CREATEWNDA, lpcs, 4)
    TEST_FIELD_ALIGN (CBT_CREATEWNDA, lpcs, 4)
    TEST_FIELD_OFFSET(CBT_CREATEWNDA, lpcs, 0)
    TEST_FIELD_SIZE  (CBT_CREATEWNDA, hwndInsertAfter, 4)
    TEST_FIELD_ALIGN (CBT_CREATEWNDA, hwndInsertAfter, 4)
    TEST_FIELD_OFFSET(CBT_CREATEWNDA, hwndInsertAfter, 4)
}

static void test_pack_CBT_CREATEWNDW(void)
{
    /* CBT_CREATEWNDW */
    TEST_TYPE_SIZE   (CBT_CREATEWNDW, 8)
    TEST_TYPE_ALIGN  (CBT_CREATEWNDW, 4)
    TEST_FIELD_SIZE  (CBT_CREATEWNDW, lpcs, 4)
    TEST_FIELD_ALIGN (CBT_CREATEWNDW, lpcs, 4)
    TEST_FIELD_OFFSET(CBT_CREATEWNDW, lpcs, 0)
    TEST_FIELD_SIZE  (CBT_CREATEWNDW, hwndInsertAfter, 4)
    TEST_FIELD_ALIGN (CBT_CREATEWNDW, hwndInsertAfter, 4)
    TEST_FIELD_OFFSET(CBT_CREATEWNDW, hwndInsertAfter, 4)
}

static void test_pack_CLIENTCREATESTRUCT(void)
{
    /* CLIENTCREATESTRUCT */
    TEST_TYPE_SIZE   (CLIENTCREATESTRUCT, 8)
    TEST_TYPE_ALIGN  (CLIENTCREATESTRUCT, 4)
    TEST_FIELD_SIZE  (CLIENTCREATESTRUCT, hWindowMenu, 4)
    TEST_FIELD_ALIGN (CLIENTCREATESTRUCT, hWindowMenu, 4)
    TEST_FIELD_OFFSET(CLIENTCREATESTRUCT, hWindowMenu, 0)
    TEST_FIELD_SIZE  (CLIENTCREATESTRUCT, idFirstChild, 4)
    TEST_FIELD_ALIGN (CLIENTCREATESTRUCT, idFirstChild, 4)
    TEST_FIELD_OFFSET(CLIENTCREATESTRUCT, idFirstChild, 4)
}

static void test_pack_COMBOBOXINFO(void)
{
    /* COMBOBOXINFO */
    TEST_TYPE_SIZE   (COMBOBOXINFO, 52)
    TEST_TYPE_ALIGN  (COMBOBOXINFO, 4)
    TEST_FIELD_SIZE  (COMBOBOXINFO, cbSize, 4)
    TEST_FIELD_ALIGN (COMBOBOXINFO, cbSize, 4)
    TEST_FIELD_OFFSET(COMBOBOXINFO, cbSize, 0)
    TEST_FIELD_SIZE  (COMBOBOXINFO, rcItem, 16)
    TEST_FIELD_ALIGN (COMBOBOXINFO, rcItem, 4)
    TEST_FIELD_OFFSET(COMBOBOXINFO, rcItem, 4)
    TEST_FIELD_SIZE  (COMBOBOXINFO, rcButton, 16)
    TEST_FIELD_ALIGN (COMBOBOXINFO, rcButton, 4)
    TEST_FIELD_OFFSET(COMBOBOXINFO, rcButton, 20)
    TEST_FIELD_SIZE  (COMBOBOXINFO, stateButton, 4)
    TEST_FIELD_ALIGN (COMBOBOXINFO, stateButton, 4)
    TEST_FIELD_OFFSET(COMBOBOXINFO, stateButton, 36)
    TEST_FIELD_SIZE  (COMBOBOXINFO, hwndCombo, 4)
    TEST_FIELD_ALIGN (COMBOBOXINFO, hwndCombo, 4)
    TEST_FIELD_OFFSET(COMBOBOXINFO, hwndCombo, 40)
    TEST_FIELD_SIZE  (COMBOBOXINFO, hwndItem, 4)
    TEST_FIELD_ALIGN (COMBOBOXINFO, hwndItem, 4)
    TEST_FIELD_OFFSET(COMBOBOXINFO, hwndItem, 44)
    TEST_FIELD_SIZE  (COMBOBOXINFO, hwndList, 4)
    TEST_FIELD_ALIGN (COMBOBOXINFO, hwndList, 4)
    TEST_FIELD_OFFSET(COMBOBOXINFO, hwndList, 48)
}

static void test_pack_COMPAREITEMSTRUCT(void)
{
    /* COMPAREITEMSTRUCT */
    TEST_TYPE_SIZE   (COMPAREITEMSTRUCT, 32)
    TEST_TYPE_ALIGN  (COMPAREITEMSTRUCT, 4)
    TEST_FIELD_SIZE  (COMPAREITEMSTRUCT, CtlType, 4)
    TEST_FIELD_ALIGN (COMPAREITEMSTRUCT, CtlType, 4)
    TEST_FIELD_OFFSET(COMPAREITEMSTRUCT, CtlType, 0)
    TEST_FIELD_SIZE  (COMPAREITEMSTRUCT, CtlID, 4)
    TEST_FIELD_ALIGN (COMPAREITEMSTRUCT, CtlID, 4)
    TEST_FIELD_OFFSET(COMPAREITEMSTRUCT, CtlID, 4)
    TEST_FIELD_SIZE  (COMPAREITEMSTRUCT, hwndItem, 4)
    TEST_FIELD_ALIGN (COMPAREITEMSTRUCT, hwndItem, 4)
    TEST_FIELD_OFFSET(COMPAREITEMSTRUCT, hwndItem, 8)
    TEST_FIELD_SIZE  (COMPAREITEMSTRUCT, itemID1, 4)
    TEST_FIELD_ALIGN (COMPAREITEMSTRUCT, itemID1, 4)
    TEST_FIELD_OFFSET(COMPAREITEMSTRUCT, itemID1, 12)
    TEST_FIELD_SIZE  (COMPAREITEMSTRUCT, itemData1, 4)
    TEST_FIELD_ALIGN (COMPAREITEMSTRUCT, itemData1, 4)
    TEST_FIELD_OFFSET(COMPAREITEMSTRUCT, itemData1, 16)
    TEST_FIELD_SIZE  (COMPAREITEMSTRUCT, itemID2, 4)
    TEST_FIELD_ALIGN (COMPAREITEMSTRUCT, itemID2, 4)
    TEST_FIELD_OFFSET(COMPAREITEMSTRUCT, itemID2, 20)
    TEST_FIELD_SIZE  (COMPAREITEMSTRUCT, itemData2, 4)
    TEST_FIELD_ALIGN (COMPAREITEMSTRUCT, itemData2, 4)
    TEST_FIELD_OFFSET(COMPAREITEMSTRUCT, itemData2, 24)
    TEST_FIELD_SIZE  (COMPAREITEMSTRUCT, dwLocaleId, 4)
    TEST_FIELD_ALIGN (COMPAREITEMSTRUCT, dwLocaleId, 4)
    TEST_FIELD_OFFSET(COMPAREITEMSTRUCT, dwLocaleId, 28)
}

static void test_pack_COPYDATASTRUCT(void)
{
    /* COPYDATASTRUCT */
    TEST_TYPE_SIZE   (COPYDATASTRUCT, 12)
    TEST_TYPE_ALIGN  (COPYDATASTRUCT, 4)
    TEST_FIELD_SIZE  (COPYDATASTRUCT, dwData, 4)
    TEST_FIELD_ALIGN (COPYDATASTRUCT, dwData, 4)
    TEST_FIELD_OFFSET(COPYDATASTRUCT, dwData, 0)
    TEST_FIELD_SIZE  (COPYDATASTRUCT, cbData, 4)
    TEST_FIELD_ALIGN (COPYDATASTRUCT, cbData, 4)
    TEST_FIELD_OFFSET(COPYDATASTRUCT, cbData, 4)
    TEST_FIELD_SIZE  (COPYDATASTRUCT, lpData, 4)
    TEST_FIELD_ALIGN (COPYDATASTRUCT, lpData, 4)
    TEST_FIELD_OFFSET(COPYDATASTRUCT, lpData, 8)
}

static void test_pack_CREATESTRUCTA(void)
{
    /* CREATESTRUCTA */
    TEST_TYPE_SIZE   (CREATESTRUCTA, 48)
    TEST_TYPE_ALIGN  (CREATESTRUCTA, 4)
    TEST_FIELD_SIZE  (CREATESTRUCTA, lpCreateParams, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTA, lpCreateParams, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTA, lpCreateParams, 0)
    TEST_FIELD_SIZE  (CREATESTRUCTA, hInstance, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTA, hInstance, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTA, hInstance, 4)
    TEST_FIELD_SIZE  (CREATESTRUCTA, hMenu, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTA, hMenu, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTA, hMenu, 8)
    TEST_FIELD_SIZE  (CREATESTRUCTA, hwndParent, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTA, hwndParent, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTA, hwndParent, 12)
    TEST_FIELD_SIZE  (CREATESTRUCTA, cy, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTA, cy, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTA, cy, 16)
    TEST_FIELD_SIZE  (CREATESTRUCTA, cx, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTA, cx, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTA, cx, 20)
    TEST_FIELD_SIZE  (CREATESTRUCTA, y, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTA, y, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTA, y, 24)
    TEST_FIELD_SIZE  (CREATESTRUCTA, x, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTA, x, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTA, x, 28)
    TEST_FIELD_SIZE  (CREATESTRUCTA, style, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTA, style, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTA, style, 32)
    TEST_FIELD_SIZE  (CREATESTRUCTA, lpszName, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTA, lpszName, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTA, lpszName, 36)
    TEST_FIELD_SIZE  (CREATESTRUCTA, lpszClass, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTA, lpszClass, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTA, lpszClass, 40)
    TEST_FIELD_SIZE  (CREATESTRUCTA, dwExStyle, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTA, dwExStyle, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTA, dwExStyle, 44)
}

static void test_pack_CREATESTRUCTW(void)
{
    /* CREATESTRUCTW */
    TEST_TYPE_SIZE   (CREATESTRUCTW, 48)
    TEST_TYPE_ALIGN  (CREATESTRUCTW, 4)
    TEST_FIELD_SIZE  (CREATESTRUCTW, lpCreateParams, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTW, lpCreateParams, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTW, lpCreateParams, 0)
    TEST_FIELD_SIZE  (CREATESTRUCTW, hInstance, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTW, hInstance, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTW, hInstance, 4)
    TEST_FIELD_SIZE  (CREATESTRUCTW, hMenu, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTW, hMenu, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTW, hMenu, 8)
    TEST_FIELD_SIZE  (CREATESTRUCTW, hwndParent, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTW, hwndParent, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTW, hwndParent, 12)
    TEST_FIELD_SIZE  (CREATESTRUCTW, cy, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTW, cy, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTW, cy, 16)
    TEST_FIELD_SIZE  (CREATESTRUCTW, cx, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTW, cx, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTW, cx, 20)
    TEST_FIELD_SIZE  (CREATESTRUCTW, y, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTW, y, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTW, y, 24)
    TEST_FIELD_SIZE  (CREATESTRUCTW, x, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTW, x, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTW, x, 28)
    TEST_FIELD_SIZE  (CREATESTRUCTW, style, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTW, style, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTW, style, 32)
    TEST_FIELD_SIZE  (CREATESTRUCTW, lpszName, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTW, lpszName, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTW, lpszName, 36)
    TEST_FIELD_SIZE  (CREATESTRUCTW, lpszClass, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTW, lpszClass, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTW, lpszClass, 40)
    TEST_FIELD_SIZE  (CREATESTRUCTW, dwExStyle, 4)
    TEST_FIELD_ALIGN (CREATESTRUCTW, dwExStyle, 4)
    TEST_FIELD_OFFSET(CREATESTRUCTW, dwExStyle, 44)
}

static void test_pack_CURSORINFO(void)
{
    /* CURSORINFO */
    TEST_TYPE_SIZE   (CURSORINFO, 20)
    TEST_TYPE_ALIGN  (CURSORINFO, 4)
    TEST_FIELD_SIZE  (CURSORINFO, cbSize, 4)
    TEST_FIELD_ALIGN (CURSORINFO, cbSize, 4)
    TEST_FIELD_OFFSET(CURSORINFO, cbSize, 0)
    TEST_FIELD_SIZE  (CURSORINFO, flags, 4)
    TEST_FIELD_ALIGN (CURSORINFO, flags, 4)
    TEST_FIELD_OFFSET(CURSORINFO, flags, 4)
    TEST_FIELD_SIZE  (CURSORINFO, hCursor, 4)
    TEST_FIELD_ALIGN (CURSORINFO, hCursor, 4)
    TEST_FIELD_OFFSET(CURSORINFO, hCursor, 8)
    TEST_FIELD_SIZE  (CURSORINFO, ptScreenPos, 8)
    TEST_FIELD_ALIGN (CURSORINFO, ptScreenPos, 4)
    TEST_FIELD_OFFSET(CURSORINFO, ptScreenPos, 12)
}

static void test_pack_CWPRETSTRUCT(void)
{
    /* CWPRETSTRUCT */
    TEST_TYPE_SIZE   (CWPRETSTRUCT, 20)
    TEST_TYPE_ALIGN  (CWPRETSTRUCT, 4)
    TEST_FIELD_SIZE  (CWPRETSTRUCT, lResult, 4)
    TEST_FIELD_ALIGN (CWPRETSTRUCT, lResult, 4)
    TEST_FIELD_OFFSET(CWPRETSTRUCT, lResult, 0)
    TEST_FIELD_SIZE  (CWPRETSTRUCT, lParam, 4)
    TEST_FIELD_ALIGN (CWPRETSTRUCT, lParam, 4)
    TEST_FIELD_OFFSET(CWPRETSTRUCT, lParam, 4)
    TEST_FIELD_SIZE  (CWPRETSTRUCT, wParam, 4)
    TEST_FIELD_ALIGN (CWPRETSTRUCT, wParam, 4)
    TEST_FIELD_OFFSET(CWPRETSTRUCT, wParam, 8)
    TEST_FIELD_SIZE  (CWPRETSTRUCT, message, 4)
    TEST_FIELD_ALIGN (CWPRETSTRUCT, message, 4)
    TEST_FIELD_OFFSET(CWPRETSTRUCT, message, 12)
    TEST_FIELD_SIZE  (CWPRETSTRUCT, hwnd, 4)
    TEST_FIELD_ALIGN (CWPRETSTRUCT, hwnd, 4)
    TEST_FIELD_OFFSET(CWPRETSTRUCT, hwnd, 16)
}

static void test_pack_CWPSTRUCT(void)
{
    /* CWPSTRUCT */
    TEST_TYPE_SIZE   (CWPSTRUCT, 16)
    TEST_TYPE_ALIGN  (CWPSTRUCT, 4)
    TEST_FIELD_SIZE  (CWPSTRUCT, lParam, 4)
    TEST_FIELD_ALIGN (CWPSTRUCT, lParam, 4)
    TEST_FIELD_OFFSET(CWPSTRUCT, lParam, 0)
    TEST_FIELD_SIZE  (CWPSTRUCT, wParam, 4)
    TEST_FIELD_ALIGN (CWPSTRUCT, wParam, 4)
    TEST_FIELD_OFFSET(CWPSTRUCT, wParam, 4)
    TEST_FIELD_SIZE  (CWPSTRUCT, message, 4)
    TEST_FIELD_ALIGN (CWPSTRUCT, message, 4)
    TEST_FIELD_OFFSET(CWPSTRUCT, message, 8)
    TEST_FIELD_SIZE  (CWPSTRUCT, hwnd, 4)
    TEST_FIELD_ALIGN (CWPSTRUCT, hwnd, 4)
    TEST_FIELD_OFFSET(CWPSTRUCT, hwnd, 12)
}

static void test_pack_DEBUGHOOKINFO(void)
{
    /* DEBUGHOOKINFO */
    TEST_TYPE_SIZE   (DEBUGHOOKINFO, 20)
    TEST_TYPE_ALIGN  (DEBUGHOOKINFO, 4)
    TEST_FIELD_SIZE  (DEBUGHOOKINFO, idThread, 4)
    TEST_FIELD_ALIGN (DEBUGHOOKINFO, idThread, 4)
    TEST_FIELD_OFFSET(DEBUGHOOKINFO, idThread, 0)
    TEST_FIELD_SIZE  (DEBUGHOOKINFO, idThreadInstaller, 4)
    TEST_FIELD_ALIGN (DEBUGHOOKINFO, idThreadInstaller, 4)
    TEST_FIELD_OFFSET(DEBUGHOOKINFO, idThreadInstaller, 4)
    TEST_FIELD_SIZE  (DEBUGHOOKINFO, lParam, 4)
    TEST_FIELD_ALIGN (DEBUGHOOKINFO, lParam, 4)
    TEST_FIELD_OFFSET(DEBUGHOOKINFO, lParam, 8)
    TEST_FIELD_SIZE  (DEBUGHOOKINFO, wParam, 4)
    TEST_FIELD_ALIGN (DEBUGHOOKINFO, wParam, 4)
    TEST_FIELD_OFFSET(DEBUGHOOKINFO, wParam, 12)
    TEST_FIELD_SIZE  (DEBUGHOOKINFO, code, 4)
    TEST_FIELD_ALIGN (DEBUGHOOKINFO, code, 4)
    TEST_FIELD_OFFSET(DEBUGHOOKINFO, code, 16)
}

static void test_pack_DELETEITEMSTRUCT(void)
{
    /* DELETEITEMSTRUCT */
    TEST_TYPE_SIZE   (DELETEITEMSTRUCT, 20)
    TEST_TYPE_ALIGN  (DELETEITEMSTRUCT, 4)
    TEST_FIELD_SIZE  (DELETEITEMSTRUCT, CtlType, 4)
    TEST_FIELD_ALIGN (DELETEITEMSTRUCT, CtlType, 4)
    TEST_FIELD_OFFSET(DELETEITEMSTRUCT, CtlType, 0)
    TEST_FIELD_SIZE  (DELETEITEMSTRUCT, CtlID, 4)
    TEST_FIELD_ALIGN (DELETEITEMSTRUCT, CtlID, 4)
    TEST_FIELD_OFFSET(DELETEITEMSTRUCT, CtlID, 4)
    TEST_FIELD_SIZE  (DELETEITEMSTRUCT, itemID, 4)
    TEST_FIELD_ALIGN (DELETEITEMSTRUCT, itemID, 4)
    TEST_FIELD_OFFSET(DELETEITEMSTRUCT, itemID, 8)
    TEST_FIELD_SIZE  (DELETEITEMSTRUCT, hwndItem, 4)
    TEST_FIELD_ALIGN (DELETEITEMSTRUCT, hwndItem, 4)
    TEST_FIELD_OFFSET(DELETEITEMSTRUCT, hwndItem, 12)
    TEST_FIELD_SIZE  (DELETEITEMSTRUCT, itemData, 4)
    TEST_FIELD_ALIGN (DELETEITEMSTRUCT, itemData, 4)
    TEST_FIELD_OFFSET(DELETEITEMSTRUCT, itemData, 16)
}

static void test_pack_DESKTOPENUMPROCA(void)
{
    /* DESKTOPENUMPROCA */
    TEST_TYPE_SIZE   (DESKTOPENUMPROCA, 4)
    TEST_TYPE_ALIGN  (DESKTOPENUMPROCA, 4)
}

static void test_pack_DESKTOPENUMPROCW(void)
{
    /* DESKTOPENUMPROCW */
    TEST_TYPE_SIZE   (DESKTOPENUMPROCW, 4)
    TEST_TYPE_ALIGN  (DESKTOPENUMPROCW, 4)
}

static void test_pack_DLGITEMTEMPLATE(void)
{
    /* DLGITEMTEMPLATE (pack 2) */
    TEST_TYPE_SIZE   (DLGITEMTEMPLATE, 18)
    TEST_TYPE_ALIGN  (DLGITEMTEMPLATE, 2)
    TEST_FIELD_SIZE  (DLGITEMTEMPLATE, style, 4)
    TEST_FIELD_ALIGN (DLGITEMTEMPLATE, style, 2)
    TEST_FIELD_OFFSET(DLGITEMTEMPLATE, style, 0)
    TEST_FIELD_SIZE  (DLGITEMTEMPLATE, dwExtendedStyle, 4)
    TEST_FIELD_ALIGN (DLGITEMTEMPLATE, dwExtendedStyle, 2)
    TEST_FIELD_OFFSET(DLGITEMTEMPLATE, dwExtendedStyle, 4)
    TEST_FIELD_SIZE  (DLGITEMTEMPLATE, x, 2)
    TEST_FIELD_ALIGN (DLGITEMTEMPLATE, x, 2)
    TEST_FIELD_OFFSET(DLGITEMTEMPLATE, x, 8)
    TEST_FIELD_SIZE  (DLGITEMTEMPLATE, y, 2)
    TEST_FIELD_ALIGN (DLGITEMTEMPLATE, y, 2)
    TEST_FIELD_OFFSET(DLGITEMTEMPLATE, y, 10)
    TEST_FIELD_SIZE  (DLGITEMTEMPLATE, cx, 2)
    TEST_FIELD_ALIGN (DLGITEMTEMPLATE, cx, 2)
    TEST_FIELD_OFFSET(DLGITEMTEMPLATE, cx, 12)
    TEST_FIELD_SIZE  (DLGITEMTEMPLATE, cy, 2)
    TEST_FIELD_ALIGN (DLGITEMTEMPLATE, cy, 2)
    TEST_FIELD_OFFSET(DLGITEMTEMPLATE, cy, 14)
    TEST_FIELD_SIZE  (DLGITEMTEMPLATE, id, 2)
    TEST_FIELD_ALIGN (DLGITEMTEMPLATE, id, 2)
    TEST_FIELD_OFFSET(DLGITEMTEMPLATE, id, 16)
}

static void test_pack_DLGPROC(void)
{
    /* DLGPROC */
    TEST_TYPE_SIZE   (DLGPROC, 4)
    TEST_TYPE_ALIGN  (DLGPROC, 4)
}

static void test_pack_DLGTEMPLATE(void)
{
    /* DLGTEMPLATE (pack 2) */
    TEST_TYPE_SIZE   (DLGTEMPLATE, 18)
    TEST_TYPE_ALIGN  (DLGTEMPLATE, 2)
    TEST_FIELD_SIZE  (DLGTEMPLATE, style, 4)
    TEST_FIELD_ALIGN (DLGTEMPLATE, style, 2)
    TEST_FIELD_OFFSET(DLGTEMPLATE, style, 0)
    TEST_FIELD_SIZE  (DLGTEMPLATE, dwExtendedStyle, 4)
    TEST_FIELD_ALIGN (DLGTEMPLATE, dwExtendedStyle, 2)
    TEST_FIELD_OFFSET(DLGTEMPLATE, dwExtendedStyle, 4)
    TEST_FIELD_SIZE  (DLGTEMPLATE, cdit, 2)
    TEST_FIELD_ALIGN (DLGTEMPLATE, cdit, 2)
    TEST_FIELD_OFFSET(DLGTEMPLATE, cdit, 8)
    TEST_FIELD_SIZE  (DLGTEMPLATE, x, 2)
    TEST_FIELD_ALIGN (DLGTEMPLATE, x, 2)
    TEST_FIELD_OFFSET(DLGTEMPLATE, x, 10)
    TEST_FIELD_SIZE  (DLGTEMPLATE, y, 2)
    TEST_FIELD_ALIGN (DLGTEMPLATE, y, 2)
    TEST_FIELD_OFFSET(DLGTEMPLATE, y, 12)
    TEST_FIELD_SIZE  (DLGTEMPLATE, cx, 2)
    TEST_FIELD_ALIGN (DLGTEMPLATE, cx, 2)
    TEST_FIELD_OFFSET(DLGTEMPLATE, cx, 14)
    TEST_FIELD_SIZE  (DLGTEMPLATE, cy, 2)
    TEST_FIELD_ALIGN (DLGTEMPLATE, cy, 2)
    TEST_FIELD_OFFSET(DLGTEMPLATE, cy, 16)
}

static void test_pack_DRAWITEMSTRUCT(void)
{
    /* DRAWITEMSTRUCT */
    TEST_TYPE_SIZE   (DRAWITEMSTRUCT, 48)
    TEST_TYPE_ALIGN  (DRAWITEMSTRUCT, 4)
    TEST_FIELD_SIZE  (DRAWITEMSTRUCT, CtlType, 4)
    TEST_FIELD_ALIGN (DRAWITEMSTRUCT, CtlType, 4)
    TEST_FIELD_OFFSET(DRAWITEMSTRUCT, CtlType, 0)
    TEST_FIELD_SIZE  (DRAWITEMSTRUCT, CtlID, 4)
    TEST_FIELD_ALIGN (DRAWITEMSTRUCT, CtlID, 4)
    TEST_FIELD_OFFSET(DRAWITEMSTRUCT, CtlID, 4)
    TEST_FIELD_SIZE  (DRAWITEMSTRUCT, itemID, 4)
    TEST_FIELD_ALIGN (DRAWITEMSTRUCT, itemID, 4)
    TEST_FIELD_OFFSET(DRAWITEMSTRUCT, itemID, 8)
    TEST_FIELD_SIZE  (DRAWITEMSTRUCT, itemAction, 4)
    TEST_FIELD_ALIGN (DRAWITEMSTRUCT, itemAction, 4)
    TEST_FIELD_OFFSET(DRAWITEMSTRUCT, itemAction, 12)
    TEST_FIELD_SIZE  (DRAWITEMSTRUCT, itemState, 4)
    TEST_FIELD_ALIGN (DRAWITEMSTRUCT, itemState, 4)
    TEST_FIELD_OFFSET(DRAWITEMSTRUCT, itemState, 16)
    TEST_FIELD_SIZE  (DRAWITEMSTRUCT, hwndItem, 4)
    TEST_FIELD_ALIGN (DRAWITEMSTRUCT, hwndItem, 4)
    TEST_FIELD_OFFSET(DRAWITEMSTRUCT, hwndItem, 20)
    TEST_FIELD_SIZE  (DRAWITEMSTRUCT, hDC, 4)
    TEST_FIELD_ALIGN (DRAWITEMSTRUCT, hDC, 4)
    TEST_FIELD_OFFSET(DRAWITEMSTRUCT, hDC, 24)
    TEST_FIELD_SIZE  (DRAWITEMSTRUCT, rcItem, 16)
    TEST_FIELD_ALIGN (DRAWITEMSTRUCT, rcItem, 4)
    TEST_FIELD_OFFSET(DRAWITEMSTRUCT, rcItem, 28)
    TEST_FIELD_SIZE  (DRAWITEMSTRUCT, itemData, 4)
    TEST_FIELD_ALIGN (DRAWITEMSTRUCT, itemData, 4)
    TEST_FIELD_OFFSET(DRAWITEMSTRUCT, itemData, 44)
}

static void test_pack_DRAWSTATEPROC(void)
{
    /* DRAWSTATEPROC */
    TEST_TYPE_SIZE   (DRAWSTATEPROC, 4)
    TEST_TYPE_ALIGN  (DRAWSTATEPROC, 4)
}

static void test_pack_DRAWTEXTPARAMS(void)
{
    /* DRAWTEXTPARAMS */
    TEST_TYPE_SIZE   (DRAWTEXTPARAMS, 20)
    TEST_TYPE_ALIGN  (DRAWTEXTPARAMS, 4)
    TEST_FIELD_SIZE  (DRAWTEXTPARAMS, cbSize, 4)
    TEST_FIELD_ALIGN (DRAWTEXTPARAMS, cbSize, 4)
    TEST_FIELD_OFFSET(DRAWTEXTPARAMS, cbSize, 0)
    TEST_FIELD_SIZE  (DRAWTEXTPARAMS, iTabLength, 4)
    TEST_FIELD_ALIGN (DRAWTEXTPARAMS, iTabLength, 4)
    TEST_FIELD_OFFSET(DRAWTEXTPARAMS, iTabLength, 4)
    TEST_FIELD_SIZE  (DRAWTEXTPARAMS, iLeftMargin, 4)
    TEST_FIELD_ALIGN (DRAWTEXTPARAMS, iLeftMargin, 4)
    TEST_FIELD_OFFSET(DRAWTEXTPARAMS, iLeftMargin, 8)
    TEST_FIELD_SIZE  (DRAWTEXTPARAMS, iRightMargin, 4)
    TEST_FIELD_ALIGN (DRAWTEXTPARAMS, iRightMargin, 4)
    TEST_FIELD_OFFSET(DRAWTEXTPARAMS, iRightMargin, 12)
    TEST_FIELD_SIZE  (DRAWTEXTPARAMS, uiLengthDrawn, 4)
    TEST_FIELD_ALIGN (DRAWTEXTPARAMS, uiLengthDrawn, 4)
    TEST_FIELD_OFFSET(DRAWTEXTPARAMS, uiLengthDrawn, 16)
}

static void test_pack_EDITWORDBREAKPROCA(void)
{
    /* EDITWORDBREAKPROCA */
    TEST_TYPE_SIZE   (EDITWORDBREAKPROCA, 4)
    TEST_TYPE_ALIGN  (EDITWORDBREAKPROCA, 4)
}

static void test_pack_EDITWORDBREAKPROCW(void)
{
    /* EDITWORDBREAKPROCW */
    TEST_TYPE_SIZE   (EDITWORDBREAKPROCW, 4)
    TEST_TYPE_ALIGN  (EDITWORDBREAKPROCW, 4)
}

static void test_pack_EVENTMSG(void)
{
    /* EVENTMSG */
    TEST_TYPE_SIZE   (EVENTMSG, 20)
    TEST_TYPE_ALIGN  (EVENTMSG, 4)
    TEST_FIELD_SIZE  (EVENTMSG, message, 4)
    TEST_FIELD_ALIGN (EVENTMSG, message, 4)
    TEST_FIELD_OFFSET(EVENTMSG, message, 0)
    TEST_FIELD_SIZE  (EVENTMSG, paramL, 4)
    TEST_FIELD_ALIGN (EVENTMSG, paramL, 4)
    TEST_FIELD_OFFSET(EVENTMSG, paramL, 4)
    TEST_FIELD_SIZE  (EVENTMSG, paramH, 4)
    TEST_FIELD_ALIGN (EVENTMSG, paramH, 4)
    TEST_FIELD_OFFSET(EVENTMSG, paramH, 8)
    TEST_FIELD_SIZE  (EVENTMSG, time, 4)
    TEST_FIELD_ALIGN (EVENTMSG, time, 4)
    TEST_FIELD_OFFSET(EVENTMSG, time, 12)
    TEST_FIELD_SIZE  (EVENTMSG, hwnd, 4)
    TEST_FIELD_ALIGN (EVENTMSG, hwnd, 4)
    TEST_FIELD_OFFSET(EVENTMSG, hwnd, 16)
}

static void test_pack_FILTERKEYS(void)
{
    /* FILTERKEYS */
    TEST_TYPE_SIZE   (FILTERKEYS, 24)
    TEST_TYPE_ALIGN  (FILTERKEYS, 4)
    TEST_FIELD_SIZE  (FILTERKEYS, cbSize, 4)
    TEST_FIELD_ALIGN (FILTERKEYS, cbSize, 4)
    TEST_FIELD_OFFSET(FILTERKEYS, cbSize, 0)
    TEST_FIELD_SIZE  (FILTERKEYS, dwFlags, 4)
    TEST_FIELD_ALIGN (FILTERKEYS, dwFlags, 4)
    TEST_FIELD_OFFSET(FILTERKEYS, dwFlags, 4)
    TEST_FIELD_SIZE  (FILTERKEYS, iWaitMSec, 4)
    TEST_FIELD_ALIGN (FILTERKEYS, iWaitMSec, 4)
    TEST_FIELD_OFFSET(FILTERKEYS, iWaitMSec, 8)
    TEST_FIELD_SIZE  (FILTERKEYS, iDelayMSec, 4)
    TEST_FIELD_ALIGN (FILTERKEYS, iDelayMSec, 4)
    TEST_FIELD_OFFSET(FILTERKEYS, iDelayMSec, 12)
    TEST_FIELD_SIZE  (FILTERKEYS, iRepeatMSec, 4)
    TEST_FIELD_ALIGN (FILTERKEYS, iRepeatMSec, 4)
    TEST_FIELD_OFFSET(FILTERKEYS, iRepeatMSec, 16)
    TEST_FIELD_SIZE  (FILTERKEYS, iBounceMSec, 4)
    TEST_FIELD_ALIGN (FILTERKEYS, iBounceMSec, 4)
    TEST_FIELD_OFFSET(FILTERKEYS, iBounceMSec, 20)
}

static void test_pack_FLASHWINFO(void)
{
    /* FLASHWINFO */
    TEST_TYPE_SIZE   (FLASHWINFO, 20)
    TEST_TYPE_ALIGN  (FLASHWINFO, 4)
    TEST_FIELD_SIZE  (FLASHWINFO, cbSize, 4)
    TEST_FIELD_ALIGN (FLASHWINFO, cbSize, 4)
    TEST_FIELD_OFFSET(FLASHWINFO, cbSize, 0)
    TEST_FIELD_SIZE  (FLASHWINFO, hwnd, 4)
    TEST_FIELD_ALIGN (FLASHWINFO, hwnd, 4)
    TEST_FIELD_OFFSET(FLASHWINFO, hwnd, 4)
    TEST_FIELD_SIZE  (FLASHWINFO, dwFlags, 4)
    TEST_FIELD_ALIGN (FLASHWINFO, dwFlags, 4)
    TEST_FIELD_OFFSET(FLASHWINFO, dwFlags, 8)
    TEST_FIELD_SIZE  (FLASHWINFO, uCount, 4)
    TEST_FIELD_ALIGN (FLASHWINFO, uCount, 4)
    TEST_FIELD_OFFSET(FLASHWINFO, uCount, 12)
    TEST_FIELD_SIZE  (FLASHWINFO, dwTimeout, 4)
    TEST_FIELD_ALIGN (FLASHWINFO, dwTimeout, 4)
    TEST_FIELD_OFFSET(FLASHWINFO, dwTimeout, 16)
}

static void test_pack_GRAYSTRINGPROC(void)
{
    /* GRAYSTRINGPROC */
    TEST_TYPE_SIZE   (GRAYSTRINGPROC, 4)
    TEST_TYPE_ALIGN  (GRAYSTRINGPROC, 4)
}

static void test_pack_GUITHREADINFO(void)
{
    /* GUITHREADINFO */
    TEST_TYPE_SIZE   (GUITHREADINFO, 48)
    TEST_TYPE_ALIGN  (GUITHREADINFO, 4)
    TEST_FIELD_SIZE  (GUITHREADINFO, cbSize, 4)
    TEST_FIELD_ALIGN (GUITHREADINFO, cbSize, 4)
    TEST_FIELD_OFFSET(GUITHREADINFO, cbSize, 0)
    TEST_FIELD_SIZE  (GUITHREADINFO, flags, 4)
    TEST_FIELD_ALIGN (GUITHREADINFO, flags, 4)
    TEST_FIELD_OFFSET(GUITHREADINFO, flags, 4)
    TEST_FIELD_SIZE  (GUITHREADINFO, hwndActive, 4)
    TEST_FIELD_ALIGN (GUITHREADINFO, hwndActive, 4)
    TEST_FIELD_OFFSET(GUITHREADINFO, hwndActive, 8)
    TEST_FIELD_SIZE  (GUITHREADINFO, hwndFocus, 4)
    TEST_FIELD_ALIGN (GUITHREADINFO, hwndFocus, 4)
    TEST_FIELD_OFFSET(GUITHREADINFO, hwndFocus, 12)
    TEST_FIELD_SIZE  (GUITHREADINFO, hwndCapture, 4)
    TEST_FIELD_ALIGN (GUITHREADINFO, hwndCapture, 4)
    TEST_FIELD_OFFSET(GUITHREADINFO, hwndCapture, 16)
    TEST_FIELD_SIZE  (GUITHREADINFO, hwndMenuOwner, 4)
    TEST_FIELD_ALIGN (GUITHREADINFO, hwndMenuOwner, 4)
    TEST_FIELD_OFFSET(GUITHREADINFO, hwndMenuOwner, 20)
    TEST_FIELD_SIZE  (GUITHREADINFO, hwndMoveSize, 4)
    TEST_FIELD_ALIGN (GUITHREADINFO, hwndMoveSize, 4)
    TEST_FIELD_OFFSET(GUITHREADINFO, hwndMoveSize, 24)
    TEST_FIELD_SIZE  (GUITHREADINFO, hwndCaret, 4)
    TEST_FIELD_ALIGN (GUITHREADINFO, hwndCaret, 4)
    TEST_FIELD_OFFSET(GUITHREADINFO, hwndCaret, 28)
    TEST_FIELD_SIZE  (GUITHREADINFO, rcCaret, 16)
    TEST_FIELD_ALIGN (GUITHREADINFO, rcCaret, 4)
    TEST_FIELD_OFFSET(GUITHREADINFO, rcCaret, 32)
}

static void test_pack_HARDWAREHOOKSTRUCT(void)
{
    /* HARDWAREHOOKSTRUCT */
    TEST_TYPE_SIZE   (HARDWAREHOOKSTRUCT, 16)
    TEST_TYPE_ALIGN  (HARDWAREHOOKSTRUCT, 4)
    TEST_FIELD_SIZE  (HARDWAREHOOKSTRUCT, hwnd, 4)
    TEST_FIELD_ALIGN (HARDWAREHOOKSTRUCT, hwnd, 4)
    TEST_FIELD_OFFSET(HARDWAREHOOKSTRUCT, hwnd, 0)
    TEST_FIELD_SIZE  (HARDWAREHOOKSTRUCT, message, 4)
    TEST_FIELD_ALIGN (HARDWAREHOOKSTRUCT, message, 4)
    TEST_FIELD_OFFSET(HARDWAREHOOKSTRUCT, message, 4)
    TEST_FIELD_SIZE  (HARDWAREHOOKSTRUCT, wParam, 4)
    TEST_FIELD_ALIGN (HARDWAREHOOKSTRUCT, wParam, 4)
    TEST_FIELD_OFFSET(HARDWAREHOOKSTRUCT, wParam, 8)
    TEST_FIELD_SIZE  (HARDWAREHOOKSTRUCT, lParam, 4)
    TEST_FIELD_ALIGN (HARDWAREHOOKSTRUCT, lParam, 4)
    TEST_FIELD_OFFSET(HARDWAREHOOKSTRUCT, lParam, 12)
}

static void test_pack_HARDWAREINPUT(void)
{
    /* HARDWAREINPUT */
    TEST_TYPE_SIZE   (HARDWAREINPUT, 8)
    TEST_TYPE_ALIGN  (HARDWAREINPUT, 4)
    TEST_FIELD_SIZE  (HARDWAREINPUT, uMsg, 4)
    TEST_FIELD_ALIGN (HARDWAREINPUT, uMsg, 4)
    TEST_FIELD_OFFSET(HARDWAREINPUT, uMsg, 0)
    TEST_FIELD_SIZE  (HARDWAREINPUT, wParamL, 2)
    TEST_FIELD_ALIGN (HARDWAREINPUT, wParamL, 2)
    TEST_FIELD_OFFSET(HARDWAREINPUT, wParamL, 4)
    TEST_FIELD_SIZE  (HARDWAREINPUT, wParamH, 2)
    TEST_FIELD_ALIGN (HARDWAREINPUT, wParamH, 2)
    TEST_FIELD_OFFSET(HARDWAREINPUT, wParamH, 6)
}

static void test_pack_HDEVNOTIFY(void)
{
    /* HDEVNOTIFY */
    TEST_TYPE_SIZE   (HDEVNOTIFY, 4)
    TEST_TYPE_ALIGN  (HDEVNOTIFY, 4)
}

static void test_pack_HDWP(void)
{
    /* HDWP */
    TEST_TYPE_SIZE   (HDWP, 4)
    TEST_TYPE_ALIGN  (HDWP, 4)
}

static void test_pack_HELPINFO(void)
{
    /* HELPINFO */
    TEST_TYPE_SIZE   (HELPINFO, 28)
    TEST_TYPE_ALIGN  (HELPINFO, 4)
    TEST_FIELD_SIZE  (HELPINFO, cbSize, 4)
    TEST_FIELD_ALIGN (HELPINFO, cbSize, 4)
    TEST_FIELD_OFFSET(HELPINFO, cbSize, 0)
    TEST_FIELD_SIZE  (HELPINFO, iContextType, 4)
    TEST_FIELD_ALIGN (HELPINFO, iContextType, 4)
    TEST_FIELD_OFFSET(HELPINFO, iContextType, 4)
    TEST_FIELD_SIZE  (HELPINFO, iCtrlId, 4)
    TEST_FIELD_ALIGN (HELPINFO, iCtrlId, 4)
    TEST_FIELD_OFFSET(HELPINFO, iCtrlId, 8)
    TEST_FIELD_SIZE  (HELPINFO, hItemHandle, 4)
    TEST_FIELD_ALIGN (HELPINFO, hItemHandle, 4)
    TEST_FIELD_OFFSET(HELPINFO, hItemHandle, 12)
    TEST_FIELD_SIZE  (HELPINFO, dwContextId, 4)
    TEST_FIELD_ALIGN (HELPINFO, dwContextId, 4)
    TEST_FIELD_OFFSET(HELPINFO, dwContextId, 16)
    TEST_FIELD_SIZE  (HELPINFO, MousePos, 8)
    TEST_FIELD_ALIGN (HELPINFO, MousePos, 4)
    TEST_FIELD_OFFSET(HELPINFO, MousePos, 20)
}

static void test_pack_HELPWININFOA(void)
{
    /* HELPWININFOA */
    TEST_TYPE_SIZE   (HELPWININFOA, 28)
    TEST_TYPE_ALIGN  (HELPWININFOA, 4)
    TEST_FIELD_SIZE  (HELPWININFOA, wStructSize, 4)
    TEST_FIELD_ALIGN (HELPWININFOA, wStructSize, 4)
    TEST_FIELD_OFFSET(HELPWININFOA, wStructSize, 0)
    TEST_FIELD_SIZE  (HELPWININFOA, x, 4)
    TEST_FIELD_ALIGN (HELPWININFOA, x, 4)
    TEST_FIELD_OFFSET(HELPWININFOA, x, 4)
    TEST_FIELD_SIZE  (HELPWININFOA, y, 4)
    TEST_FIELD_ALIGN (HELPWININFOA, y, 4)
    TEST_FIELD_OFFSET(HELPWININFOA, y, 8)
    TEST_FIELD_SIZE  (HELPWININFOA, dx, 4)
    TEST_FIELD_ALIGN (HELPWININFOA, dx, 4)
    TEST_FIELD_OFFSET(HELPWININFOA, dx, 12)
    TEST_FIELD_SIZE  (HELPWININFOA, dy, 4)
    TEST_FIELD_ALIGN (HELPWININFOA, dy, 4)
    TEST_FIELD_OFFSET(HELPWININFOA, dy, 16)
    TEST_FIELD_SIZE  (HELPWININFOA, wMax, 4)
    TEST_FIELD_ALIGN (HELPWININFOA, wMax, 4)
    TEST_FIELD_OFFSET(HELPWININFOA, wMax, 20)
    TEST_FIELD_SIZE  (HELPWININFOA, rgchMember, 2)
    TEST_FIELD_ALIGN (HELPWININFOA, rgchMember, 1)
    TEST_FIELD_OFFSET(HELPWININFOA, rgchMember, 24)
}

static void test_pack_HELPWININFOW(void)
{
    /* HELPWININFOW */
    TEST_TYPE_SIZE   (HELPWININFOW, 28)
    TEST_TYPE_ALIGN  (HELPWININFOW, 4)
    TEST_FIELD_SIZE  (HELPWININFOW, wStructSize, 4)
    TEST_FIELD_ALIGN (HELPWININFOW, wStructSize, 4)
    TEST_FIELD_OFFSET(HELPWININFOW, wStructSize, 0)
    TEST_FIELD_SIZE  (HELPWININFOW, x, 4)
    TEST_FIELD_ALIGN (HELPWININFOW, x, 4)
    TEST_FIELD_OFFSET(HELPWININFOW, x, 4)
    TEST_FIELD_SIZE  (HELPWININFOW, y, 4)
    TEST_FIELD_ALIGN (HELPWININFOW, y, 4)
    TEST_FIELD_OFFSET(HELPWININFOW, y, 8)
    TEST_FIELD_SIZE  (HELPWININFOW, dx, 4)
    TEST_FIELD_ALIGN (HELPWININFOW, dx, 4)
    TEST_FIELD_OFFSET(HELPWININFOW, dx, 12)
    TEST_FIELD_SIZE  (HELPWININFOW, dy, 4)
    TEST_FIELD_ALIGN (HELPWININFOW, dy, 4)
    TEST_FIELD_OFFSET(HELPWININFOW, dy, 16)
    TEST_FIELD_SIZE  (HELPWININFOW, wMax, 4)
    TEST_FIELD_ALIGN (HELPWININFOW, wMax, 4)
    TEST_FIELD_OFFSET(HELPWININFOW, wMax, 20)
    TEST_FIELD_SIZE  (HELPWININFOW, rgchMember, 4)
    TEST_FIELD_ALIGN (HELPWININFOW, rgchMember, 2)
    TEST_FIELD_OFFSET(HELPWININFOW, rgchMember, 24)
}

static void test_pack_HIGHCONTRASTA(void)
{
    /* HIGHCONTRASTA */
    TEST_TYPE_SIZE   (HIGHCONTRASTA, 12)
    TEST_TYPE_ALIGN  (HIGHCONTRASTA, 4)
    TEST_FIELD_SIZE  (HIGHCONTRASTA, cbSize, 4)
    TEST_FIELD_ALIGN (HIGHCONTRASTA, cbSize, 4)
    TEST_FIELD_OFFSET(HIGHCONTRASTA, cbSize, 0)
    TEST_FIELD_SIZE  (HIGHCONTRASTA, dwFlags, 4)
    TEST_FIELD_ALIGN (HIGHCONTRASTA, dwFlags, 4)
    TEST_FIELD_OFFSET(HIGHCONTRASTA, dwFlags, 4)
    TEST_FIELD_SIZE  (HIGHCONTRASTA, lpszDefaultScheme, 4)
    TEST_FIELD_ALIGN (HIGHCONTRASTA, lpszDefaultScheme, 4)
    TEST_FIELD_OFFSET(HIGHCONTRASTA, lpszDefaultScheme, 8)
}

static void test_pack_HIGHCONTRASTW(void)
{
    /* HIGHCONTRASTW */
    TEST_TYPE_SIZE   (HIGHCONTRASTW, 12)
    TEST_TYPE_ALIGN  (HIGHCONTRASTW, 4)
    TEST_FIELD_SIZE  (HIGHCONTRASTW, cbSize, 4)
    TEST_FIELD_ALIGN (HIGHCONTRASTW, cbSize, 4)
    TEST_FIELD_OFFSET(HIGHCONTRASTW, cbSize, 0)
    TEST_FIELD_SIZE  (HIGHCONTRASTW, dwFlags, 4)
    TEST_FIELD_ALIGN (HIGHCONTRASTW, dwFlags, 4)
    TEST_FIELD_OFFSET(HIGHCONTRASTW, dwFlags, 4)
    TEST_FIELD_SIZE  (HIGHCONTRASTW, lpszDefaultScheme, 4)
    TEST_FIELD_ALIGN (HIGHCONTRASTW, lpszDefaultScheme, 4)
    TEST_FIELD_OFFSET(HIGHCONTRASTW, lpszDefaultScheme, 8)
}

static void test_pack_HOOKPROC(void)
{
    /* HOOKPROC */
    TEST_TYPE_SIZE   (HOOKPROC, 4)
    TEST_TYPE_ALIGN  (HOOKPROC, 4)
}

static void test_pack_ICONINFO(void)
{
    /* ICONINFO */
    TEST_TYPE_SIZE   (ICONINFO, 20)
    TEST_TYPE_ALIGN  (ICONINFO, 4)
    TEST_FIELD_SIZE  (ICONINFO, fIcon, 4)
    TEST_FIELD_ALIGN (ICONINFO, fIcon, 4)
    TEST_FIELD_OFFSET(ICONINFO, fIcon, 0)
    TEST_FIELD_SIZE  (ICONINFO, xHotspot, 4)
    TEST_FIELD_ALIGN (ICONINFO, xHotspot, 4)
    TEST_FIELD_OFFSET(ICONINFO, xHotspot, 4)
    TEST_FIELD_SIZE  (ICONINFO, yHotspot, 4)
    TEST_FIELD_ALIGN (ICONINFO, yHotspot, 4)
    TEST_FIELD_OFFSET(ICONINFO, yHotspot, 8)
    TEST_FIELD_SIZE  (ICONINFO, hbmMask, 4)
    TEST_FIELD_ALIGN (ICONINFO, hbmMask, 4)
    TEST_FIELD_OFFSET(ICONINFO, hbmMask, 12)
    TEST_FIELD_SIZE  (ICONINFO, hbmColor, 4)
    TEST_FIELD_ALIGN (ICONINFO, hbmColor, 4)
    TEST_FIELD_OFFSET(ICONINFO, hbmColor, 16)
}

static void test_pack_ICONMETRICSA(void)
{
    /* ICONMETRICSA */
    TEST_TYPE_SIZE   (ICONMETRICSA, 76)
    TEST_TYPE_ALIGN  (ICONMETRICSA, 4)
    TEST_FIELD_SIZE  (ICONMETRICSA, cbSize, 4)
    TEST_FIELD_ALIGN (ICONMETRICSA, cbSize, 4)
    TEST_FIELD_OFFSET(ICONMETRICSA, cbSize, 0)
    TEST_FIELD_SIZE  (ICONMETRICSA, iHorzSpacing, 4)
    TEST_FIELD_ALIGN (ICONMETRICSA, iHorzSpacing, 4)
    TEST_FIELD_OFFSET(ICONMETRICSA, iHorzSpacing, 4)
    TEST_FIELD_SIZE  (ICONMETRICSA, iVertSpacing, 4)
    TEST_FIELD_ALIGN (ICONMETRICSA, iVertSpacing, 4)
    TEST_FIELD_OFFSET(ICONMETRICSA, iVertSpacing, 8)
    TEST_FIELD_SIZE  (ICONMETRICSA, iTitleWrap, 4)
    TEST_FIELD_ALIGN (ICONMETRICSA, iTitleWrap, 4)
    TEST_FIELD_OFFSET(ICONMETRICSA, iTitleWrap, 12)
    TEST_FIELD_SIZE  (ICONMETRICSA, lfFont, 60)
    TEST_FIELD_ALIGN (ICONMETRICSA, lfFont, 4)
    TEST_FIELD_OFFSET(ICONMETRICSA, lfFont, 16)
}

static void test_pack_ICONMETRICSW(void)
{
    /* ICONMETRICSW */
    TEST_TYPE_SIZE   (ICONMETRICSW, 108)
    TEST_TYPE_ALIGN  (ICONMETRICSW, 4)
    TEST_FIELD_SIZE  (ICONMETRICSW, cbSize, 4)
    TEST_FIELD_ALIGN (ICONMETRICSW, cbSize, 4)
    TEST_FIELD_OFFSET(ICONMETRICSW, cbSize, 0)
    TEST_FIELD_SIZE  (ICONMETRICSW, iHorzSpacing, 4)
    TEST_FIELD_ALIGN (ICONMETRICSW, iHorzSpacing, 4)
    TEST_FIELD_OFFSET(ICONMETRICSW, iHorzSpacing, 4)
    TEST_FIELD_SIZE  (ICONMETRICSW, iVertSpacing, 4)
    TEST_FIELD_ALIGN (ICONMETRICSW, iVertSpacing, 4)
    TEST_FIELD_OFFSET(ICONMETRICSW, iVertSpacing, 8)
    TEST_FIELD_SIZE  (ICONMETRICSW, iTitleWrap, 4)
    TEST_FIELD_ALIGN (ICONMETRICSW, iTitleWrap, 4)
    TEST_FIELD_OFFSET(ICONMETRICSW, iTitleWrap, 12)
    TEST_FIELD_SIZE  (ICONMETRICSW, lfFont, 92)
    TEST_FIELD_ALIGN (ICONMETRICSW, lfFont, 4)
    TEST_FIELD_OFFSET(ICONMETRICSW, lfFont, 16)
}

static void test_pack_INPUT(void)
{
    /* INPUT */
    TEST_FIELD_SIZE  (INPUT, type, 4)
    TEST_FIELD_ALIGN (INPUT, type, 4)
    TEST_FIELD_OFFSET(INPUT, type, 0)
}

static void test_pack_KBDLLHOOKSTRUCT(void)
{
    /* KBDLLHOOKSTRUCT */
    TEST_TYPE_SIZE   (KBDLLHOOKSTRUCT, 20)
    TEST_TYPE_ALIGN  (KBDLLHOOKSTRUCT, 4)
    TEST_FIELD_SIZE  (KBDLLHOOKSTRUCT, vkCode, 4)
    TEST_FIELD_ALIGN (KBDLLHOOKSTRUCT, vkCode, 4)
    TEST_FIELD_OFFSET(KBDLLHOOKSTRUCT, vkCode, 0)
    TEST_FIELD_SIZE  (KBDLLHOOKSTRUCT, scanCode, 4)
    TEST_FIELD_ALIGN (KBDLLHOOKSTRUCT, scanCode, 4)
    TEST_FIELD_OFFSET(KBDLLHOOKSTRUCT, scanCode, 4)
    TEST_FIELD_SIZE  (KBDLLHOOKSTRUCT, flags, 4)
    TEST_FIELD_ALIGN (KBDLLHOOKSTRUCT, flags, 4)
    TEST_FIELD_OFFSET(KBDLLHOOKSTRUCT, flags, 8)
    TEST_FIELD_SIZE  (KBDLLHOOKSTRUCT, time, 4)
    TEST_FIELD_ALIGN (KBDLLHOOKSTRUCT, time, 4)
    TEST_FIELD_OFFSET(KBDLLHOOKSTRUCT, time, 12)
    TEST_FIELD_SIZE  (KBDLLHOOKSTRUCT, dwExtraInfo, 4)
    TEST_FIELD_ALIGN (KBDLLHOOKSTRUCT, dwExtraInfo, 4)
    TEST_FIELD_OFFSET(KBDLLHOOKSTRUCT, dwExtraInfo, 16)
}

static void test_pack_KEYBDINPUT(void)
{
    /* KEYBDINPUT */
    TEST_TYPE_SIZE   (KEYBDINPUT, 16)
    TEST_TYPE_ALIGN  (KEYBDINPUT, 4)
    TEST_FIELD_SIZE  (KEYBDINPUT, wVk, 2)
    TEST_FIELD_ALIGN (KEYBDINPUT, wVk, 2)
    TEST_FIELD_OFFSET(KEYBDINPUT, wVk, 0)
    TEST_FIELD_SIZE  (KEYBDINPUT, wScan, 2)
    TEST_FIELD_ALIGN (KEYBDINPUT, wScan, 2)
    TEST_FIELD_OFFSET(KEYBDINPUT, wScan, 2)
    TEST_FIELD_SIZE  (KEYBDINPUT, dwFlags, 4)
    TEST_FIELD_ALIGN (KEYBDINPUT, dwFlags, 4)
    TEST_FIELD_OFFSET(KEYBDINPUT, dwFlags, 4)
    TEST_FIELD_SIZE  (KEYBDINPUT, time, 4)
    TEST_FIELD_ALIGN (KEYBDINPUT, time, 4)
    TEST_FIELD_OFFSET(KEYBDINPUT, time, 8)
    TEST_FIELD_SIZE  (KEYBDINPUT, dwExtraInfo, 4)
    TEST_FIELD_ALIGN (KEYBDINPUT, dwExtraInfo, 4)
    TEST_FIELD_OFFSET(KEYBDINPUT, dwExtraInfo, 12)
}

static void test_pack_LPACCESSTIMEOUT(void)
{
    /* LPACCESSTIMEOUT */
    TEST_TYPE_SIZE   (LPACCESSTIMEOUT, 4)
    TEST_TYPE_ALIGN  (LPACCESSTIMEOUT, 4)
    TEST_TARGET_SIZE (LPACCESSTIMEOUT, 12)
    TEST_TARGET_ALIGN(LPACCESSTIMEOUT, 4)
}

static void test_pack_LPANIMATIONINFO(void)
{
    /* LPANIMATIONINFO */
    TEST_TYPE_SIZE   (LPANIMATIONINFO, 4)
    TEST_TYPE_ALIGN  (LPANIMATIONINFO, 4)
    TEST_TARGET_SIZE (LPANIMATIONINFO, 8)
    TEST_TARGET_ALIGN(LPANIMATIONINFO, 4)
}

static void test_pack_LPCBTACTIVATESTRUCT(void)
{
    /* LPCBTACTIVATESTRUCT */
    TEST_TYPE_SIZE   (LPCBTACTIVATESTRUCT, 4)
    TEST_TYPE_ALIGN  (LPCBTACTIVATESTRUCT, 4)
    TEST_TARGET_SIZE (LPCBTACTIVATESTRUCT, 8)
    TEST_TARGET_ALIGN(LPCBTACTIVATESTRUCT, 4)
}

static void test_pack_LPCBT_CREATEWNDA(void)
{
    /* LPCBT_CREATEWNDA */
    TEST_TYPE_SIZE   (LPCBT_CREATEWNDA, 4)
    TEST_TYPE_ALIGN  (LPCBT_CREATEWNDA, 4)
    TEST_TARGET_SIZE (LPCBT_CREATEWNDA, 8)
    TEST_TARGET_ALIGN(LPCBT_CREATEWNDA, 4)
}

static void test_pack_LPCBT_CREATEWNDW(void)
{
    /* LPCBT_CREATEWNDW */
    TEST_TYPE_SIZE   (LPCBT_CREATEWNDW, 4)
    TEST_TYPE_ALIGN  (LPCBT_CREATEWNDW, 4)
    TEST_TARGET_SIZE (LPCBT_CREATEWNDW, 8)
    TEST_TARGET_ALIGN(LPCBT_CREATEWNDW, 4)
}

static void test_pack_LPCDLGTEMPLATEA(void)
{
    /* LPCDLGTEMPLATEA */
    TEST_TYPE_SIZE   (LPCDLGTEMPLATEA, 4)
    TEST_TYPE_ALIGN  (LPCDLGTEMPLATEA, 4)
    TEST_TARGET_SIZE (LPCDLGTEMPLATEA, 18)
    TEST_TARGET_ALIGN(LPCDLGTEMPLATEA, 2)
}

static void test_pack_LPCDLGTEMPLATEW(void)
{
    /* LPCDLGTEMPLATEW */
    TEST_TYPE_SIZE   (LPCDLGTEMPLATEW, 4)
    TEST_TYPE_ALIGN  (LPCDLGTEMPLATEW, 4)
    TEST_TARGET_SIZE (LPCDLGTEMPLATEW, 18)
    TEST_TARGET_ALIGN(LPCDLGTEMPLATEW, 2)
}

static void test_pack_LPCLIENTCREATESTRUCT(void)
{
    /* LPCLIENTCREATESTRUCT */
    TEST_TYPE_SIZE   (LPCLIENTCREATESTRUCT, 4)
    TEST_TYPE_ALIGN  (LPCLIENTCREATESTRUCT, 4)
    TEST_TARGET_SIZE (LPCLIENTCREATESTRUCT, 8)
    TEST_TARGET_ALIGN(LPCLIENTCREATESTRUCT, 4)
}

static void test_pack_LPCMENUINFO(void)
{
    /* LPCMENUINFO */
    TEST_TYPE_SIZE   (LPCMENUINFO, 4)
    TEST_TYPE_ALIGN  (LPCMENUINFO, 4)
    TEST_TARGET_SIZE (LPCMENUINFO, 28)
    TEST_TARGET_ALIGN(LPCMENUINFO, 4)
}

static void test_pack_LPCMENUITEMINFOA(void)
{
    /* LPCMENUITEMINFOA */
    TEST_TYPE_SIZE   (LPCMENUITEMINFOA, 4)
    TEST_TYPE_ALIGN  (LPCMENUITEMINFOA, 4)
    TEST_TARGET_SIZE (LPCMENUITEMINFOA, 48)
    TEST_TARGET_ALIGN(LPCMENUITEMINFOA, 4)
}

static void test_pack_LPCMENUITEMINFOW(void)
{
    /* LPCMENUITEMINFOW */
    TEST_TYPE_SIZE   (LPCMENUITEMINFOW, 4)
    TEST_TYPE_ALIGN  (LPCMENUITEMINFOW, 4)
    TEST_TARGET_SIZE (LPCMENUITEMINFOW, 48)
    TEST_TARGET_ALIGN(LPCMENUITEMINFOW, 4)
}

static void test_pack_LPCOMBOBOXINFO(void)
{
    /* LPCOMBOBOXINFO */
    TEST_TYPE_SIZE   (LPCOMBOBOXINFO, 4)
    TEST_TYPE_ALIGN  (LPCOMBOBOXINFO, 4)
    TEST_TARGET_SIZE (LPCOMBOBOXINFO, 52)
    TEST_TARGET_ALIGN(LPCOMBOBOXINFO, 4)
}

static void test_pack_LPCOMPAREITEMSTRUCT(void)
{
    /* LPCOMPAREITEMSTRUCT */
    TEST_TYPE_SIZE   (LPCOMPAREITEMSTRUCT, 4)
    TEST_TYPE_ALIGN  (LPCOMPAREITEMSTRUCT, 4)
    TEST_TARGET_SIZE (LPCOMPAREITEMSTRUCT, 32)
    TEST_TARGET_ALIGN(LPCOMPAREITEMSTRUCT, 4)
}

static void test_pack_LPCREATESTRUCTA(void)
{
    /* LPCREATESTRUCTA */
    TEST_TYPE_SIZE   (LPCREATESTRUCTA, 4)
    TEST_TYPE_ALIGN  (LPCREATESTRUCTA, 4)
    TEST_TARGET_SIZE (LPCREATESTRUCTA, 48)
    TEST_TARGET_ALIGN(LPCREATESTRUCTA, 4)
}

static void test_pack_LPCREATESTRUCTW(void)
{
    /* LPCREATESTRUCTW */
    TEST_TYPE_SIZE   (LPCREATESTRUCTW, 4)
    TEST_TYPE_ALIGN  (LPCREATESTRUCTW, 4)
    TEST_TARGET_SIZE (LPCREATESTRUCTW, 48)
    TEST_TARGET_ALIGN(LPCREATESTRUCTW, 4)
}

static void test_pack_LPCSCROLLINFO(void)
{
    /* LPCSCROLLINFO */
    TEST_TYPE_SIZE   (LPCSCROLLINFO, 4)
    TEST_TYPE_ALIGN  (LPCSCROLLINFO, 4)
    TEST_TARGET_SIZE (LPCSCROLLINFO, 28)
    TEST_TARGET_ALIGN(LPCSCROLLINFO, 4)
}

static void test_pack_LPCURSORINFO(void)
{
    /* LPCURSORINFO */
    TEST_TYPE_SIZE   (LPCURSORINFO, 4)
    TEST_TYPE_ALIGN  (LPCURSORINFO, 4)
    TEST_TARGET_SIZE (LPCURSORINFO, 20)
    TEST_TARGET_ALIGN(LPCURSORINFO, 4)
}

static void test_pack_LPCWPRETSTRUCT(void)
{
    /* LPCWPRETSTRUCT */
    TEST_TYPE_SIZE   (LPCWPRETSTRUCT, 4)
    TEST_TYPE_ALIGN  (LPCWPRETSTRUCT, 4)
    TEST_TARGET_SIZE (LPCWPRETSTRUCT, 20)
    TEST_TARGET_ALIGN(LPCWPRETSTRUCT, 4)
}

static void test_pack_LPCWPSTRUCT(void)
{
    /* LPCWPSTRUCT */
    TEST_TYPE_SIZE   (LPCWPSTRUCT, 4)
    TEST_TYPE_ALIGN  (LPCWPSTRUCT, 4)
    TEST_TARGET_SIZE (LPCWPSTRUCT, 16)
    TEST_TARGET_ALIGN(LPCWPSTRUCT, 4)
}

static void test_pack_LPDEBUGHOOKINFO(void)
{
    /* LPDEBUGHOOKINFO */
    TEST_TYPE_SIZE   (LPDEBUGHOOKINFO, 4)
    TEST_TYPE_ALIGN  (LPDEBUGHOOKINFO, 4)
    TEST_TARGET_SIZE (LPDEBUGHOOKINFO, 20)
    TEST_TARGET_ALIGN(LPDEBUGHOOKINFO, 4)
}

static void test_pack_LPDELETEITEMSTRUCT(void)
{
    /* LPDELETEITEMSTRUCT */
    TEST_TYPE_SIZE   (LPDELETEITEMSTRUCT, 4)
    TEST_TYPE_ALIGN  (LPDELETEITEMSTRUCT, 4)
    TEST_TARGET_SIZE (LPDELETEITEMSTRUCT, 20)
    TEST_TARGET_ALIGN(LPDELETEITEMSTRUCT, 4)
}

static void test_pack_LPDLGITEMTEMPLATEA(void)
{
    /* LPDLGITEMTEMPLATEA */
    TEST_TYPE_SIZE   (LPDLGITEMTEMPLATEA, 4)
    TEST_TYPE_ALIGN  (LPDLGITEMTEMPLATEA, 4)
    TEST_TARGET_SIZE (LPDLGITEMTEMPLATEA, 18)
    TEST_TARGET_ALIGN(LPDLGITEMTEMPLATEA, 2)
}

static void test_pack_LPDLGITEMTEMPLATEW(void)
{
    /* LPDLGITEMTEMPLATEW */
    TEST_TYPE_SIZE   (LPDLGITEMTEMPLATEW, 4)
    TEST_TYPE_ALIGN  (LPDLGITEMTEMPLATEW, 4)
    TEST_TARGET_SIZE (LPDLGITEMTEMPLATEW, 18)
    TEST_TARGET_ALIGN(LPDLGITEMTEMPLATEW, 2)
}

static void test_pack_LPDLGTEMPLATEA(void)
{
    /* LPDLGTEMPLATEA */
    TEST_TYPE_SIZE   (LPDLGTEMPLATEA, 4)
    TEST_TYPE_ALIGN  (LPDLGTEMPLATEA, 4)
    TEST_TARGET_SIZE (LPDLGTEMPLATEA, 18)
    TEST_TARGET_ALIGN(LPDLGTEMPLATEA, 2)
}

static void test_pack_LPDLGTEMPLATEW(void)
{
    /* LPDLGTEMPLATEW */
    TEST_TYPE_SIZE   (LPDLGTEMPLATEW, 4)
    TEST_TYPE_ALIGN  (LPDLGTEMPLATEW, 4)
    TEST_TARGET_SIZE (LPDLGTEMPLATEW, 18)
    TEST_TARGET_ALIGN(LPDLGTEMPLATEW, 2)
}

static void test_pack_LPDRAWITEMSTRUCT(void)
{
    /* LPDRAWITEMSTRUCT */
    TEST_TYPE_SIZE   (LPDRAWITEMSTRUCT, 4)
    TEST_TYPE_ALIGN  (LPDRAWITEMSTRUCT, 4)
    TEST_TARGET_SIZE (LPDRAWITEMSTRUCT, 48)
    TEST_TARGET_ALIGN(LPDRAWITEMSTRUCT, 4)
}

static void test_pack_LPDRAWTEXTPARAMS(void)
{
    /* LPDRAWTEXTPARAMS */
    TEST_TYPE_SIZE   (LPDRAWTEXTPARAMS, 4)
    TEST_TYPE_ALIGN  (LPDRAWTEXTPARAMS, 4)
    TEST_TARGET_SIZE (LPDRAWTEXTPARAMS, 20)
    TEST_TARGET_ALIGN(LPDRAWTEXTPARAMS, 4)
}

static void test_pack_LPEVENTMSG(void)
{
    /* LPEVENTMSG */
    TEST_TYPE_SIZE   (LPEVENTMSG, 4)
    TEST_TYPE_ALIGN  (LPEVENTMSG, 4)
    TEST_TARGET_SIZE (LPEVENTMSG, 20)
    TEST_TARGET_ALIGN(LPEVENTMSG, 4)
}

static void test_pack_LPFILTERKEYS(void)
{
    /* LPFILTERKEYS */
    TEST_TYPE_SIZE   (LPFILTERKEYS, 4)
    TEST_TYPE_ALIGN  (LPFILTERKEYS, 4)
    TEST_TARGET_SIZE (LPFILTERKEYS, 24)
    TEST_TARGET_ALIGN(LPFILTERKEYS, 4)
}

static void test_pack_LPGUITHREADINFO(void)
{
    /* LPGUITHREADINFO */
    TEST_TYPE_SIZE   (LPGUITHREADINFO, 4)
    TEST_TYPE_ALIGN  (LPGUITHREADINFO, 4)
    TEST_TARGET_SIZE (LPGUITHREADINFO, 48)
    TEST_TARGET_ALIGN(LPGUITHREADINFO, 4)
}

static void test_pack_LPHARDWAREHOOKSTRUCT(void)
{
    /* LPHARDWAREHOOKSTRUCT */
    TEST_TYPE_SIZE   (LPHARDWAREHOOKSTRUCT, 4)
    TEST_TYPE_ALIGN  (LPHARDWAREHOOKSTRUCT, 4)
    TEST_TARGET_SIZE (LPHARDWAREHOOKSTRUCT, 16)
    TEST_TARGET_ALIGN(LPHARDWAREHOOKSTRUCT, 4)
}

static void test_pack_LPHARDWAREINPUT(void)
{
    /* LPHARDWAREINPUT */
    TEST_TYPE_SIZE   (LPHARDWAREINPUT, 4)
    TEST_TYPE_ALIGN  (LPHARDWAREINPUT, 4)
    TEST_TARGET_SIZE (LPHARDWAREINPUT, 8)
    TEST_TARGET_ALIGN(LPHARDWAREINPUT, 4)
}

static void test_pack_LPHELPINFO(void)
{
    /* LPHELPINFO */
    TEST_TYPE_SIZE   (LPHELPINFO, 4)
    TEST_TYPE_ALIGN  (LPHELPINFO, 4)
    TEST_TARGET_SIZE (LPHELPINFO, 28)
    TEST_TARGET_ALIGN(LPHELPINFO, 4)
}

static void test_pack_LPHELPWININFOA(void)
{
    /* LPHELPWININFOA */
    TEST_TYPE_SIZE   (LPHELPWININFOA, 4)
    TEST_TYPE_ALIGN  (LPHELPWININFOA, 4)
    TEST_TARGET_SIZE (LPHELPWININFOA, 28)
    TEST_TARGET_ALIGN(LPHELPWININFOA, 4)
}

static void test_pack_LPHELPWININFOW(void)
{
    /* LPHELPWININFOW */
    TEST_TYPE_SIZE   (LPHELPWININFOW, 4)
    TEST_TYPE_ALIGN  (LPHELPWININFOW, 4)
    TEST_TARGET_SIZE (LPHELPWININFOW, 28)
    TEST_TARGET_ALIGN(LPHELPWININFOW, 4)
}

static void test_pack_LPHIGHCONTRASTA(void)
{
    /* LPHIGHCONTRASTA */
    TEST_TYPE_SIZE   (LPHIGHCONTRASTA, 4)
    TEST_TYPE_ALIGN  (LPHIGHCONTRASTA, 4)
    TEST_TARGET_SIZE (LPHIGHCONTRASTA, 12)
    TEST_TARGET_ALIGN(LPHIGHCONTRASTA, 4)
}

static void test_pack_LPHIGHCONTRASTW(void)
{
    /* LPHIGHCONTRASTW */
    TEST_TYPE_SIZE   (LPHIGHCONTRASTW, 4)
    TEST_TYPE_ALIGN  (LPHIGHCONTRASTW, 4)
    TEST_TARGET_SIZE (LPHIGHCONTRASTW, 12)
    TEST_TARGET_ALIGN(LPHIGHCONTRASTW, 4)
}

static void test_pack_LPICONMETRICSA(void)
{
    /* LPICONMETRICSA */
    TEST_TYPE_SIZE   (LPICONMETRICSA, 4)
    TEST_TYPE_ALIGN  (LPICONMETRICSA, 4)
    TEST_TARGET_SIZE (LPICONMETRICSA, 76)
    TEST_TARGET_ALIGN(LPICONMETRICSA, 4)
}

static void test_pack_LPICONMETRICSW(void)
{
    /* LPICONMETRICSW */
    TEST_TYPE_SIZE   (LPICONMETRICSW, 4)
    TEST_TYPE_ALIGN  (LPICONMETRICSW, 4)
    TEST_TARGET_SIZE (LPICONMETRICSW, 108)
    TEST_TARGET_ALIGN(LPICONMETRICSW, 4)
}

static void test_pack_LPINPUT(void)
{
    /* LPINPUT */
    TEST_TYPE_SIZE   (LPINPUT, 4)
    TEST_TYPE_ALIGN  (LPINPUT, 4)
}

static void test_pack_LPKBDLLHOOKSTRUCT(void)
{
    /* LPKBDLLHOOKSTRUCT */
    TEST_TYPE_SIZE   (LPKBDLLHOOKSTRUCT, 4)
    TEST_TYPE_ALIGN  (LPKBDLLHOOKSTRUCT, 4)
    TEST_TARGET_SIZE (LPKBDLLHOOKSTRUCT, 20)
    TEST_TARGET_ALIGN(LPKBDLLHOOKSTRUCT, 4)
}

static void test_pack_LPKEYBDINPUT(void)
{
    /* LPKEYBDINPUT */
    TEST_TYPE_SIZE   (LPKEYBDINPUT, 4)
    TEST_TYPE_ALIGN  (LPKEYBDINPUT, 4)
    TEST_TARGET_SIZE (LPKEYBDINPUT, 16)
    TEST_TARGET_ALIGN(LPKEYBDINPUT, 4)
}

static void test_pack_LPMDICREATESTRUCTA(void)
{
    /* LPMDICREATESTRUCTA */
    TEST_TYPE_SIZE   (LPMDICREATESTRUCTA, 4)
    TEST_TYPE_ALIGN  (LPMDICREATESTRUCTA, 4)
    TEST_TARGET_SIZE (LPMDICREATESTRUCTA, 36)
    TEST_TARGET_ALIGN(LPMDICREATESTRUCTA, 4)
}

static void test_pack_LPMDICREATESTRUCTW(void)
{
    /* LPMDICREATESTRUCTW */
    TEST_TYPE_SIZE   (LPMDICREATESTRUCTW, 4)
    TEST_TYPE_ALIGN  (LPMDICREATESTRUCTW, 4)
    TEST_TARGET_SIZE (LPMDICREATESTRUCTW, 36)
    TEST_TARGET_ALIGN(LPMDICREATESTRUCTW, 4)
}

static void test_pack_LPMDINEXTMENU(void)
{
    /* LPMDINEXTMENU */
    TEST_TYPE_SIZE   (LPMDINEXTMENU, 4)
    TEST_TYPE_ALIGN  (LPMDINEXTMENU, 4)
    TEST_TARGET_SIZE (LPMDINEXTMENU, 12)
    TEST_TARGET_ALIGN(LPMDINEXTMENU, 4)
}

static void test_pack_LPMEASUREITEMSTRUCT(void)
{
    /* LPMEASUREITEMSTRUCT */
    TEST_TYPE_SIZE   (LPMEASUREITEMSTRUCT, 4)
    TEST_TYPE_ALIGN  (LPMEASUREITEMSTRUCT, 4)
    TEST_TARGET_SIZE (LPMEASUREITEMSTRUCT, 24)
    TEST_TARGET_ALIGN(LPMEASUREITEMSTRUCT, 4)
}

static void test_pack_LPMENUINFO(void)
{
    /* LPMENUINFO */
    TEST_TYPE_SIZE   (LPMENUINFO, 4)
    TEST_TYPE_ALIGN  (LPMENUINFO, 4)
    TEST_TARGET_SIZE (LPMENUINFO, 28)
    TEST_TARGET_ALIGN(LPMENUINFO, 4)
}

static void test_pack_LPMENUITEMINFOA(void)
{
    /* LPMENUITEMINFOA */
    TEST_TYPE_SIZE   (LPMENUITEMINFOA, 4)
    TEST_TYPE_ALIGN  (LPMENUITEMINFOA, 4)
    TEST_TARGET_SIZE (LPMENUITEMINFOA, 48)
    TEST_TARGET_ALIGN(LPMENUITEMINFOA, 4)
}

static void test_pack_LPMENUITEMINFOW(void)
{
    /* LPMENUITEMINFOW */
    TEST_TYPE_SIZE   (LPMENUITEMINFOW, 4)
    TEST_TYPE_ALIGN  (LPMENUITEMINFOW, 4)
    TEST_TARGET_SIZE (LPMENUITEMINFOW, 48)
    TEST_TARGET_ALIGN(LPMENUITEMINFOW, 4)
}

static void test_pack_LPMINIMIZEDMETRICS(void)
{
    /* LPMINIMIZEDMETRICS */
    TEST_TYPE_SIZE   (LPMINIMIZEDMETRICS, 4)
    TEST_TYPE_ALIGN  (LPMINIMIZEDMETRICS, 4)
    TEST_TARGET_SIZE (LPMINIMIZEDMETRICS, 20)
    TEST_TARGET_ALIGN(LPMINIMIZEDMETRICS, 4)
}

static void test_pack_LPMINMAXINFO(void)
{
    /* LPMINMAXINFO */
    TEST_TYPE_SIZE   (LPMINMAXINFO, 4)
    TEST_TYPE_ALIGN  (LPMINMAXINFO, 4)
    TEST_TARGET_SIZE (LPMINMAXINFO, 40)
    TEST_TARGET_ALIGN(LPMINMAXINFO, 4)
}

static void test_pack_LPMONITORINFO(void)
{
    /* LPMONITORINFO */
    TEST_TYPE_SIZE   (LPMONITORINFO, 4)
    TEST_TYPE_ALIGN  (LPMONITORINFO, 4)
    TEST_TARGET_SIZE (LPMONITORINFO, 40)
    TEST_TARGET_ALIGN(LPMONITORINFO, 4)
}

static void test_pack_LPMONITORINFOEXA(void)
{
    /* LPMONITORINFOEXA */
    TEST_TYPE_SIZE   (LPMONITORINFOEXA, 4)
    TEST_TYPE_ALIGN  (LPMONITORINFOEXA, 4)
    TEST_TARGET_SIZE (LPMONITORINFOEXA, 72)
    TEST_TARGET_ALIGN(LPMONITORINFOEXA, 4)
}

static void test_pack_LPMONITORINFOEXW(void)
{
    /* LPMONITORINFOEXW */
    TEST_TYPE_SIZE   (LPMONITORINFOEXW, 4)
    TEST_TYPE_ALIGN  (LPMONITORINFOEXW, 4)
    TEST_TARGET_SIZE (LPMONITORINFOEXW, 104)
    TEST_TARGET_ALIGN(LPMONITORINFOEXW, 4)
}

static void test_pack_LPMOUSEHOOKSTRUCT(void)
{
    /* LPMOUSEHOOKSTRUCT */
    TEST_TYPE_SIZE   (LPMOUSEHOOKSTRUCT, 4)
    TEST_TYPE_ALIGN  (LPMOUSEHOOKSTRUCT, 4)
    TEST_TARGET_SIZE (LPMOUSEHOOKSTRUCT, 20)
    TEST_TARGET_ALIGN(LPMOUSEHOOKSTRUCT, 4)
}

static void test_pack_LPMOUSEINPUT(void)
{
    /* LPMOUSEINPUT */
    TEST_TYPE_SIZE   (LPMOUSEINPUT, 4)
    TEST_TYPE_ALIGN  (LPMOUSEINPUT, 4)
    TEST_TARGET_SIZE (LPMOUSEINPUT, 24)
    TEST_TARGET_ALIGN(LPMOUSEINPUT, 4)
}

static void test_pack_LPMOUSEKEYS(void)
{
    /* LPMOUSEKEYS */
    TEST_TYPE_SIZE   (LPMOUSEKEYS, 4)
    TEST_TYPE_ALIGN  (LPMOUSEKEYS, 4)
    TEST_TARGET_SIZE (LPMOUSEKEYS, 28)
    TEST_TARGET_ALIGN(LPMOUSEKEYS, 4)
}

static void test_pack_LPMSG(void)
{
    /* LPMSG */
    TEST_TYPE_SIZE   (LPMSG, 4)
    TEST_TYPE_ALIGN  (LPMSG, 4)
    TEST_TARGET_SIZE (LPMSG, 28)
    TEST_TARGET_ALIGN(LPMSG, 4)
}

static void test_pack_LPMSGBOXPARAMSA(void)
{
    /* LPMSGBOXPARAMSA */
    TEST_TYPE_SIZE   (LPMSGBOXPARAMSA, 4)
    TEST_TYPE_ALIGN  (LPMSGBOXPARAMSA, 4)
    TEST_TARGET_SIZE (LPMSGBOXPARAMSA, 40)
    TEST_TARGET_ALIGN(LPMSGBOXPARAMSA, 4)
}

static void test_pack_LPMSGBOXPARAMSW(void)
{
    /* LPMSGBOXPARAMSW */
    TEST_TYPE_SIZE   (LPMSGBOXPARAMSW, 4)
    TEST_TYPE_ALIGN  (LPMSGBOXPARAMSW, 4)
    TEST_TARGET_SIZE (LPMSGBOXPARAMSW, 40)
    TEST_TARGET_ALIGN(LPMSGBOXPARAMSW, 4)
}

static void test_pack_LPMSLLHOOKSTRUCT(void)
{
    /* LPMSLLHOOKSTRUCT */
    TEST_TYPE_SIZE   (LPMSLLHOOKSTRUCT, 4)
    TEST_TYPE_ALIGN  (LPMSLLHOOKSTRUCT, 4)
    TEST_TARGET_SIZE (LPMSLLHOOKSTRUCT, 24)
    TEST_TARGET_ALIGN(LPMSLLHOOKSTRUCT, 4)
}

static void test_pack_LPMULTIKEYHELPA(void)
{
    /* LPMULTIKEYHELPA */
    TEST_TYPE_SIZE   (LPMULTIKEYHELPA, 4)
    TEST_TYPE_ALIGN  (LPMULTIKEYHELPA, 4)
    TEST_TARGET_SIZE (LPMULTIKEYHELPA, 8)
    TEST_TARGET_ALIGN(LPMULTIKEYHELPA, 4)
}

static void test_pack_LPMULTIKEYHELPW(void)
{
    /* LPMULTIKEYHELPW */
    TEST_TYPE_SIZE   (LPMULTIKEYHELPW, 4)
    TEST_TYPE_ALIGN  (LPMULTIKEYHELPW, 4)
    TEST_TARGET_SIZE (LPMULTIKEYHELPW, 8)
    TEST_TARGET_ALIGN(LPMULTIKEYHELPW, 4)
}

static void test_pack_LPNCCALCSIZE_PARAMS(void)
{
    /* LPNCCALCSIZE_PARAMS */
    TEST_TYPE_SIZE   (LPNCCALCSIZE_PARAMS, 4)
    TEST_TYPE_ALIGN  (LPNCCALCSIZE_PARAMS, 4)
    TEST_TARGET_SIZE (LPNCCALCSIZE_PARAMS, 52)
    TEST_TARGET_ALIGN(LPNCCALCSIZE_PARAMS, 4)
}

static void test_pack_LPNMHDR(void)
{
    /* LPNMHDR */
    TEST_TYPE_SIZE   (LPNMHDR, 4)
    TEST_TYPE_ALIGN  (LPNMHDR, 4)
    TEST_TARGET_SIZE (LPNMHDR, 12)
    TEST_TARGET_ALIGN(LPNMHDR, 4)
}

static void test_pack_LPNONCLIENTMETRICSA(void)
{
    /* LPNONCLIENTMETRICSA */
    TEST_TYPE_SIZE   (LPNONCLIENTMETRICSA, 4)
    TEST_TYPE_ALIGN  (LPNONCLIENTMETRICSA, 4)
    TEST_TARGET_SIZE (LPNONCLIENTMETRICSA, 340)
    TEST_TARGET_ALIGN(LPNONCLIENTMETRICSA, 4)
}

static void test_pack_LPNONCLIENTMETRICSW(void)
{
    /* LPNONCLIENTMETRICSW */
    TEST_TYPE_SIZE   (LPNONCLIENTMETRICSW, 4)
    TEST_TYPE_ALIGN  (LPNONCLIENTMETRICSW, 4)
    TEST_TARGET_SIZE (LPNONCLIENTMETRICSW, 500)
    TEST_TARGET_ALIGN(LPNONCLIENTMETRICSW, 4)
}

static void test_pack_LPPAINTSTRUCT(void)
{
    /* LPPAINTSTRUCT */
    TEST_TYPE_SIZE   (LPPAINTSTRUCT, 4)
    TEST_TYPE_ALIGN  (LPPAINTSTRUCT, 4)
    TEST_TARGET_SIZE (LPPAINTSTRUCT, 64)
    TEST_TARGET_ALIGN(LPPAINTSTRUCT, 4)
}

static void test_pack_LPSCROLLINFO(void)
{
    /* LPSCROLLINFO */
    TEST_TYPE_SIZE   (LPSCROLLINFO, 4)
    TEST_TYPE_ALIGN  (LPSCROLLINFO, 4)
    TEST_TARGET_SIZE (LPSCROLLINFO, 28)
    TEST_TARGET_ALIGN(LPSCROLLINFO, 4)
}

static void test_pack_LPSERIALKEYSA(void)
{
    /* LPSERIALKEYSA */
    TEST_TYPE_SIZE   (LPSERIALKEYSA, 4)
    TEST_TYPE_ALIGN  (LPSERIALKEYSA, 4)
    TEST_TARGET_SIZE (LPSERIALKEYSA, 28)
    TEST_TARGET_ALIGN(LPSERIALKEYSA, 4)
}

static void test_pack_LPSERIALKEYSW(void)
{
    /* LPSERIALKEYSW */
    TEST_TYPE_SIZE   (LPSERIALKEYSW, 4)
    TEST_TYPE_ALIGN  (LPSERIALKEYSW, 4)
    TEST_TARGET_SIZE (LPSERIALKEYSW, 28)
    TEST_TARGET_ALIGN(LPSERIALKEYSW, 4)
}

static void test_pack_LPSOUNDSENTRYA(void)
{
    /* LPSOUNDSENTRYA */
    TEST_TYPE_SIZE   (LPSOUNDSENTRYA, 4)
    TEST_TYPE_ALIGN  (LPSOUNDSENTRYA, 4)
    TEST_TARGET_SIZE (LPSOUNDSENTRYA, 48)
    TEST_TARGET_ALIGN(LPSOUNDSENTRYA, 4)
}

static void test_pack_LPSOUNDSENTRYW(void)
{
    /* LPSOUNDSENTRYW */
    TEST_TYPE_SIZE   (LPSOUNDSENTRYW, 4)
    TEST_TYPE_ALIGN  (LPSOUNDSENTRYW, 4)
    TEST_TARGET_SIZE (LPSOUNDSENTRYW, 48)
    TEST_TARGET_ALIGN(LPSOUNDSENTRYW, 4)
}

static void test_pack_LPSTICKYKEYS(void)
{
    /* LPSTICKYKEYS */
    TEST_TYPE_SIZE   (LPSTICKYKEYS, 4)
    TEST_TYPE_ALIGN  (LPSTICKYKEYS, 4)
    TEST_TARGET_SIZE (LPSTICKYKEYS, 8)
    TEST_TARGET_ALIGN(LPSTICKYKEYS, 4)
}

static void test_pack_LPSTYLESTRUCT(void)
{
    /* LPSTYLESTRUCT */
    TEST_TYPE_SIZE   (LPSTYLESTRUCT, 4)
    TEST_TYPE_ALIGN  (LPSTYLESTRUCT, 4)
    TEST_TARGET_SIZE (LPSTYLESTRUCT, 8)
    TEST_TARGET_ALIGN(LPSTYLESTRUCT, 4)
}

static void test_pack_LPTITLEBARINFO(void)
{
    /* LPTITLEBARINFO */
    TEST_TYPE_SIZE   (LPTITLEBARINFO, 4)
    TEST_TYPE_ALIGN  (LPTITLEBARINFO, 4)
    TEST_TARGET_SIZE (LPTITLEBARINFO, 44)
    TEST_TARGET_ALIGN(LPTITLEBARINFO, 4)
}

static void test_pack_LPTOGGLEKEYS(void)
{
    /* LPTOGGLEKEYS */
    TEST_TYPE_SIZE   (LPTOGGLEKEYS, 4)
    TEST_TYPE_ALIGN  (LPTOGGLEKEYS, 4)
    TEST_TARGET_SIZE (LPTOGGLEKEYS, 8)
    TEST_TARGET_ALIGN(LPTOGGLEKEYS, 4)
}

static void test_pack_LPTPMPARAMS(void)
{
    /* LPTPMPARAMS */
    TEST_TYPE_SIZE   (LPTPMPARAMS, 4)
    TEST_TYPE_ALIGN  (LPTPMPARAMS, 4)
    TEST_TARGET_SIZE (LPTPMPARAMS, 20)
    TEST_TARGET_ALIGN(LPTPMPARAMS, 4)
}

static void test_pack_LPTRACKMOUSEEVENT(void)
{
    /* LPTRACKMOUSEEVENT */
    TEST_TYPE_SIZE   (LPTRACKMOUSEEVENT, 4)
    TEST_TYPE_ALIGN  (LPTRACKMOUSEEVENT, 4)
    TEST_TARGET_SIZE (LPTRACKMOUSEEVENT, 16)
    TEST_TARGET_ALIGN(LPTRACKMOUSEEVENT, 4)
}

static void test_pack_LPWINDOWINFO(void)
{
    /* LPWINDOWINFO */
    TEST_TYPE_SIZE   (LPWINDOWINFO, 4)
    TEST_TYPE_ALIGN  (LPWINDOWINFO, 4)
    TEST_TARGET_SIZE (LPWINDOWINFO, 60)
    TEST_TARGET_ALIGN(LPWINDOWINFO, 4)
}

static void test_pack_LPWINDOWPLACEMENT(void)
{
    /* LPWINDOWPLACEMENT */
    TEST_TYPE_SIZE   (LPWINDOWPLACEMENT, 4)
    TEST_TYPE_ALIGN  (LPWINDOWPLACEMENT, 4)
    TEST_TARGET_SIZE (LPWINDOWPLACEMENT, 44)
    TEST_TARGET_ALIGN(LPWINDOWPLACEMENT, 4)
}

static void test_pack_LPWINDOWPOS(void)
{
    /* LPWINDOWPOS */
    TEST_TYPE_SIZE   (LPWINDOWPOS, 4)
    TEST_TYPE_ALIGN  (LPWINDOWPOS, 4)
    TEST_TARGET_SIZE (LPWINDOWPOS, 28)
    TEST_TARGET_ALIGN(LPWINDOWPOS, 4)
}

static void test_pack_LPWNDCLASSA(void)
{
    /* LPWNDCLASSA */
    TEST_TYPE_SIZE   (LPWNDCLASSA, 4)
    TEST_TYPE_ALIGN  (LPWNDCLASSA, 4)
    TEST_TARGET_SIZE (LPWNDCLASSA, 40)
    TEST_TARGET_ALIGN(LPWNDCLASSA, 4)
}

static void test_pack_LPWNDCLASSEXA(void)
{
    /* LPWNDCLASSEXA */
    TEST_TYPE_SIZE   (LPWNDCLASSEXA, 4)
    TEST_TYPE_ALIGN  (LPWNDCLASSEXA, 4)
    TEST_TARGET_SIZE (LPWNDCLASSEXA, 48)
    TEST_TARGET_ALIGN(LPWNDCLASSEXA, 4)
}

static void test_pack_LPWNDCLASSEXW(void)
{
    /* LPWNDCLASSEXW */
    TEST_TYPE_SIZE   (LPWNDCLASSEXW, 4)
    TEST_TYPE_ALIGN  (LPWNDCLASSEXW, 4)
    TEST_TARGET_SIZE (LPWNDCLASSEXW, 48)
    TEST_TARGET_ALIGN(LPWNDCLASSEXW, 4)
}

static void test_pack_LPWNDCLASSW(void)
{
    /* LPWNDCLASSW */
    TEST_TYPE_SIZE   (LPWNDCLASSW, 4)
    TEST_TYPE_ALIGN  (LPWNDCLASSW, 4)
    TEST_TARGET_SIZE (LPWNDCLASSW, 40)
    TEST_TARGET_ALIGN(LPWNDCLASSW, 4)
}

static void test_pack_MDICREATESTRUCTA(void)
{
    /* MDICREATESTRUCTA */
    TEST_TYPE_SIZE   (MDICREATESTRUCTA, 36)
    TEST_TYPE_ALIGN  (MDICREATESTRUCTA, 4)
    TEST_FIELD_SIZE  (MDICREATESTRUCTA, szClass, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTA, szClass, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTA, szClass, 0)
    TEST_FIELD_SIZE  (MDICREATESTRUCTA, szTitle, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTA, szTitle, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTA, szTitle, 4)
    TEST_FIELD_SIZE  (MDICREATESTRUCTA, hOwner, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTA, hOwner, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTA, hOwner, 8)
    TEST_FIELD_SIZE  (MDICREATESTRUCTA, x, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTA, x, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTA, x, 12)
    TEST_FIELD_SIZE  (MDICREATESTRUCTA, y, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTA, y, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTA, y, 16)
    TEST_FIELD_SIZE  (MDICREATESTRUCTA, cx, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTA, cx, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTA, cx, 20)
    TEST_FIELD_SIZE  (MDICREATESTRUCTA, cy, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTA, cy, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTA, cy, 24)
    TEST_FIELD_SIZE  (MDICREATESTRUCTA, style, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTA, style, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTA, style, 28)
    TEST_FIELD_SIZE  (MDICREATESTRUCTA, lParam, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTA, lParam, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTA, lParam, 32)
}

static void test_pack_MDICREATESTRUCTW(void)
{
    /* MDICREATESTRUCTW */
    TEST_TYPE_SIZE   (MDICREATESTRUCTW, 36)
    TEST_TYPE_ALIGN  (MDICREATESTRUCTW, 4)
    TEST_FIELD_SIZE  (MDICREATESTRUCTW, szClass, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTW, szClass, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTW, szClass, 0)
    TEST_FIELD_SIZE  (MDICREATESTRUCTW, szTitle, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTW, szTitle, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTW, szTitle, 4)
    TEST_FIELD_SIZE  (MDICREATESTRUCTW, hOwner, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTW, hOwner, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTW, hOwner, 8)
    TEST_FIELD_SIZE  (MDICREATESTRUCTW, x, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTW, x, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTW, x, 12)
    TEST_FIELD_SIZE  (MDICREATESTRUCTW, y, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTW, y, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTW, y, 16)
    TEST_FIELD_SIZE  (MDICREATESTRUCTW, cx, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTW, cx, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTW, cx, 20)
    TEST_FIELD_SIZE  (MDICREATESTRUCTW, cy, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTW, cy, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTW, cy, 24)
    TEST_FIELD_SIZE  (MDICREATESTRUCTW, style, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTW, style, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTW, style, 28)
    TEST_FIELD_SIZE  (MDICREATESTRUCTW, lParam, 4)
    TEST_FIELD_ALIGN (MDICREATESTRUCTW, lParam, 4)
    TEST_FIELD_OFFSET(MDICREATESTRUCTW, lParam, 32)
}

static void test_pack_MDINEXTMENU(void)
{
    /* MDINEXTMENU */
    TEST_TYPE_SIZE   (MDINEXTMENU, 12)
    TEST_TYPE_ALIGN  (MDINEXTMENU, 4)
    TEST_FIELD_SIZE  (MDINEXTMENU, hmenuIn, 4)
    TEST_FIELD_ALIGN (MDINEXTMENU, hmenuIn, 4)
    TEST_FIELD_OFFSET(MDINEXTMENU, hmenuIn, 0)
    TEST_FIELD_SIZE  (MDINEXTMENU, hmenuNext, 4)
    TEST_FIELD_ALIGN (MDINEXTMENU, hmenuNext, 4)
    TEST_FIELD_OFFSET(MDINEXTMENU, hmenuNext, 4)
    TEST_FIELD_SIZE  (MDINEXTMENU, hwndNext, 4)
    TEST_FIELD_ALIGN (MDINEXTMENU, hwndNext, 4)
    TEST_FIELD_OFFSET(MDINEXTMENU, hwndNext, 8)
}

static void test_pack_MEASUREITEMSTRUCT(void)
{
    /* MEASUREITEMSTRUCT */
    TEST_TYPE_SIZE   (MEASUREITEMSTRUCT, 24)
    TEST_TYPE_ALIGN  (MEASUREITEMSTRUCT, 4)
    TEST_FIELD_SIZE  (MEASUREITEMSTRUCT, CtlType, 4)
    TEST_FIELD_ALIGN (MEASUREITEMSTRUCT, CtlType, 4)
    TEST_FIELD_OFFSET(MEASUREITEMSTRUCT, CtlType, 0)
    TEST_FIELD_SIZE  (MEASUREITEMSTRUCT, CtlID, 4)
    TEST_FIELD_ALIGN (MEASUREITEMSTRUCT, CtlID, 4)
    TEST_FIELD_OFFSET(MEASUREITEMSTRUCT, CtlID, 4)
    TEST_FIELD_SIZE  (MEASUREITEMSTRUCT, itemID, 4)
    TEST_FIELD_ALIGN (MEASUREITEMSTRUCT, itemID, 4)
    TEST_FIELD_OFFSET(MEASUREITEMSTRUCT, itemID, 8)
    TEST_FIELD_SIZE  (MEASUREITEMSTRUCT, itemWidth, 4)
    TEST_FIELD_ALIGN (MEASUREITEMSTRUCT, itemWidth, 4)
    TEST_FIELD_OFFSET(MEASUREITEMSTRUCT, itemWidth, 12)
    TEST_FIELD_SIZE  (MEASUREITEMSTRUCT, itemHeight, 4)
    TEST_FIELD_ALIGN (MEASUREITEMSTRUCT, itemHeight, 4)
    TEST_FIELD_OFFSET(MEASUREITEMSTRUCT, itemHeight, 16)
    TEST_FIELD_SIZE  (MEASUREITEMSTRUCT, itemData, 4)
    TEST_FIELD_ALIGN (MEASUREITEMSTRUCT, itemData, 4)
    TEST_FIELD_OFFSET(MEASUREITEMSTRUCT, itemData, 20)
}

static void test_pack_MENUINFO(void)
{
    /* MENUINFO */
    TEST_TYPE_SIZE   (MENUINFO, 28)
    TEST_TYPE_ALIGN  (MENUINFO, 4)
    TEST_FIELD_SIZE  (MENUINFO, cbSize, 4)
    TEST_FIELD_ALIGN (MENUINFO, cbSize, 4)
    TEST_FIELD_OFFSET(MENUINFO, cbSize, 0)
    TEST_FIELD_SIZE  (MENUINFO, fMask, 4)
    TEST_FIELD_ALIGN (MENUINFO, fMask, 4)
    TEST_FIELD_OFFSET(MENUINFO, fMask, 4)
    TEST_FIELD_SIZE  (MENUINFO, dwStyle, 4)
    TEST_FIELD_ALIGN (MENUINFO, dwStyle, 4)
    TEST_FIELD_OFFSET(MENUINFO, dwStyle, 8)
    TEST_FIELD_SIZE  (MENUINFO, cyMax, 4)
    TEST_FIELD_ALIGN (MENUINFO, cyMax, 4)
    TEST_FIELD_OFFSET(MENUINFO, cyMax, 12)
    TEST_FIELD_SIZE  (MENUINFO, hbrBack, 4)
    TEST_FIELD_ALIGN (MENUINFO, hbrBack, 4)
    TEST_FIELD_OFFSET(MENUINFO, hbrBack, 16)
    TEST_FIELD_SIZE  (MENUINFO, dwContextHelpID, 4)
    TEST_FIELD_ALIGN (MENUINFO, dwContextHelpID, 4)
    TEST_FIELD_OFFSET(MENUINFO, dwContextHelpID, 20)
    TEST_FIELD_SIZE  (MENUINFO, dwMenuData, 4)
    TEST_FIELD_ALIGN (MENUINFO, dwMenuData, 4)
    TEST_FIELD_OFFSET(MENUINFO, dwMenuData, 24)
}

static void test_pack_MENUITEMINFOA(void)
{
    /* MENUITEMINFOA */
    TEST_TYPE_SIZE   (MENUITEMINFOA, 48)
    TEST_TYPE_ALIGN  (MENUITEMINFOA, 4)
    TEST_FIELD_SIZE  (MENUITEMINFOA, cbSize, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOA, cbSize, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOA, cbSize, 0)
    TEST_FIELD_SIZE  (MENUITEMINFOA, fMask, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOA, fMask, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOA, fMask, 4)
    TEST_FIELD_SIZE  (MENUITEMINFOA, fType, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOA, fType, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOA, fType, 8)
    TEST_FIELD_SIZE  (MENUITEMINFOA, fState, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOA, fState, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOA, fState, 12)
    TEST_FIELD_SIZE  (MENUITEMINFOA, wID, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOA, wID, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOA, wID, 16)
    TEST_FIELD_SIZE  (MENUITEMINFOA, hSubMenu, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOA, hSubMenu, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOA, hSubMenu, 20)
    TEST_FIELD_SIZE  (MENUITEMINFOA, hbmpChecked, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOA, hbmpChecked, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOA, hbmpChecked, 24)
    TEST_FIELD_SIZE  (MENUITEMINFOA, hbmpUnchecked, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOA, hbmpUnchecked, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOA, hbmpUnchecked, 28)
    TEST_FIELD_SIZE  (MENUITEMINFOA, dwItemData, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOA, dwItemData, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOA, dwItemData, 32)
    TEST_FIELD_SIZE  (MENUITEMINFOA, dwTypeData, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOA, dwTypeData, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOA, dwTypeData, 36)
    TEST_FIELD_SIZE  (MENUITEMINFOA, cch, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOA, cch, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOA, cch, 40)
    TEST_FIELD_SIZE  (MENUITEMINFOA, hbmpItem, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOA, hbmpItem, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOA, hbmpItem, 44)
}

static void test_pack_MENUITEMINFOW(void)
{
    /* MENUITEMINFOW */
    TEST_TYPE_SIZE   (MENUITEMINFOW, 48)
    TEST_TYPE_ALIGN  (MENUITEMINFOW, 4)
    TEST_FIELD_SIZE  (MENUITEMINFOW, cbSize, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOW, cbSize, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOW, cbSize, 0)
    TEST_FIELD_SIZE  (MENUITEMINFOW, fMask, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOW, fMask, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOW, fMask, 4)
    TEST_FIELD_SIZE  (MENUITEMINFOW, fType, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOW, fType, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOW, fType, 8)
    TEST_FIELD_SIZE  (MENUITEMINFOW, fState, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOW, fState, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOW, fState, 12)
    TEST_FIELD_SIZE  (MENUITEMINFOW, wID, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOW, wID, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOW, wID, 16)
    TEST_FIELD_SIZE  (MENUITEMINFOW, hSubMenu, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOW, hSubMenu, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOW, hSubMenu, 20)
    TEST_FIELD_SIZE  (MENUITEMINFOW, hbmpChecked, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOW, hbmpChecked, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOW, hbmpChecked, 24)
    TEST_FIELD_SIZE  (MENUITEMINFOW, hbmpUnchecked, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOW, hbmpUnchecked, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOW, hbmpUnchecked, 28)
    TEST_FIELD_SIZE  (MENUITEMINFOW, dwItemData, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOW, dwItemData, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOW, dwItemData, 32)
    TEST_FIELD_SIZE  (MENUITEMINFOW, dwTypeData, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOW, dwTypeData, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOW, dwTypeData, 36)
    TEST_FIELD_SIZE  (MENUITEMINFOW, cch, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOW, cch, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOW, cch, 40)
    TEST_FIELD_SIZE  (MENUITEMINFOW, hbmpItem, 4)
    TEST_FIELD_ALIGN (MENUITEMINFOW, hbmpItem, 4)
    TEST_FIELD_OFFSET(MENUITEMINFOW, hbmpItem, 44)
}

static void test_pack_MENUITEMTEMPLATE(void)
{
    /* MENUITEMTEMPLATE */
    TEST_TYPE_SIZE   (MENUITEMTEMPLATE, 6)
    TEST_TYPE_ALIGN  (MENUITEMTEMPLATE, 2)
    TEST_FIELD_SIZE  (MENUITEMTEMPLATE, mtOption, 2)
    TEST_FIELD_ALIGN (MENUITEMTEMPLATE, mtOption, 2)
    TEST_FIELD_OFFSET(MENUITEMTEMPLATE, mtOption, 0)
    TEST_FIELD_SIZE  (MENUITEMTEMPLATE, mtID, 2)
    TEST_FIELD_ALIGN (MENUITEMTEMPLATE, mtID, 2)
    TEST_FIELD_OFFSET(MENUITEMTEMPLATE, mtID, 2)
    TEST_FIELD_SIZE  (MENUITEMTEMPLATE, mtString, 2)
    TEST_FIELD_ALIGN (MENUITEMTEMPLATE, mtString, 2)
    TEST_FIELD_OFFSET(MENUITEMTEMPLATE, mtString, 4)
}

static void test_pack_MENUITEMTEMPLATEHEADER(void)
{
    /* MENUITEMTEMPLATEHEADER */
    TEST_TYPE_SIZE   (MENUITEMTEMPLATEHEADER, 4)
    TEST_TYPE_ALIGN  (MENUITEMTEMPLATEHEADER, 2)
    TEST_FIELD_SIZE  (MENUITEMTEMPLATEHEADER, versionNumber, 2)
    TEST_FIELD_ALIGN (MENUITEMTEMPLATEHEADER, versionNumber, 2)
    TEST_FIELD_OFFSET(MENUITEMTEMPLATEHEADER, versionNumber, 0)
    TEST_FIELD_SIZE  (MENUITEMTEMPLATEHEADER, offset, 2)
    TEST_FIELD_ALIGN (MENUITEMTEMPLATEHEADER, offset, 2)
    TEST_FIELD_OFFSET(MENUITEMTEMPLATEHEADER, offset, 2)
}

static void test_pack_MINIMIZEDMETRICS(void)
{
    /* MINIMIZEDMETRICS */
    TEST_TYPE_SIZE   (MINIMIZEDMETRICS, 20)
    TEST_TYPE_ALIGN  (MINIMIZEDMETRICS, 4)
    TEST_FIELD_SIZE  (MINIMIZEDMETRICS, cbSize, 4)
    TEST_FIELD_ALIGN (MINIMIZEDMETRICS, cbSize, 4)
    TEST_FIELD_OFFSET(MINIMIZEDMETRICS, cbSize, 0)
    TEST_FIELD_SIZE  (MINIMIZEDMETRICS, iWidth, 4)
    TEST_FIELD_ALIGN (MINIMIZEDMETRICS, iWidth, 4)
    TEST_FIELD_OFFSET(MINIMIZEDMETRICS, iWidth, 4)
    TEST_FIELD_SIZE  (MINIMIZEDMETRICS, iHorzGap, 4)
    TEST_FIELD_ALIGN (MINIMIZEDMETRICS, iHorzGap, 4)
    TEST_FIELD_OFFSET(MINIMIZEDMETRICS, iHorzGap, 8)
    TEST_FIELD_SIZE  (MINIMIZEDMETRICS, iVertGap, 4)
    TEST_FIELD_ALIGN (MINIMIZEDMETRICS, iVertGap, 4)
    TEST_FIELD_OFFSET(MINIMIZEDMETRICS, iVertGap, 12)
    TEST_FIELD_SIZE  (MINIMIZEDMETRICS, iArrange, 4)
    TEST_FIELD_ALIGN (MINIMIZEDMETRICS, iArrange, 4)
    TEST_FIELD_OFFSET(MINIMIZEDMETRICS, iArrange, 16)
}

static void test_pack_MINMAXINFO(void)
{
    /* MINMAXINFO */
    TEST_TYPE_SIZE   (MINMAXINFO, 40)
    TEST_TYPE_ALIGN  (MINMAXINFO, 4)
    TEST_FIELD_SIZE  (MINMAXINFO, ptReserved, 8)
    TEST_FIELD_ALIGN (MINMAXINFO, ptReserved, 4)
    TEST_FIELD_OFFSET(MINMAXINFO, ptReserved, 0)
    TEST_FIELD_SIZE  (MINMAXINFO, ptMaxSize, 8)
    TEST_FIELD_ALIGN (MINMAXINFO, ptMaxSize, 4)
    TEST_FIELD_OFFSET(MINMAXINFO, ptMaxSize, 8)
    TEST_FIELD_SIZE  (MINMAXINFO, ptMaxPosition, 8)
    TEST_FIELD_ALIGN (MINMAXINFO, ptMaxPosition, 4)
    TEST_FIELD_OFFSET(MINMAXINFO, ptMaxPosition, 16)
    TEST_FIELD_SIZE  (MINMAXINFO, ptMinTrackSize, 8)
    TEST_FIELD_ALIGN (MINMAXINFO, ptMinTrackSize, 4)
    TEST_FIELD_OFFSET(MINMAXINFO, ptMinTrackSize, 24)
    TEST_FIELD_SIZE  (MINMAXINFO, ptMaxTrackSize, 8)
    TEST_FIELD_ALIGN (MINMAXINFO, ptMaxTrackSize, 4)
    TEST_FIELD_OFFSET(MINMAXINFO, ptMaxTrackSize, 32)
}

static void test_pack_MONITORENUMPROC(void)
{
    /* MONITORENUMPROC */
    TEST_TYPE_SIZE   (MONITORENUMPROC, 4)
    TEST_TYPE_ALIGN  (MONITORENUMPROC, 4)
}

static void test_pack_MONITORINFO(void)
{
    /* MONITORINFO */
    TEST_TYPE_SIZE   (MONITORINFO, 40)
    TEST_TYPE_ALIGN  (MONITORINFO, 4)
    TEST_FIELD_SIZE  (MONITORINFO, cbSize, 4)
    TEST_FIELD_ALIGN (MONITORINFO, cbSize, 4)
    TEST_FIELD_OFFSET(MONITORINFO, cbSize, 0)
    TEST_FIELD_SIZE  (MONITORINFO, rcMonitor, 16)
    TEST_FIELD_ALIGN (MONITORINFO, rcMonitor, 4)
    TEST_FIELD_OFFSET(MONITORINFO, rcMonitor, 4)
    TEST_FIELD_SIZE  (MONITORINFO, rcWork, 16)
    TEST_FIELD_ALIGN (MONITORINFO, rcWork, 4)
    TEST_FIELD_OFFSET(MONITORINFO, rcWork, 20)
    TEST_FIELD_SIZE  (MONITORINFO, dwFlags, 4)
    TEST_FIELD_ALIGN (MONITORINFO, dwFlags, 4)
    TEST_FIELD_OFFSET(MONITORINFO, dwFlags, 36)
}

static void test_pack_MONITORINFOEXA(void)
{
    /* MONITORINFOEXA */
    TEST_TYPE_SIZE   (MONITORINFOEXA, 72)
    TEST_TYPE_ALIGN  (MONITORINFOEXA, 4)
    TEST_FIELD_SIZE  (MONITORINFOEXA, cbSize, 4)
    TEST_FIELD_ALIGN (MONITORINFOEXA, cbSize, 4)
    TEST_FIELD_OFFSET(MONITORINFOEXA, cbSize, 0)
    TEST_FIELD_SIZE  (MONITORINFOEXA, rcMonitor, 16)
    TEST_FIELD_ALIGN (MONITORINFOEXA, rcMonitor, 4)
    TEST_FIELD_OFFSET(MONITORINFOEXA, rcMonitor, 4)
    TEST_FIELD_SIZE  (MONITORINFOEXA, rcWork, 16)
    TEST_FIELD_ALIGN (MONITORINFOEXA, rcWork, 4)
    TEST_FIELD_OFFSET(MONITORINFOEXA, rcWork, 20)
    TEST_FIELD_SIZE  (MONITORINFOEXA, dwFlags, 4)
    TEST_FIELD_ALIGN (MONITORINFOEXA, dwFlags, 4)
    TEST_FIELD_OFFSET(MONITORINFOEXA, dwFlags, 36)
    TEST_FIELD_SIZE  (MONITORINFOEXA, szDevice, 32)
    TEST_FIELD_ALIGN (MONITORINFOEXA, szDevice, 1)
    TEST_FIELD_OFFSET(MONITORINFOEXA, szDevice, 40)
}

static void test_pack_MONITORINFOEXW(void)
{
    /* MONITORINFOEXW */
    TEST_TYPE_SIZE   (MONITORINFOEXW, 104)
    TEST_TYPE_ALIGN  (MONITORINFOEXW, 4)
    TEST_FIELD_SIZE  (MONITORINFOEXW, cbSize, 4)
    TEST_FIELD_ALIGN (MONITORINFOEXW, cbSize, 4)
    TEST_FIELD_OFFSET(MONITORINFOEXW, cbSize, 0)
    TEST_FIELD_SIZE  (MONITORINFOEXW, rcMonitor, 16)
    TEST_FIELD_ALIGN (MONITORINFOEXW, rcMonitor, 4)
    TEST_FIELD_OFFSET(MONITORINFOEXW, rcMonitor, 4)
    TEST_FIELD_SIZE  (MONITORINFOEXW, rcWork, 16)
    TEST_FIELD_ALIGN (MONITORINFOEXW, rcWork, 4)
    TEST_FIELD_OFFSET(MONITORINFOEXW, rcWork, 20)
    TEST_FIELD_SIZE  (MONITORINFOEXW, dwFlags, 4)
    TEST_FIELD_ALIGN (MONITORINFOEXW, dwFlags, 4)
    TEST_FIELD_OFFSET(MONITORINFOEXW, dwFlags, 36)
    TEST_FIELD_SIZE  (MONITORINFOEXW, szDevice, 64)
    TEST_FIELD_ALIGN (MONITORINFOEXW, szDevice, 2)
    TEST_FIELD_OFFSET(MONITORINFOEXW, szDevice, 40)
}

static void test_pack_MOUSEHOOKSTRUCT(void)
{
    /* MOUSEHOOKSTRUCT */
    TEST_TYPE_SIZE   (MOUSEHOOKSTRUCT, 20)
    TEST_TYPE_ALIGN  (MOUSEHOOKSTRUCT, 4)
    TEST_FIELD_SIZE  (MOUSEHOOKSTRUCT, pt, 8)
    TEST_FIELD_ALIGN (MOUSEHOOKSTRUCT, pt, 4)
    TEST_FIELD_OFFSET(MOUSEHOOKSTRUCT, pt, 0)
    TEST_FIELD_SIZE  (MOUSEHOOKSTRUCT, hwnd, 4)
    TEST_FIELD_ALIGN (MOUSEHOOKSTRUCT, hwnd, 4)
    TEST_FIELD_OFFSET(MOUSEHOOKSTRUCT, hwnd, 8)
    TEST_FIELD_SIZE  (MOUSEHOOKSTRUCT, wHitTestCode, 4)
    TEST_FIELD_ALIGN (MOUSEHOOKSTRUCT, wHitTestCode, 4)
    TEST_FIELD_OFFSET(MOUSEHOOKSTRUCT, wHitTestCode, 12)
    TEST_FIELD_SIZE  (MOUSEHOOKSTRUCT, dwExtraInfo, 4)
    TEST_FIELD_ALIGN (MOUSEHOOKSTRUCT, dwExtraInfo, 4)
    TEST_FIELD_OFFSET(MOUSEHOOKSTRUCT, dwExtraInfo, 16)
}

static void test_pack_MOUSEINPUT(void)
{
    /* MOUSEINPUT */
    TEST_TYPE_SIZE   (MOUSEINPUT, 24)
    TEST_TYPE_ALIGN  (MOUSEINPUT, 4)
    TEST_FIELD_SIZE  (MOUSEINPUT, dx, 4)
    TEST_FIELD_ALIGN (MOUSEINPUT, dx, 4)
    TEST_FIELD_OFFSET(MOUSEINPUT, dx, 0)
    TEST_FIELD_SIZE  (MOUSEINPUT, dy, 4)
    TEST_FIELD_ALIGN (MOUSEINPUT, dy, 4)
    TEST_FIELD_OFFSET(MOUSEINPUT, dy, 4)
    TEST_FIELD_SIZE  (MOUSEINPUT, mouseData, 4)
    TEST_FIELD_ALIGN (MOUSEINPUT, mouseData, 4)
    TEST_FIELD_OFFSET(MOUSEINPUT, mouseData, 8)
    TEST_FIELD_SIZE  (MOUSEINPUT, dwFlags, 4)
    TEST_FIELD_ALIGN (MOUSEINPUT, dwFlags, 4)
    TEST_FIELD_OFFSET(MOUSEINPUT, dwFlags, 12)
    TEST_FIELD_SIZE  (MOUSEINPUT, time, 4)
    TEST_FIELD_ALIGN (MOUSEINPUT, time, 4)
    TEST_FIELD_OFFSET(MOUSEINPUT, time, 16)
    TEST_FIELD_SIZE  (MOUSEINPUT, dwExtraInfo, 4)
    TEST_FIELD_ALIGN (MOUSEINPUT, dwExtraInfo, 4)
    TEST_FIELD_OFFSET(MOUSEINPUT, dwExtraInfo, 20)
}

static void test_pack_MOUSEKEYS(void)
{
    /* MOUSEKEYS */
    TEST_TYPE_SIZE   (MOUSEKEYS, 28)
    TEST_TYPE_ALIGN  (MOUSEKEYS, 4)
    TEST_FIELD_SIZE  (MOUSEKEYS, cbSize, 4)
    TEST_FIELD_ALIGN (MOUSEKEYS, cbSize, 4)
    TEST_FIELD_OFFSET(MOUSEKEYS, cbSize, 0)
    TEST_FIELD_SIZE  (MOUSEKEYS, dwFlags, 4)
    TEST_FIELD_ALIGN (MOUSEKEYS, dwFlags, 4)
    TEST_FIELD_OFFSET(MOUSEKEYS, dwFlags, 4)
    TEST_FIELD_SIZE  (MOUSEKEYS, iMaxSpeed, 4)
    TEST_FIELD_ALIGN (MOUSEKEYS, iMaxSpeed, 4)
    TEST_FIELD_OFFSET(MOUSEKEYS, iMaxSpeed, 8)
    TEST_FIELD_SIZE  (MOUSEKEYS, iTimeToMaxSpeed, 4)
    TEST_FIELD_ALIGN (MOUSEKEYS, iTimeToMaxSpeed, 4)
    TEST_FIELD_OFFSET(MOUSEKEYS, iTimeToMaxSpeed, 12)
    TEST_FIELD_SIZE  (MOUSEKEYS, iCtrlSpeed, 4)
    TEST_FIELD_ALIGN (MOUSEKEYS, iCtrlSpeed, 4)
    TEST_FIELD_OFFSET(MOUSEKEYS, iCtrlSpeed, 16)
    TEST_FIELD_SIZE  (MOUSEKEYS, dwReserved1, 4)
    TEST_FIELD_ALIGN (MOUSEKEYS, dwReserved1, 4)
    TEST_FIELD_OFFSET(MOUSEKEYS, dwReserved1, 20)
    TEST_FIELD_SIZE  (MOUSEKEYS, dwReserved2, 4)
    TEST_FIELD_ALIGN (MOUSEKEYS, dwReserved2, 4)
    TEST_FIELD_OFFSET(MOUSEKEYS, dwReserved2, 24)
}

static void test_pack_MSG(void)
{
    /* MSG */
    TEST_TYPE_SIZE   (MSG, 28)
    TEST_TYPE_ALIGN  (MSG, 4)
    TEST_FIELD_SIZE  (MSG, hwnd, 4)
    TEST_FIELD_ALIGN (MSG, hwnd, 4)
    TEST_FIELD_OFFSET(MSG, hwnd, 0)
    TEST_FIELD_SIZE  (MSG, message, 4)
    TEST_FIELD_ALIGN (MSG, message, 4)
    TEST_FIELD_OFFSET(MSG, message, 4)
    TEST_FIELD_SIZE  (MSG, wParam, 4)
    TEST_FIELD_ALIGN (MSG, wParam, 4)
    TEST_FIELD_OFFSET(MSG, wParam, 8)
    TEST_FIELD_SIZE  (MSG, lParam, 4)
    TEST_FIELD_ALIGN (MSG, lParam, 4)
    TEST_FIELD_OFFSET(MSG, lParam, 12)
    TEST_FIELD_SIZE  (MSG, time, 4)
    TEST_FIELD_ALIGN (MSG, time, 4)
    TEST_FIELD_OFFSET(MSG, time, 16)
    TEST_FIELD_SIZE  (MSG, pt, 8)
    TEST_FIELD_ALIGN (MSG, pt, 4)
    TEST_FIELD_OFFSET(MSG, pt, 20)
}

static void test_pack_MSGBOXCALLBACK(void)
{
    /* MSGBOXCALLBACK */
    TEST_TYPE_SIZE   (MSGBOXCALLBACK, 4)
    TEST_TYPE_ALIGN  (MSGBOXCALLBACK, 4)
}

static void test_pack_MSGBOXPARAMSA(void)
{
    /* MSGBOXPARAMSA */
    TEST_TYPE_SIZE   (MSGBOXPARAMSA, 40)
    TEST_TYPE_ALIGN  (MSGBOXPARAMSA, 4)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, cbSize, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, cbSize, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, cbSize, 0)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, hwndOwner, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, hwndOwner, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, hwndOwner, 4)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, hInstance, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, hInstance, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, hInstance, 8)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, lpszText, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, lpszText, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, lpszText, 12)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, lpszCaption, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, lpszCaption, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, lpszCaption, 16)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, dwStyle, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, dwStyle, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, dwStyle, 20)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, lpszIcon, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, lpszIcon, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, lpszIcon, 24)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, dwContextHelpId, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, dwContextHelpId, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, dwContextHelpId, 28)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, lpfnMsgBoxCallback, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, lpfnMsgBoxCallback, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, lpfnMsgBoxCallback, 32)
    TEST_FIELD_SIZE  (MSGBOXPARAMSA, dwLanguageId, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSA, dwLanguageId, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSA, dwLanguageId, 36)
}

static void test_pack_MSGBOXPARAMSW(void)
{
    /* MSGBOXPARAMSW */
    TEST_TYPE_SIZE   (MSGBOXPARAMSW, 40)
    TEST_TYPE_ALIGN  (MSGBOXPARAMSW, 4)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, cbSize, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, cbSize, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, cbSize, 0)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, hwndOwner, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, hwndOwner, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, hwndOwner, 4)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, hInstance, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, hInstance, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, hInstance, 8)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, lpszText, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, lpszText, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, lpszText, 12)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, lpszCaption, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, lpszCaption, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, lpszCaption, 16)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, dwStyle, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, dwStyle, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, dwStyle, 20)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, lpszIcon, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, lpszIcon, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, lpszIcon, 24)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, dwContextHelpId, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, dwContextHelpId, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, dwContextHelpId, 28)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, lpfnMsgBoxCallback, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, lpfnMsgBoxCallback, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, lpfnMsgBoxCallback, 32)
    TEST_FIELD_SIZE  (MSGBOXPARAMSW, dwLanguageId, 4)
    TEST_FIELD_ALIGN (MSGBOXPARAMSW, dwLanguageId, 4)
    TEST_FIELD_OFFSET(MSGBOXPARAMSW, dwLanguageId, 36)
}

static void test_pack_MSLLHOOKSTRUCT(void)
{
    /* MSLLHOOKSTRUCT */
    TEST_TYPE_SIZE   (MSLLHOOKSTRUCT, 24)
    TEST_TYPE_ALIGN  (MSLLHOOKSTRUCT, 4)
    TEST_FIELD_SIZE  (MSLLHOOKSTRUCT, pt, 8)
    TEST_FIELD_ALIGN (MSLLHOOKSTRUCT, pt, 4)
    TEST_FIELD_OFFSET(MSLLHOOKSTRUCT, pt, 0)
    TEST_FIELD_SIZE  (MSLLHOOKSTRUCT, mouseData, 4)
    TEST_FIELD_ALIGN (MSLLHOOKSTRUCT, mouseData, 4)
    TEST_FIELD_OFFSET(MSLLHOOKSTRUCT, mouseData, 8)
    TEST_FIELD_SIZE  (MSLLHOOKSTRUCT, flags, 4)
    TEST_FIELD_ALIGN (MSLLHOOKSTRUCT, flags, 4)
    TEST_FIELD_OFFSET(MSLLHOOKSTRUCT, flags, 12)
    TEST_FIELD_SIZE  (MSLLHOOKSTRUCT, time, 4)
    TEST_FIELD_ALIGN (MSLLHOOKSTRUCT, time, 4)
    TEST_FIELD_OFFSET(MSLLHOOKSTRUCT, time, 16)
    TEST_FIELD_SIZE  (MSLLHOOKSTRUCT, dwExtraInfo, 4)
    TEST_FIELD_ALIGN (MSLLHOOKSTRUCT, dwExtraInfo, 4)
    TEST_FIELD_OFFSET(MSLLHOOKSTRUCT, dwExtraInfo, 20)
}

static void test_pack_MULTIKEYHELPA(void)
{
    /* MULTIKEYHELPA */
    TEST_TYPE_SIZE   (MULTIKEYHELPA, 8)
    TEST_TYPE_ALIGN  (MULTIKEYHELPA, 4)
    TEST_FIELD_SIZE  (MULTIKEYHELPA, mkSize, 4)
    TEST_FIELD_ALIGN (MULTIKEYHELPA, mkSize, 4)
    TEST_FIELD_OFFSET(MULTIKEYHELPA, mkSize, 0)
    TEST_FIELD_SIZE  (MULTIKEYHELPA, mkKeylist, 1)
    TEST_FIELD_ALIGN (MULTIKEYHELPA, mkKeylist, 1)
    TEST_FIELD_OFFSET(MULTIKEYHELPA, mkKeylist, 4)
    TEST_FIELD_SIZE  (MULTIKEYHELPA, szKeyphrase, 1)
    TEST_FIELD_ALIGN (MULTIKEYHELPA, szKeyphrase, 1)
    TEST_FIELD_OFFSET(MULTIKEYHELPA, szKeyphrase, 5)
}

static void test_pack_MULTIKEYHELPW(void)
{
    /* MULTIKEYHELPW */
    TEST_TYPE_SIZE   (MULTIKEYHELPW, 8)
    TEST_TYPE_ALIGN  (MULTIKEYHELPW, 4)
    TEST_FIELD_SIZE  (MULTIKEYHELPW, mkSize, 4)
    TEST_FIELD_ALIGN (MULTIKEYHELPW, mkSize, 4)
    TEST_FIELD_OFFSET(MULTIKEYHELPW, mkSize, 0)
    TEST_FIELD_SIZE  (MULTIKEYHELPW, mkKeylist, 2)
    TEST_FIELD_ALIGN (MULTIKEYHELPW, mkKeylist, 2)
    TEST_FIELD_OFFSET(MULTIKEYHELPW, mkKeylist, 4)
    TEST_FIELD_SIZE  (MULTIKEYHELPW, szKeyphrase, 2)
    TEST_FIELD_ALIGN (MULTIKEYHELPW, szKeyphrase, 2)
    TEST_FIELD_OFFSET(MULTIKEYHELPW, szKeyphrase, 6)
}

static void test_pack_NAMEENUMPROCA(void)
{
    /* NAMEENUMPROCA */
    TEST_TYPE_SIZE   (NAMEENUMPROCA, 4)
    TEST_TYPE_ALIGN  (NAMEENUMPROCA, 4)
}

static void test_pack_NAMEENUMPROCW(void)
{
    /* NAMEENUMPROCW */
    TEST_TYPE_SIZE   (NAMEENUMPROCW, 4)
    TEST_TYPE_ALIGN  (NAMEENUMPROCW, 4)
}

static void test_pack_NCCALCSIZE_PARAMS(void)
{
    /* NCCALCSIZE_PARAMS */
    TEST_TYPE_SIZE   (NCCALCSIZE_PARAMS, 52)
    TEST_TYPE_ALIGN  (NCCALCSIZE_PARAMS, 4)
    TEST_FIELD_SIZE  (NCCALCSIZE_PARAMS, rgrc, 48)
    TEST_FIELD_ALIGN (NCCALCSIZE_PARAMS, rgrc, 4)
    TEST_FIELD_OFFSET(NCCALCSIZE_PARAMS, rgrc, 0)
    TEST_FIELD_SIZE  (NCCALCSIZE_PARAMS, lppos, 4)
    TEST_FIELD_ALIGN (NCCALCSIZE_PARAMS, lppos, 4)
    TEST_FIELD_OFFSET(NCCALCSIZE_PARAMS, lppos, 48)
}

static void test_pack_NMHDR(void)
{
    /* NMHDR */
    TEST_TYPE_SIZE   (NMHDR, 12)
    TEST_TYPE_ALIGN  (NMHDR, 4)
    TEST_FIELD_SIZE  (NMHDR, hwndFrom, 4)
    TEST_FIELD_ALIGN (NMHDR, hwndFrom, 4)
    TEST_FIELD_OFFSET(NMHDR, hwndFrom, 0)
    TEST_FIELD_SIZE  (NMHDR, idFrom, 4)
    TEST_FIELD_ALIGN (NMHDR, idFrom, 4)
    TEST_FIELD_OFFSET(NMHDR, idFrom, 4)
    TEST_FIELD_SIZE  (NMHDR, code, 4)
    TEST_FIELD_ALIGN (NMHDR, code, 4)
    TEST_FIELD_OFFSET(NMHDR, code, 8)
}

static void test_pack_NONCLIENTMETRICSA(void)
{
    /* NONCLIENTMETRICSA */
    TEST_TYPE_SIZE   (NONCLIENTMETRICSA, 340)
    TEST_TYPE_ALIGN  (NONCLIENTMETRICSA, 4)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, cbSize, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, cbSize, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, cbSize, 0)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, iBorderWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, iBorderWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, iBorderWidth, 4)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, iScrollWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, iScrollWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, iScrollWidth, 8)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, iScrollHeight, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, iScrollHeight, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, iScrollHeight, 12)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, iCaptionWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, iCaptionWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, iCaptionWidth, 16)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, iCaptionHeight, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, iCaptionHeight, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, iCaptionHeight, 20)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, lfCaptionFont, 60)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, lfCaptionFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, lfCaptionFont, 24)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, iSmCaptionWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, iSmCaptionWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, iSmCaptionWidth, 84)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, iSmCaptionHeight, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, iSmCaptionHeight, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, iSmCaptionHeight, 88)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, lfSmCaptionFont, 60)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, lfSmCaptionFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, lfSmCaptionFont, 92)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, iMenuWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, iMenuWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, iMenuWidth, 152)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, iMenuHeight, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, iMenuHeight, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, iMenuHeight, 156)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, lfMenuFont, 60)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, lfMenuFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, lfMenuFont, 160)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, lfStatusFont, 60)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, lfStatusFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, lfStatusFont, 220)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSA, lfMessageFont, 60)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSA, lfMessageFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSA, lfMessageFont, 280)
}

static void test_pack_NONCLIENTMETRICSW(void)
{
    /* NONCLIENTMETRICSW */
    TEST_TYPE_SIZE   (NONCLIENTMETRICSW, 500)
    TEST_TYPE_ALIGN  (NONCLIENTMETRICSW, 4)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, cbSize, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, cbSize, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, cbSize, 0)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, iBorderWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, iBorderWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, iBorderWidth, 4)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, iScrollWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, iScrollWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, iScrollWidth, 8)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, iScrollHeight, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, iScrollHeight, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, iScrollHeight, 12)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, iCaptionWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, iCaptionWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, iCaptionWidth, 16)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, iCaptionHeight, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, iCaptionHeight, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, iCaptionHeight, 20)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, lfCaptionFont, 92)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, lfCaptionFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, lfCaptionFont, 24)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, iSmCaptionWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, iSmCaptionWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, iSmCaptionWidth, 116)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, iSmCaptionHeight, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, iSmCaptionHeight, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, iSmCaptionHeight, 120)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, lfSmCaptionFont, 92)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, lfSmCaptionFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, lfSmCaptionFont, 124)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, iMenuWidth, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, iMenuWidth, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, iMenuWidth, 216)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, iMenuHeight, 4)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, iMenuHeight, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, iMenuHeight, 220)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, lfMenuFont, 92)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, lfMenuFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, lfMenuFont, 224)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, lfStatusFont, 92)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, lfStatusFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, lfStatusFont, 316)
    TEST_FIELD_SIZE  (NONCLIENTMETRICSW, lfMessageFont, 92)
    TEST_FIELD_ALIGN (NONCLIENTMETRICSW, lfMessageFont, 4)
    TEST_FIELD_OFFSET(NONCLIENTMETRICSW, lfMessageFont, 408)
}

static void test_pack_PAINTSTRUCT(void)
{
    /* PAINTSTRUCT */
    TEST_TYPE_SIZE   (PAINTSTRUCT, 64)
    TEST_TYPE_ALIGN  (PAINTSTRUCT, 4)
    TEST_FIELD_SIZE  (PAINTSTRUCT, hdc, 4)
    TEST_FIELD_ALIGN (PAINTSTRUCT, hdc, 4)
    TEST_FIELD_OFFSET(PAINTSTRUCT, hdc, 0)
    TEST_FIELD_SIZE  (PAINTSTRUCT, fErase, 4)
    TEST_FIELD_ALIGN (PAINTSTRUCT, fErase, 4)
    TEST_FIELD_OFFSET(PAINTSTRUCT, fErase, 4)
    TEST_FIELD_SIZE  (PAINTSTRUCT, rcPaint, 16)
    TEST_FIELD_ALIGN (PAINTSTRUCT, rcPaint, 4)
    TEST_FIELD_OFFSET(PAINTSTRUCT, rcPaint, 8)
    TEST_FIELD_SIZE  (PAINTSTRUCT, fRestore, 4)
    TEST_FIELD_ALIGN (PAINTSTRUCT, fRestore, 4)
    TEST_FIELD_OFFSET(PAINTSTRUCT, fRestore, 24)
    TEST_FIELD_SIZE  (PAINTSTRUCT, fIncUpdate, 4)
    TEST_FIELD_ALIGN (PAINTSTRUCT, fIncUpdate, 4)
    TEST_FIELD_OFFSET(PAINTSTRUCT, fIncUpdate, 28)
    TEST_FIELD_SIZE  (PAINTSTRUCT, rgbReserved, 32)
    TEST_FIELD_ALIGN (PAINTSTRUCT, rgbReserved, 1)
    TEST_FIELD_OFFSET(PAINTSTRUCT, rgbReserved, 32)
}

static void test_pack_PCOMBOBOXINFO(void)
{
    /* PCOMBOBOXINFO */
    TEST_TYPE_SIZE   (PCOMBOBOXINFO, 4)
    TEST_TYPE_ALIGN  (PCOMBOBOXINFO, 4)
    TEST_TARGET_SIZE (PCOMBOBOXINFO, 52)
    TEST_TARGET_ALIGN(PCOMBOBOXINFO, 4)
}

static void test_pack_PCOMPAREITEMSTRUCT(void)
{
    /* PCOMPAREITEMSTRUCT */
    TEST_TYPE_SIZE   (PCOMPAREITEMSTRUCT, 4)
    TEST_TYPE_ALIGN  (PCOMPAREITEMSTRUCT, 4)
    TEST_TARGET_SIZE (PCOMPAREITEMSTRUCT, 32)
    TEST_TARGET_ALIGN(PCOMPAREITEMSTRUCT, 4)
}

static void test_pack_PCOPYDATASTRUCT(void)
{
    /* PCOPYDATASTRUCT */
    TEST_TYPE_SIZE   (PCOPYDATASTRUCT, 4)
    TEST_TYPE_ALIGN  (PCOPYDATASTRUCT, 4)
    TEST_TARGET_SIZE (PCOPYDATASTRUCT, 12)
    TEST_TARGET_ALIGN(PCOPYDATASTRUCT, 4)
}

static void test_pack_PCURSORINFO(void)
{
    /* PCURSORINFO */
    TEST_TYPE_SIZE   (PCURSORINFO, 4)
    TEST_TYPE_ALIGN  (PCURSORINFO, 4)
    TEST_TARGET_SIZE (PCURSORINFO, 20)
    TEST_TARGET_ALIGN(PCURSORINFO, 4)
}

static void test_pack_PCWPRETSTRUCT(void)
{
    /* PCWPRETSTRUCT */
    TEST_TYPE_SIZE   (PCWPRETSTRUCT, 4)
    TEST_TYPE_ALIGN  (PCWPRETSTRUCT, 4)
    TEST_TARGET_SIZE (PCWPRETSTRUCT, 20)
    TEST_TARGET_ALIGN(PCWPRETSTRUCT, 4)
}

static void test_pack_PCWPSTRUCT(void)
{
    /* PCWPSTRUCT */
    TEST_TYPE_SIZE   (PCWPSTRUCT, 4)
    TEST_TYPE_ALIGN  (PCWPSTRUCT, 4)
    TEST_TARGET_SIZE (PCWPSTRUCT, 16)
    TEST_TARGET_ALIGN(PCWPSTRUCT, 4)
}

static void test_pack_PDEBUGHOOKINFO(void)
{
    /* PDEBUGHOOKINFO */
    TEST_TYPE_SIZE   (PDEBUGHOOKINFO, 4)
    TEST_TYPE_ALIGN  (PDEBUGHOOKINFO, 4)
    TEST_TARGET_SIZE (PDEBUGHOOKINFO, 20)
    TEST_TARGET_ALIGN(PDEBUGHOOKINFO, 4)
}

static void test_pack_PDELETEITEMSTRUCT(void)
{
    /* PDELETEITEMSTRUCT */
    TEST_TYPE_SIZE   (PDELETEITEMSTRUCT, 4)
    TEST_TYPE_ALIGN  (PDELETEITEMSTRUCT, 4)
    TEST_TARGET_SIZE (PDELETEITEMSTRUCT, 20)
    TEST_TARGET_ALIGN(PDELETEITEMSTRUCT, 4)
}

static void test_pack_PDLGITEMTEMPLATEA(void)
{
    /* PDLGITEMTEMPLATEA */
    TEST_TYPE_SIZE   (PDLGITEMTEMPLATEA, 4)
    TEST_TYPE_ALIGN  (PDLGITEMTEMPLATEA, 4)
    TEST_TARGET_SIZE (PDLGITEMTEMPLATEA, 18)
    TEST_TARGET_ALIGN(PDLGITEMTEMPLATEA, 2)
}

static void test_pack_PDLGITEMTEMPLATEW(void)
{
    /* PDLGITEMTEMPLATEW */
    TEST_TYPE_SIZE   (PDLGITEMTEMPLATEW, 4)
    TEST_TYPE_ALIGN  (PDLGITEMTEMPLATEW, 4)
    TEST_TARGET_SIZE (PDLGITEMTEMPLATEW, 18)
    TEST_TARGET_ALIGN(PDLGITEMTEMPLATEW, 2)
}

static void test_pack_PDRAWITEMSTRUCT(void)
{
    /* PDRAWITEMSTRUCT */
    TEST_TYPE_SIZE   (PDRAWITEMSTRUCT, 4)
    TEST_TYPE_ALIGN  (PDRAWITEMSTRUCT, 4)
    TEST_TARGET_SIZE (PDRAWITEMSTRUCT, 48)
    TEST_TARGET_ALIGN(PDRAWITEMSTRUCT, 4)
}

static void test_pack_PEVENTMSG(void)
{
    /* PEVENTMSG */
    TEST_TYPE_SIZE   (PEVENTMSG, 4)
    TEST_TYPE_ALIGN  (PEVENTMSG, 4)
    TEST_TARGET_SIZE (PEVENTMSG, 20)
    TEST_TARGET_ALIGN(PEVENTMSG, 4)
}

static void test_pack_PFLASHWINFO(void)
{
    /* PFLASHWINFO */
    TEST_TYPE_SIZE   (PFLASHWINFO, 4)
    TEST_TYPE_ALIGN  (PFLASHWINFO, 4)
    TEST_TARGET_SIZE (PFLASHWINFO, 20)
    TEST_TARGET_ALIGN(PFLASHWINFO, 4)
}

static void test_pack_PGUITHREADINFO(void)
{
    /* PGUITHREADINFO */
    TEST_TYPE_SIZE   (PGUITHREADINFO, 4)
    TEST_TYPE_ALIGN  (PGUITHREADINFO, 4)
    TEST_TARGET_SIZE (PGUITHREADINFO, 48)
    TEST_TARGET_ALIGN(PGUITHREADINFO, 4)
}

static void test_pack_PHARDWAREHOOKSTRUCT(void)
{
    /* PHARDWAREHOOKSTRUCT */
    TEST_TYPE_SIZE   (PHARDWAREHOOKSTRUCT, 4)
    TEST_TYPE_ALIGN  (PHARDWAREHOOKSTRUCT, 4)
    TEST_TARGET_SIZE (PHARDWAREHOOKSTRUCT, 16)
    TEST_TARGET_ALIGN(PHARDWAREHOOKSTRUCT, 4)
}

static void test_pack_PHARDWAREINPUT(void)
{
    /* PHARDWAREINPUT */
    TEST_TYPE_SIZE   (PHARDWAREINPUT, 4)
    TEST_TYPE_ALIGN  (PHARDWAREINPUT, 4)
    TEST_TARGET_SIZE (PHARDWAREINPUT, 8)
    TEST_TARGET_ALIGN(PHARDWAREINPUT, 4)
}

static void test_pack_PHDEVNOTIFY(void)
{
    /* PHDEVNOTIFY */
    TEST_TYPE_SIZE   (PHDEVNOTIFY, 4)
    TEST_TYPE_ALIGN  (PHDEVNOTIFY, 4)
    TEST_TARGET_SIZE (PHDEVNOTIFY, 4)
    TEST_TARGET_ALIGN(PHDEVNOTIFY, 4)
}

static void test_pack_PHELPWININFOA(void)
{
    /* PHELPWININFOA */
    TEST_TYPE_SIZE   (PHELPWININFOA, 4)
    TEST_TYPE_ALIGN  (PHELPWININFOA, 4)
    TEST_TARGET_SIZE (PHELPWININFOA, 28)
    TEST_TARGET_ALIGN(PHELPWININFOA, 4)
}

static void test_pack_PHELPWININFOW(void)
{
    /* PHELPWININFOW */
    TEST_TYPE_SIZE   (PHELPWININFOW, 4)
    TEST_TYPE_ALIGN  (PHELPWININFOW, 4)
    TEST_TARGET_SIZE (PHELPWININFOW, 28)
    TEST_TARGET_ALIGN(PHELPWININFOW, 4)
}

static void test_pack_PICONINFO(void)
{
    /* PICONINFO */
    TEST_TYPE_SIZE   (PICONINFO, 4)
    TEST_TYPE_ALIGN  (PICONINFO, 4)
    TEST_TARGET_SIZE (PICONINFO, 20)
    TEST_TARGET_ALIGN(PICONINFO, 4)
}

static void test_pack_PICONMETRICSA(void)
{
    /* PICONMETRICSA */
    TEST_TYPE_SIZE   (PICONMETRICSA, 4)
    TEST_TYPE_ALIGN  (PICONMETRICSA, 4)
    TEST_TARGET_SIZE (PICONMETRICSA, 76)
    TEST_TARGET_ALIGN(PICONMETRICSA, 4)
}

static void test_pack_PICONMETRICSW(void)
{
    /* PICONMETRICSW */
    TEST_TYPE_SIZE   (PICONMETRICSW, 4)
    TEST_TYPE_ALIGN  (PICONMETRICSW, 4)
    TEST_TARGET_SIZE (PICONMETRICSW, 108)
    TEST_TARGET_ALIGN(PICONMETRICSW, 4)
}

static void test_pack_PINPUT(void)
{
    /* PINPUT */
    TEST_TYPE_SIZE   (PINPUT, 4)
    TEST_TYPE_ALIGN  (PINPUT, 4)
}

static void test_pack_PKBDLLHOOKSTRUCT(void)
{
    /* PKBDLLHOOKSTRUCT */
    TEST_TYPE_SIZE   (PKBDLLHOOKSTRUCT, 4)
    TEST_TYPE_ALIGN  (PKBDLLHOOKSTRUCT, 4)
    TEST_TARGET_SIZE (PKBDLLHOOKSTRUCT, 20)
    TEST_TARGET_ALIGN(PKBDLLHOOKSTRUCT, 4)
}

static void test_pack_PKEYBDINPUT(void)
{
    /* PKEYBDINPUT */
    TEST_TYPE_SIZE   (PKEYBDINPUT, 4)
    TEST_TYPE_ALIGN  (PKEYBDINPUT, 4)
    TEST_TARGET_SIZE (PKEYBDINPUT, 16)
    TEST_TARGET_ALIGN(PKEYBDINPUT, 4)
}

static void test_pack_PMDINEXTMENU(void)
{
    /* PMDINEXTMENU */
    TEST_TYPE_SIZE   (PMDINEXTMENU, 4)
    TEST_TYPE_ALIGN  (PMDINEXTMENU, 4)
    TEST_TARGET_SIZE (PMDINEXTMENU, 12)
    TEST_TARGET_ALIGN(PMDINEXTMENU, 4)
}

static void test_pack_PMEASUREITEMSTRUCT(void)
{
    /* PMEASUREITEMSTRUCT */
    TEST_TYPE_SIZE   (PMEASUREITEMSTRUCT, 4)
    TEST_TYPE_ALIGN  (PMEASUREITEMSTRUCT, 4)
    TEST_TARGET_SIZE (PMEASUREITEMSTRUCT, 24)
    TEST_TARGET_ALIGN(PMEASUREITEMSTRUCT, 4)
}

static void test_pack_PMENUITEMTEMPLATE(void)
{
    /* PMENUITEMTEMPLATE */
    TEST_TYPE_SIZE   (PMENUITEMTEMPLATE, 4)
    TEST_TYPE_ALIGN  (PMENUITEMTEMPLATE, 4)
    TEST_TARGET_SIZE (PMENUITEMTEMPLATE, 6)
    TEST_TARGET_ALIGN(PMENUITEMTEMPLATE, 2)
}

static void test_pack_PMENUITEMTEMPLATEHEADER(void)
{
    /* PMENUITEMTEMPLATEHEADER */
    TEST_TYPE_SIZE   (PMENUITEMTEMPLATEHEADER, 4)
    TEST_TYPE_ALIGN  (PMENUITEMTEMPLATEHEADER, 4)
    TEST_TARGET_SIZE (PMENUITEMTEMPLATEHEADER, 4)
    TEST_TARGET_ALIGN(PMENUITEMTEMPLATEHEADER, 2)
}

static void test_pack_PMINIMIZEDMETRICS(void)
{
    /* PMINIMIZEDMETRICS */
    TEST_TYPE_SIZE   (PMINIMIZEDMETRICS, 4)
    TEST_TYPE_ALIGN  (PMINIMIZEDMETRICS, 4)
    TEST_TARGET_SIZE (PMINIMIZEDMETRICS, 20)
    TEST_TARGET_ALIGN(PMINIMIZEDMETRICS, 4)
}

static void test_pack_PMINMAXINFO(void)
{
    /* PMINMAXINFO */
    TEST_TYPE_SIZE   (PMINMAXINFO, 4)
    TEST_TYPE_ALIGN  (PMINMAXINFO, 4)
    TEST_TARGET_SIZE (PMINMAXINFO, 40)
    TEST_TARGET_ALIGN(PMINMAXINFO, 4)
}

static void test_pack_PMOUSEHOOKSTRUCT(void)
{
    /* PMOUSEHOOKSTRUCT */
    TEST_TYPE_SIZE   (PMOUSEHOOKSTRUCT, 4)
    TEST_TYPE_ALIGN  (PMOUSEHOOKSTRUCT, 4)
    TEST_TARGET_SIZE (PMOUSEHOOKSTRUCT, 20)
    TEST_TARGET_ALIGN(PMOUSEHOOKSTRUCT, 4)
}

static void test_pack_PMOUSEINPUT(void)
{
    /* PMOUSEINPUT */
    TEST_TYPE_SIZE   (PMOUSEINPUT, 4)
    TEST_TYPE_ALIGN  (PMOUSEINPUT, 4)
    TEST_TARGET_SIZE (PMOUSEINPUT, 24)
    TEST_TARGET_ALIGN(PMOUSEINPUT, 4)
}

static void test_pack_PMSG(void)
{
    /* PMSG */
    TEST_TYPE_SIZE   (PMSG, 4)
    TEST_TYPE_ALIGN  (PMSG, 4)
    TEST_TARGET_SIZE (PMSG, 28)
    TEST_TARGET_ALIGN(PMSG, 4)
}

static void test_pack_PMSGBOXPARAMSA(void)
{
    /* PMSGBOXPARAMSA */
    TEST_TYPE_SIZE   (PMSGBOXPARAMSA, 4)
    TEST_TYPE_ALIGN  (PMSGBOXPARAMSA, 4)
    TEST_TARGET_SIZE (PMSGBOXPARAMSA, 40)
    TEST_TARGET_ALIGN(PMSGBOXPARAMSA, 4)
}

static void test_pack_PMSGBOXPARAMSW(void)
{
    /* PMSGBOXPARAMSW */
    TEST_TYPE_SIZE   (PMSGBOXPARAMSW, 4)
    TEST_TYPE_ALIGN  (PMSGBOXPARAMSW, 4)
    TEST_TARGET_SIZE (PMSGBOXPARAMSW, 40)
    TEST_TARGET_ALIGN(PMSGBOXPARAMSW, 4)
}

static void test_pack_PMSLLHOOKSTRUCT(void)
{
    /* PMSLLHOOKSTRUCT */
    TEST_TYPE_SIZE   (PMSLLHOOKSTRUCT, 4)
    TEST_TYPE_ALIGN  (PMSLLHOOKSTRUCT, 4)
    TEST_TARGET_SIZE (PMSLLHOOKSTRUCT, 24)
    TEST_TARGET_ALIGN(PMSLLHOOKSTRUCT, 4)
}

static void test_pack_PMULTIKEYHELPA(void)
{
    /* PMULTIKEYHELPA */
    TEST_TYPE_SIZE   (PMULTIKEYHELPA, 4)
    TEST_TYPE_ALIGN  (PMULTIKEYHELPA, 4)
    TEST_TARGET_SIZE (PMULTIKEYHELPA, 8)
    TEST_TARGET_ALIGN(PMULTIKEYHELPA, 4)
}

static void test_pack_PMULTIKEYHELPW(void)
{
    /* PMULTIKEYHELPW */
    TEST_TYPE_SIZE   (PMULTIKEYHELPW, 4)
    TEST_TYPE_ALIGN  (PMULTIKEYHELPW, 4)
    TEST_TARGET_SIZE (PMULTIKEYHELPW, 8)
    TEST_TARGET_ALIGN(PMULTIKEYHELPW, 4)
}

static void test_pack_PNONCLIENTMETRICSA(void)
{
    /* PNONCLIENTMETRICSA */
    TEST_TYPE_SIZE   (PNONCLIENTMETRICSA, 4)
    TEST_TYPE_ALIGN  (PNONCLIENTMETRICSA, 4)
    TEST_TARGET_SIZE (PNONCLIENTMETRICSA, 340)
    TEST_TARGET_ALIGN(PNONCLIENTMETRICSA, 4)
}

static void test_pack_PNONCLIENTMETRICSW(void)
{
    /* PNONCLIENTMETRICSW */
    TEST_TYPE_SIZE   (PNONCLIENTMETRICSW, 4)
    TEST_TYPE_ALIGN  (PNONCLIENTMETRICSW, 4)
    TEST_TARGET_SIZE (PNONCLIENTMETRICSW, 500)
    TEST_TARGET_ALIGN(PNONCLIENTMETRICSW, 4)
}

static void test_pack_PPAINTSTRUCT(void)
{
    /* PPAINTSTRUCT */
    TEST_TYPE_SIZE   (PPAINTSTRUCT, 4)
    TEST_TYPE_ALIGN  (PPAINTSTRUCT, 4)
    TEST_TARGET_SIZE (PPAINTSTRUCT, 64)
    TEST_TARGET_ALIGN(PPAINTSTRUCT, 4)
}

static void test_pack_PROPENUMPROCA(void)
{
    /* PROPENUMPROCA */
    TEST_TYPE_SIZE   (PROPENUMPROCA, 4)
    TEST_TYPE_ALIGN  (PROPENUMPROCA, 4)
}

static void test_pack_PROPENUMPROCEXA(void)
{
    /* PROPENUMPROCEXA */
    TEST_TYPE_SIZE   (PROPENUMPROCEXA, 4)
    TEST_TYPE_ALIGN  (PROPENUMPROCEXA, 4)
}

static void test_pack_PROPENUMPROCEXW(void)
{
    /* PROPENUMPROCEXW */
    TEST_TYPE_SIZE   (PROPENUMPROCEXW, 4)
    TEST_TYPE_ALIGN  (PROPENUMPROCEXW, 4)
}

static void test_pack_PROPENUMPROCW(void)
{
    /* PROPENUMPROCW */
    TEST_TYPE_SIZE   (PROPENUMPROCW, 4)
    TEST_TYPE_ALIGN  (PROPENUMPROCW, 4)
}

static void test_pack_PTITLEBARINFO(void)
{
    /* PTITLEBARINFO */
    TEST_TYPE_SIZE   (PTITLEBARINFO, 4)
    TEST_TYPE_ALIGN  (PTITLEBARINFO, 4)
    TEST_TARGET_SIZE (PTITLEBARINFO, 44)
    TEST_TARGET_ALIGN(PTITLEBARINFO, 4)
}

static void test_pack_PUSEROBJECTFLAGS(void)
{
    /* PUSEROBJECTFLAGS */
    TEST_TYPE_SIZE   (PUSEROBJECTFLAGS, 4)
    TEST_TYPE_ALIGN  (PUSEROBJECTFLAGS, 4)
    TEST_TARGET_SIZE (PUSEROBJECTFLAGS, 12)
    TEST_TARGET_ALIGN(PUSEROBJECTFLAGS, 4)
}

static void test_pack_PWINDOWINFO(void)
{
    /* PWINDOWINFO */
    TEST_TYPE_SIZE   (PWINDOWINFO, 4)
    TEST_TYPE_ALIGN  (PWINDOWINFO, 4)
    TEST_TARGET_SIZE (PWINDOWINFO, 60)
    TEST_TARGET_ALIGN(PWINDOWINFO, 4)
}

static void test_pack_PWINDOWPLACEMENT(void)
{
    /* PWINDOWPLACEMENT */
    TEST_TYPE_SIZE   (PWINDOWPLACEMENT, 4)
    TEST_TYPE_ALIGN  (PWINDOWPLACEMENT, 4)
    TEST_TARGET_SIZE (PWINDOWPLACEMENT, 44)
    TEST_TARGET_ALIGN(PWINDOWPLACEMENT, 4)
}

static void test_pack_PWINDOWPOS(void)
{
    /* PWINDOWPOS */
    TEST_TYPE_SIZE   (PWINDOWPOS, 4)
    TEST_TYPE_ALIGN  (PWINDOWPOS, 4)
    TEST_TARGET_SIZE (PWINDOWPOS, 28)
    TEST_TARGET_ALIGN(PWINDOWPOS, 4)
}

static void test_pack_PWNDCLASSA(void)
{
    /* PWNDCLASSA */
    TEST_TYPE_SIZE   (PWNDCLASSA, 4)
    TEST_TYPE_ALIGN  (PWNDCLASSA, 4)
    TEST_TARGET_SIZE (PWNDCLASSA, 40)
    TEST_TARGET_ALIGN(PWNDCLASSA, 4)
}

static void test_pack_PWNDCLASSEXA(void)
{
    /* PWNDCLASSEXA */
    TEST_TYPE_SIZE   (PWNDCLASSEXA, 4)
    TEST_TYPE_ALIGN  (PWNDCLASSEXA, 4)
    TEST_TARGET_SIZE (PWNDCLASSEXA, 48)
    TEST_TARGET_ALIGN(PWNDCLASSEXA, 4)
}

static void test_pack_PWNDCLASSEXW(void)
{
    /* PWNDCLASSEXW */
    TEST_TYPE_SIZE   (PWNDCLASSEXW, 4)
    TEST_TYPE_ALIGN  (PWNDCLASSEXW, 4)
    TEST_TARGET_SIZE (PWNDCLASSEXW, 48)
    TEST_TARGET_ALIGN(PWNDCLASSEXW, 4)
}

static void test_pack_PWNDCLASSW(void)
{
    /* PWNDCLASSW */
    TEST_TYPE_SIZE   (PWNDCLASSW, 4)
    TEST_TYPE_ALIGN  (PWNDCLASSW, 4)
    TEST_TARGET_SIZE (PWNDCLASSW, 40)
    TEST_TARGET_ALIGN(PWNDCLASSW, 4)
}

static void test_pack_SCROLLINFO(void)
{
    /* SCROLLINFO */
    TEST_TYPE_SIZE   (SCROLLINFO, 28)
    TEST_TYPE_ALIGN  (SCROLLINFO, 4)
    TEST_FIELD_SIZE  (SCROLLINFO, cbSize, 4)
    TEST_FIELD_ALIGN (SCROLLINFO, cbSize, 4)
    TEST_FIELD_OFFSET(SCROLLINFO, cbSize, 0)
    TEST_FIELD_SIZE  (SCROLLINFO, fMask, 4)
    TEST_FIELD_ALIGN (SCROLLINFO, fMask, 4)
    TEST_FIELD_OFFSET(SCROLLINFO, fMask, 4)
    TEST_FIELD_SIZE  (SCROLLINFO, nMin, 4)
    TEST_FIELD_ALIGN (SCROLLINFO, nMin, 4)
    TEST_FIELD_OFFSET(SCROLLINFO, nMin, 8)
    TEST_FIELD_SIZE  (SCROLLINFO, nMax, 4)
    TEST_FIELD_ALIGN (SCROLLINFO, nMax, 4)
    TEST_FIELD_OFFSET(SCROLLINFO, nMax, 12)
    TEST_FIELD_SIZE  (SCROLLINFO, nPage, 4)
    TEST_FIELD_ALIGN (SCROLLINFO, nPage, 4)
    TEST_FIELD_OFFSET(SCROLLINFO, nPage, 16)
    TEST_FIELD_SIZE  (SCROLLINFO, nPos, 4)
    TEST_FIELD_ALIGN (SCROLLINFO, nPos, 4)
    TEST_FIELD_OFFSET(SCROLLINFO, nPos, 20)
    TEST_FIELD_SIZE  (SCROLLINFO, nTrackPos, 4)
    TEST_FIELD_ALIGN (SCROLLINFO, nTrackPos, 4)
    TEST_FIELD_OFFSET(SCROLLINFO, nTrackPos, 24)
}

static void test_pack_SENDASYNCPROC(void)
{
    /* SENDASYNCPROC */
    TEST_TYPE_SIZE   (SENDASYNCPROC, 4)
    TEST_TYPE_ALIGN  (SENDASYNCPROC, 4)
}

static void test_pack_SERIALKEYSA(void)
{
    /* SERIALKEYSA */
    TEST_TYPE_SIZE   (SERIALKEYSA, 28)
    TEST_TYPE_ALIGN  (SERIALKEYSA, 4)
    TEST_FIELD_SIZE  (SERIALKEYSA, cbSize, 4)
    TEST_FIELD_ALIGN (SERIALKEYSA, cbSize, 4)
    TEST_FIELD_OFFSET(SERIALKEYSA, cbSize, 0)
    TEST_FIELD_SIZE  (SERIALKEYSA, dwFlags, 4)
    TEST_FIELD_ALIGN (SERIALKEYSA, dwFlags, 4)
    TEST_FIELD_OFFSET(SERIALKEYSA, dwFlags, 4)
    TEST_FIELD_SIZE  (SERIALKEYSA, lpszActivePort, 4)
    TEST_FIELD_ALIGN (SERIALKEYSA, lpszActivePort, 4)
    TEST_FIELD_OFFSET(SERIALKEYSA, lpszActivePort, 8)
    TEST_FIELD_SIZE  (SERIALKEYSA, lpszPort, 4)
    TEST_FIELD_ALIGN (SERIALKEYSA, lpszPort, 4)
    TEST_FIELD_OFFSET(SERIALKEYSA, lpszPort, 12)
    TEST_FIELD_SIZE  (SERIALKEYSA, iBaudRate, 4)
    TEST_FIELD_ALIGN (SERIALKEYSA, iBaudRate, 4)
    TEST_FIELD_OFFSET(SERIALKEYSA, iBaudRate, 16)
    TEST_FIELD_SIZE  (SERIALKEYSA, iPortState, 4)
    TEST_FIELD_ALIGN (SERIALKEYSA, iPortState, 4)
    TEST_FIELD_OFFSET(SERIALKEYSA, iPortState, 20)
    TEST_FIELD_SIZE  (SERIALKEYSA, iActive, 4)
    TEST_FIELD_ALIGN (SERIALKEYSA, iActive, 4)
    TEST_FIELD_OFFSET(SERIALKEYSA, iActive, 24)
}

static void test_pack_SERIALKEYSW(void)
{
    /* SERIALKEYSW */
    TEST_TYPE_SIZE   (SERIALKEYSW, 28)
    TEST_TYPE_ALIGN  (SERIALKEYSW, 4)
    TEST_FIELD_SIZE  (SERIALKEYSW, cbSize, 4)
    TEST_FIELD_ALIGN (SERIALKEYSW, cbSize, 4)
    TEST_FIELD_OFFSET(SERIALKEYSW, cbSize, 0)
    TEST_FIELD_SIZE  (SERIALKEYSW, dwFlags, 4)
    TEST_FIELD_ALIGN (SERIALKEYSW, dwFlags, 4)
    TEST_FIELD_OFFSET(SERIALKEYSW, dwFlags, 4)
    TEST_FIELD_SIZE  (SERIALKEYSW, lpszActivePort, 4)
    TEST_FIELD_ALIGN (SERIALKEYSW, lpszActivePort, 4)
    TEST_FIELD_OFFSET(SERIALKEYSW, lpszActivePort, 8)
    TEST_FIELD_SIZE  (SERIALKEYSW, lpszPort, 4)
    TEST_FIELD_ALIGN (SERIALKEYSW, lpszPort, 4)
    TEST_FIELD_OFFSET(SERIALKEYSW, lpszPort, 12)
    TEST_FIELD_SIZE  (SERIALKEYSW, iBaudRate, 4)
    TEST_FIELD_ALIGN (SERIALKEYSW, iBaudRate, 4)
    TEST_FIELD_OFFSET(SERIALKEYSW, iBaudRate, 16)
    TEST_FIELD_SIZE  (SERIALKEYSW, iPortState, 4)
    TEST_FIELD_ALIGN (SERIALKEYSW, iPortState, 4)
    TEST_FIELD_OFFSET(SERIALKEYSW, iPortState, 20)
    TEST_FIELD_SIZE  (SERIALKEYSW, iActive, 4)
    TEST_FIELD_ALIGN (SERIALKEYSW, iActive, 4)
    TEST_FIELD_OFFSET(SERIALKEYSW, iActive, 24)
}

static void test_pack_SOUNDSENTRYA(void)
{
    /* SOUNDSENTRYA */
    TEST_TYPE_SIZE   (SOUNDSENTRYA, 48)
    TEST_TYPE_ALIGN  (SOUNDSENTRYA, 4)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, cbSize, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, cbSize, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, cbSize, 0)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, dwFlags, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, dwFlags, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, dwFlags, 4)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, iFSTextEffect, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, iFSTextEffect, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, iFSTextEffect, 8)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, iFSTextEffectMSec, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, iFSTextEffectMSec, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, iFSTextEffectMSec, 12)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, iFSTextEffectColorBits, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, iFSTextEffectColorBits, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, iFSTextEffectColorBits, 16)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, iFSGrafEffect, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, iFSGrafEffect, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, iFSGrafEffect, 20)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, iFSGrafEffectMSec, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, iFSGrafEffectMSec, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, iFSGrafEffectMSec, 24)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, iFSGrafEffectColor, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, iFSGrafEffectColor, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, iFSGrafEffectColor, 28)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, iWindowsEffect, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, iWindowsEffect, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, iWindowsEffect, 32)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, iWindowsEffectMSec, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, iWindowsEffectMSec, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, iWindowsEffectMSec, 36)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, lpszWindowsEffectDLL, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, lpszWindowsEffectDLL, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, lpszWindowsEffectDLL, 40)
    TEST_FIELD_SIZE  (SOUNDSENTRYA, iWindowsEffectOrdinal, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYA, iWindowsEffectOrdinal, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYA, iWindowsEffectOrdinal, 44)
}

static void test_pack_SOUNDSENTRYW(void)
{
    /* SOUNDSENTRYW */
    TEST_TYPE_SIZE   (SOUNDSENTRYW, 48)
    TEST_TYPE_ALIGN  (SOUNDSENTRYW, 4)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, cbSize, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, cbSize, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, cbSize, 0)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, dwFlags, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, dwFlags, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, dwFlags, 4)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, iFSTextEffect, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, iFSTextEffect, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, iFSTextEffect, 8)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, iFSTextEffectMSec, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, iFSTextEffectMSec, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, iFSTextEffectMSec, 12)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, iFSTextEffectColorBits, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, iFSTextEffectColorBits, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, iFSTextEffectColorBits, 16)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, iFSGrafEffect, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, iFSGrafEffect, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, iFSGrafEffect, 20)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, iFSGrafEffectMSec, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, iFSGrafEffectMSec, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, iFSGrafEffectMSec, 24)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, iFSGrafEffectColor, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, iFSGrafEffectColor, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, iFSGrafEffectColor, 28)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, iWindowsEffect, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, iWindowsEffect, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, iWindowsEffect, 32)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, iWindowsEffectMSec, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, iWindowsEffectMSec, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, iWindowsEffectMSec, 36)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, lpszWindowsEffectDLL, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, lpszWindowsEffectDLL, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, lpszWindowsEffectDLL, 40)
    TEST_FIELD_SIZE  (SOUNDSENTRYW, iWindowsEffectOrdinal, 4)
    TEST_FIELD_ALIGN (SOUNDSENTRYW, iWindowsEffectOrdinal, 4)
    TEST_FIELD_OFFSET(SOUNDSENTRYW, iWindowsEffectOrdinal, 44)
}

static void test_pack_STICKYKEYS(void)
{
    /* STICKYKEYS */
    TEST_TYPE_SIZE   (STICKYKEYS, 8)
    TEST_TYPE_ALIGN  (STICKYKEYS, 4)
    TEST_FIELD_SIZE  (STICKYKEYS, cbSize, 4)
    TEST_FIELD_ALIGN (STICKYKEYS, cbSize, 4)
    TEST_FIELD_OFFSET(STICKYKEYS, cbSize, 0)
    TEST_FIELD_SIZE  (STICKYKEYS, dwFlags, 4)
    TEST_FIELD_ALIGN (STICKYKEYS, dwFlags, 4)
    TEST_FIELD_OFFSET(STICKYKEYS, dwFlags, 4)
}

static void test_pack_STYLESTRUCT(void)
{
    /* STYLESTRUCT */
    TEST_TYPE_SIZE   (STYLESTRUCT, 8)
    TEST_TYPE_ALIGN  (STYLESTRUCT, 4)
    TEST_FIELD_SIZE  (STYLESTRUCT, styleOld, 4)
    TEST_FIELD_ALIGN (STYLESTRUCT, styleOld, 4)
    TEST_FIELD_OFFSET(STYLESTRUCT, styleOld, 0)
    TEST_FIELD_SIZE  (STYLESTRUCT, styleNew, 4)
    TEST_FIELD_ALIGN (STYLESTRUCT, styleNew, 4)
    TEST_FIELD_OFFSET(STYLESTRUCT, styleNew, 4)
}

static void test_pack_TIMERPROC(void)
{
    /* TIMERPROC */
    TEST_TYPE_SIZE   (TIMERPROC, 4)
    TEST_TYPE_ALIGN  (TIMERPROC, 4)
}

static void test_pack_TITLEBARINFO(void)
{
    /* TITLEBARINFO */
    TEST_TYPE_SIZE   (TITLEBARINFO, 44)
    TEST_TYPE_ALIGN  (TITLEBARINFO, 4)
    TEST_FIELD_SIZE  (TITLEBARINFO, cbSize, 4)
    TEST_FIELD_ALIGN (TITLEBARINFO, cbSize, 4)
    TEST_FIELD_OFFSET(TITLEBARINFO, cbSize, 0)
    TEST_FIELD_SIZE  (TITLEBARINFO, rcTitleBar, 16)
    TEST_FIELD_ALIGN (TITLEBARINFO, rcTitleBar, 4)
    TEST_FIELD_OFFSET(TITLEBARINFO, rcTitleBar, 4)
    TEST_FIELD_SIZE  (TITLEBARINFO, rgstate, 24)
    TEST_FIELD_ALIGN (TITLEBARINFO, rgstate, 4)
    TEST_FIELD_OFFSET(TITLEBARINFO, rgstate, 20)
}

static void test_pack_TOGGLEKEYS(void)
{
    /* TOGGLEKEYS */
    TEST_TYPE_SIZE   (TOGGLEKEYS, 8)
    TEST_TYPE_ALIGN  (TOGGLEKEYS, 4)
    TEST_FIELD_SIZE  (TOGGLEKEYS, cbSize, 4)
    TEST_FIELD_ALIGN (TOGGLEKEYS, cbSize, 4)
    TEST_FIELD_OFFSET(TOGGLEKEYS, cbSize, 0)
    TEST_FIELD_SIZE  (TOGGLEKEYS, dwFlags, 4)
    TEST_FIELD_ALIGN (TOGGLEKEYS, dwFlags, 4)
    TEST_FIELD_OFFSET(TOGGLEKEYS, dwFlags, 4)
}

static void test_pack_TPMPARAMS(void)
{
    /* TPMPARAMS */
    TEST_TYPE_SIZE   (TPMPARAMS, 20)
    TEST_TYPE_ALIGN  (TPMPARAMS, 4)
    TEST_FIELD_SIZE  (TPMPARAMS, cbSize, 4)
    TEST_FIELD_ALIGN (TPMPARAMS, cbSize, 4)
    TEST_FIELD_OFFSET(TPMPARAMS, cbSize, 0)
    TEST_FIELD_SIZE  (TPMPARAMS, rcExclude, 16)
    TEST_FIELD_ALIGN (TPMPARAMS, rcExclude, 4)
    TEST_FIELD_OFFSET(TPMPARAMS, rcExclude, 4)
}

static void test_pack_TRACKMOUSEEVENT(void)
{
    /* TRACKMOUSEEVENT */
    TEST_TYPE_SIZE   (TRACKMOUSEEVENT, 16)
    TEST_TYPE_ALIGN  (TRACKMOUSEEVENT, 4)
    TEST_FIELD_SIZE  (TRACKMOUSEEVENT, cbSize, 4)
    TEST_FIELD_ALIGN (TRACKMOUSEEVENT, cbSize, 4)
    TEST_FIELD_OFFSET(TRACKMOUSEEVENT, cbSize, 0)
    TEST_FIELD_SIZE  (TRACKMOUSEEVENT, dwFlags, 4)
    TEST_FIELD_ALIGN (TRACKMOUSEEVENT, dwFlags, 4)
    TEST_FIELD_OFFSET(TRACKMOUSEEVENT, dwFlags, 4)
    TEST_FIELD_SIZE  (TRACKMOUSEEVENT, hwndTrack, 4)
    TEST_FIELD_ALIGN (TRACKMOUSEEVENT, hwndTrack, 4)
    TEST_FIELD_OFFSET(TRACKMOUSEEVENT, hwndTrack, 8)
    TEST_FIELD_SIZE  (TRACKMOUSEEVENT, dwHoverTime, 4)
    TEST_FIELD_ALIGN (TRACKMOUSEEVENT, dwHoverTime, 4)
    TEST_FIELD_OFFSET(TRACKMOUSEEVENT, dwHoverTime, 12)
}

static void test_pack_USEROBJECTFLAGS(void)
{
    /* USEROBJECTFLAGS */
    TEST_TYPE_SIZE   (USEROBJECTFLAGS, 12)
    TEST_TYPE_ALIGN  (USEROBJECTFLAGS, 4)
    TEST_FIELD_SIZE  (USEROBJECTFLAGS, fInherit, 4)
    TEST_FIELD_ALIGN (USEROBJECTFLAGS, fInherit, 4)
    TEST_FIELD_OFFSET(USEROBJECTFLAGS, fInherit, 0)
    TEST_FIELD_SIZE  (USEROBJECTFLAGS, fReserved, 4)
    TEST_FIELD_ALIGN (USEROBJECTFLAGS, fReserved, 4)
    TEST_FIELD_OFFSET(USEROBJECTFLAGS, fReserved, 4)
    TEST_FIELD_SIZE  (USEROBJECTFLAGS, dwFlags, 4)
    TEST_FIELD_ALIGN (USEROBJECTFLAGS, dwFlags, 4)
    TEST_FIELD_OFFSET(USEROBJECTFLAGS, dwFlags, 8)
}

static void test_pack_WINDOWINFO(void)
{
    /* WINDOWINFO */
    TEST_TYPE_SIZE   (WINDOWINFO, 60)
    TEST_TYPE_ALIGN  (WINDOWINFO, 4)
    TEST_FIELD_SIZE  (WINDOWINFO, cbSize, 4)
    TEST_FIELD_ALIGN (WINDOWINFO, cbSize, 4)
    TEST_FIELD_OFFSET(WINDOWINFO, cbSize, 0)
    TEST_FIELD_SIZE  (WINDOWINFO, rcWindow, 16)
    TEST_FIELD_ALIGN (WINDOWINFO, rcWindow, 4)
    TEST_FIELD_OFFSET(WINDOWINFO, rcWindow, 4)
    TEST_FIELD_SIZE  (WINDOWINFO, rcClient, 16)
    TEST_FIELD_ALIGN (WINDOWINFO, rcClient, 4)
    TEST_FIELD_OFFSET(WINDOWINFO, rcClient, 20)
    TEST_FIELD_SIZE  (WINDOWINFO, dwStyle, 4)
    TEST_FIELD_ALIGN (WINDOWINFO, dwStyle, 4)
    TEST_FIELD_OFFSET(WINDOWINFO, dwStyle, 36)
    TEST_FIELD_SIZE  (WINDOWINFO, dwExStyle, 4)
    TEST_FIELD_ALIGN (WINDOWINFO, dwExStyle, 4)
    TEST_FIELD_OFFSET(WINDOWINFO, dwExStyle, 40)
    TEST_FIELD_SIZE  (WINDOWINFO, dwWindowStatus, 4)
    TEST_FIELD_ALIGN (WINDOWINFO, dwWindowStatus, 4)
    TEST_FIELD_OFFSET(WINDOWINFO, dwWindowStatus, 44)
    TEST_FIELD_SIZE  (WINDOWINFO, cxWindowBorders, 4)
    TEST_FIELD_ALIGN (WINDOWINFO, cxWindowBorders, 4)
    TEST_FIELD_OFFSET(WINDOWINFO, cxWindowBorders, 48)
    TEST_FIELD_SIZE  (WINDOWINFO, cyWindowBorders, 4)
    TEST_FIELD_ALIGN (WINDOWINFO, cyWindowBorders, 4)
    TEST_FIELD_OFFSET(WINDOWINFO, cyWindowBorders, 52)
    TEST_FIELD_SIZE  (WINDOWINFO, atomWindowType, 2)
    TEST_FIELD_ALIGN (WINDOWINFO, atomWindowType, 2)
    TEST_FIELD_OFFSET(WINDOWINFO, atomWindowType, 56)
    TEST_FIELD_SIZE  (WINDOWINFO, wCreatorVersion, 2)
    TEST_FIELD_ALIGN (WINDOWINFO, wCreatorVersion, 2)
    TEST_FIELD_OFFSET(WINDOWINFO, wCreatorVersion, 58)
}

static void test_pack_WINDOWPLACEMENT(void)
{
    /* WINDOWPLACEMENT */
    TEST_TYPE_SIZE   (WINDOWPLACEMENT, 44)
    TEST_TYPE_ALIGN  (WINDOWPLACEMENT, 4)
    TEST_FIELD_SIZE  (WINDOWPLACEMENT, length, 4)
    TEST_FIELD_ALIGN (WINDOWPLACEMENT, length, 4)
    TEST_FIELD_OFFSET(WINDOWPLACEMENT, length, 0)
    TEST_FIELD_SIZE  (WINDOWPLACEMENT, flags, 4)
    TEST_FIELD_ALIGN (WINDOWPLACEMENT, flags, 4)
    TEST_FIELD_OFFSET(WINDOWPLACEMENT, flags, 4)
    TEST_FIELD_SIZE  (WINDOWPLACEMENT, showCmd, 4)
    TEST_FIELD_ALIGN (WINDOWPLACEMENT, showCmd, 4)
    TEST_FIELD_OFFSET(WINDOWPLACEMENT, showCmd, 8)
    TEST_FIELD_SIZE  (WINDOWPLACEMENT, ptMinPosition, 8)
    TEST_FIELD_ALIGN (WINDOWPLACEMENT, ptMinPosition, 4)
    TEST_FIELD_OFFSET(WINDOWPLACEMENT, ptMinPosition, 12)
    TEST_FIELD_SIZE  (WINDOWPLACEMENT, ptMaxPosition, 8)
    TEST_FIELD_ALIGN (WINDOWPLACEMENT, ptMaxPosition, 4)
    TEST_FIELD_OFFSET(WINDOWPLACEMENT, ptMaxPosition, 20)
    TEST_FIELD_SIZE  (WINDOWPLACEMENT, rcNormalPosition, 16)
    TEST_FIELD_ALIGN (WINDOWPLACEMENT, rcNormalPosition, 4)
    TEST_FIELD_OFFSET(WINDOWPLACEMENT, rcNormalPosition, 28)
}

static void test_pack_WINDOWPOS(void)
{
    /* WINDOWPOS */
    TEST_TYPE_SIZE   (WINDOWPOS, 28)
    TEST_TYPE_ALIGN  (WINDOWPOS, 4)
    TEST_FIELD_SIZE  (WINDOWPOS, hwnd, 4)
    TEST_FIELD_ALIGN (WINDOWPOS, hwnd, 4)
    TEST_FIELD_OFFSET(WINDOWPOS, hwnd, 0)
    TEST_FIELD_SIZE  (WINDOWPOS, hwndInsertAfter, 4)
    TEST_FIELD_ALIGN (WINDOWPOS, hwndInsertAfter, 4)
    TEST_FIELD_OFFSET(WINDOWPOS, hwndInsertAfter, 4)
    TEST_FIELD_SIZE  (WINDOWPOS, x, 4)
    TEST_FIELD_ALIGN (WINDOWPOS, x, 4)
    TEST_FIELD_OFFSET(WINDOWPOS, x, 8)
    TEST_FIELD_SIZE  (WINDOWPOS, y, 4)
    TEST_FIELD_ALIGN (WINDOWPOS, y, 4)
    TEST_FIELD_OFFSET(WINDOWPOS, y, 12)
    TEST_FIELD_SIZE  (WINDOWPOS, cx, 4)
    TEST_FIELD_ALIGN (WINDOWPOS, cx, 4)
    TEST_FIELD_OFFSET(WINDOWPOS, cx, 16)
    TEST_FIELD_SIZE  (WINDOWPOS, cy, 4)
    TEST_FIELD_ALIGN (WINDOWPOS, cy, 4)
    TEST_FIELD_OFFSET(WINDOWPOS, cy, 20)
    TEST_FIELD_SIZE  (WINDOWPOS, flags, 4)
    TEST_FIELD_ALIGN (WINDOWPOS, flags, 4)
    TEST_FIELD_OFFSET(WINDOWPOS, flags, 24)
}

static void test_pack_WINEVENTPROC(void)
{
    /* WINEVENTPROC */
    TEST_TYPE_SIZE   (WINEVENTPROC, 4)
    TEST_TYPE_ALIGN  (WINEVENTPROC, 4)
}

static void test_pack_WINSTAENUMPROCA(void)
{
    /* WINSTAENUMPROCA */
    TEST_TYPE_SIZE   (WINSTAENUMPROCA, 4)
    TEST_TYPE_ALIGN  (WINSTAENUMPROCA, 4)
}

static void test_pack_WINSTAENUMPROCW(void)
{
    /* WINSTAENUMPROCW */
    TEST_TYPE_SIZE   (WINSTAENUMPROCW, 4)
    TEST_TYPE_ALIGN  (WINSTAENUMPROCW, 4)
}

static void test_pack_WNDCLASSA(void)
{
    /* WNDCLASSA */
    TEST_TYPE_SIZE   (WNDCLASSA, 40)
    TEST_TYPE_ALIGN  (WNDCLASSA, 4)
    TEST_FIELD_SIZE  (WNDCLASSA, style, 4)
    TEST_FIELD_ALIGN (WNDCLASSA, style, 4)
    TEST_FIELD_OFFSET(WNDCLASSA, style, 0)
    TEST_FIELD_SIZE  (WNDCLASSA, lpfnWndProc, 4)
    TEST_FIELD_ALIGN (WNDCLASSA, lpfnWndProc, 4)
    TEST_FIELD_OFFSET(WNDCLASSA, lpfnWndProc, 4)
    TEST_FIELD_SIZE  (WNDCLASSA, cbClsExtra, 4)
    TEST_FIELD_ALIGN (WNDCLASSA, cbClsExtra, 4)
    TEST_FIELD_OFFSET(WNDCLASSA, cbClsExtra, 8)
    TEST_FIELD_SIZE  (WNDCLASSA, cbWndExtra, 4)
    TEST_FIELD_ALIGN (WNDCLASSA, cbWndExtra, 4)
    TEST_FIELD_OFFSET(WNDCLASSA, cbWndExtra, 12)
    TEST_FIELD_SIZE  (WNDCLASSA, hInstance, 4)
    TEST_FIELD_ALIGN (WNDCLASSA, hInstance, 4)
    TEST_FIELD_OFFSET(WNDCLASSA, hInstance, 16)
    TEST_FIELD_SIZE  (WNDCLASSA, hIcon, 4)
    TEST_FIELD_ALIGN (WNDCLASSA, hIcon, 4)
    TEST_FIELD_OFFSET(WNDCLASSA, hIcon, 20)
    TEST_FIELD_SIZE  (WNDCLASSA, hCursor, 4)
    TEST_FIELD_ALIGN (WNDCLASSA, hCursor, 4)
    TEST_FIELD_OFFSET(WNDCLASSA, hCursor, 24)
    TEST_FIELD_SIZE  (WNDCLASSA, hbrBackground, 4)
    TEST_FIELD_ALIGN (WNDCLASSA, hbrBackground, 4)
    TEST_FIELD_OFFSET(WNDCLASSA, hbrBackground, 28)
    TEST_FIELD_SIZE  (WNDCLASSA, lpszMenuName, 4)
    TEST_FIELD_ALIGN (WNDCLASSA, lpszMenuName, 4)
    TEST_FIELD_OFFSET(WNDCLASSA, lpszMenuName, 32)
    TEST_FIELD_SIZE  (WNDCLASSA, lpszClassName, 4)
    TEST_FIELD_ALIGN (WNDCLASSA, lpszClassName, 4)
    TEST_FIELD_OFFSET(WNDCLASSA, lpszClassName, 36)
}

static void test_pack_WNDCLASSEXA(void)
{
    /* WNDCLASSEXA */
    TEST_TYPE_SIZE   (WNDCLASSEXA, 48)
    TEST_TYPE_ALIGN  (WNDCLASSEXA, 4)
    TEST_FIELD_SIZE  (WNDCLASSEXA, cbSize, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXA, cbSize, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXA, cbSize, 0)
    TEST_FIELD_SIZE  (WNDCLASSEXA, style, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXA, style, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXA, style, 4)
    TEST_FIELD_SIZE  (WNDCLASSEXA, lpfnWndProc, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXA, lpfnWndProc, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXA, lpfnWndProc, 8)
    TEST_FIELD_SIZE  (WNDCLASSEXA, cbClsExtra, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXA, cbClsExtra, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXA, cbClsExtra, 12)
    TEST_FIELD_SIZE  (WNDCLASSEXA, cbWndExtra, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXA, cbWndExtra, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXA, cbWndExtra, 16)
    TEST_FIELD_SIZE  (WNDCLASSEXA, hInstance, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXA, hInstance, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXA, hInstance, 20)
    TEST_FIELD_SIZE  (WNDCLASSEXA, hIcon, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXA, hIcon, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXA, hIcon, 24)
    TEST_FIELD_SIZE  (WNDCLASSEXA, hCursor, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXA, hCursor, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXA, hCursor, 28)
    TEST_FIELD_SIZE  (WNDCLASSEXA, hbrBackground, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXA, hbrBackground, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXA, hbrBackground, 32)
    TEST_FIELD_SIZE  (WNDCLASSEXA, lpszMenuName, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXA, lpszMenuName, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXA, lpszMenuName, 36)
    TEST_FIELD_SIZE  (WNDCLASSEXA, lpszClassName, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXA, lpszClassName, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXA, lpszClassName, 40)
    TEST_FIELD_SIZE  (WNDCLASSEXA, hIconSm, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXA, hIconSm, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXA, hIconSm, 44)
}

static void test_pack_WNDCLASSEXW(void)
{
    /* WNDCLASSEXW */
    TEST_TYPE_SIZE   (WNDCLASSEXW, 48)
    TEST_TYPE_ALIGN  (WNDCLASSEXW, 4)
    TEST_FIELD_SIZE  (WNDCLASSEXW, cbSize, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXW, cbSize, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXW, cbSize, 0)
    TEST_FIELD_SIZE  (WNDCLASSEXW, style, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXW, style, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXW, style, 4)
    TEST_FIELD_SIZE  (WNDCLASSEXW, lpfnWndProc, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXW, lpfnWndProc, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXW, lpfnWndProc, 8)
    TEST_FIELD_SIZE  (WNDCLASSEXW, cbClsExtra, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXW, cbClsExtra, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXW, cbClsExtra, 12)
    TEST_FIELD_SIZE  (WNDCLASSEXW, cbWndExtra, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXW, cbWndExtra, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXW, cbWndExtra, 16)
    TEST_FIELD_SIZE  (WNDCLASSEXW, hInstance, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXW, hInstance, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXW, hInstance, 20)
    TEST_FIELD_SIZE  (WNDCLASSEXW, hIcon, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXW, hIcon, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXW, hIcon, 24)
    TEST_FIELD_SIZE  (WNDCLASSEXW, hCursor, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXW, hCursor, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXW, hCursor, 28)
    TEST_FIELD_SIZE  (WNDCLASSEXW, hbrBackground, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXW, hbrBackground, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXW, hbrBackground, 32)
    TEST_FIELD_SIZE  (WNDCLASSEXW, lpszMenuName, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXW, lpszMenuName, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXW, lpszMenuName, 36)
    TEST_FIELD_SIZE  (WNDCLASSEXW, lpszClassName, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXW, lpszClassName, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXW, lpszClassName, 40)
    TEST_FIELD_SIZE  (WNDCLASSEXW, hIconSm, 4)
    TEST_FIELD_ALIGN (WNDCLASSEXW, hIconSm, 4)
    TEST_FIELD_OFFSET(WNDCLASSEXW, hIconSm, 44)
}

static void test_pack_WNDCLASSW(void)
{
    /* WNDCLASSW */
    TEST_TYPE_SIZE   (WNDCLASSW, 40)
    TEST_TYPE_ALIGN  (WNDCLASSW, 4)
    TEST_FIELD_SIZE  (WNDCLASSW, style, 4)
    TEST_FIELD_ALIGN (WNDCLASSW, style, 4)
    TEST_FIELD_OFFSET(WNDCLASSW, style, 0)
    TEST_FIELD_SIZE  (WNDCLASSW, lpfnWndProc, 4)
    TEST_FIELD_ALIGN (WNDCLASSW, lpfnWndProc, 4)
    TEST_FIELD_OFFSET(WNDCLASSW, lpfnWndProc, 4)
    TEST_FIELD_SIZE  (WNDCLASSW, cbClsExtra, 4)
    TEST_FIELD_ALIGN (WNDCLASSW, cbClsExtra, 4)
    TEST_FIELD_OFFSET(WNDCLASSW, cbClsExtra, 8)
    TEST_FIELD_SIZE  (WNDCLASSW, cbWndExtra, 4)
    TEST_FIELD_ALIGN (WNDCLASSW, cbWndExtra, 4)
    TEST_FIELD_OFFSET(WNDCLASSW, cbWndExtra, 12)
    TEST_FIELD_SIZE  (WNDCLASSW, hInstance, 4)
    TEST_FIELD_ALIGN (WNDCLASSW, hInstance, 4)
    TEST_FIELD_OFFSET(WNDCLASSW, hInstance, 16)
    TEST_FIELD_SIZE  (WNDCLASSW, hIcon, 4)
    TEST_FIELD_ALIGN (WNDCLASSW, hIcon, 4)
    TEST_FIELD_OFFSET(WNDCLASSW, hIcon, 20)
    TEST_FIELD_SIZE  (WNDCLASSW, hCursor, 4)
    TEST_FIELD_ALIGN (WNDCLASSW, hCursor, 4)
    TEST_FIELD_OFFSET(WNDCLASSW, hCursor, 24)
    TEST_FIELD_SIZE  (WNDCLASSW, hbrBackground, 4)
    TEST_FIELD_ALIGN (WNDCLASSW, hbrBackground, 4)
    TEST_FIELD_OFFSET(WNDCLASSW, hbrBackground, 28)
    TEST_FIELD_SIZE  (WNDCLASSW, lpszMenuName, 4)
    TEST_FIELD_ALIGN (WNDCLASSW, lpszMenuName, 4)
    TEST_FIELD_OFFSET(WNDCLASSW, lpszMenuName, 32)
    TEST_FIELD_SIZE  (WNDCLASSW, lpszClassName, 4)
    TEST_FIELD_ALIGN (WNDCLASSW, lpszClassName, 4)
    TEST_FIELD_OFFSET(WNDCLASSW, lpszClassName, 36)
}

static void test_pack_WNDENUMPROC(void)
{
    /* WNDENUMPROC */
    TEST_TYPE_SIZE   (WNDENUMPROC, 4)
    TEST_TYPE_ALIGN  (WNDENUMPROC, 4)
}

static void test_pack_WNDPROC(void)
{
    /* WNDPROC */
    TEST_TYPE_SIZE   (WNDPROC, 4)
    TEST_TYPE_ALIGN  (WNDPROC, 4)
}

#endif /* _WIN64 */

static void test_pack(void)
{
    test_pack_ACCESSTIMEOUT();
    test_pack_ANIMATIONINFO();
    test_pack_CBTACTIVATESTRUCT();
    test_pack_CBT_CREATEWNDA();
    test_pack_CBT_CREATEWNDW();
    test_pack_CLIENTCREATESTRUCT();
    test_pack_COMBOBOXINFO();
    test_pack_COMPAREITEMSTRUCT();
    test_pack_COPYDATASTRUCT();
    test_pack_CREATESTRUCTA();
    test_pack_CREATESTRUCTW();
    test_pack_CURSORINFO();
    test_pack_CWPRETSTRUCT();
    test_pack_CWPSTRUCT();
    test_pack_DEBUGHOOKINFO();
    test_pack_DELETEITEMSTRUCT();
    test_pack_DESKTOPENUMPROCA();
    test_pack_DESKTOPENUMPROCW();
    test_pack_DLGITEMTEMPLATE();
    test_pack_DLGPROC();
    test_pack_DLGTEMPLATE();
    test_pack_DRAWITEMSTRUCT();
    test_pack_DRAWSTATEPROC();
    test_pack_DRAWTEXTPARAMS();
    test_pack_EDITWORDBREAKPROCA();
    test_pack_EDITWORDBREAKPROCW();
    test_pack_EVENTMSG();
    test_pack_FILTERKEYS();
    test_pack_FLASHWINFO();
    test_pack_GRAYSTRINGPROC();
    test_pack_GUITHREADINFO();
    test_pack_HARDWAREHOOKSTRUCT();
    test_pack_HARDWAREINPUT();
    test_pack_HDEVNOTIFY();
    test_pack_HDWP();
    test_pack_HELPINFO();
    test_pack_HELPWININFOA();
    test_pack_HELPWININFOW();
    test_pack_HIGHCONTRASTA();
    test_pack_HIGHCONTRASTW();
    test_pack_HOOKPROC();
    test_pack_ICONINFO();
    test_pack_ICONMETRICSA();
    test_pack_ICONMETRICSW();
    test_pack_INPUT();
    test_pack_KBDLLHOOKSTRUCT();
    test_pack_KEYBDINPUT();
    test_pack_LPACCESSTIMEOUT();
    test_pack_LPANIMATIONINFO();
    test_pack_LPCBTACTIVATESTRUCT();
    test_pack_LPCBT_CREATEWNDA();
    test_pack_LPCBT_CREATEWNDW();
    test_pack_LPCDLGTEMPLATEA();
    test_pack_LPCDLGTEMPLATEW();
    test_pack_LPCLIENTCREATESTRUCT();
    test_pack_LPCMENUINFO();
    test_pack_LPCMENUITEMINFOA();
    test_pack_LPCMENUITEMINFOW();
    test_pack_LPCOMBOBOXINFO();
    test_pack_LPCOMPAREITEMSTRUCT();
    test_pack_LPCREATESTRUCTA();
    test_pack_LPCREATESTRUCTW();
    test_pack_LPCSCROLLINFO();
    test_pack_LPCURSORINFO();
    test_pack_LPCWPRETSTRUCT();
    test_pack_LPCWPSTRUCT();
    test_pack_LPDEBUGHOOKINFO();
    test_pack_LPDELETEITEMSTRUCT();
    test_pack_LPDLGITEMTEMPLATEA();
    test_pack_LPDLGITEMTEMPLATEW();
    test_pack_LPDLGTEMPLATEA();
    test_pack_LPDLGTEMPLATEW();
    test_pack_LPDRAWITEMSTRUCT();
    test_pack_LPDRAWTEXTPARAMS();
    test_pack_LPEVENTMSG();
    test_pack_LPFILTERKEYS();
    test_pack_LPGUITHREADINFO();
    test_pack_LPHARDWAREHOOKSTRUCT();
    test_pack_LPHARDWAREINPUT();
    test_pack_LPHELPINFO();
    test_pack_LPHELPWININFOA();
    test_pack_LPHELPWININFOW();
    test_pack_LPHIGHCONTRASTA();
    test_pack_LPHIGHCONTRASTW();
    test_pack_LPICONMETRICSA();
    test_pack_LPICONMETRICSW();
    test_pack_LPINPUT();
    test_pack_LPKBDLLHOOKSTRUCT();
    test_pack_LPKEYBDINPUT();
    test_pack_LPMDICREATESTRUCTA();
    test_pack_LPMDICREATESTRUCTW();
    test_pack_LPMDINEXTMENU();
    test_pack_LPMEASUREITEMSTRUCT();
    test_pack_LPMENUINFO();
    test_pack_LPMENUITEMINFOA();
    test_pack_LPMENUITEMINFOW();
    test_pack_LPMINIMIZEDMETRICS();
    test_pack_LPMINMAXINFO();
    test_pack_LPMONITORINFO();
    test_pack_LPMONITORINFOEXA();
    test_pack_LPMONITORINFOEXW();
    test_pack_LPMOUSEHOOKSTRUCT();
    test_pack_LPMOUSEINPUT();
    test_pack_LPMOUSEKEYS();
    test_pack_LPMSG();
    test_pack_LPMSGBOXPARAMSA();
    test_pack_LPMSGBOXPARAMSW();
    test_pack_LPMSLLHOOKSTRUCT();
    test_pack_LPMULTIKEYHELPA();
    test_pack_LPMULTIKEYHELPW();
    test_pack_LPNCCALCSIZE_PARAMS();
    test_pack_LPNMHDR();
    test_pack_LPNONCLIENTMETRICSA();
    test_pack_LPNONCLIENTMETRICSW();
    test_pack_LPPAINTSTRUCT();
    test_pack_LPSCROLLINFO();
    test_pack_LPSERIALKEYSA();
    test_pack_LPSERIALKEYSW();
    test_pack_LPSOUNDSENTRYA();
    test_pack_LPSOUNDSENTRYW();
    test_pack_LPSTICKYKEYS();
    test_pack_LPSTYLESTRUCT();
    test_pack_LPTITLEBARINFO();
    test_pack_LPTOGGLEKEYS();
    test_pack_LPTPMPARAMS();
    test_pack_LPTRACKMOUSEEVENT();
    test_pack_LPWINDOWINFO();
    test_pack_LPWINDOWPLACEMENT();
    test_pack_LPWINDOWPOS();
    test_pack_LPWNDCLASSA();
    test_pack_LPWNDCLASSEXA();
    test_pack_LPWNDCLASSEXW();
    test_pack_LPWNDCLASSW();
    test_pack_MDICREATESTRUCTA();
    test_pack_MDICREATESTRUCTW();
    test_pack_MDINEXTMENU();
    test_pack_MEASUREITEMSTRUCT();
    test_pack_MENUINFO();
    test_pack_MENUITEMINFOA();
    test_pack_MENUITEMINFOW();
    test_pack_MENUITEMTEMPLATE();
    test_pack_MENUITEMTEMPLATEHEADER();
    test_pack_MINIMIZEDMETRICS();
    test_pack_MINMAXINFO();
    test_pack_MONITORENUMPROC();
    test_pack_MONITORINFO();
    test_pack_MONITORINFOEXA();
    test_pack_MONITORINFOEXW();
    test_pack_MOUSEHOOKSTRUCT();
    test_pack_MOUSEINPUT();
    test_pack_MOUSEKEYS();
    test_pack_MSG();
    test_pack_MSGBOXCALLBACK();
    test_pack_MSGBOXPARAMSA();
    test_pack_MSGBOXPARAMSW();
    test_pack_MSLLHOOKSTRUCT();
    test_pack_MULTIKEYHELPA();
    test_pack_MULTIKEYHELPW();
    test_pack_NAMEENUMPROCA();
    test_pack_NAMEENUMPROCW();
    test_pack_NCCALCSIZE_PARAMS();
    test_pack_NMHDR();
    test_pack_NONCLIENTMETRICSA();
    test_pack_NONCLIENTMETRICSW();
    test_pack_PAINTSTRUCT();
    test_pack_PCOMBOBOXINFO();
    test_pack_PCOMPAREITEMSTRUCT();
    test_pack_PCOPYDATASTRUCT();
    test_pack_PCURSORINFO();
    test_pack_PCWPRETSTRUCT();
    test_pack_PCWPSTRUCT();
    test_pack_PDEBUGHOOKINFO();
    test_pack_PDELETEITEMSTRUCT();
    test_pack_PDLGITEMTEMPLATEA();
    test_pack_PDLGITEMTEMPLATEW();
    test_pack_PDRAWITEMSTRUCT();
    test_pack_PEVENTMSG();
    test_pack_PFLASHWINFO();
    test_pack_PGUITHREADINFO();
    test_pack_PHARDWAREHOOKSTRUCT();
    test_pack_PHARDWAREINPUT();
    test_pack_PHDEVNOTIFY();
    test_pack_PHELPWININFOA();
    test_pack_PHELPWININFOW();
    test_pack_PICONINFO();
    test_pack_PICONMETRICSA();
    test_pack_PICONMETRICSW();
    test_pack_PINPUT();
    test_pack_PKBDLLHOOKSTRUCT();
    test_pack_PKEYBDINPUT();
    test_pack_PMDINEXTMENU();
    test_pack_PMEASUREITEMSTRUCT();
    test_pack_PMENUITEMTEMPLATE();
    test_pack_PMENUITEMTEMPLATEHEADER();
    test_pack_PMINIMIZEDMETRICS();
    test_pack_PMINMAXINFO();
    test_pack_PMOUSEHOOKSTRUCT();
    test_pack_PMOUSEINPUT();
    test_pack_PMSG();
    test_pack_PMSGBOXPARAMSA();
    test_pack_PMSGBOXPARAMSW();
    test_pack_PMSLLHOOKSTRUCT();
    test_pack_PMULTIKEYHELPA();
    test_pack_PMULTIKEYHELPW();
    test_pack_PNONCLIENTMETRICSA();
    test_pack_PNONCLIENTMETRICSW();
    test_pack_PPAINTSTRUCT();
    test_pack_PROPENUMPROCA();
    test_pack_PROPENUMPROCEXA();
    test_pack_PROPENUMPROCEXW();
    test_pack_PROPENUMPROCW();
    test_pack_PTITLEBARINFO();
    test_pack_PUSEROBJECTFLAGS();
    test_pack_PWINDOWINFO();
    test_pack_PWINDOWPLACEMENT();
    test_pack_PWINDOWPOS();
    test_pack_PWNDCLASSA();
    test_pack_PWNDCLASSEXA();
    test_pack_PWNDCLASSEXW();
    test_pack_PWNDCLASSW();
    test_pack_SCROLLINFO();
    test_pack_SENDASYNCPROC();
    test_pack_SERIALKEYSA();
    test_pack_SERIALKEYSW();
    test_pack_SOUNDSENTRYA();
    test_pack_SOUNDSENTRYW();
    test_pack_STICKYKEYS();
    test_pack_STYLESTRUCT();
    test_pack_TIMERPROC();
    test_pack_TITLEBARINFO();
    test_pack_TOGGLEKEYS();
    test_pack_TPMPARAMS();
    test_pack_TRACKMOUSEEVENT();
    test_pack_USEROBJECTFLAGS();
    test_pack_WINDOWINFO();
    test_pack_WINDOWPLACEMENT();
    test_pack_WINDOWPOS();
    test_pack_WINEVENTPROC();
    test_pack_WINSTAENUMPROCA();
    test_pack_WINSTAENUMPROCW();
    test_pack_WNDCLASSA();
    test_pack_WNDCLASSEXA();
    test_pack_WNDCLASSEXW();
    test_pack_WNDCLASSW();
    test_pack_WNDENUMPROC();
    test_pack_WNDPROC();
}

START_TEST(generated)
{
    test_pack();
}
