/*
 * Copyright (C) 2008 Emweb bvba, Kessel-Lo, Belgium.
 *
 * See the LICENSE file for terms of use.
 */

#include <algorithm>

#include "Wt/WDefaultLayout"

namespace Wt {

WDefaultLayout::WDefaultLayout(WWidget *parent)
  : WLayout()
{ 
  if (parent)
    setLayoutInParent(parent);
}

WDefaultLayout::~WDefaultLayout()
{
  for (unsigned i = 0; i < items_.size(); ++i)
    delete items_[i];
}

void WDefaultLayout::addItem(WLayoutItem *item)
{
  items_.push_back(item);
  updateAddItem(item);
}

void WDefaultLayout::removeItem(WLayoutItem *item)
{
  int i = indexOf(item);

  if (i != -1) {
    updateRemoveItem(item);
    items_.erase(items_.begin() + i);
  }
}

WLayoutItem *WDefaultLayout::itemAt(int index) const
{
  return items_[index];
}

int WDefaultLayout::indexOf(WLayoutItem *item) const
{
  std::vector<WLayoutItem *>::const_iterator i
    = std::find(items_.begin(), items_.end(), item);

  if (i == items_.end())
    return -1;
  else
    return i - items_.begin();
}

int WDefaultLayout::count() const
{
  return items_.size();
}

}
