/*
 * Copyright (C) 2008 Emweb bvba, Kessel-Lo, Belgium.
 *
 * See the LICENSE file for terms of use.
 */

#include <cassert>

#include "FileServe.h"
#include "WtException.h"

namespace Wt {

FileServe::FileServe(const char *contents)
  : template_(contents),
    currentPos_(0)
{ }

void FileServe::setVar(const std::string& name, const std::string& value)
{
  vars_[name] = value;
}

void FileServe::stream(std::ostream& out)
{
  streamUntil(out, std::string());
}

void FileServe::streamUntil(std::ostream& out, const std::string& until)
{
  std::string currentVar;
  bool readingVar = false;

  int start = currentPos_;

  for (; template_[currentPos_]; ++currentPos_) {
    const char *s = template_ + currentPos_;

    if (readingVar) {
      if (*s == '}') {
	if (currentVar == until) {
	  ++currentPos_;
	  return;
	}

	std::map<std::string, std::string>::const_iterator i
	  = vars_.find(currentVar);

	if (i == vars_.end())
	  throw WtException("Internal error: could not find variable: "
			    + currentVar);

	out << i->second;

	readingVar = false;
	start = currentPos_ + 1;
      } else
	currentVar.push_back(*s);
    } else {
      if (*s == '$') {
	if (*(s + 1) == '{') {
	  if (currentPos_ - start > 0)
	    out.write(template_ + start, currentPos_ - start);

	  ++currentPos_;
	  readingVar = true;
	  currentVar.clear();
	}
      }
    }
  }

  if (currentPos_ - start > 0)
    out.write(template_ + start, currentPos_ - start);
}

}
