var ${WT_CLASS} = {

DOCUMENT_ELEMENT_NODE: 1,
DOCUMENT_TEXT_NODE: 3,
DOCUMENT_CDATA_SECTION_NODE: 4,
DOCUMENT_COMMENT_NODE: 8,

// Array Remove - By John Resig (MIT Licensed)
arrayRemove: function(a, from, to) {
  var rest = a.slice((to || from) + 1 || a.length);
  a.length = from < 0 ? a.length + from : from;
  return a.push.apply(a, rest);
},

isIE: navigator.userAgent.toLowerCase().indexOf("msie") != -1
  && navigator.userAgent.toLowerCase().indexOf("opera") == -1,

isGecko: navigator.userAgent.toLowerCase().indexOf("gecko") != -1,

isIEMobile: navigator.userAgent.toLowerCase().indexOf("msie 4") != -1
  || navigator.userAgent.toLowerCase().indexOf("msie 5") != -1,

setHtml: function (el, html) {
  function myImportNode(e, deep) {
    switch (e.nodeType) {
    case 1: // element
      var newNode;
      if (e.namespaceURI == null)
	newNode = document.createElement(e.nodeName);
      else
	newNode = document.createElementNS(e.namespaceURI, e.nodeName);
      if (e.attributes && e.attributes.length > 0)
	for (var i = 0, il = e.attributes.length; i < il;)
	  newNode.setAttribute(e.attributes[i].nodeName,
			       e.getAttribute(e.attributes[i++].nodeName));
      if (deep && e.childNodes.length > 0)
	for (var i = 0, il = e.childNodes.length; i < il;)
	  newNode.appendChild(myImportNode(e.childNodes[i++], deep));
      return newNode;
      break;
    case 3: // text
    case 4: // cdata
    case 5: // comment
      return document.createTextNode(e.nodeValue);
      break;
    }
  }

  if (${INNER_HTML}) {
    el.innerHTML = html;
  } else {
    var d = new DOMParser();
    var b = d.parseFromString('<div>'+html+'<\/div>','application/xhtml+xml');
    var d = b.documentElement;
    if (d.nodeType != 1) // element
      d = d.nextSibling;

    el.innerHTML = '';
    for (var i = 0, il = d.childNodes.length; i < il;)
      el.appendChild(myImportNode(d.childNodes[i++], true));
  }
},

hide: function(o) { this.getElement(o).style.display = 'none'; },

inline: function(o) { this.getElement(o).style.display = 'inline'; },

block: function(o) { this.getElement(o).style.display = 'block'; },

show: function(o) { this.getElement(o).style.display = ''; },

copyhide: function(from, to) {
  to.style.position = from.style.position;
  to.style.left = from.style.left;
  to.style.visibility = from.style.visibility;
},

cancelEvent: function(e) {
  if (e.preventDefault) e.preventDefault(); else e.returnValue=false;
  if (e.stopPropagation) e.stopPropagation(); else e.cancelBubble=true;
},

getElement: function(id) {
  var el = document.getElementById(id);
  if (!el)
    for (var i = 0; i < window.frames.length; ++i) {
      try {
        el = window.frames[i].document.getElementById(id);
        if (el)
          return el;
      } catch (e) {
      }
    }
  return el;
},

/*
 * Get coordinates of object/widget relative to page origin.
 */
widgetPageCoordinates: function(obj) {
  var objX = objY = 0;

  while (obj) {
    objX += obj.offsetLeft;
    objY += obj.offsetTop;
    
    var op = obj.offsetParent;
    if (op == null)
      obj = null;
    else {
      do {
        obj = obj.parentNode;
        objX -= obj.scrollLeft;
        objY -= obj.scrollTop;
      } while (obj != op);
    }
  }

  /* we should add document scroll offset ? */
  return { x: objX, y: objY };
},

/*
 * Get coordinates of (mouse) event relative to a widget.
 */
widgetCoordinates: function(obj, e) {
  var p = ${WT_CLASS}.pageCoordinates(e);
  var w = ${WT_CLASS}.widgetPageCoordinates(obj);
  return { x: p.x - w.x, y: p.y - w.y };
},

/*
 * Get coordinates of (mouse) event relative to page origin.
 */
pageCoordinates: function(e) {
  var posX = posY = 0;
  if (e.pageX || e.pageY) {
    posX = e.pageX; posY = e.pageY;
  } else if (e.clientX || e.clientY) {
    posX = e.clientX + document.body.scrollLeft
      + document.documentElement.scrollLeft;
    posY = e.clientY + document.body.scrollTop
      + document.documentElement.scrollTop;
  }

  return { x: posX, y: posY };
},

isKeyPress: function(e) {
  if (e.altKey || e.ctrlKey || e.metaKey)
    return false;

  var charCode = (typeof e.charCode !== 'undefined') ? e.charCode : 0;

  if (charCode > 0 || ${WT_CLASS}.isIE)
    return true;
  else
    return (e.keyCode == 13 || e.keyCode == 27 || e.keyCode == 32
	   || (e.keyCode > 46 && e.keyCode < 112));
},

px: function(c, s) {
  var v = null;
  if (document.defaultView && document.defaultView.getComputedStyle) {
    v = document.defaultView.getComputedStyle(c, null)[s];
  } else if (c.currentStyle) {
    v = c.currentStyle[s];
  } else {
    v = c.style[s];
  }
  if (v == 'auto' || v == null)
    return 0;
  var m = /^\s*(\d+)\s*px\s*$/.exec(v);
  var v = m && m.length == 2 ? m[1] : "0";
  return v ? parseInt(v) : 0;
},

pxself: function(c, s) {
  var v = c.style[s];
  if (v == 'auto' || v == null)
    return 0;
  var m = /^\s*(\d+)\s*px\s*$/.exec(v);
  var v = m && m.length == 2 ? m[1] : "0";
  return v ? parseInt(v) : 0;
},

IEwidth: function(c, min, max) {
  var r = c.parentNode.clientWidth
   - ${WT_CLASS}.px(c, 'marginLeft')
   - ${WT_CLASS}.px(c, 'marginRight')
   - ${WT_CLASS}.px(c, 'borderLeftWidth')
   - ${WT_CLASS}.px(c, 'borderRightWidth')
   - ${WT_CLASS}.px(c.parentNode, 'paddingLeft')
   - ${WT_CLASS}.px(c.parentNode, 'paddingRight');

  var m = /^\s*(\d+)\s*px\s*$/.exec(min);
  var v = m && m.length == 2 ? m[1] : "0";
  min = v ? parseInt(v) : 0;

  m = /^\s*(\d+)\s*px\s*$/.exec(max);
  v = m && m.length == 2 ? m[1] : "100000";
  max = v ? parseInt(v) : 100000;

  if (r < min)
    return min-1;
  else if (r > max)
    return max+1;
  else if (c.style["styleFloat"] != "")
    return min-1;
  else
    return "auto";
},

clone: function(o) {
  for (i in o) {
    this[i] = o[i];
  }
}

};

var ${APP_CLASS} = function() {

var downX = 0;
var downY = 0;

var saveDownPos = function(e) {
  var coords = ${WT_CLASS}.pageCoordinates(e);
  downX = coords.x;
  downY = coords.y;
};

var historyKey = null;
var historyStates = ${STATES_INIT};

var historyChange = function(newLocation, historyData) {
  if (historyData != null)
    historyStates = historyData;

  if (historyKey == null) {
    historyKey = newLocation;
    return;
  } else {
    historyKey = newLocation;
    setTimeout("${APP_CLASS}.private.update(null, 'hist', null, true);", 100);
  }
};

var historyChangeState = function(key, value) {
  if (window.dhtmlHistory) {
    historyStates[key] = value;

    historyKey = "";
    for (var key in historyStates) {
      if (key != "______array") {
        if (historyKey != "")
          historyKey += ";"
        historyKey += key + ":" + historyStates[key];
      }
    }

    window.dhtmlHistory.add(historyKey, historyStates);
  }
};

var captureElement = null;
var dragObject = null;
var dragSourceId = null;
var dragMimeType = null;
var dragDropObjects = null;
var dragOffsetX = 0;
var dragOffsetY = 0;
var dragDropTarget = null;
var dragObjectPrevStylePosition = null;
var dragObjectPrevStyleDisplay = null;
var dragObjectPrevStyleLeft = 0;
var dragObjectPrevStyleRight = 0;

var capture = function(obj) {
  captureElement = obj;
}

var dragStart = function(obj, e) {
  captureElement = null;

  /*
   * attributes used in dragger:
   *   dwid = dragWidgetId
   *   dsid = dragSourceId
   *   dmt = dragMimeType
   * attributes used in dropelement:
   *   amts = acceptMimeTypes
   *   ds = dropSignal
   */
  dragObject = ${WT_CLASS}.getElement(obj.getAttribute("dwid"));
  dragSourceId = obj.getAttribute("dsid");
  dragObjectPrevStylePosition = dragObject.style["position"];
  dragObjectPrevStyleDisplay = dragObject.style["display"];
  dragObjectPrevStyleLeft = dragObject.style["left"];
  dragObjectPrevStyleRight = dragObject.style["right"];

  dragObject.style["position"] = 'absolute';
  dragObject.style["display"] = '';

  var xy = ${WT_CLASS}.pageCoordinates(e);

  if (dragObject == obj) {
    var widgetXy = ${WT_CLASS}.widgetPageCoordinates(obj);
    dragOffsetX = xy.x - widgetXy.x;
    dragOffsetY = xy.y - widgetXy.y;
  } else {
    dragOffsetX = 0;
    dragOffsetY = 0;
  }

  dragDropObjects = [];
  dragDropTarget = null;

  dragMimeType = obj.getAttribute("dmt");
  var mimeType = "{" + dragMimeType + ":";

  function findChildElements(element) {
    if (element.getAttribute) {
      var amts = element.getAttribute("amts");
      if (amts != null && amts.indexOf(mimeType) != -1)
        dragDropObjects.push(element);
    }

    var children = element.childNodes;
    for (var i = 0; i < children.length; i++)
      findChildElements(children[i]);
  }
  
  findChildElements(document.body);

  return dragDrag(e);
};

var dragDrag = function(e) {
  if (captureElement != null) {
    if (!e) e = window.event;
    captureElement.onmousemove(e);
    return false;
  }

  var newPosX;
  var newPosY;

  if (dragObject != null) {
    var xy = ${WT_CLASS}.pageCoordinates(e);

    dragObject.style["left"] = (xy.x - dragOffsetX) + 'px';
    dragObject.style["top"] = (xy.y - dragOffsetY) + 'px';

    var prevDropTarget = dragDropTarget;
    dragDropTarget = null;

    for (x = 0; x < dragDropObjects.length; ++x) {
      theObj = dragDropObjects[x];
      var objXy = ${WT_CLASS}.widgetPageCoordinates(theObj);

      if ((xy.x > objXy.x) && (xy.x < (objXy.x + theObj.offsetWidth))
	  && (xy.y > objXy.y) && (xy.y < (objXy.y + theObj.offsetHeight))) {
	dragDropTarget = theObj;
      }
    }

    if (dragDropTarget != prevDropTarget) {
      if (dragDropTarget) {
        // indicate a drop target
        var mimeType = "{" + dragMimeType + ":";
        var amts = dragDropTarget.getAttribute("amts");
        var s = amts.indexOf(mimeType) + mimeType.length;
	var e = amts.indexOf("}", s);
	var style = amts.substring(s, e);
	if (style.length != 0) {
          dragDropTarget.setAttribute("dos", dragDropTarget.className);
	  dragDropTarget.className = style;
        }
      } else {
        // indicate no drop target
      }

      if (prevDropTarget != null) {
        // indicate no longer drop target
        prevDropTarget.className = prevDropTarget.getAttribute("dos");
      }
    }

    ${WT_CLASS}.cancelEvent(e);
    return false;
  }

  return true;
};

var dragEnd = function(e) {
  if (captureElement != null) {
    if (!e) e = window.event;
    var el = captureElement;
    captureElement = null;
    el.onmouseup(e);
    return false;
  }

  if (dragObject) {
    if (dragDropTarget) {
      dragDropTarget.className = dragDropTarget.getAttribute("dos");
      emit(dragDropTarget, "_drop", dragSourceId, dragMimeType);
    } else {
      // could not be dropped, animate it floating back ?
    }
    dragObject.style["position"] = dragObjectPrevStylePosition;
    dragObject.style["display"] = dragObjectPrevStyleDisplay;
    dragObject.style["left"] = dragObjectPrevStyleLeft;
    dragObject.style["right"] = dragObjectPrevStyleRight;

    dragObject = null;
  }
};

var userEvents = [];

var encodeEvent = function(self, e) {
  var result = "";

  if (historyKey != null)
    result += '&historyKey=' + historyKey;

  if (e == userEvents) {
    for (var i = 0; i < userEvents.length; ++i) {
      result += '&ue' + i + 'id=' + userEvents[i].id
        + '&ue' + i + 'name='
	+ encodeURIComponent(userEvents[i].name)
        + '&ue' + i + 'an=' + userEvents[i].args.length;

      for (var j = 0; j < userEvents[i].args.length; ++j)
        result += '&ue' + i + 'a' + j + '='
         + encodeURIComponent(userEvents[i].args[j]);
    }

    userEvents = [];

    return result;
  }

  if (!e)
    return result;

  result += '&type=' + e.type;

  if (e.clientX || e.clientY)
    result += '&clientX=' + e.clientX + '&clientY=' + e.clientY;

  var pageCoords = ${WT_CLASS}.pageCoordinates(e);
  var posX = pageCoords.x;
  var posY = pageCoords.y;

  if (posX || posY) {
    result += '&documentX=' + posX + '&documentY=' + posY;
    result += '&dragdX=' + (posX - downX)
      + '&dragdY=' + (posY - downY);
  }

  if (e.screenX || e.screenY)
    result += '&screenX=' + e.screenX + '&screenY=' + e.screenY;

  if (self) {
    var widgetCoords = ${WT_CLASS}.widgetPageCoordinates(self);
    var objX = widgetCoords.x;
    var objY = widgetCoords.y;
    result += '&widgetX=' + (posX - objX) + '&widgetY=' + (posY - objY);
  }

  if (e.which)
    result += '&right=' + (e.which==3);
  else
    if (e.button)
      result += '&right=' + (e.button==2);

  if (typeof e.keyCode !== 'undefined')
    result += '&keyCode=' + e.keyCode;

  if (typeof e.charCode !== 'undefined')
    result += '&charCode=' + e.charCode;

  if (e.altKey)
    result += '&altKey=1';
  if (e.ctrlKey)
    result += '&ctrlKey=1';
  if (e.metaKey)
    result += '&metaKey=1';
  if (e.shiftKey)
    result += '&shiftKey=1';

  return result;
};

var formObjects = ${FORM_OBJECTS};
var url = ${RELATIVE_URL};
var quited = false;
var norestart = false;
var loaded = false;
var responsesPending = 0;
var keepAliveTimer = null;
var inFrame = ${IN_FRAME};

var doKeepAlive = function() {
  update(null, 'none', null, false);
  keepAliveTimer = setTimeout(doKeepAlive, ${KEEP_ALIVE}000);
};

var debug = function(s) {
  document.body.innerHTML += s;
};

var setTitle = function(title) {
  if (${WT_CLASS}.isIEMobile) return;

  document.title = title;
  if (inFrame)
    window.parent.document.title = title;
};

var load = function() {
  if (!loaded) {
    loaded = true;
    setTitle(document.title);
    ${ONLOAD};
    update(null, 'load', null, false);
    keepAliveTimer = setTimeout(doKeepAlive, ${KEEP_ALIVE}000);
  }
};

var cancelFeedback = function(t) {
  clearTimeout(t);
  document.body.style.cursor = 'auto';
  var div = ${WT_CLASS}.getElement("feedback");
  if (div) div.style.display = 'none';
};

var waitFeedback = function() {
  var div = ${WT_CLASS}.getElement("feedback");
  if (div)
    div.style.display = '';
  else {
    div = document.createElement("div");
    div.id = "feedback";
    div.innerHTML = "Loading...";
    document.body.appendChild(div);
  }
  document.body.style.cursor = 'wait';
};

var handleResponse = function(msg, timer) {
  if (quited)
    return;

  try {
    eval(msg);
    ${APP_CLASS}.private.autoJavaScript();
  } catch (e) {
    alert ("Wt internal error: " + e + ", code: " +  e.code 
     + ", description: " + e.description /* + ":" + msg */);
  }

  if (timer)
    cancelFeedback(timer);

  --responsesPending;
  sendUserEvents();
};

var randomSeed = new Date().getTime();

var update = function(self, signalName, e, feedback) {
  ${APP_CLASS}.private.autoJavaScript();
  ++responsesPending;

  if (${WT_CLASS}.isIEMobile) feedback = false;

  if (quited) {
    if (norestart)
      return;
    if (confirm("The application was quited, do you want to restart?")) {
      if (inFrame)
        window.parent.document.location = window.parent.document.location;
      else
        document.location = document.location;
      norestart = true;
      return;
    } else {
      norestart = true;
      return;
    }
  }

  var query = '&rand=' + Math.round(Math.random(randomSeed) * 100000);

  var querydata = 'signal=' + signalName;
  for (x = 0; x < formObjects.length; ++x) {
    var el = ${WT_CLASS}.getElement(formObjects[x]);
    if (el == null)
      continue;

    if (el.type == 'select-multiple') {
      for (i=0; i < el.options.length; i++)
	if (el.options[i].selected)
	  querydata += '&' + formObjects[x]
	    + '=' + encodeURIComponent(el.options[i].value);
    } else if ((el.type != 'file')
	       && (((el.type != 'checkbox') && (el.type != 'radio'))
		   || el.checked))
      querydata += '&' +formObjects[x]
	+ '=' + encodeURIComponent(el.value);
  }

  querydata += encodeEvent(self, e);

  var tm = feedback ? setTimeout(waitFeedback, ${INDICATOR_TIMEOUT}) : null;

  ${APP_CLASS}.private.sendUpdate(url + query, querydata, tm);
};

var sendUserEvents = function() {
  if (responsesPending == 0
      && userEvents.length > 0) {
    update(null, "user", userEvents, true);
  }
};

var emit = function(object, name) {
  var userEvent = new Object();
  if (typeof(object) == "string")
    userEvent.id = object;
  else if (object == ${APP_CLASS})
    userEvent.id = "app";
  else
    userEvent.id = object.id;

  userEvent.name = name;
  userEvent.args = [];
  for (var i = 2; i < arguments.length; ++i) {
    if (arguments[i] === false)
      userEvent.args[i-2] = 0;
    else if (arguments[i] === true)
      userEvent.args[i-2] = 1;
    else
      userEvent.args[i-2] = arguments[i];
  }

  userEvents[userEvents.length] = userEvent;
  sendUserEvents();
};

var addTimerEvent = function(timerid, msec) {
  setTimeout('var obj=${WT_CLASS}.getElement("' + timerid + '"); '
             + 'if (obj) { obj.onclick(); }', msec);
};

var jsLibsLoaded = {};

var onJsLoad = function(path, f)
{
  if (jsLibsLoaded[path] === true)
    f();
  else
    jsLibsLoaded[path] = f;
};

var jsLoaded = function(path)
{
  if (jsLibsLoaded[path] === true)
    return;
  else {
    if (typeof jsLibsLoaded[path] !== 'undefined')
      jsLibsLoaded[path]();
    jsLibsLoaded[path] = true;
  }
};

var loadScript = function(uri, symbol)
{
  var loaded = false;
  if (symbol != "")
    loaded = !eval("typeof " + symbol + " == 'undefined'");

  if (!loaded) {
    var s = document.createElement('script');
    s.setAttribute('src', uri);
    s.onload = function() { jsLoaded(uri);};
    s.onreadystatechange = function() {
      if (s.readyState == 'complete' || s.readyState == 'loaded') {
	jsLoaded(uri);
      }
    };
    var h = document.getElementsByTagName('head')[0];
    h.appendChild(s);
  } else
    jsLoaded(uri);
};

var addStyle = function(style)
{
  var s = document.createElement('style');
  s.setAttribute('type', 'text/css');
  if (s.styleSheet) { // IE
    s.styleSheet.cssText = style;
  } else {
    var t = document.createTextNode(style);
    s.appendChild(t);
  }
  var h = document.getElementsByTagName('head')[0];
  h.appendChild(s);
};

var addStyleSheet = function(uri)
{
  var s = document.createElement('link');
  s.setAttribute('type', 'text/css');
  s.setAttribute('href', uri);
  s.setAttribute('type','text/css');
  s.setAttribute('rel','stylesheet');
  var h = document.getElementsByTagName('head')[0];
  h.appendChild(s);
};

var ImagePreloader = function(uris, callback)
{
  this.callback = callback;
  this.work = uris.length;
  this.images = [];

  if (uris.length == 0)
    callback(this.images);
  else
    for (var i = 0; i < uris.length; i++)
      this.preload(uris[i]);
};

ImagePreloader.prototype.preload = function(uri)
{
  var image = new Image;
  this.images.push(image);
  image.onload = ImagePreloader.prototype.onload;
  image.onerror = ImagePreloader.prototype.onload;
  image.onabort = ImagePreloader.prototype.onload;
  image.imagePreloader = this;

  image.src = uri;
};

ImagePreloader.prototype.onload = function()
{
  var preloader = this.imagePreloader;
  if (--preloader.work == 0)
    preloader.callback(preloader.images);
};

/*
 * Public static methods
 */
return {
  private: {
    "addStyle" : addStyle,
    "addStyleSheet" : addStyleSheet,
    "loadScript" : loadScript,
    "onJsLoad" : onJsLoad,
    "setTitle" : setTitle,
    "update" : update,
    "quit" : function() { quited = true; clearTimeout(keepAliveTimer); },
    "setFormObjects" : function(o) { formObjects = o; },
    "saveDownPos" : saveDownPos,
    "addTimerEvent" : addTimerEvent,
    "load" : load,
    "handleResponse" : handleResponse,

    "dragStart" : dragStart,
    "dragDrag" : dragDrag,
    "dragEnd" : dragEnd,
    "capture" : capture,

    "historyChangeState" : historyChangeState,
    "historyChange" : historyChange,
    "ImagePreloader" : ImagePreloader,

    "autoJavaScript" : function() { ${AUTO_JAVASCRIPT} }
  },

  "emit" : emit
};

}();

var WtSignalEmit = ${APP_CLASS}.emit;
