var _$_WT_CLASS_$_ = {

DOCUMENT_ELEMENT_NODE: 1,
DOCUMENT_TEXT_NODE: 3,
DOCUMENT_CDATA_SECTION_NODE: 4,
DOCUMENT_COMMENT_NODE: 8,

// Array Remove - By John Resig (MIT Licensed)
arrayRemove: function(a, from, to) {
  var rest = a.slice((to || from) + 1 || a.length);
  a.length = from < 0 ? a.length + from : from;
  return a.push.apply(a, rest);
},

isIE: navigator.userAgent.toLowerCase().indexOf("msie") != -1
  && navigator.userAgent.toLowerCase().indexOf("opera") == -1,

isGecko: navigator.userAgent.toLowerCase().indexOf("gecko") != -1,

isIEMobile: navigator.userAgent.toLowerCase().indexOf("msie 4") != -1
  || navigator.userAgent.toLowerCase().indexOf("msie 5") != -1,

updateDelay: this.isIE ? 10 : 51,

setHtml: function (el, html) {
  function myImportNode(e, deep) {
    var newNode, i, il;
    switch (e.nodeType) {
    case 1: // element
      if (e.namespaceURI == null)
	newNode = document.createElement(e.nodeName);
      else
	newNode = document.createElementNS(e.namespaceURI, e.nodeName);
      if (e.attributes && e.attributes.length > 0)
	for (i = 0, il = e.attributes.length; i < il;)
	  newNode.setAttribute(e.attributes[i].nodeName,
			       e.getAttribute(e.attributes[i++].nodeName));
      if (deep && e.childNodes.length > 0)
	for (i = 0, il = e.childNodes.length; i < il;)
	  newNode.appendChild(myImportNode(e.childNodes[i++], deep));
      return newNode;
      break;
    case 3: // text
    case 4: // cdata
    case 5: // comment
      return document.createTextNode(e.nodeValue);
      break;
    }
  }

  if (_$_INNER_HTML_$_) {
    el.innerHTML = html;
  } else {
    var d, b;
    d = new DOMParser();
    b = d.parseFromString('<div>'+html+'<\/div>','application/xhtml+xml');
    d = b.documentElement;
    if (d.nodeType != 1) // element
      d = d.nextSibling;

    el.innerHTML = '';
    for (var i = 0, il = d.childNodes.length; i < il;)
      el.appendChild(myImportNode(d.childNodes[i++], true));
  }
},

hide: function(o) { this.getElement(o).style.display = 'none'; },

inline: function(o) { this.getElement(o).style.display = 'inline'; },

block: function(o) { this.getElement(o).style.display = 'block'; },

show: function(o) { this.getElement(o).style.display = ''; },

copyhide: function(from, to) {
  to.style.position = from.style.position;
  to.style.left = from.style.left;
  to.style.visibility = from.style.visibility;
},

cancelEvent: function(e) {
  if (e.preventDefault) e.preventDefault(); else e.returnValue=false;
  if (e.stopPropagation) e.stopPropagation(); else e.cancelBubble=true;
},

getElement: function(id) {
  var el = document.getElementById(id);
  if (!el)
    for (var i = 0; i < window.frames.length; ++i) {
      try {
        el = window.frames[i].document.getElementById(id);
        if (el)
          return el;
      } catch (e) {
      }
    }
  return el;
},

/*
 * Get coordinates of object/widget relative to page origin.
 */
widgetPageCoordinates: function(obj) {
  var objX = objY = 0, op, lop = null;

  while (obj) {
    objX += obj.offsetLeft;
    objY += obj.offsetTop;

    op = obj.offsetParent;
    if (op == null)
      obj = null;
    else {
      lop = op;
      do {
        obj = obj.parentNode;
	if (obj.tagName.toUpperCase() === "DIV") {
	  objX -= obj.scrollLeft;
	  objY -= obj.scrollTop;
	}
      } while (obj != op);
    }
  }

  return { x: objX, y: objY };
},

/*
 * Get coordinates of (mouse) event relative to a widget.
 */
widgetCoordinates: function(obj, e) {
  var p = _$_WT_CLASS_$_.pageCoordinates(e);
  var w = _$_WT_CLASS_$_.widgetPageCoordinates(obj);
  return { x: p.x - w.x, y: p.y - w.y };
},

/*
 * Get coordinates of (mouse) event relative to page origin.
 */
pageCoordinates: function(e) {
  var posX = posY = 0;
  if (e.pageX || e.pageY) {
    posX = e.pageX; posY = e.pageY;
  } else if (e.clientX || e.clientY) {
    posX = e.clientX + document.body.scrollLeft
      + document.documentElement.scrollLeft;
    posY = e.clientY + document.body.scrollTop
      + document.documentElement.scrollTop;
  }

  return { x: posX, y: posY };
},

isKeyPress: function(e) {
  if (e.altKey || e.ctrlKey || e.metaKey)
    return false;

  var charCode = (typeof e.charCode !== 'undefined') ? e.charCode : 0;

  if (charCode > 0 || _$_WT_CLASS_$_.isIE)
    return true;
  else
    return (e.keyCode == 13 || e.keyCode == 27 || e.keyCode == 32
	   || (e.keyCode > 46 && e.keyCode < 112));
},

px: function(c, s) {
  var v = null;
  if (document.defaultView && document.defaultView.getComputedStyle) {
    v = document.defaultView.getComputedStyle(c, null)[s];
  } else if (c.currentStyle) {
    v = c.currentStyle[s];
  } else {
    v = c.style[s];
  }
  if (v == 'auto' || v == null)
    return 0;
  var m = /^\s*(\d+)\s*px\s*$/.exec(v);
  var v = m && m.length == 2 ? m[1] : "0";
  return v ? parseInt(v) : 0;
},

isHidden: function(w) {
  if (w.style.display == 'none')
    return true;
  else { 
    w = w.parentNode;
    if (w != null && w.tagName.toLowerCase() != "body")
      return _$_WT_CLASS_$_.isHidden(w);
    else
      return false;
  }
},

pxself: function(c, s) {
  var v = c.style[s];
  if (v == 'auto' || v == null)
    return 0;
  var m = /^\s*(\d+)\s*px\s*$/.exec(v);
  var v = m && m.length == 2 ? m[1] : "0";
  return v ? parseInt(v) : 0;
},

IEwidth: function(c, min, max) {
  var r = c.parentNode.clientWidth
   - _$_WT_CLASS_$_.px(c, 'marginLeft')
   - _$_WT_CLASS_$_.px(c, 'marginRight')
   - _$_WT_CLASS_$_.px(c, 'borderLeftWidth')
   - _$_WT_CLASS_$_.px(c, 'borderRightWidth')
   - _$_WT_CLASS_$_.px(c.parentNode, 'paddingLeft')
   - _$_WT_CLASS_$_.px(c.parentNode, 'paddingRight');

  var m = /^\s*(\d+)\s*px\s*$/.exec(min);
  var v = m && m.length == 2 ? m[1] : "0";
  min = v ? parseInt(v) : 0;

  m = /^\s*(\d+)\s*px\s*$/.exec(max);
  v = m && m.length == 2 ? m[1] : "100000";
  max = v ? parseInt(v) : 100000;

  if (r < min)
    return min-1;
  else if (r > max)
    return max+1;
  else if (c.style["styleFloat"] != "")
    return min-1;
  else
    return "auto";
},

clone: function(o) {
  if (o == null || typeof(o) != 'object')
    return o;
  var temp = { };
  for (var i in o) {
    temp[i] = o[i];
  }

  return temp;
},

addCss: function(cssText) {
  var s = document.createElement('style');
  s.setAttribute('type', 'text/css');
  s.id = 'main';
  if (s.styleSheet) { // IE
    s.styleSheet.cssText = cssText;
  } else {
    var t = document.createTextNode(cssText);
    s.appendChild(t);
  }
  var h = document.getElementsByTagName('head')[0];
  h.appendChild(s);
},

// from: http://www.hunlock.com/blogs/Totally_Pwn_CSS_with_Javascript
getCssRule: function(selector, deleteFlag) {
  selector=selector.toLowerCase();

  if (document.styleSheets) {
    for (var i=0; i<document.styleSheets.length; i++) {
      var styleSheet=document.styleSheets[i];
      var ii=0;
      var cssRule=false;
      do {
	if (styleSheet.cssRules)
	  cssRule = styleSheet.cssRules[ii];
	else
	  cssRule = styleSheet.rules[ii];
	if (cssRule)
	  if (cssRule.selectorText.toLowerCase()==selector)
	    if (deleteFlag=='delete') {
	      if (styleSheet.cssRules)
		styleSheet.deleteRule(ii);
	      else
		styleSheet.removeRule(ii);
	      return true;
	    } else
	      return cssRule;
	++ii;
      } while (cssRule);
    }
  }

  return false;
},

removeCssRule: function(selector) {
  return _$_WT_CLASS_$_.getCssRule(selector, 'delete');
},

addStyleSheet: function(uri) {
  var s = document.createElement('link');
  s.setAttribute('type', 'text/css');
  s.setAttribute('href', uri);
  s.setAttribute('type','text/css');
  s.setAttribute('rel','stylesheet');
  var h = document.getElementsByTagName('head')[0];
  h.appendChild(s);
},

history: (function() {
/*
Original copyright: heavily simplified for Wt
Copyright (c) 2008, Yahoo! Inc. All rights reserved.
Code licensed under the BSD License:
http://developer.yahoo.net/yui/license.txt
version: 2.5.2
*/
  var _UAwebkit = false;
  var _UAie = false;
  var _UAopera = false;
  var _onLoadFn = null;
  var _histFrame = null;
  var _stateField = null;
  var _initialized = false;
  var _fqstates = [];
  var _initialState, _currentState;
  var _onStateChange = function(){};
  function _getHash() {
    var i, href;
    href = location.href;
    i = href.indexOf("#");
    return i >= 0 ? href.substr(i + 1) : null;
  }
  function _storeStates() {
    _stateField.value = _initialState + "|" + _currentState;
    if (_UAwebkit) {
      _stateField.value += "|" + _fqstates.join(",");
    }
  }
  function _handleFQStateChange(fqstate) {
    var currentState;
    if (!fqstate) {
      _currentState = _initialState;
      _onStateChange(unescape(_currentState));
      return;
    }
    currentState = fqstate;
    if (!currentState || _currentState !== currentState) {
      _currentState = currentState || _initialState;
      _onStateChange(unescape(_currentState));
    }
  }
  function _updateIFrame (fqstate) {
    var html, doc;
    html = '<html><body><div id="state">' + fqstate
      + '</div></body></html>';
    try {
      doc = _histFrame.contentWindow.document;
      doc.open();
      doc.write(html);
      doc.close();
      return true;
    } catch (e) {
      return false;
    }
  }
  function _checkIframeLoaded() {
    var doc, elem, fqstate, hash;
    if (!_histFrame.contentWindow || !_histFrame.contentWindow.document) {
      setTimeout(_checkIframeLoaded, 10);
      return;
    }
    doc = _histFrame.contentWindow.document;
    elem = doc.getElementById("state");
    fqstate = elem ? elem.innerText : null;
    hash = _getHash();
    setInterval(function () {
	var newfqstate, newHash;
	doc = _histFrame.contentWindow.document;
	elem = doc.getElementById("state");
	newfqstate = elem ? elem.innerText : null;
	newHash = _getHash();
	if (newfqstate !== fqstate) {
	  fqstate = newfqstate;
	  _handleFQStateChange(fqstate);
	  if (!fqstate) {
	    newHash = _initialState;
	  } else {
	    newHash = fqstate;
	  }
	  location.hash = newHash;
	  hash = newHash;
	  _storeStates();
	} else if (newHash !== hash) {
	  hash = newHash;
	  _updateIFrame(newHash);
	}
      }, 50);
    _initialized = true;
    if (_onLoadFn != null)
      _onLoadFn();
  }
  function _initialize() {
    var parts, counter, hash;
    parts = _stateField.value.split("|");
    if (parts.length > 1) {
      _initialState = parts[0];
      _currentState = parts[1];
    }
    if (parts.length > 2) {
      _fqstates = parts[2].split(",");
    }
    if (_UAie) {
      _checkIframeLoaded();
    } else {
      counter = history.length;
      hash = _getHash();
      setInterval(function () {
	  var state, newHash, newCounter;
	  newHash = _getHash();
	  newCounter = history.length;
	  if (newHash !== hash) {
	    hash = newHash;
	    counter = newCounter;
	    _handleFQStateChange(hash);
	    _storeStates();
	  } else if (newCounter !== counter && _UAwebkit) {
	    hash = newHash;
	    counter = newCounter;
	    state = _fqstates[counter - 1];
	    _handleFQStateChange(state);
	    _storeStates();
	  }
	}, 50);
      _initialized = true;
      if (_onLoadFn != null)
	_onLoadFn();
    }
  }
  return {
  onReady: function (fn) {
    if (_initialized) {
      setTimeout(function () { fn(); }, 0);
    } else {
      _onLoadFn = fn;
    }
  },
  _initialize: function() {
    _initialize();
  },
  register: function (initialState, onStateChange) {
    if (_initialized) {
      throw new Error("All modules must be registered before calling YAHOO.util.History.initialize");
    }
    _initialState = escape(initialState);
    _currentState = _initialState;
    _onStateChange = onStateChange;
  },
  initialize: function (stateField, histFrame) {
    if (_initialized) {
      // The browser history manager has already been initialized.
      return;
    }
    var vendor = navigator.vendor || "";
    if (vendor === "KDE") {
    } else if (typeof window.opera !== "undefined") {
      _UAopera = true;
    } else if (typeof document.all !== "undefined") {
      _UAie = true;
    } else if (vendor.indexOf("Apple Computer, Inc.") > -1) {
      _UAwebkit = true;
    }
    if (typeof stateField === "string") {
      stateField = document.getElementById(stateField);
    }
    if (!stateField ||
	stateField.tagName.toUpperCase() !== "TEXTAREA" &&
	(stateField.tagName.toUpperCase() !== "INPUT" ||
	 stateField.type !== "hidden" &&
	 stateField.type !== "text")) {
      throw new Error("Missing or invalid argument");
    }
    _stateField = stateField;
    if (_UAie) {
      if (typeof histFrame === "string") {
	histFrame = document.getElementById(histFrame);
      }
      if (!histFrame || histFrame.tagName.toUpperCase() !== "IFRAME") {
	throw new Error("Missing or invalid argument");
      }
      _histFrame = histFrame;
    }
  },
  navigate: function (state) {
    if (!_initialized) {
      //throw new Error("The Browser History Manager is not initialized");
      return;
    }
    fqstate = state;
    if (_UAie) {
      return _updateIFrame(fqstate);
    } else {
      location.hash = fqstate;
      if (_UAwebkit) {
	_fqstates[history.length] = fqstate;
	_storeStates();
      }
      return true;
    }
  },
  getCurrentState: function () {
    if (!_initialized) {
      throw new Error("The Browser History Manager is not initialized");
    }
    return _currentState;
  }
  };
})()
};

var _$_APP_CLASS_$_ = function() {

var downX = 0;
var downY = 0;

var saveDownPos = function(e) {
  var coords = _$_WT_CLASS_$_.pageCoordinates(e);
  downX = coords.x;
  downY = coords.y;
};

var currentHash = null;

var onHashChange = function() {
  var newLocation = _$_WT_CLASS_$_.history.getCurrentState();
  if (currentHash == newLocation) {
    return;
  } else {
    currentHash = newLocation;
    setTimeout("_$_APP_CLASS_$_._p_.update(null, 'hash', null, true);", 1);
  }
};

var setHash = function(newLocation) {
  if (currentHash != newLocation) {
    currentHash = newLocation;
    _$_WT_CLASS_$_.history.navigate(escape(newLocation));
  }
};

var captureElement = null;
var dragObject = null;
var dragSourceId = null;
var dragMimeType = null;
var dragDropObjects = null;
var dragOffsetX = 0;
var dragOffsetY = 0;
var dragDropTarget = null;
var dragObjectPrevStylePosition = null;
var dragObjectPrevStyleDisplay = null;
var dragObjectPrevStyleLeft = 0;
var dragObjectPrevStyleRight = 0;

var capture = function(obj) {
  captureElement = obj;
}

var dragStart = function(obj, e) {
  captureElement = null;

  /*
   * attributes used in dragger:
   *   dwid = dragWidgetId
   *   dsid = dragSourceId
   *   dmt = dragMimeType
   * attributes used in dropelement:
   *   amts = acceptMimeTypes
   *   ds = dropSignal
   */
  dragObject = _$_WT_CLASS_$_.getElement(obj.getAttribute("dwid"));
  dragSourceId = obj.getAttribute("dsid");
  dragObjectPrevStylePosition = dragObject.style["position"];
  dragObjectPrevStyleDisplay = dragObject.style["display"];
  dragObjectPrevStyleLeft = dragObject.style["left"];
  dragObjectPrevStyleRight = dragObject.style["right"];

  dragObject.style["position"] = 'absolute';
  dragObject.style["display"] = '';
  dragObject.parentNode.removeChild(dragObject);
  document.body.appendChild(dragObject);

  var xy = _$_WT_CLASS_$_.pageCoordinates(e);

  if (dragObject == obj) {
    var widgetXy = _$_WT_CLASS_$_.widgetPageCoordinates(obj);
    dragOffsetX = xy.x - widgetXy.x;
    dragOffsetY = xy.y - widgetXy.y;
  } else {
    dragOffsetX = 0;
    dragOffsetY = 0;
  }

  dragDropObjects = [];
  dragDropTarget = null;

  dragMimeType = obj.getAttribute("dmt");
  var mimeType = "{" + dragMimeType + ":";

  function findChildElements(element) {
    if (element.getAttribute) {
      var amts = element.getAttribute("amts");
      if (amts != null && amts.indexOf(mimeType) != -1)
        dragDropObjects.push(element);
    }

    var children = element.childNodes;
    for (var i = 0; i < children.length; i++)
      findChildElements(children[i]);
  }
  
  findChildElements(document.body);

  return dragDrag(e);
};

var dragDrag = function(e) {
  if (captureElement != null) {
    if (!e) e = window.event;
    captureElement.onmousemove(e);
    return false;
  }

  if (dragObject != null) {
    var xy = _$_WT_CLASS_$_.pageCoordinates(e);

    dragObject.style["left"] = (xy.x - dragOffsetX) + 'px';
    dragObject.style["top"] = (xy.y - dragOffsetY) + 'px';

    var prevDropTarget = dragDropTarget;
    dragDropTarget = null;

    for (var x = 0; x < dragDropObjects.length; ++x) {
      theObj = dragDropObjects[x];
      var objXy = _$_WT_CLASS_$_.widgetPageCoordinates(theObj);

      if ((xy.x > objXy.x) && (xy.x < (objXy.x + theObj.offsetWidth))
	  && (xy.y > objXy.y) && (xy.y < (objXy.y + theObj.offsetHeight))) {
	dragDropTarget = theObj;
      }
    }

    if (dragDropTarget != prevDropTarget) {
      if (dragDropTarget) {
        // indicate a drop target
        var mimeType = "{" + dragMimeType + ":";
        var amts = dragDropTarget.getAttribute("amts");
        var s = amts.indexOf(mimeType) + mimeType.length;
	var e = amts.indexOf("}", s);
	var style = amts.substring(s, e);
	if (style.length != 0) {
          dragDropTarget.setAttribute("dos", dragDropTarget.className);
	  dragDropTarget.className = style;
        }
      } else {
        // indicate no drop target
      }

      if (prevDropTarget != null) {
        // indicate no longer drop target
        prevDropTarget.className = prevDropTarget.getAttribute("dos");
      }
    }

    _$_WT_CLASS_$_.cancelEvent(e);
    return false;
  }

  return true;
};

var dragEnd = function(e) {
  if (captureElement != null) {
    if (!e) e = window.event;
    var el = captureElement;
    captureElement = null;
    el.onmouseup(e);
    return false;
  }

  if (dragObject) {
    if (dragDropTarget) {
      dragDropTarget.className = dragDropTarget.getAttribute("dos");
      emit(dragDropTarget, "_drop", dragSourceId, dragMimeType);
    } else {
      // could not be dropped, animate it floating back ?
    }
    dragObject.style["position"] = dragObjectPrevStylePosition;
    dragObject.style["display"] = dragObjectPrevStyleDisplay;
    dragObject.style["left"] = dragObjectPrevStyleLeft;
    dragObject.style["right"] = dragObjectPrevStyleRight;

    dragObject = null;
  }
};

var encodeEvent = function(self, e, signal, i) {
  var se = '&e' + i;
  var result = se + 'signal=' + signal;

  if (!e)
    return result;

  if (e.id) {
    result += se + 'id=' + e.id
        + se + 'name=' + encodeURIComponent(e.name)
        + se + 'an=' + e.args.length;

    for (var j = 0; j < e.args.length; ++j)
      result += se + 'a' + j + '=' + encodeURIComponent(e.args[j]);
    return result;
  }

  var t = e.target || e.srcElement;
  while (!t.id && t.parentNode)
    t = t.parentNode;
  if (t.id)
    result += se + 'tid=' + t.id;

  if (e.clientX || e.clientY)
    result += se + 'clientX=' + e.clientX + se + 'clientY=' + e.clientY;

  var pageCoords = _$_WT_CLASS_$_.pageCoordinates(e);
  var posX = pageCoords.x;
  var posY = pageCoords.y;

  if (posX || posY) {
    result += se + 'documentX=' + posX + se + 'documentY=' + posY;
    result += se + 'dragdX=' + (posX - downX) + se + 'dragdY=' + (posY - downY);
  }

  if (e.screenX || e.screenY)
    result += se + 'screenX=' + e.screenX + se + 'screenY=' + e.screenY;

  if (self) {
    var widgetCoords = _$_WT_CLASS_$_.widgetPageCoordinates(self);
    var objX = widgetCoords.x;
    var objY = widgetCoords.y;
    result += se + 'widgetX=' + (posX - objX) + se + 'widgetY=' + (posY - objY);
  }

  if (e.which)
    result += se + 'right=' + (e.which==3);
  else
    if (e.button)
      result += se + 'right=' + (e.button==2);

  if (typeof e.keyCode !== 'undefined')
    result += se + 'keyCode=' + e.keyCode;

  if (typeof e.charCode !== 'undefined')
    result += se + 'charCode=' + e.charCode;

  if (e.altKey)
    result += se + 'altKey=1';
  if (e.ctrlKey)
    result += se + 'ctrlKey=1';
  if (e.metaKey)
    result += se + 'metaKey=1';
  if (e.shiftKey)
    result += se + 'shiftKey=1';

  if (self)
    result += se + 'scrollX=' + self.scrollLeft
      + se + 'scrollY=' + self.scrollTop
      + se + 'width=' + self.clientWidth
      + se + 'height=' + self.clientHeight;

  return result;
};

var pendingEvents = [];

var encodePendingEvents = function() {
  var result = "";

  if (currentHash != null)
    result += '&_=' + encodeURIComponent(unescape(currentHash));

  for (var i = 0; i < pendingEvents.length; ++i) {
    if (pendingEvents[i].id)
      result += encodeEvent(null, pendingEvents[i], 'user', i);
    else
      result += encodeEvent(pendingEvents[i].object, pendingEvents[i].event,
			    pendingEvents[i].signal, i);
  }

  pendingEvents = [];

  return result;
}

var formObjects = _$_FORM_OBJECTS_$_;
var url = _$_RELATIVE_URL_$_;
var quited = false;
var norestart = false;
var loaded = false;
var responsesPending = 0;
var keepAliveTimer = null;

var doKeepAlive = function() {
  update(null, 'none', null, false);
  keepAliveTimer = setTimeout(doKeepAlive, _$_KEEP_ALIVE_$_000);
};

var debug = function(s) {
  document.body.innerHTML += s;
};

var setTitle = function(title) {
  if (_$_WT_CLASS_$_.isIEMobile) return;
  document.title = title;
};

var load = function() {
  _$_WT_CLASS_$_.history._initialize();
  if (!loaded) {
    loaded = true;
    setTitle(document.title);
    _$_ONLOAD_$_;
    update(null, 'load', null, false);
    keepAliveTimer = setTimeout(doKeepAlive, _$_KEEP_ALIVE_$_000);
  }
};

var cancelFeedback = function(t) {
  clearTimeout(t);
  document.body.style.cursor = 'auto';
  var div = _$_WT_CLASS_$_.getElement("feedback");
  if (div) div.style.display = 'none';
};

var waitFeedback = function() {
  var div = _$_WT_CLASS_$_.getElement("feedback");
  if (div)
    div.style.display = '';
  else {
    div = document.createElement("div");
    div.id = "feedback";
    div.innerHTML = "Loading...";
    document.body.appendChild(div);
  }
  document.body.style.cursor = 'wait';
};

var handleResponse = function(msg, timer) {
  if (quited)
    return;

  try {
    eval(msg);
    _$_APP_CLASS_$_._p_.autoJavaScript();
  } catch (e) {
    alert("Wt internal error: " + e + ", code: " +  e.code 
     + ", description: " + e.description /* + ":" + msg */);
  }

  if (timer)
    cancelFeedback(timer);

  --responsesPending;

  if (pendingEvents.length > 0)
    scheduleUpdate(true);
};

var randomSeed = new Date().getTime();

var updateTimeout = null;

var update = function(self, signalName, e, feedback) {
  _$_APP_CLASS_$_._p_.autoJavaScript();

  var pendingEvent = new Object();
  pendingEvent.object = self;
  pendingEvent.signal = signalName;
  pendingEvent.event = _$_WT_CLASS_$_.clone(e);

  pendingEvents[pendingEvents.length] = pendingEvent;

  scheduleUpdate(feedback);
}

var scheduleUpdate = function(feedback) {
  if (responsesPending == 0) {
    if (updateTimeout == null)
      updateTimeout = setTimeout(function() { sendUpdate(feedback); },
				 _$_WT_CLASS_$_.updateDelay);
  }
}

var sendUpdate = function(feedback) {
  updateTimeout = null;
  ++responsesPending;

  if (_$_WT_CLASS_$_.isIEMobile) feedback = false;

  if (quited) {
    if (norestart)
      return;
    if (confirm("The application was quited, do you want to restart?")) {
      document.location = document.location;
      norestart = true;
      return;
    } else {
      norestart = true;
      return;
    }
  }

  var query = '&rand=' + Math.round(Math.random(randomSeed) * 100000);

  var querydata = encodePendingEvents();

  for (var x = 0; x < formObjects.length; ++x) {
    var el = _$_WT_CLASS_$_.getElement(formObjects[x]);
    if (el == null)
      continue;

    if (el.type == 'select-multiple') {
      for (var i = 0; i < el.options.length; i++)
	if (el.options[i].selected)
	  querydata += '&' + formObjects[x]
	    + '=' + encodeURIComponent(el.options[i].value);
    } else if ((el.type != 'file')
	       && (((el.type != 'checkbox') && (el.type != 'radio'))
		   || el.checked))
      querydata += '&' +formObjects[x]
	+ '=' + encodeURIComponent(el.value);
  }

  var tm = feedback ? setTimeout(waitFeedback, _$_INDICATOR_TIMEOUT_$_) : null;

  _$_APP_CLASS_$_._p_.sendUpdate(url + query, querydata, tm);
};

var emit = function(object, name) {
  var userEvent = new Object();

  if (typeof(object) == "string")
    userEvent.id = object;
  else if (object == _$_APP_CLASS_$_)
    userEvent.id = "app";
  else
    userEvent.id = object.id;

  userEvent.name = name;
  userEvent.args = [];
  for (var i = 2; i < arguments.length; ++i) {
    if (arguments[i] === false)
      userEvent.args[i-2] = 0;
    else if (arguments[i] === true)
      userEvent.args[i-2] = 1;
    else
      userEvent.args[i-2] = arguments[i];
  }

  pendingEvents[pendingEvents.length] = userEvent;

  if (responsesPending == 0)
    scheduleUpdate(true);
};

var addTimerEvent = function(timerid, msec) {
  setTimeout('var obj=_$_WT_CLASS_$_.getElement("' + timerid + '"); '
             + 'if (obj) { obj.onclick(); }', msec);
};

var jsLibsLoaded = {};

var onJsLoad = function(path, f)
{
  if (jsLibsLoaded[path] === true)
    f();
  else
    jsLibsLoaded[path] = f;
};

var jsLoaded = function(path)
{
  if (jsLibsLoaded[path] === true)
    return;
  else {
    if (typeof jsLibsLoaded[path] !== 'undefined')
      jsLibsLoaded[path]();
    jsLibsLoaded[path] = true;
  }
};

var loadScript = function(uri, symbol)
{
  var loaded = false;
  if (symbol != "")
    loaded = !eval("typeof " + symbol + " == 'undefined'");

  if (!loaded) {
    var s = document.createElement('script');
    s.setAttribute('src', uri);
    s.onload = function() { jsLoaded(uri);};
    s.onreadystatechange = function() {
      if (s.readyState == 'complete' || s.readyState == 'loaded') {
	jsLoaded(uri);
      }
    };
    var h = document.getElementsByTagName('head')[0];
    h.appendChild(s);
  } else
    jsLoaded(uri);
};

var ImagePreloader = function(uris, callback)
{
  this.callback = callback;
  this.work = uris.length;
  this.images = [];

  if (uris.length == 0)
    callback(this.images);
  else
    for (var i = 0; i < uris.length; i++)
      this.preload(uris[i]);
};

ImagePreloader.prototype.preload = function(uri)
{
  var image = new Image;
  this.images.push(image);
  image.onload = ImagePreloader.prototype.onload;
  image.onerror = ImagePreloader.prototype.onload;
  image.onabort = ImagePreloader.prototype.onload;
  image.imagePreloader = this;

  image.src = uri;
};

ImagePreloader.prototype.onload = function()
{
  var preloader = this.imagePreloader;
  if (--preloader.work == 0)
    preloader.callback(preloader.images);
};

_$_WT_CLASS_$_.history.register('_$_INITIAL_HASH_$_', onHashChange);

/*
 * Public static methods
 */
return {
  _p_: {
    "loadScript" : loadScript,
    "onJsLoad" : onJsLoad,
    "setTitle" : setTitle,
    "update" : update,
    "quit" : function() { quited = true; clearTimeout(keepAliveTimer); },
    "setFormObjects" : function(o) { formObjects = o; },
    "saveDownPos" : saveDownPos,
    "addTimerEvent" : addTimerEvent,
    "load" : load,
    "handleResponse" : handleResponse,

    "dragStart" : dragStart,
    "dragDrag" : dragDrag,
    "dragEnd" : dragEnd,
    "capture" : capture,

    "onHashChange" : onHashChange,
    "setHash" : setHash,
    "ImagePreloader" : ImagePreloader,

    "autoJavaScript" : function() { _$_AUTO_JAVASCRIPT_$_ }
  },

  "emit" : emit
};

}();

var WtSignalEmit = _$_APP_CLASS_$_.emit;
var scriptLoaded = false;

function onLoad() {
  if (!scriptLoaded) {
    isLoaded = true;
    return;
  }

  _$_WT_CLASS_$_.history.initialize("Wt-history-field", "Wt-history-iframe");
  window.onresize=_$_APP_CLASS_$_._p_.autoJavaScript;
  document.body.onmousemove=function(e) {
    if (!e) e = window.event;
    return _$_APP_CLASS_$_._p_.dragDrag(e);
  }
  document.body.onmouseup=function(e) {
    if (!e) e = window.event;
    return _$_APP_CLASS_$_._p_.dragEnd(e);
  }
  document.body.ondragstart=function() {
    return false;
  };
  _$_APP_CLASS_$_._p_.load();
}

function loadWidgetTree() { }
