/*
 *  error.c:		Error handling
 *
 *  Written by:		Stefan Frank
 *			Ullrich Hafner
 *  
 *  Credits:	Modelled after variable argument routines from Jef
 *		Poskanzer's pbmplus package. 
 *  
 *  Copyright (C) 1998 Ullrich Hafner <hafner@bigfoot.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

/*
 *  $Date: 2000/01/23 13:45:24 $
 *  $Author: hafner $
 *  $Revision: 1.12 $
 *  $State: Exp $
 */

#define _ERROR_C

#include "config.h"

#include <stdio.h>
#include <gtk/gtk.h>

#if STDC_HEADERS
#	include <stdarg.h>
#else  /* not STDC_HEADERS */
#	include <varargs.h>
#endif /* not STDC_HEADERS */

#include "misc.h"

#include "error.h"

/*******************************************************************************

			     global variables
  
*******************************************************************************/

int		error_line  = 0;
char		*error_file = NULL;
enum verbosity verboselevel = SOMEVERBOSITY;

extern GtkWidget *log_text;

/*******************************************************************************

			       public code
  
*******************************************************************************/

void
_error (const char *format, ...)
/*
 *  Print error message and exit.
 *
 *  No return value.
 */
{
   va_list	args;

   va_start (args, format);
   {
      char *tmp = g_strdup_printf (_("%s: line %d:\nError: %s\n"),
				   error_file, error_line, format);
      g_logv ("Wmakerconf", G_LOG_LEVEL_ERROR, tmp, args);
      Free (tmp);
   }
   va_end(args);
   exit (1);
}

void 
_warning (const char *format, ...)
/*
 *  Issue a warning and continue execution.
 *
 *  No return value.
 */
{
   va_list	args;

   va_start (args, format);

   if (verboselevel == NOVERBOSITY)
      return;
   {
      char *text    = g_strdup_printf (_("%s: line %d:\nWarning: %s\n"),
				       error_file, error_line, format);
      char *message = g_strdup_vprintf (text, args);
      char *newline = "\n";

      g_log ("Wmakerconf", G_LOG_LEVEL_WARNING, message);
      Free (text);
      gtk_text_insert (GTK_TEXT (log_text), NULL, NULL, NULL, message, -1);
      Free (message);
      gtk_text_insert (GTK_TEXT (log_text), NULL, NULL, NULL, newline, -1);
   }
   va_end (args);
}

void 
message (const char *format, ...)
/*
 *  Print a message to stderr.
 */
{
   va_list args;
     
   va_start (args, format);

   if (verboselevel == NOVERBOSITY)
      return;

   {
      char *message = g_strdup_vprintf (format, args);
      char *newline = "\n";
      
      gtk_text_insert (GTK_TEXT (log_text), NULL, NULL, NULL, message, -1);
      Free (message);
      gtk_text_insert (GTK_TEXT (log_text), NULL, NULL, NULL, newline, -1);
   }
   
   va_end (args);
}

