# Customize to fit your system

# paths
PREFIX      = /usr/local
CONFPREFIX  = ${PREFIX}/etc
MANPREFIX   = ${PREFIX}/share/man
SHAREPREFIX = ${PREFIX}/share

INCDIR      = ${PREFIX}/include
LIBDIR      = ${PREFIX}/lib
X11DIR      = /usr/X11R6

# includes and libs
INCLUDES    = -I. -I${INCDIR} -I/usr/include -I${X11DIR}/include
LIBS        = -L${LIBDIR} -L/usr/lib -lc -lm -L${X11DIR}/lib -lX11
DRAW        = xlib

# cairo support
#DRAW        = cairo
#CAIROFLAGS  = -lcairo
#CAIROINC    = -I/usr/include/cairo -I${INCDIR}/cairo

# str{l,n}{cat,cpy} support, if you have OpenBSD you can use strl*
STRLCPY     = strncpy
STRLCAT     = strncat
STRLFLAGS   = -DSTRLCPY=${STRLCPY} -DSTRLCAT=${STRLCAT}

# compiler
VERSION     = 2
# Note: - under Solaris add -D__EXTENSIONS__ to CFLAGS
CFLAGS      = -O0 -g -Wall -pedantic ${INCLUDES} ${STRLFLAGS} -DDRAW=\"${DRAW}\" -DVERSION=\"${VERSION}\"
LDFLAGS     = -g ${LIBS}
#CFLAGS      = -Os ${INCLUDES} ${STRLFLAGS} -DDRAW=\"${DRAW}\" -DVERSION=\"${VERSION}\"
#LDFLAGS     = ${LIBS}

# userland
AR          = ar cr
CC          = cc
YACC        = yacc
CP          = cp -f
COMPRESS    = bzip2
INSTBIN     = ${CP}
INSTDATA    = ${CP}
MODBIN      = chmod 755
MODDATA     = chmod 444
MKDIR       = mkdir
RANLIB      = ranlib
RM          = rm -f
TAR         = tar
PYTHON      = python
SED         = sed

# code formatting
INDENT      = indent -nbad -bap -bbo -nbc -br -brs -c33 -cd33 -ncdb -ce -ci4 -cli0 -cp33 -cs -d0 -di1 -nfc1 -nfca -hnl -i4 -ip0 -l75 -lp -npcs -nsaf -nsai -nsaw -nprs -nsc -nsob -nss -nut
