#!/usr/bin/python
################################################################################
# Copyright (c) 2005 Christian Dietrich <stettberger@gmx.de>                   #
#                                                                              #
# Permission is hereby granted, free of charge, to any person obtaining a copy #
# of this software and associated documentation files (the "Software"), to     #
# deal in the Software without restriction, including without limitation the   #
# rights to use, copy, modify, merge, publish, distribute, sublicense, and/or  #
# sell copies of the Software, and to permit persons to whom the Software is   #
# furnished to do so, subject to the following conditions:                     #
#                                                                              #
# The above copyright notice and this permission notice shall be included in   #
# all copies or substantial portions of the Software.                          #
#                                                                              #
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR   #
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,     #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE  #
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER       #
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING      #
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS #
# IN THE SOFTWARE.                                                             #
################################################################################

from fuse import Fuse
import ixplib
import re, sys, os, getopt

Version="0.1"

class IxpFs(Fuse):
    __doc__="""Mount a Ixp Filesystem (provided by a IXP-Socket) to a spezific mountpoint
(requires fuse, python2.3, python2.3-fuse, ixplib)"""
    def __init__(self, *args, **kw):
        ## Parse Argv
        optlist, args = getopt.getopt(sys.argv[1:], 's:m:hv',['help'])
        try:
            socket=os.environ['WMIR_SOCKET']
        except:
            socket="%s/.wmii/ixp/wmifs-%s" % (os.getenv('HOME'), os.getenv('DISPLAY'))
        mount=None
        for o, a in optlist:
            if o in ( "-h", "--help"):
                self.usage()
                sys.exit(0)
            if o == "-v":
                self.version()
                sys.exit(0)
            if o == "-s":
                socket=a
            if o == "-m":
                mount=a
        if mount==None:
            self.usage()
            sys.exit(-1)
        Fuse.__init__(self, *args, **kw)
        self.mountpoint=mount
        self.socket=ixplib.Client(socket)
    def usage(self):
        print """usage: %s [-s <socket file>] [-v] [-m <mountpoint>] [-h]
    -s   socket file (default: WMIR_SOCKET environment variable)
    -m   where the ixpfs is mounted to
    -h   print out this help message
    -v   version info"""%(sys.argv[0])
    def version(self):
        print """IxpFs - IXP Filesystem - %s
  2005    Christian Dietrich"""%(Version)
    def getdir (self,path):
        fd=self.socket.open(path)
        dirlist=self.socket.read(fd).split("\n")
        self.socket.close(fd)        
        list=[]
        for i in range(0,len(dirlist)-1):
	    if (re.search(".*/$", dirlist[i])):
	        dirlist[i]=re.sub("/$", "", dirlist[i])
            list.append((dirlist[i], 0))
        list.append((".",0))
        list.append(("..",0))
        return list
    def getattr(self, path):
        if (path=="/") or self.is_directory(path):
            ret= (16768, 0, 0, 0, os.geteuid(), os.getegid(), 0, 1116774319, 1113741997, 1113741997)
        else:
            ret=(33152,0,0,0, os.geteuid(), os.getegid(),len(self.read(path,0,0)),0,0,0)
        return ret
    def open(self, path, flags):
        try:
            fd=self.socket.open(path)
            self.socket.close(fd)
            return 0
        except ixplib.ClientError:
            self.socket.create(path)
            return 0
    def read(self, path, len, offset):
        self.open(path,0)
        path.replace("$TEMPDIR", "")
        fd=self.socket.open(path)
        content=self.socket.read(fd)
        self.socket.close(fd)
        return content+"\n"
    """
    This Function tests if $path is a directoy (then it returns True) or not (then it returns False)
    """
    def is_directory(self,path):
        path=re.sub("^/", "", path)
        teile=path.split("/")
        pfad=""
        for i in range(0, len(teile)-1):
            pfad="%s/%s" % (pfad, teile[i])
        file=teile[len(teile)-1]
        if re.search("^\s*$", pfad):
            pfad="/"
        fd=self.socket.open(pfad)
        dirs=self.socket.read(fd)
        dirs=dirs.split("\n")
        self.socket.close(fd)
        for i in range(0,len(dirs)-1):
            if (file+"/")==dirs[i]:
                return True
        return False
    def write(self, path, buf, off):
        fd=self.socket.open(path)
        buf=buf.split("\n")
        buf=buf[0]
        self.socket.write(fd, buf)
        self.socket.close(fd)
    def release(self, path, flags):
        return 0
    def utime(self, path, times):
        return 0
    def truncate(self, path, size):
        return 0
    def mknod(self, path, mode, dev):
        self.socket.create(path)
    def unlink (self, path):
        self.socket.remove(path)

server=IxpFs()
server.mulitthreaded=1
server.main()

