#include "defines.h"

#ifdef HAVE_IMAP
#include "imapclient.h"
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

struct imap_struct {
	struct sockaddr_in server;
	struct hostent *hp;
	int s;
	int numunread;
	int numtotal;
};

Imap initImap(void) {

	Imap ic;

	ic = (Imap)malloc( sizeof(*ic) );
	if( ic == 0 )
		return 0;
	ic->numtotal = -1;
	ic->numunread = -1;

	return ic;
}

int imapConnect(Imap ic, char *serverName, int port) {
	if((ic->s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
		return -1;
	memset( &(ic->server), 0, sizeof(ic->server) );
	ic->server.sin_family = AF_INET;
	if((ic->hp = gethostbyname(serverName)) <= 0)
		return -1;
	memcpy( &(ic->server.sin_addr), ic->hp->h_addr, ic->hp->h_length );
	ic->server.sin_port = htons(port);
	if( connect( ic->s, (struct sockaddr *)&(ic->server), sizeof(ic->server)) < 0)
		return -1;
	return 0;
}

int imapLogin(Imap ic, char *user, char *pass) {
	int size;
	char in[1024];
	char temp[1024];
	char out[1024];

	size = recv(ic->s, in, 1024, 0);
	bzero(temp, 1024);
	memcpy(temp, in, size);
	if( temp[0] != '*' )
		return -1;
	snprintf( out, 1024, "A0001 LOGIN %s %s\r\n", user, pass);
	send(ic->s, out, strlen(out), 0);
	size = recv(ic->s, in, 1024, 0);
	bzero(temp, 1024);
	memcpy(temp, in, size);
	if( strstr(temp, "OK") != NULL )
		return 0;
	return -1;
}

int imapCheckMail(Imap ic, char *folder) {
	int size;
	int num;
	char *in = malloc(1024);
	char *out = malloc(1024);

	snprintf(out, 1024, "A0002 EXAMINE %s\r\n", folder);
	send(ic->s, out, strlen(out), 0);
	size = recv(ic->s, in, 1024, 0);

	if( strstr(in, "OK") == NULL)
		return -1;

	while( (in = strchr(in, '\n')) ) {
		if(ic->numtotal == -1) {
			if(sscanf(in, "\n* %d EXISTS\n", &num) == 1) {
				ic->numtotal = num;
			}
		} else {
			if(sscanf(in, "\n* %d RECENT\n", &num) == 1) {
				ic->numunread = num;
				break;
			}
		}
		in++;
	}

	return 0;
}

int imapGetTotalMess( Imap ic ) {
	if( ic != 0 )
		return ic->numtotal;
	return -1;
}

int imapGetUnreadMess( Imap ic ) {
	if( ic != 0 )
		return ic->numunread;
	return -1;
}

int imapQuit( Imap ic ) {
	int size;
	char in[1024];

	send(ic->s, "A0003 LOGOUT\r\n", 1024, 0);
	size = recv(ic->s, in, 1024, 0);
	if(ic->s != 0)
		close(ic->s);
	return 0;
}
#endif /* HAVE_IMAP */

