/*
 *  wmmisc - WindowMaker Dockapp for monitoring misc. information.
 *  Copyright (C) 2003-2004 Jesse S. (luxorfalls@sbcglobal.net)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <getopt.h>
#include <signal.h>

#ifdef USE_MTRACE
#include <mcheck.h>
#endif /* USE_MTRACE */

#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include "wmgeneral.h"

#include "wmmisc-master.xpm"
#include "dockapp_main.h"
#include "dockapp_draw.h"
#include "dockapp_utils.h"

void
dockapp_show_help (const char *wm_name)
{
  printf ("Usage: %s [OPTION]...\n", wm_name);
  printf ("This is a simple WindowMaker 'DockApp' that will monitor the following:\n");
  printf ("Number of users logged in, total processes, total number of processes running,\n");
  printf ("the system's fork count and load average.\n\n");
  printf ("                -h       display this help and exit\n");
  printf ("                -v       output version information and exit\n\n");
  printf ("Report bugs to <%s>\n", DOCKAPP_AUTHOR_EMAIL);
}

void
dockapp_show_version (void)
{
  printf ("%s %d.%d\n", DOCKAPP_NAME, DOCKAPP_MAJOR_VERSION,
	  DOCKAPP_MINOR_VERSION);
  printf ("Written by %s <%s>\n\n", DOCKAPP_AUTHOR, DOCKAPP_AUTHOR_EMAIL);
  printf ("Copyright (C) 2003-2004 %s\n", DOCKAPP_AUTHOR);
  printf ("This is free software; see the source for copying conditions.  There is NO\n");
  printf ("warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n");
}

void
dockapp_exit (int signal_received)
{
#ifdef USE_MTRACE
  muntrace ();
#endif /* USE_MTRACE */

#ifdef DEBUG
  fprintf (stderr, "%s: Exiting cleanly with signal %d\n", DOCKAPP_NAME,
	   signal_received);
#endif /* DEBUG */

  exit (0);
}

void
dockapp_crash (int signal_received)
{
  fprintf (stderr, "%s: got signal %d -- bailing out!\n", DOCKAPP_NAME,
	   signal_received);
  fprintf (stderr, "It appears that %s has encountered an error.\n",
	   DOCKAPP_NAME);
  fprintf (stderr,
	   "If this continues to happen, please run '%s core' from a debugger,\n",
	   DOCKAPP_NAME);
  fprintf (stderr, "such as gdb, and report the output to <%s>.\n",
	   DOCKAPP_AUTHOR_EMAIL);

  abort ();
}

int
main (int argc, char *argv[])
{
  int opt = 0;

#ifdef USE_MTRACE
  mtrace ();
#endif /* USE_MTRACE */

  signal (SIGINT, dockapp_exit);
  signal (SIGSEGV, dockapp_crash);

  while ((opt = getopt (argc, argv, "hv")) != -1)
    {
      switch (opt)
	{
	case ('h'):
	  dockapp_show_help (argv[0]);
	  break;

	case ('v'):
	  dockapp_show_version ();
	  break;
	}

      exit (0);
    }

  createXBMfromXPM (wmmisc_mask_bits, wmmisc_master_xpm,
		    wmmisc_mask_width, wmmisc_mask_height);

  openXwindow (argc, argv, wmmisc_master_xpm, wmmisc_mask_bits,
	       wmmisc_mask_width, wmmisc_mask_height);

  RedrawWindowXY (0, 0);

  dockapp_draw_small_str ("USERS", 4, 4);
  dockapp_draw_small_str ("PROCS", 4, 11);
  dockapp_draw_small_str ("ACTIVE", 4, 18);

  dockapp_draw_small_str ("UP", 4, 28);
  dockapp_draw_small_str ("DAYS", 4, 37);
  dockapp_draw_small_str ("WEEKS", 4, 44);

  dockapp_draw_small_str ("LOAD", 4, 53);

  dockapp_draw_data ();

  do
    {
      dockapp_draw_data ();

      usleep (250000L);
    } while (1);

  return 0;
}
