
#include "libbab.h"

#include <iostream>

using std::cout;
using std::endl;

bool check_arg(int nargs,int actual) {
    if ( (actual+1) < nargs )
        return true;
    else {
        cout << "Warning: parameter expected" << endl;
        return false;
    }
}

void show_help(const char *program) {
    cout << "Usage: " << program << " --path path_to_dictionary"
        << " --dict dictionary_file word" << endl ;

}

int main( int argc , char * argv[] )
{
    string dictionary = "Engtospa.dic";
    string path = "/usr/share/wordtrans";
    string word;

    if (argc==1) { show_help(argv[0]); return EXIT_FAILURE ; }

    if (argc>1) for (int c=1;c<argc;c++) {

        if (strcmp(argv[c],"--help")==0) {
            show_help(argv[0]);
            return 0;
        }
        else
        if (strcmp(argv[c],"--path")==0) {
            if (check_arg(argc,c)) {
                path = argv[++c];
            }
        }
        else
        if (strcmp(argv[c],"--dict")==0) {
            if (check_arg(argc,c)) {
                dictionary = argv[++c];
            }
        }
        else {
            word = argv[c];
        }
    }

#ifdef DEBUG
    cout << "path: '" << path.c_str() << "' dictionary: '"
        << dictionary.c_str() << "' word: '" << word.c_str() << "'" << endl;
#endif

    babylon *bab = babylon::create_babylon( dictionary );
    bab->set_path( path ) ;
    bab->open( dictionary ) ;

    babylon::container_type lst ;
    if ( ! bab->translate( word, lst ) )
    return EXIT_FAILURE ;
    for ( babylon::container_type::const_iterator
        it = lst.begin() ;
        it != lst.end() ;
        ++ it ) {
        cout << "- " << it->word ;
#ifdef WANT_ATTRIB
        cout << "(" << it->attrib << ")" ;
#endif
    cout << ":\n" ;
        cout << it->definition << '\n' ;
    cout << endl ;
    }

    delete bab;

    return 0 ;
}

