/* datei.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: datei.h,v 1.58 2005/02/07 22:40:34 ralf Exp $ */

#ifndef DATEI_H
#define DATEI_H

#include "wdefines.h"
#include <aguix/util.h>
#include <aguix/fieldlistview.h>
#include <aguix/fieldlistviewdnd.h>
#include "worker_types.h"
#include <vector>
#include <list>

/* vvv Nur eins davon kann gleichzeitig aktiv sein, also durch numerieren */
enum { SORT_NAME = 0,
       SORT_SIZE,
       SORT_ACCTIME,
       SORT_MODTIME,
       SORT_CHGTIME,
       SORT_TYPE,
       SORT_OWNER,
       SORT_INODE,
       SORT_NLINK };

/* for checking valid sortmode */
#define ISVALID_SORTMODE(sortmode) ( ( ( sortmode & 0xff ) >= SORT_NAME ) && ( ( sortmode & 0xff ) <= SORT_NLINK ) )

/* vvv Dient zur Ver-Oderung mit dem Mode */
#define SORT_REVERSE 256
enum {SORT_DIRLAST=512,SORT_DIRMIXED=1024};

// how many characters are used for permission string
// NOT including the trailing null byte
#define WORKER_PERMCHARS 10

class WCFiletype;

class Datei
{
public:
  Datei();
  ~Datei();
  Datei( const Datei &other );
  Datei &operator=( const Datei &other );

  int open( const char *name, const char *mode );
  void close();
  int putUChar(unsigned char value);
  int putUShort(unsigned short int value);
  int putInt(int);
  int putULong(unsigned long value);
  int putString( const char *str1 );
  unsigned char getUChar();
  int getCharAsInt();
  unsigned short int getUShort();
  int getInt();
  unsigned long getULong();
  char *getString(int count);
  int getString(char *,int count);
  void seek(long offset,int mode);
  int overreadChunk();
  long errors();
  int putStringExt(const char *format,const char *str);
  int putLine( const char *str );
  char *getLine();
  bool isEOF();
  
  static int getIntSize();
  static int getUCharSize();
  static int getUShortSize();
  static int getULongSize();
  static bool fileExists(const char*);
  typedef enum {D_FE_NOFILE,D_FE_FILE,D_FE_DIR,D_FE_LINK} d_fe_t;
  static d_fe_t fileExistsExt(const char*);
  static d_fe_t lfileExistsExt(const char*);
  static char *getFilenameFromPath(const char*);
  static char *getNameWithoutExt(const char*);
  static char *createTMPName();
  static char *createTMPName( const char *infix );
  static char *shrinkFilename( const char *str, int maxlength );
  static loff_t fileSize( const char * );
  static char *getRelativePath( const char *source, const char *destdir );
  static int copyfile( const char *dest, const char *source );
private:
  int fd;
  long error;
  int putCharacter( int c );
  int getCharacter();
  bool iseof;
};

class FileEntry
{
public:
  FileEntry();
  ~FileEntry();
  FileEntry( const FileEntry &other );
  FileEntry &operator=( const FileEntry &other );

  bool isDir() const;
  FileEntry *duplicate();
  int readInfos();
  int readInfos(bool);
  char *getDestination() const;
  int writeDestination2Buf(char*,int,bool);
  const char *getPermissionString();
  bool isExe( bool fastTest = false ) const;
  WCFiletype* checkFiletype( List *ftlist, bool skipcontent, class CondParser *condparser = NULL );
  bool match(char* pattern);
  bool checkAccess( int m );

  void setLVC( FieldListView *lv, int row, const std::vector<WorkerTypes::listcol_t> *dis );
  void setLVC_DND( FieldListViewDND *lv, int row, const std::vector<WorkerTypes::listcol_t> *dis );
  
  loff_t size() const;
  time_t lastaccess() const;
  time_t lastmod() const;
  time_t lastchange() const;
  mode_t mode() const;
  uid_t userid() const;
  gid_t groupid() const;
  ino_t inode() const;
  nlink_t nlink() const;
  loff_t blocks() const;
  loff_t dsize() const;
  time_t dlastaccess() const;
  time_t dlastmod() const;
  time_t dlastchange() const;
  mode_t dmode() const;
  uid_t duserid() const;
  gid_t dgroupid() const;
  ino_t dinode() const;
  nlink_t dnlink() const;
  loff_t dblocks() const;
  dev_t rdev() const;
  dev_t drdev() const;
  dev_t dev() const;
  dev_t ddev() const;
  
  char *getContentStr( int pos, int len = 1 );
  int getContentNum( int pos, int len = 1 );
  void freeContentBuf();

  struct FE_stat {
    loff_t size;
    time_t lastaccess;
    time_t lastmod;
    time_t lastchange;
    mode_t mode;
    uid_t userid;
    gid_t groupid;
    ino_t inode;
    nlink_t nlink;
    loff_t blocks;
    dev_t rdev;   // device type
    dev_t dev;    // device
  } statbuf, dstatbuf;

  char *fullname;
  char *name;
  loff_t dirsize;
  bool select;
  bool isLink;
  bool isCorrupt;
  
  long nr;
  bool inFilter;
  WCFiletype *filetype;
  bool isHidden;
  bool use;
  
  bool reclistQueued;  // for filetype recognition in normalmode
  
  void freeOutputBuf();
  const char *findOutput( const char *tcommand );
  int findReturnvalue( const char *tcommand, int *return_value );
  int findOutputAndRV( const char *tcommand, const char **return_output, int *return_value );
  void addOutput( const char *tcommand, const char *toutput, int value = 0 );
  
  bool isReg() const;
  void setCustomColors( bool nv );
  bool getCustomColors() const;
  void setColor( int m, const int *v );
  void setColor( int m, int pos, int v );
  int getColor( int m, int pos ) const;
  const int *getColor( int m ) const;
  bool isSameFile( const char *othername, bool follow_symlinks ) const;
  bool equals( const FileEntry &fe ) const;
  bool equals( const FileEntry *fe ) const;
private:
  struct {
    char *content;
    int size;
  } contentBuf;
  void readContentBuf( int len = 64 );
  class StringBuf *outputBuf;

  typedef struct _typecandidate_t {
    _typecandidate_t()
    {
      prio = 0;
      tests_done = 0;
      type = NULL;
    }
    unsigned int prio;
    WCFiletype *type;
    int tests_done;
  } typecandidate_t;

  typecandidate_t runTests( WCFiletype *type,
			    bool skipcontent,
			    CondParser *condparser,
			    unsigned char fbuffer[64],
			    int reads );
  typecandidate_t checkFiletype( const std::list<WCFiletype*> *ftlist,
				 bool skipcontent,
				 CondParser *condparser,
				 unsigned char fbuffer[64],
				 int reads );

  bool customcolors;
  int fg[4], bg[4];
};

class Verzeichnis
{
public:
  Verzeichnis();
  ~Verzeichnis();
  Verzeichnis( const Verzeichnis &other );
  Verzeichnis &operator=( const Verzeichnis &other );

  ArrayList *getFiles();
  int readDir( const char *, bool dontWarnInvalid = false );
  void closeDir();
  int sort(int);
  int sort(int,bool force);
  int getSize();
  char *getDir();

  int getUseSize();
  static int sortfunction(void*,void*,int);
  ArrayList *getInvalidEntries();
protected:

  ArrayList *files;
  char *actdir;
  int actsortmode;
  
  ArrayList *invalid_entries;
};

char *ParentDir(const char *,char *);
char *ParentDir(const char *,char *,int);
char *HandlePath(const char *);
char *HandlePathExt(const char*);
int getOwnerStringLen(uid_t,gid_t);
char* getOwnerString(uid_t,gid_t);
char *resolveEnv(const char*);

#endif

