/* goftpop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: goftpop.cc,v 1.2 2005/03/20 20:49:09 ralf Exp $ */

#include "goftpop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

const char *GoFTPOp::name = "GoFTPOp";

GoFTPOp::GoFTPOp() : FunctionProto()
{
  requestflags = true;
  dontenterftp = false;
  always_store_pw = false;
  host = "";
  user = "";
  pass = "";
  hasConfigure = true;

  pw_stored = false;
}

GoFTPOp::~GoFTPOp()
{
}

GoFTPOp*
GoFTPOp::duplicate() const
{
  GoFTPOp *ta=new GoFTPOp();
  ta->setRequestFlags( requestflags );
  ta->setDontEnterFTP( dontenterftp );
  ta->setHost( host );
  ta->setUser( user );
  ta->setPass( pass );
  ta->setAlwaysStorePW( always_store_pw );
  return ta;
}

bool
GoFTPOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
GoFTPOp::getName()
{
  return name;
}

int
GoFTPOp::run(ActionMessage *msg)
{
  Requester *req = Worker::getRequester();
  std::string str1;
  bool cont = true;
  NormalMode *nm1=NULL;
  ListerMode *lm1=NULL;
  Lister *l1;

  if ( requestflags == true ) {
    if ( doconfigure( 1 ) != 0 ) cont = false;
  } else {
    tdontenterftp = dontenterftp;
    thost = host;
    tuser = user;
    tpass = pass;
    talways_store_pw = always_store_pw;
  }
  
  if ( cont == true ) {
    if ( ( thost.length() < 1 ) ||
	 ( tuser.length() < 1 ) ) {
      req->request( catalog.getLocale( 124 ), catalog.getLocale( 625 ), catalog.getLocale( 11 ) );
    } else {
      if ( ( pw_stored == false ) || ( talways_store_pw == true ) ) {
	str1 = "/#ftp_ctl:";
	str1 += tuser;
	str1 += "@";
	str1 += thost;
	str1 += "/password";
	
	Datei d;
	d.open( str1.c_str(), "w" );
	d.putString( tpass.c_str() );
	d.putString( "\n" );
	d.close();
	pw_stored = true;
      }

      if ( tdontenterftp == false ) {
	str1 = "/#ftp:";
	str1 += tuser;
	str1 += "@";
	str1 += thost;
	str1 += "/";

	l1 = msg->getWorker()->getActiveLister();
	if ( l1 != NULL ) {
	  l1->switch2Mode( 0 );
	  lm1 = l1->getActiveMode();
	  if ( ( lm1 != NULL ) &&
	       ( lm1->isType( "NormalMode" ) == true ) ) {
	    nm1=(NormalMode*)lm1;
	    nm1->enterDir( str1.c_str() );
	  }
	}
      }
    }
  }
  tpass = "";

  return 0;
}

bool
GoFTPOp::save(Datei *fh)
{
  if ( fh == NULL ) return false;
  WConfig::configPutPairBool( fh, "requestflags", requestflags );
  WConfig::configPutPairBool( fh, "dontenterftp", dontenterftp );
  WConfig::configPutPairString( fh, "hostname", host.c_str() );
  WConfig::configPutPairString( fh, "username", user.c_str() );
  WConfig::configPutPairString( fh, "password", pass.c_str() );
  WConfig::configPutPairBool( fh, "alwaysstorepw", always_store_pw );
  return true;
}

const char *
GoFTPOp::getDescription()
{
  return catalog.getLocaleCom( 48 );
}

int
GoFTPOp::configure()
{
  return doconfigure(0);
}

int
GoFTPOp::doconfigure(int mode)
{
  AGUIX *aguix = Worker::getAGUIX();
  Button *okb,*cancelb;
  AWindow *win;
  ChooseButton *cb1,*rfcb=NULL, *cb2;
  StringGadget *sgh, *sgu, *sgp;
  AGMessage *msg;
  int endmode=-1;
  char *tstr;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;
  Requester *req = Worker::getRequester();
  
  win=new AWindow(aguix);

  tstr = (char*)_allocsafe( strlen( catalog.getLocale( 293 ) ) + strlen( catalog.getLocaleCom( 48 ) ) + 1 );
  sprintf( tstr, catalog.getLocale( 293 ), catalog.getLocaleCom( 48 ) );
  win->create( NULL, 10, 10, 10, 10, 0, tstr );
  _freesafe( tstr );

  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 7 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  AContainer *ac1_2 = ac1->add( new AContainer( win, 2, 1 ), 0, 0 );
  ac1_2->setMinSpace( 5 );
  ac1_2->setMaxSpace( 5 );
  ac1_2->setBorderWidth( 0 );
  ac1_2->add( new Text( aguix, 0, 0, catalog.getLocale( 620 ), 1 ), 0, 0, cfix );
  sgh = (StringGadget*)ac1_2->add( new StringGadget( aguix, 0, 0, 100, host.c_str(), 0 ),
				   1, 0, cincw );

  AContainer *ac1_3 = ac1->add( new AContainer( win, 2, 1 ), 0, 1 );
  ac1_3->setMinSpace( 5 );
  ac1_3->setMaxSpace( 5 );
  ac1_3->setBorderWidth( 0 );
  ac1_3->add( new Text( aguix, 0, 0, catalog.getLocale( 621 ), 1 ), 0, 0, cfix );
  sgu = (StringGadget*)ac1_3->add( new StringGadget( aguix, 0, 0, 100, user.c_str(), 0 ),
				   1, 0, cincw );

  AContainer *ac1_4 = ac1->add( new AContainer( win, 2, 1 ), 0, 2 );
  ac1_4->setMinSpace( 5 );
  ac1_4->setMaxSpace( 5 );
  ac1_4->setBorderWidth( 0 );
  ac1_4->add( new Text( aguix, 0, 0, catalog.getLocale( 622 ), 1 ), 0, 0, cfix );
  sgp = (StringGadget*)ac1_4->add( new StringGadget( aguix, 0, 0, 100, "", 0 ),
				   1, 0, cincw );
  sgp->setPasswordMode( true );
  sgp->setText( pass.c_str() );

  cb1 = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, ( dontenterftp == true ) ? 1 : 0,
						   catalog.getLocale( 623 ), LABEL_RIGHT, 1, 0 ),
				 0, 3, cincwnr );
  cb2 = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, ( always_store_pw == true ) ? 1 : 0,
						   catalog.getLocale( 627 ), LABEL_RIGHT, 1, 0 ),
				 0, 4, cincwnr );
  if ( mode == 0 ) {
    rfcb = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, ( requestflags == true ) ? 1 : 0,
						      catalog.getLocale( 294 ), LABEL_RIGHT, 1, 0 ),
				    0, 5, cincwnr );
  }

  AContainer *ac1_5 = ac1->add( new AContainer( win, 2, 1 ), 0, 6 );
  ac1_5->setMinSpace( 5 );
  ac1_5->setMaxSpace( -1 );
  ac1_5->setBorderWidth( 0 );
  okb = (Button*)ac1_5->add( new Button( aguix,
					 0,
					 0,
					 catalog.getLocale( 11 ),
					 1,
					 0,
					 0 ), 0, 0, cfix );
  cancelb = (Button*)ac1_5->add( new Button( aguix,
					     0,
					     0,
					     catalog.getLocale( 8 ),
					     1,
                                                     0,
					     0 ), 1, 0, cfix );
  win->contMaximize( true );

  win->setDoTabCycling( true );
  win->show();
  for( ; endmode == -1; ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      switch ( msg->type ) {
        case AG_CLOSEWINDOW:
          if ( msg->closewindow.window == win->getWindow() ) endmode = 1;
          break;
        case AG_BUTTONCLICKED:
          if ( msg->button.button == okb ) endmode = 0;
          else if ( msg->button.button == cancelb ) endmode = 1;
          break;
        case AG_KEYPRESSED:
          if ( win->isParent( msg->key.window, false ) == true ) {
            switch ( msg->key.key ) {
              case XK_Return:
                if ( cancelb->hasFocus() == true ) {
		  endmode = 1;
		} else {
                  endmode=0;
                }
                break;
              case XK_Escape:
                endmode = 1;
                break;
            }
          }
          break;
      }
      aguix->ReplyMessage( msg );
    }
  }
  
  if ( endmode == 0 ) {
    // ok
    if ( mode == 1 ) {
      tdontenterftp = ( cb1->getState() == 1 ) ? true : false;
      talways_store_pw = ( cb2->getState() == 1 ) ? true : false;
      thost = sgh->getText();
      tuser = sgu->getText();
      tpass = sgp->getText();
      sgp->setText( "" );
    } else {
      dontenterftp = ( cb1->getState() == 1 ) ? true : false;
      always_store_pw = ( cb2->getState() == 1 ) ? true : false;
      if ( rfcb != NULL ) requestflags = ( rfcb->getState() == 1 ) ? true : false;
      setHost( sgh->getText() );
      setUser( sgu->getText() );
      if ( sgp->getText() != NULL ) {
	if ( strlen( sgp->getText() ) > 0 ) {
	  std::string str1;
	  
	  str1 = catalog.getLocale( 11 );
	  str1 += "|";
	  str1 += catalog.getLocale( 8 );
	  if ( req->request( catalog.getLocale( 347 ), catalog.getLocale( 624 ), str1.c_str() ) == 0 ) {
	    setPass( sgp->getText() );
	  }
	}
      }
      sgp->setText( "" );
    }
  }
  win->close();
  delete win;

  return endmode;
}

void GoFTPOp::setRequestFlags( bool nv )
{
  requestflags = nv;
}

void GoFTPOp::setDontEnterFTP( bool nv )
{
  dontenterftp = nv;
}

void GoFTPOp::setHost( std::string s1 )
{
  host = s1;
}

void GoFTPOp::setUser( std::string s1 )
{
  user = s1;
}

void GoFTPOp::setPass( std::string s1 )
{
  pass = s1;
}

void GoFTPOp::setAlwaysStorePW( bool nv )
{
  always_store_pw = nv;
}
