/* solidbutton.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: solidbutton.cc,v 1.11 2005/05/15 13:47:29 ralf Exp $ */

#include "solidbutton.h"
#include "lowlevelfunc.h"
#include "awindow.h"

const char *SolidButton::type="SolidButton";

SolidButton::~SolidButton()
{
  if(text!=NULL) _freesafe(text);
}

SolidButton::SolidButton(AGUIX *taguix,int tx,int ty,int width,
                         const char *ttext,int tfg,int tbg,bool tstate):GUIElement(taguix)
{
  _x=tx;
  _y=ty;
  if ( width > 0 ) _w = width;
  _h=taguix->getCharHeight()+4;
  this->state=tstate;
  this->text=dupstring(ttext);
  this->fg=tfg;
  this->bg=tbg;
  lastbg=-1;
  font=NULL;
}

SolidButton::SolidButton(AGUIX *taguix,int tx,int ty,int width,int height,
                         const char *ttext,int tfg,int tbg,bool tstate):GUIElement(taguix)
{
  _x=tx;
  _y=ty;
  if ( width > 0 ) _w = width;
  if ( height > 0 ) _h = height;
  this->state=tstate;
  this->text=dupstring(ttext);
  this->fg=tfg;
  this->bg=tbg;
  lastbg=-1;
  font=NULL;
}

const char *SolidButton::getText() const
{
  return text;
}

void SolidButton::setText(const char *new_text)
{
  if(text!=NULL) _freesafe(text);
  text=dupstring(new_text);
  redraw();
}

void SolidButton::setFG(int tfg)
{
  if((tfg<(_aguix->getMaxCols()))&&(tfg>=0)) {
    this->fg=tfg;
    redraw();
  }
}

int SolidButton::getFG() const
{
  return fg;
}

void SolidButton::setBG(int tbg)
{
  if((tbg<(_aguix->getMaxCols()))&&(tbg>=0)) {
    this->bg=tbg;
    redraw();
  }
}

int SolidButton::getBG() const
{
  return bg;
}

bool SolidButton::getState() const
{
  return state;
}

void SolidButton::setState(bool tstate)
{
  this->state=tstate;
  redraw();
}

void SolidButton::redraw()
{
  GC usegc;
  if ( isCreated() == false ) return;
  if(win==0) return;
  _aguix->SetWindowBG(win,bg);
  lastbg=bg;
  _aguix->ClearWin(win);
  if(font==NULL) usegc=0; else usegc=font->getGC();
  if(state==true) {
    _aguix->setFG(usegc,1);
  } else {
    _aguix->setFG(usegc,2);
  }
  _aguix->DrawLine(win,usegc,0,_h-1,0,0);
  _aguix->DrawLine(win,usegc,0,0,_w-1,0);
  if(state==true) {
    _aguix->setFG(usegc,2);
  } else {
    _aguix->setFG(usegc,1);
  }
  _aguix->DrawLine(win,usegc,0,_h-1,_w-1,_h-1);
  _aguix->DrawLine(win,usegc,_w-1,_h-1,_w-1,1);
  _aguix->setFG(usegc,fg);
  int ch,cw;
  if(font==NULL) {
    ch=_aguix->getCharHeight();
    cw=_aguix->getCharWidth();
  } else {
    ch=font->getCharHeight();
    cw=font->getCharWidth();
  }
  int dy=_h/2-ch/2;
  unsigned int maxdisplay=(_w-2)/cw;
  char *tstr;
  tstr=dupstring(text);
  if(strlen(tstr)>maxdisplay) tstr[maxdisplay]=0;
  int dw=strlen(tstr)*(_aguix->getCharWidth());
  int dx=_w/2-dw/2;
  if(font==NULL) _aguix->DrawText(win,tstr,dx,dy);
  else _aguix->DrawText(win,font,tstr,dx,dy);
  _freesafe(tstr);
  _aguix->Flush();
}

void SolidButton::flush()
{
}

bool SolidButton::handleMessage(XEvent *E,Message *msg)
{
  if ( isCreated() == false ) return false;
  if((msg->type==Expose)&&(msg->window==win)) {
    redraw();
  }
  return false;
}

int SolidButton::setFont(char *fontname)
{
  font=_aguix->getFont(fontname);
  if(font==NULL) return -1;
  return 0;
}

const char *SolidButton::getType() const
{
  return type;
}

bool SolidButton::isType(const char *qtype) const
{
  if(strcmp(type,qtype)==0) return true;
  return false;
}
