/* textstorage.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not^, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: textstorage.h,v 1.2 2005/06/23 16:06:37 ralf Exp $ */

#ifndef TEXTSTORAGE_H
#define TEXTSTORAGE_H

#include "aguixdefs.h"
#include <vector>
#include <string>

class TextStorage
{
 public:
  virtual ~TextStorage() {}
  virtual int getNrOfLines() const = 0;
  virtual int getLine( int line_nr, unsigned int offset, int len, std::string &return_line ) const = 0;
  virtual int getLine( int line_nr, unsigned int offset, std::string &return_line ) const = 0;
  virtual int getMaxLineLen() const = 0;
  virtual int getLineLen( int line_nr ) const = 0;
  virtual void setLineLimit( int new_limit ) = 0;
};

class TextStorageString : public TextStorage
{
 public:
  TextStorageString( std::string content );
  TextStorageString( const char *buf, int len );
  TextStorageString( const TextStorageString &other );
  TextStorageString &operator=( const TextStorageString &other );

  int getNrOfLines() const;
  int getLine( int line_nr, unsigned int offset, int len, std::string &return_line ) const;
  int getLine( int line_nr, unsigned int offset, std::string &return_line ) const;
  int getMaxLineLen() const;
  int getLineLen( int line_nr ) const;
  void setLineLimit( int new_limit );
 private:
  void initBuffer( std::string &content, int line_limit = -1 );
  unsigned int getTokenLen( unsigned int start_offset );
  
  std::string buffer;                      // stores text file
  std::vector<unsigned int> line_offsets;  // stores offset for each line (can be outside of buffer
                                           // for last line)
};

#endif
