/* functionproto.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: functionproto.h,v 1.15 2005/10/19 18:04:50 ralf Exp $ */

#ifndef FUNCTIONPROTO_H
#define FUNCTIONPROTO_H

#include "wdefines.h"

class Datei;
class Worker;
class AGUIX;
class WCGlobalFlags;
class Lister;
class WPUContext;
class List;

class ActionMessage
{
public:
  ActionMessage( Worker *);
  ~ActionMessage();
  ActionMessage( const ActionMessage &other );
  ActionMessage &operator=( const ActionMessage &other );

  WCGlobalFlags *flags;
  
  typedef enum {AM_MODE_NORMAL,
                AM_MODE_ONLYACTIVE,
                AM_MODE_DNDACTION,
                AM_MODE_SPECIAL} am_mode_t;
  am_mode_t mode;
  Lister *startLister;
  const class DNDMsg *dndmsg;
  class WCFiletype *filetype;
  class List *(*getActionList)( class WCFiletype *, int id, WCGlobalFlags **return_flags );
  int getActionListID;
  
  Worker *getWorker() const;
  const class FileEntry *getFE() const;
  void setFE( const class FileEntry *tfe );
protected:
  Worker *worker;
  class FileEntry *fe;
};

class FunctionProto
{
public:
  FunctionProto();
  virtual ~FunctionProto();
  FunctionProto( const FunctionProto &other );
  FunctionProto &operator=( const FunctionProto &other );

  virtual int configure();
  virtual FunctionProto *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual bool save(Datei *);
  virtual int run( WPUContext *, ActionMessage * );
  virtual const char *getDescription();
  
  static int presave(Datei*,FunctionProto*);
  int configureWhenAvail();
protected:
  static const char *name;
  bool hasConfigure;
};

void freecoms(List*);

#endif
