/* wcfiletype.hh
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2006-2007 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef WCFILETYPE_HH
#define WCFILETYPE_HH

#include "wdefines.h"
#include <list>
#include <string>
#include <map>

class List;
class FunctionProto;
class Datei;

class WCFiletype
{
public:
  WCFiletype();
  ~WCFiletype();
  WCFiletype( const WCFiletype &other );
  WCFiletype &operator=( const WCFiletype &other );

  WCFiletype *duplicate() const;
  void setName(const char*);
  void setPattern(const char*);
  void setUsePattern(bool);
  void setFiledesc( const short* );
  void setUseFiledesc(bool);
  char *getName();
  char *getPattern();
  bool getUsePattern() const;
  short *getFiledesc();
  bool getUseFiledesc() const;
  List *getDNDActions();
  List *getDoubleClickActions();
  List *getShowActions();
  List *getRawShowActions();
  List *getUserActions(int);
  List *getCustomActions( const std::string &customname );
  void setDNDActions(List*);
  void addComDNDAction( const FunctionProto * );
  void setDoubleClickActions(List*);
  void addComDoubleClickAction( const FunctionProto * );
  void setShowActions(List*);
  void addComShowAction( const FunctionProto * );
  void setRawShowActions(List*);
  void addComRawShowAction( const FunctionProto * );
  void setUserActions(int,List*);
  void addComUserAction( int i, const FunctionProto * fp );
  void setCustomActions( const std::string &customname, List* );
  void addComCustomAction( const std::string &customname, const FunctionProto * fp );
  bool save(Datei*) const;

  //TODO besser als enum type aber das macht mit config Probleme
#define NORMALTYPE 0
#define NOTYETTYPE 1
#define UNKNOWNTYPE 2
#define VOIDTYPE 3
#define DIRTYPE 4

  int getinternID() const;
  void setinternID(int);
  int getNameLen() const;

  void setPatternIgnoreCase( bool nv );
  bool getPatternIgnoreCase() const;
  void setPatternUseRegExp( bool nv );
  bool getPatternUseRegExp() const;
  bool patternMatchString( const char * );
  void setPatternUseFullname( bool nv );
  bool getPatternUseFullname() const;
  
  static int sortfunction( void *, void *, int );
  
  void clearFiledesc();
  void setFiledesc( int pos, short v );

  void setExtCond( const char* );
  void setUseExtCond( bool );
  const char *getExtCond() const;
  bool getUseExtCond() const;
  void addSubType( WCFiletype *newtype );
  void removeSubType( WCFiletype *remtype );
  const std::list<WCFiletype*> *getSubTypeList();
  void setParentType( WCFiletype *pt );
  WCFiletype *getParentType() const;
  std::vector<unsigned int> *getTypePos();
  void sortSubTypeList();
  static bool sortfunctionType( WCFiletype *ft1, WCFiletype *ft2 );

  enum colordef_t {
    DEFAULTCOL, CUSTOMCOL, EXTERNALCOL, PARENTCOL
  };
  colordef_t getColorMode() const;
  void setColorMode( colordef_t newmode );
  const int *getCustomColor( int m ) const;
  void setCustomColor( int m, const int *c );
  void setCustomColor( int m, int pos, int c );
  const char *getColorExt() const;
  void setColorExt( const char *s );

    void fillNamesOfCustomActions( bool recursive, std::list<std::string> &names );
    List *getActionList( bool recursive, const class ActionDescr &descr );

    void removeCustomAction( const std::string &customname );
    void clearCustomActions();
protected:
  char *name;
  char *pattern;
  bool usepattern;
  short filedesc[64];  // 0-255 ASCII-Code, -1 dont care, -2 end
  bool usefiledesc;
  List *dndaction;
  List *doubleclickaction;
  List *showaction;
  List *rawshowaction;
  List *useraction[10];
  std::map<std::string, List *> customaction;
  int internID;
  int namelen;
  
  bool patternIgnoreCase;
  bool patternUseRegExp;
  bool patternUseFullname;
  
  char *extCond;
  bool useExtCond;
#ifdef HAVE_REGEX
  regex_t patternReg;
  bool patternRegCompiled;
  void freeCompPatternReg();
  void compilePatternReg();
#endif

  std::list<WCFiletype*> *subtypes;
  WCFiletype *parentType;
  void getTypePos( const WCFiletype *child, std::vector<unsigned int> *v );

  colordef_t colmode;
  int colfg[4], colbg[4];
  char *colext;
};

#endif
