/* datei.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2008 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef DATEI_H
#define DATEI_H

#include "wdefines.h"
#include <aguix/awidth.h>

class Datei
{
public:
  Datei();
  ~Datei();
  Datei( const Datei &other );
  Datei &operator=( const Datei &other );

  int open( const char *name, const char *mode );
  int close();
  int putUChar(unsigned char value);
  int putUShort(unsigned short int value);
  int putInt(int);
  int putULong(unsigned long value);
  int putString( const char *str1 );
  unsigned char getUChar();
  int getCharAsInt();
  unsigned short int getUShort();
  int getInt();
  unsigned long getULong();
  char *getString(int count);
  int getString(char *,int count);
  void seek(long offset,int mode);
  int overreadChunk();
  long errors();
  int putStringExt(const char *format,const char *str);
  int putLine( const char *str );
  char *getLine();
  bool isEOF();
  
  static int getIntSize();
  static int getUCharSize();
  static int getUShortSize();
  static int getULongSize();
  static bool fileExists(const char*);
  typedef enum {D_FE_NOFILE,D_FE_FILE,D_FE_DIR,D_FE_LINK} d_fe_t;
  static d_fe_t fileExistsExt(const char*);
  static d_fe_t lfileExistsExt(const char*);
  static char *getFilenameFromPath(const char*);
  static char *getNameWithoutExt(const char*);
  static char *createTMPName( const char *infix = NULL );
  static char *shrinkFilename( const char *str, int maxlength, AWidth &lencalc );
  static loff_t fileSize( const char * );
  static char *getRelativePath( const char *source, const char *destdir );
  static int copyfile( const char *dest, const char *source );

  void configPutPair( const char *id, const char *info );
  void configPutPairNum( const char *id, int num );
  void configPutPairNum( const char *id, int num1, int num2 );
  void configPutPairString( const char *id, const char *str );
  void configPutPairBool( const char *id, bool val );
  void configPutInfo( const char *str, bool semicolon );
  void configPutString( const char *str, bool semicolon );
  void configOpenSection( const char *sectioname );
  void configCloseSection();

  size_t read( char *buffer, size_t len );
private:
  int fd;
  long error;
  int putCharacter( int c );
  int getCharacter();
  bool iseof;
  
  int sectiondepth;
};

char *ParentDir(const char *,char *);
char *ParentDir(const char *,char *,int);
char *HandlePath(const char *);
char *HandlePathExt(const char*);
int getOwnerStringLen(uid_t,gid_t);
char* getOwnerString(uid_t,gid_t);
char *resolveEnv(const char*);

#endif

