/* chmodop.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: chmodop.h,v 1.7 2003/05/04 00:36:15 ralf Exp $ */

#ifndef CHMODOP_H
#define CHMODOP_H

#include "wdefines.h"
#include "functionproto.h"
#include <aguix/awindow.h>
#include <aguix/text.h>
#include <aguix/solidbutton.h>
#include <aguix/button.h>
#include <aguix/cyclebutton.h>
#include <aguix/stringgadget.h>

class ChModOp:public FunctionProto
{
public:
  ChModOp();
  virtual ~ChModOp();
  virtual ChModOp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual bool save(Datei*);
  virtual const char *getDescription();
  virtual int configure();
  
  int doconfigure(int mode);
  
  void setOnFiles(bool);
  void setOnDirs(bool);
  void setRecursive(bool);
  void setRequestFlags(bool);
protected:
  static const char *name;
  // Infos to save

  bool onfiles,
       ondirs,
       recursive,
       requestflags;
  
  // temp variables
  Lister *startlister;

  bool tonfiles,
       tondirs,
       trecursive;
  
  int normalmodechmod();
};

#endif
