/* nmrowdata.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2003 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: nmrowdata.h,v 1.1 2003/11/06 21:41:50 ralf Exp $ */

#ifndef NMROWDATA_H
#define NMROWDATA_H

#include "wdefines.h"
#include <aguix/fieldlvrowdata.h>
#include "datei.h"

class NMRowData : public FieldLVRowData
{
public:
  NMRowData();
  NMRowData( int trow, FileEntry *tfe, const char *tfullname );
  ~NMRowData();
  NMRowData *duplicate() const;
  void update( int trow, FileEntry *tfe, const char *tfullname );
  int getRow() const;
  const FileEntry *getFE() const;
  const char *getFullname() const;
private:
  int row;
  FileEntry *fe;
  char *fullname;
};

#endif
