/* startprogop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: startprogop.cc,v 1.20 2003/06/04 23:28:55 ralf Exp $ */

#include "startprogop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

const char *StartProgOp::name="StartProgOp";

StartProgOp::StartProgOp() : FunctionProto()
{
  startprogstart=STARTPROGOP_START_NORMAL;

  view_str=dupstring("");
  
  global=false;
  requestflags=false;
  inbackground = false;
  hasConfigure = true;
}

StartProgOp::~StartProgOp()
{
  _freesafe(view_str);
}

StartProgOp*
StartProgOp::duplicate() const
{
  StartProgOp *ta=new StartProgOp();
  ta->startprogstart=startprogstart;

  _freesafe(ta->view_str);
  ta->view_str=dupstring(view_str);
  ta->global=global;
  ta->requestflags=requestflags;
  ta->inbackground = inbackground;
  return ta;
}

bool
StartProgOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
StartProgOp::getName()
{
  return name;
}

int
StartProgOp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      endlister = msg->getWorker()->getOtherLister(startlister);
      lm1=startlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodestartprog();
    }
  }
  return 0;
}

bool
StartProgOp::save(Datei *fh)
{
  if ( fh == NULL ) return false;
  switch(startprogstart) {
    case STARTPROGOP_START_IN_TERMINAL:
      WConfig::configPutPair( fh, "start", "terminal" );
      break;
    case STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY:
      WConfig::configPutPair( fh, "start", "terminalwait" );
      break;
    case STARTPROGOP_SHOW_OUTPUT:
      WConfig::configPutPair( fh, "start", "showoutput" );
      break;
    default:
      WConfig::configPutPair( fh, "start", "normal" );
      break;
  }
  WConfig::configPutPairString( fh, "viewstr", view_str );
  WConfig::configPutPairBool( fh, "global", global );
  WConfig::configPutPairBool( fh, "requestflags", requestflags );
  WConfig::configPutPairBool( fh, "inbackground", inbackground );
  return true;
}

const char *
StartProgOp::getDescription()
{
  return catalog.getLocaleCom(32);
}

int
StartProgOp::normalmodestartprog()
{
  struct NM_startprogorder sporder;
  NormalMode *nm1=NULL;
  ListerMode *lm1=NULL;
  bool cont=true;
  
  if(startlister==NULL) return 1;
  lm1=startlister->getActiveMode();
  if(lm1==NULL) return 1;
  if(lm1->isType("NormalMode")!=true) return 1;
  nm1=(NormalMode*)lm1;
  if(requestflags==true) {
    if(doconfigure(1)!=0) cont=false;
  } else {
    // set values in t* variables
    tglobal=global;
    tstartprogstart=startprogstart;
    tinbackground = inbackground;
    tview_str=dupstring(view_str);
  }
  
  if(cont==true) {
    memset( &sporder, 0, sizeof( sporder ) );
    FileEntry *tfe;
    if(am->mode==am->AM_MODE_SPECIAL) {
      tfe=(FileEntry*)am->extraInfo;
    } else tfe=NULL;
    sporder.usefe=tfe;
    sporder.global=tglobal;
    sporder.inbackground = tinbackground;
    switch(tstartprogstart) {
      case STARTPROGOP_START_IN_TERMINAL:
        sporder.start=sporder.NM_START_IN_TERMINAL;
        break;
      case STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY:
        sporder.start=sporder.NM_START_IN_TERMINAL_AND_WAIT4KEY;
        break;
      case STARTPROGOP_SHOW_OUTPUT:
        sporder.start=sporder.NM_SHOW_OUTPUT;
        break;
      default:
        sporder.start=sporder.NM_START_NORMAL;
    }
    sporder.view_str=NULL;
    if(strlen(tview_str)>0) sporder.view_str=tview_str;
    nm1->startprog(&sporder);
    _freesafe(tview_str);
  }
  return 0;
}

int
StartProgOp::configure()
{
  return doconfigure(0);
}

int
StartProgOp::doconfigure(int mode)
{
  AGUIX *aguix = Worker::getAGUIX();
  Button *okb,*cb;
  StringGadget *sg;
  AWindow *win;
  CycleButton *cyb;
  ChooseButton *gcb,*rfcb=NULL, *ibcb;
  Text *ttext;
  int tw,w,h,x,y,t1,t2;
  AGMessage *msg;
  int endmode=-1;
  Requester *req;
  const char *textstr;
  char *buttonstr, *tstr;
  int erg,i;
  
  req=new Requester(aguix);
  w=h=10;
  x=y=5;
  win=new AWindow(aguix);

  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(32))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(32));
  win->create(NULL,10,10,w,h,0,tstr);
  _freesafe(tstr);

  ttext = (Text*)win->add( new Text( aguix, x, y, catalog.getLocaleCom( 32 ), 1 ) );
  y += ttext->getHeight() + 5;

  ttext=(Text*)win->add(new Text(aguix,x,y,catalog.getLocale(331),1));
  x+=ttext->getWidth()+5;
  cyb=(CycleButton*)win->add(new CycleButton(aguix,x,y,100,1,0,0));
  cyb->addOption(catalog.getLocale(332));
  cyb->addOption(catalog.getLocale(333));
  cyb->addOption(catalog.getLocale(334));
  cyb->addOption(catalog.getLocale(335));
  cyb->resize(cyb->getMaxSize(),cyb->getHeight());
  switch(startprogstart) {
    case STARTPROGOP_START_IN_TERMINAL:
      cyb->setOption(1);
      break;
    case STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY:
      cyb->setOption(2);
      break;
    case STARTPROGOP_SHOW_OUTPUT:
      cyb->setOption(3);
      break;
    default:
      cyb->setOption(0);
      break;
  }
  
  y+=cyb->getHeight()+5;
  tw=x+cyb->getWidth()+5;
  if(tw>w) w=tw;
  x=5;

  ttext=(Text*)win->add(new Text(aguix,x,y,catalog.getLocale(337),1));
  x+=ttext->getWidth()+5;
  tw=w-x-5;
  if(tw<50) tw=50;
  sg=(StringGadget*)win->add(new StringGadget(aguix,x,y,tw,view_str,0));
  y+=sg->getHeight()+5;
  tw=sg->getWidth()+5+x;
  if(tw>w) w=tw;
  x=5;

  gcb=(ChooseButton*)win->add(new ChooseButton(aguix,x,y,(global==true)?1:0,
                                                catalog.getLocale(343),LABEL_RIGHT,1,0));
  y+=gcb->getHeight()+5;
  tw=gcb->getWidth()+10;
  if(tw>w) w=tw;

  ibcb = (ChooseButton*)win->add( new ChooseButton( aguix,
                                                    x,
                                                    y,
                                                    ( inbackground == true ) ? 1 : 0,
                                                    catalog.getLocale( 435 ),
                                                    LABEL_RIGHT,
                                                    1,
                                                    0 ) );
  y+=ibcb->getHeight()+5;
  tw=ibcb->getWidth()+10;
  if(tw>w) w=tw;

  if(mode==0) {
    rfcb=(ChooseButton*)win->add(new ChooseButton(aguix,x,y,(requestflags==true)?1:0,
                                                 catalog.getLocale(294),LABEL_RIGHT,1,0));
    y+=rfcb->getHeight()+5;
    tw=rfcb->getWidth()+10;
    if(tw>w) w=tw;
  }

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   y,
                                   t1,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  w-5-t2,
                                  y,
                                  t2,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  y+=okb->getHeight()+5;
  
  sg->resize(w-5-sg->getX(),sg->getHeight());

  h=y;
  okb->takeFocus();
  win->setDoTabCycling( true );
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) {
            if(NormalMode::isCorrectViewProg(sg->getText())==false) {
              // show requester
              textstr=catalog.getLocale(312);
              buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(313))+1+
                                          strlen(catalog.getLocale(314))+1);
              sprintf(buttonstr,"%s|%s",catalog.getLocale(313),
                                        catalog.getLocale(314));
              erg=req->request(catalog.getLocale(125),textstr,buttonstr);
              _freesafe(buttonstr);
              if(erg==0) {
                sg->activate();
              } else {
                sg->setText("");
              }
            } else endmode=0;
          } else if(msg->button.button==cb) endmode=1;
          break;
	case AG_STRINGGADGET_DEACTIVATE:
          if(msg->stringgadget.sg==sg) {
            if(NormalMode::isCorrectViewProg(sg->getText())==false) {
              // show requester
              textstr=catalog.getLocale(312);
              buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(313))+1+
                                          strlen(catalog.getLocale(314))+1);
              sprintf(buttonstr,"%s|%s",catalog.getLocale(313),
                                        catalog.getLocale(314));
              erg=req->request(catalog.getLocale(125),textstr,buttonstr);
              _freesafe(buttonstr);
              if(erg==0) {
                sg->activate();
              } else {
                sg->setText("");
              }
            }
          }
	  break;
        case AG_KEYPRESSED:
          if(win->isParent(msg->key.window,false)==true) {
            switch(msg->key.key) {
              case XK_1:
                i=cyb->getSelectedOption()+1;
                if(i>=4) i=0;
                cyb->setOption(i);
                break;
              case XK_2:
                gcb->setState((gcb->getState()==1)?0:1);
                break;
              case XK_3:
                ibcb->setState( ( ibcb->getState() == 1 ) ? 0 : 1 );
                break;
              case XK_Return:
                if ( cb->hasFocus() == false ) {
                  if(NormalMode::isCorrectViewProg(sg->getText())==false) {
                    // show requester
                    textstr=catalog.getLocale(312);
                    buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(313))+1+
                                                strlen(catalog.getLocale(314))+1);
                    sprintf(buttonstr,"%s|%s",catalog.getLocale(313),
                                              catalog.getLocale(314));
                    erg=req->request(catalog.getLocale(125),textstr,buttonstr);
                    _freesafe(buttonstr);
                    if(erg==0) {
                      sg->activate();
                    } else {
                      sg->setText("");
                    }
                  } else endmode=0;
                }
                break;
              case XK_Escape:
                endmode=1;
                break;
            }
          }
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    if(mode==1) {
      tview_str=dupstring(sg->getText());
      switch(cyb->getSelectedOption()) {
        case 1:
          tstartprogstart=STARTPROGOP_START_IN_TERMINAL;
          break;
        case 2:
          tstartprogstart=STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY;
          break;
        case 3:
          tstartprogstart=STARTPROGOP_SHOW_OUTPUT;
          break;
        default:
          tstartprogstart=STARTPROGOP_START_NORMAL;
          break;
      }
      tglobal=(gcb->getState()==1)?true:false;
      tinbackground = ( ibcb->getState() == 1 ) ? true : false;
    } else {
      _freesafe(view_str);
      view_str=dupstring(sg->getText());
      switch(cyb->getSelectedOption()) {
        case 1:
          startprogstart=STARTPROGOP_START_IN_TERMINAL;
          break;
        case 2:
          startprogstart=STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY;
          break;
        case 3:
          startprogstart=STARTPROGOP_SHOW_OUTPUT;
          break;
        default:
          startprogstart=STARTPROGOP_START_NORMAL;
          break;
      }
      global=(gcb->getState()==1)?true:false;
      inbackground = ( ibcb->getState() == 1 ) ? true : false;
      requestflags=(rfcb->getState()==1)?true:false;
    }
  }
  
  win->close();
  delete win;
  delete req;

  return endmode;
}

void StartProgOp::setStart(startprogstart_t nv)
{
  startprogstart=nv;
}

void StartProgOp::setGlobal(bool nv)
{
  global=nv;
}

void StartProgOp::setRequestFlags(bool nv)
{
  requestflags=nv;
}

void StartProgOp::setInBackground( bool nv )
{
  inbackground = nv;
}

void StartProgOp::setViewStr( const char *nv )
{
  if ( nv == NULL ) return;
  _freesafe( view_str );
  view_str = dupstring( nv );
}

