/* wconfig.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: wconfig.h,v 1.47 2004/03/07 22:35:46 ralf Exp $ */

#ifndef WCONFIG_H
#define WCONFIG_H

#include "wdefines.h"
#include <aguix/aguix.h>
#include <aguix/awindow.h>
#include <aguix/stringgadget.h>
#include <aguix/bevelbox.h>
#include <aguix/fieldlistview.h>
#include <aguix/solidbutton.h>
#include <aguix/choosebutton.h>
#include <aguix/cyclebutton.h>
#include "worker_locale.h"
#include "functionproto.h"
#include "datei.h"
#include "worker_types.h"
#include <vector>
#include <list>

class Worker;
class WCPath;
class WCHotkey;
class WCButton;
class WCFiletype;
class WCGlobalFlags;

class WC_Color
{
public:
  WC_Color();
  WC_Color( int r, int g, int b);
  WC_Color *duplicate();
  int getRed() const;
  int getGreen() const;
  int getBlue() const;
  void setRed( int );
  void setGreen( int );
  void setBlue( int );
protected:
  int red, green, blue;
};

class WCShortkey
{
public:
  WCShortkey();
  ~WCShortkey();
  WCShortkey *duplicate();
  void setShortkey(KeySym);
  void setMod(unsigned int);
  KeySym getShortkey();
  unsigned int getMod();
  bool isShortkey(KeySym,unsigned int);
  bool isReal();
protected:
  KeySym shortkey;
  unsigned int mod;
};

class WCDoubleShortkey
{
public:
  WCDoubleShortkey();
  ~WCDoubleShortkey();
  WCDoubleShortkey *duplicate() const;
  void setKeySym( KeySym k, int pos );
  KeySym getKeySym( int pos );
  void setMod( unsigned int m, int pos);
  unsigned int getMod( int pos );
  bool isShortkey( KeySym k, unsigned int m );
  bool isShortkey( KeySym k1, unsigned int m1, KeySym k2, unsigned int m2 );
  bool save( Datei* );
  bool isReal();

  enum shortkey_type { WCDS_NORMAL, WCDS_DOUBLE };

  void setType( enum shortkey_type nv );
  enum shortkey_type getType();
protected:
  KeySym key[2];
  unsigned int mod[2];
  enum shortkey_type type;
};

class WConfig
{
public:
  typedef enum {CLOCKBAR_MODE_TIMERAM=0,CLOCKBAR_MODE_TIME,CLOCKBAR_MODE_VERSION,CLOCKBAR_MODE_EXTERN} clockbar_mode_t;

  WConfig(Worker *);
  ~WConfig();
  WConfig *duplicate();
  void setLang( const char* );
  void setTerminalBin(const char*);
  void setRows(unsigned int);
  void setColumns(unsigned int);
  void setCacheSize(unsigned int);
  void setHBarTop(int,bool);
  void setVBarLeft(int,bool);
  void setHBarHeight(int,unsigned int);
  void setVBarWidth(int,unsigned int);
  void setVisCols( int side, const std::vector<WorkerTypes::listcol_t> *nv );
  char *getLang();
  char *getTerminalBin();
  unsigned int getRows();
  unsigned int getColumns();
  unsigned int getCacheSize();
  bool getHBarTop(int);
  bool getVBarLeft(int);
  unsigned int getHBarHeight(int);
  unsigned int getVBarWidth(int);
  const std::vector<WorkerTypes::listcol_t> *getVisCols( int side ) const;
  void setStatusbar(int,int);
  void setSelLVB(int,int);
  void setUnselLVB(int,int);
  void setSelDir(int,int);
  void setUnselDir(int,int);
  void setSelFile(int,int);
  void setUnselFile(int,int);
  void setSelDirAct(int,int);
  void setUnselDirAct(int,int);
  void setSelFileAct(int,int);
  void setUnselFileAct(int,int);
  void setClockbar(int,int);
  void setRequest(int,int);
  void setLVHeader( int, int );
  int getStatusbar(int) const;
  int getSelLVB(int) const;
  int getUnselLVB(int) const;
  int getSelDir(int) const;
  int getUnselDir(int) const;
  int getSelFile(int) const;
  int getUnselFile(int) const;
  int getSelDirAct(int) const;
  int getUnselDirAct(int) const;
  int getSelFileAct(int) const;
  int getUnselFileAct(int) const;
  int getClockbar(int) const;
  int getRequest(int) const;
  int getLVHeader( int ) const;
  void setStartDir(int,const char*);
  char *getStartDir(int);
  void setFont(int,const char*);
  char *getFont(int);
  void setPaths(List*);
  List *getPaths();
  void setFiletypes(List*);
  List *getFiletypes();
  void setHotkeys(List*);
  List *getHotkeys();
  void setButtons(List*);
  List *getButtons();
  void setColors(List*);
  List *getColors();
  void setColor( int nr, int red, int green, int blue );
  void resetColors();
  void cleanUpPaths();
  void cleanUpButtons();
  void setOwnerstringtype(int);
  int getOwnerstringtype();
  void setClockbarMode(clockbar_mode_t);
  clockbar_mode_t getClockbarMode();
  void setClockbarUpdatetime(int);
  int getClockbarUpdatetime();
  void setClockbarCommand(const char *);
  const char *getClockbarCommand();
  void setDontCheckDirs(List*);
  List *getDontCheckDirs();
  void setShowStringForDirSize(bool nv);
  bool getShowStringForDirSize();
  void setStringForDirSize(const char *nv);
  const char *getStringForDirSize();

  void applyColorList(List *);

  bool configure();
  int palette();
  int palette(int);
  bool save();
  bool saveas(char*);
  bool load();
  bool loadfrom(char*);
  
  const char *getHome();
  WCFiletype *getnotyettype();
  WCFiletype *getdirtype();
  WCFiletype *getvoidtype();
  WCFiletype *getunknowntype();
  void applyLanguage();
  
  int savesize(int w,int h);
  int loadsize(int *w,int *h);
  
  const char *getTerminalStr();
  void setListerBG(int);
  int getListerBG();
  int getStringForDirSizeLen();

  void setDateFormat( int nv );
  int getDateFormat();
  void setDateFormatString( const char *nv );
  const char *getDateFormatString();
  void setDateSubst( bool nv );
  bool getDateSubst();
  void setTimeFormat( int nv );
  int getTimeFormat();
  void setTimeFormatString( const char *nv );
  const char *getTimeFormatString();
  void setDateBeforeTime( bool nv );
  bool getDateBeforeTime();
  
  void setShowHeader( int side, bool nv );
  bool getShowHeader( int side ) const;

  int getDatelen( const struct tm *timeptr );
  int writeDateToString( char *buf, int maxlen, struct tm *timeptr );
  
  bool checkForNewerConfig();
  time_t getFileConfigMod();
  
  void clearVisCols( int side );
  void addListCol( int side, WorkerTypes::listcol_t nv );
  
  static void configPutPair( Datei *fh, const char *id, const char *info );
  static void configPutPairNum( Datei *fh, const char *id, int num );
  static void configPutPairNum( Datei *fh, const char *id, int num1, int num2 );
  static void configPutPairString( Datei *fh, const char *id, const char *str );
  static void configPutPairBool( Datei *fh, const char *id, bool val );
  static void configPutInfo( Datei *fh, const char *str, bool semicolon );
  static void configPutString( Datei *fh, const char *str, bool semicolon );
  static void configOpenSection( Datei *fh, const char *sectioname );
  static void configCloseSection( Datei *fh );

  typedef enum { LO_STATEBAR,
                 LO_CLOCKBAR,
                 LO_BUTTONS,
                 LO_LISTVIEWS,
                 LO_BLL,
                 LO_LBL,
                 LO_LLB,
                 LO_BL,
                 LO_LB,
                 LO_DUMMY } layoutID_t;
  void setLayoutOrders( std::list<layoutID_t> &nl );
  std::list<layoutID_t> &getLayoutOrders();
  void setLayoutButtonVert( bool nv );
  bool getLayoutButtonVert() const;
  void setLayoutListviewVert( bool nv );
  bool getLayoutListviewVert() const;
  void clearLayoutOrders();
  void layoutAddEntry( layoutID_t nv );
protected:
  char *lang;
  unsigned int rows,columns;
  unsigned int cachesize;
  List *colors;
  bool hbar_top[2];
  bool vbar_left[2];
  unsigned int hbar_height[2];
  unsigned int vbar_width[2];
  std::vector<WorkerTypes::listcol_t> viscols[2];
  int statusbar[2];
  int sel_lvb[2];
  int unsel_lvb[2];
  int sel_dir[2];
  int unsel_dir[2];
  int sel_file[2];
  int unsel_file[2];
  int sel_dir_act[2];
  int unsel_dir_act[2];
  int sel_file_act[2];
  int unsel_file_act[2];
  int clockbar[2];
  int request[2];
  int lvheader[2];
  char *dir[2];  // left=0, right=1
  char *fonts[4];  // global, buttons, left lister, right lister
  List *paths;  // Elemente sind WCPath
  List *filetypes; // Elemente sind WCFiletype
  List *hotkeys; // Elemente sind WCHotkey
  List *buttons; // Elemente sind WCButton
  clockbar_mode_t clockbar_mode;
  int clockbar_updatetime;
  char *clockbar_command;
  List *dontcheckdirs;
  
  struct {
    std::list<layoutID_t> orders;
    bool buttonVert;
    bool listviewVert;
  } layoutConf;
  
  char *terminalbin;
  
  int ownerstringtype;
  
  bool showStringForDirSize;
  char *stringForDirSize;
  int stringForDirSizeLen;
  bool showHeader[2];
  
  #define NORMALTYPE 0
  #define NOTYETTYPE 1
  #define UNKNOWNTYPE 2
  #define VOIDTYPE 3
  #define DIRTYPE 4
  WCFiletype *notyettype; // Nur zum schnelleren Auslesen, muss nicht abgespeichert werden
  WCFiletype *dirtype; // Nur zum schnelleren Auslesen, muss nicht abgespeichert werden
  WCFiletype *voidtype; // Nur zum schnelleren Auslesen, muss nicht abgespeichert werden
  WCFiletype *unknowntype; // Nur zum schnelleren Auslesen, muss nicht abgespeichert werden
  
  char *home;
  Worker *worker;

  bool changeTypes();
  bool changeTypes(bool onlyFiletypes);
  bool changeTypes( bool onlyFiletypes, bool allowRemoveUnique );
  bool changeHotkeys();
  bool changeFont();
  bool changeGlobal();
  bool changeColorDefs();
  bool changeStartup();
  bool changeButtons();
  bool changePaths();
  bool changePalette();
  bool changeLanguage();
  bool changeFileSets();
  bool changeDisplaySets(int);
  bool changeClockbarSets();
  bool configureLayout();

  void showPathBank(int,Button**);
  void showButtonBank( int, Button***);
  
  bool configurePath(WCPath*);
  int grabKey( const char *title, const char *text, KeySym *return_key, unsigned int *return_mod );
  int getDoubleShortkey( bool doublek,
                         const WCButton *ignore_b,
                         const WCHotkey *ignore_h,
                         const WCPath *ignore_p,
                         WCDoubleShortkey **return_dk);
  int findDoubleShortkey( WCDoubleShortkey *dk,
                          WCButton **return_button,
                          WCPath **return_path,
                          WCHotkey **return_hotkey );
  bool configureHotkey(WCHotkey*);
  FunctionProto *requestCommand();
  static int requestCommand_sf(void*,void*);

  bool configureButton(WCButton*);
  bool configureFiletype(WCFiletype*);
  void showFTActions( const char*, WCFiletype*, FieldListView*, FieldListView*, List**, WCGlobalFlags** );
  void applyGlobalFlags( FieldListView *, WCGlobalFlags * );
  bool changeFiledesc(WCFiletype*);
  char *getStr4Char(int,short);
  int WCEditByte(int ch);
  bool FTautocreate(WCFiletype *);
  void initFixTypes();
  void setDefaultConfig();
  int configureDCD(List *);

  // for loading the old config
  int parseChunk(Datei *fp);
  int read1Config(Datei *fp);
  void getFunctionProtoOldStyle(const unsigned long comnr,
                                const unsigned long flag1,
                                const unsigned long flag2,
                                const char *usercomstr,
                                List *l2);
  void changeRS(const char *,char **);
  bool showOldRequest;
  
  static bool isCorrectTerminalBin(const char*);
  int listerbg;
  
  int cfg_export();
  int im_export();
  int export2file( bool export_buttons,
                   bool export_hotkeys,
                   bool export_types,
                   const char *filename );
  int cfg_import1();
  int cfg_import2( const char *filename );
  int cfg_import3( WConfig *importconfig, int nrb );
  int cfg_import4( WConfig *importconfig, bool apply_b, bool apply_h, bool apply_f );
  
  int date_format;  // -1 = user-defined
                    // >=0 any of the predefined
  char *date_formatstring;
  bool date_subst;
  
  int time_format; // as above
  char *time_formatstring;
  
  bool date_before_time;
  int configureDateTime();
  
  int configureButtonSize[2];
  int changeTypesSize[2];
  int changeHotkeysSize[2];
  int configureFiletypeSize[2];
  int configureHotkeySize[2];
  char *lastRequestCommand;
  time_t currentConfigTime;
  
  bool loadBinConfig( const char * );
  int loadBinColor( Datei *fh, WC_Color *col );
  int loadBinPath( Datei *fh, WCPath *p1 );
  int loadBinFiletype( Datei *fh, WCFiletype *f1 );
  int loadBinHotkey( Datei *fh, WCHotkey *h1 );
  int loadBinButton( Datei *fh, WCButton *b1 );
  int loadBinShortkey( Datei *fh, WCShortkey *key );
  int loadBinDoubleShortkey( Datei *fh, WCDoubleShortkey *dk );
  int loadBinGlobalFlags( Datei *fh );
  List *loadBinFunction( Datei *fh );
  
  static int sectiondepth;
};

class WCKey
{
public:
  List *getDoubleKeys();
  void setDoubleKeys( List *dklist );
  bool hasKey( KeySym k, unsigned int m );
  bool hasKey( KeySym k1, unsigned int m1, KeySym k2, unsigned int m2 );
  void removeKey( KeySym k, unsigned int m );
  void removeKey( KeySym k1, unsigned int m1, KeySym k2, unsigned int m2 );
  void removeKey( WCDoubleShortkey *dk );
  bool conflictKey( KeySym k, unsigned int m );
  bool conflictKey( KeySym k1, unsigned int m1, KeySym k2, unsigned int m2 );
  bool conflictKey( WCDoubleShortkey *dk );
  void addKey( const KeySym k, const unsigned int m );
  void addKey( const KeySym k1, const unsigned int m1, const KeySym k2, const unsigned int m2 );
  void addKey( const WCDoubleShortkey *dk );
protected:
  List *dkeys;    // list of WCDoubleShortkey
  
  void removeAllKeys();
  WCKey();
  ~WCKey();
};

class WCPath:public WCKey
{
public:
  WCPath();
  ~WCPath();
  WCPath *duplicate();
  void setName(const char*);
  void setFG(int);
  void setBG(int);
  void setPath(const char*);
  char *getName();
  int getFG();
  int getBG();
  char *getPath();
  void setCheck(bool);
  bool getCheck();
  bool configure(AGUIX*);
  bool save(Datei*);
protected:
  char *name;
  int fg,bg;
  char *path;
  bool check;
};

class WCGlobalFlags
{
public:
  WCGlobalFlags();
  ~WCGlobalFlags();
  WCGlobalFlags *duplicate();
  unsigned long getFlags();
  void setFlags(unsigned long);
  bool save(Datei*);

  static List* getNameOfFlags();
  static void freeNameOfFlags(List*);
protected:
  unsigned long flags;
};

class WCFiletype
{
public:
  WCFiletype();
  ~WCFiletype();
  WCFiletype *duplicate();
  void setName(const char*);
  void setPattern(const char*);
  void setUsePattern(bool);
  void setFiledesc(short*);
  void setUseFiledesc(bool);
  char *getName();
  char *getPattern();
  bool getUsePattern();
  short *getFiledesc();
  bool getUseFiledesc();
  List *getDNDActions();
  List *getDoubleClickActions();
  List *getShowActions();
  List *getRawShowActions();
  List *getUserActions(int);
  void setDNDActions(List*);
  void addComDNDAction( const FunctionProto * );
  void setDoubleClickActions(List*);
  void addComDoubleClickAction( const FunctionProto * );
  void setShowActions(List*);
  void addComShowAction( const FunctionProto * );
  void setRawShowActions(List*);
  void addComRawShowAction( const FunctionProto * );
  void setUserActions(int,List*);
  void addComUserAction( int i, const FunctionProto * fp );
  WCGlobalFlags *getDNDActionsGF();
  WCGlobalFlags *getDoubleClickActionsGF();
  WCGlobalFlags *getShowActionsGF();
  WCGlobalFlags *getRawShowActionsGF();
  WCGlobalFlags *getUserActionsGF(int);
  void setDNDActionsGF(WCGlobalFlags*);
  void setDoubleClickActionsGF(WCGlobalFlags*);
  void setShowActionsGF(WCGlobalFlags*);
  void setRawShowActionsGF(WCGlobalFlags*);
  void setUserActionsGF(int,WCGlobalFlags*);
  bool save(Datei*);
  int getinternID();
  void setinternID(int);
  int getNameLen();

  void setFileExp( const char* );
  const char *getFileExp();
  void setUseFileExp( bool );
  bool getUseFileExp();
  bool fileExpMatchString( const char * );
  void setPatternIgnoreCase( bool nv );
  bool getPatternIgnoreCase();
  void setPatternUseRegExp( bool nv );
  bool getPatternUseRegExp();
  bool patternMatchString( const char * );
  void setPatternUseFullname( bool nv );
  bool getPatternUseFullname() const;
  
  static int sortfunction( void *, void *, int );
  
  void clearFiledesc();
  void setFiledesc( int pos, short v );
protected:
  char *name;
  char *pattern;
  bool usepattern;
  short filedesc[64];  // 0-255 ASCII-Code, -1 dont care, -2 end
  bool usefiledesc;
  List *dndaction;
  WCGlobalFlags *dndactiongf;
  List *doubleclickaction;
  WCGlobalFlags *doubleclickactiongf;
  List *showaction;
  WCGlobalFlags *showactiongf;
  List *rawshowaction;
  WCGlobalFlags *rawshowactiongf;
  List *useraction[10];
  WCGlobalFlags *useractiongf[10];
  int internID;
  int namelen;
  
  bool usefileexp;
  char *fileexp;

#if 0  // for filetype checking with file
  regex_t preg;
  bool regex_compiled;
  void free_compexp();
  void compile_exp();
#endif

  bool patternIgnoreCase;
  bool patternUseRegExp;
  bool patternUseFullname;
#ifdef HAVE_REGEX
  regex_t patternReg;
  bool patternRegCompiled;
  void freeCompPatternReg();
  void compilePatternReg();
#endif
};

class WCHotkey:public WCKey
{
public:
  WCHotkey();
  ~WCHotkey();
  WCHotkey *duplicate();
  void setName(const char*);
  char *getName();
  WCShortkey *getKey();
  List *getComs();
  void addCom( const FunctionProto *fp );
  void setKey(WCShortkey*);
  void setComs(List*);
  WCGlobalFlags *getComsGF();
  void setComsGF(WCGlobalFlags*);
  bool save(Datei*);
protected:
  char *name;
  WCShortkey *key;
  List *com;
  WCGlobalFlags *flags;
};

class WCButton:public WCKey
{
public:
  WCButton();
  ~WCButton();
  WCButton *duplicate();
  void setText(const char*);
  void setFG(int);
  void setBG(int);
  char *getText();
  int getFG();
  int getBG();
  List *getComs();
  void setComs(List*);
  void addCom( const FunctionProto *fp );
  void setCheck(bool);
  bool getCheck();
  WCGlobalFlags *getComsGF();
  void setComsGF(WCGlobalFlags*);
  bool save(Datei*);
protected:
  char *text;
  int fg,bg;
  List *com;
  WCGlobalFlags *flags;
  bool check;
};

void freecoms(List*);

extern WConfig *wconfig;

#endif

