/* bevelbox.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: bevelbox.cc,v 1.10 2004/03/18 06:58:05 ralf Exp $ */

#include "bevelbox.h"
#include "lowlevelfunc.h"
#include "awindow.h"

const char *BevelBox::type="BevelBox";

BevelBox::~BevelBox()
{
}

BevelBox::BevelBox(AGUIX *taguix):GUIElement(taguix)
{
  this->state=0;
  bgset=false;
}

BevelBox::BevelBox(AGUIX *taguix,int tx,int ty,int width,int height,
                   int tstate):GUIElement(taguix)
{
  this->x=tx;
  this->y=ty;
  if ( width > 0 ) this->w = width;
  if ( height > 0 ) this->h = height;
  this->state=tstate;
  bgset=false;
}

int BevelBox::getState() const
{
  return state;
}

void BevelBox::setState(int tstate)
{
  if(tstate==1) this->state=tstate;
  else this->state=0;
  redraw();
}

void BevelBox::redraw()
{
  if(parent==NULL) return;

  if(bgset==false) {
    aguix->SetWindowBG(win,parent->getBG());
    bgset=true;
  }
  aguix->ClearWin(win);
  if(state==0) {
    aguix->setFG(2);
  } else {
    aguix->setFG(1);
  }
  aguix->DrawLine(win,0,h-1,0,0);
  aguix->DrawLine(win,0,0,w-1,0);
  if(state==0) {
    aguix->setFG(1);
  } else {
    aguix->setFG(2);
  }
  aguix->DrawLine(win,0,h-1,w-1,h-1);
  aguix->DrawLine(win,w-1,h-1,w-1,1);
}

void BevelBox::flush()
{
}

bool BevelBox::handleMessage(XEvent *E,Message *msg)
{
  if ( parent != NULL ) {
    if((msg->type==Expose)&&(msg->window==win)) {
      redraw();
    }
  }
  return false;
}

const char *BevelBox::getType() const
{
  return type;
}

bool BevelBox::isType(const char *qtype) const
{
  if(strcmp(type,qtype)==0) return true;
  return false;
}
