// EventLabel.cc ---
//
// Copyright (C) 2003, 2004, 2007, 2008 Rob Caelers <robc@krandor.nl>
// All rights reserved.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include "preinclude.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "debug.hh"

#include "EventButton.hh"


//! User pressed some mouse button in the main window.
bool
EventButton::on_button_press_event(GdkEventButton *event)
{
  bool handled = button_pressed.emit(event->button);
  bool ret = true;
  
  if (!handled)
    {
      ret = Gtk::Button::on_button_press_event(event);
    }
  
  return ret;
}
