/***************************************************************************
 * Unit:    raster            release 0.26                                 *
 * Purpose: Prototypes for low level pixelbuff operations.                 *
 * Modul:   img_tool.h                                                     *
 * Licency: GPL or LGPL                                                    *
 * Copyright: (c) 1998-2024 Jaroslav Fojtik                                *
 ***************************************************************************/
#ifndef _IMG_TOOL_H
#define _IMG_TOOL_H

#ifdef __cplusplus
extern "C" {
#endif

void swab16(unsigned char *block, int pixels);
void swab32(unsigned char *block, int pixels);
void swab64(unsigned char *block, int pixels);

void MaxU8(unsigned char *R1, const unsigned char *R2, unsigned size);
void MinU8(unsigned char *R1, const unsigned char *R2, unsigned size);
void MaxU16(unsigned char *R1, const unsigned char *R2, unsigned size);
void MinU16(unsigned char *R1, const unsigned char *R2, unsigned size);

void RGB_BGR(char *Data, int size);
void RGB_BGR2(unsigned char *OutData, const unsigned char *InData, unsigned PixelCount);
void RGB32_BGR24(unsigned char *OutData, const unsigned char *InData, unsigned PixelCount);
void RGBA32_BGRiA32(char *Data, int PixelCount);
void RGBA64_BGRiA64(char *Data, int PixelCount);
void RGB_Gray(unsigned char *OutData, const unsigned char *InData, unsigned PixelCount);
void RGB_Gray24(unsigned char *OutData, const unsigned char *InData, unsigned PixelCount);
void BGR_Gray24precise(unsigned char *OutData, const unsigned char *InData, unsigned PixelCount);
void BGR32_Gray24(unsigned char *OutData, const unsigned char *InData, unsigned PixelCount);
void RGB32_Gray(unsigned char *OutData, const unsigned char *InData, unsigned PixelCount);

void NotR(char *R, int size);
void OrR(void *R1, const void *R2, unsigned maxX);	// R1:=R1 or R2
void AndR(void *R1, const void *R2, unsigned maxX);	// R1:=R1 and R2
void ShrR(void *R, unsigned maxX);			// R1:=R1 shr 1
void ShlR(void *R, unsigned maxX, unsigned char zbytek);	// R1:=R1 shl 1

void YUV_RGB(unsigned char *OutData, const unsigned char *y, const unsigned char *u, const unsigned char *v, unsigned PixelCount);
void YUYV_RGB(unsigned char *OutData, const unsigned char *yuyv, unsigned PixelCount);

#ifdef __cplusplus
}
#endif


#endif	/* _IMG_TOOL_H */
