/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xmerge;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import writer2latex.xmerge.Document;

public class DOMDocument
implements Document {
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private org.w3c.dom.Document contentDoc = null;
    private org.w3c.dom.Document styleDoc = null;
    private String documentName = null;
    private String fileName = null;
    private String fileExt = null;

    public DOMDocument(String name, String ext) {
        this(name, ext, true, false);
    }

    protected String getFileExtension() {
        return this.fileExt;
    }

    public DOMDocument(String name, String ext, boolean namespaceAware, boolean validating) {
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceAware);
        this.fileExt = ext;
        this.documentName = this.trimDocumentName(name);
        this.fileName = this.documentName + this.getFileExtension();
    }

    private String trimDocumentName(String name) {
        String ext;
        String temp = name.toLowerCase();
        if (temp.endsWith(ext = this.getFileExtension())) {
            int nlen = name.length();
            int endIndex = nlen - ext.length();
            name = name.substring(0, endIndex);
        }
        return name;
    }

    public org.w3c.dom.Document getContentDOM() {
        return this.contentDoc;
    }

    public void setContentDOM(Node newDom) {
        this.contentDoc = (org.w3c.dom.Document)newDom;
    }

    public String getName() {
        return this.documentName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void read(InputStream is) throws IOException {
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            System.err.println("Error:" + ex);
        }
        try {
            this.contentDoc = builder.parse(is);
        }
        catch (SAXException ex) {
            System.err.println("Error:" + ex);
        }
    }

    public void write(OutputStream os) throws IOException {
        byte[] contentBytes = this.docToBytes(this.contentDoc);
        os.write(contentBytes);
    }

    private byte[] docToBytes(org.w3c.dom.Document doc) throws IOException {
        ByteArrayOutputStream baos;
        block7: {
            baos = new ByteArrayOutputStream();
            String domImpl = doc.getClass().getName();
            try {
                if (domImpl.equals("com.sun.xml.tree.XmlDocument")) {
                    Class<?> jaxpDoc = Class.forName("com.sun.xml.tree.XmlDocument");
                    Method meth = jaxpDoc.getMethod("write", Class.forName("java.io.OutputStream"));
                    meth.invoke((Object)doc, baos);
                    break block7;
                }
                if (domImpl.equals("org.apache.crimson.tree.XmlDocument")) {
                    Class<?> crimsonDoc = Class.forName("org.apache.crimson.tree.XmlDocument");
                    Method meth = crimsonDoc.getMethod("write", Class.forName("java.io.OutputStream"));
                    meth.invoke((Object)doc, baos);
                    break block7;
                }
                if (domImpl.equals("org.apache.xerces.dom.DocumentImpl") || domImpl.equals("org.apache.xerces.dom.DeferredDocumentImpl")) {
                    Class<?> xercesSer = Class.forName("org.apache.xml.serialize.XMLSerializer");
                    Constructor<?> con = xercesSer.getConstructor(Class.forName("java.io.OutputStream"), Class.forName("org.apache.xml.serialize.OutputFormat"));
                    Method meth = xercesSer.getMethod("serialize", Class.forName("org.w3c.dom.Document"));
                    Object serializer = con.newInstance(baos, null);
                    meth.invoke(serializer, doc);
                    break block7;
                }
                if (domImpl.equals("gnu.xml.dom.DomDocument")) {
                    Class<?> gnuSer = Class.forName("gnu.xml.dom.ls.DomLSSerializer");
                    Method meth = gnuSer.getMethod("serialize", Class.forName("org.w3c.dom.Node"), Class.forName("java.io.OutputStream"));
                    Object serializer = gnuSer.newInstance();
                    meth.invoke(serializer, doc, baos);
                    break block7;
                }
                throw new IOException("No appropriate API (JAXP/Xerces) to serialize XML document: " + domImpl);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe.toString());
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        }
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    public final void initContentDOM() throws IOException {
        this.contentDoc = this.createDOM("");
    }

    private final org.w3c.dom.Document createDOM(String rootName) throws IOException {
        org.w3c.dom.Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            System.err.println("Error:" + ex);
        }
        Element root = doc.createElement(rootName);
        doc.appendChild(root);
        return doc;
    }
}

