#!/usr/bin/env python
#----------------------------------------------------------------------
# Name:        setup.py
# Purpose:     Distutils script for building wxPython
#
# Author:      Robin Dunn
#
# Created:     12-Oct-2000
# RCS-ID:      $Id: setup.py,v 1.4 2007/08/31 09:03:41 gusstdie Exp $
# Copyright:   (c) 2000 by Total Control Software
# Licence:     wxWindows license
#----------------------------------------------------------------------

import sys, os


# The full contents of the wx.build.config module used to be located
# here in setup.py.  They were split into a separate module so it will
# be installed with wxPython and can then be used by the build scripts
# of other extension modules that wish to be wxPython compatible.
# The split is still fairly new and hasn't been tested by building
# third-party extensions yet, so expect some things to still shift
# back and forth, and also more stuff in config.py will get converted
# to functions, etc.

# This script imports it as just "config" because if wxPython doesn't
# exist yet, then it can't be imported from wx.build.config (since
# wx._core doesn't exist yet.)  So instead we keep the main copy of
# config .py in the same place as setup.py, and then copy it to
# wx/build as needed below.

# To fully support external builds, we need to have a build options
# file that is created whenever a new wxPython build is performed.
# We happen to be doing that here in this script, so make sure to
# remove the build_options.py file, so that config.py will recreate it.

sys.setup_is_main =  __name__ == "__main__"  # an icky hack!
from wx.build.config import *


#----------------------------------------------------------------------
# patch distutils if it can't cope with the "classifiers" or
# "download_url" keywords 
#----------------------------------------------------------------------

if sys.version < '2.2.3': 
    from distutils.dist import DistributionMetadata 
    DistributionMetadata.classifiers = None 
    DistributionMetadata.download_url = None
    depends = {}
else:
    depends = {'depends' : depends}

#----------------------------------------------------------------------
# Define the WXSVG extension module
#----------------------------------------------------------------------

PKGDIR='wx/wxsvg'

msg('Preparing WXSVG...')
location = '.'

other_includes = ['../include/']

swig_sources = run_swig(['wxsvg.i'], location, GENDIR, PKGDIR,
                        USE_SWIG, swig_force, swig_args, swig_deps)

ext = Extension('_wxsvg',
                swig_sources,

                include_dirs =  includes + other_includes,
                define_macros = defines,

                library_dirs = libdirs + ['../src/.libs/'],
                libraries = libs + ['wxsvg'] ,

                extra_compile_args = cflags + ['-DUSE_RENDER_LIBART'],
                extra_link_args = lflags,
                )

wxpExtensions.append(ext)


#----------------------------------------------------------------------
# Tools, scripts data files, etc.
#----------------------------------------------------------------------
if NO_HEADERS:
    HEADERS = None
else:
    h_files = []
    i_files = glob.glob(opj("src/*.i"))   + \
              glob.glob(opj("src/_*.py"))

    HEADERS = zip(h_files, ["/wxPython"]*len(h_files)) + \
              zip(i_files, ["/wxPython/i_files"]*len(i_files))

#----------------------------------------------------------------------
# Do the Setup/Build/Install/Whatever
#----------------------------------------------------------------------

if INSTALL_MULTIVERSION:
    EXTRA_PATH = getExtraPath(addOpts=EP_ADD_OPTS, shortVer=not EP_FULL_VER)
else:
    EXTRA_PATH = None
       
       
if __name__ == "__main__":
    setup(name             = 'wxsvg',
          version          = "1.0.0.0-beta7",
          description      = "wxPython bindings for wxSVG",
          long_description = "wxPython bindings for wxSVG",
          author           = "Edouard Tisserant, Alex Thuering",
          author_email     = "edouard.tisserant@lolitech.fr, alex.thuering@web.de",
          url              = "http://wxsvg.sourceforge.net/",
          download_url     = "http://sourceforge.net/project/showfiles.php?group_id=124832",
          license          = LICENSE,
          platforms        = PLATFORMS,
          classifiers      = filter(None, CLASSIFIERS.split("\n")),
          keywords         = KEYWORDS + ",SVG,wxSVG",

          packages = [ 'wx.wxsvg' ],

          extra_path = EXTRA_PATH,

          ext_package = PKGDIR,
          ext_modules = wxpExtensions,

          options = { 'build'            : { 'build_base' : BUILD_BASE },
                      },

          scripts =    None,
          data_files = None,
          headers =    HEADERS,

          # Override some of the default distutils command classes with my own
          cmdclass = { 'install' :        wx_install,
                       'install_data':    wx_smart_install_data,
                       'install_headers': wx_install_headers,
                       'clean':           wx_extra_clean,
                       },
          )


#----------------------------------------------------------------------
#----------------------------------------------------------------------
