
import  cStringIO
import  wx

#----------------------------------------------------------------------

ArtClients = [ "wx.ART_TOOLBAR",
               "wx.ART_MENU",
               "wx.ART_FRAME_ICON",
               "wx.ART_CMN_DIALOG",
               "wx.ART_HELP_BROWSER",
               "wx.ART_MESSAGE_BOX",
               "wx.ART_OTHER",
               ]

ArtIDs = [ "wx.ART_ADD_BOOKMARK",
           "wx.ART_DEL_BOOKMARK",
           "wx.ART_HELP_SIDE_PANEL",
           "wx.ART_HELP_SETTINGS",
           "wx.ART_HELP_BOOK",
           "wx.ART_HELP_FOLDER",
           "wx.ART_HELP_PAGE",
           "wx.ART_GO_BACK",
           "wx.ART_GO_FORWARD",
           "wx.ART_GO_UP",
           "wx.ART_GO_DOWN",
           "wx.ART_GO_TO_PARENT",
           "wx.ART_GO_HOME",
           "wx.ART_FILE_OPEN",
           "wx.ART_PRINT",
           "wx.ART_HELP",
           "wx.ART_TIP",
           "wx.ART_REPORT_VIEW",
           "wx.ART_LIST_VIEW",
           "wx.ART_NEW_DIR",
           "wx.ART_FOLDER",
           "wx.ART_GO_DIR_UP",
           "wx.ART_EXECUTABLE_FILE",
           "wx.ART_NORMAL_FILE",
           "wx.ART_TICK_MARK",
           "wx.ART_CROSS_MARK",
           "wx.ART_ERROR",
           "wx.ART_QUESTION",
           "wx.ART_WARNING",
           "wx.ART_INFORMATION",
           ]


#----------------------------------------------------------------------

class MyArtProvider(wx.ArtProvider):
    def __init__(self, log):
        wx.ArtProvider.__init__(self)
        self.log = log

    def CreateBitmap(self, artid, client, size):
        # You can do anything here you want, such as using the same
        # image for any size, any client, etc., or using specific
        # images for specific sizes, whatever...

        # See end of file for the image data

        bmp = wx.NullBitmap
        # use this one for all 48x48 images
        if size.width == 48:
            bmp = makeBitmap(smile48_png)

        # but be more specific for these
        elif size.width == 16 and artid == wx.ART_ADD_BOOKMARK:
            bmp = makeBitmap(smile16_png)
        elif size.width == 32 and artid == wx.ART_ADD_BOOKMARK:
            bmp = makeBitmap(smile32_png)

        # and just ignore the size for these
        elif artid == wx.ART_GO_BACK:
            bmp = makeBitmap(left_png)
        elif artid == wx.ART_GO_FORWARD:
            bmp = makeBitmap(right_png)
        elif artid == wx.ART_GO_UP:
            bmp = makeBitmap(up_png)
        elif artid == wx.ART_GO_DOWN:
            bmp = makeBitmap(down_png)
        elif artid == wx.ART_GO_TO_PARENT:
            bmp = makeBitmap(back_png)

        elif artid == wx.ART_CROSS_MARK:
            bmp = makeBitmap(cross_png)
        elif artid == wx.ART_TICK_MARK:
            bmp = makeBitmap(tick_png)

        if bmp.Ok():
            self.log.write("MyArtProvider: providing %s:%s at %s\n" %(artid, client, size))
        return bmp



class TestPanel(wx.Panel):
    def __init__(self, parent, log):
        wx.Panel.__init__(self, parent, -1)
        self.log = log

        sizer = wx.BoxSizer(wx.VERTICAL)

        title = wx.StaticText(self, -1, "ArtProvider")
        title.SetFont(wx.Font(18, wx.SWISS, wx.NORMAL, wx.BOLD))
        sizer.Add(title, 0, wx.ALIGN_CENTRE|wx.ALL, 5)

        line = wx.StaticLine(self, -1, size=(20,-1), style=wx.LI_HORIZONTAL)
        sizer.Add(line, 0, wx.GROW|wx.ALIGN_CENTER_VERTICAL|wx.ALL, 5)

        fgs = wx.FlexGridSizer(0, 3, 10, 10)

        combo = wx.ComboBox(self, -1, "", choices = ArtClients,
                           style = wx.CB_DROPDOWN|wx.CB_READONLY)
        fgs.Add(combo, 0, wx.ALIGN_CENTRE|wx.ALL, 5)
        self.Bind(wx.EVT_COMBOBOX, self.OnSelectClient, combo)
        combo.Select(0)

        combo = wx.ComboBox(self, -1, "", choices = ArtIDs,
                           style = wx.CB_DROPDOWN|wx.CB_READONLY)
        fgs.Add(combo, 0, wx.ALIGN_CENTRE|wx.ALL, 5)
        self.Bind(wx.EVT_COMBOBOX, self.OnSelectID, combo)
        combo.Select(0)

        cb = wx.CheckBox(self, -1, "Use custom provider")
        fgs.Add(cb, 0, wx.ALIGN_CENTRE|wx.ALL, 5)
        self.Bind(wx.EVT_CHECKBOX, self.OnUseCustom, cb)

        fgs.Add((10, 10), 0, wx.ALIGN_CENTRE|wx.ALL, 5)
        fgs.Add((10, 10), 0, wx.ALIGN_CENTRE|wx.ALL, 5)
        fgs.Add((10, 10), 0, wx.ALIGN_CENTRE|wx.ALL, 5)

        box = wx.BoxSizer(wx.VERTICAL)
        bmp = wx.EmptyBitmap(16,16)
        self.bmp16 = wx.StaticBitmap(self, -1, bmp)
        box.Add(self.bmp16, 0, wx.ALIGN_CENTRE|wx.ALL, 5)
        text = wx.StaticText(self, -1, "16x16")
        box.Add(text, 0, wx.ALIGN_CENTRE|wx.ALL, 5)

        fgs.Add(box, 0, wx.ALIGN_CENTRE|wx.ALL, 5)

        box = wx.BoxSizer(wx.VERTICAL)
        bmp = wx.EmptyBitmap(32,32)
        self.bmp32 = wx.StaticBitmap(self, -1, bmp)
        box.Add(self.bmp32, 0, wx.ALIGN_CENTRE|wx.ALL, 5)
        text = wx.StaticText(self, -1, "32x32")
        box.Add(text, 0, wx.ALIGN_CENTRE|wx.ALL, 5)

        fgs.Add(box, 0, wx.ALIGN_CENTRE|wx.ALL, 5)

        box = wx.BoxSizer(wx.VERTICAL)
        bmp = wx.EmptyBitmap(48,48)
        self.bmp48 = wx.StaticBitmap(self, -1, bmp)
        box.Add(self.bmp48, 0, wx.ALIGN_CENTRE|wx.ALL, 5)
        text = wx.StaticText(self, -1, "48x48")
        box.Add(text, 0, wx.ALIGN_CENTRE|wx.ALL, 5)

        fgs.Add(box, 0, wx.ALIGN_CENTRE|wx.ALL, 5)
        sizer.Add(fgs, 0, wx.ALL, 5)
        self.SetSizer(sizer)

        self.client = eval(ArtClients[0])
        self.artid = eval(ArtIDs[0])
        self.getArt()


    def OnSelectClient(self, evt):
        self.log.write("OnSelectClient\n")
        self.client = eval(evt.GetString())
        self.getArt()


    def OnSelectID(self, evt):
        self.log.write("OnSelectID\n")
        self.artid = eval(evt.GetString())
        self.getArt()


    def OnUseCustom(self, evt):
        if evt.IsChecked():
            self.log.write("Images will now be provided by MyArtProvider\n")
            wx.ArtProvider_PushProvider( MyArtProvider(self.log) )
        else:
            self.log.write("MyArtProvider deactivated\n")
            wx.ArtProvider_PopProvider()
        self.getArt()


    def getArt(self):
        self.log.write("Getting art for %s:%s\n" % (self.client, self.artid))

        bmp = wx.ArtProvider_GetBitmap(self.artid, self.client, (16,16))

        if not bmp.Ok():
            bmp = wxEmptyBitmap(16,16)

        self.bmp16.SetBitmap(bmp)

        bmp = wx.ArtProvider_GetBitmap(self.artid, self.client, (32,32))

        if not bmp.Ok():
            bmp = wxEmptyBitmap(32,32)

        self.bmp32.SetBitmap(bmp)

        bmp = wx.ArtProvider_GetBitmap(self.artid, self.client, (48,48))

        if not bmp.Ok():
            bmp = wxEmptyBitmap(48,48)

        self.bmp48.SetBitmap(bmp)


#----------------------------------------------------------------------

def runTest(frame, nb, log):
    win = TestPanel(nb, log)
    return win

#----------------------------------------------------------------------


overview = """<html><body>
<h2><center>wx.ArtProvider</center></h2>

wx.ArtProvider class can be used to customize the look of wxWindows
applications.  When wxWindows internal classes need to display an icon
or a bitmap (e.g. in the standard file dialog), it does not use a
hard-coded resource but asks wx.ArtProvider for it instead. This way
the users can plug in their own wx.ArtProvider class and easily replace
standard art with his/her own version. It is easy thing to do: all
that is needed is to derive a class from wx.ArtProvider, override it's
CreateBitmap method and register the provider with
wx.ArtProvider_PushProvider.
<p>

This class can also be used to get the platform native icons as
provided by wx.ArtProvider_GetBitmap or wx.ArtProvider_GetIcon methods.

</body></html>
"""


#----------------------------------------------------------------------
# Image data


def makeBitmap(data):
    stream = cStringIO.StringIO(data)
    return wx.BitmapFromImage(wx.ImageFromStream(stream))


back_png = \
'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00 \x00\x00\x00 \x08\x06\x00\
\x00\x00szz\xf4\x00\x00\x00\x04sBIT\x08\x08\x08\x08|\x08d\x88\x00\x00\x07YID\
ATx\x9c\xa5\x97Ml\x9dG\x15\x86\x9fsf\xbe\xef^\xfb:\xaeS\xd7\xa9\x1d;!IK)\xfd\
A\x05\x95BQ\xc5\xdf\x02\xb1(\x12\x0b\x10\x8b\x8a\x05]Vl\xd8\xb2`\xcb\x92\xee\
Q\x85\xd8U\xaa\xba\x03\tD+@j\x91J\x11\x8aT\xd14\xfd\xa7\xf9q\x9a\xc6\x8e\xe3\
\xd8\xb1\xefwg\xcea1s\xaf\x13;\xaa*1\xd2h4su\xe7=\xe7\xcc{\xdes>\x99\x9b\x9b\
\x03\xe0\xf9\x17\xff\xe2[\xb6B;u\'\x86`\x19\x9299Ar\xc8\x19\xb29\xd9 \xe5\
\xb2O\x069\x97\xb3\x03{\x1b\xff\xa7\x9c\xa5zf\xe6,\x1e\xda\xe0\xe1\xe5U\xe6g\
\xb6\x91\xb9\xb99~\xf7\xc2i\x1f\xcc-3\xdd\x8f\xe5r\x83Q\x86\x94\xa0K\x05p\
\xbc\x1f\xe5\xba\xff?\xcf{\xb1\xe3;_x\x17\xf9\xd3\xcb\xaf\xbb\xce>\xc2\xcctd\
\x94*x\xca\\\xdb\xd8\xe2Fg\x98\x0b\x96\x95l\xc2\xc8 \xbb\xe0Y\xc8&\xd5+!eadB\
JBv\xa9`R\xef\x12FYH\x19\xcc\x84.\xcb\xc4\xb0\xa5\xd9k\xc4-[f\xb1_\xc0\xdda\
\xed\xca*k\xabg\xd9\xda\xfc\x84\xeb;\x01\x97\x1eh\x03\x12A"N\x03D\\"\xe6\x81\
LK\xf6H\xb6H\xf6@\xb6@\xf2H\xb2\xc0(+\xd9#\xbb]$y\x00\x14\xd5\x00\x08\x00\
\x17\xaf\xcd\x12\t\x83b\x9d\xc3\xd6\xf5\xab|\xf4\xf6+|ti\xc8\xb9+\rW\xae\xb7\
\x88*\x1a\x14\x15E\x82"Z\xa7(\xaa\rh\x00\tH]\x11\x05Q\\\x14<\xe0\x12HV"\xe8\
\x08\xfd6\xd3k\x03\xee\xc2(\t\xd1\xc6\x841\xf8\xf8\xc2;\\^\x1f\xf2\xda\xd9\
\x86\xc1\xf4!V\x16gh{-\xe6J\x08\x11\t\rA\x03\x1a"\xaa\r\x12\x02\xaa\x81 \x11\
\x82\xa2\xd5\x10\x11-\x06\x11\xe8\xb7\xca(\x0b\xef\xad\n\xeb\x9b\x86Y\xa6UgD\
\x03@4wF\x19,\x8f\xb8\xb1u\x85w/6\xf4z\x03N\x1e\x9bc\xa7\x13.\xad\x8d\xd8\
\xed\x04QG\xd5\x11\x8d\x88\n\xa8 \x02\xaa\x02\x9a\x01\x07\x11\x10\xc1\xa5\
\x84\xd8\x81\xa9>\x9cZR\xbev\xbf\xf3\xea\x1b\xc6ng\xb4\xd1\xd8\xee"\xee\x82\
\x9a\x15V\xa6,\x98\x05\xae\xef\xf69<7 [\xe0\xfc\xe5!\xdb\xbb`D\x9c\x80\x110\
\x1a2\x01\xf32\x93+)+\xc9\xea\xbb[ \xe5\xc8(\x17\x0e\\\xdbV\xfe\xf3a\xa6\x1b\
\x19\xcb\x0bNTc\xaa5\xc6#\x9a\x97Ts\x03B\x8b\xc6\xcc\xf4T\x8f\xcd\x1b\x86y@\
\xb4A5V\xcf[\xd0\x88H\x99\xd40#\x91\xe1\xf6\xc7|\xf0\xfa\xb3\xe44\xac$\x13\
\x16\x1f|\x9a\xc3+\x8fc9s\xe1\n\xdc5\x0b\x17.\x1bM(\x112\x87\x98\xcdk\x8a\
\x00\x94\xb7\r!\xe2#\x10\x95\xcf\x04\x8e\x04\xba\xe1&\xabg\x9e\'w[\x13\xef\
\xe6V\x9e@W\x1eC\xc4p\x87\x18 \x06\xa3\x89\x8a{\xc9\xbahUt0\n\x80\xc6B\xb2\
\x00\xaa\xf6\x99\xc0]\xea\xbe\xa6\xd7x\x08\x86\x88\xa1bD\x15\x82B\x10\xa7\t\
\x19K\x1d9Iy\x82\x94\xc0\x11\xa0\xe4\xbajD\x15D\xed3\x82G\x1ce\xff\x10\xbc\
\x82\x1bA\xa5\xcc`4\x01R\xee0\x13\xa2Y\xc9\x02\x1c\x8c0y\x82\x9a\xce\x07\xc0\
\xddAt?x\xb8\xbd\x01\xe2\x15\xdcPQT\xa0Q\xa7\t`y\x88\xe5q\x16T\xfd\xf7q\x04B\
 \x84\xe6\x00x\xeevx\xff\xb5\xdf\xb0~\xfe\xd5\x03\xe0\xb73@e\x0c\xee\x04\xf5\
\xca\x01\xa7\t\x86\xa5\x0e\xcf\x1dj\xe6E\xbbS5@cU\xb8\x83\xe0\xef\xfc\xe3\
\xd7|\xf8\xfa\xb3\x9cy\xf9\x17\\=\xf7\xea-\xe0\x8a\xdd\xc6\x00\xaf\xe0F\x08N\
T\'(\xc4h\xb8\x8d\xb0\xdc\xa1\xe6%\x02E\x8e\x03\xa2-\x12""\xe1\x00\xf8\x857~\
\x8f{fg\xe3\x03\xce\xbc\xf4s\xd6\xcf\xfd\xbd\x80\x8b\xa1d\x04?`@P+\xde\xab\
\x13\x024\xc1\xe97\x8e\xe7\x0e\xcfCt\\zG&\xe4ZdT\x02\xaa\xb7\x07\x1f\x8f\x9d\
\x8d\xf79\xfb\xd23\\;\xf7r\x01\x17\xdf\x1f\x00d\x1c\xfa\xeayPh\x1b\xa7\x89\
\x0e\xdea\xd6\xa1\xee^\x940A\xf6H\x13c\xcd\xfd\xc2\xf6\x94\x86\xdc\xb1\xf4(s\
\xcb\x8f\xdfry;}\x84\x95G\x9eA0`\x84\xe5m\xdco}\x86\x10t\xe2y\xac\xde7\x01z\
\x11\xdc\n\x07&: \x02x\xa0m\xa4V;@\x84\xde\xccQ\x16\x1fx\x8a\xd4\xedp\xf5\
\xfc+\x93\xcb\xd3p\x83\xde\xf4<\xf3\x9f\xfb&*\xc6\xf6\xe5\xd3\xe4\xd1\x8d\
\xc9\xef\xb1\x99f\xee\xae{\n\xb8:M\xa8\x86D\xa1\x89`\xb9\xc3\xb2U\x1d\xc8\
\xa0\x02f\x01Cji\x15\x10&l\xef\xcd\x9e@4\xe2\x96\x80r\xc1\xbb\xaf\xfc\x8a\
\xb4\xb3J\x7fz\x9e\xff\x9e\xfe\xed-\xde7\xfdY\x06\xb3\x0b\x05<\x8e\xa3P\xc0\
\xdb\x08X5 \xd7,P\x11\xdcJ\x9dV\t\x88\x08.LR\xed\xd0\xdd_e\xfa\xf0}l\xaf\xbd\
9\x01\xd9\xdd\xfc\x88\xb7\xfe\xfaKD\xc3\xc4\xb0\xf1\xb8\xfb\xc47\x98=\xbcD\
\x13\xbd\x86_*\t\xa1\x89\xe0\x96\xf0\x9c\xf6t\xa04\x94\x01#\x82j\x997\xe5y38\
\xca\xd1\x87~\xc6~\xb9\x05?\x00\xde\xf4\x0e\xf1\xc5\xc7~J\xaf\r\x05<\xde\x04\
\xde\x08m\x03\xee\t\xcb\xc3\x92\x86\xa3\xda4\x8er S\xbb\x9b}"\xa3b,\xdd\xffc\
\x16N}\x1f\r\xed\x01\xc6\xef\xbd\xfd\x14\xf7=\xfa\x14\xcb\xa7\x1e\x9d\x80\
\xc7\xeau\x08B\x1b\xa1\x8d\x8a\xdb\x10\xb7\xaeHqJ\x85\x03\x9e\x15s\x10\n\x07\
\xbc\xa8\xf9$\xcf{3\x0b|\xe9\xc9\xe7X\xff\xf0\xcf\x9c;\xfd\x1c\x1b\x97N\x93j\
\xf5\x8b\xcd\x14\xf3+_\xe1\x81\xaf?\xcd=\x0f}\x8f\xb6mn\x01\x8f*5\xfcJ\xbf\
\xe7\x95\x037e\x81\nXR\x92\x95~\xaf\xdf+\x06LD\xa6V\xb5\xb6?\xe0\xd8\x03?d\
\xf9\xde\xef\xb2}\xf5,\xdb\xebo\xa3df\xef<\xce\x91\x95\x87\x99\x1e\xcc\x1c\
\xf0\xbc\t\xc2\xa1\x81\x12\x832\xd5S\xdahX\x1e\xe1y\xb8\x97\x05"\xd0\x8d"\
\xd9\x84\x8dm\xe1\xd4Q\xe5\xd2zfk;\xdfTR\xf7\xb4\xbd\x99\x1a0=\xf82K\xc7\x1f\
\xd9K\xb51\xe1\xf6\x81\xdfqH9\xbe\xd8pi-\xd36B\xd3\x08\xe27G \x15ju)\x90\x0c\
.\xac\t\'\x16\x9d\'\x1e\x84s\x9f@7\xa2\xd6sAE\t\xea\x84 {\xda^E&\xdc\xcc\xf6\
\x1a\xf6~O8~w\x83 \xacof\x8e-\x08MTR\xea\xb0<\xac\x1c\xc8P\xaaw\xc0\xdd\x19v\
\xc6kof\x8e\x1c\x866Z\x05\xda\xabj\xb7\x14\x96O\x01\x8f\r\x88\x08\xabW2[\xbb\
#\xa6{pbQ\xf9\xdb?/\xb2\xb9\xb9\x8d[":\xb5\x1f\x00\xdc\x85A\xdf\x18\xa5\x8c\
\xbb\xb1\xb6Q:\xd8\x18\xac\x94Q-k[C\x1d\xa3\xd3\x8b\x8eEh\xa3 ^"iU\xc4\xd4\
\x95&8m\x14\x16\xef\x14\x96\xe6\x95l\xc6\x0b\x7f\xf8\x17f\x1d\xb8\x11\x8f\
\xcd]\xe5\xcc\xea\x11\xccJ#\xa9!0\x88\xd0\x84L\x1b\x85\x18tR\xc3\x83\x16\x1e\
\xc4\x89!U\xdf\xe3\xb8\xd7s\x9a e\x8dB\xaf1\x1a\x15\xa2\n\xbbC\xe1\xf4[[\xbc\
\xf8\xc7\x7f\xf3\xde\x07\xab\xb8\x97\xce(\x9e\xbck\x8d\x85\x99M\xce_\xbdc\
\x12\x85\x11\xb1\xf6\xed%2f`\xa9#\xe5\x8e\x9c\x129\x15\x02y\x1eb\xb5\xa8\x94\
\x0e\xa7+\nge?>/kWz\x00\xebp7<\x0f9yr\x19\xfd\xc9\x8f\x9e\x94o}\xfe=\xee]\
\xf8\x04%\x17A\x1aW\xc7}_\xb5\xd9J+\xfd\xa9\xc3\r\xb7\\V\xb7\xc9\xea\x9e\x8b\
b\xba!\x18G\x97\xe6\xf9\xc1\xb7\x97\xf9\x1f\x92tznH\x8fy\x14\x00\x00\x00\x00\
IEND\xaeB`\x82'

down_png = \
'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00 \x00\x00\x00 \x08\x06\x00\
\x00\x00szz\xf4\x00\x00\x00\x04sBIT\x08\x08\x08\x08|\x08d\x88\x00\x00\x042ID\
ATx\x9c\xa5\xd5Ko\x1bU\x14\xc0\xf1\xff\x8c\xe7\xe1g\xe2\xa6\x84\xa8\xa8\x82\
\xd0\x88E\xabJ\x08\t\x8a*\xb1@\x02v\xec@l`\x87\xf8\x1e\x91\xf8\x06 \x90\xd8\
\xb3\xe2S\xb0aS\x1ej\x8bhIe\xd2\xa8i\xa8\x13\xc7\x8f\xda\xe3\x99\xb93\xf7\
\xcee1\x1e\xc7\xae\xed\xc4c\x16Wc\xddk\xfbw\xce\xf1\xf1\xb9\xc6\x0fw\xb5\xfe\
h\x1b\x02\t\x91\x02\xa1 N&^+\x88\x12\x08%\x08\x99\xeeE\xa3\xf3l\t\x05~\x9c>\
\xc3\xd1^(\'>7:\x7fqOH0\x13\r\x00\xa6\x91\xae\x82\x01F\xba5~\xca\x04\x94\x86\
db\xa9\xd1\x92I\x1a|\x16t<\x91\x84\x18%\x15\xc4g\x81\x87Y\xa2\x12\x94R\x98J\
\x8f\x0e\'\xb2\x11\nNzC\xfex\xb0\x8f\x17\xeb\xf4|"\xfb\xec\xfdB\x82\x17\x9fe\
\xfcb\x05\xc6\x99gU\x12\n!\x13\xc2\x11\x8e\x14X*\x99\xc5#\x05a\x9c\xf0\xfdw\
\xdf\xb0qe\x9bO>\xfb\x9c\xcb\x9b\x9b+\xe3\xa1L\xe8{\x01a\xa40\xdc**Iq\xad",\
\xa5g\xf1HA\xb1R\xe3\xda\xcdw\xf8\xe5\xa7o9\xd8\xfb\x93\xdb\x1f\x7f\xc1\xdb\
\xb7\xde\xc5)\x96s\xe1\xfda\xc0\xc0\x1b\x12)0\xdd\x1aI\xa2\xc78\xb1O\xe1\xc3\
\xafvw\xafT\xa7q\x7f\xf4%\xf5\x8d-\xee\xfcz\x87\xb0w\xc2\xc1\xdf\xf7y\xf8\
\xcf!Vu\x13wm\x8381\xce\xc5\xbd0\xe6\xb4\xd3a0\xf0\x90X\x18v\x19,w\nG\n\n\
\x1f|\xb9\xbb\xbbU\x99\xc5#\tv\xa9\xc2\xa3\xc3\x16\x9d\xe6\x13\xb0\\\x82a\
\x9f\xc7\xfb\rN\xfa!v\xf5\x12\x96[\x99\xc1\x07\xa1\xa4\xd5\xeepzz\x8a\x88\
\x15\xda.\xa5\xb8S\xc2\x88\xa7\xf1\xb4\x07\xf4|\\(\x90\xda\xe0\xad\xdb\xef\
\xf3\xf8\xaf\xdfP\x1a\x0c\xb7\x86L4O\x1e\xfc\xceq\xf3\x19Wo\xdc\xe2\xea\xceu\
\x12\xd3!\x94\x9aV\xe79\'\xad\x14\xc6.\x81S\x1e\xe1e\x1cb\x84\x12S\xb8\x96\
\x11\x96L\xe6\xe3Y\xc3m_\xbb\xc6\xfa\xab7\xe86\x0f\xc1.aXEp\xca\x88(f\xff\
\xc1]\x8e\xdb]6^\xd9\xc1\xf3C\xfaC\x1f]pa\x84fx\xc5\xd2\x84A8\x83#E:\x07\x16\
\xe1\x91\x02\xa3\xe0\xb2\xf3\xe6{`\x97\xc78N\x05\xc3)\x83]b\xe8y<=h\xd0\xeb\
\x0f\xe6\xe2U\x1b,bT0\x98\xc1Q\x023N\x16\xe3Y\xb7o\xbfq\x9d\xf2KW_\xc0\'\xa0\
\xe2\xfa\xec\xde\x08\xaf8\x90\x88!z\x0e\x8e\x8c\xd2At\xd1\x90q+kl\xbe~s>^\
\xaa/\xc4\xab\x0eTL\x89\xef\xf5\xe7\xe2Z\nL\x99\x9c\x8fg\xdd\xfd\xca\xceu\n\
\xe5z.|\xa3\x08\x81?D\x8a`.N\xec\xa7\x01,3\xe1\xca\xeb\x97\xa9\xbd\xfcZ.\xbc\
h&\xf4\x9f\xf7\x16\xe2H1}\x17\x9c7\xe1\xe2\xc4\xe4\xd2\x95m\x0c\xa7\xb2\x14^\
s@\x84>\xde\xa0\xbf\x10GE\x98?~z\xc9Xv\xb6;k\x9b\xd8\xeb[K\xe1eKs\xda\xe9\
\xa2\xe3p!\xae\xa5\xc0\x84\xe5/\x16Up(\xd6\xb7.\xc4\xab\x0eh\x15\xd1>m\x9f\
\x8b\x93\x05\x90\xe7J-\x94\xd60\xdc\xea\xb9x\xd5\x86V\xbbG\x14z\xe7\xe2\xc8\
\x08\x0b\x96\xc7C\t\xca\xb01\x9c\n\xdar\x17\xe2\x16\x8a\xa3\xe6\xf1\x858jT\
\x81e\xf1\xecL\x17\xec\x85x\xcd\x81^\xdf\xa3\xd7\xe9\\\x88\x9f\xf5@\x0e\\)\
\x85\x11\x0b\\S\xcd\xc5\x8b\x05\xcd\xc1\xd3&*\n.\xc4\x89\xfcQ\x05r\xe0HA\xa2\
\x04:\xf2g\xf0\x8a\rB\x08\x0e\x8f\x8e\x96\xc2\xc7M\x98\x07\xcf\xee\xf3\xa1\
\xd7\xc7BN\xe15\x07\xf6\x8fZ\x04\x83\xeeR\xf88\x80\xbc8R\x10\x0e\x07xC\x7f\n\
\'\x914\xf6\x1f/\x8dO\xf5@\x1e<\xbbX\x9a\xc7-\xdc\x82\x1e\xff\x14\xadn\x9f\
\xe3\xe6\xbfK\xe3\xe3\n\xac\x82#\x05\xedv\x0b\xdf\x0f\xa8:\xb0\xeeh\xee\xed\
\x1d\xa0\xa2pi\xfc\xeco\xb8\x02\x8e\x12D\x81O\xe3\xe91\x1bEx>\x0c\xd9k4r\xe1\
\xe3\n\xac\x82gCf\xefQ\x83@D\xdcm<c\xd0\xeb\xe6\xc2\xb5\x14\xe9$\\\x15\'\xf6\
\xe9u\x04?\xdf;\xe0\xfe\xc3G\xb9q"\x1f\xa3^\xafc}\xdd\xd5\xab\xe0Y\xb7\x1bIL\
\x12\x05\xb9q&+\xb0*\xae\xc7@~|\xfc7\xfc?\xf8*e\x9f<\xfb\x0fT{\xea\xc3\x87j\
\xf9\x90\x00\x00\x00\x00IEND\xaeB`\x82'

left_png = \
'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00 \x00\x00\x00 \x08\x06\x00\
\x00\x00szz\xf4\x00\x00\x00\x04sBIT\x08\x08\x08\x08|\x08d\x88\x00\x00\x04\
\x03IDATx\x9c\xc5\xd7Mo\x1bE\x18\xc0\xf1\xff\xbe\xc4^\x9b\x86V\x81\x86\xf2\
\x8e\x8aJ+\x90(jE\x85\x84\xd4\x03\x12G$\xee\\\xb8\xf2-\xfa9\x10_\x82\x0b\x07\
N\xbd \xd4"\xd1&MQ\xd44iZ7N\xea$vl\xafwwv\x9e\x99\xe1\xe0\xf7\xc4i\xeb\xf4%\
\x07k\xf6\x19\xef\xccoV\xf3\xb2\xcfz\xbf.8w\xba\x04\xb9\x05cA[0\x0e\xc4\x808\
\x90^\xbd\xb2\xa0\xcd\xf0\x1eq\xddX\xdb\xee=\xa9t\xe3\xbc\xf7\xbf2\xbd\xd8t\
\xafS\xe9\x96\xfd87\x90\t\x84\xa7Kpq~X\xd9\xbfa4N\xfa\x8d\xfb\xa5\x1d\xe9L \
\xd6P\x0c\xc0\xb9\xee\xe05\xe0\x01\xb6\x17\xe7\xbd\x81j;\x8e\x1bc\xf0G;;*\
\xde\xefP\x19\xc8\xccx\x9c\xe8n\x9d\xea\xd5\x8d\xe2\x88\xc27\xf6\xf8pgr|m\
\x8f\x0fG\'\xf8\xc6\xbd>\x1ck\x08l>\xc0\x11\x85/\xaf\x18\xef?\\\x148\xe6J\
\x80\xd5\x03\x1cQ\x84\xe2^\r\xde\xc9-\x99\xf1\xf1\x80\x13\x0581\xe3\xd1\x8cs\
$\x8b\x07\xb8\x93\x9cP\xec\xcb\xc3\x13mi\xa5B\xa2\x1d\xda+R\x0c!\nav\x06D\
\x84\xb8\xbd7\x86#\x8a\xd0\xd8\x17\xc33q4:9{\x1dE\xac,\xe2\x15\xa0P&\x1a\xc1\
g|\xcbn\xb3\x89\xcd\xb31\x1c\xa3\x08\x95=\x1a\xdeN\x85\x9dV\x87\x9d\xbd\x0e\
\x89v\x98\xa0\x887S>\x80\x97Bh\xc5)\x9d\xb8u\x00GrB=\x05\x9ej\xc7n3\xa6\xba]\
\xa7\xdeN\xc9\xc4\x83\x99\x12\x14\xca\x87\xe2\x9e3\xec\xd6\xeb\x13q\xd7\x9f\
\x82g\xe1\xad4\xa7\xb2\xb5Mu\xb3F\xb3\xddA\xc22^\xa1\xfcL\xbc\x18:6\xb7\x9b\
\xe4ig"\x8eN\x08\xb5\x9d\x8cg\xda\xb2\xb1\xbd\xc7ze\x83\xcd\xcd-\xd2\\\xe3\
\x82\x08J\xa7zx\xf9\xa9x\x14\x82R\x8a\xc6\xee\xee\xa1\xf8`\x1b\x8e\xe2\xb5V\
\xc6\xea\xc3\xc7\xdc_{@\xa3^G[o\x08M\x81\x87\x9ee\xfd\xc9\x0eZ\xa5\x87\xe2\
\x98\xde\x1aP\xe2X\xab\xd4X\\^\xe1\xd1\xfa\x1aI\x92\xe0\xc2h\x1c\x9a\x02\x8f\
B\xd8\xad\xb7i\xee5\x9e\x8a;Q\xdd)\x88Sa\xe9\xde*k+\xcbd*?\x08M\x89G\x01\xa4\
i\x82\xd3\xd9SqD\xe1\xfd\xf2\xa7s\xa1\xdf\x9d\x82\xda^\xcc\xfd\x07\x15\xaa\
\x9b\x9b$\xa9\xc2\x06\xc5\xa9\xf1\xfeu\x1c\'\xdc\xb8u\xa7\xb7\x00\'\xe3H\x8e\
\xf7\xf3\x1f\xce\x15\x83\xf1}\xde\xc9\x84Z\xa3E\xad\xd1\xa6\x9d\n\xe2\xcdL\
\x85\x97B(\x06\x8e\xbb+\x15\x16\x96\xee\x1e\x8acTw\r87~\xc8\x18/\xe4\xc4\xc9\
9\xfc\xf2\x1ce%\xb4SM\xa2=L\x10=\x17\x1e\x050[\xf4\xb8|\xee\x0c\x1b\x955v\
\xb6\x1a\x13q\'j\x98\x11\x1d\xf6bq^HX(Q\x8c"B\x1f\x02\x1c\xe5\xc0=\x03\xef\
\x96\xef\xbcY\xe0\xeb/>\xc5w2\x11\'O\xba\t\xc9\xf3\xbc\xcf\x95\x80\x88\xa1\
\x93\xa4\xec4c\x1a\xed6\xceh\xa2\xc0M\xc4\xfb\x83\xfa\xe6\xfc{\x9c\xfd\xf8\
\xfd\x898\xa2\xf0\xd5s\xe0\xfb3\x19\x95\xb4\xa9\xd5vX^}\xc4\xbd\xf5*\x8df\
\x8c\xef\xcc\x01\xbc\x14\xc2\\9\xe0\x87\xab\x97(\x15\xc2\x038\xa2\xf0\xf5\
\x11\xd2\xa8~c\x95v\xa8V\xab\xdc\xbc\xb5\xc0\xf5\x9b\x8b,\xadV\x89\x93\x8cb\
\x0f\xef\xff\xbe\xfa\xe8\x14W.}y\x00w\xa2\x08s\xd3M\x9d\xa7\xc5G\x8fW+9\xdbO\
Zl?^c\xb1\\\xe4\xc2\xd9\x0f\xb9\xf2\xf9\'\\xw\x96R\xe83[\xf0\xf8\xe9\xfb\xcb\
\xfc\xf7\xef\rj\x1b\x8d\x01\x8e(\x823?^\xbb\x96\xc9\xd1\xf1\xfd\x87\x8cJ\xda\
<\xae<\xe4\xf6\xe2\x1dV*5\\P`\xfed\x99s\xf3\x11\xfe\x1boq\xf3\xef\xbfp\x92\r\
\xf3\x81T\x86\x1f\x0c/\x8a\x8fn\xb5\\r\x96\x97n\xb3\xbc\xf0\x0f\xbf\xcf\x9d\
\xe4\xbb\xab\xdfr\xf1\xb3\x0f\x98?\xfd6[\x8f\xee\xf7\xda+\xbc\xf3\xbf9\xa7\
\xed\xcb\xc5\'\xadvDQ\x08}\xf2N\x0b\'\xe9\xf8\x1a\xd8\xff\xb9\xf4*p\'\n\x95\
\xa9\xc1\x93\x0f\xce\x81\xd7\x85\x0f\xdb\xef;\x07\x8e\x13w\xa2\xf0\x8f\x13G\
\x14\xff\x03\xe8\x84\x1b+\xdf\xf26\x9e\x00\x00\x00\x00IEND\xaeB`\x82'

right_png = \
'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00 \x00\x00\x00 \x08\x06\x00\
\x00\x00szz\xf4\x00\x00\x00\x04sBIT\x08\x08\x08\x08|\x08d\x88\x00\x00\x04\nI\
DATx\x9c\xc5\x96Ko\x1bU\x14\xc7\x7f\xf3\xb4=&\xd4mQ_H\xd0"\xdaD,\xda\x8aR\nB\
\xa8\xb0a\x83\xc4\x82\r{>\x01_\x00\xa9;>\x04\x0b\xb6,\xd9\xb0fQ@\x08\x81BU\
\x92\xaa\xa1\xa5\x0f\xbbQ\x12\'c{\xecy\xdf\x07\x8b\xf1\xb86u\x9c\xa4I\x95\
\xd5\x9ds\xe6\xce\xfd\x9d9\xf7\x9c\xff\xbdF\xa3\xd1\xe0\xbb\xdf;:S \x15\xe4\
\n\xa4\x06!Ah\x10C\x7f\xaa \x97O\xe7\x08]\xd8\xb9*\xe6\xc4\xa2\xb0\xb3\xe1\
\xfbT\x0emY<\xc7\xa2\x18K;\x93\x90\x08\xb0\xbf\xf9\xa9\xa3/\x9dx\xea,\'\x8c\
\xdbQ\xf9q9\xaa\xb1\xc5\x04\x0cr\xa8X\xa0u\x11|\x0e\x18\x80\x1a\xda\xd90\xd0\
\\M\xc2\xa5\x94\x98R\xef\x1f^.\x98JH\xe4\xa4\x1d\xe5\x85/\x1d\xfa\xc6\xe1\
\x88\x14S\xaa\xc3\x83k\x99\x15\x198,8y\x84]nA\xb9\xf8\x1fK\xf7\xb1\xaa\x1e\
\xa7N\x9dBH\xe3\x85\xc2\x11)\xb6T\x93\x7f\xde\\\xf7\xf9\xfe\xdb\xaf9s\xe1\n\
\xd7\xae\x7f\xc2\xf9\xf9\x0b\x98N\xe5\x85\xc0\x8b\x00\xf4d\xda\xaf]\xbd\xc2\
\xcd\x9bW\xb9\xfb\xf3\x0f\xdc\xbf\xf5\x0b\x8d\xb3\x17Yx\xf7#\xe6\xdf\xbaHm\
\xee(\x992\x0e\x0c\xaeE\x86-\xd4\xe4\x9eKm\xf2\xe9\xe7_\xd0\xbc\x7f\x87\xb8\
\xd7\xc6o\xad\xf0\xebz\x8b\xc5\xdf\xcer\xf2\xcdK\xbc\xbep\x89\xa3\'N#\rg\xdf\
pD\x8au\xfd\xcb\x1b7\x8eT\'\x0b\xce{i\x8e\x9e\xac\xd0\xfa\xf7.\xd8\x15\x8c\
\xca\x1cBi\x02\xbfM\xeb\xf1CV76I\xa5\tN\ri:\xcf\rG\xa6\xd8#q\xf8_\xb5\xbf\
\xf7\xc1\x87\xdc\xb9\xfd\x17\xdd\xf6*85\x0c\xbb\n\xae\x872\x1d\xfa]\x9f\xfe\
\xd2"n\xb3\x85\xf7\xca\xab\xd4\x8e\x9d\xc1\xacx\xa4\xd2\xdc\x13\x1cQ\xb6\xe1\
\x94V\xb3\xdd\x1a\x97?\xfe\x0c\xcbk\x8c\xe0\xb8u\x0c\xd7\x03\xc7\x03\xd7#\
\x97\x9a^0`cm\x95\xcd\xf6&a\x94\x90\xe4z\xd7p-RL\xa1\xb6\xef\xf3\xb3o\x9c\
\xe7\xe4\xfc;S\xe1\x86\xe3A\xad\x81\xe1zh\xabJ\xaeM2\xa1\x90\x18\xb8\xa6\xc6\
6\x14\x86\x88g\xc2\xc9\xa3a\x11n\xd3\xe7\xb9\xb6\x98\xbf\xfc>\xbe\xdf%\x13b*\
|\xc2\xe7z\xd4\x1d\xf0\x1c\x9b\x97\x9d:H\x9b\xa0\xd7\xa3\xd7MI\x92g\xe1\xa36\
\x9c%2\xf5\xc6q\xce,\xbc\xcd\xa3\x95%\xb4S\xdb\x05\x1c\x1a\x15\xf0\x1c\x83\
\xbaS\xe5\xdc\xf1*\xc8c\xf8\xdd.\xcd\'kl\xb5\xd7\xc8\xcbm\x91\x19F\xa3\xd1\
\xe0\xab\x1f;z\x96\xc8\xf4\xa3\x8c\xbfo\xfdI\x14\xc5\xbb\x84S\xd8v1\x96\xef\
\x1cC1\x08\x07,\xdfk\xb2\xf2\xcf\n\x9d\xcd\rl\xd8Y\xe1\x94\xe5b\xd7\x8f\x82\
\xae<7\xbc\xee@\xa3b\xf2\xda\x919N\xcf\x9dC\xc4\x01\x8b\x1bO\x8a\x00v\x92\
\xd7\xad\xde\x800\xcd\xf7\x05\xaf\x9a\x92\x87\xeb\x01\xb7\xef>`iy\x99\xb0\
\xe7\x83\xc8\x8a\x00f\xc1\xc3L\xb1\xde\xdeD\x19\xce\x9e\xe1U[\x93$\x19\x0f\
\x1e\xb5Y^\xb9\xc7\xdaj\x93<)\xdb2+\x84\x08f\x1f,[\x9d\x80$\xc9\xf6\x04wME\'\
\x08\xb9\xf7\xf0\t\xad\xc7\x8f\x18\xf4\xb6@\x0e\xab\x7f\x0c\xae\xc50\x80\xed\
\xe0Q&\xe9\x06\x01z(D;\xc1\x919\xcd\xad\xb1j\x8f\x82Q\xb5O\x83\x93E\xc3\x0cl\
s\xaa\xf9\xdd\x1e\xb9d&\xbcf)\x928\xa1\xb5\xb9E\xbb\xbdA\x18\xf4&\xfa|\x16\
\x9c2\x03\xd3\xe0\x838%\x8c\x92m\xe16\x92\xb0\x1f\xf2\xd8\xef\x10t}\xf2$|Fdv\
\x82\x8f\x02\x98v\xa4\x06\x83\x08e\xb9\x13\xf0\x9a\r\x15r\xfc\xce\x80A\xafK\
\x1c\xf6\xa7\xca\xebn\xe1\x1350\x0e\xefG)Y\xaeFp\xcf\xd2X*\'\xee\x87\xf8a\
\x80L\xe3m\xb5}/\xf0Q\x06\xc6\xe1q\xae\x88\xe2\x14\x9c\x1a\xb85\x1c\x9d\x93&\
\tQ\xdc\x1f}tP\xf0\xa7m8v\x99H2\x89\xb6*`9\x18YB&\xd3\x1d\x8f\xd4\xe7\x85\
\x8f20~\x93\xc9q\xd0\xa6\x84<A\xed\xe2<\xdf\x0f\\\x8b\x14\xb3,\xc2\xbd\xded\
\x0e\x02N\x16\x15\x01\x1c\x16\x9c\xf1\x0c\x1c\x06|\xb4\x05\x87\x05G\xa4\xfc\
\x07\x8a\xed\x03}\xa8\xdcA9\x00\x00\x00\x00IEND\xaeB`\x82'

smile16_png = \
'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\x00\x00\x00\x10\x08\x06\
\x00\x00\x00\x1f\xf3\xffa\x00\x00\x00\x04sBIT\x08\x08\x08\x08|\x08d\x88\x00\
\x00\x02\xa3IDATx\x9ce\x93\xdfkSg\x18\xc7?\xe7WL\x1b\xa2\x07!U\xa9\x89\xe9j\
\x90H\x87\x0cA\x86"\xb2\xf6B\xa1\xe0\x8d\xca\x19.\x88XJ\xa0\xb7R\xbc\x14\xbc\
\xb2\xfb\x03z\x93u\x17\xbb\xdb\x8dcHA\x85\xe4\xa6\xec\x80\x11d\xa3\x9548WMW\
\x10\xd9\xc4\xa2\x89\xc99=\xfdz\xd1D\x83\xbe\xf0\xde\xbc\xcf\xfb\xe1\xf9\xf2\
\xfd>\x0f\xae\xeb\xd2\x7f\xcb\xe5\xb2\n\x85\xcb\xcaf\x0f\xc8\xb6\r9\x8e\xa9\
\\.\xadbqZ\xbe\xef\xeb\xf3\xff&}\xc7\xf3.\xe9\xea\xd5\xf3\x8c\x8d\xfd\xc3\
\xdd\xbb\'i\xb5~\xa0\xd9\xfc\x9e;w\x8e12r\x1f\xcf;\x85\xe7]T?c\xb8\xae\x0b\
\xc0\x89\x13\xdf(\x93\xf9\x9f\xf9\xf9\xf38N\x004\x81w@\x04t\x80g\x84a\x8d\
\x99\x99\x80F\xe3$\xd5\xea\xb2\x01\xec(\xf0\xbcK\xcad\xa0T\xba\x8d\xe3\xe4\
\x81D\x17\xec5k\x03-\x1c\xc7\xa0T\xdaE&\xb3\x84\xe7]\xd8)\xfa\xbe\xaftz\xaf\
\x82\xa0&\xe9\xb9\xa4\x07\x9a\x9d\x9d\x15 \xa9 \xa9 @\xa9TJ\xd2\xa0\xa4\x01\
\x05\x01J\x1fD\xbe\xef\xcb(\x16\xa752\xb2\xc5\x8d\x1b7\x01\x0bx\x82a\x9c\x03\
@*\x00\x9b\xe4\xf3OY]]E\x1a\x04E\xb0e0\xf7c\xc4Z\xa3\x80Y\xa9\xdccrr\x18\xd8\
\x00\x9e\x01\x7f\xf6Y\xd4\x016X__\xef{\xdb\x86\xce \x93\x13I*\x95E\x0c\xc71\
\xd5l^\xc7q\x92@\x9b\xa9\xa9\x97,,\x04\x1f\x8d\x83\xf5\xae\xa1]8\x8a`s\x88\
\xb0m\x918\xd4\xe8\xc5\x18t\x1d\x7f\xcb\xc2B\x08l\x02\xcb@\xbd\x0f\x16h\x8b\
\xaf\x0e\xc6!\x1c\x800\x0e\x80\x99\xcd\x0eS\xaf\xff\x0b\xbc\x02\xea\xe4\xf3\
\x8f\x80\x87\xdd\xce\xfa\x04\x13Bd\xb2\xf6\xf2-\xb4\x92\xd4W\r\xb2\x87R\xd8\
\xe3\xe3gY\\\xfc\x85\xb1\xb1\x18 j5H$D\xb3\xd7\x98m`\x0b"\x83\xe3G\x93\xe8\
\xf90\xb4v\xb3\xf8\xe05\xe3g&z1\x1a\n\x82\x81nL;Q)\x1eW,\x16\x93m[J\xc4m\x1d\
\x1b\xdd+m\x1c\x91j\xa7\x15<\xfeN\xe9\xfd1\xf9Ke\x19\xae\xeb\xe2y\x17\x14E?S\
*\xd9}\x92\x05\xe66\xc4,&\x8e\x0eQ\xfe-\x05\xed$\x84\xbb\x98\xbeY\xc3J~\xcb\
\xaf\xbfW\x8c\xbeQ\xfeZ\x99\xcc\x12\xf3\xf3\xe08=\xf5&\xbc\xdf\x03o\xf6C;I\
\xd8\x8c1s\xebo\x1a\xff\x1d\xa0\xfa\xd7\xda\xa7Q\x06\xa8V\x97\r\xcb\x9abt\
\x14\xe6\xe6`e\x05\xc2\x8eE\xd81Yy\xfa\x8e\xb9\x9f^0z\xee!\xd6\xee\xd3\x1fa\
\x00>_O\xdf\xf7U,^S.\xb7O\x8e\x8d\x1c\x1b\xe5\x0e\x0f\xa98}E\xfe\x1fK_\xac\
\xf3\x07\xc0b=\xfa\xc1x\xb5\x84\x00\x00\x00\x00IEND\xaeB`\x82'

smile32_png = \
'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00 \x00\x00\x00 \x08\x06\x00\
\x00\x00szz\xf4\x00\x00\x00\x04sBIT\x08\x08\x08\x08|\x08d\x88\x00\x00\t\xc0I\
DATx\x9c\xc5\x97il\\\xd5\x15\xc7\x7fo\xde\xbc7\xfbx6\xdb\x93L\xe2\x988\x9b\
\x81\x10H\xd8\n\xa8-\x90PJ\xcb\xee\x90\xb0\x94B(\x08\xa9\xad\xa0\x85\x82J\
\xa5\xaa\x1f\xa0\xa2\xa8,\x95\xba( \x81\x08!\x0b!\x86\x8a\xadI\x03\x05Z\xc2\
\x1ah\x16\x12c\xc7`;\x1e\xc7\x9e}<3\xef\xbd\x99\xb7\xdc~\xb0\xb3\xe1\x80\xaa\
~\xe9\x95\xae\xf4\xf4t\xef\xfd\xff\xee\xb9\xe7\x9c{\x8f\x14\x89D\xf8\x7f6\
\xf7\x7f3h\xcd3\xcf\x8at:\x8d\xaeiH\x92D\xa1P\xa4\xd1h\xa0\xe9\x1a\xd9l\x16\
\xaf\xd7\xcb\t\xed\xed\xa8\xaa\x8am\xdb\x04C!R\xa9\x14\x91H\x84\xe5]WI_\xb7\
\xb6\xf4U\x16X\xfb\xecz\xd1\xdf\xdf\x8fe\x9aD\xa2Q\x12\x89\x04\xa6i\xd2\xbf\
\x7f?\xbb\xf7\xec\xc1\xeb\xf5\x92lM\xb2{\xcfn>\xf9\xf8\x13\x96]\xb4\x8c\x13;\
;\t75!\xcb2\xd9L\x86\\.\x8f\xdb\xedf\xee\xbc\xb9\xfc\xfcgw\x1c\x17\xe4\xb8\
\x16x\xe4\xd1?\x88\xbe\xbe>\x96,^B"\x11G\xd3t,\xcb\xc2\xa8\x1b\xf8|>T\x8f\
\x87P(Dkk+\xc1`\x00\x80\x83\x07\x0f2o\xee\\|>\x1f#\xe94\xd3S)\xe6\xcd\x9fO\
\xb5Z\xe5\xa3\x0f?\xe2\xea\xaek\xc4\xb9\xe7\x9e;\x05\xe4\x18\x80u\xeb7\x8a\
\xdd\xbbv\x91\xcdd\x08\x04\x83\x94\xc7\xcb(\x8aB\xbe\x90\'\x16\x8d100@*\x95\
\xe2\x9co\x9c\x83n\xe8\x94\xcbe>\xeb\xed\xc50\x0c\x06\x07\x06Yz\xe1\x85L\x9b\
6\r\xdb\xb6\xd9\xdf\xd7G\xad\xa6\xe18\x0e\xc5R\x91\xe1\xe1a\x06\x07\x07\xb9\
\xf2\xaa.\xb1r\xe5JV\\\xd3%M\x01x\xe5\x95W\xe8\xee\xeef\xe1\xc2\x85\x94\x8aE\
\xa2\xb1\x18~\xbf\x9f\xcf\xfb\xfbY\xb6\xec"\x92\xc9V*\x95\n\xd1h\x94x<\xcec\
\x8f=FOO\x0f\x99L\x06\xaf\xd7\xcb\xce]\xbb\xb0,\x8bH4J\xa5R\xa5\xbb\xbb\x9bb\
\xa9\xc8\x9c\x8e\x0e2\x99,\x8a\xa2\xa0\xeb:{\xf7\xee="\x1a\x89D\x88D"<\xb7i\
\xb3ho\xef\x10\x1e\xaf_\xdcu\xd7="\xdc\x14\x15\xe7_\xb0T\x84\x9b\xa2Br\xb9\
\xc5\x82\x05\'\x89\xef_z\xb9\x98={\xae\x981c\x96\xb8\xeb\xae{\x84?\x10\x12H\
\xb2@\x92\x85\xe4r\x8b\xef\\|\x89X\xb8p\x91hk;A\x9cz\xeab\x91hn\x15H\xb2\xf0\
\x07B\xe2\xf4\xd3\xcf\x14\x92\xcb-\xce8\xe3,\xd1\xb5|\x85\xd8\xb2u\x9b\x88D"\
G,\xd0\xb3o\x1f\x8dF\x03\xbf\xd7\xcb\xa7\xef\xbeC\x9bdS\xfdl\x1fm\x8a\x0b\
\x11\x8f\xe2\xd3*\x94v\xef\xc4_\xab\xe1\xb7\x1d\xde{\xa1\x9b\xd9.\x17x}\xe4M\
\x93\x8am3\xf0\xe9^\x86GF0\x1c\x1b\xa1\xebx\x05\xc4\x90@\xd3\xe9\xed\xed\xc5\
+\xcb\xe4\xb29Z\x93I\xca\xe5\xf2\xb1Q\xb0a\xe3&\xa1e\xb2\x046>\xcdl*\x04B!\
\xacX+\xdbX\xcc\xe6\xfa)\xb42\xca\xaa\xe6/\x98\xa3\xd4\x10\xba\x81(\x14A\xd3\
\x11\xe9\x0c\xf9L\x8e\xf2h\x81}\xca,^\x9b~6\xfd\xb2\x97\xcer?g\xa5\xdf!\\/\
\x93G\xd0\x87M\xc4\xad0\xe7\xd2K\x98y\xf3\r\\\xff\x83\xeb\x8f\xf5\x81\x95+\
\x96K\xef\xdd\xb4JL\xa3\x8a\x14\x0c E\xa3lu/&y\xe3O\xd9\xf9\x84\x865>H\xcf\
\x80\xc2\xf3\xe7\x17\x898uDS\x18gx\x04a\xda\x04\x1a&=\xbe\x0e\x12\x8f\xaea\
\xc7F0k\xa3\x8cU\x0e0\x16Hr\xe7\xee\xa7\t\xe3\x90@\xa2b9\x94_\xfb;\xd3N>\xe9\
\xb0\x0b\xb8\x0e}ly\xe0A\x91\xd8\xb9\x1d\xc9\xed\xc6\x15\x0c!\xb9=\xbc\xeb\
\xcc\xe2\xb6\'4\x1cK\x03 m\xa8\xechx\x91\x12\t\xa4D\x1c)\x1eC\xf2{q\xc5#t\'\
\xcf\xe7\xce\x8d`\x9b\x06\x00\x02\x89\xde\xd0tz\x02\xcd\xc7\x84\xb8i\x18\x1c\
\xe8\xfe+\x9b7l\x12\x87\x01^x\xbe[$\xb6nAih`9\x08K\x80\xc7K\x8b\xab\x80=>\
\x88\xa3eq\xf4,\xaa\x18\'\x10\x0bL\x00\xf8\xfdH>/\xf8}\x00\xa4j\x038\x954N\
\xa3\x84c\x14q\xac\x1a\xe1\xea\x18Q\xbd0%\xcf\x8c\xf5\xeeg\xfc\xdd\x0f\x8e\
\xe4\x01W\xb1D =\x88p\t$\x1b\xb0\x04X\x82\xe5\x89Q\xfeU\xf8\x80>#\x82\xaah\\\
\xb8\xc8\xcbi\x0b\xe7A~t\xca\xa2]\xe3\x1f\xb0o\x8f\xc5\xfb\xb1ET]n|\xc5^\xbe\
}\xe0\rf:\x16\xd5/\x8dm8.\xd2\xdb\xdef\xf3\xe6\x17\x85\x1b@\x1d\x1cB\xaeV\
\xc0\xe7A\x98\x0e\x92)\x106\xb4\xc8&\xeb\x97\n\x86|\x02Ob&\xb1\x96\x18~\xe1\
\xe0L\x91\x87\x80S\xe7\xb7\xe9\x978\xb0\xe7y\n.\x19\xc7\xd6\xf186\xe3\xc7\
\x19\x8b\xec\xe1`\xdf\x10\x1d\xe9\xf4\x84\x05\x94\\\x0e\xc9\xb4@U\xc0\x14\
\xe0\x00\x15\x1d\x112p\xe9\x1a\xed\x01?\x92\xab\x01\xb9Q\x1c@\xe4r\x08MC\xe8\
\x06h\xfa1k\'\xed\x06A[PEP9\x9e\xf8$\x80a\xb9idr\x93\x00c#XB \x8f\x1b\xa0\
\xd6\xb1\xc7J\xb8$\x15\xf2\x05\x84\xcf;1I\xd3\x0e\xcf\x17\x9a\x86\xc8\xe5\
\x11\xf9\x02B3p\xf2%\x84^\x07\xbd\x8e\x85\xc0\x02\xcc\xc9n\x1fG\x1c\xd9\x83-\
\xfb1\xb2\xa5\xc90\xac\x94\xb1\xea6\xaai\xc1\xd88R\x8bLv\xd8M\x8bW\xc7\x19\
\x1eA\xd2\x8d\t\x87;\x04\xa0\x1b\x88|a"\x0f\xe4K\xa0\x19\x88B\x05\xa17\xb0\
\x01\x0b\x81\x89\x00\xc0\xc1M\x81\x16`\x18\x1b0\xd50\xb6\xac`\xca^*\xe9\xe2\
\x04\x80\xddp\xb0\x1c\x81\xd1\xb0\xf1Z\x06\xaf\x0e\\\xc0j\xee\xe4\xba\xec\
\x0b\\\xb7\xe8\x8d\t\xa1Io\x9f\xb0\x86\x8e\xd0\x0cD\xbe4\xd1\x0b\x15\xd0\xeb\
\x18\x08L\xc0\x9a\xdc\xb9\x8e`\xb5\xfbe\xf4x\x8a\xc5c\xf7\x92P\xdf\xc4\x94=\
\xd8j\x18I\xf6#$e\x02\xa0\xde\x9c\xc4\xb0l\x84-\x90\xab\x06#R3\x9a\x12d}\xe1\
\n\x96|\xf6!\xf3\xdb\xb2\x90/\x1dcI\xe7\xe8\x9d\x17\xc61\xf5\x06\x06\x1c\x86\
0\x81\xb7\xb8\x9d\x9c\xa7\x13\xbf\xa8RqM\'"{\xb0\xd5\xd0\xc41\xa8\x01\x02\
\xd3&\xef\x02+\x1cA\xb7\x04.\xcb\xa1n;\x84\x19\xc3\xed3\xc9\x97\x9a\xb9\xd3z\
\x88K3/qk\xcbjd\xe9\xc8\x89\n\xbd~x\xe7\xa6\xde\xa0>y\xf6:0F\x0bkx\x88\x81\
\xe07\xa9\xd5\x82$[FH\x16\xdf\xc5RC\xd8\xb2\x8a\xa34!\x84\x89\xaf9<\t0k\x06\
\x86\xac ;:\x02X\xc0[\xb8\x95\xbb\xf1x\x0cf\xcd\xfa\x82\x97\xd3\x97\xb0\xe5\
\xe02f\xd4\x078\xd1\xda\xc5\x12e;\x91\xc6(\xed\xf5\x0cu\x04=\x9c\xc4\x10\x1d\
\xec\xe1lz\xbdgR\xf2\xa4@\x92\x08\xfbJ4\x85\x8b\xa8\x8a\x8e\xdb\x93\xc7\x90C\
8J\x13\xa6\xec!\xe0\xb1\xf1\xb7\xa7&\x00\xc4\xcc\x14F \x84S\xaa\xd1\x00b|N\
\xdc\x9f\xa5\xaa\x86\x98?g\x1fw\xff\xf8\x01^\xddv9;\xfe}&\xaf\x16\xaf\xe2U\
\xae\xc6\x96\xdc\xb8\x03\r\x00l[\xc1%\xdbH.\x87d\xf3(\xdf=g\r\x0b;w\xf2\xc4\
\x9a\x9f`\xd4\xbd\xa4\xa4\xedXj\x88\x86\x1a\xc2V\xc3\x085\xc4\xf4y\x01V\xdc\
\xbaJr\x03\\u\xcbM\xd2\xa6s\x96\nkh\x04\x81\x04\xd8,\x93\x9ed\x9dq\x1f\xdb\
\xdf?\x0f\x10\xdc\xf6\xc3?r\xfb\xcd\x8fQ,\xc6)\x14\x13\x0c\x0e\xb7c\x9a\n\
\x00\x01\x7f\x8d\xb6\x19\x03\x84\x82\xe3$\xe2YF3\xd3x\xf8O\xf71^\t\xa2*\x16\
\xb1\xe2\x0645\x8c\xa3\x84\xb1d\x0f\x8a\xc7\xcf\x8c\xf3N\x86\xb7\x8f\xba\r]\
\x97]\x8c\xf1\xe1\'\x98\xb9<&p\xca\x81\xa7\xd9\x92\\\x05\xaa\xcc\xaeOO\xe3W\
\xf7?\xcc\xcd\xd7=\xce\x89\x0bv3}Z\x9a\x93O\xdc9%\xbf\xd4\xb4\x00o\xfc\xf3"\
\x9e\xd9\xb8\x8aHS\x89\xf1j\x84\x94\xb4\x85\xba\x00\xc7\xe5\xc1T\xc38j\x88T\
\xab\x9b\xd8\xe29\xc0\x97^\xc5\xeb/\xbdF\xe8\xeb\x9eCq@\x06*t\xf0Lj-\x86\xe3\
\'\x16)ppl:\x1d\xed\xfb\xb9\xec\xe2\xcd\xcc\x99\xddK"\x9e\x01 \x93M\xb2c\xd7\
\x19\xbc\xfe\xe6\xc5\x0c\xa5\xdb\xe9h\xefc\xff\xc0\\Z\x03\xbd\xcc5~\x8d\xa3z\
h\xa8a\x1a\xbe\x042\x06\xe7\xafZ\xc2-\xf7\xffr\xea\x9bP]~9\xc6\xde\x1e\xf4\
\x8fw\xe2\x06\xfc\xf4\xb3"\xdd\xc5\xdf\xda\xffL\xdf\xd0\xa9\x9c\xbap\x07~\
\x9f\xc6\xd3\x1b~D\xb9\xdaD"\x9a\x03\xa0<\x1e\xa1)\\\xa2m\xc6\x00\xa6\xa5\
\xb0\xff\x8by\xcc\x0e\xbd\xcet\xfd\xf1\xc3\xe2\x96\x1aB\x92\x15\xe6w*DN\xeb<\
\xac9\xa5.x\xeew\x8f\x88\xdco\x1e\xc4\x1c\x1dC\x99$4\xf1\xf1R`5\xe3\xb1N*\
\xb5&Z\x9b\xc7hI\x1c\xa4m\xe6 \x00C\x07N\xe0\xf3\xc1\xd9\xd4\xf4 !_\x89P\xf1\
\x1ft\xf8\xd7b*\xe1\xc3\xe2\x96\x1a\xa0-^\xe7\xac{\xaf\xa4\xeb\xdak\xa4\xaf\
\x04\x00Xw\xc7/\xc4\xe8\xea\xa7h\x8ceP\x8e\xfa\xdf \xc0`\xe2Z\x06\x03\xdfc\
\xac:\x1b\x07\x19\x00\xb7\xabA\xab\xaf\x87&\xed-\xe2\xce\xdb4\xd4 \x8e\xeb\
\xc8\xce-\x97\xcc\xccf\x87\xd3\xef\xb8\x8c\x95\xb7\xdcpL]\xf0\x95\x95\xd1\
\xc6\x07\x7f/F\xff\xf2$\xa5O\xf7"\xec)W\n0\x91n\x1bj\x08K\xf6`\xa9!L\xd9CC\
\x9d\x8cu5\x8c\xa5\x06q\x99e\xe6\xceS\xe9\xbc\xe5\nV\xac\xbaqJu\xf4\x95\x00\
\x00\xcf\xaf]\'\xc6_\xdb\xc6\xe8+[)\x1d8\x80\xe3\x1c\x05"Ox\xb59\x99^\x0fe8[\
\x9d\x085YQ\x88\x055\xe6_0\x9f\x96\xa5\xe7q\xf5\xf2\xab\x8f[\x9a}-\xc0\xa1\
\xb6\xe9\xa95\xa2\xb4\xf5\r2\xdb\xdf\xa7:\x96\xa3VkP\xb7\x04\xb6\xdb\x87\xad\
\x04AV\x10J\x08\xb7\xea\xc2\xe7s\x13\x9b\x91$\xf5\xadE\xc4\x96,8\xe6\xbc\xff\
g\x80Cm\xf3\xe6\x17\x85S.S\x1f\x1a\xa6\xba\xef3L}"\x13:\xc2A\x89F\x89\x9e~\n\
J<N\xd7\xf5+\xbfV\xf4\xe8\xf6\x1f\xef}\x9b\xb7\xd0cu}\x00\x00\x00\x00IEND\
\xaeB`\x82'

smile48_png = \
'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\x00\x000\x08\x06\x00\
\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\x08|\x08d\x88\x00\x00\
\x0c4IDATx\x9c\xed\x99{\x8c]\xc5}\xc7?3\xe7}\xef=\xf7\xe1\xbb\xde\x97\xd7\
\xbb`{\xc1\x0b\xb10\xc6(\x01\xb2n\xa9 Ai"\x82[\x05E$\xfc\x83\x10Hi\xa5(j\xd4\
H\x95\x9a\xaa\xad\x10i\xffI\x9b\xaaJj(\x15(~cC\xc2#H\x01c\x8ay8\xc5\xbb\xe0\
\xf7zm\xaf\xd7\xbb\xeb}\xde\xdd\xfb\xbe\xf7\xbc\xa6\x7f\xec\x82\x85H\xbb\xbb\
\xbe+\xa1J\x1di\xa4\xa393\xe7\xf7\xfd\x9e\xdfc~3?\x91N\xa7\xf9\xbf\xdc\xe4\
\xe7\r\xa0\xd1\xf6\xff\x04>\xef\xa6\xaf\xf4\x07\xf7\xefyF\xd5\xf2g\xa9\x15\
\x06\x11\xc1,Am\x14+\xd1\x81\xe1\xac\xc1L\xde\x88\x11\xdf\xc07\xb7\x7fK\xac\
\x94<\xb1RN|\xe0\xf9\xdd*w\xf9u.\x9d\xd8CX\x1b\'a{\xd8\x16d\xdc\x85\tJ \x8d\
\x18V\xeafd\xf6~\xcc\xf4\xed+BdE\x08\x1cx~\xb7:q\xf8o\x99\xbc\xfc;\x1c\xd3\'\
\xe3\xce\x03O\xbb\xe0X`\x9bW\xe7\xd6<\xa8\xf96\xa1\xfb\x87\xc4\xaf\xffA\xc3$\
V\xc4\x84.\x1d\x7f\x8eK\x83G\x89Y\xc1\'\xe0\xdb\x9a\xe6\x81g\xdc\xcf\x12\x98\
-\xd6\xa8\xd5\xdf\xc0\x9f\xd9\xd4\xb0\xec\x86\x9dx\xc7?\x7f_\xf5\xbd\xf7\x02\
\x9a\x9c\x07o[\xf3\x7f\xde6\xa1-\x0b\xd9\x14\xc4\x9d\xab=\x9b\x9a\x1f\xb7\r\
\x0fr\x078\xb0\xe7\x17\xeas%p\xee\xc3\x17\xf1je,\xe3\xea\x1fw\x16l?\xee\xfc\
\xfe5qg\xfe\xbd\xee_ *\x1emH~C\x04\xf6\xef}VM\x8c_\xfe\xcc\xb8m~\xdal~_\xb3M\
p,EX9\xd7\x08\x84\xc6\x08\xa8(\xc4\xf3\xfc\x86\x00(\x7f\xb6\xa1\xf5\r\x11\
\x98\x9d:G>_n\x08@!7\xc4\xf3\xfb~y\xcd~\xd0P\x14:=0N\xad\x1ea\xe8P\xaeA\xbe\
\x0cRB\xa9\n\xd3ypcW\xe7\xda\xb6\x8dm\xdb\xe8\x9aF\x10\x86\x9c\x1f\xf18>Pa\
\xf0\xca4_i\x99\xbcf\x0c\xd7L\xe0\xc5\xfd\xff\xa1\x9e\xfe\xc5\xbfp\xe0p\x04\
\x80e\x82\xa1\xfd\xcf\xf3{z\xae\xa7\xb7\xb7\x97m\x7f\xb0\x8d\xb7\xdey\x8bCo\
\xbeM\xdf\x87\xa7\xd0\xb4:\xb7\xf6\x9e\xe4\xd7/\xeeR\xdf\xb8\xff\xdb\xcb\xde\
\x13\xae\xc9\x84\x9e\xfd\xa7\xef\xaa\x96\xdaO\xd9\xbc\xee\x12=\xeb\xe2$b:\
\x86\xa1\x834P\x18\x94\xaa|\xa6W\xea\x92\xd1\xf1<o\x1cz\x97\x89\xa9<\x9af\
\x90LX|q\xf3\x1a6\xb6\x0e\xb3V\x7f\x81}O\xff\xd9\xb2Mi\xd9\x1ax\xf6\xa9\x7fW\
\xa3\xa7\xf7\xf0\x9fo\x0c\xd2\xda$x\xf8\x8f\x93\x94k\x82\xe6&\x87d\xc2! \xc6\
\xe8T\x80mY\x98\x96\x85\x94&R\xea(i\x92J%X\xdf\xa1\x90!\xe4\xf3-\xcc\xe4\x12\
\xe8\x94\x19\x1e\xec\xe7\xc3~\x8d\xd6u\xbd\xcb\x85\xb3<\x02;\x9f{Ni~\xc8\x8d\
\x9b\xbfKP\xedd\xf0\xa3~\x08s\xe8\xa2\xce\xc8\xa8B7\x02\x1cw\x06KJt\xbd\x82\
\xd0\x04RJ4MC\x97\x82`f\x88\x81s\x1a\xb99\x9b \x84z\x18Q*8\xf85\x87P\x18l\
\xb8\xe5\x0e`\xef\xb2\x08,9\x17\xda\xb7w\xaf\xcaOL\xb2*\xbd\x8a\xd3\xc7\x8eq\
\xea\xdd\xf7@\x85\x84\xf5*A\xad\x8a\n|\xd2\xe9$J)\x04\x1aa\xf4\xf1J\tRC\n\
\x81\xd4@\x13\x12t\x89\x10\x82H\x80PP+\x97)\xe5\x8b(\xdbf\xfb\x0f\xbe\xcfw\
\x1eyd\xc9\xbe\xb0d\x1f\x98\x19\x1f\'\x1eO0|\xfe"}\xef\xbcK\x14}\x82\x10!%\
\xba\xae\xa3\xe9:\x86i"u\x1d\xa9ih\x0bc\x9a\xbe\xf0\xaci\xc8\x85\xae-\xbc\
\x97\x9aF\xdcu1-\x93\xcaL\x8eC{\xf7\xf1\xc2\xc1\x83K\xf6\x85%\x99\xd0\xb3\
\xcf<\xa3T\xbdN\xa5T\xe2\x9d\xd7\x0fQ\xcc\x17\x88[&R(\xa4RX\x96\x85!%BjD(4MC\
H1\xaf\r\xa1\x81\x94H!\xf1B\x0fG\xd7@\x93H!@\n\x84\x04\xa1\x14\xa9t\x860TL\
\x9f\xbf\xc8\xc0\xf1\xe3K\xc5\xbf4\r\x94f\xa6\x11\x08~\xfb\xf2\xcb\\\x1c8\
\x87R\n?\x0c\x18\x99\x9be \x97\xe3\\\xbe@\xce0xu`\x90\xdf\x9c9G$%\x8e\xe3\
\x10O$\xb0c\x0e\x96ms\xa5T\xe0W\'\x8eslr\x82\t\xcf\xa3\x7ft\x94\xf7/\\`\xa2P\
\x00)\x89\xbb\t\xda\xdbZ\x11Jq\xe4W\xbf^\xb2\x16\x16\xd5\xc0\xfe={Tqr\x82\
\xc2\xec\x0cC\xa7\xcf"\x80\x9a\xefs|r\x8c\xf3\xa3#x\x9e\x07\x80a\x18\xf8\xbe\
\xcf\x9d\xb7\xdf\x8eeZ\x08)A\xcc;q\xa4 \xb5*\xcb\xf8\x7f\x1d\xe5\xfc\xc8\x08\
\xba\xae\xe3\xfb>B\x08R\xae\xcb\xd6\xeen\xfeh\xe3M\x18\x9a\x8ea\x1a\xe4\xa6\
\xa68\xf2\xe6\x9bK\xc1\xbf\xb8\x06\xfcj\x05\x15\xf8L\x8e]\x01\xa50M\x93+\x95\
"g\x86.\x12\x04\x01\xb1X\x82\xf6\xf6N\x92\xc9\x0cn\xc2\xa5;\xe5\x12\x85\xc1<\
\xf8\x05[\x97R\x92\xd2u\xba;:\xb0m\x87\xa6l\x0bm\xad\x1d\x98\xa6\xc5\\\xa1\
\xc0\x91\x93\'\x99\xacV\x90RbY\x16A\xdd\xe7\xec\xb1\xbe%\x11XT\x03~\xa5\x8c\
\nCf\'\'H\xc4\xe3\x08\xa5\xd1\x1c\xe9\xdc\xb5\xf5\x0e\xe2\xc9\x0c1\xc3\xc4\
\xb4l\x94\n)\xcd\xcd\xe2\x196\xc5P\x91\xf9\xf8\x03B\x12\x112^\xf1\xf8\xd2\
\xedw\xd3{\xa7A(utM\x92\x9b\x9dfrf\n+\xac\xd1\x92J#\x95"\x16\x8b\xa3P\xcc\
\x8e\x8f\xb3c\xc7\x0e\xf5\xe8\xa3\x8f\xfe\xaf\x11iQ\x02\x91\xef\xa3K\x81\xa5\
i\xb8\x89\x04U?\xc2p\xb2\xac5tz\xd6v\xa1\x87ut)\x90*\xc2\xbc\xa1\x9b\x81\x91\
\x11N\x8f\\fu\xa9\xc2\xe0\xe8%R\xf1\x04\xa9\xd5\x1d\xac\xbd~#=\x9d\x9d8""\
\xf0\xabH)\t\xda\xb3\xcc\xd5\xd630:\xc6D\xbdF\x97\xa3\x93t\x13h\xa6I\x04\x0c\
\r\r-\xaa\x81\xc5\x9d8\x08\x88\x82\x00\xbfRf$_`Z\t\x0c)\xd9\xb4~#\xa1W\xa5^)\
P\xc9O\x13\xd6\xab\xe0\xd7\xd9r\xd3\x17\xb8\xed\xe6[\x98\xae\xd7\x19\x99\x99\
f\xacP\xa0s\xfdM\xdcy\xcbVb\xa6N\xe8W\x89\xc2:^%O\xe0UH\xdb\x06[\xbao`\xba\
\x1epdd\x9c\xa9j\x15\xcb4\x91J\xe1\xd5j\x8d\x13\x88\xc2\x90Z\xb5\xc2\xdc\\\
\x8e\xa0^\xe5\xe2\xa5A6\xae\xef\x99\x0f\x83JQ\xafU\xf1}\x8fz\xbdB\x18\x05DQ\
\x84\x1bO20t\x91G\xbe\xfe\x15\xdc\x98\xc5\xf1\x93\x1f0W\xcc\xcf\xef\x13\x86\
\x85&@j\x12\x15\x85h\x9a$\x93L\xd2\xde\xdcFan\x1a\xd7q\xf0\xc3\x10/\x08>\xb5\
\xd7\\3\x01?\x8c\xa8\xd7j8v\x8c\x94&\x88\xbc:\x02\x85\x14\xf3\xf1[\xd7-\x14\
\x02\xa5\xe9\xd4\xbd\x80\xc1\x8b\x83\xec\xd8\xf5o\xacJX|\xe7\xeb\xf7\xf2\xbd\
\x07\xefg\xf8\xf2\x00O\xef\xfcW\xaa\xb5\n\x9a\xa1a;1\x0c\xcb\xc4t\x1c\x84\
\x9cwt\x85\xa2\xbb\xbd\x8d\x98m3[.\x11\x08\xd0\xf4\xc5\xb7\xa9E\th\x96E\xe0\
\x05\xd8\x8eC\xd6qp\r\x8d\xbe\x8f\x8eb[6\xae\x9b\xc6\x89\'HfZ\x88\xb9\xab\
\x98\xadz\xec\xf9\xcd\x8b\xdc\xb7\xf9F^z\xf2\xafX\xd7\xd5\xc9\xb7\xff\xf4\
\x9b\x1c\xfc\xc7\xbf!\xa6G\xbcz\xe8%\x94n\x10\xe9\x06\xba\xe3b\xdb\t\x9c\xb8\
K\xc9\xf3\xe8;\xfe\x01m-\xcdxB\xa1t\r\xa5\xeb\xf3\xa1\xb8Q\x02F,\x06J\xcd\
\xc7v"\xbe\xd0\xd2\xcc\x85\x0b\x03|p\xb2\x0faX\xa4\xb2m\xb8\xd9V\x8cx\x86\
\xd7\xdf=DO{\x13\x7f\xff\xf0\x9f\xd0\x94r!\xf0Q\x85<\xdd\xed-\xfc\xc3c\x0fs\
\xf4\xc3~^{\xfb0N2K<\xb5\x9ax\xa6\x99\xc8\xb0x\xff\xa3>\xdaR\x0em-\xcd\xcc\
\x14\x0bxa\x880\x8cE\xc1\xc3\x12\xa2\x90\x93L\xe2y>RH\x0c\xc3 )%[\xdb[8}\xf2\
\x18\xfd\'\xfbi\xce\xaefMK\x1b\xa3\x93cL\xccL\xd2\xeev\xa0+\x05\xb5\n\x9f\
\xdaJ\xbd\x1aQ\x14\xf1\xde\x07\xefs\xfdu\x1b0\x0c\x83\xf1\x99\x19fg\'ivmn\
\xdd\xba\x05\x84`fnv>\x1d\x89\xc7\xd0\x97`B\x8b\xce0l\x07a\x9aD*$\x1eOP*\x14\
I\xd86w\\\xd7E\xd1\xf7\x89\x00Y\xce\xb1&n3\x9eH\xf0\xf6\xd9\x0b\xfc\xc5S\xbb\
\xf8\xde7\xeee\xdd\x9aV\xaa\x9eO\xdf\xf9K\xfc\xdd\xae\x17\x11(\xb6\xf6t#j\
\xd3\x10\xeat\xad\xb2\xb9\xa3g\x0b\x9a\xd4(\x97\xcb\xcc\xe4r\x8cNN\xa2[6\xd2\
\xb2\xe9\xec\xecl\x9c\xc0\x03\xdb\xb7\x8b\xa7~\xf635~\xfe<\x86\x13C+/\x1c\
\xe2\x85 \x1d\x8b\xa1\x1b\x06\xbaa\xa0\xe9:\xa5 `*_\xe0\x95c\'x\xa5\xef\x14m\
\x99$\xd5\xba\xc7\x95\xb9"\xa6\xaeQ\x0b\x15]\x9d\x9dt\xb4\xb6b\xda\x16\xb6ec\
\xd9\x16\xbe\x1f\xe0\xf9>G\xfb\xfa(U\xabd\xd7\xac\xa5\xb3\xb3\x93\xc7\x1e{l\
\xd1\xb4zI\xd9hv\xcd\x1a\xccl\x96\xd9\xa9I\x84n@\x14"\xa4\xbc\xda\x17r\x9e\
\xee\xd6V&K\xdd\xbc\x7f\xe2\x04\xba\x80\\\xa9\x8c@\xa0P(-\xc6\x83\xf7\xdd\
\xcb\xf5m\xad(\x14\x9eWG\xd3t,a#\xa4\xe0\xf4\xc0Y\x06\x87/\xe3\xc4\xe3\x98n\
\x82\xeb\xae\xbbn)\xd0\x96~\xa0yf\xc7\x0eux\xdf^\xaaS\xd3\x18BbY\xe6\xfcIkA\
\x03\x1fk\xc1\x0fC\x86\xa6\xa6\x98,\x95\x98+\x97I\xc4b\xb465\xd1\xd5\xdcD{\
\xf3jL\xd3@\x01a\x14\xe28q\xdc\x94\xcb\xc8\xe5\xcb\xec\x7f\xe9U\xca\xf5:M\
\x1dkY\xb7\xb1\x87\x9d;w.\xe9P\xb3\xac\xdb\xe9\x9f\xfe\xe4\'\xea\xd0\x9e\xdd\
\xa8r\x95t2\x89m\x99\xf3\xe0u\x1d\xdd41\x0c\x830\x8a\x08\x95B\xd3u,\xcb\xc24\
M\x0c\xcbBHP(L\xcb$\x8a"\xbc\xc0\xc7\xb2\x1dj\xb5*\x87\xdf?\xca\xe5+\xe3\xa4\
V\xb7`\xa53<\xf4\xd0C<\xfe\xf8\xe3K"\xb0\xac3q\xd7\r7p\xeb=\xf7p\xec\xb7\xaf\
3\x91\x9b!f\x98\xb8\xaeK<\x11Gj\x1a\xb50D3\x0c\xcc\x05\x8d\x08!\x88\x94\xc2\
\xab\xd7\x91\xba$\x0c|\x84\x8a0-\x13\x82\x90\xbe\xbe~>\x1c8\x8b\x1fF\xacji\
\xc5H\xa7\xe9\xed\xed]2x\xb8\x86\xfa\xc0\xc1\x03\x07\xd4\xe0\xa9S\xbc\xf9\
\xc2\x0b\x14FGqL\x93\xe6\xa6&\xd2\xe9\x0cB\x93W\xcdI\xd3\xd0\x16HH)\x91R\x00\
\x11(\xc5L.G\xff\x993\x8c\xcf\xcd\xa1\x9b&\xa9\xd66\x0c7\xc9]w}\x99\'\x9f|rY\
wC\xd7\\\xe0\xd8\xf1\xf3\x9f\xab\xc3\x07\x0f2|\xea\x14\xa6\xd4\x16\xec? \x99\
L\x92M\xa7q\x1c\x07\xc30PBP\xad\xd5\xa8T\xca\xe4\xf3s\\\xc9\xcdP*\x14\t4\r7\
\x9d\xc6iiEZ6\xbd\xbd\xbd<\xf1\xc4\x13\xcb\xbe\xd8j\xa8B\xf3\xfc\xfe\xfdjx\
\xe0\x1c\xaf\xec\xdc\x89\x0c|.\x0c\x0e2\xedy\xb4$\x93$]\x17MJ\xbc \xa0\xe6yx\
\xbe\x87\xeb8\x9c\x19\x1d\xe3\xb6u\xeb\x18\x1e\x1e&\xb3i\x137\xddr\x0b\xdb\
\xb6m[\x96\xd9\xac\x18\x81\x8f\xdb=\xb7\xdd\xa6:\xae\\\xe1G\x99\x0c\x87-\x8b\
]\xc5"\xd3\xc3\xc3T,\x8b \x08\xd04\x8dD\xb9\xcc\xb6\xaf}\x8d\xf5o\xbd\xc5\
\xed\xad\xad<44\xc4\xcdw\xdd\xc5\xab\x87\x0e5TbZ\x912\xab\x93JQT\x8a\xec\xd0\
\x10\xdf\x12\x82\xbfv]\xc6\xcbe\xb4L\x06\'\x95\xc27M\x92\x1b6\xf0h\xb1\xc8\
\xc3--\xac\x8a\xc7\t\x95b\xd3\x96-\r\xcb^\x91\x1a\xd9\x8d\x9b61\xecy\xd4\x86\
\x86\x90A@\xe2\xd2%\xc2Z\r16\xc6\xadMM\xbc^(\x90\xae\xd7\xf1\x84\xa0R.3U\xab\
\x91jo\xa7\xad\xa3\xa3a\xd9+\xa2\x81\xb6\xceN\xc6fg\x99\xeb\xea"\xd6\xd6F{S\
\x13\xc9\xd5\xab\x19*\x958\x92\xcb\xa1\x0c\x83T"\xc1\x86X\x8cX{;\x17\x85\xa0\
\\,\x92\xcdf\x1b\x96\xbdb\x85\xee\xcbccT\xebu\x82J\x85\x1f\x9d?\xcfd\x18\xf2\
\xe7?\xfc!\xed]]\xfc\xee\x8d78\xd6\xd7\xc7\x91\xe1a\xbe\xb4y3^\xb1H87\xb7\
\xa4ls\xb1\xb6"\x04b\xb1\x181\xc7\xe1e\xc3`(\x97\xe3\xadL\x86\x07\xbf\xfaU\
\xbe|\xf7\xdd<\xf0\xc0\x03b\xf7\xee\xdd\xaaX(\xf0\xf0\xe1\xc3<25\xc5P\x14\
\xd1\x12\x8baYV\xc3\xb2W$\n\x1d<xP\xbd\xf7\xdak\x9c9s\x06]\x08\xbex\xcf=l\
\xe8\xe9a\xfb\xf6\xed\x9fD\x98}\xfb\xf6\xa9\x93\xfd\xfd\xbc\xf9\xca+\xd8\xb6\
\xcd\xdd\xf7\xdd\xc7_\xfe\xf8\xc7\rW\xea\xff\x1b\xd5\xe8\x0b\x01\xe7z\x82m\
\x00\x00\x00\x00IEND\xaeB`\x82'

up_png = \
'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00 \x00\x00\x00 \x08\x06\x00\
\x00\x00szz\xf4\x00\x00\x00\x04sBIT\x08\x08\x08\x08|\x08d\x88\x00\x00\x04\
\x03IDATx\x9c\xc5\xd7\xcdo\xdbd\x1c\xc0\xf1\xaf\x1d\xbb1v\xd2\xae\xac\x1b\
\xd36\x10\x1b &!\x90V4\x06H\x1c&n\x08\xf1\x0f \xe0\xca\x15\x0e\xfb/8#.\x88\
\x0bB\\&M\x88\x0b\x87ich\x0c!\x0e\x83\xb2\xc2\xd6\xb1\xf5}I\xd3.m\x12\xe7\
\xf1\xe3\xe7\x85\x83\x9b\xbe\x904q\xb2\x03\xa7\xc4y\xfc\xf8c\xe7y~/v\xbe\x9b\
m\xd9WO\x86$\x1a\xda\n\xa4\x86D\x834\x90l\x1fK\x93\xfd\x16\xa7\x90n\x8fw\xce\
\xe9\x1c\x0b\x95\x8dw\xc6\x84\xde\xbe\x96\xca\xbew\xe6w\xce\xed8\xae\xb1\xf6\
\x7f\xc3\xb3\x1b0\x8f\x87ol\xc5\xfc}\xef\xc1H8Z\xe2Jm\x1f\xeb\xc9\xff\x98\
\xf9\x93\x9b?\\\xa2)\xe4\xd08*\xc15vt\xbc)4\xf7f~\xa3\xb1\xb6\xcc\xd2\xf2\
\xca\xd0\xb8U\t\xae6\xa3\xaf\xf9j\xb5F\xbd\xb2\x80q\n,\xcc\xfd54\x8e\x8c\xb7\
7\xe1\x88\x1bn\xee\xce,Jk\x9c\xb1\x88\xfa\xda*\xf5Fk(\x1c-q\x95\x19\r\xdfj\t\
V\xfe\xb9\x8d\xe3\x87\x10\x8c#\x95fm\xad:\x14n\xb3=`G\n\xb5\xc5\xa5E\xda\x8d\
:\x04\xe3P,\xe3\x04\xe3<\xaao"R\x93\x1bG%\xb8\xca\x8e\x10\xe7\xca\xb207\x8b\
\xf5\x9e\xd8\xc1\x9dh\n\xa9\x0c\x8dv\x92\x1bG\xcb,\x0f\x0c\x9bd66\x1b4\x1e\
\xad\xef\xc3)\x96\xb1~H[\xc8\xdc8*\xc1K\x8d\xc5\x1b\x02\x97\x1aV\x96\x16\x91\
J\xef\xc3\x9d\xa0\x0c\xc18\n\x0f\x9b\x13G%\xb8\xd6\x0c\x87\xc7BQ]Y\xe8\x89;\
\xc52v,\xc2C\xe5\xc2\xad\x96\xb8j\xbb\x16\xe4\xcd\xed\xd5Z\r!DO\x9cb\x99\xc8\
\x87\xc8w@\xc9\x8182\xdeMDy\x0bKm\xad\x82-N\x1c\x88\x87>L\x85.\x91\xa7\x07\
\xe2\xa8\x04W\xdb\xfcx#\x164c\xd1\x17?T\x84R\xd1a\xaa\\\x1c\x88\xef\xe4\x81\
\xbc%u}c\x93\xd4\x16\xfa\xe2\xa1\x0f\x91\x0f\xc7\'C\x82\x82\xed\x8b\xa3e\xb6\
\x04y\xf0\x964l5\xb6p\x8a\xa5\x81x\xe8\xc1\x91\xb2\xc7\xb1\'\xcb}\xf1l\t\x8c\
\xcd\xd5L4[\x02\xa9\xc9\x85G>\x94|\x87\x17OLR\xb0\xea@\x1c\x95\xe0\xeeM@\xfd\
\xeay3nc\xc7\xa2\\xg\xec\xf4\xd1\x88\xa3\x93\xa5\x03\xf1\x9d\x7f`\x10\xdeN4"\
5C\xe1\x91\x0f\xc7J\x05\xa6_8q n\xb5\xcc\xa2`P\'\x13\')\xc6\x0b\x86\xc2\x0f\
\x15\xb3\xcf\xe9\xd3SLDAO\x1c\x19\xe3*c\x07w2\x86\xbex\xe8\xdb\x9ex\xe4\xc3\
\xa9\xc3E^9s\xaa\'\xbe\xdb\x92\xf5\xc1\x852\x98B\xd0\x13\x1fs\x0c\x0fk\x1b\
\xcc\xcc-\xd1l\xc5]x\xe8\xc3D\xd1\xe1\xed\xb3\xcf\xe1;\xa6;\x1at\x82\xa7\x8c\
\xed\xdbFI\xe3v\xe1\xa1\x07B\xb4\xb9\xbb\xfc\x90j\xb5\x8aM\x05\xab\x8b\xf3\
\x9c=\xf3\x0c\x17^:N\x14z\x84>\x94\xb6\xe7\xbdvj\x82\xe7\x9f}\x9a\xdb3\xb7\
\xf6\xe1Y?`\x0e\xc6\x13\rA\xc1\xee\xc3}4+\x95\x1a\xb7n\xdf\xa5R\xa9`S\x01*\
\xa1\xd9\xa8\xf3\xd3\x8d\x9b|y\xf9*\xbf?\xa8\xe1\xbbv\xcffty\xef\xc2\xb9.\
\x1c\xb5\xa7\x1f\xe8\x85\x17\xac\xa24\x96\xe1A\xc1\xd2n\xb5\x98\xbd\xb7\xc0\
\xfd\xf9\x05R\x11w\xad\xa9M\x13\x16\xe7\x1f\xf0\xc5\xd7\x97\xf8\xfc\xf2/\xac\
\xd6Ev\xf3\x01\xbc;}\x92\xa7\x8e\x1c\xde\x87gy\xc0\xd8\x9e8Z\x12z\x96\xc9\
\xc0\xc15)\xcb\x955\xee\xdc\x9f\xa7\xb1\xf9h`zU\xa2\xc5\xb5kW\xb9\xf8\xd9W|{\
\xe3>\xad\xc4\xf0\xf21\x9f\x0bo\xbd\xb9\x0fG\'8\xef\x7fS\xb1?\xd6\x8fv\xe1\
\x05#9>\x19\xa0D\x9b\xda\xfa\x06I\xbb9\xb0\xb0\xf4\n5\'\x15\x9c?7\xcd\xa7\
\x1f\xbc\x83\xd6\x86\x0f?\xfe\x04\xd9\xda\x04\x9d\xcd\xf1\xb4\xb5={8l\xcaz-&\
nma\xd2\xc1U\xed\xa08\xb7*\xe1\xe7\xebW\xf8\xe8\xd7\xeb\xbc~\xfe\r|\x17\xa4\
\xdemV<m\xbaq\xab\x12\x94\x8cQ9\xeay?|\xef\x86\x8b\xeb\r\xae|\x7fi\xe7\xc9w\
\xdf\x0bl\xfe\x06rT|\xef\x9a\xff\xf7\xfa\xff\x02\x1b\x95\x05yYu\xd8\x0c\x00\
\x00\x00\x00IEND\xaeB`\x82'


tick_png = \
'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00 \x00\x00\x00 \x08\x06\x00\
\x00\x00szz\xf4\x00\x00\x00\x04sBIT\x08\x08\x08\x08|\x08d\x88\x00\x00\x03\
\x02IDATx\x9c\xe5\x97?HzQ\x14\xc7\xbf\xf7\xf6\x93\x1e\x0f\xc4G\x7f\x96\x86\
\x04\xdb\x0b\x1c\x9a\xda\x83\x94H\xa1(!\x90\x8c\x0c\x87 r\x89p\n\xc1\xc9%\
\x08\x8apI4\xa8\x1e\x91$\xe5\xd0\xd4\x14\x15A A\x04\r.\x12TC\x96\x10t~\x93\
\xef\xa7\xe9\xf5O\xbfg\x0e\x1d\xb8\xf0x\xf7\x9c\xf3\xf9r\xee\xb9\xf7\xdd\xc7\
\x14EA+\x8d\xb7\x94\xde\n\x01\xc1`\x90\x86\x87\x87imm\x8d\x00\xe0\xcfO\x81#\
\x91\x08\xed\xed\xed!\x10\x08\xe0\xe9\xe9\t\x16\x8b\x05?"@UU:;;C \x10@:\x9d\
\x06\x11\x01\x00\xde\xde\xde\x9a/@UUJ$\x12\xd8\xd8\xd8\xd0\x80\x05\xbb\xbf\
\xbf\x07\xd0\xc4\x1e\xa8\x06\x07\x00I\x92\x9a\' \x16\x8b\xd1\xce\xce\x8e\x10\
>00\x00\xa7\xd3\t\xa0\tK\x10\x8b\xc5hss\x13\x87\x87\x87\xf8\xfc\xfc,\x9b\xef\
\xe9\xe9\xc1\xfc\xfc<|>\x1f\x03jT`\x7f\x7f\x9f\xf4\x86\xfb\xfd~,//\xb3\xc2;\
\xf6\xf5$TU\x95nnn\x90J\xa5`0\x18055\x05\xaf\xd7\xcb\xca\xb25\x087\x1a\x8dXY\
YA(\x14*\xcd\xa5(\x8a6\x92\xc9$\xb9\\.2\x1a\x8d\x04\x80\x00\xd0\xd0\xd0\x10\
\xa5R)*\xf6\xfb:\x92\xc9$\x8d\x8d\x8d\x11\xe7\\\x8b+\x1e\xb2,\xd3\xe2\xe2"\
\x9d\x9e\x9e\x96\xe5\xd1\x1e\x8e\x8f\x8f+&\xe9\xea\xea\xa2x<.\x14P\x0b.I\x92\
\x10\xae(\xca\xbf\x1e\xb8\xbc\xbc\xc4\xd1\xd1QY\xf9^__\xf1\xfc\xfc\\\xb1\xec\
\xaa\xaa\xd2\xc1\xc1\x81\xb0\xec\x9cs\xd8l6\x8c\x8c\x8c\xc0\xe9tV\\FM\xc0\
\xc5\xc5\x05>>>\xca\x1c\xf2\xf9<\x1e\x1e\x1e*\xc2\x13\x89\x04\xa2\xd1\xa8\
\x10>::\n\x8f\xc7\x83\xf1\xf1qa\x0fi\x02\xf2\xf9\xbc\xc8\x07www\x15\xe1\xa2}\
\xce\x18\x83\xddn\xc7\xdc\xdc\x1c\\.W\xd5\x06\xae\xeb \xcaf\xb3\xda\x96\xdc\
\xde\xde\xa6\xad\xad-!\x1c\x00\xacV+\xdcnwM8P\xe7A\x94N\xa7\xd9\xf5\xf55\x85\
\xc3a\n\x06\x838??\xafX\xf6\x02|ii\t3335\xe1u\x0bxyy\xa1P(\x04\xce9\xb2\xd9\
\xac\xd0\xcfj\xb5\xc2\xef\xf7k\xa7\x9cn\x02\x00\xe0\xf1\xf1Q8\xc79\xc7\xe0\
\xe0 \x16\x16\x16\x1a\x82\x97\x08hkkk$\xae\x04^\xe8\xf6\xe9\xe9\xe9\x86\xe0%\
\x02\xfa\xfa\xfa\xbe\r\xaf\xa7\xdb\x859\n\x0f&\x93\t\x8c\xd5\x9fC\x0fx\x89\
\x00\xb3\xd9\x0cY\x96\xeb\n2\x18\x0c\xba\xc0\x81\xa2%\xe8\xee\xeeFgg\'r\xb9\
\\\xd5\x00Y\x96\xe1\xf1x`\xb3\xd9099\xf9_p\xa0\xa8\x02\x92$\xa1\xb7\xb7\xb7&\
\xdc\xeb\xf5\xc2\xe1p\xe8\x02\x07\x8a*011\xc1\xd6\xd7\xd7\xe9\xfd\xfd\x1dWWW\
\xda\xed\xb5`\x1d\x1d\x1dp\xbb\xdd\xb0\xdb\xed\xc2\x0f\xcbw\xac\xecB\x12\x89\
D(\x1a\x8d\xe2\xe4\xe4\x04\xb9\\\x0e\x8c1X,\x16\xf8|>\xac\xae\xae\xea\x06\
\x16\n\x00\x80\xdd\xdd]\xba\xbd\xbdE&\x93A{{;\xfa\xfb\xfb1;;\xab;\\(\xe0\'\
\xed\xf7\xfd\x9c~\xb5\xbf\x8a\xf3q\xb2q\x86\xa0|\x00\x00\x00\x00IEND\xaeB`\
\x82'


cross_png = \
'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00 \x00\x00\x00 \x08\x06\x00\
\x00\x00szz\xf4\x00\x00\x00\x04sBIT\x08\x08\x08\x08|\x08d\x88\x00\x00\x03\
\x9fIDATx\x9c\xc5\x97OH*_\x14\xc7\xbfW~\x82\x8c\x19Sh\xc2\x80\x8b\xfe\x10\
\x04A\x90P.\x84(r\x13ER\x14\x11\x18A\x11\x14\xba0\n\x83B\xa1\x90\\\x88\xa5\
\x05\xe5B\x11%7\x89\x14B\x08\xc2\xac\xda\xb6\x88V\xd12\xb0M\xb4jWx\xde\xe2a<\
_3\xe3(\xef\xf7\xde\x81\xb3P\xef9\xdf\xcf\x9d+\xdfs\x87\xf1<\x8f\x7f\x19\x9a\
\x7f\xaa\xfe7\x01\x82\xc1 \xcd\xcf\xcfS<\x1e\xa7_\xbfg\xf5\x8e \x9dNSKK\x0bf\
ffX3\xc2\xc9d\x92r\xb9\x1c\x8a\xc5"\xde\xde\xde044\x84\xbd\xbd=,--1Y\x80t:M\
\x8c1\xdc\xde\xde\xe2\xea\xea\n\x13\x13\x13\x98\x9a\x9aj\x18\xe2\xf0\xf0\x90\
\xe2\xf18\xee\xef\xefA\xf4s\xe3Z\xad\x16\xa3\xa3\xa3\xb0\xdb\xed\xb0\xdb\xed\
\x00\xcf\xf35y||L\xfd\xfd\xfd\xd4\xd3\xd3C\x1c\xc7\x11\x00\xe28\x8e\xbc^/\
\x89\xa2H\xbf\xaf\x97\xcaR\xa9D>\x9f\x8f\xccf3\x01\x90L\x8e\xe3(\x18\x0cRM\
\xe1\xc9\xc9\t\x19\x8dF\xd9\x025\x10\x85B\x81fggI\xa7\xd3\xc9\x8a\x03 \xa3\
\xd1H\x89D\xa2\x16\xe0\xe2\xe2\x82:::\x14\xa9\x95 \xb2\xd9,\xd9l6\xd2h4\x8a\
\xe2f\xb3\x99vvv\x88\xe7\xf9\xefG077\xa7Xl0\x18(\x14\n}\x038;;\xa3\x81\x81\
\x01\xc5Z\x00\xd4\xd5\xd5E\x91H\xe4\xab\xfe\x1b@*\x95\x92=\x86jZ,\x16J&\x93\
\xc4\xf3<DQ\xa4P(D\x82 (\xd6h4\x1a\xb2\xd9l\x94\xc9dj\xe0%\xcf\xb1\xdeS\x00@\
V\xab\x95\xb2\xd9,y<\x1e2\x18\x0c\x8ak\xb5Z-9\x9dN*\x14\n\xdf\x9e\x9c$@*\x95\
\xaa\xbb#\xc6\x18uvv\x92V\xabU\\\xc7q\x1cy<\x1e*\x16\x8b\x92\xff\x1bY#ZYY\
\xa1X,\x86\x8f\x8f\x0f\xc9\xdf\xd5D{{;\x96\x97\x97199)\xeb!\xb2V\xecp8~\x1aE\
\x93!\x08\x02vww\x91L&\x99\x92\x81\xc9\x02,,,0\x97\xcb\x05A\x10\x9a\x12\xdf\
\xda\xda\xc2\xc1\xc1A]\xe7T\x1cF\x9b\x9b\x9b\xcc\xe5rA\xa7\xd35,\xbe\xbf\xbf\
\xaf\xca\xb6\xebN\xc3\xf1\xf1q\x0c\x0f\x0f\xab\x12\xd7h4\x98\x9e\x9eV-\xae\n\
\xe0\xe1\xe1\x01OOO\xaa\x9aU*\x15\\__\xc3\xef\xf7S\xfd\xd5*\x00\xfc~?\x85\
\xc3a\x94\xcbe\xb5\xfdP.\x97\x11\x0e\x87\xd5C\xc8\r\x95H$R\xd7\x0b\x94R\x10\
\x84\x1a\xcb\x95\xcb\xffE\xbc\x11\x88\x9a\x0f\xa2(R \x10\xf8#\xe2j!j\xc4\xbd\
^\xef\xd7%D)M&\x13\x99L&\xd5\x10f\xb3\x99|>\x9f\xe4\x18\x07\xcf\xf3\xb8\xb9\
\xb9\xa1\xb5\xb55U\xe2\xd5\x1d\x05\x02\x01U\xeb\xab\xa9\xd7\xeb)\x16\x8bI\
\x03\xb8\xdd\xee\xba\x97\x88\xdf\x1f\xa7(\x8a\xe4\xf1x\xea\x0e\xa3j\xf6\xf6\
\xf6R.\x97\x93\x06\x88F\xa3\xa4\xd7\xeb\x15\x1b\xf4\xf5\xf5Q4\x1a\xadiP,\x16\
\xc9\xe9t*\xc23\xc6hdd\xe4\xeb\xfe \tpzzJ\xad\xad\xad\xb2M\x06\x07\x07)\x9b\
\xcdJ6\x90:>\xc6\x181\xc6\x08\x00uwwK\xee\xbc\x9a\xff\x01\xc0\xf3\xf33\xde\
\xdf\xdf!\x15\x16\x8b\x05n\xb7\x1b\x1b\x1b\x1b\x92\xf6\xba\xb8\xb8\xc8\xf2\
\xf9<\xb5\xb5\xb5!\x93\xc9\xe0\xf3\xf3\x13ccc\xd0\xe9tx}}\x85\xc3\xe1\xc0\
\xea\xea\xaa\xac5\xb3\xeae2\x91H\xa0T*\xa1R\xa9|\xc14:X\xce\xcf\xcf\x89\x88\
\xb0\xbe\xbe\xaez\x16|]H.//\xe9\xe5\xe5\x05\x8f\x8f\x8f8::\x02\x00loo#\x1a\
\x8d6\xf5F\xd40@5\xf2\xf9<\xdd\xdd\xdd\x01\x00\xacVk\xd3\xafdM\x03\xfc\xed\
\xf8\x01\xe9\t\x94\x8c\xa7\xf9\xf9<\x00\x00\x00\x00IEND\xaeB`\x82'



if __name__ == '__main__':
    import sys,os
    import run
    run.main(['', os.path.basename(sys.argv[0])] + sys.argv[1:])



