/*-
# X-BASED ABACUS
#
#  AbacusP.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#  Abacus demo and neat pointers from
#  Copyright (c) 1991 - 1998	Luis Fernandes, elf@ee.ryerson.ca
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "useful",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Abacus */

#ifndef _AbacusP_h
#define _AbacusP_h

#ifdef WINVER
#define STRICT

#include <windows.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "Abacus.h"

#ifndef DEMOPATH
#define DEMOPATH "c:/windows"
#endif
#ifndef BUMPSOUND
#define BUMPSOUND "c:/windows/bump.wav"
#endif
#ifndef MOVESOUND
#define MOVESOUND "c:/windows/move.wav"
#endif

#if ((WINVER > 0x030a) && !defined(GCL_HBRBACKGROUND))
#undef WINVER
#define WINVER 0x030a
#endif
#if (WINVER <= 0x030a)		/* if WINDOWS 3.1 or less */
#define Pos int
#define SETBACK(h,b) (void)SetClassWord(h,GCW_HBRBACKGROUND,(WORD)b);
#define MoveTO(h,x,y) MoveTo(h,x,y);
#else
#define Pos long
#define SETBACK(h,b) (void)SetClassLong(h,GCL_HBRBACKGROUND,(LONG)b);
#define MoveTO(h,x,y) MoveToEx(h,x,y,NULL);
#endif
#ifndef Point
#define Point POINT
#endif
#ifndef Boolean
#define Boolean BOOL
#endif
#ifndef True
#define True TRUE
#endif
#ifndef False
#define False FALSE
#endif
#define GC COLORREF  /* Equate apples to oranges */
#define Pixmap HBITMAP

#define DC(w,dr) ((dr==0)?w->core.hDC:w->abacus.memDC)
#define RECTANGLE(w,x,y,l,h,c) if ((l)==1 && (h)==1) \
  (void)SetPixel(w,x,y,c); \
  else (void)Rectangle(w,x,y,x+l,y+h)
#define DRAWRECTANGLE(w,dr,c,x,y,l,h) \
  if (dr) w->abacus.hOldBitmap = (HBITMAP) SelectObject(w->abacus.memDC,dr); \
  w->abacus.hPen = CreatePen(PS_SOLID,1,c); \
  w->abacus.hOldPen = (HPEN) SelectObject(DC(w,dr),w->abacus.hPen); \
  RECTANGLE(DC(w,dr),x,y,(l)+1,(h)+1,c); \
  (void) SelectObject(DC(w,dr),w->abacus.hOldPen); \
  (void) DeleteObject(w->abacus.hPen); \
  if (dr) (void) SelectObject(w->abacus.memDC,w->abacus.hOldBitmap)
#define FILLRECTANGLE(w,dr,c,x,y,l,h) \
  if (dr) w->abacus.hOldBitmap = (HBITMAP) SelectObject(w->abacus.memDC,dr); \
  w->abacus.hPen = CreatePen(PS_SOLID,1,c); \
  w->abacus.hOldPen = (HPEN) SelectObject(DC(w,dr),w->abacus.hPen); \
  w->abacus.hBrush = CreateSolidBrush(c); \
  w->abacus.hOldBrush = (HBRUSH) SelectObject(DC(w,dr),w->abacus.hBrush); \
  RECTANGLE(DC(w,dr),x,y,l,h,c); \
  (void) SelectObject(DC(w,dr),w->abacus.hOldBrush); \
  (void) DeleteObject(w->abacus.hBrush); \
  (void) SelectObject(DC(w,dr),w->abacus.hOldPen); \
  (void) DeleteObject(w->abacus.hPen); \
  if (dr) (void) SelectObject(w->abacus.memDC,w->abacus.hOldBitmap)
#define CIRCLE(w,r,x,y) if(r>0) \
 (void)Ellipse(w,x-r+1,y-r+1,x+r,y+r)
#define DRAWCIRCLE(w,dr,c,d,x,y) \
  if (dr) w->abacus.hOldBitmap = (HBITMAP) SelectObject(w->abacus.memDC,dr); \
  w->abacus.hPen = CreatePen(PS_SOLID,1,c); \
  w->abacus.hOldPen = (HPEN) SelectObject(DC(w,dr),w->abacus.hPen); \
  w->abacus.hBrush = CreateSolidBrush(c); \
  w->abacus.hOldBrush = (HBRUSH) SelectObject(DC(w,dr),w->abacus.hBrush); \
  CIRCLE(DC(w,dr),((d+2)>>1),(x)+(d)%2,(y)+(d)%2); \
  (void) SelectObject(DC(w,dr),w->abacus.hOldBrush); \
  (void) DeleteObject(w->abacus.hBrush); \
  (void) SelectObject(DC(w,dr),w->abacus.hOldPen); \
  (void) DeleteObject(w->abacus.hPen); \
  if (dr) (void) SelectObject(w->abacus.memDC,w->abacus.hOldBitmap)
#define FILLCIRCLE(w,dr,c,d,x,y) \
  w->abacus.hOldBitmap = (HBITMAP) SelectObject(w->abacus.memDC,dr); \
  w->abacus.hPen = CreatePen(PS_SOLID,1,c); \
  w->abacus.hOldPen = (HPEN) SelectObject(DC(w,dr),w->abacus.hPen); \
  w->abacus.hBrush = CreateSolidBrush(c); \
  w->abacus.hOldBrush = (HBRUSH) SelectObject(DC(w,dr),w->abacus.hBrush); \
  CIRCLE(DC(w,dr),((d+2)>>1),(x)+(d)%2,(y)+(d)%2); \
  (void) SelectObject(DC(w,dr),w->abacus.hOldBrush); \
  (void) DeleteObject(w->abacus.hBrush); \
  (void) SelectObject(DC(w,dr),w->abacus.hOldPen); \
  (void) DeleteObject(w->abacus.hPen); \
  if (dr) (void) SelectObject(w->abacus.memDC,w->abacus.hOldBitmap)
#if 0
#define DISPLAY_WARNING(s) (void) fprintf(stderr, s)
#else
#define DISPLAY_INFO(s) (void) MessageBox(w->core.hWnd, s, "Info", MB_OK)
#define DISPLAY_WARNING(s) (void) MessageBox(w->core.hWnd, s, "Warning", MB_OK)
#endif
#define DISPLAY_ERROR(s) (void) fprintf(stderr, "%s\n", s); exit(1)

typedef struct _CorePart {
	HWND        hWnd;
	HDC         hDC;
	HINSTANCE   hInstance;
	Pos         width, height;
} CorePart;

extern void DestroyAbacus(AbacusWidget w, HBRUSH brush);
extern void ResizeAbacus(AbacusWidget w);
extern void InitializeAbacus(AbacusWidget w, HBRUSH brush);
extern void ExposeAbacus(AbacusWidget w);
extern void HideAbacus(AbacusWidget w);
extern void SelectAbacus(AbacusWidget w, const int x, const int y);
extern void ReleaseAbacus(AbacusWidget w);
extern void ClearAbacus(AbacusWidget w);
extern void IncrementAbacus(AbacusWidget w);
extern void DecrementAbacus(AbacusWidget w);
extern void SpeedAbacus(AbacusWidget w);
extern void SlowAbacus(AbacusWidget w);
extern void SoundAbacus(AbacusWidget w);
extern void FormatAbacus(AbacusWidget w);
extern void RomanNumeralsAbacus(AbacusWidget w);
extern void SignAbacus(AbacusWidget w);
extern void QuarterAbacus(AbacusWidget w);
extern void QuarterPercentAbacus(AbacusWidget w);
extern void VerticalAbacus(AbacusWidget w);
extern void EnterAbacus(AbacusWidget w);
extern void LeaveAbacus(AbacusWidget w);

extern void MoveAbacus(AbacusWidget w);
extern void SetAbacusString(AbacusWidget w, int reason, char *string);
#if (WINVER <= 0x030a)
extern void Sleep(unsigned long cMilliseconds);
#endif

extern void InitializeAbacusDemo(AbacusWidget w);
extern void ExposeAbacusDemo(AbacusWidget w);
extern void ClearAbacusDemo(AbacusWidget w);
extern void DemoAbacusDemo(AbacusWidget w);
extern void NextAbacusDemo(AbacusWidget w);
extern void RepeatAbacusDemo(AbacusWidget w);
extern void MoreAbacusDemo(AbacusWidget w);

#else

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#else
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#endif
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include <X11/Xos.h>
#include "Abacus.h"

#ifdef VMS
#ifndef DEMOPATH
#define DEMOPATH "[.]"
#endif
#ifndef BUMPSOUND
#define BUMPSOUND "[.]bump.au"
#endif
#ifndef MOVESOUND
#define MOVESOUND "[.]move.au"
#endif
#else
#ifndef DEMOPATH
#if 0
#define DEMOPATH "/usr/share/games/xabacus"
#endif
#define DEMOPATH "/usr/local/share/games/xabacus"
#endif
#ifndef BUMPSOUND
#if 0
#define BUMPSOUND "/usr/share/games/xabacus/bump.au"
#endif
#define BUMPSOUND "/usr/local/share/games/xabacus/bump.au"
#endif
#ifndef MOVESOUND
#if 0
#define MOVESOUND "/usr/share/games/xabacus/move.au"
#endif
#define MOVESOUND "/usr/local/share/games/xabacus/move.au"
#endif
#endif

#ifndef Pos
#define Pos Position
#endif
#ifndef Point
#define Point XPoint
#endif
#define NUM_DEGREES 360
#define MULT 64
#define FULLCIRCLE (NUM_DEGREES*MULT)
#define DR(w,dr) ((dr==0)?XtWindow(w):dr)
#define DRAWRECTANGLE(w,dr,c,i,j,l,h) XDrawRectangle(XtDisplay(w),DR(w,dr),\
	c,i,j,l,h)
#define FILLRECTANGLE(w,dr,c,i,j,l,h) XFillRectangle(XtDisplay(w),DR(w,dr),\
	c,i,j,l,h)
#define DRAWCIRCLE(w,dr,c,d,x,y) if(d>0) XDrawArc(XtDisplay(w),DR(w,dr),\
	c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define FILLCIRCLE(w,dr,c,d,x,y) if(d>0) XFillArc(XtDisplay(w),DR(w,dr),\
	c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)

#define DISPLAY_INFO(s) XtWarning(s)
#define DISPLAY_WARNING(s) XtWarning(s)
#define DISPLAY_ERROR(s) XtError(s)

/* This gets around C's inability to do inheritance */
typedef struct _AbacusClassPart {
	int         ignore;
} AbacusClassPart;

typedef struct _AbacusClassRec {
	CoreClassPart core_class;
	AbacusClassPart abacus_class;
} AbacusClassRec;

extern AbacusClassRec abacusClassRec;

extern void Sleep(unsigned long cMilliseconds);
#endif

#define MAXDECKS 2
#define PLACESETTING 2
#define UP 1
#define DOWN 0
#define TOP 1
#define BOTTOM 0
#define CARRY 2	/* I guess it could be even more if you have a weird config
		   also need a space to hold null (not included) */
#define SPECIAL_QUARTERS 2 /* Quarters, QuarterPercents */

/* Migrate to Locale */
#define DECIMAL_SEPARATOR '.'
#define GROUP_SEPARATOR ','
#define GROUPING_SIZE 3

#define MAXLENFORMAT 9

#define LINES 4
#define CHARS 64

#define MAXSLICES 10

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

#define ABS(a) (((a)<0)?(-(a)):(a))
#define SIGN(a) (((a)<0)?(-1):1)
#define MIN(a,b) (((int)(a)<(int)(b))?(int)(a):(int)(b))
#define MAX(a,b) (((int)(a)>(int)(b))?(int)(a):(int)(b))
#define NEWPOS(dir,x) ((((dir)==UP)?-1:1)*(x))

typedef struct _DeckPart {
	int         number;
	Boolean     orientation;
	int         factor;
	int        *position;
	int         spaces;	/* spaces between beads */
	int         room;	/* spaces + number */
	Pos         height;
} DeckPart;

typedef struct _AbacusPart {
	DeckPart    decks[MAXDECKS];
	int         currentDeck, currentRail, currentPosition;
	int         rails;	/* number of columns of beads */
	int         decimalPosition, numDigits;
	int         base, displayBase;	/* 10 usually */
	int         delay, numSlices, mode;
	int         deck, rail, number;
	Pos         width, midHeight, midBarY, railWidth;
	Point       frameSize, beadSize;
	Point       pos, delta, offset;
	Boolean     mono, reverse, script, demo, focus, vertical, aux;
	Boolean     sign, quarter, quarterPercent, romanNumerals;
	Boolean     slot, diamond, sound;
	char       *digits, *mathBuffer;
	FILE       *fp;
	GC          frameGC, borderGC, railGC, inverseGC;
	GC          beadShadeGC[5];
	Pixmap      bufferBead[2][2];
#ifdef WINVER
	long        oldTime;
	HDC         memDC;
	char        format[81], bumpSound[81], moveSound[81];
	HPEN        hOldPen, hPen;
	HBRUSH      hOldBrush, hBrush;
	HBITMAP     hOldBitmap;
#else
	struct timeval oldTime;
	char       *format, *bumpSound, *moveSound;
	int         menu;
	Colormap    colormap;
	Pixel       foreground, background;
	Pixel       borderColor, beadColor, frameColor, railColor;
	XtCallbackList select;
#endif
} AbacusPart;

typedef struct _AbacusDemoPart {
	int         lessons;
	int         lessonLength, lessonCount;
	int         aux, deck, rail, number, lines;
	int         fontHeight;
	FILE       *fp;
	Boolean     query, started, framed;
	GC          foregroundGC;
#ifdef WINVER
	char        path[81];
#else
	GC          inverseGC;
	char       *path, *font;
	XFontStruct *fontInfo;
	Pixel       background, foreground;
	XtCallbackList select;
#endif
} AbacusDemoPart;

typedef struct _AbacusRec {
	CorePart    core;
	AbacusPart  abacus;
	AbacusDemoPart abacusDemo;
} AbacusRec;

extern void SetAbacus(AbacusWidget w, int reason);
extern void SetAbacusDemo(AbacusWidget w, int reason);
extern void SetAbacusMove(AbacusWidget w, int reason, int aux,
	int deck, int rail, int number);
extern int char2Int(char character);
extern char int2Char(int digit);

extern void dividePieces(char * buf, int base, int pieces,
	int mult, int places);
extern void addStrings(char *finalBuf, char *buf, char *pieceBuf,
	int base);
extern void subStrings(char *finalBuf, char *buf, char *pieceBuf,
	int base);
extern void convertString(char * buf, char * inbuf,
	int base, int displayBase, int decimalPosition);

extern int sizeofRoman(int base, Boolean romanNumerals);
extern int string2Roman(char *buf, char *inbuf, int base);
extern void calculate(AbacusWidget w, char *buffer);

extern int baseToBottom(int base);

extern void ClearRails(AbacusWidget w);
#endif /* _AbacusP_h */
