/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included which follows the "include" declaration
** in the input file. */
#line 1 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"

/* queryparser.lemony: build a Xapian::Query object from a user query string.
 *
 * Copyright (C) 2004,2005,2006 Olly Betts
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <config.h>

#include "accentnormalisingitor.h"
#include "queryparser_internal.h"
#include "utils.h"

// Include the list of token values lemon generates.
#include "queryparser_token.h"

#include <algorithm>
#include <list>
#include <string>

using namespace std;

using namespace Xapian;

// Disable debug code lemon adds.
#define NDEBUG

/// Class used to pass information about a term from lexer to parser.
class Term {
    // So State can read our name.
    friend class ::State;

    string name;
    termpos pos;

  public:
    Term(const string &name_, termpos pos_) : name(name_), pos(pos_) { }

    termpos get_termpos() const { return pos; }

    Query * as_query() const { return new Query(name, 1, pos); }

    Query * as_wildcarded_query(State * state) const;

    Query as_query_object() const { return Query(name, 1, pos); }
};

/// Parser State shared between the lexer and the parser.
class State {
  private:
    QueryParser::Internal * qpi;

  public:
    Query query;
    const char * error;

    State(QueryParser::Internal * qpi_) : qpi(qpi_), error(NULL) { }

    void add_to_stoplist(const Term * term) {
	qpi->stoplist.push_back(term->name);
    }

    Query::op default_op() const { return qpi->default_op; }

    bool is_stopword(const Term *term) const {
	return qpi->stopper && (*qpi->stopper)(term->name);
    }

    Database get_database() {
	return qpi->db;
    }
};

static void
add_to_query(Query & q, Query::op op, const Query &term)
{
    if (q.empty()) {
	q = term;
    } else {
	q = Query(op, q, term);
    }
}

Query *
Term::as_wildcarded_query(State * state) const
{
    Database db = state->get_database();
    TermIterator t = db.allterms_begin();
    t.skip_to(name);
    Query q;
    while (t != db.allterms_end() && (*t).substr(0, name.size()) == name) {
	add_to_query(q, Query::OP_OR, Query(*t, 1, pos));
	++t;
    }
    return new Query(q);
}

static inline string
downcase_term(const string &term)
{
    string t;
    t.reserve(term.size());
    AccentNormalisingItor i(term.begin());
    const AccentNormalisingItor end(term.end());
    while (i != end) t += C_tolower(*i++);
    return t;
}

static inline bool
is_phrase_generator(unsigned char ch)
{
    // These characters generate a phrase search.
    // Ordered mostly by frequency of calls to this function done when
    // running queryparsertest.
    return (ch && strchr(".-/':\\_@", ch) != NULL);
}

static inline bool
prefix_needs_colon(const string & prefix, unsigned char ch)
{
    if (!C_isupper(ch)) return false;
    string::size_type len = prefix.length();
    return (len > 1 && prefix[len - 1] != ':');
}

// Prototype the functions lemon generates.
static void *ParseAlloc();
static void ParseFree(void *);
static void Parse(void *, int, Term *, State *);

Query
QueryParser::Internal::parse_query(const string &qs, unsigned flags)
{
#ifndef NDEBUG
    // Set the prefix added to Lemon's debug output, if it's enabled.
    // FIXME: arrange to send this to the Xapian debug log, and turn
    // on Lemon's debugging when --enable-debug is on.
    ParseTrace(stdout, "LEMON: ");
#endif

    void * pParser = ParseAlloc();

    termpos term_pos = 1;
    AccentNormalisingItor it(qs.begin()), end(qs.end());

    State state(this);

    list<string> prefix_stack;
    // Simplify reading the current prefix by pushing an empty string.
    prefix_stack.push_back("");

    enum {
	DEFAULT, IN_QUOTES, IN_PREFIXED_QUOTES, IN_PHRASED_TERM
    } mode = DEFAULT;

    unsigned char newprev = ' ';
    while (it != end) {
	if (mode == IN_PHRASED_TERM) mode = DEFAULT;
	if (C_isspace(*it)) {
	    newprev = ' ';
	    ++it;
	    it = find_if(it, end, C_isnotspace);
	    if (it == end) break;
	}

	if (!C_isalnum(*it)) {
	    unsigned char prev = newprev;
	    unsigned char ch = *it++;
	    if (it != end) newprev = *it;
	    switch (ch) {
	      case '"':
		// Skip whitespace.
		it = find_if(it, end, C_isnotspace);
		if (mode == DEFAULT) {
		    if (it == end) {
			// Ignore an unmatched " at the end of the query to
			// avoid generating an empty pair of QUOTEs which will
			// cause a parse error.
			goto done;
		    }
		    if (*it == '"') {
			// Ignore empty "" (but only if we're not already
			// IN_QUOTES as we don't merge two adjacent quoted
			// phrases!)
			newprev = *it++;
			continue;
		    }
		}
		if (flags & FLAG_PHRASE) {
		    Parse(pParser, QUOTE, NULL, &state);
		    if (mode == DEFAULT) {
			mode = IN_QUOTES;
		    } else {
			// Remove the prefix we pushed for this phrase.
			if (mode == IN_PREFIXED_QUOTES)
			    prefix_stack.pop_back();
			mode = DEFAULT;
		    }
		}
		continue;

	      case '+': case '-':
		// Ignore + or - at end of query.
		if (it == end) goto done;
		if (prev > ' ' && prev != '(') {
		    // Or if not after whitespace or an open bracket.
		    continue;
		}
		if (C_isspace(*it) || *it == '+' || *it == '-') {
		    // Ignore + or - followed by a space, or further + or -.
		    // Postfix + (such as in C++ and H+) is handled as part of
		    // the term lexing code below.
		    newprev = *it++;
		    continue;
		}
		if (mode == DEFAULT && (flags & FLAG_LOVEHATE))
		    Parse(pParser, (ch == '+' ? LOVE : HATE), NULL, &state);
		continue;

	      case '(':
		// Skip whitespace.
		it = find_if(it, end, C_isnotspace);
		// Ignore ( at end of query.
		if (it == end) goto done;
		if (prev > ' ' && prev != '(' && prev != ')') {
		    // Or if not after whitespace or a bracket.
		    continue;
		}
		if (*it == ')') {
		    // Ignore empty ().
		    newprev = *it++;
		    continue;
		}
		if (mode == DEFAULT && (flags & FLAG_BOOLEAN)) {
		    prefix_stack.push_back(prefix_stack.back());
		    Parse(pParser, BRA, NULL, &state);
		}
		continue;

	      case ')':
		if (term_pos == 1) {
		    // Ignore ) at start of query.
		    continue;
		}
		if (mode == DEFAULT && (flags & FLAG_BOOLEAN)) {
		    // Remove the prefix we pushed for the corresponding BRA.
		    // If brackets are unmatched, it's a syntax error, but
		    // that's no excuse to SEGV!
		    if (prefix_stack.size() > 1) prefix_stack.pop_back();
		    Parse(pParser, KET, NULL, &state);
		}
		continue;
	    }
	    // Skip any other characters.
	    continue;
	}

	newprev = 'A'; // Any letter will do...

	// A term, a prefix, or a boolean operator.
	string prefix;
	if (mode == DEFAULT && !prefixes.empty()) {
	    // Check for fieldname prefixes (e.g. title:historical).
	    AccentNormalisingItor p = find_if(it, end, C_isnotalnum);
	    if (p != end && *p == ':' && ++p != end && *p > ' ' && *p != ')') {
		string field;
		p = it;
		while (*p != ':') field += *p++;
		map<string, BoolAndString>::const_iterator f;
		f = prefixes.find(field);
		if (f != prefixes.end()) {
		    unsigned char ch = *++p;
		    bool boolean_filter = f->second.flag;
		    if (boolean_filter || C_isalnum(ch) ||
			((flags & FLAG_PHRASE) && ch == '"') ||
			((flags & FLAG_BOOLEAN) && ch == '(')) {
			it = p;
			// Can't boolean prefix a subexpression or phrase.
			if (!boolean_filter && !C_isalnum(ch)) {
			    newprev = ch;
			    ++it;
			    prefix_stack.push_back(f->second.str);
			    if (ch == '(') {
				// Prefixed sub-expr: title:(fast NEAR food)
				Parse(pParser, BRA, NULL, &state);
				continue;
			    }
			    // Prefixed phrase: subject:"space flight"
			    Parse(pParser, QUOTE, NULL, &state);
			    mode = IN_PREFIXED_QUOTES;
			    continue;
			}
			prefix = f->second.str;
			if (boolean_filter) {
			    if (prefix_needs_colon(prefix, *it))
				prefix += ':';
			    while (it != end && *it > ' ' && *it != ')')
				prefix += *it++;
			    Parse(pParser, BOOLEAN_FILTER,
				  new Term(prefix, 0), &state);
			    continue;
			}
		    }
		}
	    }
	}

phrased_term:
	string term;
	size_t transliterations = it.transliterations();
	// Look for initials separated by '.' (e.g. P.T.O., U.N.C.L.E).
	// Don't worry if there's a trailing '.' or not.
	if (C_isupper(*it)) {
	    string t;
	    AccentNormalisingItor p = it;
	    do {
		t += *p++;
	    } while (p != end && *p == '.' && ++p != end && C_isupper(*p));
	    // One letter does not make an acronym!  If we handled a single
	    // uppercase letter here, we wouldn't catch M&S below.
	    if (t.length() > 1) {
		// Check there's not a (lower case) letter or digit
		// immediately after it.
		if (p == end || !C_isalnum(*p)) {
		    it = p;
		    swap(term, t);
		}
	    }
	}
	bool was_acronym = !term.empty();

	if (term.empty()) {
	    while (it != end) {
		if (!C_isalnum(*it)) {
		    // Treat a single embedded '&' as a word character
		    // (e.g. AT&T).
		    if (*it != '&') break;
		    AccentNormalisingItor p = it;
		    ++p;
		    if (p == end || !C_isalnum(*p)) break;
		}
		term += *it++;
	    }
	    if (it != end && (*it == '#' || C_issign(*it))) {
		string suff_term = term;
		AccentNormalisingItor p = it;
		if (*p == '#') {
		    // Keep trailing # (e.g. C#).
		    suff_term += '#';
		    while (++p != end && *p == '#') { }
		} else {
		    // Keep trailing +, and - (e.g. C++, Na+, Cl-).
		    // FIXME: keeping trailing "-" is of dubious utility and
		    // there's the risk of hyphens getting stuck onto the end of
		    // terms...
		    // FIXME: generating a term like foo+---+++ doesn't make
		    // much sense - we should probably be more conservative as
		    // to what combinations are allowed.
		    do {
			suff_term += *p++;
		    } while (p != end && C_issign(*p));
		}
		if (p == end || !C_isalnum(*p)) {
		    // If the suffixed term doesn't exist, check that the
		    // non-suffixed term does.  This also takes care of
		    // the case when QueryParser::set_database() hasn't
		    // been called.
		    bool use_suff_term = false;
		    string lc = downcase_term(suff_term);
		    if (db.term_exists(lc)) {
			use_suff_term = true;
		    } else {
			lc = downcase_term(term);
			if (!db.term_exists(lc)) use_suff_term = true;
		    }
		    if (use_suff_term) {
			term = suff_term;
			it = p;
		    }
		}
	    }
	}

	// Boolean operators.
	if (mode == DEFAULT && (flags & FLAG_BOOLEAN) &&
	    // Don't want to interpret A.N.D. or ND as an AND operator.
	    !was_acronym && transliterations == it.transliterations() &&
	    prefix.empty() &&
	    term.size() >= 2 && term.size() <= 4 && C_isalpha(term[0])) {

	    string op = term;
	    if (flags & FLAG_BOOLEAN_ANY_CASE) {
		for (string::iterator i = op.begin(); i != op.end(); ++i) {
		    *i = C_toupper(*i);
		}
	    }
	    if (op.size() == 3) {
		if (op == "AND") {
		    Parse(pParser, AND, NULL, &state);
		    continue;
		} else if (op == "NOT") {
		    Parse(pParser, NOT, NULL, &state);
		    continue;
		} else if (op == "XOR") {
		    Parse(pParser, XOR, NULL, &state);
		    continue;
		} else if (op == "ADJ") {
		    if (it != end && *it == '/') {
			size_t width = 0;
			AccentNormalisingItor p = it;
			while (++p != end && C_isdigit(*p)) {
			    width = (width * 10) + (*p - '0');
			}
			if (width && (p == end || C_isspace(*p))) {
			    it = p;
			    Parse(pParser, ADJ, new Term("", width), &state);
			    continue;
			}
		    }

		    Parse(pParser, ADJ, NULL, &state);
		    continue;
		}
	    } else if (op.size() == 2) {
		if (op == "OR") {
		    Parse(pParser, OR, NULL, &state);
		    continue;
		}
	    } else if (op.size() == 4) {
		if (op == "NEAR") {
		    if (it != end && *it == '/') {
			size_t width = 0;
			AccentNormalisingItor p = it;
			while (++p != end && C_isdigit(*p)) {
			    width = (width * 10) + (*p - '0');
			}
			if (width && (p == end || C_isspace(*p))) {
			    it = p;
			    Parse(pParser, NEAR, new Term("", width), &state);
			    continue;
			}
		    }

		    Parse(pParser, NEAR, NULL, &state);
		    continue;
		}
	    }
	}

	bool need_to_stem = (stem_action != STEM_NONE);
	string unstemmed_term;
	if (stem_action == STEM_SOME && it != end && *it == '.') {
	    AccentNormalisingItor p = it;
	    ++p;
	    // TopTerms won't generate an embedded '.', and we want to
	    // stem terms in a phrased term with '.' phrase generators -
	    // e.g. "example.com" should give a phrase search for "exampl"
	    // and "com", not "example" and "com".
	    if (p == end || C_isspace(*p)) {
		it = p;
		// If topterms added a term with a trailing '.', it will be
		// lower case.  So if it has an initial capital it must be an
		// initial in someone's name, a full stop in pasted text or
		// something like that.
		if (!C_isupper(term[0])) {
		    unstemmed_term = term + '.';
		    need_to_stem = false;
		}
	    }
	}

	if (unstemmed_term.empty()) unstemmed_term = term;
	term = downcase_term(term);
	if (need_to_stem) {
	    if (stem_action == STEM_SOME && C_isupper(unstemmed_term[0]))
		term = 'R' + term;
	    else
		term = stemmer.stem_word(term);
	}

	if (prefix.empty()) prefix = prefix_stack.back();
	if (!prefix.empty()) {
	    if (prefix_needs_colon(prefix, term[0])) prefix += ':';
	    term = prefix + term;
	}

	unstem.insert(make_pair(term, unstemmed_term));

	if (mode == IN_PHRASED_TERM) {
	    Parse(pParser, PHR_TERM, new Term(term, term_pos++), &state);
	} else {
	    if (flags & FLAG_WILDCARD) {
		if (mode == DEFAULT && it != end && *it == '*') {
		    ++it;
		    if (it == end || !C_isalnum(*it)) {
			// Wildcard at end of term (also know as
			// "right truncation").
			Parse(pParser, WILD_TERM, new Term(term, term_pos++),
			      &state);
			continue;
		    }
		}
	    }

	    Parse(pParser, TERM, new Term(term, term_pos++), &state);
	    if (mode != DEFAULT) continue;
	}

	if (it != end && is_phrase_generator(*it)) {
	    // Skip multiple phrase generaters.
	    do {
		++it;
	    } while (it != end && is_phrase_generator(*it));
	    // Don't generate a phrase unless the phrase generators are
	    // immediately followed by another term.
	    if (it != end && C_isalnum(*it)) {
		mode = IN_PHRASED_TERM;
		goto phrased_term;
	    }
	}
    }
done:
    // Implicitly close any unclosed quotes...
    if (mode == IN_QUOTES || mode == IN_PREFIXED_QUOTES)
	Parse(pParser, QUOTE, NULL, &state);
    Parse(pParser, 0, NULL, &state);
    ParseFree(pParser);

    errmsg = state.error;
    return state.query;
}

struct ProbQuery {
    Query query;
    Query love;
    Query hate;
    Query filter;
};

class TermList {
    list<Query> terms;
    size_t window;

  public:
    TermList() : window(0) { }

    /// Add a Term object to this TermList object.
    void add_term(Term * term) {
	terms.push_back(term->as_query_object());
	delete term;
    }

    void adjust_window(size_t alternative_window) {
	if (alternative_window > window) window = alternative_window;
    }

    /// Convert to a Xapian::Query * using adjacent OP_PHRASE.
    Query * as_phrase_query() const {
	Query * term;
	term = new Query(Query::OP_PHRASE, terms.begin(), terms.end(),
			 terms.size());
	delete this;
	return term;
    }

    /// Convert to a Xapian::Query * using OP_NEAR.
    Query * as_near_query() const {
	Query * term;
	// The common meaning of 'a NEAR b' is "a within 10 terms of b", which
	// means a window size of 11.  For more than 2 terms, we just add one
	// to the window size for each extra term.
	size_t w = window;
	if (w == 0) w = 10;
	term = new Query(Query::OP_NEAR, terms.begin(), terms.end(),
			 terms.size() + w - 1);
	delete this;
	return term;
    }

    /// Convert to a Xapian::Query * using OP_PHRASE to implement ADJ.
    Query * as_adj_query() const {
	Query * term;
	// The common meaning of 'a ADJ b' is "a at most 10 terms before b",
	// which means a window size of 11.  For more than 2 terms, we just add
	// one to the window size for each extra term.
	size_t w = window;
	if (w == 0) w = 10;
	term = new Query(Query::OP_PHRASE, terms.begin(), terms.end(),
			 terms.size() + w - 1);
	delete this;
	return term;
    }

    /** Provide a way to explicitly delete an object of this class.  The
     *  destructor is protected to prevent auto-variables of this type.
     */
    void destroy() { delete this; }

  protected:
    /** Protected destructor, so an auto-variable of this type is a
     *  compile-time error - you must allocate this object with new.
     */
    ~TermList() { }
};

// Helper macro for converting a boolean operation into a Xapian::Query.
#define BOOL_OP_TO_QUERY(E, A, OP, B, OP_TXT) \
    do {\
	if (!A || !B) {\
	    state->error = "Syntax: <expression> "OP_TXT" <expression>";\
	    yy_parse_failed(yypParser);\
	    return;\
	}\
	E = new Query(OP, *A, *B);\
	delete A;\
	delete B;\
    } while (0)

#line 641 "queryparser_internal.cc"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    ParseTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 32
#define YYACTIONTYPE unsigned char
#define ParseTOKENTYPE Term *
typedef union {
  ParseTOKENTYPE yy0;
  int yy6;
  TermList * yy11;
  ProbQuery * yy12;
  Query * yy53;
  int yy63;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define ParseARG_SDECL State * state;
#define ParseARG_PDECL ,State * state
#define ParseARG_FETCH State * state = yypParser->state
#define ParseARG_STORE yypParser->state = state
#define YYNSTATE 63
#define YYNRULE 44
#define YYERRORSYMBOL 17
#define YYERRSYMDT yy63
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   108,    1,    2,    3,   13,   39,   40,   47,   60,   63,
 /*    10 */    28,   30,   33,   12,    2,    5,   13,   39,   40,   47,
 /*    20 */    60,    4,   28,   30,   33,   12,    2,    7,   13,   39,
 /*    30 */    40,   47,   60,   18,   28,   30,   33,   12,    2,    9,
 /*    40 */    13,   39,   40,   47,   60,   20,   28,   30,   33,   12,
 /*    50 */     2,   11,   13,   39,   40,   47,   60,   27,   28,   30,
 /*    60 */    33,   37,    2,    3,   13,   39,   40,   47,   60,   29,
 /*    70 */    28,   30,   33,   12,    2,   62,   13,   39,   40,   47,
 /*    80 */    60,   31,   28,   30,   33,   91,   24,   91,   91,   91,
 /*    90 */    91,   17,   19,   32,   17,   19,   16,   64,   14,   16,
 /*   100 */    21,   91,   28,   30,   33,   42,   55,   59,   61,   22,
 /*   110 */    58,   23,   36,   26,   42,   55,   59,   25,   22,   58,
 /*   120 */    23,   36,   35,   42,   55,   59,   34,   22,   58,   23,
 /*   130 */    36,   77,   87,   87,   15,   77,   22,   87,   23,   36,
 /*   140 */    92,   38,   92,   92,   92,   92,   41,   77,   21,   77,
 /*   150 */    28,   30,   33,   77,   77,   45,   92,   22,   44,   23,
 /*   160 */    36,   43,   77,   77,   46,   77,   28,   30,   33,   45,
 /*   170 */    77,   22,   50,   23,   36,   49,   77,   77,   46,   77,
 /*   180 */    28,   30,   33,   45,   77,   22,   53,   23,   36,   77,
 /*   190 */    52,   77,   77,   46,   77,   28,   30,   33,   45,   77,
 /*   200 */    22,   57,   23,   36,   56,   77,   77,   46,   77,   28,
 /*   210 */    30,   33,    6,    8,   10,    4,   77,   77,   15,   77,
 /*   220 */    22,   77,   23,   36,   48,   51,   77,   77,   77,   54,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    18,   19,   20,   21,   22,   23,   24,   25,   26,    0,
 /*    10 */    28,   29,   30,   19,   20,   21,   22,   23,   24,   25,
 /*    20 */    26,    5,   28,   29,   30,   19,   20,   21,   22,   23,
 /*    30 */    24,   25,   26,   10,   28,   29,   30,   19,   20,   21,
 /*    40 */    22,   23,   24,   25,   26,   10,   28,   29,   30,   19,
 /*    50 */    20,   21,   22,   23,   24,   25,   26,   10,   28,   29,
 /*    60 */    30,   19,   20,   21,   22,   23,   24,   25,   26,   11,
 /*    70 */    28,   29,   30,   19,   20,   21,   22,   23,   24,   25,
 /*    80 */    26,    6,   28,   29,   30,    0,   27,    2,    3,    4,
 /*    90 */     5,    6,    7,   10,    6,    7,   11,    0,   24,   11,
 /*   100 */    26,   16,   28,   29,   30,    8,    9,   10,    2,   12,
 /*   110 */    13,   14,   15,   10,    8,    9,   10,   14,   12,   13,
 /*   120 */    14,   15,   10,    8,    9,   10,    7,   12,   13,   14,
 /*   130 */    15,   31,    8,    9,   10,   31,   12,   13,   14,   15,
 /*   140 */     0,   16,    2,    3,    4,    5,   24,   31,   26,   31,
 /*   150 */    28,   29,   30,   31,   31,   10,   16,   12,   13,   14,
 /*   160 */    15,   23,   31,   31,   26,   31,   28,   29,   30,   10,
 /*   170 */    31,   12,   13,   14,   15,   23,   31,   31,   26,   31,
 /*   180 */    28,   29,   30,   10,   31,   12,   13,   14,   15,   31,
 /*   190 */    23,   31,   31,   26,   31,   28,   29,   30,   10,   31,
 /*   200 */    12,   13,   14,   15,   23,   31,   31,   26,   31,   28,
 /*   210 */    29,   30,    2,    3,    4,    5,   31,   31,   10,   31,
 /*   220 */    12,   31,   14,   15,    8,    9,   31,   31,   31,   13,
};
#define YY_SHIFT_USE_DFLT (-1)
static const short yy_shift_ofst[] = {
 /*     0 */    97,    9,   -1,  210,  106,   -1,  115,   16,  115,   16,
 /*    10 */   115,   16,   -1,  124,   -1,   88,   -1,   23,   -1,   35,
 /*    20 */    -1,   -1,   -1,   47,  103,   -1,   -1,   -1,   58,   -1,
 /*    30 */    75,   83,   -1,  119,  112,   -1,  115,  125,   -1,   -1,
 /*    40 */   208,   -1,  145,   -1,   -1,   88,   -1,  216,  159,   -1,
 /*    50 */    -1,  173,   -1,   -1,   -1,  188,   -1,   -1,   -1,   85,
 /*    60 */   140,  115,   16,
};
#define YY_REDUCE_USE_DFLT (-19)
static const short yy_reduce_ofst[] = {
 /*     0 */   -18,  -19,  -19,  -19,   -6,  -19,    6,  -19,   18,  -19,
 /*    10 */    30,  -19,  -19,   74,  -19,  -19,  -19,  -19,  -19,  -19,
 /*    20 */   -19,  -19,  -19,   59,  -19,  -19,  -19,  -19,  -19,  -19,
 /*    30 */   -19,  -19,  -19,  -19,  -19,  -19,   42,  -19,  -19,  -19,
 /*    40 */   122,  -19,  138,  -19,  -19,  -19,  -19,  -19,  152,  -19,
 /*    50 */   -19,  167,  -19,  -19,  -19,  181,  -19,  -19,  -19,  -19,
 /*    60 */   -19,   54,  -19,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */    72,   71,   65,  107,   72,   66,   72,   67,   72,   69,
 /*    10 */    72,   70,   71,   73,   76,   89,  101,  107,  103,  107,
 /*    20 */   105,   90,   93,  107,  107,   94,  100,   99,   95,  102,
 /*    30 */    96,  107,  104,   97,  107,  106,   72,   71,   98,   74,
 /*    40 */    88,   75,  107,   77,   85,   91,   92,  107,  107,   78,
 /*    50 */    86,  107,   80,   82,   84,  107,   79,   81,   83,   89,
 /*    60 */    90,   72,   68,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  ParseARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

/* Prototype this here so we can call it from a rule action (ick). */
static void yy_parse_failed(yyParser *);

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;

/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}

/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "ERROR",         "NOT",           "OR",          
  "XOR",           "AND",           "NEAR",          "ADJ",         
  "LOVE",          "HATE",          "TERM",          "PHR_TERM",    
  "WILD_TERM",     "BOOLEAN_FILTER",  "QUOTE",         "BRA",         
  "KET",           "error",         "query",         "expr",        
  "prob_expr",     "bool_arg",      "prob",          "term",        
  "stop_term",     "stop_prob",     "compound_term",  "phrase",      
  "phrased_term",  "near_expr",     "adj_expr",    
};

/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "query ::= expr",
 /*   1 */ "query ::=",
 /*   2 */ "expr ::= prob_expr",
 /*   3 */ "expr ::= bool_arg AND bool_arg",
 /*   4 */ "expr ::= bool_arg NOT bool_arg",
 /*   5 */ "expr ::= bool_arg AND NOT bool_arg",
 /*   6 */ "expr ::= bool_arg OR bool_arg",
 /*   7 */ "expr ::= bool_arg XOR bool_arg",
 /*   8 */ "bool_arg ::= expr",
 /*   9 */ "bool_arg ::=",
 /*  10 */ "prob_expr ::= prob",
 /*  11 */ "prob_expr ::= term",
 /*  12 */ "prob ::= stop_term stop_term",
 /*  13 */ "prob ::= prob stop_term",
 /*  14 */ "prob ::= LOVE term",
 /*  15 */ "prob ::= stop_prob LOVE term",
 /*  16 */ "prob ::= HATE term",
 /*  17 */ "prob ::= stop_prob HATE term",
 /*  18 */ "prob ::= HATE BOOLEAN_FILTER",
 /*  19 */ "prob ::= stop_prob HATE BOOLEAN_FILTER",
 /*  20 */ "prob ::= BOOLEAN_FILTER",
 /*  21 */ "prob ::= stop_prob BOOLEAN_FILTER",
 /*  22 */ "prob ::= LOVE BOOLEAN_FILTER",
 /*  23 */ "prob ::= stop_prob LOVE BOOLEAN_FILTER",
 /*  24 */ "stop_prob ::= prob",
 /*  25 */ "stop_prob ::= stop_term",
 /*  26 */ "stop_term ::= TERM",
 /*  27 */ "stop_term ::= compound_term",
 /*  28 */ "term ::= TERM",
 /*  29 */ "term ::= compound_term",
 /*  30 */ "compound_term ::= WILD_TERM",
 /*  31 */ "compound_term ::= QUOTE phrase QUOTE",
 /*  32 */ "compound_term ::= phrased_term",
 /*  33 */ "compound_term ::= near_expr",
 /*  34 */ "compound_term ::= adj_expr",
 /*  35 */ "compound_term ::= BRA expr KET",
 /*  36 */ "phrase ::= TERM",
 /*  37 */ "phrase ::= phrase TERM",
 /*  38 */ "phrased_term ::= TERM PHR_TERM",
 /*  39 */ "phrased_term ::= phrased_term PHR_TERM",
 /*  40 */ "near_expr ::= TERM NEAR TERM",
 /*  41 */ "near_expr ::= near_expr NEAR TERM",
 /*  42 */ "adj_expr ::= TERM ADJ TERM",
 /*  43 */ "adj_expr ::= adj_expr ADJ TERM",
};

/*
** This function returns the symbolic name associated with a token
** value.
*/
static const char *ParseTokenName(int tokenType){
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
  return "";
}
#endif /* NDEBUG */

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** None.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
static void *ParseAlloc(){
  yyParser *pParser;
  pParser = (yyParser*)malloc( sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
#line 636 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{delete (yypminor->yy0);}
#line 1053 "queryparser_internal.cc"
      break;
    case 19:
    case 20:
    case 21:
    case 23:
    case 24:
    case 26:
#line 693 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{delete (yypminor->yy53);}
#line 1063 "queryparser_internal.cc"
      break;
    case 22:
    case 25:
#line 775 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{delete (yypminor->yy12);}
#line 1069 "queryparser_internal.cc"
      break;
    case 27:
    case 28:
    case 29:
    case 30:
#line 950 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{(yypminor->yy11)->destroy();}
#line 1077 "queryparser_internal.cc"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = (YYCODETYPE)yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** A pointer to the parser.  This should be a pointer
** obtained from ParseAlloc.
*/
static void ParseFree(
  void *p                     /* The parser to be deleted */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  free((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     ParseARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     ParseARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 18, 1 },
  { 18, 0 },
  { 19, 1 },
  { 19, 3 },
  { 19, 3 },
  { 19, 4 },
  { 19, 3 },
  { 19, 3 },
  { 21, 1 },
  { 21, 0 },
  { 20, 1 },
  { 20, 1 },
  { 22, 2 },
  { 22, 2 },
  { 22, 2 },
  { 22, 3 },
  { 22, 2 },
  { 22, 3 },
  { 22, 2 },
  { 22, 3 },
  { 22, 1 },
  { 22, 2 },
  { 22, 2 },
  { 22, 3 },
  { 25, 1 },
  { 25, 1 },
  { 24, 1 },
  { 24, 1 },
  { 23, 1 },
  { 23, 1 },
  { 26, 1 },
  { 26, 3 },
  { 26, 1 },
  { 26, 1 },
  { 26, 1 },
  { 26, 3 },
  { 27, 1 },
  { 27, 2 },
  { 28, 2 },
  { 28, 2 },
  { 29, 3 },
  { 29, 3 },
  { 30, 3 },
  { 30, 3 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
#line 679 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    // Save the parsed query in the State structure so we can return it.
    state->query = *yymsp[0].minor.yy53;
    delete yymsp[0].minor.yy53;
}
#line 1335 "queryparser_internal.cc"
        break;
      case 1:
#line 685 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    // Handle a query string with no terms in.
    state->query = Query();
}
#line 1343 "queryparser_internal.cc"
        break;
      case 2:
      case 8:
#line 696 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{ yygotominor.yy53 = yymsp[0].minor.yy53; }
#line 1349 "queryparser_internal.cc"
        break;
      case 3:
#line 699 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{ BOOL_OP_TO_QUERY(yygotominor.yy53, yymsp[-2].minor.yy53, Query::OP_AND, yymsp[0].minor.yy53, "AND");   yy_destructor(5,&yymsp[-1].minor);
}
#line 1355 "queryparser_internal.cc"
        break;
      case 4:
#line 702 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{ BOOL_OP_TO_QUERY(yygotominor.yy53, yymsp[-2].minor.yy53, Query::OP_AND_NOT, yymsp[0].minor.yy53, "NOT");   yy_destructor(2,&yymsp[-1].minor);
}
#line 1361 "queryparser_internal.cc"
        break;
      case 5:
#line 705 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{ BOOL_OP_TO_QUERY(yygotominor.yy53, yymsp[-3].minor.yy53, Query::OP_AND_NOT, yymsp[0].minor.yy53, "AND NOT");   yy_destructor(5,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[-1].minor);
}
#line 1368 "queryparser_internal.cc"
        break;
      case 6:
#line 708 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{ BOOL_OP_TO_QUERY(yygotominor.yy53, yymsp[-2].minor.yy53, Query::OP_OR, yymsp[0].minor.yy53, "OR");   yy_destructor(3,&yymsp[-1].minor);
}
#line 1374 "queryparser_internal.cc"
        break;
      case 7:
#line 711 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{ BOOL_OP_TO_QUERY(yygotominor.yy53, yymsp[-2].minor.yy53, Query::OP_XOR, yymsp[0].minor.yy53, "XOR");   yy_destructor(4,&yymsp[-1].minor);
}
#line 1380 "queryparser_internal.cc"
        break;
      case 9:
#line 720 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    // Set the argument to NULL, which enables the bool_arg-using rules in
    // expr above to report uses of AND, OR, etc which don't have two
    // arguments.
    yygotominor.yy53 = NULL;
}
#line 1390 "queryparser_internal.cc"
        break;
      case 10:
#line 732 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy53 = new Query(yymsp[0].minor.yy12->query);
    // Handle any "+ terms".
    if (!yymsp[0].minor.yy12->love.empty()) {
	if (yygotominor.yy53->empty()) {
	    *yygotominor.yy53 = yymsp[0].minor.yy12->love;
	} else {
	    *yygotominor.yy53 = Query(Query::OP_AND_MAYBE, yymsp[0].minor.yy12->love, *yygotominor.yy53);
	}
    }
    // Handle any "- terms".
    if (!yymsp[0].minor.yy12->hate.empty()) {
	if (yygotominor.yy53->empty()) {
	    delete yygotominor.yy53;
	    // Can't just hate!
	    yy_parse_failed(yypParser);
	    return;
	}
	*yygotominor.yy53 = Query(Query::OP_AND_NOT, *yygotominor.yy53, yymsp[0].minor.yy12->hate);
    }
    // Handle any boolean filters.
    if (!yymsp[0].minor.yy12->filter.empty()) {
	if (yygotominor.yy53->empty()) {
	    *yygotominor.yy53 = yymsp[0].minor.yy12->filter;
	    // FIXME and make the query boolean somehow...
	} else {
	    *yygotominor.yy53 = Query(Query::OP_FILTER, *yygotominor.yy53, yymsp[0].minor.yy12->filter);
	}
    }
    // FIXME what if yygotominor.yy53->empty() (all terms are stopwords)?
    delete yymsp[0].minor.yy12;
}
#line 1426 "queryparser_internal.cc"
        break;
      case 11:
      case 27:
      case 29:
#line 765 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy53 = yymsp[0].minor.yy53;
}
#line 1435 "queryparser_internal.cc"
        break;
      case 12:
#line 777 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy12 = new ProbQuery;
    yygotominor.yy12->query = *yymsp[-1].minor.yy53;
    delete yymsp[-1].minor.yy53;
    if (!yymsp[0].minor.yy53->empty())
	add_to_query(yygotominor.yy12->query, state->default_op(), *yymsp[0].minor.yy53);
    delete yymsp[0].minor.yy53;
}
#line 1447 "queryparser_internal.cc"
        break;
      case 13:
#line 786 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy12 = yymsp[-1].minor.yy12;
    // If yymsp[0].minor.yy53 is a stopword, there's nothing to do here.
    if (!yymsp[0].minor.yy53->empty())
	add_to_query(yygotominor.yy12->query, state->default_op(), *yymsp[0].minor.yy53);
    delete yymsp[0].minor.yy53;
}
#line 1458 "queryparser_internal.cc"
        break;
      case 14:
#line 794 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy12 = new ProbQuery;
    if (state->default_op() == Query::OP_AND) {
	yygotominor.yy12->query = *yymsp[0].minor.yy53;
    } else {
	yygotominor.yy12->love = *yymsp[0].minor.yy53;
    }
    delete yymsp[0].minor.yy53;
  yy_destructor(8,&yymsp[-1].minor);
}
#line 1472 "queryparser_internal.cc"
        break;
      case 15:
#line 804 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy12 = yymsp[-2].minor.yy12;
    if (state->default_op() == Query::OP_AND) {
	/* The default op is AND, so we just put loved terms into the query
	 * (in this case the only effect of love is to ignore the stopword
	 * list). */
	add_to_query(yygotominor.yy12->query, Query::OP_AND, *yymsp[0].minor.yy53);
    } else {
	add_to_query(yygotominor.yy12->love, Query::OP_AND, *yymsp[0].minor.yy53);
    }
    delete yymsp[0].minor.yy53;
  yy_destructor(8,&yymsp[-1].minor);
}
#line 1489 "queryparser_internal.cc"
        break;
      case 16:
#line 817 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy12 = new ProbQuery;
    yygotominor.yy12->hate = *yymsp[0].minor.yy53;
    delete yymsp[0].minor.yy53;
  yy_destructor(9,&yymsp[-1].minor);
}
#line 1499 "queryparser_internal.cc"
        break;
      case 17:
#line 823 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy12 = yymsp[-2].minor.yy12;
    add_to_query(yygotominor.yy12->hate, Query::OP_OR, *yymsp[0].minor.yy53);
    delete yymsp[0].minor.yy53;
  yy_destructor(9,&yymsp[-1].minor);
}
#line 1509 "queryparser_internal.cc"
        break;
      case 18:
#line 829 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy12 = new ProbQuery;
    yygotominor.yy12->hate = yymsp[0].minor.yy0->as_query_object();
    delete yymsp[0].minor.yy0;
  yy_destructor(9,&yymsp[-1].minor);
}
#line 1519 "queryparser_internal.cc"
        break;
      case 19:
#line 835 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy12 = yymsp[-2].minor.yy12;
    add_to_query(yygotominor.yy12->hate, Query::OP_OR, yymsp[0].minor.yy0->as_query_object());
    delete yymsp[0].minor.yy0;
  yy_destructor(9,&yymsp[-1].minor);
}
#line 1529 "queryparser_internal.cc"
        break;
      case 20:
#line 841 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy12 = new ProbQuery;
    yygotominor.yy12->filter = yymsp[0].minor.yy0->as_query_object();
    delete yymsp[0].minor.yy0;
}
#line 1538 "queryparser_internal.cc"
        break;
      case 21:
#line 847 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy12 = yymsp[-1].minor.yy12;
    // FIXME we should OR filters with the same prefix...
    add_to_query(yygotominor.yy12->filter, Query::OP_AND, yymsp[0].minor.yy0->as_query_object());
    delete yymsp[0].minor.yy0;
}
#line 1548 "queryparser_internal.cc"
        break;
      case 22:
#line 854 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    // LOVE BOOLEAN_FILTER(yymsp[0].minor.yy0) is just the same as BOOLEAN_FILTER
    yygotominor.yy12 = new ProbQuery;
    yygotominor.yy12->filter = yymsp[0].minor.yy0->as_query_object();
    delete yymsp[0].minor.yy0;
  yy_destructor(8,&yymsp[-1].minor);
}
#line 1559 "queryparser_internal.cc"
        break;
      case 23:
#line 861 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    // LOVE BOOLEAN_FILTER(yymsp[0].minor.yy0) is just the same as BOOLEAN_FILTER
    yygotominor.yy12 = yymsp[-2].minor.yy12;
    // FIXME we should OR filters with the same prefix...
    add_to_query(yygotominor.yy12->filter, Query::OP_AND, yymsp[0].minor.yy0->as_query_object());
    delete yymsp[0].minor.yy0;
  yy_destructor(8,&yymsp[-1].minor);
}
#line 1571 "queryparser_internal.cc"
        break;
      case 24:
#line 875 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{ yygotominor.yy12 = yymsp[0].minor.yy12; }
#line 1576 "queryparser_internal.cc"
        break;
      case 25:
#line 877 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy12 = new ProbQuery;
    yygotominor.yy12->query = *yymsp[0].minor.yy53;
    delete yymsp[0].minor.yy53;
}
#line 1585 "queryparser_internal.cc"
        break;
      case 26:
#line 892 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    if (state->is_stopword(yymsp[0].minor.yy0)) {
	yygotominor.yy53 = new Query;
	state->add_to_stoplist(yymsp[0].minor.yy0);
    } else {
	yygotominor.yy53 = yymsp[0].minor.yy0->as_query();
    }
    delete yymsp[0].minor.yy0;
}
#line 1598 "queryparser_internal.cc"
        break;
      case 28:
#line 911 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy53 = yymsp[0].minor.yy0->as_query();
    delete yymsp[0].minor.yy0;
}
#line 1606 "queryparser_internal.cc"
        break;
      case 30:
#line 926 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy53 = yymsp[0].minor.yy0->as_wildcarded_query(state);
    delete yymsp[0].minor.yy0;
}
#line 1614 "queryparser_internal.cc"
        break;
      case 31:
#line 932 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{ yygotominor.yy53 = yymsp[-1].minor.yy11->as_phrase_query();   yy_destructor(14,&yymsp[-2].minor);
  yy_destructor(14,&yymsp[0].minor);
}
#line 1621 "queryparser_internal.cc"
        break;
      case 32:
#line 935 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{ yygotominor.yy53 = yymsp[0].minor.yy11->as_phrase_query(); }
#line 1626 "queryparser_internal.cc"
        break;
      case 33:
#line 938 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{ yygotominor.yy53 = yymsp[0].minor.yy11->as_near_query(); }
#line 1631 "queryparser_internal.cc"
        break;
      case 34:
#line 941 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{ yygotominor.yy53 = yymsp[0].minor.yy11->as_adj_query(); }
#line 1636 "queryparser_internal.cc"
        break;
      case 35:
#line 944 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{ yygotominor.yy53 = yymsp[-1].minor.yy53;   yy_destructor(15,&yymsp[-2].minor);
  yy_destructor(16,&yymsp[0].minor);
}
#line 1643 "queryparser_internal.cc"
        break;
      case 36:
#line 952 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy11 = new TermList;
    yygotominor.yy11->add_term(yymsp[0].minor.yy0);
}
#line 1651 "queryparser_internal.cc"
        break;
      case 37:
      case 39:
#line 957 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy11 = yymsp[-1].minor.yy11;
    yygotominor.yy11->add_term(yymsp[0].minor.yy0);
}
#line 1660 "queryparser_internal.cc"
        break;
      case 38:
#line 969 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy11 = new TermList;
    yygotominor.yy11->add_term(yymsp[-1].minor.yy0);
    yygotominor.yy11->add_term(yymsp[0].minor.yy0);
}
#line 1669 "queryparser_internal.cc"
        break;
      case 40:
      case 42:
#line 986 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy11 = new TermList;
    yygotominor.yy11->add_term(yymsp[-2].minor.yy0);
    yygotominor.yy11->add_term(yymsp[0].minor.yy0);
    if (yymsp[-1].minor.yy0) {
	yygotominor.yy11->adjust_window(yymsp[-1].minor.yy0->get_termpos());
	delete yymsp[-1].minor.yy0;
    }
}
#line 1683 "queryparser_internal.cc"
        break;
      case 41:
      case 43:
#line 996 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"
{
    yygotominor.yy11 = yymsp[-2].minor.yy11;
    yygotominor.yy11->add_term(yymsp[0].minor.yy0);
    if (yymsp[-1].minor.yy0) {
	yygotominor.yy11->adjust_window(yymsp[-1].minor.yy0->get_termpos());
	delete yymsp[-1].minor.yy0;
    }
}
#line 1696 "queryparser_internal.cc"
        break;
  }
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
#line 640 "/u1/olly/xapian-svn-snapshot/tags/0.9.9/xapian/xapian-core/queryparser/queryparser.lemony"

    // If we've not already set an error message, set a default one.
    if (!state->error) state->error = "parse error";
#line 1730 "queryparser_internal.cc"
  ParseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  ParseARG_FETCH;
  (void)yymajor;
  (void)yyminor;
#define TOKEN (yyminor.yy0)
  ParseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  ParseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
static void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  ParseARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor((YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor((YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor((YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
