.\" $Id: xboard.man,v 1.98 2001/12/09 23:02:59 mann Exp $
.TH xboard 6 "$Date: 2001/12/09 23:02:59 $" "GNU"
.SH NAME
.PP
xboard \- X user interface for GNU Chess, Crafty, the Internet Chess Server (ICS),
and electronic mail correspondence chess.
.SH SYNOPSIS
.PP
To run with GNU Chess:
.B xboard [options]
.br
To run with Crafty:
.B xboard -fcp crafty -fd \fIcrafty's-directory\fB [options]
.br
To run with the ICS:
.B xboard -ics -icshost hostname [options]
.br
To play email chess: See
.BR cmail (6).
.br
To run standalone:
.B xboard -ncp [options]
.br
To use in a pipeline:
.B |pxboard
.SH DESCRIPTION
.PP
.BR xboard
is a graphical chessboard that can serve as a
user interface to the GNU Chess and Crafty chess engines, the
Internet Chess Servers,
electronic mail correspondence chess, or your own collection of saved games.
.PP
As an interface to GNU Chess or Crafty,
xboard
lets you play a game against the machine,
set up arbitrary positions,
force variations, or watch
a game between two machines.
.PP
As an interface to Crafty,
xboard
also lets you interactively analyze your stored games
or set up and analyze arbitrary positions.
.PP
As an interface to the Internet Chess Server (ICS),
.B xboard -ics
lets you play against other ICS users,
observe games they are playing, or review
games that have recently finished.  
Most of the "wild" chess variants on ICS are supported,
including bughouse.
.PP
As an interface to electronic mail correspondence chess,
xboard
works with the
.BR cmail (6)
program.  See its manual page for instructions.
.PP
You can also use
xboard
as a chessboard to play through games.
It will read and write game files and allow you to play 
through variations manually.
You can use it to browse games off the net
or review games you have saved.  
These features are available at all times; if you want to use
them without starting a chess engine or connecting to the ICS,
you can do so with the command
.BR "xboard -ncp" .
.PP
To view games from a netnews reader like
.BR rn (1)
or
.BR xrn (1),
use the news reader's Save command and specify "|pxboard"
as the save
file name.  This pipes the article to 
.BR pxboard ,
a simple shell script that saves the article to a temporary file and runs
xboard
in the background.  See the script itself for more information.
.PP
To move a piece, either drag it with the left mouse button,
or click the left mouse button once on the piece, then once more on
the destination square.
To drop a new piece on a square (when applicable),
press button 2 or 3 over the square and select from the popup menu.
.PP
When
xboard
is iconized, its graphical icon is a white knight if it is White's turn to
move, a black knight if it is Black's turn.  See 
.B Iconize
below if you have problems getting this feature to work.
.SH MENU COMMANDS, BUTTONS, AND KEYS
.PP
All 
xboard
commands are available on menus.  The most frequently used
commands also have shortcut keys or on-screen buttons.
.SH File Menu
.TP 8
.B Reset
Resets
xboard
and the chess engine to the beginning of a new chess game.
The "r" key is a keyboard equivalent.
In Internet Chess Server mode, clears the current state of 
xboard,
then resynchronizes with ICS by sending a 
.IR refresh
command.
If you want to stop playing, observing, or examining a game 
on ICS, use an appropriate command from the 
Action menu, not Reset.
.TP 8
.B Load Game
Plays a game from a record file.
The "g" key is a keyboard equivalent.
A popup dialog prompts you for the file name.
If the file contains more than one game, a second popup dialog displays
a list of games (with information drawn from their PGN tags, if any), and you
can select the one you want.
Alternatively, you can load the 
.IR N th
game in the file directly from the file name dialog, by typing the number
.IR N 
after the file name, separated by a space.

The game file parser will accept PGN (portable game notation), or
in fact almost any file that contains moves in algebraic notation.
Notation of the form "P@f7" is accepted for piece-drops in bughouse games;
this is a nonstandard extension to PGN.
If the file includes a PGN position (FEN tag), or an old-style
xboard
position diagram
bracketed by "[--" and "--]" before the
first move, the game starts from that position.
Text enclosed in parentheses, square brackets, or curly braces 
is assumed to be commentary and is displayed in a pop-up window.
Any other text in the file is ignored.  PGN variations (enclosed in 
parentheses) are treated as comments; 
xboard
is not able to walk variation trees.
The nonstandard PGN tag [Variant "varname"] functions similarly to
the -variant command-line option (see below), allowing games in certain chess
variants to be loaded.  There is also a heuristic to 
recognize chess variants from the Event tag, by looking for the strings
that the Internet Chess Servers put there when saving variant ("wild") games.
.TP 8
.B Load Next Game
Loads the next game from the last game record file you loaded.
The shifted "N" key is a keyboard equivalent.
.TP 8
.B Load Previous Game
Loads the previous game from the last game record file you loaded.
The shifted "P" key is a keyboard equivalent.
Not available if the last game was loaded from a pipe.
.TP 8
.B Reload Same Game
Reloads the last game you loaded.
Not available if the last game was loaded from a pipe.
.TP 8
.B Save Game
Appends a record of the current game to a file.
A popup dialog prompts you for the file name.
If the game did not begin with the standard starting position,
the game file includes the starting position used.
Games are saved in the PGN (portable game notation) format,
unless the oldSaveStyle option is
True, in which case they are saved in an older format that is specific to 
xboard.
Both formats are human-readable, and both can be read back by the Load Game 
command. 
Notation of the form "P@f7" is generated for piece-drops in bughouse games;
this is a nonstandard extension to PGN.
.TP 8
.B Copy Game
Copies a record of the current game to an internal clipboard in PGN
format and sets the X selection to the game text.  The game can be
pasted to another application (such as a text editor or another copy
of xboard) using that application's paste command.  In many X
applications, such as xterm and emacs, the middle mouse button can be
used for pasting; in xboard, you must use the Paste Game command.
.TP 8
.B Paste Game
Interprets the current X selection as a game record and loads it, as
with Load Game.
.TP 8
.B Load Position
Sets up a position from a position file.
A popup dialog prompts you for the file name.
If the file contains more than one saved position, and you want
to load the 
.IR N th
one, type the number 
.IR N 
after the file name, separated by a space.
Position files must be in FEN (Forsythe-Edwards notation), or in the format
that the Save Position command writes when oldSaveStyle is turned on.
.TP 8
.B Load Next Position
Loads the next position from the last position file you loaded.
.TP 8
.B Load Previous Position
Loads the previous position from the last position file you loaded.
Not available if the last position was loaded from a pipe.
.TP 8
.B Reload Same Position
Reloads the last position you loaded.
Not available if the last position was loaded from a pipe.
.TP 8
.B Save Position
Appends a diagram of the current position to a file.
A popup dialog prompts you for the file name.
Positions are saved in FEN (Forsythe-Edwards notation) format unless
the oldSaveStyle option is True, in which case they are saved in an older,
human-readable format that is specific to 
xboard.
Both formats can be read back by the Load Position command.
.TP 8
.B Copy Position
Copies the current position to an internal clipboard in FEN format and
sets the X selection to the position text.  The position can be pasted
to another application (such as a text editor or another copy of
xboard) using that application's paste command.  In many X
applications, such as xterm and emacs, the middle mouse button can be
used for pasting; in xboard, you must use the Paste Position command.
.TP 8
.B Paste Position
Interprets the current X selection as a FEN position and loads it, as
with Load Position.
.TP 8
.B Mail Move
.PD 0
.TP 8
.B Reload CMail Message
See the manual page for
.BR cmail (6).
.PD
.TP 8
.B Exit
Exits from
xboard.
The shifted "Q" key is a keyboard equivalent.
.SH Mode Menu
.TP 8
.B Machine White
Tells the chess engine to play White.
.TP 8
.B Machine Black
Tells the chess engine to play Black.
.TP 8
.B Two Machines
Plays a game between two chess engines.
.TP 8
.B Analysis Mode
Puts XBoard in analysis mode on the current edited position or game.
This mode requires that you use a chess engine that supports analysis,
such as Crafty; GNU Chess will not work.
See the manual section
GETTING CRAFTY
for more information on getting and installing Crafty.
.TP 8
.B Analyze File
This mode lets you load a game from a file (PGN, etc.) and use a chess engine
to interactively analyze it. 
This mode requires that you use a chess engine that supports analysis,
such as Crafty; GNU Chess will not work.
See the manual section
GETTING CRAFTY
for more information on getting and installing Crafty.
.TP 8
.B ICS Client
This is the normal mode when
.I xboard
is connected to a chess server.  If you have moved into
Edit Game or Edit Position mode, you can select this option to get out.

To use xboard in ICS mode, run it in the foreground with the -ics
option, and use the
terminal you started it from to type commands and receive text responses
from the chess server.  Useful ICS commands include
.IR who
to see who is logged on,
.IR games
to see what games are being played,
.IR match
to challenge another player to a game,
.IR observe
to observe an ongoing game,
.IR examine
or
.IR oldmoves
to review a recently completed game,
and of course
.IR help .

Some special 
xboard
features are activated when you are in 
.IR examine 
or
.IR bsetup
mode on ICS.  See the descriptions of the menu commands
Forward, Backward, Pause, ICS Client, and Stop Examining below.
You can also issue the ICS position-editing commands with the mouse.  
Move pieces by dragging with mouse button 1.
To drop a new piece on a square, press mouse button 2 or 3
over the square.  This brings up a menu of white pieces (button 2) or black
pieces (button 3).  Additional menu choices let you empty the square or
clear the board.  Click on the White or Black clock to set the side to play.
You cannot set the side to play or drag pieces to arbitrary squares while
examining on ICC, but you can do so in bsetup mode on FICS.

If you are playing a bughouse game on the ICS, you can drop an offboard piece
by pressing mouse button 2 or 3 over an empty square to bring up a piece menu.
It makes no difference which button you use.  A list of the offboard pieces
each player has available is shown in the window title after the player's name.
.TP 8
.B Edit Game
Allows you to make moves for both Black and White, and
to change moves after backing up with the Backward command.
The clocks do not run.

In chess engine mode, the chess engine continues to check moves for
legality but does not participate in the game.  You can bring the
chess engine back into the game by selecting Machine White, Machine Black, 
or Two Machines.

In ICS mode, the moves are not sent to the ICS:
Edit Game takes 
xboard
out of ICS Client mode and lets you edit games locally.
If you want to edit
games on ICS in a way that other ICS users can see,
use the ICS
.IR examine
command or start an ICS match against yourself.
.TP 8
.B Edit Position
Lets you set up an arbitrary board position.
Use mouse button 1 to drag pieces to new squares, or to
delete a piece by dragging it off the board or dragging an empty square
on top of it.  To drop a new piece on a square, press mouse button 2 or 3
over the square.  This brings up a menu of white pieces (button 2) or black
pieces (button 3).  Additional menu choices let you empty the square or
clear the board.  You can set the side to play next
by clicking on the White or Black indicator at the top of the screen.
Selecting Edit Position causes 
xboard
to discard all remembered moves in the current game.

In ICS mode, changes made to the position by Edit Position
are not sent to the ICS:  Edit Position takes 
xboard
out of ICS Client mode and lets you edit positions locally.
If you want to edit
positions on ICS in a way that other ICS users can see,
use the ICS
.IR examine
command, or start an ICS match against yourself.  
(See also the ICS Client topic above.)
.TP 8
.B Training
Training mode lets you interactively guess the moves of a game for one
of the players. You guess the next move of the game by playing the
move on the board. If the move played matches the next move of the
game, the move is accepted and the opponent's response is autoplayed.
If the move played is incorrect, an error message is displayed.  You
can select this mode only while loading a game (that is, after
selecting Load Game from the File menu).  While xboard is in Training
mode, the navigation buttons are disabled.
.TP 8
.B Show Game List
Shows or hides the list of games generated by the last Load Game command.
.TP 8
.B Edit Tags
Lets you edit the PGN (portable game notation)
tags for the current game.  After editing, the tags must still conform to
the PGN tag syntax:

.nf
    <tag-section> ::= <tag-pair> <tag-section>
		      <empty>
    <tag-pair> ::= [ <tag-name> <tag-value> ]
    <tag-name> ::= <identifier>
    <tag-value> ::= <string>
.fi

See the PGN Standard for full details.  Here is an example:

.nf
    [Event "Portoroz Interzonal"]
    [Site "Portoroz, Yugoslavia"]
    [Date "1958.08.16"]
    [Round "8"]
    [White "Robert J. Fischer"]
    [Black "Bent Larsen"]
    [Result "1-0"]
.fi

Any characters that do not match this syntax are silently ignored.  Note that
the PGN standard requires all games to have at least the seven tags shown
above.  Any that you omit will be filled in by
xboard
with "?" (unknown value), or "-" (inapplicable value).
.TP 8
.B Edit Comment
Adds or modifies a comment on the current position.  Comments are
saved by Save Game and are displayed by Load Game, Forward, and Backward.
.TP 8
.B ICS Input Box
If this mode is on in ICS mode,
xboard
creates an extra window that you can use for typing in ICS commands.
The input box is especially useful if you want to type in something long or do
some editing on your input, because output from ICS doesn't get mixed
in with your typing as it would in the main terminal window.
.TP 8
.B Pause
Pauses updates to the board, and if you are playing
against a local chess engine, also pauses your clock.
To continue, select Pause again, and the display will automatically
update to the latest position.
The [P] button and keyboard "p" key are equivalents.

If you select Pause when you are playing against a local chess engine and
it is not your move, the engine's clock
will continue to run and it will eventually make a move, at which point
both clocks will stop.  Since board updates are paused, however,
you will not see the move until you exit from Pause mode (or select Forward).
This behavior is meant to simulate adjournment with a sealed move.

If you select Pause while you are in 
.IR examine
mode on ICS, you can step
backward and forward in the current history of the examined game without
affecting the other observers and examiners.  Select Pause again to reconnect
yourself to the current state of the game on ICS.

If you select Pause while you are loading a game, the 
game stops loading.
You can load more moves manually by selecting Forward, or resume automatic
loading by selecting Pause again.
.SH Action Menu
.TP 8
.B Accept
Accepts a pending ICS match offer.
If there is more than one offer pending, you will have to type in a more
specific command instead of using this menu choice.
.TP 8
.B Decline
Declines a pending ICS offer (match, draw, adjourn, etc.).
If there is more than one offer pending, you will have to type in a more
specific command instead of using this menu choice.
.TP 8
.B Call Flag
Calls your opponent's flag, claiming a win on time, or claiming a draw
if you are both out of time.  You can also call your opponent's flag
by clicking on his clock or by pressing the keyboard "t" key.
.TP 8
.B Draw
Offers a draw to your opponent, accepts a pending draw offer
from your opponent, or claims a draw by repetition or the 50-move 
rule, as appropriate.  The "d" key is a keyboard equivalent.
.TP 8
.B Adjourn
Asks your opponent to agree to adjourning the current game, or
agrees to a pending adjournment offer from your opponent.
.TP 8
.B Abort
Asks your opponent to agree to aborting the current game, or
agrees to a pending abort offer from your opponent.
An aborted ICS game ends immediately without affecting either player's rating.
.TP 8
.B Resign
Resigns the game to your opponent.  The shifted "R" key is a keyboard
equivalent. 
.TP 8
.B Stop Observing
Ends your participation in observing a game, by issuing the ICS
.IR observe
command with no arguments.
.TP 8
.B Stop Examining
Ends your participation in examining a game, by issuing the ICS
.IR unexamine
command.
.SH Step Menu
.TP 8
.B Backward
Steps backward through a series of remembered moves.
The [<] button and the "b" key are equivalents.
In addition, pressing the Control key steps back one move, and releasing
it steps forward again.

In most modes, Backward only lets you look back at 
old positions; it does not retract moves.
This is the case if you are playing against a local chess engine, playing or
observing a game on the ICS, or loading a game.  If you select Backward in any
of these situations, you will not be allowed to make a different move.
Use Retract Move or Edit Game if you want to change past moves.

If you are examining a game on ICS, the behavior of
Backward depends on whether 
xboard
is in Pause mode.
If Pause mode is off, Backward issues the ICS 
.IR backward
command, which
backs up everyone's view of the game and allows you to make a different move.
If Pause mode is on, Backward only backs up your local view.
.TP 8
.B Forward
Steps forward through a series of remembered moves (undoing the effect of
Backward) or forward through a game file.
The [>] button and the f key are equivalents.

If you are examining a game on ICS, the behavior of
Forward depends on whether 
xboard
is in Pause mode.
If Pause mode is off, Forward issues the ICS 
.IR forward
command, which
moves everyone's view of the game forward along the current line.
If Pause mode is on, Forward only moves your local view forward, and it
will not go past the position that the game was in when you paused.
.TP 8
.B Back to Start
Jumps backward to the first remembered position in the game.
The [<<] button and the shifted "B" key are equivalents.

In most modes, Back to Start only lets you look back at 
old positions; it does not retract moves.
This is the case if you are playing against a local chess engine, playing or
observing a game on the ICS, or loading a game.  If you select Back to
Start in any
of these situations, you will not be allowed to make different moves.
Use Retract Move or Edit Game if you want to change past moves; or
use Reset to start a new game.

If you are examining a game on ICS, the behavior of
Back to Start depends on whether 
xboard
is in Pause mode.
If Pause mode is off, Back to Start issues the ICS 
.I backward 999999
command, which
backs up everyone's view of the game to the start and allows you to make
different moves.
If Pause mode is on, Back to Start only backs up your local view.
.TP 8
.B Forward to End
Jumps forward to the last remembered position in the game.
The [>>] button and the shifted "F" key are equivalents.

If you are examining a game on ICS, the behavior of
Forward to End depends on whether 
xboard
is in Pause mode.
If Pause mode is off, Forward to End issues the ICS 
.I forward 999999
command, which moves everyone's view of the game forward to the end
of the current line.  
If Pause mode is on, Forward to End only moves your local view forward, and it
will not go past the position that the game was in when you paused.
.TP 8
.B Revert
If you are examining a game on ICS and Pause mode is off, 
issues the ICS command
.IR revert .
.TP 8
.B Truncate Game
Discards all remembered moves of the game beyond the current position.
Puts 
xboard
into Edit Game mode if it was not there already.
.TP 8
.B Move Now
Forces the chess engine to move immediately.  May not work with all
chess engines.
.TP 8
.B Retract Move
Retracts your last move.  
When playing a local chess engine, you can do this only after the
engine has replied to your move; if it is still thinking, use Move Now first.
In ICS mode, Retract Move issues the command 
.I takeback 1
or
.I takeback 2
depending on whether it is your opponent's move or yours.
.SH Options Menu
.TP 8
.B Always Queen
If this option is off,
xboard
brings up a dialog box whenever you move a pawn to the last rank,
asking what piece you want to promote it to.  
If the option is on, your pawns are always promoted to
queens.  Your opponent can still underpromote.
.TP 8
.B Animate Dragging
If Animate Dragging is on, while you are dragging a piece with the
mouse, an image of the piece follows the mouse cursor.
If Animate Dragging is off, there is no visual feedback while you are
dragging a piece, but if Animate Moving is on, the move will be
animated when it is complete. 
.TP 8
.B Animate Moving
If Animate Moving is on, all piece moves are animated.  An image of the
piece is shown moving from the old square to the new square when the
move is completed (unless the move was already animated by Animate Dragging).
If Animate Moving is off, a moved piece instantly disappears from its
old square and reappears on its new square when the move is complete.
.TP 8
.B Auto Comment
If this option is on, any remarks made on ICS while you are observing or
playing a game are recorded as a comment on the current move.  This includes
remarks made with the ICS commands
.I say, tell, whisper,
and
.I kibitz.
Limitation: remarks that you type yourself are not recognized;
xboard
scans only the output from ICS, not the input you type to it.
.TP 8
.B Auto Flag
If this option is on and one player runs out of time
before the other,
xboard
will automatically call his flag, claiming a win on time.
In ICS mode, Auto Flag will only call your opponent's flag, not yours,
and the ICS may award you a draw instead of a win if you have
insufficient mating material.  In local chess engine mode,
xboard
may call either player's flag and will not take material into account.
.TP 8
.B Auto Flip View
If the Auto Flip View option is on when you start a game, the board
will be automatically oriented so that your pawns move from the bottom
of the window towards the top.
.TP 8
.B Auto Observe
If this option is on and you add a player to your 
.IR gnotify
list on ICS,
xboard
will automatically observe all of that player's games, unless you are
doing something else (such as observing or playing a game of your own) when
one starts.
The games are displayed 
from the point of view of the player on your gnotify list; that is, his
pawns move from the bottom of the window towards the top.
Exceptions:  If both players in a game are on your gnotify list, if
your ICS 
.IR highlight
variable is set to 0, or if the ICS you are using does not 
properly support observing from Black's point of view,
you will see the game from White's point of view.
.TP 8
.B Auto Raise Board
If this option is on, whenever a new game begins, the chessboard window
is deiconized (if necessary) and raised to the top of the stack of windows.
.TP 8
.B Auto Save
If this option is on, at the end of every game
xboard
prompts you for a file name and appends a record
of the game to the file you specify.  Disabled if the saveGameFile
option is set, as in that case all games are saved to the specified file.
.TP 8
.B Blindfold
If this option is on, xboard displays the board as usual but does
not display pieces or move highlights.  You can still move in the
usual way (with the mouse or by typing moves in ICS mode), even though
the pieces are invisible.
.TP 8
.B Flash Moves
If this option is on, whenever a move is completed, the moved piece flashes.
The number of times to flash is set by the flashCount command-line
option; it defaults to 3 if Flash Moves is first turned on from the menu.
.TP 8
.B Flip View
Inverts your view of the chess board for the duration of the current
game.  Starting a new game returns the board to normal.  
The "v" key is a keyboard equivalent.

If you are
playing a game on the ICS, the board is always
oriented at the start of the game so that your 
pawns move from the bottom of the window towards the top.
Otherwise, the starting orientation is determined by the flipView command line
option; if it is False (the default), White's pawns move from bottom
to top at the start of each game; if it is True, Black's pawns move
from bottom to top.
.TP 8
.B Get Move List
If this option is on, whenever
xboard
receives the first board of a new ICS game (or a different ICS game from
the one it is currently displaying), it
retrieves the list of past moves from the ICS.
You can then review the moves with the Forward and Backward commands
or save them with Save Game.  You might want to
turn off this option if you are observing several blitz games at once,
to keep from wasting time and network bandwidth fetching the move lists over
and over.
When you turn this option on from the menu,
xboard
immediately fetches the move list of the current game (if any).
.TP 8
.B Highlight Last Move
If Highlight Last Move is on, after a move is made, the starting and
ending squares remain highlighted. In addition, after you use Backward
or Back to Start, the starting and ending squares of the last move to
be unmade are highlighted.
.TP 8
.B Move Sound
If this option is on,
xboard
alerts you by playing a sound after each
of your opponent's moves (or after every move if
you are observing a game on the Internet Chess Server).
The sound is not played after moves you make 
or moves read from a saved game file.  By default, the
sound is the terminal bell, but on some systems you can change it
to a sound file using the soundMove option; see below.

If you turn on this option when using
xboard
with the Internet Chess Server, you will probably want to
give the 
.I "set bell 0"
command to the ICS, since otherwise the ICS
will ring the terminal bell after every move.
.TP 8
.B ICS Alarm
When this option is on, an alarm sound is played when your clock
counts down to the icsAlarmTime (by default, 5 seconds) in an ICS
game.  For games with time controls that include an increment, the
alarm will sound each time the clock counts down to the icsAlarmTime.
By default, the alarm sound is the terminal bell, but on some systems
you can change it to a sound file using the soundIcsAlarm option; see
below.
.TP 8
.B Old Save Style
If this option is off,
xboard
saves games in PGN (portable game notation) and positions in FEN
(Forsythe-Edwards notation).  If the option is on,
a save style that is compatible with older versions of
xboard
is used instead.  The old position style is more human-readable than
FEN; the old game style has no particular advantages.
.TP 8
.B Periodic Updates
If this option is off (or if
you are using a chess engine that does not support periodic updates),
the analysis window
will be updated only when the analysis changes. If this option is
on, the Analysis Window will be updated every two seconds.
.TP 8
.B Ponder Next Move
If this option is off, the chess engine will think only when it is on
move.  If the option is on, the engine will also think while waiting
for you to make your move.
.TP 8
.B Popup Exit Message
If this option is on, when xboard wants to display a message just
before exiting, it brings up a modal dialog box and waits for you to
click OK before exiting.  If the option is off, xboard prints the
message to standard error (the terminal) and exits immediately.
.TP 8
.B Popup Move Errors
If this option is off, when you make an error in moving (such as
attempting an illegal move or moving the wrong color piece), the
error message is displayed in the message area.  If the option is
on, move errors are displayed in small popup windows like other errors.
You can dismiss an error popup either by clicking its OK button or by
clicking anywhere on the board, including downclicking to start a move.
.TP 8
.B Premove
If this option is on while playing a game on ICS, you can register
your next planned move before it is your turn.  Move the piece with
the mouse in the ordinary way, and the starting and ending squares
will be highlighted with a special color (red by default).  When it is
your turn, if your registered move is legal, xboard will send it to
ICS immediately; if not, it will be ignored and you can make a
different move.  If you change your mind about your premove, either
make a different move, or double-click on any piece to cancel the move
entirely.
.TP 8
.B Quiet Play
If this option is on,
xboard
will automatically issue an ICS 
.I "set shout 0"
command whenever you start an ICS
game and a 
.I "set shout 1"
command whenever you finish one.  Thus you 
will not be distracted by shouts from other ICS users while playing.
.TP 8
.B Show Coords
If this option is on,
xboard
displays algebraic coordinates along the board's left and bottom edges.
.TP 8
.B Show Thinking
If this option is on, the chess engine's notion of the score and best
line of play
from the current position is displayed as it is thinking.  The score indicates
how many pawns ahead (or if negative, behind) the engine thinks it is.  
When GNU Chess is thinking on your time, this thinking is not shown if GNU
Chess was compiled with the -DQUIETBACKGROUND option.
In matches between two machines, the score is prefixed by W or B to indicate
whether the display is of White's thinking or Black's, and thinking on the
opponent's time is never shown.
.TP 8
.B Test Legality
If this option is on, xboard
tests whether moves you try to make with the mouse are legal, and
refuses to let you make an illegal move.  Moves loaded from a file
with Load Game are also checked.
If the option is off, all moves are accepted, but
if a local chess engine or the ICS is active,
they will still reject illegal moves.  Turning off this option is
useful if you are playing a chess variant with rules that 
xboard
does not understand.  (Bughouse, suicide, and wild variants where
the king may castle after starting on the d file are generally 
supported with Test Legality on.)
.SH Help Menu
.TP 8
.B Info XBoard
Displays the xboard
info file in a new window.  For this feature to work,
you must have the GNU info program installed on your system,
and the file xboard.info must either be present in the current 
working directory, or have been installed by 
the 
.I "make install"
command when you built 
xboard.
.TP 8
.B Man XBoard
Displays this man page in a new window.  For this feature to work,
the file xboard.6 must have been installed by 
the
.I "make install"
command when you built 
xboard,
and the
directory it was placed in must be on the search path for your system's
.BR man (1)
command.
.TP 8
.B Hint
Displays a move hint from the local chess engine.
.TP 8
.B Book
Displays a list of possible moves from the local chess engine's opening book.
The first column gives moves, the second column gives one possible response
for each move, and the third column shows the number of lines in the
book that include the move from the first column.  If you select this option
and nothing happens, the chess engine is out of its book or does not
support this command.
.TP 8
.B About XBoard
Shows the current 
xboard
version number.
.SH Other shortcut keys
.TP 8
.B Iconize
Pressing the i or c key iconizes
xboard.
The graphical icon displays a white knight if it is White's move, or a
black knight if it is Black's move.  If your X window manager displays only
text icons, not graphical ones, check its documentation; there is probably a
way to enable graphical icons.  If you are running the Motif window manager 
.BR mwm (1),
add these lines to your \&.Xdefaults file and restart mwm:

.nf
    Mwm*iconDecoration: activelabel label image
    Mwm*XBoard*iconImageBackground: White
    Mwm*XBoard*iconImageForeground: Black
.fi

The first line above enables graphical icons in 
.BR mwm ;
you don't need it if you already have them.
The next two lines force the white knights to come out white and the black
knights black.  Unfortunately these resources can't be set from inside 
xboard;
you have to set them in your \&.Xdefaults.
.PP
You can add or remove
xboard
shortcut keys
using the X resource 
.IR form.translations .
Here is an example of what would go in your \&.Xdefaults file:

.nf
    XBoard*form.translations: \\
        Shift<Key>?: AboutGameProc() \\n \\
	<Key>y: AcceptProc() \\n \\
	<Key>n: DeclineProc() \\n \\
	<Key>i: NothingProc()
.fi

Binding a key to NothingProc makes it do nothing, thus removing it as a
shortcut key.
The 
xboard
functions that can be bound to keys are: 

.nf
AbortProc, AboutGameProc, AboutProc, AcceptProc,
AdjournProc, AlwaysQueenProc, AnalysisModeProc,
AnalyzeFileProc, AnimateDraggingProc, AnimateMovingProc,
AutobsProc, AutoflagProc, AutoflipProc, AutoraiseProc,
AutosaveProc, BackwardProc, BlindfoldProc, BookProc,
CallFlagProc, CopyGameProc, CopyPositionProc, DebugProc,
DeclineProc, DrawProc, EditCommentProc, EditGameProc,
EditPositionProc, EditTagsProc, EnterKeyProc,
FlashMovesProc, FlipViewProc, ForwardProc,
GetMoveListProc, HighlightLastMoveProc, HintProc,
Iconify, IcsAlarmProc, IcsAlarmProc, IcsClientProc,
IcsInputBoxProc, InfoProc, LoadGameProc,
LoadNextGameProc, LoadNextPositionProc, LoadPositionProc,
LoadPrevGameProc, LoadPrevPositionProc, LoadSelectedProc,
MachineBlackProc, MachineWhiteProc, MailMoveProc,
ManProc, MoveNowProc, MoveSoundProc, NothingProc,
OldSaveStyleProc, PasteGameProc, PastePositionProc,
PauseProc, PeriodicUpdatesProc, PonderNextMoveProc,
PopupExitMessageProc, PopupMoveErrorsProc, PremoveProc,
QuietPlayProc, QuitProc, ReloadCmailMsgProc,
ReloadGameProc, ReloadPositionProc, RematchProc,
ResetProc, ResignProc, RetractMoveProc, RevertProc,
SaveGameProc, SavePositionProc, ShowCoordsProc,
ShowGameListProc, ShowThinkingProc, StopExaminingProc,
StopObservingProc, TestLegalityProc, ToEndProc,
ToStartProc, TrainingProc, TruncateGameProc, and
TwoMachinesProc.
.fi
.SH OPTIONS
.PP
This section documents the command-line options to 
xboard.
You can set these options in two ways: by typing them on the shell
command line you use to start
xboard,
or by setting them as X resources (typically in your \&.Xdefaults file).
Many of the options cannot be changed while
xboard
is running; others set the initial state of items
that can be changed with the Options menu.
.PP
Most of the 
options have both a long name and a short name.
To turn a boolean option on or off from the command line, either give
its long name followed by the value True or False
.RI ( -longOptionName
True), or give
just the short name to turn the option on
.RI ( -opt ),
or the short name preceded by "x" to turn the option off
.RI ( - x opt ).
For options that take strings or numbers as values, you can use the long or
short option names interchangeably.
.PP
Each option corresponds to an X resource
with the same name, so if you like, you can set options in your
.IR \&.Xdefaults
file or in a file named XBoard in your home directory.
For options that have two names, the longer
one is the name of the corresponding X resource; the short name is not
recognized.
To turn a boolean option on or off as an X resource,
give its long name followed by the value True or False 
.RI (XBoard* longOptionName :
True).
.SH Chess Engine Options
All of these options apply to both the GNU Chess and Crafty
chess engines.
.TP 8
.B -tc \fRor\fB -timeControl minutes[:seconds]
Each player begins with his clock set to the timeControl period.
Default: 5 minutes.
The additional options movesPerSession and timeIncrement are mutually
exclusive.  
.TP 8
.B -mps \fRor\fB -movesPerSession moves
When both players have made movesPerSession moves, a
new timeControl period is added to both clocks.  Default: 40 moves.
.TP 8
.B -inc \fRor\fB -timeIncrement seconds
If this option is specified, movesPerSession is ignored.
Instead, after each player's move, timeIncrement seconds are
added to his clock.  
Use -timeIncrement 0 if you want to require the entire
game to be played in one timeControl period, with no increment.
Default: -1, which specifies movesPerSession mode.
.TP 8
.B -clock/-xclock \fRor\fB -clockMode True/False
Determines whether or not to display the chess clocks.
If clockMode is False, the clocks are not shown, but the
side that is to play next is still highlighted.  Also, unless 
searchTime is set, the chess engine still keeps track of the
clock time and uses it to determine how fast to make its moves.
.TP 8
.B -st \fRor\fB -searchTime minutes[:seconds]
Tells the chess engine to spend at most the given amount of time searching
for each of its moves.  Without this option, the engine chooses
its search time based on the number of moves and amount of time
remaining until the next time control.
Setting this option also sets clockMode to False.
.TP 8
.B -depth \fRor\fB -searchDepth number
Tells the chess engine 
to look ahead at most the given number of moves when searching
for a move to make.  Without this option, the engine chooses
its search depth based on the number of moves and amount of time
remaining until the next time control.
With the option,
the engine will cut off its search early if it reaches the specified depth.
.TP 8
.B -thinking/-xthinking \fRor\fB -showThinking True/False
Sets the Show Thinking menu option.  Default: False.
.TP 8
.B -ponder/-xponder \fRor\fB -ponderNextMove True/False
Sets the Ponder Next Move menu option. Default: True.
.TP 8
.B -mg \fRor\fB -matchGames n
Automatically runs an \fIn\fP-game match between two chess engines,
with alternating colors.
If the loadGameFile or loadPositionFile option is set, 
xboard
starts each game with the given opening moves or the given position; 
otherwise, the games start with the standard initial chess position.
If the saveGameFile 
option is set, a move record for the match
is appended to the specified file.
If the savePositionFile 
option is set, the final position reached in each game of the match
is appended to the specified file.
When the match is over, 
xboard
displays the match score and exits.  Default: 0 (do not run a match).
.TP 8
.B -mm/-xmm \fRor\fB -matchMode True/False
Provided for backward compatibility.
If true and matchGames is 0, sets matchGames to 1.
.TP 8
.B -fcp \fRor\fB -firstChessProgram program
Name of first chess engine.
Default:
.IR gnuchessx .
.TP 8
.B -scp \fRor\fB -secondChessProgram program
Name of second chess engine.
A second chess engine is started only in Two Machines (match) mode.
Default:
.IR gnuchessx .
.TP 8
.B -fb/-xfb \fRor\fB -firstPlaysBlack True/False
In games between two chess engines, firstChessProgram normally
plays white.  (This is a change from earlier versions of
xboard.)
If this option is True, firstChessProgram plays black.
In a multi-game match, this option affects the colors only for
the first game; they still alternate in subsequent games.
.TP 8
.B -fh \fRor\fB -firstHost host
.PD 0
.TP 8
.B -sh \fRor\fB -secondHost host
Hosts on which the chess engines are to be run.
The default for each is 
.IR localhost .
If you specify another host, 
xboard
uses 
.BR rsh (1)
to run the chess engine there.
(You can substitute a different remote shell program for rsh using the
remoteShell option described below.)
.PD
.TP 8
.B -fd \fRor\fB -firstDirectory dir
.PD 0
.TP 8
.B -sd \fRor\fB -secondDirectory dir
Working directories in which the chess engines are to be run.
The default for both is "", which means to run the chess engine
in the same working directory as 
xboard
itself.  (See the CHESSDIR environment variable.)
This option is effective only when the chess engine is being run
on the local host; it does not work if the engine is run remotely
using the -fh or -sh option.
.PD
.TP 8
.B -initString string
.PD 0
.TP 8
.B -secondInitString string
The string that is sent to initialize each chess engine for a new game.
Default:
.nf
    new
    random
.fi
Setting this option from the command line is tricky,
because you must type in real newline characters, including one at the end.
In most shells you can
do this by entering a "\\" character followed by a newline.
It is easier to set the option from your \&.Xdefaults file;
in that case you can include the character sequence "\\n" in the string, and
it will be converted to a newline.

If you change this option, don't remove the 
.I new
command; it is required by all chess engines to start a new game.

You can remove the 
.I random
command if you
like; including it causes GNU Chess to randomize its move selection slightly so
that it doesn't play the same moves in every game.  
Even without 
.IR random ,
GNU Chess
randomizes its choice of moves from its opening book.  Crafty
ignores this command; it randomizes by default.

You can also try adding other commands to the initString; 
see the GNU Chess or Crafty documentation for details.
.PD
.TP 8
.B -firstComputerString string
.PD 0
.TP 8
.B -secondComputerString string
The string that is sent to the chess engine if its opponent is another
computer chess engine.  The default is "computer\\n".  Probably the
only useful alternative is the empty string (""), which keeps the
engine from knowing that it is playing another computer.
.PD
.TP 8
.B -reuse/-xreuse \fRor\fB -reuseFirst True/False
.PD 0
.TP 8
.B -reuse2/-xreuse2 \fRor\fB -reuseSecond True/False
If the option is False,
xboard
kills off the chess engine after every game and starts it again
for the next game.  
If the option is True (the default), 
xboard
starts the chess engine only once
and uses it repeatedly to play multiple games.
Some chess engines may not work properly when
reuse is turned on, such as versions of Crafty earlier than 12.0,
but otherwise new games will start faster if it is left on.
.PD
.TP 8
.B -firstProtocolVersion version-number
.PD 0
.TP 8
.B -secondProtocolVersion version-number
This option specifies which version of the chess engine communication
protocol to use.  By default, version-number is 2.  In version 1, the
"protover" command is not sent to the engine; since version 1 is a
subset of version 2, nothing else changes.  Other values for
version-number are not supported.
.PD
.SH Internet Chess Server Options
.TP 8
.B -ics/-xics \fRor\fB -internetChessServerMode True/False
Connect with an Internet Chess Server to play chess against
its other users, observe games they are playing, or
review games that have recently finished.  Default: False.
.TP 8
.B -icshost \fRor\fB -internetChessServerHost host
The Internet host name or address of the chess server to connect 
to when in ICS mode.  
Default: chessclub.com.
See the file 
.I ics-addresses
in the 
xboard
source distribution for a list of other addresses to try.
If your site doesn't have a working Internet name server, try 
specifying the host address in numeric form.  You may also need
to specify the numeric address when using the icshelper option
with timestamp or timeseal (see below).
At this writing,
chessclub.com is 207.99.5.190 and freechess.org (formerly fics.onenet.net)
is 164.58.253.13.
.TP 8
.B -icsport \fRor\fB -internetChessServerPort port-number
The port number to use when connecting to a chess server in ICS mode.
Default: 5000.
.TP 8
.B -icshelper \fRor\fB -internetChessServerHelper prog-name
An external helper program used to communicate with the chess server.
You would set it to "timestamp" for ICC (chessclub.com) or
"timeseal" for FICS (freechess.org, eics.daimi.aau.dk, etc.), after
obtaining the correct version of timestamp or timeseal for your
computer.  See "help timestamp" on ICC and "help timeseal" on FICS.
This option is shorthand for "-useTelnet -telnetProgram program".
.TP 8
.B -telnet/-xtelnet \fRor\fB -useTelnet True/False
This option is poorly named; it should be called useHelper.
If set to True, it instructs
xboard 
to run an external program to communicate with the Internet Chess
Server.  The program to use is given by the telnetProgram option.
If the option is False (the default),
xboard
opens a TCP socket and uses its own internal implementation 
of the telnet protocol to communicate with the ICS.  
See the FIREWALLS section
below for an explanation of when this option is useful.
.TP 8
.B -telnetProgram prog-name
This option is poorly named; it should be called helperProgram.
It gives the name of the telnet program to be used with the 
gateway and useTelnet options.  The default is 
.IR telnet .
The telnet program 
is invoked with the value of internetChessServerHost as its first argument
and the value of internetChessServerPort as its second argument.
See the FIREWALLS section below for an explanation of when this option is
useful. 
.TP 8
.B -gateway host-name
If this option is set to a host name,
xboard
communicates with the Internet Chess Server by using
.BR rsh (1)
to run the telnetProgram
on the given host, instead of using its own internal implementation 
of the telnet protocol.
You can substitute a different remote shell program for rsh with the
remoteShell option described below.
See the FIREWALLS section below for an explanation of when this option is
useful. 
.TP 8
.B -internetChessServerCommPort \fRor\fB -icscomm dev-name
If this option is set, 
xboard
communicates with the ICS through the given character I/O device
instead of opening a TCP connection.
Use this option if your system
does not have any kind of Internet connection itself (not
even a SLIP or PPP connection), but you do have dialup access 
(or a hardwired terminal line) to an Internet
service provider from which you can telnet to the ICS.

The support for this option in 
xboard
is minimal.  You need to set all communication parameters and tty modes
before you enter
xboard.

Use a script something like this:

.nf
    stty raw -echo 9600 > /dev/tty00
    xboard -ics -icscomm /dev/tty00
.fi

Here replace 
.IR /dev/tty00
with the name of the device that your
modem is connected to.  
You might have to add several more options to these stty commands.  See the
man pages for 
.BR stty (1)
and
.BR tty (4)
if you run into problems.  Also, on many systems
stty works on its standard input instead of standard output, so you
have to use "<" instead of ">".

If you are using linux, try starting with the script below.  Change it as
necessary for your installation.

.nf
    ##################################################
    #!/bin/sh -f
    # configure modem and fire up xboard
    
    # configure modem
    ( stty 2400 ; stty raw ; stty hupcl ; stty -clocal 
      stty ignbrk ; stty ignpar ; stty ixon ; stty ixoff 
      stty -iexten ; stty -echo ) < /dev/modem

    xboard -ics -icscomm /dev/modem
    ##################################################
.fi

After you start
xboard
in this way, type whatever commands are necessary to dial out to
your Internet provider and log in.
Then telnet to ICS, using a command like 
.IR "telnet chessclub.com 5000" .
Important: See the paragraph in the LIMITATIONS section below 
about extra echoes.
.TP 8
.B -icslogon \fRor\fB -internetChessServerLogonScript file-name
Whenever
xboard
connects to the Internet Chess Server, if it finds a file with
the name given in this option,
it feeds the file's contents to the ICS as commands.
The default file name is 
.IR .icsrc .
Usually the first two lines of the file should be your ICS user name
and password.
The file can be either in $CHESSDIR, in 
xboard's
working directory if CHESSDIR is not set, or in your home directory.
.TP 8
.B -msLoginDelay delay
If you experience trouble logging onto an ICS using the
.B -icslogon
option, inserting some delay between characters of the login
script may help. This option inserts
.B delay
milliseconds of delay per character. Good values to
try are 100 and 250.
.TP 8
.B -icsinput/-xicsinput \fRor\fB -internetChessServerInputBox True/False
Sets ICS Input Box on the mode menu.  Default: False.
.TP 8
.B -autocomm/-xautocomm \fRor\fB -autoComment True/False
Sets the Auto Comment menu option.  Default: False.
.TP 8
.B -autoflag/-xautoflag \fRor\fB -autoCallFlag True/False
Sets the Auto Flag menu option.  Default: False.
.TP 8
.B -autobs/-xautobs \fRor\fB -autoObserve True/False
Sets the Auto Observe menu option.  Default: False.
.TP 8
.B -moves/-xmoves \fRor\fB -getMoveList True/False
Sets the Get Move List menu option.  Default: True.
.TP 8
.B -alarm/-xalarm \fRor\fB -icsAlarm True/False
Sets the ICS Alarm menu option.  Default: True.
.TP 8
.B -icsAlarmTime ms
Sets the time in milliseconds for the ICS Alarm menu option.  Default: 5000.
.TP 8
.B -pre/-xpre \fRor\fB -premove True/False
Sets the Premove menu option.  Default: True.
.TP 8
.B -quiet/-xquiet \fRor\fB -quietPlay True/False
Sets the Quiet Play menu option.  Default: False.
Default: False.
.TP 8
.B -colorize/-xcolorize \fRor\fB -colorizeMessages TrueFalse
Setting
.I colorizeMessages
to True causes 
xboard
to colorize the messages received from the ICS.
Colorization works only if your xterm 
supports ISO 6429 escape sequences for changing text colors.
.TP 8
.B -colorShout foreground,background,bold
.PD 0
.TP 8
.B -colorSShout foreground,background,bold
.TP 8
.B -colorChannel foreground,background,bold
.TP 8
.B -colorKibitz foreground,background,bold
.TP 8
.B -colorTell foreground,background,bold
.TP 8
.B -colorChallenge foreground,background,bold
.TP 8
.B -colorRequest foreground,background,bold
.TP 8
.B -colorSeek foreground,background,bold
.TP 8
.B -colorNormal foreground,background,bold
.PD
These options set the colors used when colorizing ICS messages.
All ICS messages are grouped into one of these categories:
shout, sshout, channel 1, other channel, kibitz, tell, challenge, 
request (including abort, adjourn, draw, pause, and takeback), 
seek, or normal (all other messages).  

Each foreground or background argument can be one of the following:
black, red, green, yellow, blue, magenta, cyan, white, or default.
Here "default" means the default foreground or background color of
your xterm.  Bold can be 1 or 0.  If background is omitted, "default"
is assumed; if bold is omitted, 0 is assumed.

Here is an example of how to set the colors in your \&.Xdefaults file.
The colors shown here are the default values; you will get
them if you turn -colorize on without specifying your own colors.

.nf
    xboard*colorizeMessages: true	
    xboard*colorShout: green
    xboard*colorSShout: green, black, 1
    xboard*colorChannel1: cyan
    xboard*colorChannel: cyan, black, 1
    xboard*colorKibitz: magenta, black, 1
    xboard*colorTell: yellow, black, 1
    xboard*colorChallenge: red, black, 1
    xboard*colorRequest: red
    xboard*colorSeek: blue
    xboard*colorNormal: default
.fi
.TP 8
.B -soundProgram progname
If this option is set to a sound-playing program that is installed and
working on your system, xboard can play sound files when certain
events occur, listed below.  The default program name is "play".  If
any of the sound options is set to "$", the event rings the terminal
bell by sending a ^G character to standard output, instead of playing
a sound file.  If an option is set to the empty string "", no sound is
played for that event.
.TP 8
.B -soundShout filename
.PD 0
.TP 8
.B -soundSShout filename
.TP 8
.B -soundChannel filename
.TP 8
.B -soundKibitz filename
.TP 8
.B -soundTell filename
.TP 8
.B -soundChallenge filename
.TP 8
.B -soundRequest filename
.TP 8
.B -soundSeek filename
.PD
These sounds are triggered in the same way as the colorization events
described above.  They all default to "", no sound.  They are played
only if the colorizeMessages is on.
.TP 8
.B -soundMove filename
This sound is used by the Move Sound menu option.  Default: "$".
.TP 8
.B -soundIcsAlarm filename
This sound is used by the ICS Alarm menu option.  Default: "$".
.TP 8
.B -soundIcsWin filename
This sound is played when you win an ICS game.  Default: "" (no sound).
.TP 8
.B -soundIcsLoss filename
This sound is played when you lose an ICS game.  Default: "" (no sound).
.TP 8
.B -soundIcsDraw filename
This sound is played when you draw an ICS game.  Default: "" (no sound).
.TP 8
.B -soundIcsUnfinished filename
This sound is played when an ICS game that you are participating in is
aborted, adjourned, or otherwise ends inconclusively.  Default: "" (no
sound).

Here is an example of how to set the sounds in your \&.Xdefaults file.

.nf
    xboard*soundShout: shout.wav
    xboard*soundSShout: sshout.wav
    xboard*soundChannel1: channel1.wav
    xboard*soundChannel: channel.wav
    xboard*soundKibitz: kibitz.wav
    xboard*soundTell: tell.wav
    xboard*soundChallenge: challenge.wav
    xboard*soundRequest: request.wav
    xboard*soundSeek: seek.wav
    xboard*soundMove: move.wav
    xboard*soundIcsWin: win.wav
    xboard*soundIcsLoss: lose.wav
    xboard*soundIcsDraw: draw.wav
    xboard*soundIcsUnfinished: unfinished.wav
    xboard*soundIcsAlarm: alarm.wav
.fi
.SH Load and Save Options
.TP 8
.B -lgf \fRor\fB -loadGameFile file
.PD 0
.TP 8
.B -lgi \fRor\fB -loadGameIndex index
If the loadGameFile option is set,
xboard
loads the specified game file at startup.
The file name "-" specifies the standard input.
If there is more than one game in the file,
xboard
pops up a menu of the available games, with entries based on their PGN 
(portable game notation) tags.
If the loadGameIndex option is set to
.IR N ,
the menu is suppressed and
the
.IR N th
game found in the file is loaded immediately.
The menu is also suppressed if matchMode is enabled or if the game file
is a pipe; in these cases the first game in
the file is loaded immediately.  Use the
.BR pxboard
shell script if you want to pipe files containing multiple games into
xboard 
and still see the menu.
.PD
.TP 8
.B -td \fRor\fB -timeDelay seconds
Time delay between moves during \fBLoad Game\fR.
Fractional seconds are allowed; try -td 0.4.  
A time delay value of -1 tells
xboard
not to step through game files automatically.
Default: 1 second.
.TP 8
.B -sgf \fRor\fB -saveGameFile file
If this option is set, 
xboard 
appends a record of every game played to the specified file.
The file name "-" specifies the standard output.
.TP 8
.B -autosave/-xautosave \fRor\fB -autoSaveGames True/False
Sets the Auto Save menu option.
Ignored if saveGameFile is set.
Default: False.
.TP 8
.B -lpf \fRor\fB -loadPositionFile file
.PD 0
.TP 8
.B -lpi \fRor\fB -loadPositionIndex index
If the loadPositionFile option is set,
xboard
loads the specified position file at startup.
The file name "-" specifies the standard input.
If the loadPositionIndex option is set to 
.IR N ,
the
.IR N th
position found in the file is loaded; otherwise the first position is loaded.
.PD
.TP 8
.B -spf \fRor\fB -savePositionFile file
If this option is set, 
xboard 
appends the final position reached in
every game played to the specified file.
The file name "-" specifies the standard output.
.TP 8
.B -oldsave/-xoldsave \fRor\fB -oldSaveStyle True/False
Sets the Old Save Style menu option.  Default: False.
.SH User Interface Options
.TP 8
.B standard Xt options
xboard
accepts standard Xt options like -display, -geometry, and -iconic.
.TP 8
.B -movesound/-xmovesound \fRor\fB -ringBellAfterMoves True/False
Sets the Move Sound menu option.  Default: False.
For upward compatibility, -bell/-xbell are also accepted as abbreviations
for this option.
.TP 8
.B -exit/-xexit \fRor\fB -popupExitMessage True/False
Sets the Popup Exit Message menu option.  Default: True.
.TP 8
.B -popup/-xpopup \fRor\fB -popupMoveErrors True/False
Sets the Popup Move Errors menu option.  Default: False.
.TP 8
.B -queen/-xqueen \fRor\fB -alwaysPromoteToQueen True/False
Sets the Always Queen menu option.  Default: False.
.TP 8
.B -legal/-xlegal \fRor\fB -testLegality True/False
Sets the Test Legality menu option.  Default: True.
.TP 8
.B -size \fRor\fB -boardSize "(sizeName | n1,n2,n3,n4,n5,n6,n7)"
Determines how large the board will be, by selecting the pixel size
of the pieces and setting a few related parameters.
The sizeName can be one of: Titanic, giving 129x129 pixel pieces,
Colossal 116x116, Giant 108x108, Huge 95x95, Big 87x87, Large 80x80, Bulky 72x72,
Medium 64x64, Moderate 58x58, Average 54x54, Middling 49x49, Mediocre
45x45, Small 40x40, Slim 37x37, Petite 33x33, Dinky 29x29, Teeny 25x25,
or Tiny 21x21.
Pieces of all these sizes are built into xboard.  Other sizes can
be used if you have them; see the pixmapDirectory and bitmapDirectory
options.
The default depends on the size of your screen; it is approximately the
largest size that will fit without clipping.

You can select other sizes or vary other layout parameters by providing
a list of comma-separated values (with no spaces) as the argument.
You do not need to provide all the values; for any you omit from the
end of the list, defaults are taken from the nearest built-in size.
The value n1 gives the piece size, n2 the width of the black border
between squares, n3 the desired size for the 
.IR clockFont ,
n4 the desired size for the 
.IR coordFont ,
n5 the desired size for the default
.IR font ,
n6 the smallLayout flag (0 or 1), and n7 the tinyLayout flag (0 or 1).  
All dimensions are in pixels.
If the border between squares is eliminated (0 width), the various
highlight options will not work, as there is nowhere to draw the highlight.
If smallLayout is 1 and 
.I titleInWindow
is True, 
the window layout is rearranged to make more room for the title.
If tinyLayout is 1, the labels on the menu bar are abbreviated
to one character each and the buttons in the button bar are made narrower.
.TP 8
.B -coords/-xcoords \fRor\fB -showCoords True/False
Sets the Show Coords menu option.  Default: False.
The
.IR coordFont
option specifies what font to use.  
.TP 8
.B -autoraise/-xautoraise \fRor\fB -autoRaiseBoard True/False
Sets the Auto Raise Board menu option.  Default: True.
.TP 8
.B -autoflip/-xautoflip \fRor\fB -autoFlipView True/False
Sets the Auto Flip View menu option.  Default: True.
.TP 8
.B -flip/-xflip \fRor\fB -flipView True/False
If Auto Flip View is not set, or if you are observing but not participating
in a game, then the positioning of the board at the start of each game
depends on the flipView option.  If flipView is False (the default),
the board is positioned so that the white pawns move from the bottom to the
top; if True, the black pawns move from the bottom to the top.
In any case, the Flip menu option can be used to flip the board after
the game starts.
.TP 8
.B -title/-xtitle \fRor\fB -titleInWindow True/False
If this option is True, 
xboard
displays player names (for ICS games) and game file names (for Load
Game) inside its main window.  If the option is False (the default),
this information is displayed only in the window banner.  You probably
won't want to set this option unless the information is not showing up
in the banner, as happens with a few X window managers.
.TP 8
.B -buttons/-xbuttons \fRor\fB -showButtonBar True/False
If this option is False, xboard omits the [<<] [<] [P] [>] [>>] button
bar from the window, allowing the message line to be wider.  You can
still get the functions of these buttons using the menus or their keyboard
shortcuts.  Default: True.
.TP 8
.B -mono/-xmono \fRor\fB -monoMode True/False
Determines whether
xboard
displays its pieces and squares with two colors (True) or four (False).
You shouldn't have to specify monoMode;
xboard
will determine if it is necessary.
.TP 8
\fB\-flashCount\fP \fIcount\fP
.PD 0
.TP 8
\fB\-flashRate\fP \fIrate\fP
.TP 8
\fB\-flash\fP
.TP 8
\fB\-xflash\fP
These options enable flashing of pieces when they
land on their destination square.
.B flashCount
tells XBoard how many times to flash a piece after it
lands on its destination square.
.B flashRate
controls the rate of flashing (flashes/sec).
Abbreviations:
.B flash
sets flashCount to 3.
.B xflash
sets flashCount to 0.
Defaults:  flashCount=0 (no flashing), flashRate=5.
.PD
.TP 8
.B -highlight/-xhighlight \fRor\fB -highlightLastMove True/False
Sets the Highlight Last Move menu option. Default: False.
.TP 8
.B -blind/-xblind \fRor\fB -blindfold True/False
Sets the Blindfold menu option.  Default: False.
.TP 8
.B -clockFont font
The font used for the clocks.
If the option
value is a pattern that does not specify the font size, 
xboard
tries to choose an appropriate font for the board size being used.
Default: -*-helvetica-bold-r-normal--*-*-*-*-*-*-*-*.
.TP 8
.B -coordFont font
The font used for rank and file coordinate labels if 
.IR showCoords
is True.
If the option
value is a pattern that does not specify the font size, 
xboard
tries to choose an appropriate font for the board size being used.
Default: -*-helvetica-bold-r-normal--*-*-*-*-*-*-*-*.
.TP 8
.B -font font
The font used for popup dialogs, menus, comments, etc.
If the option
value is a pattern that does not specify the font size, 
xboard
tries to choose an appropriate font for the board size being used.
Default: -*-helvetica-medium-r-normal--*-*-*-*-*-*-*-*.
.TP 8
.B -fontSizeTolerance tol
In the font selection algorithm, a nonscalable font will be preferred
over a scalable font if the nonscalable font's size differs by tol pixels
or less from the desired size.  A value of -1 will force
a scalable font to always be used if available; a value of 0 will
use a nonscalable font only if it is exactly the right size; 
a large value (say 1000) will force a nonscalable font to always be
used if available.  Default: 4.
.TP 8
.B -bm \fRor\fB -bitmapDirectory dir
.PD 0
.TP 8
.B -pixmap \fRor\fB -pixmapDirectory dir
.PD
These options control what piece images xboard uses.  The xboard
distribution includes one set of pixmap pieces in xpm format, in the
directory \fIpixmaps\fR, and two sets of bitmap pieces in xbm format,
in the directories \fIbitmaps\fR and \fIbitmaps.xchess\fR.  Pixmap
pieces give a better appearance on the screen: the white pieces have
dark borders, and the black pieces have opaque internal details.  With
bitmaps, neither piece color has a border, and the internal details
are transparent; you see the square color or other background color
through them.

If xboard is configured and compiled on a system that includes libXpm,
the X pixmap library, the xpm pixmap pieces are compiled in as the
default.  A different xpm piece set can be selected at runtime with
the -pixmapDirectory option, or a bitmap piece set can be selected
with the -bitmapDirectory option.

If xboard is configured and compiled on a system that does not include
libXpm (or the --disable-xpm option is given to the configure
program), the bitmap pieces are compiled in as the default.  It is not
possible to use xpm pieces in this case, but pixmap pieces in another
format called "xim" can be used by giving the -pixmapDirectory option.
Or again, a different bitmap piece set can be selected with the
-bitmapDirectory option.

Files in the bitmapDirectory must be named as follows:
The first character of a piece bitmap name gives the piece it 
represents (p, n, b, r, q, or k),
the next characters give the size in pixels, the
following character indicates whether the piece is solid or outline (s or o),
and the extension is ".bm".
For example, a solid 80x80 knight would be named "n80s.bm".
The outline bitmaps are used only in monochrome mode.
If bitmap pieces are compiled in and the bitmapDirectory is missing
some files, the compiled in pieces are used instead.

If the bitmapDirectory option is given,
it is also possible to replace xboard's icons and menu checkmark,
by supplying files named "icon_white.bm", "icon_black.bm", and
"checkmark.bm".

You can import pixmap pieces from the
.B ZIICS
distribution by using the 
.B zic2xpm
program to convert them.  This program produces both xpm and xim
pixmaps, so you can use these pieces even if you do not have xpm
support compiled into your xboard.  ZIICS provides a large number of
piece sets to choose from.  Here's how to import them:
.sp
1) Download the ZIICS distribution. It is available from

.nf
     ftp://ftp.freechess.org/pub/chess/DOS/ziics131.exe
.fi
.sp
2) Unzip it into a directory, for example:

.nf
      unzip -L ziics131.exe -d ~/ziics
.fi
.sp
3) Pick a chess set you want to use, for example the FRITZ4 set.
Create a directory to hold the pieces, then run the
.B zic2xpm
program to create the pieces:

.nf
      mkdir ~/fritz4
      cd ~/fritz4
      zic2xpm ~/ziics/fritz4.*
.fi
.sp
(The
.B zic2xpm
program is in the directory where 
xboard
was compiled,
in case you didn't do a 
.IR "make install" .)
.sp
4) Now, just add the
.B -pixmapDirectory
option when you start
xboard:

.nf
     xboard -pixmapDirectory ~/fritz4
.fi
.sp
Or add the option to your .Xdefaults file:

.nf
     xboard*pixmapDirectory: ~/fritz4
.fi
.TP 8
.B -whitePieceColor color
.PD 0
.TP 8
.B -blackPieceColor color
.TP 8
.B -lightSquareColor color
.TP 8
.B -darkSquareColor color
.TP 8
.B -highlightSquareColor color
.TP 8
.B -premoveHighlightColor color
.PD
Colors to use for the pieces, squares, and square highlights.
Defaults:

.nf
    -whitePieceColor       #FFFFCC
    -blackPieceColor       #202020
    -lightSquareColor      #C8C365
    -darkSquareColor       #77A26D
    -highlightSquareColor  #FFFF00
    -premoveHighlightColor #FF0000
.fi

If you are using a grayscale monitor, try setting the colors to:

.nf
    -whitePieceColor       gray100
    -blackPieceColor       gray0
    -lightSquareColor      gray80
    -darkSquareColor       gray60
    -highlightSquareColor  gray100
    -premoveHighlightColor gray70
.fi
.TP 8
.B -drag/-xdrag \fRor\fB -animateDragging True/False
Sets the Animate Dragging menu option. Default: True.
.TP 8
.B -animate/-xanimate \fRor\fB -animateMoving True/False
Sets the Animate Moving menu option. Default: True.
.TP 8
.B -animateSpeed n
Number of milliseconds delay between each animation frame when Animate
Moves is on.
.SH Other Options
.TP 8
.B -ncp/-xncp \fRor\fB -noChessProgram True/False
If this option is True,
xboard
acts as a passive chessboard; it does not
start a chess engine at all.
Turning on this option also turns off clockMode.
Default: False.
.TP 8
.B -mode \fRor\fB -initialMode modename
If this option is given, xboard selects the given \fImodename\fP 
from the Mode menu after starting and (if applicable) processing the
loadGameFile or loadPositionFile option. Default: "" (no selection). 
Other supported values are 
MachineWhite, MachineBlack, TwoMachines, Analysis, 
AnalyzeFile, EditGame, EditPosition, and Training.
.TP 8
.B -variant varname
Activates preliminary, partial support for playing chess variants
against a local engine or editing variant games.  This flag is not
needed in ICS mode.  Recognized variant names are:

.nf
  normal        Normal chess
  wildcastle    Shuffle chess, king can castle from d file
  nocastle      Shuffle chess, no castling allowed
  fischerandom  Fischer Random shuffle chess
  bughouse      Bughouse, ICC/FICS rules
  crazyhouse    Crazyhouse, ICC/FICS rules
  losers        Lose all pieces or get mated (ICC wild 17)
  suicide       Lose all pieces including king (FICS)
  giveaway      Try to have no legal moves (ICC wild 26)
  twokings      Weird ICC wild 9
  kriegspiel    Opponent's pieces are invisible
  atomic        Capturing piece explodes (ICC wild 27)
  3check        Win by giving check 3 times (ICC wild 25)
  shatranj      An ancient precursor of chess (ICC wild 28)
  unknown       Catchall for other unknown variants
.fi

In the shuffle variants, xboard does not shuffle the pieces, but
you can do it by hand using Edit Position.  Some variants are
supported only in ICS mode, including fischerandom, bughouse, and
kriegspiel.  The winning/drawing conditions in crazyhouse (offboard
interposition on mate), losers, suicide, giveaway, atomic, and 3check
are not fully understood.  In crazyhouse, xboard does not yet keep
track of offboard pieces.  Shatranj is unsupported, but it may be
usable if you turn off Test Legality.
.TP 8
.B -debug/-xdebug \fRor\fB -debugMode True/False
Turns on debugging printout.
.TP 8
.B -rsh \fRor\fB -remoteShell shell-name
Name of the command used to run programs remotely.  
The default is 
.I rsh
or
.IR remsh ,
determined when
xboard
is configured and compiled.
.TP 8
.B -ruser \fRor\fB -remoteUser user-name
User name on the remote system when running programs with the remoteShell.
The default is your local user name.
.SH ANALYSIS MODES
.PP
If you are using a chess engine that supports analysis,
such as Crafty, you can use xboard
to analyze your games.
GNU Chess does not support analysis.
See the section titled GETTING CRAFTY
for more information on obtaining and installing Crafty.
There are a few ways to analyze:
.sp
.RS +.6i
.ti -4
.B Analyzing a stored game (PGN, etc):
Choose
.I Analyze File
from the
.I Mode Menu.
Type the name of the file you wish to load.
If the file contains multiple games, another popup will
appear to let you choose which game you want to analyze.
Use the arrow buttons to move through the game and watch
the engine's analysis.
.sp
.ti -4
.B Setting up a position to analyze
Choose
.I Edit Position
from the
.I Mode Menu.
Edit the board (the right and middle mouse buttons bring up
the black/white piece menus). When finished editing, click on
either the White or Black clock to tell 
xboard
whose turn it is
to move. Choose
.I Analysis Mode
from the
.I Mode Menu.
Watch the analysis, move pieces around, etc.
.sp
.ti -4
.B Analyzing a new game
If you want to start a new analysis from a fresh board,
choose
.I Reset Game
from the
.I File Menu,
then choose
.I Analysis Mode
from the
.I Mode Menu.
Now you can move pieces around and watch the engine's analysis.
.RE
.SH GETTING CRAFTY
.PP
Crafty is a chess engine written by Bob Hyatt (hyatt@cis.uab.edu).
You can use XBoard to play a game against Crafty, hook Crafty up
to an ICS, or use Crafty to interactively analyze games and positions
for you.

Crafty is a strong, rapidly evolving chess program. This rapid
pace of development is good, because it means Crafty is always
getting better.  This can sometimes cause problems with
backwards compatibility, but usually the latest version of Crafty
will work well with the latest version of xboard.
Crafty can be obtained from its author's FTP site:
ftp://ftp.cis.uab.edu/hyatt/.

To use Crafty with XBoard, give the -fcp and -fd options as follows, where
.I crafty's-directory
is the directory in which you installed Crafty
and placed its book and other support files.

.nf
    xboard -fcp crafty -fd \fIcrafty's-directory\fR
.fi
.SH FIREWALLS
.PP
By default,
.B xboard -ics
communicates with an Internet Chess Server by opening a TCP socket
directly from the machine it is running on to the ICS.  If there is a 
firewall between your machine and the ICS, this won't work.  Here are some
recipes for getting around common kinds of firewalls using special options to
xboard.
Important: See the paragraph in the LIMITATIONS section below 
about extra echoes.

Suppose that you can't telnet directly to ICS, but you can telnet to a
firewall host, log in, and then telnet from there to ICS.  Let's say the
firewall is called fire.wall.com.  Set command-line options as
follows: 

.nf
    xboard -ics -icshost fire.wall.com -icsport 23
.fi

Or in your \&.Xdefaults file:

.nf
    XBoard*internetChessServerHost: fire.wall.com
    XBoard*internetChessServerPort: 23
.fi

Then when you run
xboard
in ICS mode, you will be prompted to log in to the firewall host.
(This works because port 23 is the standard telnet login service.)
Log in, then telnet to ICS, using a command like 
.IR "telnet chessclub.com 5000" ,
or whatever command the firewall provides for telnetting to port 5000.

If your firewall lets you telnet (or rlogin) to remote hosts, but doesn't let
you telnet to port 5000, you will have to find some other host outside the
firewall that does let you do this, and hop through it.  For instance, suppose
you have an account at foo.edu.  Follow the recipe above, but
instead of typing 
.I "telnet chessclub.com 5000"
to the firewall, type 
.I "telnet foo.edu" 
(or 
.IR "rlogin foo.edu" ),
log in there, and
then type 
.IR "telnet chessclub.com 5000" .

Exception: chessclub.com itself lets you connect to the chess server on the
default telnet port (23), which is what you get if you don't specify a port
to the telnet program. But the other chess servers don't allow this.

Suppose that you can't telnet directly to ICS, but you can use rsh to run
programs on a firewall host, and that host can telnet to ICS.  Let's say the
firewall is called rsh.wall.com.  Set command-line options as
follows: 

.nf
    xboard -ics -gateway rsh.wall.com -icshost chessclub.com
.fi

Or in your \&.Xdefaults file:

.nf
    XBoard*gateway: rsh.wall.com
    XBoard*internetChessServerHost: chessclub.com
.fi

Then when you run
xboard
in ICS mode, it will connect to the ICS by using rsh
to run the command 
.I "telnet chessclub.com 5000" 
on host rsh.wall.com.

Suppose that you can telnet anywhere you want, but you have to run a special
program called 
.BR ptelnet
to do so.  

First, we'll consider the easy case, in
which 
.I "ptelnet chessclub.com 5000"
gets you to the chess server.  
In this case set command line options as follows:

.nf
    xboard -ics -telnet -telnetProgram ptelnet
.fi

Or in your \&.Xdefaults file:

.nf
    XBoard*useTelnet: true
    XBoard*telnetProgram: ptelnet
.fi

Then when you run
xboard
in ICS mode, it will issue the command 
.I "ptelnet chessclub.com 5000"
to connect to the ICS.

Next, suppose that 
.I "ptelnet chessclub.com 5000" 
doesn't work; that is, your ptelnet program
doesn't let you connect to alternative ports.  In this case,
you will have to find some other host outside the
firewall that does let you do this, and hop through it.  For instance, suppose
you have an account at foo.edu.  Set command line options as
follows:

.nf
    xboard -ics -telnet -telnetProgram ptelnet -icshost foo.edu -icsport ""
.fi

Or in your \&.Xdefaults file:

.nf
    XBoard*useTelnet: true
    XBoard*telnetProgram: ptelnet
    XBoard*internetChessServerHost: foo.edu
    XBoard*internetChessServerPort:
.fi

Then when you run
xboard
in ICS mode, it will issue the command 
.I "ptelnet foo.edu"
to connect to your account at foo.edu.  Log in there, then type
.IR "telnet chessclub.com 5000" .

ICC timestamp and FICS timeseal do not work through many
firewalls.  You can use them only if your firewall gives a clean TCP
connection with a full 8-bit wide path.  If your firewall allows you
to get out only by running a special telnet program, you can't use
timestamp or timeseal across it.  But if you have access to a
computer just outside your firewall, and you have much lower netlag
when talking to that computer than to the ICS, it might be worthwhile
running timestamp there.  Follow the instructions above for hopping
through a host outside the firewall (foo.edu in the example),
but run timestamp or timeseal on that host instead of telnet.

Suppose that you have a SOCKS firewall that requires you to go through
some extra level of authentication, but after that will give you a
clean 8-bit wide TCP connection to the chess server.  In that case,
you could make a socksified version of xboard
and run that.  If you are using timestamp or timeseal,
you will need to socksify it, not
xboard;
this may be difficult seeing that ICC and FICS do not
provide source code for these programs.
Socksification is beyond the scope of this document, but
see the SOCKS Web site at http://www.socks.nec.com/how2socksify.html.

.SH ENVIRONMENT
.PP
Game and position files
are found in the directory named by the CHESSDIR environment
variable.  If this variable is not set, the current working
directory is used.
If CHESSDIR is set,
xboard
actually changes its working directory to $CHESSDIR, so
any files written by the chess engine will be placed there too.
.SH SEE ALSO
.PP
.BR gnuchess (6),
.BR cmail (6).
.SH LIMITATIONS
.PP
There is no way for two people running copies of
xboard
to play each other without going through the Internet Chess Server.  
.PP
Under some circumstances, your ICS password may be echoed when you log on.
.PP
If you are connecting to the ICS by running telnet, timestamp, or
timeseal on an Internet provider
or firewall host, you may find that each line you type is echoed back an extra
time after you hit Return.  If your Internet provider is a Unix system, you
can probably turn its echo off by typing 
.I "stty -echo"
after you log in, and/or
typing ^E-Return (control-E followed by the Return key) to the telnet
program after you have logged into ICS.  It is a good idea to do this if you
can, because otherwise the extra echo can occasionally confuse
xboard's
parsing routines.
.PP
The game parser recognizes only algebraic notation.
.PP
The internal move legality tester does not look at the game history,
so in some cases it misses illegal castling or en passant captures.
It permits castling with the king on the d file because this is possible in
some "wild 1" games on ICS.
However, if you attempt an illegal move when using
a chess engine or the ICS,
xboard
will accept the error message that comes
back, undo the move, and let you try another.
.PP
Fischer Random castling is not understood.  You can probably play
Fischer Random chess successfully on ICS by typing castling moves into the ICS
Interaction window, but they will not be animated correctly, and saved
games will not be loaded correctly if castling occurs.
.PP
FEN positions saved by xboard
never include correct information about whether castling is legal or
how many half-moves have been made since the last irreversible move,
and sometimes may not correctly indicate when en passant capture is available.
.PP
The mate detector does not understand that non-contact mate is not really mate
in bughouse.  The only problem this causes while playing is minor: a
"#" (mate indicator) character will show up after a non-contact mating move in
the move list; xboard will not assume the game is over at that point.
However, if you are editing
a game, Edit Game mode will be terminated by a non-contact mate.
.PP
Some
xboard
functions may not work with versions of GNU Chess earlier 
than 4.0, patchlevel 77,
or with versions of Crafty earlier than 15.11.
A few functions work with GNU Chess but not Crafty, or vice versa.
.PP
The menus may not work if your keyboard is in Caps Lock or Num Lock mode.
This seems to be a problem with the Athena menu widget, not an xboard bug.
.PP
Also see the ToDo file included with the distribution for many other
possible bugs, limitations, and ideas for improvement that have been suggested.
.SH REPORTING PROBLEMS
.PP
Report bugs and problems with xboard
to <tim@tim-mann.org>.
Please use the 
.BR script (1)
program to start a typescript, run xboard
with the -debug option, and include the typescript output in your message.
Also tell us what kind of machine and what operating system version
you are using.  The command "uname -a" will often tell you this.
Here is a sample of approximately what you should type:

.nf
    script
    uname -a
    ./configure
    make
    ./xboard -debug
    exit
    mail tim@tim-mann.org
    Subject: Your short description of the problem
    Your detailed description of the problem
    ~r typescript
    .
.fi

If you improve 
xboard,
please send a message about your changes,
and we will get in touch with you about merging them in
to the main line of development.
.SH AUTHORS AND CONTRIBUTORS
.PP
Tim Mann has been responsible for 
xboard
versions 1.3 and beyond, and for
.BR WinBoard ,
a port of
xboard
to Microsoft Win32 (Windows NT and Windows 95).
.PP
Mark Williams 
contributed the initial (WinBoard-only) implementation
of many new features added to both XBoard and WinBoard in version 4.1.0,
including copy/paste, premove, icsAlarm, autoFlipView, training mode,
auto raise, and blindfold.  
Ben Nye contributed X copy/paste code for XBoard.
.PP
Hugh Fisher added animated piece movement to
xboard,
and Henrik Gram added it to WinBoard.
Frank McIngvale added click/click moving, the Analysis modes, piece flashing,
ZIICS import, and ICS text colorization to xboard.
Jochen Wiedmann ported xboard
to the Amiga, creating
.BR AmyBoard ,
and converted the documentation to texinfo.
Elmar Bartel contributed the new piece bitmaps for version 3.2.
Evan Welsh wrote
.BR cmail.
John Chanak contributed the initial implementation of ICS mode.
The color scheme and the old 80x80 piece bitmaps were taken from
Wayne Christopher's 
.BR XChess
program.
.PP
Chris Sears and Dan Sears wrote the original 
xboard;
they were responsible for versions 1.0 through 1.2.
.SH COPYRIGHT
.PP
Copyright 1991 by Digital Equipment Corporation, Maynard, Massachusetts.
Enhancements Copyright 1992-95 Free Software Foundation, Inc.
.PP
XBoard's alternative piece bitmaps (bitmaps.xchess) are derived from the
bitmaps in the XChess program, which was written and is copyrighted by Wayne
Christopher. 
.PP
The following terms apply to Digital Equipment Corporation's copyright
interest in XBoard:
.PP
.RS
All Rights Reserved
.PP
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
.PP
DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
.RE
.PP
The following terms apply to this enhanced version of XBoard distributed
by the Free Software Foundation:
.PP
.RS
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
.PP
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
.RE
.PP
.BR ZIICS
is a separate copyrighted work of Andy McFarland (Zek on ICC). Use
of
.BR ZIICS
falls under the ZIICS license, not the GPL.
