 /*
 * file      : cd_audio_extract.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */

/* Xcfa essayes de reprendre quelques fonctionnalites interessantes de 'rubyripper'
 *	http://code.google.com/p/rubyripper/
 *
	--------------------------------------------------------------------
	VERIF FICHIER cdparanoia mode expert
	--------------------------------------------------------------------
	44        = wav container overhead
	2352      = size for a audiocd sector as used in cdparanoia
	44 + 2352 = 2396
	filesize  = 44 bytes wav overhead + ( 2352 bytes per sector * len sector)
*/


#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gstdio.h>

#include "support.h"

#include <pthread.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <stdio.h>
#include <signal.h>

#include "global.h"
#include "info_song.h"
#include "options.h"
#include "utils.h"
#include "scan_cd.h"
#include "cd_audio.h"
#include "conv.h"
#include "secu.h"
#include "info_song.h"
#include "file.h"
#include "cd_audio.h"
#include "cd_audio_extract.h"
#include "config_user.h"
#include "cd_normalise.h"
#include "prg_init.h"
#include "logs.h"
#include "win_info.h"
#include "cd_cue.h"
#include "notify_send.h"




/*
*---------------------------------------------------------------------------
* DEFINITION EXTERNE
*---------------------------------------------------------------------------
*/
extern char *get_current_dir_name (void);


/*
*---------------------------------------------------------------------------
* DEFINITION
*---------------------------------------------------------------------------
*/
typedef struct {
	gboolean	 BoolFormatUnique;
	gchar		*NameFileFormatUnique;
	GList		*ListFileFormatUnique;
	gint		 NbrFileUnique;
	gint		 PassFileUnique;
	gint		 ChoiceFileCue;

	gchar		*PathName_SrcWavSox;
	gchar		*PathName_DestFlacSox;
	gchar		*PathName_DestOggSox;
	gchar		*PathName_DestMpcSox;
	
	gboolean	 BoolListIsPeakAlbum;
	gint		 ComboNumActive;
	gint		 NbrList;
	gchar		*PtrDirActuel;
	
} VAR_CDEXTRACT;

VAR_CDEXTRACT VarCdExtract;





/*
*---------------------------------------------------------------------------
* THREAD EXTRACTION
*---------------------------------------------------------------------------
*/

GList *cdaudioextract_remove_glist (GList *New)
{
	GList *list = g_list_first (New);
	gchar *ptr = NULL;

	while (list) {
		if ((ptr = (gchar*)list->data)) {
			g_free (ptr);
			ptr = NULL;
			list->data = NULL;
		}
		list = g_list_next(list);
	}
	g_list_free (New);
	New = NULL;
	return ((GList *)NULL);
}

void cdaudioextract_remove_list (void)
{
	GList		*List = NULL;
	AUDIO		*Audio = NULL;
	gint		 Num;
	
	PRINT_FUNC_LF();
	List = g_list_first (EnteteCD.GList_Audio_cd);
	while (List) {
		if ((Audio = List->data) != NULL) {
			if (Audio->ListConv != NULL) {
				for (Num = NUM_WAV; Num < NUM_TOTAL; Num ++) {
					if (Audio->ListConv[Num ].list != NULL)
						Audio->ListConv[ Num ].list = cdaudioextract_remove_glist ((GList *)Audio->ListConv[ Num ].list);
				}
				g_free (Audio->ListConv);
				Audio->ListConv = NULL;
			}
		}
		List = g_list_next(List);
	}
}

void cdaudioextract_create_list_is_Convert (void)
{
	GList		*List = NULL;
	AUDIO		*Audio = NULL;
	PARAM_FILELC	 param_filelc;
	
	PRINT_FUNC_LF();
	List = g_list_first (EnteteCD.GList_Audio_cd);
	while (List) {
		if ((Audio = List->data) != NULL) {
			/*
			Audio->Etat_Sox
				NUM_SOX_WAV
				NUM_SOX_FLAC
				NUM_SOX_OGG
				NUM_SOX_MPC
				switch (VarCdExtract.ChoiceFileCue) {
				case 0 :                              break;
				case 1 : Audio->Etat_Flac = WAITING;  break;
			 	case 2 : Audio->Etat_Ogg  = WAITING;  break;
				case 3 : Audio->Etat_Mpc  = WAITING;  break;
			 	}
			if (Audio->Etat_Sox == WAITING) {
				
				list = conv_with_glist_sox_get_param (VarCdExtract.ListFileFormatUnique, VarCdExtract.NameFileFormatUnique);
			
			}
			*/
			if (Audio->Etat_Sox == WAITING) {
				if (VarCdExtract.NameFileFormatUnique != NULL) {
					
					gchar *Ptr = NULL;
					
					if (VarCdExtract.PathName_SrcWavSox == NULL) {
						VarCdExtract.PathName_SrcWavSox = g_strdup (VarCdExtract.NameFileFormatUnique);
					}
					if (VarCdExtract.PathName_DestFlacSox == NULL) {
						VarCdExtract.PathName_DestFlacSox = g_strdup_printf ("%s  ", VarCdExtract.NameFileFormatUnique);
						Ptr = strrchr (VarCdExtract.PathName_DestFlacSox, '.');
						Ptr ++;
						*Ptr ++ = 'f';
						*Ptr ++ = 'l';
						*Ptr ++ = 'a';
						*Ptr ++ = 'c';
						*Ptr    = '\0';
					}
					if (VarCdExtract.PathName_DestOggSox == NULL) {
						VarCdExtract.PathName_DestOggSox = g_strdup (VarCdExtract.NameFileFormatUnique);
						Ptr = strrchr (VarCdExtract.PathName_DestOggSox, '.');
						Ptr ++;
						*Ptr ++ = 'o';
						*Ptr ++ = 'g';
						*Ptr ++ = 'g';
						*Ptr    = '\0';
					}
					if (VarCdExtract.PathName_DestMpcSox == NULL) {
						VarCdExtract.PathName_DestMpcSox = g_strdup (VarCdExtract.NameFileFormatUnique);
						Ptr = strrchr (VarCdExtract.PathName_DestMpcSox, '.');
						Ptr ++;
						*Ptr ++ = 'm';
						*Ptr ++ = 'p';
						*Ptr ++ = 'c';
						*Ptr    = '\0';
					}
				}
			}
			
			if (Audio->Etat_Sox == WAITING || Audio->Etat_Flac == WAITING) {
				param_filelc.type_conv             = FLAC_WAV_TO_FLAC;
				param_filelc.With_CommandLineUser  = Audio->EtatSelection_Flac >= CD_ETAT_SELECT_EXPERT;
				
				if (VarCdExtract.BoolFormatUnique == FALSE) {
					param_filelc.filesrc       = Audio->PathName_Dest_Wav;
					param_filelc.filedest      = Audio->PathName_Dest_Flac;
				}
				else {
					param_filelc.filesrc       = VarCdExtract.PathName_SrcWavSox;
					param_filelc.filedest      = VarCdExtract.PathName_DestFlacSox;
				}
				param_filelc.tags                  = Audio->tags;
				param_filelc.cdrom                 = NULL;
				param_filelc.num_track             = NULL;
				
				Audio->ListConv[ NUM_FLAC ].WithCommandLineUser = param_filelc.With_CommandLineUser;
				Audio->ListConv[ NUM_FLAC ].list = filelc_get_command_line (&param_filelc);
			}
			if (Audio->Etat_Ape == WAITING) {
				param_filelc.type_conv             = MAC_WAV_TO_APE;
				param_filelc.With_CommandLineUser  = Audio->EtatSelection_Ape >= CD_ETAT_SELECT_EXPERT;
				param_filelc.filesrc               = Audio->PathName_Dest_Wav;
				param_filelc.filedest              = Audio->PathName_Dest_Ape;
				param_filelc.tags                  = Audio->tags;
				param_filelc.cdrom                 = NULL;
				param_filelc.num_track             = NULL;
				
				Audio->ListConv[ NUM_APE ].WithCommandLineUser = param_filelc.With_CommandLineUser;
				Audio->ListConv[ NUM_APE ].list = filelc_get_command_line (&param_filelc);
			}
			if (Audio->Etat_WavPack == WAITING) {
				param_filelc.type_conv             = WAVPACK_WAV_TO_WAVPACK;
				param_filelc.With_CommandLineUser  = Audio->EtatSelection_WavPack >= CD_ETAT_SELECT_EXPERT;
				param_filelc.filesrc               = Audio->PathName_Dest_Wav;
				param_filelc.filedest              = Audio->PathName_Dest_Wav;
				param_filelc.tags                  = Audio->tags;
				param_filelc.cdrom                 = NULL;
				param_filelc.num_track             = NULL;

				Audio->ListConv[ NUM_WAVPACK ].WithCommandLineUser = param_filelc.With_CommandLineUser;
				Audio->ListConv[ NUM_WAVPACK ].list = filelc_get_command_line (&param_filelc);
			}
			if (Audio->Etat_Sox == WAITING || Audio->Etat_Ogg == WAITING) {
				param_filelc.type_conv             = OGGENC_WAV_TO_OGG;
				param_filelc.With_CommandLineUser  = Audio->EtatSelection_Ogg >= CD_ETAT_SELECT_EXPERT;
				
				if (VarCdExtract.BoolFormatUnique == FALSE) {
					param_filelc.filesrc       = Audio->PathName_Dest_Wav;
					param_filelc.filedest      = Audio->PathName_Dest_Ogg;
				}
				else {
					param_filelc.filesrc       = VarCdExtract.PathName_SrcWavSox;
					param_filelc.filedest      = VarCdExtract.PathName_DestOggSox;
				}
				param_filelc.tags                  = Audio->tags;
				param_filelc.cdrom                 = NULL;
				param_filelc.num_track             = NULL;

				Audio->ListConv[ NUM_OGG ].WithCommandLineUser = param_filelc.With_CommandLineUser;
				Audio->ListConv[ NUM_OGG ].list = filelc_get_command_line (&param_filelc);
			}
			if (Audio->Etat_m4a == WAITING) {
				param_filelc.type_conv             = FAAC_WAV_TO_M4A;
				param_filelc.With_CommandLineUser  = Audio->EtatSelection_M4a >= CD_ETAT_SELECT_EXPERT;
				param_filelc.filesrc               = Audio->PathName_Dest_Wav;
				param_filelc.filedest              = Audio->PathName_Dest_M4a;
				param_filelc.tags                  = Audio->tags;
				param_filelc.cdrom                 = NULL;
				param_filelc.num_track             = NULL;

				Audio->ListConv[ NUM_M4A ].WithCommandLineUser = param_filelc.With_CommandLineUser;
				Audio->ListConv[ NUM_M4A ].list = filelc_get_command_line (&param_filelc);
			}
			if (Audio->Etat_Aac == WAITING) {
				param_filelc.type_conv             = AACPLUSENC_WAV_TO_AAC;
				param_filelc.With_CommandLineUser  = Audio->EtatSelection_Aac >= CD_ETAT_SELECT_EXPERT;
				param_filelc.filesrc               = Audio->PathName_Dest_Wav;
				param_filelc.filedest              = Audio->PathName_Dest_Aac;
				param_filelc.tags                  = Audio->tags;
				param_filelc.cdrom                 = NULL;
				param_filelc.num_track             = NULL;

				Audio->ListConv[ NUM_AAC ].WithCommandLineUser = param_filelc.With_CommandLineUser;
				Audio->ListConv[ NUM_AAC ].list = filelc_get_command_line (&param_filelc);
			}
			if (Audio->Etat_Sox == WAITING || Audio->Etat_Mpc == WAITING) {
				param_filelc.type_conv             = MPPENC_WAV_TO_MPC;
				param_filelc.With_CommandLineUser  = Audio->EtatSelection_Mpc >= CD_ETAT_SELECT_EXPERT;
				
				if (VarCdExtract.BoolFormatUnique == FALSE) {
					param_filelc.filesrc       = Audio->PathName_Dest_Wav;
					param_filelc.filedest      = Audio->PathName_Dest_Mpc;
				}
				else {
					param_filelc.filesrc       = VarCdExtract.PathName_SrcWavSox;
					param_filelc.filedest      = VarCdExtract.PathName_DestMpcSox;
				}
				param_filelc.tags                  = Audio->tags;
				param_filelc.cdrom                 = NULL;
				param_filelc.num_track             = NULL;

				Audio->ListConv[ NUM_MPC ].WithCommandLineUser = param_filelc.With_CommandLineUser;
				Audio->ListConv[ NUM_MPC ].list = filelc_get_command_line (&param_filelc);
			}
			if (Audio->Etat_Mp3 == WAITING) {
				param_filelc.type_conv             = LAME_WAV_TO_MP3;
				param_filelc.With_CommandLineUser  = Audio->EtatSelection_Mp3 >= CD_ETAT_SELECT_EXPERT;
				param_filelc.filesrc               = Audio->PathName_Dest_Wav;
				param_filelc.filedest              = Audio->PathName_Dest_Mp3;
				param_filelc.tags                  = Audio->tags;
				param_filelc.cdrom                 = NULL;
				param_filelc.num_track             = NULL;

				Audio->ListConv[ NUM_MP3 ].WithCommandLineUser = param_filelc.With_CommandLineUser;
				Audio->ListConv[ NUM_MP3 ].list = filelc_get_command_line (&param_filelc);
			}
		}
		List = g_list_next(List);
	}
}

size_t cdaudioextract_get_size (gint NumTrack)
{
	return (
		NumTrack == 0
		? (BaseIoctl.Datas[ NumTrack ].length + BaseIoctl.Datas[ NumTrack ].begin) -1
		: BaseIoctl.Datas[ NumTrack ].length -1
	);
}

gboolean cdaudioextract_create_list_is_Extract (void)
{
	GList		*List = NULL;
	AUDIO		*Audio = NULL;
	PARAM_FILELC	 param_filelc;
	gboolean	 BoolIsPeakAlbum = FALSE;

	PRINT_FUNC_LF();
	VarCdExtract.NbrFileUnique = 0;
	List = g_list_first (EnteteCD.GList_Audio_cd);
	while (List) {
		if ((Audio = List->data) != NULL) {
			if (Audio->Etat_Wav == WAITING) {
				
				Audio->ListConv = (LIST_CONV *)g_malloc0 (sizeof(LIST_CONV) * (NUM_TOTAL + 2));
				
				if (VarCdExtract.BoolFormatUnique == TRUE) {
					
					Audio->Bool_Delette_Wav = TRUE;
					VarCdExtract.NbrFileUnique ++;
					VarCdExtract.ListFileFormatUnique = g_list_append (VarCdExtract.ListFileFormatUnique, g_strdup (Audio->PathName_Dest_Wav));
				}
				/*
				   1. length   12923 [02:52:23]  begin      32 [00:00:32]	cdparanoia [.0]-[.12954] -d /dev/hdb -O 0 "1.wav"
				   2. length   14175 [03:09:00]  begin   12955 [02:52:55]	cdparanoia [.12955]-[.14174] -d /dev/hdb -O 0 "2.wav"
				   3. length   14627 [03:15:02]  begin   27130 [06:01:55]	cdparanoia [.27130]-[.14626] -d /dev/hdb -O 0 "3.wav"
				   4. length   14823 [03:17:48]  begin   41757 [09:16:57]	cdparanoia [.41757]-[.14822] -d /dev/hdb -O 0 "4.wav"
				   5. length   13282 [02:57:07]  begin   56580 [12:34:30]	cdparanoia [.56580]-[.13281] -d /dev/hdb -O 0 "5.wav"
				   6. length   14290 [03:10:40]  begin   69862 [15:31:37]	cdparanoia [.69862]-[.14289] -d /dev/hdb -O 0 "6.wav"
				   7. length   13048 [02:53:73]  begin   84152 [18:42:02]	cdparanoia [.84152]-[.13047] -d /dev/hdb -O 0 "7.wav"
				   8. length   13170 [02:55:45]  begin   97200 [21:36:00]	cdparanoia [.97200]-[.13169] -d /dev/hdb -O 0 "8.wav"
				   9. length   13707 [03:02:57]  begin  110370 [24:31:45]	cdparanoia [.110370]-[.13706] -d /dev/hdb -O 0 "9.wav"
				  10. length   12458 [02:46:08]  begin  124077 [27:34:27]	cdparanoia [.124077]-[.12457] -d /dev/hdb -O 0 "10.wav"
				  11. length   14235 [03:09:60]  begin  136535 [30:20:35]	cdparanoia [.136535]-[.14234] -d /dev/hdb -O 0 "11.wav"
				  12. length   14857 [03:18:07]  begin  150770 [33:30:20]	cdparanoia [.150770]-[.14856] -d /dev/hdb -O 0 "12.wav"
				  13. length   14723 [03:16:23]  begin  165627 [36:48:27]	cdparanoia [.165627]-[.14722] -d /dev/hdb -O 0 "13.wav"
				  14. length   14657 [03:15:32]  begin  180350 [40:04:50]	cdparanoia [.180350]-[.14656] -d /dev/hdb -O 0 "14.wav"
				  15. length   13133 [02:55:08]  begin  195007 [43:20:07]	cdparanoia [.195007]-[.13132] -d /dev/hdb -O 0 "15.wav"
				  16. length   13520 [03:00:20]  begin  208140 [46:15:15]	cdparanoia [.208140]-[.13519] -d /dev/hdb -O 0 "16.wav"
				  17. length   13185 [02:55:60]  begin  221660 [49:15:35]	cdparanoia [.221660]-[.13184] -d /dev/hdb -O 0 "17.wav"
				  18. length   11895 [02:38:45]  begin  234845 [52:11:20]	cdparanoia [.234845]-[.11894] -d /dev/hdb -O 0 "18.wav"
				  19. length   11282 [02:30:32]  begin  246740 [54:49:65]	cdparanoia [.246740]-[.11281] -d /dev/hdb -O 0 "19.wav"
				  20. length   10973 [02:26:23]  begin  258022 [57:20:22]	cdparanoia [.258022]-[.10972] -d /dev/hdb -O 0 "20.wav"
				  21. length   13007 [02:53:32]  begin  268995 [59:46:45]	cdparanoia [.268995]-[.13006] -d /dev/hdb -O 0 "21.wav"
				  22. length   16310 [03:37:35]  begin  282002 [62:40:02]	cdparanoia [.282002]-[.16309] -d /dev/hdb -O 0 "22.wav"
				  23. length   12188 [02:42:38]  begin  298312 [66:17:37]	cdparanoia [.298312]-[.12187] -d /dev/hdb -O 0 "23.wav"
				  24. length   13470 [02:59:45]  begin  310500 [69:00:00]	cdparanoia [.310500]-[.13469] -d /dev/hdb -O 0 "24.wav"
				TOTAL  323938 [71:59:13]  
				*/
				switch (Config_User.Extract_cd_with) {
				case EXTRACT_WITH_CDPARANOIA :
					param_filelc.type_conv             = CDPARANOIA_CD_TO_WAV;
					param_filelc.With_CommandLineUser  = FALSE;
					param_filelc.filesrc               = Audio->PathName_Dest_Wav;
					param_filelc.filedest              = Audio->PathName_Dest_Wav;
					param_filelc.tags                  = NULL;
					param_filelc.cdrom                 = EnteteCD.NameCD_Device;
					param_filelc.num_track             = Audio->Str_Track;
					Audio->ListConv[ NUM_WAV ].Size                = cdaudioextract_get_size (Audio->Num_Track -1);
					Audio->ListConv[ NUM_WAV ].WithCommandLineUser = param_filelc.With_CommandLineUser;
					Audio->ListConv[ NUM_WAV ].list                = filelc_get_command_line_extract (&param_filelc);
					break;
				case EXTRACT_WITH_CDPARANOIA_EXPERT :
					
					/* NUM_WAV_EXPERT_1
					*/
					param_filelc.type_conv             = CDPARANOIA_CD_TO_WAV_EXPERT;
					param_filelc.With_CommandLineUser  = FALSE;
					param_filelc.filesrc               = Audio->PathName_Dest_Wav;
					param_filelc.filedest              = Audio->ExtractExpert.Name1;
					param_filelc.tags                  = NULL;
					param_filelc.cdrom                 = EnteteCD.NameCD_Device;
					param_filelc.num_track             = Audio->Str_Track;
					Audio->ListConv[ NUM_WAV_EXPERT_1 ].Size                = cdaudioextract_get_size (Audio->Num_Track -1);
					Audio->ListConv[ NUM_WAV_EXPERT_1 ].WithCommandLineUser = param_filelc.With_CommandLineUser;
					Audio->ListConv[ NUM_WAV_EXPERT_1 ].list                = filelc_get_command_line_extract (&param_filelc);
					
					/* NUM_WAV_EXPERT_2
					*/
					param_filelc.type_conv             = CDPARANOIA_CD_TO_WAV_EXPERT;
					param_filelc.With_CommandLineUser  = FALSE;
					param_filelc.filesrc               = Audio->PathName_Dest_Wav;
					param_filelc.filedest              = Audio->ExtractExpert.Name2;
					param_filelc.tags                  = NULL;
					param_filelc.cdrom                 = EnteteCD.NameCD_Device;
					param_filelc.num_track             = Audio->Str_Track;
					Audio->ListConv[ NUM_WAV_EXPERT_2 ].Size                = cdaudioextract_get_size (Audio->Num_Track -1);
					Audio->ListConv[ NUM_WAV_EXPERT_2 ].WithCommandLineUser = param_filelc.With_CommandLineUser;
					Audio->ListConv[ NUM_WAV_EXPERT_2 ].list                = filelc_get_command_line_extract (&param_filelc);
					break;
				
				case EXTRACT_WITH_CDDA2WAV :
					param_filelc.type_conv             = CDDA2WAV_CD_TO_WAV;
					param_filelc.With_CommandLineUser  = Audio->EtatSelection_Wav >= CD_ETAT_SELECT_EXPERT;
					param_filelc.filesrc               = NULL;
					param_filelc.filedest              = NULL;
					param_filelc.tags                  = NULL;
					param_filelc.cdrom                 = EnteteCD.NameCD_Device;
					param_filelc.num_track             = Audio->Str_Track;
					Audio->ListConv[ NUM_WAV ].Size                = cdaudioextract_get_size (Audio->Num_Track -1);
					Audio->ListConv[ NUM_WAV ].WithCommandLineUser = param_filelc.With_CommandLineUser;
					Audio->ListConv[ NUM_WAV ].list                = filelc_get_command_line_extract (&param_filelc);
					break;
				}
								
				if (Audio->EtatNormalise == TRUE) {
					switch (VarCdExtract.ComboNumActive) {
					case 0 :
						PRINT("...ADD TO LIST PEAK/ALBUM");
						CdNormalise_set_list_PeakGroup (Audio);
						Audio->EtatPeak = CD_NORM_PEAK;
						BoolIsPeakAlbum = TRUE;
						break;
					case 1 :
						Audio->EtatPeak = CD_NORM_PEAK;
						break;
					}
				}
			}
			else {
				Audio->EtatPeak = CD_NORM_PEAK_NONE;
			}
		}
		List = g_list_next(List);
	}
	return (BoolIsPeakAlbum);
}

gchar *cdaudioextract_new_name (gchar *Name, gchar *New)
{
	gchar *NewName = g_strdup (Name);
	gchar *Ptr = NULL;
	
	if ((Ptr = strrchr (NewName, '/')) != NULL) {
		Ptr ++;
		strcpy (Ptr, New);
	}
	return ((gchar *)NewName);
}

void cdaudioextract_set_list_textview (gchar *p_text)
{
	conv.ListPutTextview = g_list_append (conv.ListPutTextview, g_strdup (p_text));
	conv.BoolPutTextview = TRUE;
g_print("\n****\n%s****\n", p_text);
}

void cdaudioextract_copy_src_to_dest (gchar *FileExtarct_1, gchar *FileExtarct_2, gchar *PathNameDest, size_t LenFile)
{
	FILE		*fp1 = NULL;
	FILE		*fp2 = NULL;
	FILE		*fp3 = NULL;
	FILE		*fpElem = NULL;
	gchar		*Ptr1 = NULL;
	gchar		*Ptr2 = NULL;
	gchar		 Buf1 [ 2500 ];
	gchar		 Buf2 [ 2500 ];
	size_t		 LenFread = 0;
	gint		 Elem;
	gint		 Cpt;
	gint		 TotalElem = LenFile;
	gboolean	 BoolDiff = FALSE;
	gchar		*Name1 = NULL;
	gchar		*Name2 = NULL;
	GList		*List = NULL;
	gchar		*Str = NULL;
	gint		 NbrPass;
		
	/* Ouverture en lecture des 2 fichiers */
	fp1 = fopen (FileExtarct_1, "r");
	fp2 = fopen (FileExtarct_2, "r");
	/* Ouverture de la destination */
	fp3 = fopen (PathNameDest, "w");
	
	/* Lecture des entetes */
	LenFread = fread (Buf1, 1, 44, fp1);
	LenFread = fread (Buf2, 1, 44, fp2);
	/* Ecriture de l entete du fichier de destination */
	fwrite (Buf1, sizeof(gchar), 44, fp3);
	
	/* Analyse de tous les segments */
	for (Elem = 0; Elem <= TotalElem && !conv.bool_stop; Elem++) {
		
		/* Nettoyer les tampons */
		memset (Buf1, '\0', 2498);
		memset (Buf2, '\0', 2498);
		
		/* Lectures des segments */
		LenFread = fread (Buf1, 1, 2352, fp1);
		LenFread = fread (Buf2, 1, 2352, fp2);
		
		/* -------------------------------------------------------------
		*  DEBUG - DEBUG - DEBUG - DEBUG - DEBUG - DEBUG - DEBUG - DEBUG
		*  -------------------------------------------------------------
		*/
		/*
		if (Elem == 0 || Elem == 10 || Elem == 15 || Elem == 21) {
			g_print("-----------------------------------------------------------\n");
			g_print(" ELEM = %d  --> TEST\n", Elem);
			g_print("-----------------------------------------------------------\n");
			Buf1 [ 100 ] = '\0';
			Buf2 [ 100 ] = ' ';
		}
		*/
		
		NbrPass = 1;
		while (TRUE) {						
			/* Compare les segments */
			BoolDiff = FALSE;
			for (Ptr1 = Buf1, Ptr2 = Buf2, Cpt = 0; Cpt < 2352; Cpt ++, Ptr1 ++, Ptr2 ++) {
				if (*Ptr1 != *Ptr2) {
					if (NbrPass <= 4) {
						/* Si le contenu des segments est different */
						Str = g_strdup_printf (_("[Erreur du segment numero: %d]\n%d) Lecture PASS 1/2\n"), Elem, NbrPass);
						cdaudioextract_set_list_textview (Str);
						g_free (Str);
						Str = NULL;
						BoolDiff = TRUE;
					}
					else { /* NbrPass > 4 */
						Str = g_strdup_printf (_("--> Deja %d fois 2 lectures du segment %d!\n    Abandon  :/\n"), NbrPass, Elem);
						cdaudioextract_set_list_textview (Str);
						g_free (Str);
						Str = NULL;
					}
					break;
				}
			}
			if (BoolDiff == FALSE) break;
			
			/* Extraction du segment invalide pour les tampons: Buf1 et Buf2
			*  -------------------------------------------------------------
			*/
						
			/* Extraction segment 'Elem' PASS 1/2 */
			Name1 = cdaudioextract_new_name (FileExtarct_1, "1.wav");
		g_print("Name1 = %s\n", Name1);
		GDK_THREADS_ENTER();
			List = filelc_get_command_line_extract_elem (Elem, EnteteCD.NameCD_Device, Name1);
		GDK_THREADS_LEAVE();
			conv_exec_extract (
					FALSE, 
					CDPARANOIA_CD_TO_WAV_EXPERT_SEGMENT,
					List,
					"CDPARANOIA_CD_TO_WAV_EXPERT_SEGMENT"
					);
			List = filelc_remove_glist (List);
			
			/* Extraction segment 'Elem' PASS 2/2 */
			Str = g_strdup_printf (_("%d) Lecture PASS 2/2\n"), NbrPass);
			cdaudioextract_set_list_textview (Str);
			g_free (Str);
			Str = NULL;
			Name2 = cdaudioextract_new_name (FileExtarct_2, "2.wav");
		g_print("Name2 = %s\n", Name2);
		GDK_THREADS_ENTER();
			List = filelc_get_command_line_extract_elem (Elem, EnteteCD.NameCD_Device, Name2);
		GDK_THREADS_LEAVE();
			conv_exec_extract (
					FALSE, 
					CDPARANOIA_CD_TO_WAV_EXPERT_SEGMENT,
					List,
					"CDPARANOIA_CD_TO_WAV_EXPERT_SEGMENT"
					);
			List = filelc_remove_glist (List);

			/* Lecture segment 'Elem' pour Buf1 */
			fpElem = fopen (Name1, "r");
			LenFread = fread (Buf1, 1, 44, fpElem);
			memset (Buf1, '\0', 2498);
			LenFread = fread (Buf1, 1, 2352, fpElem);
			fclose (fpElem);
			g_free (Name1);
			Name1 = NULL;
			
			/* Lecture segment 'Elem' pour Buf2 */
			fpElem = fopen (Name2, "r");
			LenFread = fread (Buf2, 1, 44, fpElem);
			memset (Buf2, '\0', 2498);
			LenFread = fread (Buf2, 1, 2352, fpElem);
			fclose (fpElem);			
			g_free (Name2);
			Name2 = NULL;
			
			NbrPass ++;
		}
		
		/* Sauvergarde du segment valide dans le fichier de destination */
		fwrite (Buf1, sizeof(gchar), 2352, fp3);
	}
	
	fclose (fp1);
	fclose (fp2);
	fclose (fp3);
}

static void cdaudioextract_thread_extraction_from_cd (void *arg)
{
	GList         *ListOne = NULL;
	AUDIO         *Audio = NULL;
	gint           pos;

	/* PRINT_FUNC_LF(); */

	conv.bool_thread_extract  = TRUE;
	
	PRINT("DEBUT THREAD EXTRACTION");
	
	conv.ArgExtract = (ARGS_TO_EXEC *)g_malloc0(sizeof(ARGS_TO_EXEC) * 52);
	for (pos = 0; pos < 50; pos ++)
		conv.ArgExtract[ pos ].str = NULL;
	
	ListOne = g_list_first (EnteteCD.GList_Audio_cd);
	while (!conv.bool_stop && ListOne) {

		if ((Audio = (AUDIO *)ListOne->data) != NULL) {

			if (!conv.bool_stop && Audio->Etat_Wav == WAITING) {

				g_print ("\n");
				g_print ("SOURCE CD<%s>\n", Audio->Str_Track);
				g_print ("DEST   WAV<%s>\n", Audio->PathName_Dest_Wav);
				conv_product_name_for_label_extract (Audio->PathName_Dest_Wav);
				conv.bool_reset_extract = TRUE;
				
				switch (Config_User.Extract_cd_with) {
				case EXTRACT_WITH_CDPARANOIA :
					conv_exec_extract (
							Audio->ListConv[ NUM_WAV ].WithCommandLineUser, 
							CDPARANOIA_CD_TO_WAV,
							Audio->ListConv[ NUM_WAV ].list,
							"CDPARANOIA_CD_TO_WAV"
							);
					break;
				case EXTRACT_WITH_CDPARANOIA_EXPERT :
					if (!conv.bool_stop) {
						
						gchar *Str = NULL;
						
						Str = g_strdup_printf (_("\n[Piste: %d]\n"), Audio->Num_Track);
						cdaudioextract_set_list_textview (Str);
						g_free (Str);
						Str = NULL;
						Str = g_strdup (_("Extraction mode expert PASS 1/2\n"));
						cdaudioextract_set_list_textview (Str);
						g_free (Str);
						Str = NULL;
						
						conv_exec_extract (
								Audio->ListConv[ NUM_WAV_EXPERT_1 ].WithCommandLineUser, 
								CDPARANOIA_CD_TO_WAV_EXPERT,
								Audio->ListConv[ NUM_WAV_EXPERT_1 ].list,
								"CDPARANOIA_CD_TO_WAV_EXPERT"
								);
								
						conv_inc_rip_completed ();
						conv.bool_reset_extract = TRUE;
					}
					
					if (!conv.bool_stop) {
						
						cdaudioextract_set_list_textview (_("Extraction mode expert PASS 2/2\n"));
						
						conv_exec_extract (
								Audio->ListConv[ NUM_WAV_EXPERT_2 ].WithCommandLineUser, 
								CDPARANOIA_CD_TO_WAV_EXPERT,
								Audio->ListConv[ NUM_WAV_EXPERT_2 ].list,
								"CDPARANOIA_CD_TO_WAV_EXPERT"
								);
						
						conv_inc_rip_completed ();
						conv.bool_reset_extract = TRUE;
					}
					
					if (!conv.bool_stop) {
						
						cdaudioextract_set_list_textview (_("Controle du contenu des fichiers extraits\n"));
						
						cdaudioextract_copy_src_to_dest (
								Audio->ExtractExpert.Name1,
								Audio->ExtractExpert.Name2,
								Audio->PathName_Dest_Wav,
								Audio->ListConv[ NUM_WAV_EXPERT_1 ].Size
								);

						conv.bool_reset_extract = TRUE;
					}
				GDK_THREADS_ENTER();
					conv.ListPutTextview = filelc_remove_glist (conv.ListPutTextview);
				GDK_THREADS_LEAVE();
					break;
				
				case EXTRACT_WITH_CDDA2WAV :

					/*g_chdir (conv.TmpRep);*/

					conv_exec_extract (
							Audio->ListConv[ NUM_WAV ].WithCommandLineUser, 
							CDDA2WAV_CD_TO_WAV,
							Audio->ListConv[ NUM_WAV ].list,
							"CDDA2WAV_CD_TO_WAV"
							);
							
					/*g_chdir (VarCdExtract.PtrDirActuel);*/
					
					if (conv.bool_stop == FALSE) {
						
						gchar *StrOldName = NULL;
						/*
						in: PATH_TMP_XCFA_AUDIOCD
							audio.inf
							audio.wav
						*/
						StrOldName = g_strdup_printf ("%s/audio.wav", conv.TmpRep);
						conv_copy_src_to_dest (StrOldName, Audio->PathName_Dest_Wav);
						g_free (StrOldName);
						StrOldName = NULL;
					}
					break;
				}
				
				if (Audio->EtatNormalise == TRUE) {
					switch (VarCdExtract.ComboNumActive) {
					case 0 :
						Audio->EtatPeak = CD_NORM_PEAK_WAITING;
						PRINT("ADD PEAK/ALBUM");
						CdNormalise_add_PeakGroup ();
						break;
					case 1 :
						Audio->EtatPeak = CD_NORM_PEAK_WAITING;
						break;
					}
				}
				
				Audio->EtatSelection_Wav = CD_ETAT_ATTENTE;

				if (conv.bool_stop == TRUE) Audio->Bool_Delette_Wav = TRUE;
				conv_inc_rip_completed ();
				conv.bool_reset_extract = TRUE;
				conv_remove_name_for_label_extract (_EXTRACT_);
	
				if (VarCdExtract.BoolFormatUnique == FALSE)  {
					Audio->Etat_Wav = CONV_OK;
				}
				else {
					Audio->Etat_Wav = CONV_OK;
				}
				
				conv.Bool_MAJ_select = TRUE;
			}
		}
		if (conv.bool_stop == TRUE) {
			Audio->Bool_Delette_Wav = TRUE;
			break;
		}
		
		ListOne = g_list_next(ListOne);
	}
	/*close(conv.tube_extract [ 0 ]);*/

	g_free (VarCdExtract.PtrDirActuel);
	VarCdExtract.PtrDirActuel = NULL;
	
	g_free (conv.ArgExtract);
	conv.ArgExtract = NULL;
	
	/*  OPERATION DE PEAK/ALBUM
	 *  Amplification maximale du volume pour un groupe de fichiers en respectant les ecarts de niveau entre chacun d'eux.
	 */
	if (VarCdExtract.BoolListIsPeakAlbum == TRUE) {
	
		PRINT("DEBUT NORMALISATION PEAK/ALBUM");
		
		/* Premiere allocation */
		if (conv.ArgConv == NULL)
			conv.ArgConv = (ARGS_TO_EXEC *)g_malloc0(sizeof(ARGS_TO_EXEC) * (50 + 2));
	
		if (!conv.bool_stop &&
			  CdNormalise_get_is_list_PeakGroup () == TRUE &&
			  CdNormalise_list_PeakGroup_is_ready () == TRUE) {
			
			GList	*ListNorm = NULL;
			GList	*List = NULL;
			GList	*List2 = NULL;
			gchar	*Ptr = NULL;

			/*-- CHERCHER LA MOYENNE PEAK */
			
			ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
			// ListNorm = g_list_append (ListNorm, g_strdup (PrgInit.name_normalize));
			ListNorm = g_list_append (ListNorm, g_strdup (prginit_get_name (NMR_normalize)));
			ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
			
			/*-- AJOUTER LA LISTE DES FICHIERS */

			List2 = List = g_list_first (CdNormalise_get_list_PeakGroup ());
			while (List) {
				Ptr = (gchar *)List->data;
				ListNorm = g_list_append (ListNorm, g_strdup_printf ("%s", Ptr));
				List = g_list_next(List);
			}
			/*List = utils_clear_list (List);*/
			
			VarCdExtract.NbrList = conv_g_list_length (ListNorm, &VarCdExtract.NbrList);
			conv_exec (FALSE, NORMALISE_GET_LEVEL, ListNorm, "NORMALISE_GET_LEVEL TEST -> PEAK/GROUP");
			ListNorm = filelc_remove_glist (ListNorm);
			
			/*-- APPLIQUER LA MOYENNE PEAK */
			
			ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
			// ListNorm = g_list_append (ListNorm, g_strdup (PrgInit.name_normalize));
			ListNorm = g_list_append (ListNorm, g_strdup (prginit_get_name (NMR_normalize)));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("--gain=%fdB", conv.value_PEAK_RMS_GROUP_ARGS));
			
			/*-- AJOUTER LA LISTE DES FICHIERS */
			
			/*List = g_list_first (CdNormalise_get_list_PeakGroup ());*/
			while (List2) {
				Ptr = (gchar *)List2->data;
				ListNorm = g_list_append (ListNorm, g_strdup_printf ("\"%s\"", Ptr));
				List2 = g_list_next(List2);
				conv_inc_encode_completed ();
			}
			List2 = List = utils_clear_list (List);
			
			/*-- NORMALISATION */
			
			VarCdExtract.NbrList = conv_g_list_length (ListNorm, &VarCdExtract.NbrList);
			conv_exec (FALSE, NORMALISE_EXEC, ListNorm, "NORMALISE_EXEC Wav -> PEAK/GROUP");
			ListNorm = filelc_remove_glist (ListNorm);

			CdNormalise_set_normalise_ok ();
			
			conv_inc_encode_completed ();
			conv.Bool_MAJ_select = TRUE;
			conv.bool_reset_conv = TRUE;
			conv.BoolPercentFlac = TRUE;
		}
		PRINT("FIN NORMALISATION PEAK/ALBUM");
	}
		
	PRINT("FIN THREAD EXTRACTION");
	conv.bool_thread_extract = FALSE;
	secu_thread_sub ();
	pthread_exit(0);
}

gboolean cdaudioextract_get_ok (void)
{
	return (conv.bool_thread_extract);
}
/*
*---------------------------------------------------------------------------
* THREAD CONVERSION
*---------------------------------------------------------------------------
*/

static void cdaudioextract_thread_conversion_from_cd (void *arg)
{
	GList		*ListOne = NULL;
	AUDIO		*Audio = NULL;
	
	/* PRINT_FUNC_LF(); */

	conv.bool_thread_conv = TRUE;
	
	PRINT("DEBUT THREAD CONVERSIONS");
		
	/* Premiere allocation */
	if (conv.ArgConv == NULL)
		conv.ArgConv = (ARGS_TO_EXEC *)g_malloc0(sizeof(ARGS_TO_EXEC) * (VarCdExtract.NbrList + 2));
		
	ListOne = g_list_first (EnteteCD.GList_Audio_cd);
	while (!conv.bool_stop && ListOne) {
		
		if ((Audio = (AUDIO *)ListOne->data) == NULL) {
			ListOne = g_list_next(ListOne);
			continue;
		}
					
		if (Audio->EtatNormalise == TRUE && VarCdExtract.ComboNumActive == 1) {
			/*  PEAK
			 *  Le volume sera ajuste au maximum pour cet element
			 */
			if (!conv.bool_stop &&
			     Audio &&
			     Audio->EtatPeak == CD_NORM_PEAK_WAITING &&
			     CdNormalise_get_is_list_PeakGroup () == FALSE &&
			     Audio->Etat_Wav == CONV_OK) {
				
				GList	*ListNorm = NULL;
				
				/* Creation de la list */
				ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
				ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
				// ListNorm = g_list_append (ListNorm, g_strdup (PrgInit.name_normalize));
				ListNorm = g_list_append (ListNorm, g_strdup (prginit_get_name (NMR_normalize)));
				ListNorm = g_list_append (ListNorm, g_strdup ("--peak"));
				ListNorm = g_list_append (ListNorm, g_strdup ("--"));
				ListNorm = g_list_append (ListNorm, g_strdup_printf ("\"%s\"", Audio->PathName_Dest_Wav));

				/* normalisation */
				VarCdExtract.NbrList = conv_g_list_length (ListNorm, &VarCdExtract.NbrList);
				conv_exec (FALSE, NORMALISE_EXEC, ListNorm, "NORMALISE_EXEC Wav -> Peak");
				ListNorm = filelc_remove_glist (ListNorm);
				
				Audio->EtatPeak = CD_NORM_PEAK_NONE;
				Audio->EtatNormalise = FALSE;
				
				conv.Bool_MAJ_select = TRUE;
				conv_inc_encode_completed ();
				conv.bool_reset_conv = TRUE;
				conv.BoolPercentFlac = TRUE;
			}
		}
		
		if (!conv.bool_stop &&
		          Audio &&
		          Audio->Etat_Sox == WAITING &&
		          Audio->Etat_Wav == CONV_OK &&
		          Audio->EtatPeak == CD_NORM_PEAK_NONE) {
		          
			VarCdExtract.PassFileUnique ++;
			if (VarCdExtract.PassFileUnique >= VarCdExtract.NbrFileUnique) {
				
				GList	*list = NULL;
				
				conv_product_name_for_label (Audio->PathName_Dest_Wav);
				conv.type_conv = SOX_WAV_TO_WAV;
				conv.bool_reset_conv = TRUE;

				switch (VarCdExtract.ChoiceFileCue) {
				case 0 :                              break;
				case 1 : Audio->Etat_Flac = WAITING;  break;
			 	case 2 : Audio->Etat_Ogg  = WAITING;  break;
				case 3 : Audio->Etat_Mpc  = WAITING;  break;
			 	}
								
			GDK_THREADS_ENTER();
				list = conv_with_glist_sox_get_param (VarCdExtract.ListFileFormatUnique, VarCdExtract.NameFileFormatUnique);
			GDK_THREADS_LEAVE();
				VarCdExtract.NbrList = conv_g_list_length (list, &VarCdExtract.NbrList);
				conv_exec (FALSE, SOX_WAV_TO_WAV, list, "SOX_WAV_TO_WAV");
				list = filelc_remove_glist (list);
	PRINT("DEBUG POUR DZEF");
	g_print("\t%s = %s\n\n", VarCdExtract.NameFileFormatUnique, infosong_file_is_reg (VarCdExtract.NameFileFormatUnique) ? "EXISTE" : "NOT FOUND");
	
				conv.type_conv = NONE_CONV;
				conv_remove_name_for_label (_CONV_);
		
				conv.bool_reset_conv = TRUE;
				conv.Bool_MAJ_select = TRUE;
				conv.BoolPercentFlac = TRUE;
			}
		          
			Audio->Etat_Sox = CONV_OK;
		}
		
		if (!conv.bool_stop &&
		          Audio &&
		          Audio->Etat_Flac == WAITING &&
		          Audio->Etat_Wav == CONV_OK &&
		          Audio->EtatPeak == CD_NORM_PEAK_NONE) {
			
			g_print ("\n");
			g_print ("SOURCE WAV <%s>\n", Audio->PathName_Dest_Wav);
			g_print ("DEST   FLAC<%s>\n", Audio->PathName_Dest_Flac);

			conv_product_name_for_label (Audio->PathName_Dest_Flac);
			conv.bool_reset_conv = TRUE;
			conv.type_conv = FLAC_WAV_TO_FLAC;
			VarCdExtract.NbrList = conv_g_list_length (Audio->ListConv[ NUM_FLAC ].list, &VarCdExtract.NbrList);
			conv_exec (Audio->ListConv[ NUM_FLAC ].WithCommandLineUser,  FLAC_WAV_TO_FLAC, Audio->ListConv[ NUM_FLAC ].list, "FLAC_WAV_TO_FLAC");

			Audio->EtatSelection_Flac = CD_ETAT_ATTENTE;

			if (conv.bool_stop == TRUE) Audio->Bool_Delette_Flac = TRUE;
			conv_remove_name_for_label (_CONV_);
			conv.type_conv = NONE_CONV;
			conv_inc_encode_completed ();
			Audio->Etat_Flac = CONV_OK;

			conv.bool_reset_conv = TRUE;
			conv.Bool_MAJ_select = TRUE;
			conv.BoolPercentFlac = TRUE;
		}
		else if (!conv.bool_stop &&
		          Audio &&
		          Audio->Etat_Ape == WAITING &&
		          Audio->Etat_Wav == CONV_OK &&
		          Audio->EtatPeak == CD_NORM_PEAK_NONE) {
		          
			g_print ("\n");
			g_print ("SOURCE WAV <%s>\n", Audio->PathName_Dest_Wav);
			g_print ("DEST   APE <%s>\n", Audio->PathName_Dest_Ape);
			conv_product_name_for_label (Audio->PathName_Dest_Ape);
			conv.bool_reset_conv = TRUE;
			conv.type_conv = MAC_WAV_TO_APE;
			
			VarCdExtract.NbrList = conv_g_list_length (Audio->ListConv[ NUM_APE ].list, &VarCdExtract.NbrList);
			conv_exec (Audio->ListConv[ NUM_APE ].WithCommandLineUser,  MAC_WAV_TO_APE, Audio->ListConv[ NUM_APE ].list, "MAC_WAV_TO_APE");

			Audio->EtatSelection_Ape = CD_ETAT_ATTENTE;

			if (conv.bool_stop == TRUE) Audio->Bool_Delette_Ape = TRUE;
			conv_remove_name_for_label (_CONV_);
			conv.type_conv = NONE_CONV;
			conv_inc_encode_completed ();
			Audio->Etat_Ape = CONV_OK;

			conv.Bool_MAJ_select = TRUE;
			conv.BoolPercentApe = TRUE;
		}
		else if (!conv.bool_stop &&
		          Audio &&
		          Audio->Etat_WavPack == WAITING &&
		          Audio->Etat_Wav == CONV_OK &&
		          Audio->EtatPeak == CD_NORM_PEAK_NONE) {
		          
			gchar   *path = NULL;
			gchar   *ptr = NULL;
				
			g_print ("\n");
			g_print ("SOURCE WAV     <%s>\n", Audio->PathName_Dest_Wav);
			g_print ("DEST   WAVPACK <%s>\n", Audio->PathName_Dest_WavPack);
			conv_product_name_for_label (Audio->PathName_Dest_WavPack);
			conv.bool_reset_conv = TRUE;
			conv.type_conv = WAVPACK_WAV_TO_WAVPACK;

			logs_add_datas_system ("\n<b>TEST RESULTAT conv_with_wavpack:</b>\n[ ");
			logs_add_datas_system (Audio->PathName_Dest_WavPack);
			logs_add_datas_system (" ]\n");
			
			VarCdExtract.NbrList = conv_g_list_length (Audio->ListConv[ NUM_WAVPACK ].list, &VarCdExtract.NbrList);
			conv_exec (Audio->ListConv[ NUM_WAVPACK ].WithCommandLineUser,  WAVPACK_WAV_TO_WAVPACK, Audio->ListConv[ NUM_WAVPACK ].list, "WAVPACK_WAV_TO_WAVPACK");
			
			Audio->EtatSelection_WavPack = CD_ETAT_ATTENTE;

			if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
				conv.bool_set_log_wavpack = TRUE;
			}

			path = g_strdup (Audio->PathName_Dest_Wav);
			ptr = strrchr (path, '.');
			ptr ++;
			*ptr ++ = 'w';
			*ptr ++ = 'v';
			*ptr    = '\0';
			if (strcmp (path, Audio->PathName_Dest_WavPack) != 0)
				conv_copy_src_to_dest (path, Audio->PathName_Dest_WavPack);
			g_free (path);
			path = NULL;

			if (conv.bool_stop == TRUE) Audio->Bool_Delette_WavPack = TRUE;
			conv_remove_name_for_label (_CONV_);
			conv.type_conv = NONE_CONV;
			conv_inc_encode_completed ();
			Audio->Etat_WavPack = CONV_OK;

			conv.Bool_MAJ_select = TRUE;
			conv.BoolPercentWavPack = TRUE;
		}
		else if (!conv.bool_stop &&
		          Audio &&
		          Audio->Etat_Ogg == WAITING &&
		          Audio->Etat_Wav == CONV_OK &&
		          Audio->EtatPeak == CD_NORM_PEAK_NONE) {
		          
			g_print ("\n");
			g_print ("SOURCE WAV <%s>\n", Audio->PathName_Dest_Wav);
			g_print ("DEST   OGG <%s>\n", Audio->PathName_Dest_Ogg);
			conv_product_name_for_label (Audio->PathName_Dest_Ogg);
			conv.bool_reset_conv = TRUE;
			conv.type_conv = OGGENC_WAV_TO_OGG;

			VarCdExtract.NbrList = conv_g_list_length (Audio->ListConv[ NUM_OGG ].list, &VarCdExtract.NbrList);
			conv_exec (Audio->ListConv[ NUM_OGG ].WithCommandLineUser, OGGENC_WAV_TO_OGG, Audio->ListConv[ NUM_OGG ].list, "OGGENC_WAV_TO_OGG");
			
			Audio->EtatSelection_Ogg = CD_ETAT_ATTENTE;

			if (conv.bool_stop == TRUE) Audio->Bool_Delette_Ogg = TRUE;
			conv_remove_name_for_label (_CONV_);
			conv.type_conv = NONE_CONV;
			conv_inc_encode_completed ();
			Audio->Etat_Ogg = CONV_OK;

			conv.Bool_MAJ_select = TRUE;
			conv.BoolPercentOgg = TRUE;
		}
		else if (!conv.bool_stop &&
		          Audio &&
		          Audio->Etat_m4a == WAITING &&
		          Audio->Etat_Wav == CONV_OK &&
		          Audio->EtatPeak == CD_NORM_PEAK_NONE) {
		          
			g_print ("\n");
			g_print ("SOURCE WAV <%s>\n", Audio->PathName_Dest_Wav);
			g_print ("DEST   M4A <%s>\n", Audio->PathName_Dest_M4a);
			conv_product_name_for_label (Audio->PathName_Dest_M4a);
			conv.bool_reset_conv = TRUE;
			conv.type_conv = FAAC_WAV_TO_M4A;
			
			VarCdExtract.NbrList = conv_g_list_length (Audio->ListConv[ NUM_M4A ].list, &VarCdExtract.NbrList);
			conv_exec (Audio->ListConv[ NUM_M4A ].WithCommandLineUser, FAAC_WAV_TO_M4A, Audio->ListConv[ NUM_M4A ].list, "FAAC_WAV_TO_M4A");

			Audio->EtatSelection_M4a = CD_ETAT_ATTENTE;

			if (conv.bool_stop == TRUE) Audio->Bool_Delette_M4a = TRUE;
			conv_remove_name_for_label (_CONV_);
			conv.type_conv = NONE_CONV;
			conv_inc_encode_completed ();
			Audio->Etat_m4a = CONV_OK;

			conv.Bool_MAJ_select = TRUE;
			conv.BoolPercentM4a = TRUE;
		}
		else if (!conv.bool_stop &&
		          Audio &&
		          Audio->Etat_Aac == WAITING &&
		          Audio->Etat_Wav == CONV_OK &&
		          Audio->EtatPeak == CD_NORM_PEAK_NONE) {
		          
			g_print ("\n");
			g_print ("SOURCE WAV <%s>\n", Audio->PathName_Dest_Wav);
			g_print ("DEST   AAC <%s>\n", Audio->PathName_Dest_Aac);
			conv_product_name_for_label (Audio->PathName_Dest_Aac);
			conv.bool_reset_conv = TRUE;
			conv.type_conv = AACPLUSENC_WAV_TO_AAC;
			
			VarCdExtract.NbrList = conv_g_list_length (Audio->ListConv[ NUM_AAC ].list, &VarCdExtract.NbrList);
			conv_exec (Audio->ListConv[ NUM_AAC ].WithCommandLineUser, AACPLUSENC_WAV_TO_AAC, Audio->ListConv[ NUM_AAC ].list, "AACPLUSENC_WAV_TO_AAC");

			Audio->EtatSelection_Aac = CD_ETAT_ATTENTE;

			if (conv.bool_stop == TRUE) Audio->Bool_Delette_Aac = TRUE;
			conv_remove_name_for_label (_CONV_);
			conv.type_conv = NONE_CONV;
			conv_inc_encode_completed ();
			Audio->Etat_Aac = CONV_OK;

			conv.Bool_MAJ_select = TRUE;
			conv.bool_percent_conv = TRUE;
		}

		else if (!conv.bool_stop &&
		          Audio &&
		          Audio->Etat_Mpc == WAITING &&
		          Audio->Etat_Wav == CONV_OK &&
		          Audio->EtatPeak == CD_NORM_PEAK_NONE) {
		          
			g_print ("\n");
			g_print ("SOURCE WAV <%s>\n", Audio->PathName_Dest_Wav);
			g_print ("DEST   MPC <%s>\n", Audio->PathName_Dest_Mpc);
			conv_product_name_for_label (Audio->PathName_Dest_Mpc);
			conv.bool_reset_conv = TRUE;
			conv.type_conv = MPPENC_WAV_TO_MPC;
			
			VarCdExtract.NbrList = conv_g_list_length (Audio->ListConv[ NUM_MPC ].list, &VarCdExtract.NbrList);
			conv_exec (Audio->ListConv[ NUM_MPC ].WithCommandLineUser, MPPENC_WAV_TO_MPC, Audio->ListConv[ NUM_MPC ].list, "MPPENC_WAV_TO_MPC");

			Audio->EtatSelection_Mpc = CD_ETAT_ATTENTE;

			if (conv.bool_stop == TRUE) Audio->Bool_Delette_Mpc = TRUE;
			conv_remove_name_for_label (_CONV_);
			conv.type_conv = NONE_CONV;
			conv_inc_encode_completed ();
			Audio->Etat_Mpc = CONV_OK;

			conv.Bool_MAJ_select = TRUE;
			conv.BoolPercentMpc = TRUE;
		}
		else if (!conv.bool_stop &&
		          Audio &&
		          Audio->Etat_Mp3 == WAITING &&
		          Audio->Etat_Wav == CONV_OK &&
		          Audio->EtatPeak == CD_NORM_PEAK_NONE) {
		          
			g_print ("\n");
			g_print ("SOURCE WAV <%s>\n", Audio->PathName_Dest_Wav);
			g_print ("DEST   MP3 <%s>\n", Audio->PathName_Dest_Mp3);
			conv_product_name_for_label (Audio->PathName_Dest_Mp3);
			conv.bool_reset_conv = TRUE;
			conv.type_conv = LAME_WAV_TO_MP3;
			
			VarCdExtract.NbrList = conv_g_list_length (Audio->ListConv[ NUM_MP3 ].list, &VarCdExtract.NbrList);
			conv_exec (Audio->ListConv[ NUM_MP3 ].WithCommandLineUser, LAME_WAV_TO_MP3, Audio->ListConv[ NUM_MP3 ].list, "LAME_WAV_TO_MP3");

			Audio->EtatSelection_Mp3 = CD_ETAT_ATTENTE;

			if (conv.bool_stop == TRUE) Audio->Bool_Delette_Mp3 = TRUE;
			conv_remove_name_for_label (_CONV_);
			conv.type_conv = NONE_CONV;
			conv_inc_encode_completed ();
			Audio->Etat_Mp3 = CONV_OK;

			conv.Bool_MAJ_select = TRUE;
			conv.BoolPercentMp3 = TRUE;
		}
		
		if (conv.bool_stop == TRUE) {
			Audio->Bool_Delette_Mp3 = TRUE;
			Audio->Bool_Delette_Ogg = TRUE;
			break;
		}

		if (Audio &&
		    Audio->Etat_Wav != WAITING &&
		    Audio->Etat_Flac != WAITING &&
		    Audio->Etat_Mp3 != WAITING &&
		    Audio->Etat_Ogg != WAITING &&
		    Audio->Etat_m4a != WAITING &&
		    Audio->Etat_Aac != WAITING &&
		    Audio->Etat_Mpc != WAITING &&
		    Audio->Etat_Ape != WAITING &&
		    Audio->Etat_WavPack != WAITING &&
		    Audio->Etat_Sox != WAITING &&
		    Audio->EtatPeak == CD_NORM_PEAK_NONE) {

		    	ListOne = g_list_next(ListOne);
		}
	
		if (conv.bool_stop == TRUE) {
			Audio->Bool_Delette_Mp3 = TRUE;
			Audio->Bool_Delette_Ogg = TRUE;
			break;
		}
	}
	
	PRINT("FIN THREAD CONVERSIONS");
	
	/*close(conv.tube_conv [ 0 ]);*/
	g_free (conv.ArgConv);
	conv.ArgConv = NULL;
	conv.bool_thread_conv = FALSE;
	secu_thread_sub ();
	pthread_exit(0);
}

/*
*---------------------------------------------------------------------------
* UPDATE FROM THREAD
*---------------------------------------------------------------------------
*/
gint nbr = 0;

static gint cdaudioextract_timeout (gpointer data)
{
	/* PRINT_FUNC_LF(); */
	
	if (conv.BoolPercentWav == TRUE) {
		conv.bool_percent_conv = TRUE;
		conv.BoolPercentWav = FALSE;
	}
	if (conv.BoolPercentFlac == TRUE) {
		conv.bool_percent_conv = TRUE;
		conv.BoolPercentFlac = FALSE;
	}
	if (conv.BoolPercentApe == TRUE) {
		conv.bool_percent_conv = TRUE;
		conv.BoolPercentApe = FALSE;
	}
	if (conv.BoolPercentWavPack == TRUE) {
		conv.bool_percent_conv = TRUE;
		conv.BoolPercentWavPack = FALSE;
	}
	if (conv.BoolPercentOgg == TRUE) {
		conv.bool_percent_conv = TRUE;
		conv.BoolPercentOgg = FALSE;
	}
	if (conv.BoolPercentM4a == TRUE) {
		conv.bool_percent_conv = TRUE;
		conv.BoolPercentM4a = FALSE;
	}
	if (conv.BoolPercentMpc == TRUE) {
		conv.bool_percent_conv = TRUE;
		conv.BoolPercentMpc = FALSE;
	}
	if (conv.BoolPercentMp3 == TRUE) {
		conv.bool_percent_conv = TRUE;
		conv.BoolPercentMp3 = FALSE;
	}

	if (conv.BoolPercentCdparanoia == TRUE) {
		conv.bool_percent_extract = TRUE;
		conv.BoolPercentCdparanoia = FALSE;
	}
	if (conv.BoolPercentCdda2wav  == TRUE) {
		conv.bool_percent_extract = TRUE;
		conv.BoolPercentCdda2wav = FALSE;
	}
	
	if (conv.BoolPutTextview == TRUE) {
		if (conv.Adr_textview != NULL) {

			GList		*List = NULL;
			GtkTextBuffer	*Buf = NULL;
			GtkTextIter      End;
			gchar		*Ptr = NULL;
			GtkAdjustment	*Adj = NULL;
		
			Buf = gtk_text_view_get_buffer (GTK_TEXT_VIEW (conv.Adr_textview));
			gtk_text_buffer_get_end_iter (Buf, &End);
			gtk_text_buffer_place_cursor (Buf, &End);
	 		if ((List = g_list_first (conv.ListPutTextview)) != NULL) {
				
				Adj = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (GTK_WIDGET (lookup_widget (conv.Adr_wind, "scrolledwindow_wind_extract"))));
				
				while (List) {
					if ((Ptr = (gchar *)List->data)) {
						gtk_text_buffer_insert_at_cursor (Buf, Ptr, -1);
						g_free (Ptr);
						Ptr = NULL;
						List->data = NULL;
						gtk_adjustment_set_value (Adj, Adj->upper + 50.0);
						gtk_scrolled_window_set_vadjustment (GTK_SCROLLED_WINDOW (GTK_WIDGET (lookup_widget (conv.Adr_wind, "scrolledwindow_wind_extract"))), Adj);
					}
					List = g_list_next(List);
				}
				conv.BoolPutTextview = FALSE;
				
				gtk_adjustment_set_value (Adj, Adj->upper + 50.0);
				gtk_scrolled_window_set_vadjustment (GTK_SCROLLED_WINDOW (GTK_WIDGET (lookup_widget (conv.Adr_wind, "scrolledwindow_wind_extract"))), Adj);
			}
		}
	}

	if (conv.Bool_MAJ_select == TRUE) {
		conv.Bool_MAJ_select = FALSE;
		cdaudio_update_glist_audio_cd ();
		return TRUE;
	}
	
	if (conv.bool_reset_extract || conv.bool_reset_conv) {
		if (conv.bool_reset_extract) {
			conv.bool_reset_extract = FALSE;
			conv_set_label_extract ();
			conv_activate_progressBar (conv.Adr_progressbar_extract);
			conv_set_label_total (_EXTRACT_);
		}
		if (conv.bool_reset_conv) {
			conv.bool_reset_conv = FALSE;
			conv_set_label_conversion ();
			conv_activate_progressBar (conv.Adr_progressbar_conversion);
			conv_set_label_total (_EXTRACT_);
		}
	}

	if (conv.bool_percent_extract || conv.bool_percent_conv) {
		if (conv.bool_percent_extract) {
			if (conv.bool_reset_extract) conv.extract_percent = 1.0;
			conv_set_data_progressBar (conv.Adr_progressbar_extract, conv.extract_percent);
			conv_set_data_progressBar (conv.Adr_progressbar_total, conv.total_percent);
			if (conv.bool_reset_extract) conv.extract_percent = 0.0;
			conv.bool_percent_extract = FALSE;
		}
		if (conv.bool_percent_conv) {
			if (conv.bool_reset_conv) conv.conversion_percent = 1.0;
			conv_set_data_progressBar (conv.Adr_progressbar_conversion, conv.conversion_percent);
			conv_set_data_progressBar (conv.Adr_progressbar_total, conv.total_percent);
			if (conv.bool_reset_conv) conv.conversion_percent = 0.0;
			conv.bool_percent_conv = FALSE;
		}
	}
	
	if ((conv.bool_thread_conv == FALSE) && (conv.bool_thread_extract == FALSE)) {
		AUDIO *Audio = NULL;
		GList *List = NULL;
		FILE  *fp = NULL;

		gtk_timeout_remove (conv.handler_timeout_conv);
		conv_close_window ();

		/* Creation du fichier *.m3u */
		if (var_cd.Bool_create_file_m3u == TRUE) {
			if ((fp = fopen (var_cd.Pathname_m3u, "w"))) {
				List = g_list_first (EnteteCD.GList_Audio_cd);
				while (List) {
					if ((Audio = (AUDIO *)List->data) != NULL) {
						if (Audio->Etat_Flac == CONV_OK ||
						    Audio->Etat_Wav == CONV_OK ||
						    Audio->Etat_Mp3 == CONV_OK ||
						    Audio->Etat_Ogg == CONV_OK ||
						    Audio->Etat_m4a == CONV_OK ||
						    Audio->Etat_Aac == CONV_OK ||
						    Audio->Etat_Mpc == CONV_OK ||
						    Audio->Etat_Ape == CONV_OK ||
						    Audio->Etat_WavPack == CONV_OK) {

							if (Audio->Etat_Flac == CONV_OK)	fprintf (fp, "%s\n", Audio->PathName_Dest_Flac);
							if (Audio->Etat_Wav == CONV_OK &&
							    Audio->BoolM3uForWav == TRUE)	fprintf (fp, "%s\n", Audio->PathName_Dest_Wav);
							if (Audio->Etat_Mp3 == CONV_OK)		fprintf (fp, "%s\n", Audio->PathName_Dest_Mp3);
							if (Audio->Etat_Ogg == CONV_OK)		fprintf (fp, "%s\n", Audio->PathName_Dest_Ogg);
							if (Audio->Etat_m4a == CONV_OK)		fprintf (fp, "%s\n", Audio->PathName_Dest_M4a);
							if (Audio->Etat_Aac == CONV_OK)		fprintf (fp, "%s\n", Audio->PathName_Dest_Aac);
							if (Audio->Etat_Mpc == CONV_OK)		fprintf (fp, "%s\n", Audio->PathName_Dest_Mpc);
							if (Audio->Etat_Ape == CONV_OK)		fprintf (fp, "%s\n", Audio->PathName_Dest_Ape);
							if (Audio->Etat_WavPack == CONV_OK)	fprintf (fp, "%s\n", Audio->PathName_Dest_WavPack);
						}

					}
					List = g_list_next(List);
				}
				fclose (fp);
			}
			g_free (var_cd.Pathname_m3u);
			var_cd.Pathname_m3u = NULL;
			
			if ((fp = fopen (var_cd.Pathname_xspf, "w"))) {
				
				fprintf (fp, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
				fprintf (fp, "<playlist version=\"1\" xmlns=\"http://xspf.org/ns/0/\">\n");
				fprintf (fp, "    <trackList>\n");
				
				List = g_list_first (EnteteCD.GList_Audio_cd);
				while (List) {
					if ((Audio = (AUDIO *)List->data) != NULL) {
						if (Audio->Etat_Flac == CONV_OK ||
						    Audio->Etat_Wav == CONV_OK ||
						    Audio->Etat_Mp3 == CONV_OK ||
						    Audio->Etat_Ogg == CONV_OK ||
						    Audio->Etat_m4a == CONV_OK ||
						    Audio->Etat_Aac == CONV_OK ||
						    Audio->Etat_Mpc == CONV_OK ||
						    Audio->Etat_Ape == CONV_OK ||
						    Audio->Etat_WavPack == CONV_OK) {
							
							if (Audio->Etat_Flac == CONV_OK)	fprintf (fp, "        <track><location>%s</location></track>\n", Audio->PathName_Dest_Flac);
							if (Audio->Etat_Wav == CONV_OK && Audio->BoolM3uForWav == TRUE)
												fprintf (fp, "        <track><location>%s</location></track>\n", Audio->PathName_Dest_Wav);
							if (Audio->Etat_Mp3 == CONV_OK)		fprintf (fp, "        <track><location>%s</location></track>\n", Audio->PathName_Dest_Mp3);
							if (Audio->Etat_Ogg == CONV_OK)		fprintf (fp, "        <track><location>%s</location></track>\n", Audio->PathName_Dest_Ogg);
							if (Audio->Etat_m4a == CONV_OK)		fprintf (fp, "        <track><location>%s</location></track>\n", Audio->PathName_Dest_M4a);
							if (Audio->Etat_Aac == CONV_OK)		fprintf (fp, "        <track><location>%s</location></track>\n", Audio->PathName_Dest_Aac);
							if (Audio->Etat_Mpc == CONV_OK)		fprintf (fp, "        <track><location>%s</location></track>\n", Audio->PathName_Dest_Mpc);
							if (Audio->Etat_Ape == CONV_OK)		fprintf (fp, "        <track><location>%s</location></track>\n", Audio->PathName_Dest_Ape);
							if (Audio->Etat_WavPack == CONV_OK)	fprintf (fp, "        <track><location>%s</location></track>\n", Audio->PathName_Dest_WavPack);
						}
					}
					List = g_list_next(List);
				}
				
				fprintf (fp, "    </trackList>\n");
				fprintf (fp, "</playlist>\n");
				
				fclose (fp);
			}
			g_free (var_cd.Pathname_xspf);
			var_cd.Pathname_xspf = NULL;
		}

		/* Delete alloc name files of extraction/conversion */
		List = g_list_first (EnteteCD.GList_Audio_cd);
		while (List) {
			if ((Audio = (AUDIO *)List->data) != NULL) {
				if (Audio->PathName_Dest_Flac) {
					if (Audio->Bool_Delette_Flac) {
						g_print ("infosong_delete_file (%s)\n", Audio->PathName_Dest_Flac);
						infosong_delete_file (Audio->PathName_Dest_Flac);
					}
					g_free (Audio->PathName_Dest_Flac);
					Audio->PathName_Dest_Flac = NULL;
				}

				if (Audio->PathName_Dest_Wav) {
					if (Audio->Bool_Delette_Wav) {
						g_print ("infosong_delete_file (%s)\n", Audio->PathName_Dest_Wav);
						infosong_delete_file (Audio->PathName_Dest_Wav);
					}
					g_free (Audio->PathName_Dest_Wav);
					Audio->PathName_Dest_Wav = NULL;
				}

				if (Audio->PathName_Dest_Mp3) {
					if (Audio->Bool_Delette_Mp3) {
						g_print ("infosong_delete_file (%s)\n", Audio->PathName_Dest_Mp3);
						infosong_delete_file (Audio->PathName_Dest_Mp3);
					}
					g_free (Audio->PathName_Dest_Mp3);
					Audio->PathName_Dest_Mp3 = NULL;
				}

				if (Audio->PathName_Dest_Ogg) {
					if (Audio->Bool_Delette_Ogg) {
						g_print ("infosong_delete_file (%s)\n", Audio->PathName_Dest_Ogg);
						infosong_delete_file (Audio->PathName_Dest_Ogg);
					}
					g_free (Audio->PathName_Dest_Ogg);
					Audio->PathName_Dest_Ogg = NULL;
				}

				if (Audio->PathName_Dest_M4a) {
					if (Audio->Bool_Delette_M4a) {
						g_print ("infosong_delete_file (%s)\n", Audio->PathName_Dest_M4a);
						infosong_delete_file (Audio->PathName_Dest_M4a);
					}
					g_free (Audio->PathName_Dest_M4a);
					Audio->PathName_Dest_M4a = NULL;
				}

				if (Audio->PathName_Dest_Aac) {
					if (Audio->Bool_Delette_Aac) {
						g_print ("infosong_delete_file (%s)\n", Audio->PathName_Dest_Aac);
						infosong_delete_file (Audio->PathName_Dest_Aac);
					}
					g_free (Audio->PathName_Dest_Aac);
					Audio->PathName_Dest_Aac = NULL;
				}

				if (Audio->PathName_Dest_Mpc) {
					if (Audio->Bool_Delette_Mpc) {
						g_print ("infosong_delete_file (%s)\n", Audio->PathName_Dest_Mpc);
						infosong_delete_file (Audio->PathName_Dest_Mpc);
					}
					g_free (Audio->PathName_Dest_Mpc);
					Audio->PathName_Dest_Mpc = NULL;
				}

				if (Audio->PathName_Dest_Ape) {
					if (Audio->Bool_Delette_Ape) {
						g_print ("infosong_delete_file (%s)\n", Audio->PathName_Dest_Ape);
						infosong_delete_file (Audio->PathName_Dest_Ape);
					}
					g_free (Audio->PathName_Dest_Ape);
					Audio->PathName_Dest_Ape = NULL;
				}

				if (Audio->PathName_Dest_WavPack) {
					if (Audio->Bool_Delette_WavPack) {
						g_print ("infosong_delete_file (%s)\n", Audio->PathName_Dest_WavPack);
						infosong_delete_file (Audio->PathName_Dest_WavPack);
					}
					g_free (Audio->PathName_Dest_WavPack);
					Audio->PathName_Dest_WavPack = NULL;
				}
				if (Audio->ExtractExpert.Name1) {
					g_free (Audio->ExtractExpert.Name1);
					Audio->ExtractExpert.Name1 = NULL;
				}
				if (Audio->ExtractExpert.Name2) {
					g_free (Audio->ExtractExpert.Name2);
					Audio->ExtractExpert.Name2 = NULL;
				}
			}
			List = g_list_next(List);
		}
		
		if (VarCdExtract.ChoiceFileCue > 0) {
			g_print ("infosong_delete_file (%s)\n", VarCdExtract.PathName_SrcWavSox);
			infosong_delete_file (VarCdExtract.PathName_SrcWavSox);
		}
		
		g_free (VarCdExtract.PathName_SrcWavSox);
		VarCdExtract.PathName_SrcWavSox = NULL;
		g_free (VarCdExtract.PathName_DestFlacSox);
		VarCdExtract.PathName_DestFlacSox = NULL;
		g_free (VarCdExtract.PathName_DestOggSox);
		VarCdExtract.PathName_DestOggSox = NULL;
		g_free (VarCdExtract.PathName_DestMpcSox);
		VarCdExtract.PathName_DestMpcSox = NULL;
		
		CdNormalise_set_list_collectif_remove ();
		
		/* Delete tmp rep */
		if (conv.TmpRep)  conv.TmpRep  = utils_remove_temporary_rep (conv.TmpRep);

		cdaudio_update_glist_audio_cd ();
		cdaudio_set_flag_buttons_audio_cd ();

		conv_remove_name_for_label (_EXTRACT_);
		conv_remove_name_for_label (_CONV_);

		cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, "");

		if (conv.bool_set_log_wavpack == TRUE || conv.bool_set_log_wvunpack == TRUE) {
			conv.bool_set_log_wvunpack = FALSE;
			conv.bool_set_log_wavpack = FALSE;
			logs_set_datas_system ();
		}
		conv_set_struct_not_used ();
g_chdir (VarCdExtract.PtrDirActuel);
		
		PRINT("FIN TIMEOUT");
		
		cdcue_print_base_ioctl ();
		var_cd.TypeCreateCue = TYPE_CUE_FILE;
		cdcue_write_cue ();
		
		cdaudioextract_remove_list ();
		
		NotifySend_msg (_("XCFA: Extraction CD"), _("Ok"));
	}
	return (TRUE);
}

/*
*---------------------------------------------------------------------------
* INIT DATAS
*---------------------------------------------------------------------------
*/

ETAT_CONV cdaudioextract_get_etat_sox (void)
{
	gchar *Ptr = NULL;
	
	Ptr = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_name_file_cue));
	
	if (cdaudio_get_bool_is_wav_extract_to_cue () == TRUE &&
	    gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (lookup_widget (wind_main, "checkbutton_creation_fichier_unique_cue"))) == TRUE &&
	    *Ptr != '\0') {
		return (WAITING);
	}
	return (NONE);
}

void cdaudioextract_set_flags_before_extraction (void)
{
	GList	*List = NULL;
	AUDIO	*Audio = NULL;
	gchar	*PathDest = NULL;
	gint	 IndexExtraction;
	gchar	*Ptr = NULL;
	
	/* PRINT_FUNC_LF(); */

	EnteteCD.NameCD_Device = scancd_get_text_combo_cd (_CD_);

	/* recup du niveau de gentillesse */
	g_snprintf (conv.valuenice ,    4, "%d", options_get_val_nice ());

	if (cdaudioextract_get_etat_sox () == WAITING) {
		VarCdExtract.BoolFormatUnique = TRUE;
		VarCdExtract.ChoiceFileCue = gtk_combo_box_get_active ( GTK_COMBO_BOX ( GTK_WIDGET (lookup_widget (wind_main, "combobox_choice_file_cue"))));
		/* Pour SOX */
		/* conv.total_convert ++; */
		/* Si conversion vers FLAC | OGG | MPC */
		if (VarCdExtract.ChoiceFileCue > 0)
			conv.total_convert ++;
	}
	
	IndexExtraction = 0;
	List = g_list_first (EnteteCD.GList_Audio_cd);
	while (List) {
		if ((Audio = (AUDIO *)List->data) != NULL) {
			
			cdcue_set_BoolExtract (IndexExtraction, FALSE);
						
			Audio->BoolM3uForWav = FALSE;
	
			/* MAJ des flags
			*/
			Audio->Etat_Mp3      = Audio->EtatSelection_Mp3     >= CD_ETAT_SELECT ? WAITING : NONE;
			Audio->Etat_Ogg      = Audio->EtatSelection_Ogg     >= CD_ETAT_SELECT ? WAITING : NONE;
			Audio->Etat_Wav      = Audio->EtatSelection_Wav     >= CD_ETAT_SELECT ? WAITING : NONE;
			Audio->Etat_Flac     = Audio->EtatSelection_Flac    >= CD_ETAT_SELECT ? WAITING : NONE;
			Audio->Etat_m4a      = Audio->EtatSelection_M4a     >= CD_ETAT_SELECT ? WAITING : NONE;
			Audio->Etat_Aac      = Audio->EtatSelection_Aac     >= CD_ETAT_SELECT ? WAITING : NONE;
			Audio->Etat_Mpc      = Audio->EtatSelection_Mpc     >= CD_ETAT_SELECT ? WAITING : NONE;
			Audio->Etat_Ape      = Audio->EtatSelection_Ape     >= CD_ETAT_SELECT ? WAITING : NONE;
			Audio->Etat_WavPack  = Audio->EtatSelection_WavPack >= CD_ETAT_SELECT ? WAITING : NONE;
		
			Audio->Etat_Sox      = NONE;
			if (Audio->Etat_Wav == WAITING)
			Audio->Etat_Sox      = cdaudioextract_get_etat_sox ();
			if (Audio->Etat_Sox  == WAITING) conv.total_convert ++;
			
			if (Audio->Etat_Mp3  == WAITING)      Audio->Etat_Wav = WAITING;
			if (Audio->Etat_Ogg  == WAITING)      Audio->Etat_Wav = WAITING;
			if (Audio->Etat_Flac == WAITING)      Audio->Etat_Wav = WAITING;
			if (Audio->Etat_m4a  == WAITING)      Audio->Etat_Wav = WAITING;
			if (Audio->Etat_Aac  == WAITING)      Audio->Etat_Wav = WAITING;
			if (Audio->Etat_Mpc  == WAITING)      Audio->Etat_Wav = WAITING;
			if (Audio->Etat_Ape  == WAITING)      Audio->Etat_Wav = WAITING;
			if (Audio->Etat_WavPack  == WAITING)  Audio->Etat_Wav = WAITING;
			if (Audio->Etat_Sox  == WAITING)      Audio->Etat_Wav = WAITING;
			
			/* calcul total ripping tracks
			*/
			if (Audio->EtatSelection_Flac    >= CD_ETAT_SELECT ||
			    Audio->EtatSelection_Wav     >= CD_ETAT_SELECT ||
			    Audio->EtatSelection_Mp3     >= CD_ETAT_SELECT ||
			    Audio->EtatSelection_Ogg     >= CD_ETAT_SELECT ||
			    Audio->EtatSelection_M4a     >= CD_ETAT_SELECT ||
			    Audio->EtatSelection_Aac     >= CD_ETAT_SELECT ||
			    Audio->EtatSelection_Mpc     >= CD_ETAT_SELECT ||
			    Audio->EtatSelection_Ape     >= CD_ETAT_SELECT ||
			    Audio->EtatSelection_WavPack >= CD_ETAT_SELECT ) {
				
				if (Config_User.Extract_cd_with == EXTRACT_WITH_CDPARANOIA_EXPERT) {
					conv.total_rip ++;	/* PASS 2	*/
					
				}
				conv.total_rip ++;		/* NORMAL PASS	*/
				cdcue_set_BoolExtract (IndexExtraction, TRUE);
				
				/*if (Audio->EtatNormalise == TRUE && cdaudio_get_value_normalise_cd () > 0)	conv.total_convert ++;*/
				/*if (Audio->EtatNormalise == TRUE)	conv.total_convert ++;*/
			}

			/* calcul total convert file
			*/
			if (Audio->EtatSelection_Mp3     >= CD_ETAT_SELECT)	conv.total_convert ++;
			if (Audio->EtatSelection_Ogg     >= CD_ETAT_SELECT)	conv.total_convert ++;
			if (Audio->EtatSelection_Flac    >= CD_ETAT_SELECT)	conv.total_convert ++;
			if (Audio->EtatSelection_M4a     >= CD_ETAT_SELECT)	conv.total_convert ++;
			if (Audio->EtatSelection_Aac     >= CD_ETAT_SELECT)	conv.total_convert ++;
			if (Audio->EtatSelection_Mpc     >= CD_ETAT_SELECT)	conv.total_convert ++;
			if (Audio->EtatSelection_Ape     >= CD_ETAT_SELECT)	conv.total_convert ++;
			if (Audio->EtatSelection_WavPack >= CD_ETAT_SELECT)	conv.total_convert ++;
			
			/* init var to FALSE and NULL
			*/
			Audio->Bool_Delette_Flac      = FALSE;
			Audio->Bool_Delette_Wav       = FALSE;
			Audio->Bool_Delette_Mp3       = FALSE;
			Audio->Bool_Delette_Ogg       = FALSE;
			Audio->Bool_Delette_M4a       = FALSE;
			Audio->Bool_Delette_Aac       = FALSE;
			Audio->Bool_Delette_Mpc       = FALSE;
			Audio->Bool_Delette_Ape       = FALSE;
			Audio->Bool_Delette_WavPack   = FALSE;
			Audio->PathName_Dest_Flac     = NULL;
			Audio->PathName_Dest_Wav      = NULL;
			Audio->PathName_Dest_Mp3      = NULL;
			Audio->PathName_Dest_Ogg      = NULL;
			Audio->PathName_Dest_M4a      = NULL;
			Audio->PathName_Dest_Aac      = NULL;
			Audio->PathName_Dest_Mpc      = NULL;
			Audio->PathName_Dest_Ape      = NULL;
			Audio->PathName_Dest_WavPack  = NULL;

			/* Create REP DEST */
			if (PathDest == NULL) {
				PathDest = cdaudio_get_result_destination (Audio->tags);
				infosong_create_dir (PathDest);
			}
			/* Create tmp rep */
			if (!conv.TmpRep)  {
				conv.TmpRep  = utils_create_temporary_rep (PATH_TMP_XCFA_AUDIOCD);
			}
		
			if (Audio->Etat_Wav == WAITING) {

				switch (Config_User.Extract_cd_with) {
				case EXTRACT_WITH_CDPARANOIA :
					if (Audio->EtatSelection_Wav <= CD_ETAT_ATTENTE_EXIST) {

						Audio->PathName_Dest_Wav = g_strdup_printf ("%s/%s.wav", conv.TmpRep, Audio->NameSong);
					}
					else {
						Audio->BoolM3uForWav = TRUE;
						if (Audio->tags->Album && *Audio->tags->Album) {
							Audio->PathName_Dest_Wav = g_strdup_printf ("%s/%s.wav", PathDest, Audio->NameSong);
						} else {
							Audio->PathName_Dest_Wav = g_strdup_printf ("%s/%s.wav", PathDest, Audio->NameSong);
						}
					}
					break;
					
				case EXTRACT_WITH_CDPARANOIA_EXPERT :
					if (Audio->EtatSelection_Wav <= CD_ETAT_ATTENTE_EXIST) {

						Audio->PathName_Dest_Wav = g_strdup_printf ("%s/%s.wav", conv.TmpRep, Audio->NameSong);
					}
					else {
						Audio->BoolM3uForWav = TRUE;
						if (Audio->tags->Album && *Audio->tags->Album) {
							Audio->PathName_Dest_Wav = g_strdup_printf ("%s/%s.wav", PathDest, Audio->NameSong);
						} else {
							Audio->PathName_Dest_Wav = g_strdup_printf ("%s/%s.wav", PathDest, Audio->NameSong);
						}
					}
					Audio->ExtractExpert.Name1 = g_strdup_printf ("%s/TrackExpert_1.wav", conv.TmpRep);
					Audio->ExtractExpert.Name2 = g_strdup_printf ("%s/TrackExpert_2.wav", conv.TmpRep);
					break;
					
				case EXTRACT_WITH_CDDA2WAV :
					if (Audio->EtatSelection_Wav <= CD_ETAT_ATTENTE_EXIST) {
						Audio->PathName_Dest_Wav = g_strdup_printf ("%s/%s.wav", conv.TmpRep, Audio->NameSong);
					}
					else {
						Audio->PathName_Dest_Wav = g_strdup_printf ("%s/%s.wav", PathDest, Audio->NameSong);
						Audio->BoolM3uForWav = TRUE;
					}
					break;
				}
			}
			
			if (VarCdExtract.BoolFormatUnique == TRUE && VarCdExtract.NameFileFormatUnique == NULL) {
				
				Ptr = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_name_file_cue));
				VarCdExtract.NameFileFormatUnique = g_strdup_printf ("%s/%s.wav",  PathDest, Ptr);
			}
			
			g_free (BaseIoctl.PathNameDestFileCue);
			BaseIoctl.PathNameDestFileCue = NULL;
			Ptr = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_name_file_cue));
			BaseIoctl.PathNameDestFileCue = g_strdup_printf ("%s/%s.cue", PathDest, Ptr);
			
			Audio->PathName_Dest_Ogg      = g_strdup_printf ("%s/%s.ogg",  PathDest, Audio->NameSong);
			Audio->PathName_Dest_Mp3      = g_strdup_printf ("%s/%s.mp3",  PathDest, Audio->NameSong);
			Audio->PathName_Dest_Flac     = g_strdup_printf ("%s/%s.flac", PathDest, Audio->NameSong);
			Audio->PathName_Dest_M4a      = g_strdup_printf ("%s/%s.m4a",  PathDest, Audio->NameSong);
			Audio->PathName_Dest_Aac      = g_strdup_printf ("%s/%s.aac",  PathDest, Audio->NameSong);
			Audio->PathName_Dest_Mpc      = g_strdup_printf ("%s/%s.mpc",  PathDest, Audio->NameSong);
			Audio->PathName_Dest_Ape      = g_strdup_printf ("%s/%s.ape",  PathDest, Audio->NameSong);
			Audio->PathName_Dest_WavPack  = g_strdup_printf ("%s/%s.wv",   PathDest, Audio->NameSong);
						
			if (var_cd.Bool_create_file_m3u == TRUE && var_cd.Pathname_m3u == NULL && PathDest != NULL) {
				if (*Config_User.Name_file_m3u == '\0') {
					var_cd.Pathname_m3u = g_strdup_printf ("%s/FileM3u.m3u", PathDest);
				}
				else {
					var_cd.Pathname_m3u = g_strdup_printf ("%s/%s.m3u", PathDest, Config_User.Name_file_m3u);
				}
			}
			if (var_cd.Bool_create_file_m3u == TRUE && var_cd.Pathname_xspf == NULL && PathDest != NULL) {
				if (*Config_User.Name_file_m3u == '\0') {
					var_cd.Pathname_xspf = g_strdup_printf ("%s/FileXspf.xspf", PathDest);
				}
				else {
					var_cd.Pathname_xspf = g_strdup_printf ("%s/%s.xspf", PathDest, Config_User.Name_file_m3u);
				}
			}
		}
		
		IndexExtraction ++;
		
		List = g_list_next(List);
	}

	g_free (PathDest);
	PathDest = NULL;
}

/*
*---------------------------------------------------------------------------
* FUNC FOR EXTRACTIONS / CONVERSIONS
*---------------------------------------------------------------------------
*/

void cdaudioextract_extraction_cd_to_file_action (void)
{
	pthread_t nmr_tid;
	
	/* PRINT_FUNC_LF(); */

	if (cdaudio_get_bool_is_wav_extract_to_cue () == TRUE &&
	    gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (lookup_widget (wind_main, "checkbutton_creation_fichier_unique_cue"))) == TRUE) {
		
		gchar *Ptr = NULL;
		Ptr = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_name_file_cue));
		if (*Ptr == '\0') {
			wininfo_create (
				_("Nom de fichier unique absent"),
				_("    Veuillez saisir un nom pour le fichier unique   "),
				  "\n\n",
				  "");
			return;
		}
	}

	cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, _("Extractions et conversions en cours. Veuillez patienter ..."));
	
	if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_extract_with_cdparanoia)) == TRUE)
		Config_User.Extract_cd_with = EXTRACT_WITH_CDPARANOIA;
	else if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_cdparanoia_mode_expert)) == TRUE)
		Config_User.Extract_cd_with = EXTRACT_WITH_CDPARANOIA_EXPERT;
	else if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_extract_with_cdda2wav)) == TRUE)
		Config_User.Extract_cd_with = EXTRACT_WITH_CDDA2WAV;

	conv_reset_struct ();
	conv_set_type_oper (_EXTRACT_);
 	VarCdExtract.BoolFormatUnique = FALSE;
	VarCdExtract.NameFileFormatUnique = NULL;
	g_free (BaseIoctl.PathNameDestFileCue);
	BaseIoctl.PathNameDestFileCue = NULL;
	cdaudioextract_set_flags_before_extraction ();

	conv_create_window_extract (_("Extractions / Conversions"), (Config_User.Extract_cd_with == EXTRACT_WITH_CDPARANOIA_EXPERT) ? TRUE : FALSE);
	conv_activate_progressBar (conv.Adr_progressbar_extract);
	conv_activate_progressBar (conv.Adr_progressbar_conversion);
	conv_activate_progressBar (conv.Adr_progressbar_total);

 	conv.bool_thread_conv = TRUE;
	secu_thread_add ();
	VarCdExtract.NbrFileUnique = 0;
	VarCdExtract.PassFileUnique = 0;
	VarCdExtract.ListFileFormatUnique = NULL;
		
	VarCdExtract.NbrList = 50;
	VarCdExtract.ComboNumActive = gtk_combo_box_get_active (GTK_COMBO_BOX (var_cd.Adr_combobox_normalise_cd));
	VarCdExtract.BoolListIsPeakAlbum = cdaudioextract_create_list_is_Extract ();
	
	cdaudioextract_create_list_is_Convert ();

	VarCdExtract.PtrDirActuel = g_get_current_dir ();
g_chdir (conv.TmpRep);

 	pthread_create (&nmr_tid, NULL ,(void *)cdaudioextract_thread_conversion_from_cd, (void *)NULL);
	pthread_detach (nmr_tid);

	conv.bool_thread_extract = TRUE;
	secu_thread_add ();
 	pthread_create (&nmr_tid, NULL ,(void *)cdaudioextract_thread_extraction_from_cd, (void *)NULL);
	pthread_detach (nmr_tid);

	PRINT("DEBUT TIMEOUT");
	conv.handler_timeout_conv = gtk_timeout_add (3, cdaudioextract_timeout, 0);
}


