 /*
 * file      : file_analyze.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <pthread.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/stat.h>
#include <stdlib.h>

#include "support.h"

#include "global.h"
#include "file.h"
#include "win_pulse.h"
#include "utils.h"
#include "options.h"
#include "info_song.h"
#include "prg_init.h"
#include "file.h"
#include "logs.h"
#include "secu.h"
#include "win_info.h"
#include "tags.h"
#include "level.h"
#include "split.h"
#include "config_user.h"
#include "player.h"
#include "process.h"
#include "split_shuttle.h"
#include "fileselect.h"
#include "cursor.h"



/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

/*
GTimer *gtime = NULL;
*/

typedef enum {
	BECAUSE_NONE = 0,
	NO_ANALIZER,
	MODIF_EXT,
	SIZE_IS_ZERO
} BECAUSE;

typedef struct {					/* allocation pointee par var_analize.glist_analize	*/
	gchar		*name;				/* Le nom complet du fichier				*/
	gchar		*ptrname;			/* Pointeur sur le debut du nom de fichier		*/
	BECAUSE		 because;			/**/
	TYPE_FILE_IS	 file_real;			/**/
	TYPE_FILE_IS	 file_ext;			/**/
	gboolean	 bool_recursif;			/* TRUE si inclusion de repertoire(s)			*/
	gboolean	 BoolCueFile;			/* TRUE si fichier CUE sinon FALSE			*/
	gchar		*NameCueFile;			/* Le nom complet du fichier CUE			*/
	
} FILE_ANALIZE;

typedef enum {
	EVENT_NONE = 0,
	EVENT_PROGRESS,
	EVENT_END_THREAD
} EVENT;

typedef struct {
	EVENT              event;
	GList             *glist_analize;		/* GList contenant FILE_ANALIZE */
	CHOICE_TREEVIEW    choice_treeview;		/*  */
	gboolean           Bool_Thread_Do ;		/*  */
	gboolean           Bool_Timeout_Do ;		/*  */
	guint              Handler_Timeout_Do;		/*  */
	guint              elem_actif;			/*  */
	guint              total_elem;			/*  */
	gboolean           bool_ogginfo_ok;		/*  */
	gboolean           bool_checkmp3_ok;		/*  */
	gboolean           bool_faad_ok;		/*  */
	gint               cpt_no_analizer;		/*  */
	gint               cpt_size_is_zero;		/*  */
	gint               cpt_modif_ext;		/*  */
	
	gboolean           BoolAnalyseIsOk;		/*  */
	GList             *ListFile;			/*  */
	gboolean           BoolCueFile;			/*  */

} VAR_ANALIZE;

VAR_ANALIZE var_analize = {EVENT_NONE,NULL,_TREEVIEW_ALL_,FALSE,FALSE,0,0,0,FALSE,FALSE,FALSE,0,0,0, TRUE,NULL,FALSE};


GList *entetefile = NULL;				/* pointeur sur DETAIL */

/*
*---------------------------------------------------------------------------
* FUNCTIONS
*---------------------------------------------------------------------------
*/

FIC *fileanalyze_remove_info_fic (FIC *fic) {
	if (fic) {
		g_free (fic->name_dest);
		g_free (fic->dest_flac);
		g_free (fic->dest_wav);
		g_free (fic->dest_mp3);
		g_free (fic->dest_ogg);
		g_free (fic->tmp_flac);
		g_free (fic->tmp_wav);
		g_free (fic->tmp_sox);
		g_free (fic->tmp_mp3);
		g_free (fic->tmp_ogg);
		g_free (fic->tmp_shn);
		g_free (fic->tmp_wma);
		g_free (fic->tmp_mpc);
		g_free (fic->tmp_ape);
		g_free (fic->tmp_wavpack);
		g_free (fic->tmp_wavpack_md5);
		g_free (fic);
		fic = NULL;
	}
	return ((FIC *)NULL);
}
FIC_WAV *fileanalyze_remove_info_fic_wav (FIC_WAV *fic)
{
	if (fic) {
		g_free (fic->Path);
		g_free (fic->TmpSrc);
		g_free (fic->TmpDest);
		g_free (fic->TmpMplayer);
		g_free (fic->NameDest);
		g_free (fic->Hertz);
		g_free (fic->Voie);
		g_free (fic->Bits);
		g_free (fic->NewHertz);
		g_free (fic->NewVoie);
		g_free (fic->NewBits);
		g_free (fic);
		fic = NULL;
	}
	return ((FIC_WAV *)NULL);
}
FIC_MP3OGG *fileanalyze_remove_info_fic_mp3ogg (FIC_MP3OGG *fic)
{
	if (fic) {
		g_free (fic->New_src);
		g_free (fic->destwav);
		g_free (fic->destsox);
		g_free (fic->destmp3);
		g_free (fic->destogg);
		g_free (fic->Bitrate);
		/*g_free (fic->NewBitrate);*/
		g_free (fic);
		fic = NULL;
	}
	return ((FIC_MP3OGG *)NULL);
}

FIC_SPLIT *fileanalyze_remove_info_fic_split (FIC_SPLIT *FicSplit)
{
	if (FicSplit) {
		GList		*List = NULL;
		FIC_SPLIT	*PtrFicSplit = NULL;
		
		// PRINT_FUNC_LF();
		
		if (FicSplit->Name != NULL) {
			g_free (FicSplit->Name);
			FicSplit->Name = NULL;
		}

		if ((List = g_list_first (FicSplit->ListDecoupes)) != NULL) {
			while (List) {
				if ((PtrFicSplit = (FIC_SPLIT *)List->data)) {
					if (PtrFicSplit->Name != NULL) {
						g_free (PtrFicSplit->Name);
						PtrFicSplit->Name = NULL;
					}
					g_free (PtrFicSplit);
					PtrFicSplit = NULL;
					List->data = NULL;
				}
				List = g_list_next (List);
			}
			g_list_free (FicSplit->ListDecoupes);
			FicSplit->ListDecoupes = NULL;
		}

		g_free (FicSplit);
		FicSplit = NULL;
	}
	return ((FIC_SPLIT *)NULL);
}

void fileanalyze_remove_entetefile (void) {
	GList   *list = NULL;
	DETAIL  *detail = NULL;

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			g_free (detail->namefile);	detail->namefile = NULL;
			g_free (detail->namefileCopie);	detail->namefileCopie = NULL;
			g_free (detail->nametreeview);	detail->nametreeview = NULL;

			if (detail->type_infosong_file_is == FILE_IS_FLAC) {
				detail->info = tagsflac_remove_info ((INFO_FLAC *)detail->info);
			}
			else if (detail->type_infosong_file_is == FILE_IS_WAV) {
				detail->info = tagswav_remove_info ((INFO_WAV *)detail->info);
			}
			else if (detail->type_infosong_file_is == FILE_IS_MP3) {
				detail->info = tagsmp3_remove_info ((INFO_MP3 *)detail->info);
			}
			else  if (detail->type_infosong_file_is == FILE_IS_OGG) {
				detail->info = tagsogg_remove_info ((INFO_OGG *)detail->info);
			}
			else if (detail->type_infosong_file_is == FILE_IS_SHN) {
				detail->info = tagsshn_remove_info ((INFO_SHN *)detail->info);
			}
			else if (detail->type_infosong_file_is == FILE_IS_WMA) {
				detail->info = tagswma_remove_info ((INFO_WMA *)detail->info);
			}
			else if (detail->type_infosong_file_is == FILE_IS_MPC) {
				detail->info = tagsmpc_remove_info ((INFO_MPC *)detail->info);
			}
			else if (detail->type_infosong_file_is == FILE_IS_APE) {
				detail->info = tagsape_remove_info ((INFO_APE *)detail->info);
			}

			if (detail->fic) {
				detail->fic = fileanalyze_remove_info_fic ((FIC *)detail->fic);
			}
			if (detail->fic_wav) {
				detail->fic_wav = fileanalyze_remove_info_fic_wav ((FIC_WAV *)detail->fic_wav);
			}
			if (detail->fic_mp3ogg) {
				detail->fic_mp3ogg = fileanalyze_remove_info_fic_mp3ogg ((FIC_MP3OGG *)detail->fic_mp3ogg);
			}
			g_free (detail);
			list->data = NULL;
		}
		list = g_list_next (list);
	}
	g_list_free (entetefile);
	entetefile = NULL;
}

void fileanalyze_clear_analyze_files_glist (void)
{
	GList *list = NULL;
	FILE_ANALIZE *fa = NULL;

	list = g_list_first (var_analize.glist_analize);
	while (list) {
		if ((fa = (FILE_ANALIZE *)list->data)) {
			g_free (fa->name);
			fa->name = NULL;
			g_free ((FILE_ANALIZE *)list->data);
			list->data = NULL;
		}
		list = g_list_next (list);
	}
	g_list_free (var_analize.glist_analize);
	var_analize.glist_analize = NULL;
}

DETAIL *fileanalyze_dupply_glist_entetefile (gchar *namefile, gint *num_field)
{
	GList   *list = NULL;
	DETAIL  *detail = NULL;

	*num_field = 1;
	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			*num_field = MAX(detail->num_struct, *num_field);
			if (*detail->namefile == *namefile)
				if (strcmp (namefile, detail->namefile) == 0) {
					/*PRINT("ANALYSE DUPPLY = EXISTE DEJA");*/
					return ((DETAIL * )detail);
				}
		}
		list = g_list_next (list);
	}
	/*PRINT("ANALYSE DUPPLY = N EXISTE PAS ENCORE");*/
	return ((DETAIL * )NULL);
}

gboolean fileanalyze_exist (DETAIL *detail, TYPE_FILE_IS type)
{
	gchar     *Name = NULL;
	gboolean   bool_exist = FALSE;
	
	if ((Name = file_make_pathname_file (detail, type)) == NULL) return (FALSE);

	bool_exist = infosong_access_mode (AM_FILE_IS_REG, Name, NULL);
	g_free (Name);
	Name = NULL;
	return (bool_exist);
}

FIC *fileanalyze_set_data_fic (DETAIL *detail, gchar *namefile)
{
	FIC   *fic = NULL;
	gchar *ptr = NULL;

	fic = (FIC *)g_malloc0 (sizeof (FIC));
	fic->EtatPlay = FILE_ETAT_PLAY_NONE;
	if (detail->type_infosong_file_is == FILE_IS_FLAC ||
	    detail->type_infosong_file_is == FILE_IS_WAV ||
	    detail->type_infosong_file_is == FILE_IS_MP3 ||
	    detail->type_infosong_file_is == FILE_IS_OGG ||
	    detail->type_infosong_file_is == FILE_IS_M4A ||
	    detail->type_infosong_file_is == FILE_IS_WMA ||
	    detail->type_infosong_file_is == FILE_IS_MPC ||
	    detail->type_infosong_file_is == FILE_IS_WAVPACK ||
	    detail->type_infosong_file_is == FILE_IS_APE ||
	    detail->type_infosong_file_is == FILE_IS_SHN) {
		fic->EtatPlay = FILE_ETAT_PLAY_ATTENTE;
	}
	
	fic->EtatTrash = FILE_TRASH_NONE;
	/*
	ptr = strrchr (namefile, '/');
	ptr ++;
	fic->name_dest = g_strdup (ptr);
	ptr = strrchr (fic->name_dest, '.');
	*ptr = '\0';
	*/
	ptr = detail->nametreeview;
	if (*ptr == '/')	fic->name_dest = g_strdup ((ptr +1));
	else			fic->name_dest = g_strdup (detail->nametreeview);

	fic->dest_flac = NULL;
	fic->dest_wav = NULL;
	fic->dest_mp3 = NULL;
	fic->dest_ogg = NULL;
	fic->dest_ape = NULL;
	fic->dest_m4a = NULL;
	fic->dest_aac = NULL;
	fic->dest_mpc = NULL;
	fic->dest_wavpack = NULL;
	fic->dest_wavpack_md5 = NULL;

	fic->tmp_flac = NULL;
	fic->tmp_wav = NULL;
	fic->tmp_sox = NULL;
	fic->tmp_mp3 = NULL;
	fic->tmp_ogg = NULL;
	fic->tmp_shn = NULL;
	fic->tmp_wma = NULL;
	fic->tmp_mpc = NULL;
	fic->tmp_ape = NULL;
	fic->tmp_m4a = NULL;
	fic->tmp_aac = NULL;
	fic->tmp_wavpack = NULL;
	fic->tmp_wavpack_md5 = NULL;

	fic->Etat_Flac          = FILE_NONE;
	fic->Etat_Mp3           = FILE_NONE;
	fic->Etat_Mp3           = FILE_NONE;
	fic->Etat_Ogg           = FILE_NONE;
	fic->Etat_m4a           = FILE_NONE;
	fic->Etat_aac           = FILE_NONE;
	fic->Etat_Mpc           = FILE_NONE;
	fic->Etat_Ape           = FILE_NONE;
	fic->Etat_wavpack       = FILE_NONE;
	
	fic->Etat_Normalise     = NORM_NONE;
	if (detail->type_infosong_file_is == FILE_IS_MP3 ||
	    detail->type_infosong_file_is == FILE_IS_OGG ||
	    detail->type_infosong_file_is == FILE_IS_WAV) {
		fic->Etat_Normalise     = NORM_READY_FOR_SELECT;
	}

	fic->Etat_Scan          = ETAT_SCAN_NONE;
	fic->BoolNewString      = FALSE;
	
	fic->Etat_ReplayGain    = RPG_NONE;
	if (detail->type_infosong_file_is == FILE_IS_MP3 ||
	    detail->type_infosong_file_is == FILE_IS_OGG ||
	    detail->type_infosong_file_is == FILE_IS_FLAC ||
	    detail->type_infosong_file_is == FILE_IS_WAVPACK) {
		fic->Etat_ReplayGain = RPG_ATTENTE;
	}
	fic->LevelMix = -14;
	
	detail->count_item ++;

	return ((FIC *)fic);
}
FIC_WAV *fileanalyze_set_data_ficwav (DETAIL *detail, gchar *namefile)
{
	FIC_WAV    *fic = NULL;
	gchar      *ptr = NULL;
	INFO_WAV   *info = (INFO_WAV *)detail->info;

	// PRINT_FUNC_LF();

	fic = (FIC_WAV *)g_malloc0 (sizeof (FIC_WAV));
	fic->Bool_Conv = FALSE;
	fic->Path = g_strdup (namefile);
	ptr = strrchr (fic->Path, '/');
	*ptr = '\0';
	fic->TmpSrc = NULL;
	fic->TmpDest = NULL;
	fic->TmpMplayer = NULL;
	fic->NameDest = NULL;
	fic->Hertz = g_strdup (info->hertz);
	fic->Voie = g_strdup (info->voie);
	fic->Bits = g_strdup (info->bits);

	fic->NewHertz = g_strdup (info->hertz);
	fic->NewVoie =  g_strdup (info->voie);
	fic->NewBits =  g_strdup (info->bits);

	detail->count_item ++;

	return ((FIC_WAV *)fic);
}
FIC_MP3OGG *fileanalyze_set_data_ficmp3ogg (DETAIL *detail, gchar *namefile)
{
	FIC_MP3OGG    *fic = NULL;
	INFO_MP3      *info_mp3 = (INFO_MP3 *)detail->info;
	INFO_OGG      *info_ogg = (INFO_OGG *)detail->info;

	fic = (FIC_MP3OGG *)g_malloc0 (sizeof (FIC_MP3OGG));

	fic->Bool_Conv = FALSE;

	fic->New_src  = NULL;
	fic->destwav  = NULL;
	fic->destsox  = NULL;
	fic->destmp3  = NULL;
	fic->destogg  = NULL;
	fic->destfile = NULL;
	
	fic->Lame.type    = -1;
	fic->Lame.debit   = -1;
	fic->Lame.mode    = -1;
	fic->Oggenc.type  = -1;
	fic->Oggenc.debit = -1;
	fic->Oggenc.mode  = -1;
	
	if (detail->type_infosong_file_is == FILE_IS_MP3) fic->Bitrate = g_strdup (info_mp3->bitrate);
	if (detail->type_infosong_file_is == FILE_IS_OGG) fic->Bitrate = g_strdup (info_ogg->Nominal_bitrate);
	/*fic->NewBitrate = g_strdup (fic->Bitrate);*/

	detail->count_item ++;
	if (var_analize.choice_treeview == _TREEVIEW_ALL_) detail->count_item ++;

	return ((FIC_MP3OGG *)fic);
}
FIC_SPLIT *fileanalyze_set_data_split (DETAIL *detail, gchar *namefile)
{
	FIC_SPLIT	*FicSplit = NULL;
	
	FicSplit = (FIC_SPLIT *)g_malloc0 (sizeof (FIC_SPLIT));
	FicSplit->ListDecoupes      = NULL;
	FicSplit->Name              = NULL;
	FicSplit->GUINT_TempsTotal  = file_get_time_in_secondes (detail);
	FicSplit->AdrValueMarkA     = 0.0;
	FicSplit->AdrValueMarkB     = 100.0;
	
	return ((FIC_SPLIT *)FicSplit);
}
gboolean fileanalyze_set_data_treeview (gchar *namefile, TYPE_FILE_IS type, gboolean BoolCueFile)
{
	DETAIL    *detail = NULL;
	gchar     *ptr = NULL;
	gint       num_field;
	gboolean   BoolDupply = TRUE;

	// PRINT_FUNC_LF();

	if ((detail = fileanalyze_dupply_glist_entetefile (namefile, &num_field)) == NULL) {
		
		BoolDupply = FALSE;
		
		detail = (DETAIL *)g_malloc0 (sizeof (DETAIL));
		
		detail->namefile      = namefile;
		detail->namefileCopie = NULL;
		
		if ((ptr = strrchr (namefile, '/')) != NULL) {
			ptr ++;
		}
		detail->nametreeview = g_strdup (ptr);
		ptr = strrchr (detail->nametreeview, '.');
		*ptr = '\0';

		detail->num_struct = num_field + 1;

		detail->type_infosong_file_is = type;
		detail->info = NULL;
		detail->choice_treeview = var_analize.choice_treeview;
		detail->fic = NULL;
		detail->fic_wav = NULL;
		detail->fic_mp3ogg = NULL;
		detail->fic_split = NULL;
		detail->modif = FALSE;
		detail->count_item = 0;
		detail->remove = STRUCT_NO_REMOVE;
		
		detail->ValuePlay.Value       = 0.0;
		detail->ValuePlay.ValueMarkA  = 0.0;
		detail->ValuePlay.ValueMarkB  = 0.0;
		detail->ValuePlay.SecTime     = 0;
		detail->BoolCueFile           = BoolCueFile;
		
		entetefile = g_list_append (entetefile, detail);
	}

	if (detail && !detail->info) {
		if (type == FILE_IS_FLAC)         detail->info = tagsflac_get_info (detail, namefile);
		else if (type == FILE_IS_WAV)     detail->info = tagswav_get_info (detail, namefile);
		else if (type == FILE_IS_MP3)     detail->info = tagsmp3_get_info (detail, namefile);
		else if (type == FILE_IS_OGG)     detail->info = tagsogg_get_info (detail, namefile);
		else if (type == FILE_IS_SHN)     detail->info = tagsshn_get_info (namefile);
		else if (type == FILE_IS_WMA)     detail->info = tagswma_get_info (namefile);
		else if (type == FILE_IS_M4A)     detail->info = tagsm4a_get_info (detail, namefile);
		else if (type == FILE_IS_MPC)     detail->info = tagsmpc_get_info (namefile);
		else if (type == FILE_IS_APE)     detail->info = tagsape_get_info (namefile);
		else if (type == FILE_IS_WAVPACK) detail->info = tagswavpack_get_info (detail, namefile);
		
	}
	
	switch (detail->choice_treeview) {
	case _TREEVIEW_ALL_ :
	case _TREEVIEW_SPLIT_ :
		if (detail->choice_treeview != var_analize.choice_treeview) {
			detail->choice_treeview = _TREEVIEW_SPLIT_ALL_;
		}
		break;
	case _TREEVIEW_SPLIT_ALL_ :
		break;
	}
	
	if (detail->fic == NULL) {
		detail->fic = fileanalyze_set_data_fic (detail, namefile);
	}
	if (type == FILE_IS_WAV && detail->fic_wav == NULL) {
		detail->fic_wav = fileanalyze_set_data_ficwav (detail, namefile);
	}
	if ((type == FILE_IS_MP3 || type == FILE_IS_OGG) && detail->fic_mp3ogg == NULL) {
		detail->fic_mp3ogg = fileanalyze_set_data_ficmp3ogg (detail, namefile);
	}	
	if (var_analize.choice_treeview == _TREEVIEW_SPLIT_ && detail->fic_split == NULL) {
		detail->fic_split = fileanalyze_set_data_split (detail, namefile);
	}
	
	return (BoolDupply);
}

guint fileanalyze_get_total_file (void)
{
	GList         *list = NULL;
	FILE_ANALIZE  *fa = NULL;

	/* cherche le nombre total de fichiers */
	var_analize.total_elem = 0;
	list = g_list_first (var_analize.glist_analize);
	while (list) {
		if ((fa = (FILE_ANALIZE *)list->data)) {
			if (fa->bool_recursif == FALSE) var_analize.total_elem ++;
		}
		/*
		if ((FILE_ANALIZE *)list->data) var_analize.total_elem ++;
		*/
		list = g_list_next (list);
	}
	return (var_analize.total_elem);
}

extern int lstat(const char *file_name, struct stat *buf);
extern char *get_current_dir_name (void);

gchar   *ptrdir = NULL;
gchar   *name = NULL;

void fileanalyze_print_dir (gchar *dir)
{
	DIR    *dp;
	struct  dirent *entry;
	struct  stat statbuf;

	if ((dp = opendir (dir)) == NULL) {
		/*g_print ("ERREUR OPEN REP\n");*/
		return;
	}
	
	chdir (dir);
	while ((entry = readdir (dp)) != NULL) {
		if (winpulse_event_set_close () == FALSE) {

		lstat (entry->d_name, &statbuf);
			if (S_ISDIR (statbuf.st_mode)) {
				if (strcmp (".", entry->d_name) == 0 || strcmp ("..", entry->d_name) == 0) continue;
				fileanalyze_print_dir (entry->d_name);
			}
			else {
				/*ptrdir = g_get_current_dir ();*/
				ptrdir = get_current_dir_name();
				name = g_strdup_printf ("%s/%s", ptrdir, entry->d_name);
				
				fileselect_set_glist_from_str (name);
				
				/*g_print ("name=%s\n", name);*/
				g_free (ptrdir);
				ptrdir = NULL;
				g_free (name);
				name = NULL;
			}
		}
	}
	chdir ("..");
	closedir (dp);
}
void fileanalyze_recherche_recursive (gchar *path)
{
	fileanalyze_print_dir (path);
}

gdouble fileanalyze_get_percentage (gchar *p_str, FIC_SPLIT *FicSplit)
{
	gchar		*Ptr = NULL;
	guint		 Min, Sec, Hundr;
	gdouble		 SecondesTempsActuel = 0.0;
	gdouble		 PercentTempsActuel = 0.0;

	/* MINUTES */
	if ((Ptr = strchr (p_str, ':')) != NULL) {
		while (*Ptr != ' ') Ptr --;
		if (*Ptr == ' ') Ptr ++;
		Min = atoi (Ptr);

		/* SECONDES */
		if ((Ptr = strchr (p_str, ':')) != NULL) {
			Ptr ++;
			Sec = atoi (Ptr);

			/* CENTIEMES */
			if ((Ptr = strrchr (p_str, ':')) != NULL) {
				Ptr ++;
				Hundr = atoi (Ptr);
				
				//
				// #define GETTIMESEC (H,M,S,C) (gdouble)((H * 60) * 60) + (gdouble)(M * 60) + (gdouble)S + (gdouble)(C / 100.0)
				//
				
				/* Temps Total en secondes */
				// SecondesTempsActuel = (gdouble)(Min * 60) + (gdouble)Sec + (gdouble)(Hundr / 100.0);
				SecondesTempsActuel = GETTIMESEC (0,Min,Sec,Hundr);

				/* POURCENTAGE */
				if (FicSplit != NULL) {
					
					//
					// #define GETTIMEPERCENT(SecondesTempsActuel, AllTime) ((gdouble)SecondesTempsActuel / (gdouble)AllTime) * 100.
					//
					// PercentTempsActuel = (SecondesTempsActuel / (gdouble)FicSplit->GUINT_TempsTotal ) * 100.0;
					PercentTempsActuel = GETTIMEPERCENT(SecondesTempsActuel,FicSplit->GUINT_TempsTotal);
				}
			}
		}
	}
	
	return (PercentTempsActuel);
}

gchar *fileanalyze_get_title (gchar *p_str)
{
	gchar	*Ptr = NULL;
	gchar	*Str = NULL;
	
	Ptr = strchr (p_str, '"');
	Ptr ++;
	Str = g_strdup (Ptr);
	Ptr = strchr (Str, '"');
	*Ptr = '\0';
	
	/* Suppression du caracteres '/' interdit si il existe */
	if (strchr (Str, '/')) {
		while ((Ptr = strchr (Str, '/'))) {
			*Ptr = ' ';
		}
	}

	
	return ((gchar *)Str);
}

void fileanalyze_add_list_cue (gchar *NameCueFile)
{
#define SPLIT_MAX_CARS 1024
	FIC_SPLIT		*FicSplit = NULL;
	FIC_SPLIT		*DecoupesFicSplit = NULL;
	FIC_SPLIT		*_DecoupesFicSplit = NULL;
	GList			*List = NULL;
	GList			*_List = NULL;
	DETAIL			*detail = NULL;
	FILE			*fp;
	gchar			 buf   [ SPLIT_MAX_CARS +4 ];
	
	List = g_list_last (entetefile);
	if ((detail = (DETAIL *)List->data) != NULL) {
		if ((FicSplit = (FIC_SPLIT *)detail->fic_split) != NULL) {
			
			FicSplit->GUINT_TempsTotal = file_get_time_in_secondes (detail);
			splitshuttle_set_TimeSongSec (FicSplit->GUINT_TempsTotal);
			
			// g_print("-->FicSplit->GUINT_TempsTotal = %d\n",FicSplit->GUINT_TempsTotal);

			if ((fp = fopen (NameCueFile, "r")) == NULL) return;
						
			while (fgets (buf, SPLIT_MAX_CARS, fp) != NULL) {
				
				if (strstr (buf, "TRACK ")) {
					
					g_print("%s", buf);
					DecoupesFicSplit = g_malloc0 (sizeof (FIC_SPLIT));
					FicSplit->ListDecoupes = g_list_append (FicSplit->ListDecoupes, DecoupesFicSplit);
					DecoupesFicSplit->GUINT_TempsTotal = file_get_time_in_secondes (detail);
				}
				
				/* DEBUT */
				
				else if (strstr (buf, "INDEX 01")) {

					g_print("%s", buf);
					if (DecoupesFicSplit != NULL) {
						DecoupesFicSplit->AdrValueMarkA = fileanalyze_get_percentage (buf, FicSplit);
					}

				} 
				
				/* FIN */
				
				else if (strstr (buf, "INDEX 00")) {
					
					
					g_print("%s", buf);
					List = g_list_last (FicSplit->ListDecoupes);
					if ((List = g_list_previous (List)) != NULL) {
						
						FIC_SPLIT *Prev = (FIC_SPLIT *)List->data;
						if (Prev != NULL) {
							Prev->AdrValueMarkB = fileanalyze_get_percentage (buf, FicSplit);
						}
					}
					
					
				}
				
				else if (strstr (buf, "TITLE ")) {
					if (DecoupesFicSplit != NULL) {
						g_print("%s", buf);
						DecoupesFicSplit->Name = fileanalyze_get_title (buf);
					}
				}
			}
			
			fclose (fp);
			
			PRINT("....................AJOUTER LE CONTENU DE :");
			g_print ("\t%s\n", NameCueFile);
			
			if (DecoupesFicSplit != NULL) {

				if (DecoupesFicSplit->AdrValueMarkA == 0.) {
					DecoupesFicSplit->AdrValueMarkA = 100.;
				}
				
				if (DecoupesFicSplit->AdrValueMarkB == 0.) {
					DecoupesFicSplit->AdrValueMarkB = 100.;
				}
			}
		}
	}
	
	// VERIF POURCENTAGE DEBUT ET FIN 
	
	List = g_list_first (FicSplit->ListDecoupes);
	while (List) {
		if ((DecoupesFicSplit = (FIC_SPLIT *)List->data) != NULL) {
			// g_print ("DecoupesFicSplit->AdrValueMarkA = %f\n", DecoupesFicSplit->AdrValueMarkA);
			// g_print ("\tDecoupesFicSplit->AdrValueMarkB = %f\n", DecoupesFicSplit->AdrValueMarkB);
			if (DecoupesFicSplit->AdrValueMarkB == 0.0) {
				if ((_List = g_list_next (List)) != NULL) {
					if ((_DecoupesFicSplit = (FIC_SPLIT *)_List->data) != NULL) {
						DecoupesFicSplit->AdrValueMarkB = _DecoupesFicSplit->AdrValueMarkA;
						// g_print ("\tDecoupesFicSplit->AdrValueMarkB = %f\n", DecoupesFicSplit->AdrValueMarkB);
					}
				}
			}
		}
		List = g_list_next (List);
	}
#undef SPLIT_MAX_CARS
}

void fileanalyze_title_textview (gchar *txt, gint value)
{
	gchar * str = g_strdup_printf ("\n<b>---------------\n%s:  %d\n---------------</b>\n", txt, value);
	logs_label_import_file_add (str);
	g_free (str);
	str = NULL;
}


gboolean fileanalyze_linecommand_exist (void)
{
	return (var_analize.glist_analize == NULL ? FALSE : TRUE);
}


void fileanalyze_modify_glist_entetefile (void)
{
	GList            *list = NULL;
	DETAIL           *detail = NULL;
	FIC              *fic = NULL;
	GList            *freeglist = NULL;

	// PRINT_FUNC_LF();
	
	/* Parcourt de la liste
	*/
	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data) &&
		    (detail->remove == STRUCT_FIC_REMOVE ||
		     detail->remove == STRUCT_FIC_REMOVE_WAV ||
		     detail->remove == STRUCT_FIC_REMOVE_MP3OGG ||
		     detail->remove == STRUCT_FIC_REMOVE_SPLIT)) {
				
			switch (detail->remove) {
			case STRUCT_NO_REMOVE  :
				break;
			case STRUCT_FIC_REMOVE  :
			case STRUCT_FIC_REMOVE_WAV  :
			case STRUCT_FIC_REMOVE_MP3OGG  :
				if (detail->choice_treeview == _TREEVIEW_SPLIT_ALL_) {
					detail->choice_treeview = _TREEVIEW_SPLIT_;
					detail->remove = STRUCT_NO_REMOVE;
					list = g_list_next (list);
					continue;
				}
				break;
			case STRUCT_FIC_REMOVE_SPLIT  :
				if (detail->choice_treeview == _TREEVIEW_SPLIT_ALL_) {
					detail->choice_treeview = _TREEVIEW_ALL_;
					detail->remove = STRUCT_NO_REMOVE;
					list = g_list_next (list);
					continue;
				}
				break;
			}
			
			/* Desactive PLAY si actif
			*/
			if (((fic = (FIC *)detail->fic))) {
				fic->Etat_Normalise = NORM_NONE;
				if (fic->EtatPlay == FILE_ETAT_PLAY) {
					fic->EtatPlay = FILE_ETAT_PLAY_ATTENTE;
					PlayerExec_user_to_quit ();
					g_print("STOP PLAYSONG OF: %s\n",detail->namefile);
				}
			}

			/* Suppression des structures
			*/
			if (detail->remove == STRUCT_FIC_REMOVE ||
			    detail->remove == STRUCT_FIC_REMOVE_MP3OGG ||
			    detail->remove == STRUCT_FIC_REMOVE_WAV ||
			    detail->remove == STRUCT_FIC_REMOVE_SPLIT) {
				detail->fic        = fileanalyze_remove_info_fic ((FIC *)detail->fic);
				detail->fic_wav    = fileanalyze_remove_info_fic_wav ((FIC_WAV *)detail->fic_wav);
				detail->fic_mp3ogg = fileanalyze_remove_info_fic_mp3ogg ((FIC_MP3OGG *)detail->fic_mp3ogg);
				detail->fic_split  = fileanalyze_remove_info_fic_split ((FIC_SPLIT *)detail->fic_split);
			}

			detail->remove = STRUCT_NO_REMOVE;
			
			/* Liberer la liste des structures
			*/
			if (!detail->fic && !detail->fic_wav && !detail->fic_mp3ogg && !detail->fic_split) {
				freeglist = list;
				freeglist->data = NULL;
				list = g_list_next (list);
				entetefile = g_list_remove_link (entetefile, freeglist);
				list = g_list_first (entetefile);
				continue;
			}

		}
		list = g_list_next (list);
	}
	
	var_file.BOOL_ENTER = TRUE;
	file_set_flag_buttons_audio_file ();
	split_set_flag_buttons_audio ();
	file_affiche_glist_file ();
	split_affiche_glist ();
}

gchar *fileanalyze_get_name_without_path_ext (gchar *namefile, gboolean BoolVerif)
{
	gchar *NewName = g_strnfill (strlen(namefile) * 4, '\0');
	gchar *name = NULL;
	gchar *ptr = NULL;
	gchar *NewPtr = NewName;
	
	if ((ptr = strrchr (namefile, '/')))
		ptr ++;
	else	ptr = namefile;
	while (*ptr) {
		if (*ptr == '&') {
			*NewPtr ++ = *ptr ++;
			*NewPtr ++ = 'a';
			*NewPtr ++ = 'm';
			*NewPtr ++ = 'p';
			*NewPtr ++ = ';';
		}
		else {
			*NewPtr ++ = *ptr ++;
		}
	}
	
	if (BoolVerif == TRUE) {
		name = g_markup_escape_text (NewName, -1);
	}
	else {
		name = g_strdup (NewName);
	}
	g_free (NewName);
	NewName = NULL;

	/* Sans l'extention si elle existe */
	if ((ptr = strrchr (name, '.'))) *ptr = '\0';

	return ((gchar *)name);
}

gchar *fileanalyze_get_name_with_ext (gchar *namefile)
{
	gchar *name = NULL;
	gchar *ptr = NULL;
	
	if ((ptr = strrchr (namefile, '/'))) {
		ptr ++;
		name = g_strdup (ptr);
	}
	else {
		name = g_strdup ("???");
	}

	return ((gchar *)name);
}

/* IF detail->modif == TRUE THEN BEGIN
*
*  ENDIF
*
*/
void fileanalyze_set_flag_modif (gchar *pathname)
{
	gchar   *namesearch = fileanalyze_get_name_without_path_ext (pathname, FALSE);
	gchar   *ptr = NULL;
	GList   *list = NULL;
	DETAIL  *detail = NULL;

	// PRINT_FUNC_LF();

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			ptr = fileanalyze_get_name_without_path_ext (detail->namefile, FALSE);
			if (strcmp (ptr, namesearch) == 0) {
				detail->modif = TRUE;
			}
			g_free (ptr);
			ptr = NULL;
		}
		list = g_list_next (list);
	}
	g_free (namesearch);
	namesearch = NULL;
}

gboolean fileanalyze_IS_END_OF_add_file_to_treeview (void)
{
	return (var_analize.Bool_Timeout_Do);
}

void fileanalyze_update_info (void)
{
	GList          *list = NULL;
	DETAIL         *detail = NULL;

	ETAT_SELECTION   EtatSelection_Flac = ETAT_PRG_NONE;
	ETAT_SELECTION   EtatSelection_Wav = ETAT_PRG_NONE;
	ETAT_SELECTION   EtatSelection_Mp3 = ETAT_PRG_NONE;
	ETAT_SELECTION   EtatSelection_Ogg = ETAT_PRG_NONE;
	ETAT_SELECTION   EtatSelection_M4a = ETAT_PRG_NONE;
	ETAT_SELECTION   EtatSelection_Aac = ETAT_PRG_NONE;
	ETAT_SELECTION   EtatSelection_Mpc = ETAT_PRG_NONE;
	ETAT_SELECTION   EtatSelection_Ape = ETAT_PRG_NONE;
	ETAT_SELECTION   EtatSelection_WavPack = ETAT_PRG_NONE;
	
	ETAT_NORMALISE  Etat_Normalise = NORM_NONE;
	ETAT_REPLAYGAIN Etat_ReplayGain = RPG_NONE;
	LEVEL_DBFS      LevelDbfs = {-1,-1};
	ETAT_TRASH_FILE EtatTrash = FILE_TRASH_NONE;
	
	// PRINT_FUNC_LF();

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if (detail->modif == TRUE) {
				fileanalyze_set_flag_modif (detail->namefile);
			}
		}
		list = g_list_next (list);
	}

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if (detail->modif == FALSE) {
				list = g_list_next (list);
				continue;
			}

			if (detail->fic) {
				/* Sauvegarde des flags */
				FIC *fic = detail->fic;

				EtatSelection_Flac    = fic->EtatSelection_Flac;
				EtatSelection_Wav     = fic->EtatSelection_Wav;
				EtatSelection_Mp3     = fic->EtatSelection_Mp3;
				EtatSelection_Ogg     = fic->EtatSelection_Ogg;
				EtatSelection_M4a     = fic->EtatSelection_M4a;
				EtatSelection_Aac     = fic->EtatSelection_Aac;
				EtatSelection_Mpc     = fic->EtatSelection_Mpc;
				EtatSelection_Ape     = fic->EtatSelection_Ape;
				EtatSelection_WavPack = fic->EtatSelection_WavPack;
				
				Etat_Normalise        = fic->Etat_Normalise;
				Etat_ReplayGain       = fic->Etat_ReplayGain;
				EtatTrash             = fic->EtatTrash;
				
				detail->fic = (FIC *)fileanalyze_remove_info_fic (detail->fic);
			}
			if (detail->fic_wav) {
				detail->fic_wav = (FIC_WAV *)fileanalyze_remove_info_fic_wav (detail->fic_wav);
			}
			if (detail->fic_mp3ogg) {
				detail->fic_mp3ogg = (FIC_MP3OGG *)fileanalyze_remove_info_fic_mp3ogg (detail->fic_mp3ogg);
			}

			if (detail->type_infosong_file_is == FILE_IS_FLAC) {
				INFO_FLAC *info = (INFO_FLAC *)detail->info;
				detail->info = (INFO_FLAC *)tagsflac_remove_info (info);
			}
			else if (detail->type_infosong_file_is == FILE_IS_WAV) {
				INFO_WAV *info = (INFO_WAV *)detail->info;
				LevelDbfs    = info->LevelDbfs;
				detail->info = (INFO_WAV *)tagswav_remove_info (info);
			}
			else if (detail->type_infosong_file_is == FILE_IS_MP3) {
				INFO_MP3 *info = (INFO_MP3 *)detail->info;
				LevelDbfs    = info->LevelDbfs;
				detail->info = (INFO_MP3 *)tagsmp3_remove_info (info);
			}
			else if (detail->type_infosong_file_is == FILE_IS_OGG) {
				INFO_OGG *info = (INFO_OGG *)detail->info;
				LevelDbfs    = info->LevelDbfs;
				detail->info = (INFO_OGG *)tagsogg_remove_info (info);
			}
			else if (detail->type_infosong_file_is == FILE_IS_M4A) {
				INFO_M4A *info = (INFO_M4A *)detail->info;
				detail->info = (INFO_M4A *)tagsm4a_remove_info (info);
			}
			else if (detail->type_infosong_file_is == FILE_IS_AAC) {
				INFO_AAC *info = (INFO_AAC *)detail->info;
				detail->info = (INFO_AAC *)tagsaac_remove_info (info);
			}
			else if (detail->type_infosong_file_is == FILE_IS_SHN) {
				INFO_SHN *info = (INFO_SHN *)detail->info;
				detail->info = (INFO_SHN *)tagsshn_remove_info (info);
			}
			else if (detail->type_infosong_file_is == FILE_IS_WMA) {
				INFO_WMA *info = (INFO_WMA *)detail->info;
				detail->info = (INFO_WMA *)tagswma_remove_info (info);
			}
			else if (detail->type_infosong_file_is == FILE_IS_MPC) {
				INFO_MPC *info = (INFO_MPC *)detail->info;
				detail->info = (INFO_MPC *)tagsmpc_remove_info (info);
			}
			else if (detail->type_infosong_file_is == FILE_IS_APE) {
				INFO_APE *info = (INFO_APE *)detail->info;
				detail->info = (INFO_APE *)tagsape_remove_info (info);
			}
			else if (detail->type_infosong_file_is == FILE_IS_WAVPACK) {
				INFO_WAVPACK *info = (INFO_WAVPACK *)detail->info;
				detail->info = (INFO_WAVPACK *)tagswavpack_remove_info (info);
			}

			var_analize.choice_treeview = detail->choice_treeview;

			fileanalyze_set_data_treeview (detail->namefile, detail->type_infosong_file_is, FALSE);

			if (detail->fic) {
				/* Restitution des flags */
				FIC *fic = detail->fic;

				fic->EtatSelection_Flac    = EtatSelection_Flac;
				fic->EtatSelection_Wav     = EtatSelection_Wav;
				fic->EtatSelection_Mp3     = EtatSelection_Mp3;
				fic->EtatSelection_Ogg     = EtatSelection_Ogg;
				fic->EtatSelection_M4a     = EtatSelection_M4a;
				fic->EtatSelection_Aac     = EtatSelection_Aac;
				fic->EtatSelection_Mpc     = EtatSelection_Mpc;
				fic->EtatSelection_Ape     = EtatSelection_Ape;
				fic->EtatSelection_WavPack = EtatSelection_WavPack;

				fic->Etat_Normalise        = Etat_Normalise;
				fic->Etat_ReplayGain       = Etat_ReplayGain;
				fic->EtatTrash             = EtatTrash;
			}

			detail->count_item = 0;
			detail->modif = FALSE;
		}
		list = g_list_next (list);
	}

	file_UpdateTime_glist ();
	file_pixbuf_update_glist_file ();
}

// -----------------------------------------------------------------------------
// N O U V E A U    C O D E 
// -----------------------------------------------------------------------------

// 
// 
static gint Timeout_fileanalyze_do_verif_analyze_file_ (gpointer data)
{
	// ATENTE
	if (process_bool_action_is_ready () == FALSE && var_analize.BoolAnalyseIsOk == FALSE) {
		return (TRUE);
	}
	
	if (var_analize.event == EVENT_PROGRESS) {
		var_analize.event = EVENT_NONE;
		winpulse_set_elem_actif (var_analize.elem_actif);
	}
	else if (var_analize.Bool_Thread_Do == FALSE && var_analize.event == EVENT_END_THREAD) {

		gchar        *str = NULL;
		/*
		gdouble       gt;
		gulong        microseconds;
		*/
		GList        *list = NULL;
		FILE_ANALIZE *fa = NULL;
		
		if (!var_analize.bool_checkmp3_ok && !var_analize.bool_ogginfo_ok)
			str = g_strdup (_("ATTENTION: Il faut installer OGGINFO et CHECKMP3"));
		else if (!var_analize.bool_checkmp3_ok)
			str = g_strdup (_("ATTENTION: Il faut installer CHECKMP3"));
		else if (!var_analize.bool_ogginfo_ok)
			str = g_strdup (_("ATTENTION: Il faut installer OGGINFO"));
		else if (!var_analize.bool_faad_ok)
			str = g_strdup (_("ATTENTION: Il faut installer FAAD"));

		if (str) {
			utils_puts_statusbar_global (str);
			/*filemp3ogg_puts_label_statusbar (str);*/
			g_free (str);
			str = NULL;
		}

		if (!var_analize.bool_checkmp3_ok)	logs_label_import_file_add ("CHECKMP3 ABSENT\n");
		if (!var_analize.bool_ogginfo_ok)	logs_label_import_file_add ("OGGINFO ABSENT\n");
		if (!var_analize.bool_faad_ok)		logs_label_import_file_add ("FAAD ABSENT\n");

		if (var_analize.cpt_size_is_zero > 0) {
			fileanalyze_title_textview (_("LA TAILLE EST ZERO"), var_analize.cpt_size_is_zero);
			list = g_list_first (var_analize.glist_analize);
			while (list) {
				if ((fa = (FILE_ANALIZE *)list->data)) {
					if (fa->because == SIZE_IS_ZERO) {
						logs_label_import_file_add (fa->name);
						logs_label_import_file_add ("\n");
					}
				}
				list = g_list_next (list);
			}
		}
		
		if (var_analize.cpt_no_analizer > 0) {
			fileanalyze_title_textview (_("ANALISEUR MANQUANT"), var_analize.cpt_no_analizer);
			list = g_list_first (var_analize.glist_analize);
			while (list) {
				if ((fa = (FILE_ANALIZE *)list->data)) {
					if (fa->because == NO_ANALIZER) {
					if (fa->file_real == FILE_IS_MP3 && !var_analize.bool_checkmp3_ok)
						logs_label_import_file_add (_("CHECKMP3 absent  "));
					else if (fa->file_real == FILE_IS_OGG && !var_analize.bool_ogginfo_ok)
						logs_label_import_file_add (_("OGGINFO absent   "));
					logs_label_import_file_add (fa->name);
					logs_label_import_file_add ("\n");
					}
				}
				list = g_list_next (list);
			}
		}
		
		if (var_analize.cpt_modif_ext > 0) {
			fileanalyze_title_textview (_("MODIFICATION DE L'EXTENTION"), var_analize.cpt_modif_ext);
			list = g_list_first (var_analize.glist_analize);
			while (list) {
				if ((fa = (FILE_ANALIZE *)list->data)) {
					if (fa->because == MODIF_EXT) {
						logs_label_import_file_add (infosong_get_str_type_file_is (fa->file_ext));
						logs_label_import_file_add ("   to   ");
						logs_label_import_file_add (infosong_get_str_type_file_is (fa->file_real));
						logs_label_import_file_add ("     ");
						logs_label_import_file_add (fa->name);
						logs_label_import_file_add ("\n");
					}
				}
				list = g_list_next (list);
			}
		}

		var_analize.total_elem -= (var_analize.cpt_modif_ext + var_analize.cpt_no_analizer);

		/*
		g_timer_stop (gtime);
		gt = g_timer_elapsed (gtime, &microseconds);
		g_timer_destroy (gtime);
		gtime = NULL;
		utils_time_end ("FILE CLAUDE ");
		*/

		str = g_strdup_printf (_("\n<b>ANALYSE DE %d FICHIERS</b>\n"), var_analize.elem_actif);
		logs_label_import_file_add (str);
		g_free (str);
		str = NULL;
		
		switch (var_analize.choice_treeview) {
		case _TREEVIEW_ALL_ :
			file_notebook_in_file_switch_page (Config_User.notebook_file);

			fileanalyze_modify_glist_entetefile ();

			/*
			DEBUG
			Bascule vers l'onglet Fichiers
			Erreur trouvee et signalee par Guillaume:
				Les fichiers ne s'affichent pas suite un un download depuis le bureau  !!!!
				SOLUCE:
				Forcer le passage sur NOTEBOOK_DVD_AUDIO avant d'aller sur NOTEBOOK_FICHIERS
			*/
			gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")), NOTEBOOK_DVD_AUDIO);
			gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")), NOTEBOOK_FICHIERS);
			break;
		case _TREEVIEW_SPLIT_ :
		case _TREEVIEW_SPLIT_ALL_ :
			file_notebook_in_file_switch_page (Config_User.notebook_file);
			fileanalyze_modify_glist_entetefile ();
			break;
		}


		fileanalyze_clear_analyze_files_glist ();

		if (logs_get_checkbutton_goto_files_import () &&
			(var_analize.cpt_size_is_zero > 0 || var_analize.cpt_modif_ext > 0 || var_analize.cpt_no_analizer > 0)) {
			gtk_notebook_set_current_page (
				GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
				NOTEBOOK_LOGS);
			gtk_notebook_set_current_page (
				GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_logs")),
				NOTEBOOK_LOGS_FILE_IMPORT);
		}
		
		if (logs_set_datas_system () == TRUE) {
		
			gtk_notebook_set_current_page (
				GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
				NOTEBOOK_LOGS);
			gtk_notebook_set_current_page (
				GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_logs")),
				NOTEBOOK_LOGS_FILE_IMPORT);
		}
		
		file_set_flag_buttons_audio_file ();
		/* END OF progress and timeout */
		winpulse_close ();
		gtk_timeout_remove (var_analize.Handler_Timeout_Do);
		
		/* Marque la fin de la fonction */
		var_analize.Bool_Timeout_Do = FALSE;
		
		var_analize.cpt_no_analizer  = 0;
		var_analize.cpt_modif_ext    = 0;
		var_analize.cpt_size_is_zero = 0;
		
		fileselect_clear_glist ();
		
		cursor_set_old ();
	}

	return (TRUE);
}


DETAIL *fileanalyze_get_list (gchar *Name)
{
	GList	*List = NULL;
	DETAIL	*detail = NULL;
	
	List   = g_list_first (entetefile);
	while (List) {
		if ((detail = (DETAIL *)List->data) != NULL) {
			if (strcmp (detail->namefile, Name) == 0) return ((DETAIL *)detail);
		}
		List = g_list_next (List);
	}
	return ((DETAIL *)NULL);
}


// 
// 
static void fileanalyze_thread_do_verif_analyze_file_ (void *arg)
{
	GList         *list = NULL;
	gchar         *namefile = NULL;
	FILE_ANALIZE  *fa = NULL;
	
	// PRINT_FUNC_LF();

	var_analize.Bool_Thread_Do = TRUE;
	
	// ATENTE EN BOUCLE
	while (TRUE) {
		if (process_bool_action_is_ready () == TRUE && var_analize.BoolAnalyseIsOk == TRUE) break;
	}
	
	var_analize.total_elem = fileanalyze_get_total_file ();
	winpulse_set_ElemTotal (var_analize.total_elem);

	/* type progression */
	winpulse_set_init_progress ();
	winpulse_set_title (_("Analyse des fichiers"));
	var_analize.elem_actif = 0;

	var_analize.bool_checkmp3_ok = PrgInit.bool_checkmp3;
	var_analize.bool_ogginfo_ok  = PrgInit.bool_oggenc;
	var_analize.bool_faad_ok     = PrgInit.bool_faad;

	list = g_list_first (var_analize.glist_analize);
	while (list) {
		
		if (winpulse_event_set_close ()) {
			g_print ("CANCEL: End of analyze file\n");
			break;
		}

		if ((fa = (FILE_ANALIZE *)list->data)) {

			/* si repertoire alors continue */
			if (fa->bool_recursif == TRUE) {
				list = g_list_next (list);
				continue;
			}

			var_analize.elem_actif ++;
			winpulse_set_elem_actif (var_analize.elem_actif);

			if (fa->ptrname) {
				winpulse_set_labelfile (fa->ptrname);
			}

			if (fa->because == SIZE_IS_ZERO) {

				list = g_list_next (list);
				continue;
			}

			/* si les programmes externes sont absents alors continue */
			if ((fa->file_real == FILE_IS_MP3 && !var_analize.bool_checkmp3_ok) ||
					(fa->file_real == FILE_IS_OGG && !var_analize.bool_ogginfo_ok) ||
					(fa->file_real == FILE_IS_M4A && !var_analize.bool_faad_ok)
					) {

			  	fa->because = NO_ANALIZER;
			  	var_analize.cpt_no_analizer ++;

				list = g_list_next (list);
				continue;
			}

			namefile = g_strdup (fa->name);

			if (var_analize.choice_treeview == _TREEVIEW_SPLIT_) {
				if (
				    fa->file_real == FILE_IS_WAV /* ||
				    fa->file_real == FILE_IS_MP3 ||
				    fa->file_real == FILE_IS_OGG ||
				    fa->file_real == FILE_IS_FLAC ||
				    fa->file_real == FILE_IS_SHN ||
				    fa->file_real == FILE_IS_WAVPACK*/
				    ) {
					
					
					if (fa->BoolCueFile == FALSE) {
					
						NEW_HEADER_WAV HeaderWav;
						
						TagsWavGetHearder (namefile, &HeaderWav);
						if (HeaderWav.NbrBytes == 0) {
							
							gchar	  *str = NULL;
							
							str = g_strdup_printf ("<span color=\"blue\"><b>%s</b></span>", fa->name);
							logs_add_datas_system (str);
							g_free (str);
							str = NULL;
							logs_add_datas_system ("\n");
							logs_add_datas_system ("<b><i>");
							logs_add_datas_system (_("Mauvaise structure ou alors le fichier est compresse !"));
							logs_add_datas_system ("\n");
							logs_add_datas_system (_("Essayez depuis Fichier->Wav de modifier la frequence puis"));
							logs_add_datas_system ("\n");
							logs_add_datas_system (_("renouvelez l'operation d'import depuis Split."));
							logs_add_datas_system ("</i></b>");
							
							PRINT("CONTINUE");
							list = g_list_next (list);
							continue;
						}
						
					}
					
					// gint	   Channel, Hertz, Bits;
					// gchar	  *str = NULL;
					// DETAIL    *detail = NULL;
					// INFO_WAV  *info   = NULL;
					
					/*
					if (fa->BoolCueFile == FALSE) {
						
						if (tagswav_file_ChangeBitrate (namefile, &Channel, &Hertz, &Bits) == TRUE) {
						
							PRINT("INFO:");
							g_print("\tfa->BoolCueFile = %s\n", fa->BoolCueFile ? "TRUE" : "FALSE");
							g_print("\t%s\n", fa->name);
							g_print("\t%d voie,  %d hertz,  %d bits\n", Channel, Hertz, Bits);
							
							str = g_strdup_printf ("<span color=\"blue\"><b>%s</b></span>", fa->name);
							logs_add_datas_system (str);
							g_free (str);
							str = NULL;
							logs_add_datas_system ("\n");
							
							logs_add_datas_system ("<b>Requis: </b>\n\t");
							
							if (Hertz != 44100)			logs_add_datas_system ("<b>");
							logs_add_datas_system ("41000 hertz,  ");
							if (Hertz != 44100)			logs_add_datas_system ("</b>");
							
							if (Channel != 2)			logs_add_datas_system ("<b>");
							logs_add_datas_system ("2 channel(s),  ");
							if (Channel != 2)			logs_add_datas_system ("</b>");
							
							if (Bits != 16)				logs_add_datas_system ("<b>");
							logs_add_datas_system ("16 bits");
							if (Bits != 16)				logs_add_datas_system ("</b>");
							logs_add_datas_system ("\n");
							
							logs_add_datas_system ("<b>Actuel: </b>\n\t");
							str = g_strdup_printf("%s%d hertz%s,  %s%d channel(s)%s,  %s%d bits%s",
									(Hertz != 44100) ? "<span color=\"red\"><b>" : "",
									Hertz,
									(Hertz != 44100) ? "</b></span>" : "",
									(Channel != 2) ? "<span color=\"red\"><b>" : "",
									Channel,
									(Channel != 2) ? "</b></span>" : "",
									(Bits != 16) ? "<span color=\"red\"><b>" : "",
									Bits,
									(Bits != 16) ? "</b></span>" : ""
									);
							logs_add_datas_system (str);
							logs_add_datas_system ("\n");
							g_free (str);
							str = NULL;
						
							PRINT("CONTINUE");
							list = g_list_next (list);
							continue;
						}
					}
					*/
					
					PRINT("ANALYSE LE FICHIER ...");
					if (fileanalyze_set_data_treeview (namefile, fa->file_real, fa->BoolCueFile) == FALSE) {
						
						if (fa->BoolCueFile == TRUE) {
							PRINT("ANALYSE LE CUE ...");
							fileanalyze_add_list_cue (fa->NameCueFile);
						}
					}
					/*
					detail = fileanalyze_get_list (namefile);
					if (detail && (info = (INFO_WAV *)detail->info) != NULL) {
						
						Hertz   = atoi (info->hertz);
						Channel = atoi (info->voie);
						Bits    = atoi(info->bits);
						
						PRINT("INFO:");
						g_print("\tfa->BoolCueFile = %s\n", fa->BoolCueFile ? "TRUE" : "FALSE");
						g_print("\t%s\n", detail->namefile);
						g_print("\t%d voie,  %d hertz,  %d bits\n", Channel, Hertz, Bits);
						
						if (Channel != 2 || Hertz != 44100 || Bits != 16) {
							
							g_print("\tdetail->remove = STRUCT_FIC_REMOVE_SPLIT;\n");
							detail->remove = STRUCT_FIC_REMOVE_SPLIT;
							
							str = g_strdup_printf ("<span color=\"blue\"><b>%s</b></span>",  detail->namefile);
							logs_add_datas_system (str);
							g_free (str);
							str = NULL;
							logs_add_datas_system ("\n");
							
							logs_add_datas_system ("<b>Requis: </b>\n\t");
							
							if (Hertz != 44100)			logs_add_datas_system ("<b>");
							logs_add_datas_system ("41000 hertz,  ");
							if (Hertz != 44100)			logs_add_datas_system ("</b>");
							
							if (Channel != 2)			logs_add_datas_system ("<b>");
							logs_add_datas_system ("2 channel(s),  ");
							if (Channel != 2)			logs_add_datas_system ("</b>");
							
							if (Bits != 16)				logs_add_datas_system ("<b>");
							logs_add_datas_system ("16 bits");
							if (Bits != 16)				logs_add_datas_system ("</b>");
							logs_add_datas_system ("\n");
							
							logs_add_datas_system ("<b>Actuel: </b>\n\t");
							str = g_strdup_printf("%s%d hertz%s,  %s%d channel(s)%s,  %s%d bits%s",
									(Hertz != 44100) ? "<span color=\"red\"><b>" : "",
									Hertz,
									(Hertz != 44100) ? "</b></span>" : "",
									(Channel != 2) ? "<span color=\"red\"><b>" : "",
									Channel,
									(Channel != 2) ? "</b></span>" : "",
									(Bits != 16) ? "<span color=\"red\"><b>" : "",
									Bits,
									(Bits != 16) ? "</b></span>" : ""
									);
							logs_add_datas_system (str);
							logs_add_datas_system ("\n");
							g_free (str);
							str = NULL;
						}
					}
					*/
				}
			}
			else if (var_analize.choice_treeview == _TREEVIEW_ALL_) {
				/*
				if (fa->file_real == FILE_IS_WAV) {
					if (tagswav_file_ChangeBitrate (namefile) == TRUE) {
						PRINT("CONTINUE");
						list = g_list_next (list);
						continue;
					}
				}
				*/
				fileanalyze_set_data_treeview (namefile, fa->file_real, fa->BoolCueFile);
			}

			var_analize.event = EVENT_PROGRESS;
		}
		list = g_list_next (list);
	}
	var_analize.Bool_Thread_Do = FALSE;
	var_analize.event = EVENT_END_THREAD;
	secu_thread_sub ();
	pthread_exit(0);
}

//
//
gchar *fileanalyze_search_file_cue (gchar *p_path, gint *Err)
{
	FILE	*fp;
#define MAX_CARS 255
	gchar	 buf   [ MAX_CARS +1 ];
	gchar	*Ptr = NULL;
	gchar	*Str = NULL;
	gchar	*PathNameSong = NULL;
	gchar	*Path = NULL;
	
	// PRINT_FUNC_LF();
	
	/* Aucune erreur */
	if (Err != NULL) *Err = 0;
	
	if ((fp = fopen (p_path, "r")) == NULL) {
		if (Err != NULL) *Err = 1;
		return(NULL);
	}
	
	/*
	PERFORMER "Rita Mitsouko / Rita Mitsouko"
	TITLE "Rita Mitsouko / Rita Mitsouko"
	FILE "XCFA_CUE.wav" WAVE

	PERFORMER "José de Divina"
	TITLE "Ibiza World Tour @ Space"
	FILE "Ibiza1.mp3" WAVE
	
	REM GENRE Jazz
	REM DATE 1966
	REM DISCID 120F4902
	REM COMMENT "ExactAudioCopy v0.95b4"
	PERFORMER "John Coltrane"
	TITLE "Live in Japan (CD1)"
	FILE "un.flac" WAVE

	REM Cue file written by K3b 1.0.5
	PERFORMER "Rita Mitsouko"
	TITLE "Rita Mitsouko"
	FILE "01 - Restez Avec Moi.wav" WAVE
	*/
	
	while (fgets (buf, MAX_CARS, fp) != NULL) {
		
		/* Si debut de ligne ok */
		if ((Ptr = strstr (buf, "FILE \"")) != NULL) {

			/* Str contiendra le nom du fichier delimite par les signes "
			*/
			Ptr = strchr (buf, '"');
			Ptr ++;
			Str = g_strdup (Ptr);
			if ((Ptr = strrchr (Str, '"')) == NULL) {
				if (Err != NULL) *Err = 2;
				fclose (fp);
				g_free (Str);
				Str = NULL;
				return (NULL);
			}
			*Ptr = '\0';
			
			/* Path contiendra le chemin
			*/
			Path = g_strdup (p_path);
			if ((Ptr = strrchr (Path, '/')) != NULL) {
				*Ptr = '\0';
			}
			
			/* PathNameSong contiendra: chemin + nom du fichier musical
			*/
			PathNameSong = g_strdup_printf ("%s/%s", Path, Str);
			g_free (Path);
			Path = NULL;
			g_free (Str);
			Str = NULL;
			break;
		}
	}
	fclose (fp);
	
	if (PathNameSong == NULL) {
		if (Err != NULL) *Err = 3;
	}
	
	else if (infosong_g_str_has_suffix (PathNameSong, ".WAV") == FALSE &&
		 infosong_g_str_has_suffix (PathNameSong, ".MP3") == FALSE &&
		 infosong_g_str_has_suffix (PathNameSong, ".OGG") == FALSE &&
		 infosong_g_str_has_suffix (PathNameSong, ".FLAC") == FALSE &&
		 infosong_g_str_has_suffix (PathNameSong, ".WV") == FALSE &&
		 infosong_g_str_has_suffix (PathNameSong, ".SHN") == FALSE ) {
		
		g_print ("====\n%s\n----\n%s\t%s\n\t\tFILE NOT IN: .wav .mp3 .ogg .flac .wv .shn\n====\n", p_path, buf, PathNameSong);
		if (Err != NULL) *Err = 4;
		g_free (PathNameSong);
		PathNameSong = NULL;
	}

	return ((gchar *)PathNameSong);
}

// Thread create glist for: FILE_ANALIZE *fa = NULL;
//
static void fileanalyze_thread_do_create_glist_analyze_file_ (void *arg)
{
	FILE_ANALIZE	*fa = NULL;
	gchar		*PathNameFile  = NULL;
	GList		*List  = NULL;
	gchar		*namefile  = NULL;
	gchar		*NameCueFile  = NULL;
	TYPE_FILE_IS	 TypeFileIs;
	TYPE_FILE_IS	 TypeGetExt;
	gboolean	 BoolFileIsDir;
	gboolean	 BoolCue = FALSE;
	
	// PRINT_FUNC_LF();

	// OTHERS PROCESS NO RUN
	var_analize.BoolAnalyseIsOk = FALSE;
	
	// PROCESSUS D ANALYSE
	if (var_analize.ListFile == NULL) {
		var_analize.BoolAnalyseIsOk = TRUE;
		pthread_exit(0);
		return;
	}
	List = g_list_first (var_analize.ListFile);
	while (List) {
		
		BoolCue = FALSE;
		
		if (NameCueFile != NULL) {
			g_free (NameCueFile);
			NameCueFile = NULL;
		}
		
		if ((namefile = (gchar *)List->data) == NULL) {
			List = g_list_next (List);
			continue;
		}

		if (var_analize.BoolCueFile == TRUE && infosong_get_type_file_is (namefile) == FILE_IS_CUE) {

			// CONTROL ET RECUP DU NOM DE FICHIER CONTENU DEPUIS LE FICHIER CUE POUR LA VARIABLE: namefile
			
			if ((PathNameFile = fileanalyze_search_file_cue (namefile, NULL))) {
				
				NameCueFile = g_strdup (namefile);
				
				g_free ((gchar *)List->data);
				List->data = NULL;
				List->data = g_strdup (PathNameFile);
				namefile = (gchar *)List->data;
				
				g_free (PathNameFile);
				PathNameFile = NULL;
				
				BoolCue = TRUE;
			}
			else {
				g_free (PathNameFile);
				PathNameFile = NULL;
				List = g_list_next (List);
				continue;
			}
		}
		
		// SI name == DOSSIER ALORS RECHERCHE RECURSIVE

		if ((BoolFileIsDir = infosong_file_is_dir ((gchar *)namefile)) == TRUE) {
			fileanalyze_recherche_recursive (namefile);
			List = g_list_next (List);
			continue;
		}
		
		// SI name != FICHIER ALORS SUIVANT
		
		if (BoolFileIsDir == FALSE && infosong_file_is_reg ((gchar *)namefile) == FALSE) {
			List = g_list_next (List);
			continue;
		}
		
		// TODO
		// TROPS DE TEMPS D'ANALYZE DEPUIS:
		//	infosong_file_is ();
		TypeFileIs    = infosong_file_is (FILE_IS_NONE, namefile);
		TypeGetExt    = infosong_get_type_file_is (namefile);
		
		/*
		if (TypeFileIs == FILE_IS_FLAC)		logs_add_datas_system ("TypeFileIs == FILE_IS_FLAC\n");
		if (TypeFileIs == FILE_IS_WAV)		logs_add_datas_system ("TypeFileIs == FILE_IS_WAV\n");
		if (TypeFileIs == FILE_IS_MP3)		logs_add_datas_system ("TypeFileIs == FILE_IS_MP3\n");
		if (TypeFileIs == FILE_IS_OGG)		logs_add_datas_system ("TypeFileIs == FILE_IS_OGG\n");
		if (TypeFileIs == FILE_IS_M4A)		logs_add_datas_system ("TypeFileIs == FILE_IS_M4A\n");
		if (TypeFileIs == FILE_IS_AAC)		logs_add_datas_system ("TypeFileIs == FILE_IS_AAC\n");
		if (TypeFileIs == FILE_IS_SHN)		logs_add_datas_system ("TypeFileIs == FILE_IS_SHN\n");
		if (TypeFileIs == FILE_IS_WMA)		logs_add_datas_system ("TypeFileIs == FILE_IS_WMA\n");
		if (TypeFileIs == FILE_IS_MPC)		logs_add_datas_system ("TypeFileIs == FILE_IS_MPC\n");
		if (TypeFileIs == FILE_IS_APE)		logs_add_datas_system ("TypeFileIs == FILE_IS_APE\n");
		if (TypeFileIs == FILE_IS_WAVPACK)	logs_add_datas_system ("TypeFileIs == FILE_IS_WAVPACK\n");
		*/
				
		if (BoolFileIsDir == FALSE) {
			
			gchar		*LineCommand = NULL;
			
			if (TypeFileIs != FILE_IS_NONE && TypeGetExt == FILE_IS_NONE) {

				if (TypeFileIs == FILE_IS_FLAC)		PathNameFile = g_strdup_printf ("%s.flac", namefile);
				else if (TypeFileIs == FILE_IS_WAV)	PathNameFile = g_strdup_printf ("%s.wav", namefile);
				else if (TypeFileIs == FILE_IS_MP3)	PathNameFile = g_strdup_printf ("%s.mp3", namefile);
				else if (TypeFileIs == FILE_IS_OGG)	PathNameFile = g_strdup_printf ("%s.ogg", namefile);
				else if (TypeFileIs == FILE_IS_M4A)     PathNameFile = g_strdup_printf ("%s.m4a", namefile);
				else if (TypeFileIs == FILE_IS_AAC)     PathNameFile = g_strdup_printf ("%s.aac", namefile);
				else if (TypeFileIs == FILE_IS_SHN)	PathNameFile = g_strdup_printf ("%s.shn", namefile);
				else if (TypeFileIs == FILE_IS_WMA)	PathNameFile = g_strdup_printf ("%s.wma", namefile);
				else if (TypeFileIs == FILE_IS_MPC)	PathNameFile = g_strdup_printf ("%s.mpc", namefile);
				else if (TypeFileIs == FILE_IS_APE)	PathNameFile = g_strdup_printf ("%s.ape", namefile);
				else if (TypeFileIs == FILE_IS_WAVPACK) PathNameFile = g_strdup_printf ("%s.wv", namefile);
				else {
					List = g_list_next (List);
					continue;
				}
				
				LineCommand = g_strdup_printf ("mv \"%s\" \"%s\"", namefile, PathNameFile);
				system (LineCommand);
				g_free (LineCommand);
				LineCommand = NULL;
			}
			else if (TypeFileIs != FILE_IS_NONE && TypeFileIs != TypeGetExt) {
			
				if (TypeFileIs == FILE_IS_FLAC)		PathNameFile = g_strdup_printf ("%s.flac", namefile);
				else if (TypeFileIs == FILE_IS_WAV)	PathNameFile = g_strdup_printf ("%s.wav", namefile);
				else if (TypeFileIs == FILE_IS_MP3)	PathNameFile = g_strdup_printf ("%s.mp3", namefile);
				else if (TypeFileIs == FILE_IS_OGG)	PathNameFile = g_strdup_printf ("%s.ogg", namefile);
				else if (TypeFileIs == FILE_IS_M4A)	PathNameFile = g_strdup_printf ("%s.m4a", namefile);
				else if (TypeFileIs == FILE_IS_AAC)	PathNameFile = g_strdup_printf ("%s.aac", namefile);
				else if (TypeFileIs == FILE_IS_SHN)	PathNameFile = g_strdup_printf ("%s.shn", namefile);
				else if (TypeFileIs == FILE_IS_WMA)	PathNameFile = g_strdup_printf ("%s.wma", namefile);
				else if (TypeFileIs == FILE_IS_MPC)	PathNameFile = g_strdup_printf ("%s.mpc", namefile);
				else if (TypeFileIs == FILE_IS_APE)	PathNameFile = g_strdup_printf ("%s.ape", namefile);
				else if (TypeFileIs == FILE_IS_WAVPACK) PathNameFile = g_strdup_printf ("%s.wv", namefile);
				else {
					List = g_list_next (List);
					continue;
				}
				
				LineCommand = g_strdup_printf ("mv \"%s\" \"%s\"", namefile, PathNameFile);
				system (LineCommand);
				g_free (LineCommand);
				LineCommand = NULL;
			}
			else if (TypeFileIs == FILE_IS_NONE) {
				// L 'EXTENTION VALIDE LE CONTENU
				TypeFileIs = TypeGetExt;
			}
		}
		
		// OTHERS PROCESS NO RUN
		var_analize.BoolAnalyseIsOk = FALSE;
	
		// PROCESSUS D ANALYSE
		if (PathNameFile == NULL) {
			PathNameFile = g_strdup (namefile);
		}
		
		if (BoolFileIsDir == FALSE && infosong_type_is_song (PathNameFile) == FALSE) {
			g_free (PathNameFile);
			PathNameFile = NULL;
			
			List = g_list_next (List);
			continue;
		}

		if ((fa = g_malloc0 (sizeof (FILE_ANALIZE))) == NULL) {
			g_free (PathNameFile);
			PathNameFile = NULL;
			List = g_list_next (List);
			continue;
		}
		
		fa->name            = NULL;
		fa->ptrname         = NULL;
		fa->because         = BECAUSE_NONE;
		fa->file_ext        = FILE_IS_NONE;
		fa->file_real       = FILE_IS_NONE;
		fa->bool_recursif   = FALSE;
		fa->BoolCueFile     = BoolCue;
		fa->NameCueFile     = NameCueFile;
		
		if (infosong_get_size_file (PathNameFile) == 0) {

			fa->name     = g_strdup (PathNameFile);
			fa->because  = SIZE_IS_ZERO;
			g_print ("TAILLE EST ZERO: %s\n", PathNameFile);
			var_analize.glist_analize = g_list_append (var_analize.glist_analize, fa);
			var_analize.cpt_size_is_zero ++;
			
			g_free (PathNameFile);
			PathNameFile = NULL;
			
			List = g_list_next (List);
			continue;
		}

		fa->bool_recursif = BoolFileIsDir;
		fa->name =  g_strdup (PathNameFile);

		if (fa->bool_recursif == FALSE) {
			fa->file_ext  = TypeGetExt;
			fa->file_real = TypeFileIs;
			if ((fa->ptrname = strrchr (fa->name, '/')) != NULL) fa->ptrname ++;
			
			if (TypeFileIs != FILE_IS_NONE && (TypeGetExt == FILE_IS_NONE || TypeFileIs != TypeGetExt)) {
				fa->because = MODIF_EXT;
				var_analize.cpt_modif_ext ++;
				g_print("-------------------------MODIF_EXT\n");
			}
		}

		var_analize.glist_analize = g_list_append (var_analize.glist_analize, fa);

		g_free (PathNameFile);
		PathNameFile = NULL;
		// g_print("\tOK\n");
		
		List = g_list_next (List);
	}
	
	List = NULL;
	// La liste:
	//	var_analize.ListFile
	// sera supprimee a la fin du timeout par
	// 	fileselect_clear_glist ();

	// OTHERS PROCESS RUN
	var_analize.BoolAnalyseIsOk = TRUE;
	
	pthread_exit(0);
}

// 
// 
void fileanalyze_add_file_to_treeview_ (CHOICE_TREEVIEW choice_treeview, gboolean BoolCueFile)
{
	pthread_t nmr_tid_1;
	pthread_t nmr_tid_2;
	
	// gtime = g_timer_new ();
	// g_timer_start (gtime);
	// utils_time_start ();
	
	// PRINT_FUNC_LF();
	
	// CONDITION D ENTREE
	if ((var_analize.ListFile = fileselect_get_glist ()) == NULL) return;
	
	// SET DATAS
	var_analize.BoolAnalyseIsOk  = FALSE;
	var_analize.choice_treeview  = choice_treeview;
	var_analize.BoolCueFile      = BoolCueFile;
		
	var_analize.elem_actif       = 0;
	var_analize.total_elem       = 0;
	var_analize.event            = EVENT_NONE;
	var_analize.Bool_Thread_Do   = TRUE;
	var_analize.Bool_Timeout_Do  = TRUE;
	var_analize.bool_checkmp3_ok = PrgInit.bool_checkmp3;
	var_analize.bool_ogginfo_ok  = PrgInit.bool_oggenc;
	var_analize.bool_faad_ok     = PrgInit.bool_faad;
	
	// CREATE-WIN-PULSE
	utils_puts_statusbar_global ("");
	winpulse_create ();
	winpulse_set_title (_("Analyse recursive"));
	winpulse_set_init_pulse ();
	winpulse_set_labeltitle (_("Analyse des fichiers"));
	winpulse_set_labelfile (_("Analyse des dossiers"));
	
	cursor_set_watch ();
	
	// THREAD and TIMEOUT
	secu_thread_add ();
	pthread_create (&nmr_tid_1, NULL ,(void *)fileanalyze_thread_do_verif_analyze_file_, (void *)NULL);
	pthread_create (&nmr_tid_2, NULL ,(void *)fileanalyze_thread_do_create_glist_analyze_file_, (void *)NULL);
	var_analize.Handler_Timeout_Do = gtk_timeout_add (100, Timeout_fileanalyze_do_verif_analyze_file_, 0);
}


