 /*
 * file      : file_lc.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>
#include "support.h"

#include <string.h>
#include <stdlib.h>
 
#include "global.h"
#include "file.h"
#include "conv.h"
#include "options.h"
#include "poche.h"
#include "prg_init.h"
#include "cd_cue.h"
#include "utils.h"

/*
*---------------------------------------------------------------------------
* FONCTIONS
*---------------------------------------------------------------------------
*/

void filelc_analyse_line (gchar *entry, GList *New, TAGS *tags)
{
	gchar     **Larrbuf = NULL;
	gchar      *ptr = entry;
	GString    *gstr = NULL;
	gboolean    bool_tag = FALSE;
	gboolean    bool_open = FALSE;
	gint        i;
	
	while (ptr && *ptr) {
		if (*ptr == '\"') {
			if (bool_open == TRUE) {
				New = g_list_append (New, g_strdup (gstr->str));
				g_string_free (gstr, TRUE);
				gstr = NULL;
				ptr ++;
				bool_open = FALSE;
				continue;
			} else {
				ptr ++;
				bool_open = TRUE;
				continue;
			}
		}

		if (bool_open == TRUE) {
			if (gstr == NULL) gstr = g_string_new (NULL);
			g_string_append_printf (gstr, "%c", *ptr);
			ptr ++;
			continue;
		}

		if (*ptr == ' ') {
			if (gstr != NULL && *gstr->str) {
				New = g_list_append (New, g_strdup (gstr->str));
				g_string_free (gstr, TRUE);
				gstr = NULL;
			}
			ptr ++;
			continue;
		}
		else if (*ptr != '%') {
			if (gstr == NULL) gstr = g_string_new (NULL);
			g_string_append_printf (gstr, "%c", *ptr);
			ptr ++;
			continue;
		}

		if (*ptr == '%') {
			ptr ++;
			if ( *ptr == 'b' || *ptr == 'a' || *ptr == 't' || *ptr == 'l' || *ptr == 'N' || *ptr == 'G' || *ptr == 'c' || *ptr == 'd') {
				if (gstr == NULL) gstr = g_string_new (NULL);
			}

			/* OGGENC_WAV_TO_OGG | OGGENC_FLAC_TO_OGG */
			if (*ptr == 'b' && (*(ptr+1) == ' ' || *(ptr+1) == '\0')) {
				New = g_list_append (New, g_strdup_printf ("%s", optionsOggenc_get_val_bitrate_oggenc ()));
				ptr ++;
			}
			/* LAME_WAV_TO_MP3 */
			else if (*ptr == 'b' && *(ptr+1) == 'l' && (*(ptr+2) == ' ' || *(ptr+2) == '\0')) {
				Larrbuf = g_strsplit (optionsLame_get_str_val_bitrate_abr_vbr_lame (), " ", 0);
				for (i=0; Larrbuf[i]; i++) {
					New = g_list_append (New, g_strdup (Larrbuf[i]));
				}
				g_strfreev(Larrbuf);
				ptr ++;
				ptr ++;
			} else if (*ptr == 'a' && (*(ptr+1) == ' ' || *(ptr+1) == '\0')) {
				bool_tag = conv.Bool_artist_tag && tags && tags->Artist && *tags->Artist;
				g_string_append_printf (gstr, "%s", bool_tag ? tags->Artist : "*");
				ptr ++;
			} else if (*ptr == 't' && (*(ptr+1) == ' ' || *(ptr+1) == '\0')) {
				bool_tag = conv.Bool_title_tag && tags && tags->Title && *tags->Title;
				g_string_append_printf (gstr, "%s", bool_tag ? tags->Title : "*");
				ptr ++;
			} else if (*ptr == 'l' && (*(ptr+1) == ' ' || *(ptr+1) == '\0')) {
				bool_tag = conv.Bool_album_tag && tags && tags->Album && *tags->Album;
				g_string_append_printf (gstr, "%s", bool_tag ? tags->Album : "Album");
				ptr ++;
			} else if (*ptr == 'N' && (*(ptr+1) == ' ' || *(ptr+1) == '\0')) {
				bool_tag = conv.Bool_numerate_tag && tags && tags->Number && *tags->Number;
				g_string_append_printf (gstr, "%s", bool_tag ? tags->Number : "1");
				ptr ++;
			} else if (*ptr == 'G' && (*(ptr+1) == ' ' || *(ptr+1) == '\0')) {
				bool_tag = conv.Bool_genre_tag && tags && tags->Genre && *tags->Genre;
				g_string_append_printf (gstr, "%s", bool_tag ? tags->Genre : "100");
				ptr ++;
			} else if (*ptr == 'c' && (*(ptr+1) == ' ' || *(ptr+1) == '\0')) {
				bool_tag = conv.Bool_comment_tag && tags && tags->Comment && *tags->Comment;
				g_string_append_printf (gstr, "%s", bool_tag ? tags->Comment : "Comment");
				ptr ++;
			} else if (*ptr == 'd' && (*(ptr+1) == ' ' || *(ptr+1) == '\0')) {
				bool_tag = conv.Bool_year_tag && tags && tags->Year && *tags->Year;
				g_string_append_printf (gstr, "%s", bool_tag ? tags->Year : "2007");
				ptr ++;
			}
			else {
				while (ptr && *ptr != ' ') ptr ++;
			}
		}
	}
	if (gstr != NULL && *gstr->str) {
		New = g_list_append (New, g_strdup (gstr->str));
		g_string_free (gstr, TRUE);
		gstr = NULL;
	}
}


/* Construction d'une liste des parametres depuis la ligne de saisie
*/
/*
typedef struct {
	TYPE_CONV   type_conv;
	gchar      *entry;
	gchar      *filesrc;
	gchar      *filedest;
	TAG        *tag;
	gchar      *cdrom;
	gchar      *num_track;
} PARAM_FILELC;
*/
GList *filelc_analyse_command_line (PARAM_FILELC *param_filelc, gchar *entry)
{
	GList    *New = NULL;
	GString  *gstr = NULL;

	/*PRINT_FUNC_LF();*/

	if (param_filelc->type_conv == LAME_WAV_TO_MP3) {
		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		New = g_list_append (New, g_strdup ("lame"));

		filelc_analyse_line (entry, New, param_filelc->tags);

		New = g_list_append (New, g_strdup (param_filelc->filesrc));
		New = g_list_append (New, g_strdup (param_filelc->filedest));
	}
	else if (param_filelc->type_conv == OGGENC_WAV_TO_OGG || param_filelc->type_conv == OGGENC_FLAC_TO_OGG) {
		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		New = g_list_append (New, g_strdup ("oggenc"));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filesrc));

		filelc_analyse_line (entry, New, param_filelc->tags);

		New = g_list_append (New, g_strdup ("-o"));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filedest));
	}
	else if (param_filelc->type_conv == FLAC_WAV_TO_FLAC) {
		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		New = g_list_append (New, g_strdup ("flac"));

		filelc_analyse_line (entry, New, param_filelc->tags);

		New = g_list_append (New, g_strdup ("-f"));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filesrc));
		New = g_list_append (New, g_strdup ("-o"));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filedest));
	}
	else if (param_filelc->type_conv == FAAC_WAV_TO_M4A) {
		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		New = g_list_append (New, g_strdup ("faac"));

		filelc_analyse_line (entry, New, param_filelc->tags);

		New = g_list_append (New, g_strdup ("-o"));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filedest));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filesrc));
	}
	else if (param_filelc->type_conv == MPPENC_WAV_TO_MPC) {
		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		// New = g_list_append (New, g_strdup_printf ("%s", PrgInit.name_mppenc));
		New = g_list_append (New, g_strdup (prginit_get_name (NMR_mppenc)));

		filelc_analyse_line (entry, New, param_filelc->tags);

		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filesrc));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filedest));
	}
	else if (param_filelc->type_conv == MAC_WAV_TO_APE || param_filelc->type_conv == MAC_APE_TO_WAV) {
		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		// New = g_list_append (New, g_strdup_printf ("%s", PrgInit.name_ape));
		New = g_list_append (New, g_strdup (prginit_get_name (NMR_mac)));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filesrc));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filedest));

		filelc_analyse_line (entry, New, param_filelc->tags);
	}
	else if (param_filelc->type_conv == WAVPACK_WAV_TO_WAVPACK) {
		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		New = g_list_append (New, g_strdup ("wavpack"));

		filelc_analyse_line (entry, New, param_filelc->tags);

		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filesrc));
	}
	else if (param_filelc->type_conv == CDPARANOIA_CD_TO_WAV) {
		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		New = g_list_append (New, g_strdup ("cdparanoia"));
		New = g_list_append (New, g_strdup ("-e"));
		New = g_list_append (New, g_strdup ("-d"));
		New = g_list_append (New, g_strdup (param_filelc->cdrom));
		New = g_list_append (New, g_strdup (param_filelc->num_track));

		filelc_analyse_line (entry, New, param_filelc->tags);

		New = g_list_append (New, g_strdup (param_filelc->filedest));
	}
	else if (param_filelc->type_conv == CDDA2WAV_CD_TO_WAV) {
		/*
		cdda2wav -D /dev/hda -O wav -t 7
		*/
		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		New = g_list_append (New, g_strdup ("cdda2wav"));
		New = g_list_append (New, g_strdup ("-D"));
		New = g_list_append (New, g_strdup (param_filelc->cdrom));
		New = g_list_append (New, g_strdup ("-O"));
		New = g_list_append (New, g_strdup ("wav"));
		New = g_list_append (New, g_strdup ("-t"));
		New = g_list_append (New, g_strdup (param_filelc->num_track));
	}
	else {
		New = g_list_append (New, g_strdup (" ALORS !!"));
	}

	if (gstr != NULL) {
		g_string_free (gstr, TRUE);
		gstr = NULL;
	}

	return ((GList *)New);
}

void filelc_PRINT_GLIST (GList *New)
{
	GList *list = g_list_first (New);
	gchar *ptr = NULL;

	PRINT_FUNC_LF();

	while (list) {
		if ((ptr = (gchar*)list->data)) {
			g_print ("ptr='%s'\n", ptr);
		}
		list = g_list_next(list);
	}
}

GList *filelc_remove_glist (GList *New)
{
	GList *list = NULL;
	gchar *ptr = NULL;

	if (New != NULL) {
		list = g_list_first (New);
		while (list) {
			if ((ptr = (gchar*)list->data)) {
				g_free (ptr);
				ptr = NULL;
				list->data = NULL;
			}
			list = g_list_next(list);
		}
		g_list_free (New);
		New = NULL;
	}
	return ((GList *)NULL);
}

GList *filelc_add_options_for_visual (GList *p_list, gboolean p_bool_color, gchar *p_str)
{
	if (p_bool_color) {
		p_list = g_list_append (p_list, g_strdup_printf ("<span foreground=\"#0000FF\">%s</span>", p_str));
	} else {
		p_list = g_list_append (p_list, g_strdup (p_str));
	}
	return  ((GList *)p_list);
}

/* Recuperation des parametres internes pour visualisation depuis LIGNE POUR EXPERT
*/
GString *filelc_get_options_for_visual (TYPE_CONV type_conv)
{
	GList     *New = NULL;
	GList     *list = NULL;
	GString   *gstr = NULL;
	gchar     *ptr = NULL;
	gboolean   bool_one = TRUE;

	conv.Bool_artist_tag   = optionstags_get_checkbutton_artist_tag ();
	conv.Bool_title_tag    = optionstags_get_checkbutton_title_tag ();
	conv.Bool_album_tag    = optionstags_get_checkbutton_album_tag ();
	conv.Bool_numerate_tag = optionstags_get_checkbutton_numerate_tag ();
	conv.Bool_genre_tag    = optionstags_get_checkbutton_genre_tag ();
	conv.Bool_year_tag     = optionstags_get_checkbutton_year_tag ();
	conv.Bool_comment_tag  = optionstags_get_checkbutton_comment_tag ();

	if (type_conv == LAME_WAV_TO_MP3) {
		gchar         **Larrbuf = NULL;
		gint            i;

		New = g_list_append (New, g_strdup ("-h"));
		New = g_list_append (New, g_strdup ("--nohist"));
		/*
		LES OPTIONS CHANGEES EN COULEUR
		IDEE DE ROMAIN -> alteo_gange
		---------------------------------------------------------------------------------------------
		<span foreground=\"#0000FF\">  Xcfa sur le web</span>
		New = g_list_append (New, g_strdup ("<span foreground=\"#0000FF\">--noreplaygain</span>"));
		*/
		New = g_list_append (New, g_strdup ("--noreplaygain"));

		if (*optionsLame_get_str_val_mode_lame () != '\0') {
			Larrbuf = g_strsplit (optionsLame_get_str_val_mode_lame (), " ", 0);
			for (i=0; Larrbuf[i]; i++) {
				New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_LAME_MODE, Larrbuf[i]);
			}
			g_strfreev(Larrbuf);
		}

		Larrbuf = g_strsplit (optionsLame_get_str_val_bitrate_abr_vbr_lame (), " ", 0);
		for (i=0; Larrbuf[i]; i++) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_LAME_DEBIT, Larrbuf[i]);
		}
		g_strfreev(Larrbuf);

		if (conv.Bool_artist_tag || conv.Bool_title_tag || conv.Bool_album_tag ||
		    conv.Bool_numerate_tag || conv.Bool_genre_tag || conv.Bool_year_tag || conv.Bool_comment_tag) {

			New = filelc_add_options_for_visual (New, FALSE, "--add-id3v2");
		}
		if (conv.Bool_artist_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_ARTIST, "--ta %a");
		}
		if (conv.Bool_title_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_TITLE, "--tt %t");
		}
		if (conv.Bool_album_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_ALBUM, "--tl %l");
		}
		if (conv.Bool_numerate_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_NUMERATE, "--tn %N");
		}
		if (conv.Bool_genre_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_GENRE, "--tg %G");
		}
		if (conv.Bool_year_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_YEAR, "--ty %d");
		}
		if (conv.Bool_comment_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_COMMENT, "--tc %c");
		}
	}
	else if (type_conv == OGGENC_WAV_TO_OGG || type_conv == OGGENC_FLAC_TO_OGG) {

		New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_OGGENC_DEBIT, optionsOggenc_get_val_bitrate_oggenc ());
		
		if (optionsOggenc_get_bool_managed_oggenc () == TRUE) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_OGGENC_MANAGED, "--managed");
		}
		if (optionsOggenc_get_bool_downmix_oggenc () == TRUE) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_OGGENC_DOWNMIX, "--downmix");
		}
		
		if (conv.Bool_artist_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_ARTIST, "-a %a");
		}
		if (conv.Bool_title_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_TITLE, "-t %t");
		}
		if (conv.Bool_album_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_ALBUM, "-l %l");
		}
		if (conv.Bool_numerate_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_NUMERATE, "-N %N");
		}
		if (conv.Bool_genre_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_GENRE, "-G %G");
		}
		if (conv.Bool_year_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_YEAR, "--date %d");
		}
		if (conv.Bool_comment_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_COMMENT, "-c %c");
		}
	}
	else if (type_conv == FLAC_WAV_TO_FLAC) {

		New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_FLAC_TAUX_COMPRESSION, optionsFlac_get_compression_level_flac ());

		if (conv.Bool_artist_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_ARTIST, "-T artist=%a");
		}
		if (conv.Bool_title_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_TITLE, "-T title=%t");
		}
		if (conv.Bool_album_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_ALBUM, "-T album=%l");
		}
		if (conv.Bool_numerate_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_NUMERATE, "-T tracknumber=%N");
		}
		if (conv.Bool_genre_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_GENRE, "-T genre=%G");
		}
		if (conv.Bool_year_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_YEAR, "-T date=%d");
		}
		if (conv.Bool_comment_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_COMMENT, "-T Description=%c");
		}
	}
	else if (type_conv == FAAC_WAV_TO_M4A) {

		New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_FAAC_CONTENEUR, OptionsFaac_get_faac_conteneur ());
		New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_FAAC_SET_CHOICE_VBR_ABR, OptionsFaac_get_faac_set_choice_vbr_abr ());

		if (conv.Bool_artist_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_ARTIST, "--artist %a");
		}
		if (conv.Bool_title_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_TITLE, "--title %t");
		}
		if (conv.Bool_album_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_ALBUM, "--album %l");
		}
		if (conv.Bool_genre_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_GENRE, "--genre %G");
		}
		if (conv.Bool_year_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_YEAR, "--year %d");
		}
		if (conv.Bool_comment_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_COMMENT, "--comment %c");
		}
	}
	else if (type_conv == MPPENC_WAV_TO_MPC) {

		New = g_list_append (New, g_strdup ("--verbose"));
		New = g_list_append (New, g_strdup ("--overwrite"));

		New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_MUSEPACK_QUALITE, optionsMusepack_get_quality_mppenc ());

		if (conv.Bool_artist_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_ARTIST, "--artist %a");
		}
		if (conv.Bool_title_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_TITLE, "--title %t");
		}
		if (conv.Bool_album_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_ALBUM, "--album %l");
		}
		if (conv.Bool_genre_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_GENRE, "--genre %G");
		}
		if (conv.Bool_year_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_YEAR, "--year %d");
		}
		if (conv.Bool_numerate_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_NUMERATE, "--track %N");
		}
		if (conv.Bool_comment_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_COMMENT, "--comment %c");
		}
	}
	else if (type_conv == MAC_WAV_TO_APE || type_conv == MAC_APE_TO_WAV) {

		New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_MAC_QUALITE, optionsApe_get_compression_level_ape ());

	}
	else if (type_conv == WAVPACK_WAV_TO_WAVPACK) {

		New = g_list_append (New, g_strdup ("-y"));

		New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_WAVPACK_COMPRESSION, optionsWavpack_get_wavpack_compression ());

		New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_WAVPACK_SOUND, optionsWavpack_get_wavpack_sound ());

		if (*optionsWavpac_get_wavpack_hybride () != '\0') {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_WAVPACK_MODE_HYBRIDE, optionsWavpac_get_wavpack_hybride ());

			if (*optionsWavpack_get_wavpack_correction_file () != '\0') {
				New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_WAVPACK_FICHIER_CORRECTION, optionsWavpack_get_wavpack_correction_file ());
			}
			if (*optionsWavpack_get_wavpack_maximum_compression () != '\0') {
				New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_WAVPACK_COMPRESSION_MAXIMUM, optionsWavpack_get_wavpack_maximum_compression ());
			}
		}

		if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_WAVPACK_SIGNATURE_MD5, optionsWavpack_get_wavpack_signature_md5 ());
		}

		if (*optionsWavpack_get_wavpack_extra_encoding () != '\0') {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_WAVPACK_EXTRA_ENCODING, optionsWavpack_get_wavpack_extra_encoding ());
		}

		if (conv.Bool_artist_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_ARTIST, "-w Artist=%a");
		}
		if (conv.Bool_title_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_TITLE, "-w Title=%t");
		}
		if (conv.Bool_album_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_ALBUM, "-w Album=%l");
		}
		if (conv.Bool_genre_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_GENRE, "-w Genre=%G");
		}
		if (conv.Bool_year_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_YEAR, "-w Year=%d");
		}
		if (conv.Bool_numerate_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_NUMERATE, "-w Track=%N");
		}
		if (conv.Bool_comment_tag) {
			New = filelc_add_options_for_visual (New, var_options.ColorLineCommand == COLOR_TAG_COMMENT, "-w Comment=%c");
		}
	}

	/* Construction du GSTRING */
	list = g_list_first (New);
	if (list) {
		bool_one = TRUE;
		gstr = g_string_new (NULL);
		while (list) {
			if ((ptr = (gchar*)list->data)) {
				if (bool_one == TRUE) {
					/* SANS ESPACE */
					g_string_append_printf (gstr, "%s", ptr);
				}
				else {
					/* AVEC ESPACE */
					g_string_append_printf (gstr, " %s", ptr);
				}
				bool_one = FALSE;
			}
			list = g_list_next(list);
		}
	}

	/* Suppression du GLIST */
	list = g_list_first (New);
	while (list) {
		if ((ptr = (gchar*)list->data)) {
			g_free (ptr);
			ptr = NULL;
			list->data = NULL;
		}
		list = g_list_next(list);
	}
	g_list_free (New);
	New = NULL;

	return ((GString *)gstr);
}


/*
typedef struct {
	TYPE_CONV   type_conv;
	gboolean    With_CommandLineUser;
	gchar      *filesrc;
	gchar      *filedest;
	TAG        *tag;
	TAGCD      *tagcd;
	gchar      *cdrom;
	gchar      *num_track;
} PARAM_FILELC;
*/
GList *filelc_get_command_line (PARAM_FILELC *param_filelc)
{
	gchar	*entry = NULL;
	GList	*New = NULL;
	gchar	*Ptr = NULL;
	
	/* OPTIONS LIGNE DE SAISIE UTILISATEUR
	*/
	if (param_filelc->With_CommandLineUser == TRUE && options_bool_add_line_command (param_filelc->type_conv, &entry)) {
		
		if ((New = (GList *)filelc_analyse_command_line (param_filelc, entry))) {
			return ((GList *)New);
		}
	}
	param_filelc->With_CommandLineUser = FALSE;
	
	/*PRINT_FUNC_LF();*/
	
	/*
	g_print("TAGS:\n");
	if (conv.Bool_artist_tag)	g_print("\tArtiste   ");
	if (conv.Bool_title_tag)	g_print("Titre   ");
	if (conv.Bool_album_tag)	g_print("Album   ");
	if (conv.Bool_numerate_tag)	g_print("Numero   ");
	if (conv.Bool_genre_tag)	g_print("Genre   ");
	if (conv.Bool_year_tag)		g_print("Annee   ");
	if (conv.Bool_comment_tag)	g_print("Commentaire");
	g_print("\n");
	g_print("\n");
	*/
	
	/* OPTIONS PAR DEFAUT
	*/
	if (param_filelc->type_conv == LAME_WAV_TO_MP3) {
		gchar	**Larrbuf = NULL;
		gint	  i;

		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		New = g_list_append (New, g_strdup ("lame"));
		New = g_list_append (New, g_strdup ("-h"));
		New = g_list_append (New, g_strdup ("--nohist"));
		New = g_list_append (New, g_strdup ("--noreplaygain"));
		
		if (param_filelc->BoolSetBitrate == TRUE) {
			Larrbuf = g_strsplit (file_get_param_lame (), " ", 0);
			for (i=0; Larrbuf[i]; i++) {
				New = g_list_append (New, g_strdup (Larrbuf[i]));
			}
			g_strfreev(Larrbuf);
		}
		else {
			if ((Ptr = optionsLame_get_param_lame ()) != NULL) {
				Larrbuf = g_strsplit (Ptr, " ", 0);
				for (i=0; Larrbuf[i]; i++) {
					New = g_list_append (New, g_strdup (Larrbuf[i]));
				}
				g_strfreev(Larrbuf);
				
				g_free (Ptr);
				Ptr = NULL;
			}
			
		}

		if (conv.Bool_artist_tag || conv.Bool_title_tag || conv.Bool_album_tag ||
		    conv.Bool_numerate_tag || conv.Bool_genre_tag || conv.Bool_year_tag || conv.Bool_comment_tag) {
			New = g_list_append (New, g_strdup ("--add-id3v2"));
		}
		
		if (conv.Bool_artist_tag && param_filelc->tags && param_filelc->tags->Artist && *param_filelc->tags->Artist) {
			Ptr = utils_convert_from_utf8 (param_filelc->tags->Artist);
			if (*Ptr != '\0') {
				New = g_list_append (New, g_strdup ("--ta"));
				New = g_list_append (New, g_strdup_printf ("%s", Ptr));
			}
			g_free (Ptr);	Ptr = NULL;
		}
		
		if (conv.Bool_title_tag && param_filelc->tags && param_filelc->tags->Title && *param_filelc->tags->Title) {
			Ptr = utils_convert_from_utf8 (param_filelc->tags->Title);
			if (*Ptr != '\0') {
				New = g_list_append (New, g_strdup ("--tt"));
				New = g_list_append (New, g_strdup_printf ("%s", Ptr));
			}
			g_free (Ptr);	Ptr = NULL;
		}
		
		if (conv.Bool_album_tag && param_filelc->tags && param_filelc->tags->Album && *param_filelc->tags->Album) {
			Ptr = utils_convert_from_utf8 (param_filelc->tags->Album);
			if (*Ptr != '\0') {
				New = g_list_append (New, g_strdup ("--tl"));
				New = g_list_append (New, g_strdup_printf ("%s", Ptr));
			}
			g_free (Ptr);	Ptr = NULL;
		}
		
		if (conv.Bool_numerate_tag && param_filelc->tags && param_filelc->tags->Number && *param_filelc->tags->Number) {
			New = g_list_append (New, g_strdup ("--tn"));
			New = g_list_append (New, g_strdup_printf ("%s", param_filelc->tags->Number));
		}
		
		if (conv.Bool_genre_tag && param_filelc->tags && param_filelc->tags->Genre && *param_filelc->tags->Genre) {
			
			gint value = 147;
			
			if (param_filelc->tags->bool_tag_cd == FALSE) {
				value = infosong_get_genre_by_value (param_filelc->tags->Genre);
			} else {
				value = param_filelc->tags->IntGenre;
			}
			if (value < 0 || value > 147) value = 147;
			New = g_list_append (New, g_strdup ("--tg"));
			New = g_list_append (New, g_strdup_printf ("%d", value));
		}
		
		if (conv.Bool_year_tag && param_filelc->tags && param_filelc->tags->Year && *param_filelc->tags->Year) {
			New = g_list_append (New, g_strdup ("--ty"));
			New = g_list_append (New, g_strdup_printf ("%s", param_filelc->tags->Year));
		}
		
		if (conv.Bool_comment_tag && param_filelc->tags && param_filelc->tags->Comment && *param_filelc->tags->Comment) {
			Ptr = utils_convert_from_utf8 (param_filelc->tags->Comment);
			if (*Ptr != '\0') {
				New = g_list_append (New, g_strdup ("--tc"));
				New = g_list_append (New, g_strdup_printf ("%s", Ptr));
			}
			g_free (Ptr);	Ptr = NULL;
		}
		
		
		New = g_list_append (New, g_strdup (param_filelc->filesrc));
		New = g_list_append (New, g_strdup (param_filelc->filedest));
	}
	else if (param_filelc->type_conv == OGGENC_WAV_TO_OGG || param_filelc->type_conv == OGGENC_FLAC_TO_OGG) {

		gchar	**Larrbuf = NULL;
		gint	  i;

		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		New = g_list_append (New, g_strdup ("oggenc"));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filesrc));
		
		if (param_filelc->type_conv == OGGENC_WAV_TO_OGG && param_filelc->BoolSetBitrate == TRUE) {
			
			Larrbuf = g_strsplit (file_get_param_oggenc (), " ", 0);
			for (i=0; Larrbuf[i]; i++) {
				New = g_list_append (New, g_strdup (Larrbuf[i]));
			}
			g_strfreev(Larrbuf);
		}
		else {
			Larrbuf = g_strsplit (optionsOggenc_get_param_oggenc (), " ", 0);
			for (i=0; Larrbuf[i]; i++) {
				New = g_list_append (New, g_strdup (Larrbuf[i]));
			}
			g_strfreev(Larrbuf);
		}

		if (conv.Bool_artist_tag && param_filelc->tags && param_filelc->tags->Artist && *param_filelc->tags->Artist) {
			New = g_list_append (New, g_strdup ("-a"));
			New = g_list_append (New, g_strdup_printf ("%s", param_filelc->tags->Artist));
		}
		if (conv.Bool_title_tag && param_filelc->tags && param_filelc->tags->Title && *param_filelc->tags->Title) {
			New = g_list_append (New, g_strdup ("-t"));
			New = g_list_append (New, g_strdup_printf ("%s", param_filelc->tags->Title));
		}
		if (conv.Bool_album_tag && param_filelc->tags && param_filelc->tags->Album && *param_filelc->tags->Album) {
			New = g_list_append (New, g_strdup ("-l"));
			New = g_list_append (New, g_strdup_printf ("%s", param_filelc->tags->Album));
		}
		if (conv.Bool_numerate_tag && param_filelc->tags && param_filelc->tags->Number && *param_filelc->tags->Number) {
			New = g_list_append (New, g_strdup ("-N"));
			New = g_list_append (New, g_strdup_printf ("%s", param_filelc->tags->Number));
		}
		if (conv.Bool_genre_tag && param_filelc->tags && param_filelc->tags->Genre && *param_filelc->tags->Genre) {
			New = g_list_append (New, g_strdup ("-G"));
			New = g_list_append (New, g_strdup_printf ("%s", param_filelc->tags->Genre));
		}
		if (conv.Bool_year_tag && param_filelc->tags && param_filelc->tags->Year && *param_filelc->tags->Year) {
			New = g_list_append (New, g_strdup ("--date"));
			New = g_list_append (New, g_strdup_printf ("%s", param_filelc->tags->Year));
		}
		if (conv.Bool_comment_tag && param_filelc->tags && param_filelc->tags->Comment && *param_filelc->tags->Comment) {
			New = g_list_append (New, g_strdup ("-c"));
			New = g_list_append (New, g_strdup_printf ("comment=%s", param_filelc->tags->Comment));
		}

		New = g_list_append (New, g_strdup ("-o"));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filedest));
	}
	else if (param_filelc->type_conv == FLAC_WAV_TO_FLAC || param_filelc->type_conv == FLAC_FLAC_TO_WAV) {

		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		New = g_list_append (New, g_strdup ("flac"));
		New = g_list_append (New, g_strdup_printf ("%s",optionsFlac_get_compression_level_flac ()));

		if (conv.Bool_artist_tag && param_filelc->tags && param_filelc->tags->Artist && *param_filelc->tags->Artist) {
			New = g_list_append (New, g_strdup ("-T"));
			New = g_list_append (New, g_strdup_printf ("artist=%s",param_filelc->tags->Artist));
		}
		if (conv.Bool_title_tag && param_filelc->tags && param_filelc->tags->Title && *param_filelc->tags->Title) {
			New = g_list_append (New, g_strdup ("-T"));
			New = g_list_append (New, g_strdup_printf ("title=%s", param_filelc->tags->Title));
		}
		if (conv.Bool_album_tag && param_filelc->tags && param_filelc->tags->Album && *param_filelc->tags->Album) {
			New = g_list_append (New, g_strdup ("-T"));
			New = g_list_append (New, g_strdup_printf ("album=%s", param_filelc->tags->Album));
		}
		if (conv.Bool_numerate_tag && param_filelc->tags && param_filelc->tags->IntNumber > -1) {
			New = g_list_append (New, g_strdup ("-T"));
			New = g_list_append (New, g_strdup_printf ("tracknumber=%d", param_filelc->tags->IntNumber));
		}
		if (conv.Bool_genre_tag && param_filelc->tags && param_filelc->tags->Genre && *param_filelc->tags->Genre) {
			New = g_list_append (New, g_strdup ("-T"));
			New = g_list_append (New, g_strdup_printf ("genre=%s", param_filelc->tags->Genre));
		}
		if (conv.Bool_year_tag && param_filelc->tags && param_filelc->tags->Year && *param_filelc->tags->Year) {
			New = g_list_append (New, g_strdup ("-T"));
			New = g_list_append (New, g_strdup_printf ("date=%s", param_filelc->tags->Year));
		}
		if (conv.Bool_comment_tag && param_filelc->tags && param_filelc->tags->Comment && *param_filelc->tags->Comment) {
			New = g_list_append (New, g_strdup ("-T"));
			New = g_list_append (New, g_strdup_printf ("Description=%s",param_filelc->tags->Comment));
		}

		if (param_filelc->type_conv == FLAC_FLAC_TO_WAV) New = g_list_append (New, g_strdup ("-d"));

		New = g_list_append (New, g_strdup ("-f"));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filesrc));
		New = g_list_append (New, g_strdup ("-o"));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filedest));

	}
	else if (param_filelc->type_conv == FAAC_WAV_TO_M4A) {

		gchar *Ptr = NULL;
		
		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		New = g_list_append (New, g_strdup ("faac"));
		
		if (OptionsFaac_bool_get_faac_conteneur () == TRUE) {
			New = g_list_append (New, g_strdup_printf ("%s", OptionsFaac_get_faac_conteneur ()));
		}
		
		Ptr = OptionsFaac_get_faac_set_choice_vbr_abr ();
		if ( *(Ptr + 1) == 'b') {
			New = g_list_append (New, g_strdup ("-b"));
		}
		else {
			New = g_list_append (New, g_strdup ("-q"));
		}
		New = g_list_append (New, g_strdup_printf ("%s", (Ptr +3)));
		
		
		if (conv.Bool_artist_tag && param_filelc->tags && param_filelc->tags->Artist && *param_filelc->tags->Artist) {
			New = g_list_append (New, g_strdup ("--artist"));
			New = g_list_append (New, g_strdup_printf ("%s", param_filelc->tags->Artist));
		}
		if (conv.Bool_title_tag && param_filelc->tags && param_filelc->tags->Title && *param_filelc->tags->Title) {
			New = g_list_append (New, g_strdup ("--title"));
			New = g_list_append (New, g_strdup_printf ("%s", param_filelc->tags->Title));
		}
		if (conv.Bool_album_tag && param_filelc->tags && param_filelc->tags->Album && *param_filelc->tags->Album) {
			New = g_list_append (New, g_strdup ("--album"));
			New = g_list_append (New, g_strdup_printf ("%s", param_filelc->tags->Album));
		}
		if (conv.Bool_genre_tag && param_filelc->tags && param_filelc->tags->Genre && *param_filelc->tags->Genre) {
			New = g_list_append (New, g_strdup ("--genre"));
			New = g_list_append (New, g_strdup_printf ("%s", param_filelc->tags->Genre));
		}
		if (conv.Bool_year_tag && param_filelc->tags && param_filelc->tags->Year && *param_filelc->tags->Year) {
			New = g_list_append (New, g_strdup ("--year"));
			New = g_list_append (New, g_strdup_printf ("%s", param_filelc->tags->Year));
		}
		if (conv.Bool_comment_tag && param_filelc->tags && param_filelc->tags->Comment && *param_filelc->tags->Comment) {
			New = g_list_append (New, g_strdup ("--comment"));
			New = g_list_append (New, g_strdup_printf ("%s", param_filelc->tags->Comment));
		}
		New = g_list_append (New, g_strdup ("-o"));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filedest));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filesrc));
	}
	else if (param_filelc->type_conv == MPPENC_WAV_TO_MPC) {

		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		// New = g_list_append (New, g_strdup_printf ("%s", PrgInit.name_mppenc));
		New = g_list_append (New, g_strdup (prginit_get_name (NMR_mppenc)));
		New = g_list_append (New, g_strdup ("--verbose"));
		New = g_list_append (New, g_strdup ("--overwrite"));
		New = g_list_append (New, g_strdup_printf ("%s", optionsMusepack_get_quality_mppenc ()));

		if (conv.Bool_artist_tag && param_filelc->tags && param_filelc->tags->Artist && *param_filelc->tags->Artist) {
			New = g_list_append (New, g_strdup ("--artist"));
			Ptr = utils_convert_from_utf8 (param_filelc->tags->Artist);
			New = g_list_append (New, g_strdup_printf ("%s", Ptr));
			g_free (Ptr);	Ptr = NULL;
		}
		if (conv.Bool_title_tag && param_filelc->tags && param_filelc->tags->Title && *param_filelc->tags->Title) {
			New = g_list_append (New, g_strdup ("--title"));
			Ptr = utils_convert_from_utf8 (param_filelc->tags->Title);
			New = g_list_append (New, g_strdup_printf ("%s", Ptr));
			g_free (Ptr);	Ptr = NULL;
		}
		if (conv.Bool_album_tag && param_filelc->tags && param_filelc->tags->Album && *param_filelc->tags->Album) {
			New = g_list_append (New, g_strdup ("--album"));
			Ptr = utils_convert_from_utf8 (param_filelc->tags->Album);
			New = g_list_append (New, g_strdup_printf ("%s", Ptr));
			g_free (Ptr);	Ptr = NULL;
		}
		if (conv.Bool_genre_tag && param_filelc->tags && param_filelc->tags->Genre && *param_filelc->tags->Genre) {
			New = g_list_append (New, g_strdup ("--genre"));
			New = g_list_append (New, g_strdup_printf ("%s",param_filelc->tags->Genre));
		}
		if (conv.Bool_year_tag && param_filelc->tags && param_filelc->tags->Year && *param_filelc->tags->Year) {
			New = g_list_append (New, g_strdup ("--year"));
			New = g_list_append (New, g_strdup_printf ("%s", param_filelc->tags->Year));
		}
		if (conv.Bool_numerate_tag && param_filelc->tags && param_filelc->tags->Number && *param_filelc->tags->Number) {
			New = g_list_append (New, g_strdup ("--track"));
			New = g_list_append (New, g_strdup_printf ("%s", param_filelc->tags->Number));
		}
		if (conv.Bool_comment_tag && param_filelc->tags && param_filelc->tags->Comment && *param_filelc->tags->Comment) {
			New = g_list_append (New, g_strdup ("--comment"));
			Ptr = utils_convert_from_utf8 (param_filelc->tags->Comment);
			New = g_list_append (New, g_strdup_printf ("%s", Ptr));
			g_free (Ptr);	Ptr = NULL;
		}

		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filesrc));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filedest));
	}
	else if (param_filelc->type_conv == MAC_WAV_TO_APE || param_filelc->type_conv == MAC_APE_TO_WAV) {

		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		// New = g_list_append (New, g_strdup_printf ("%s", PrgInit.name_ape));
		New = g_list_append (New, g_strdup (prginit_get_name (NMR_mac)));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filesrc));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filedest));
		if (param_filelc->type_conv == MAC_APE_TO_WAV) {
			New = g_list_append (New, g_strdup ("-d"));
		}
		else if (param_filelc->type_conv == MAC_WAV_TO_APE) {
			New = g_list_append (New, g_strdup_printf ("%s", optionsApe_get_compression_level_ape ()));
		}
	}
	else if (param_filelc->type_conv == WAVPACK_WAV_TO_WAVPACK) {

		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		New = g_list_append (New, g_strdup ("wavpack"));
		New = g_list_append (New, g_strdup ("-y"));
		if (*optionsWavpack_get_wavpack_compression () != '\0')
			New = g_list_append (New, g_strdup_printf ("%s", optionsWavpack_get_wavpack_compression ()));
		New = g_list_append (New, g_strdup_printf ("%s", optionsWavpack_get_wavpack_sound ()));

		if (*optionsWavpac_get_wavpack_hybride () != '\0') {
			New = g_list_append (New, g_strdup_printf ("%s", optionsWavpac_get_wavpack_hybride ()));
			if (*optionsWavpack_get_wavpack_correction_file () != '\0') {
				New = g_list_append (New, g_strdup_printf ("%s", optionsWavpack_get_wavpack_correction_file ()));
			}
			if (*optionsWavpack_get_wavpack_maximum_compression () != '\0') {
				New = g_list_append (New, g_strdup_printf ("%s", optionsWavpack_get_wavpack_maximum_compression ()));
			}
		}
		if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
			New = g_list_append (New, g_strdup_printf ("%s", optionsWavpack_get_wavpack_signature_md5 ()));
		}
		if (*optionsWavpack_get_wavpack_extra_encoding () != '\0') {
			New = g_list_append (New, g_strdup_printf ("%s", optionsWavpack_get_wavpack_extra_encoding ()));
		}

		if (conv.Bool_artist_tag && param_filelc->tags && param_filelc->tags->Artist && *param_filelc->tags->Artist) {
			New = g_list_append (New, g_strdup ("-w"));
			New = g_list_append (New, g_strdup_printf ("Artist=%s", param_filelc->tags->Artist));
		}
		if (conv.Bool_title_tag && param_filelc->tags && param_filelc->tags->Title && *param_filelc->tags->Title) {
			New = g_list_append (New, g_strdup ("-w"));
			New = g_list_append (New, g_strdup_printf ("Title=%s", param_filelc->tags->Title));
		}
		if (conv.Bool_album_tag && param_filelc->tags && param_filelc->tags->Album && *param_filelc->tags->Album) {
			New = g_list_append (New, g_strdup ("-w"));
			New = g_list_append (New, g_strdup_printf ("Album=%s", param_filelc->tags->Album));
		}
		if (conv.Bool_genre_tag && param_filelc->tags && param_filelc->tags->Genre && *param_filelc->tags->Genre) {
			New = g_list_append (New, g_strdup ("-w"));
			New = g_list_append (New, g_strdup_printf ("Genre=%s", param_filelc->tags->Genre));
		}
		if (conv.Bool_year_tag && param_filelc->tags && param_filelc->tags->Year && *param_filelc->tags->Year) {
			New = g_list_append (New, g_strdup ("-w"));
			New = g_list_append (New, g_strdup_printf ("Year=%s", param_filelc->tags->Year));
		}
		if (conv.Bool_numerate_tag && param_filelc->tags && param_filelc->tags->Number && *param_filelc->tags->Number) {
			New = g_list_append (New, g_strdup ("-w"));
			New = g_list_append (New, g_strdup_printf ("Track=%s", param_filelc->tags->Number));
		}
		if (conv.Bool_comment_tag && param_filelc->tags &&param_filelc->tags->Comment && *param_filelc->tags->Comment) {
			New = g_list_append (New, g_strdup ("-w"));
			New = g_list_append (New, g_strdup_printf ("Comment=%s", param_filelc->tags->Comment));
		}

		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filesrc));
	}
	else if (param_filelc->type_conv == CDPARANOIA_CD_TO_WAV) {
		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		New = g_list_append (New, g_strdup ("cdparanoia"));
		New = g_list_append (New, g_strdup ("-e"));
		New = g_list_append (New, g_strdup ("-d"));
		New = g_list_append (New, g_strdup (param_filelc->cdrom));
		New = g_list_append (New, g_strdup (param_filelc->num_track));
		New = g_list_append (New, g_strdup (param_filelc->filedest));
	}
	else if (param_filelc->type_conv == CDDA2WAV_CD_TO_WAV) {
		/*
		cdda2wav -D /dev/hda -O wav -t 7
		*/
		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		New = g_list_append (New, g_strdup ("cdda2wav"));
		New = g_list_append (New, g_strdup ("-D"));
		New = g_list_append (New, g_strdup (param_filelc->cdrom));
		New = g_list_append (New, g_strdup ("-O"));
		New = g_list_append (New, g_strdup ("wav"));
		New = g_list_append (New, g_strdup ("-t"));
		New = g_list_append (New, g_strdup (param_filelc->num_track));
	}
	else if (param_filelc->type_conv == AACPLUSENC_WAV_TO_AAC) {
		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		New = g_list_append (New, g_strdup ("aacplusenc"));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filesrc));
		New = g_list_append (New, g_strdup_printf ("%s", param_filelc->filedest));
		
		if (param_filelc->tags->bool_tag_cd == TRUE) {
			New = g_list_append (New, g_strdup_printf ("%d",optionsaacplusenc_get_bitrate_stereo ()));
		}
		else {
			if (tagswav_file_is_mono (param_filelc->filesrc) == TRUE) {
				New = g_list_append (New, g_strdup_printf ("%d",optionsaacplusenc_get_bitrate_mono ()));
			} else {
				New = g_list_append (New, g_strdup_printf ("%d",optionsaacplusenc_get_bitrate_stereo ()));
			}
		}
	}

	return ((GList *)New);
}

GList *filelc_get_command_line_extract (PARAM_FILELC *param_filelc)
{
	GList          *New = NULL;
	
	if (param_filelc->type_conv == CDPARANOIA_CD_TO_WAV) {
		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		New = g_list_append (New, g_strdup ("cdparanoia"));
		New = g_list_append (New, g_strdup ("-e"));
		New = g_list_append (New, g_strdup ("-d"));
		New = g_list_append (New, g_strdup (param_filelc->cdrom));
		New = g_list_append (New, g_strdup (param_filelc->num_track));
		New = g_list_append (New, g_strdup (param_filelc->filedest));
	}
	else if (param_filelc->type_conv == CDPARANOIA_CD_TO_WAV_EXPERT) {
		
		gint NumTrack = atoi(param_filelc->num_track) -1;
		
		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		New = g_list_append (New, g_strdup ("cdparanoia"));
		New = g_list_append (New, g_strdup_printf ("[.%d]-[.%d]",
							BaseIoctl.Datas[ NumTrack ].begin < 44
							? 0
							: BaseIoctl.Datas[ NumTrack ].begin,
							NumTrack == 0
							? (BaseIoctl.Datas[ NumTrack ].length + BaseIoctl.Datas[ NumTrack ].begin) -1
							: BaseIoctl.Datas[ NumTrack ].length -1
							));
		New = g_list_append (New, g_strdup ("-e"));
		New = g_list_append (New, g_strdup ("-d"));
		New = g_list_append (New, g_strdup (param_filelc->cdrom));
		New = g_list_append (New, g_strdup ("-O"));
		New = g_list_append (New, g_strdup ("0"));
		New = g_list_append (New, g_strdup (param_filelc->filedest));
	}
	else if (param_filelc->type_conv == CDDA2WAV_CD_TO_WAV) {
		New = g_list_append (New, g_strdup ("nice"));
		New = g_list_append (New, g_strdup ("-n"));
		New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
		// New = g_list_append (New, g_strdup_printf ("%s", PrgInit.name_cdda2wav_icedax));
		New = g_list_append (New, g_strdup (prginit_get_name (NMR_icedax)));
		New = g_list_append (New, g_strdup ("-D"));
		New = g_list_append (New, g_strdup (param_filelc->cdrom));
		New = g_list_append (New, g_strdup ("-O"));
		New = g_list_append (New, g_strdup ("wav"));
		New = g_list_append (New, g_strdup ("-t"));
		New = g_list_append (New, g_strdup (param_filelc->num_track));
	}

	return ((GList *)New);
}


GList *filelc_get_command_line_extract_elem (gint Elem, gchar *Dev, gchar *Dest)
{
	GList          *New = NULL;
	
	New = g_list_append (New, g_strdup ("nice"));
	New = g_list_append (New, g_strdup ("-n"));
	New = g_list_append (New, g_strdup_printf ("%d", options_get_val_nice ()));
	New = g_list_append (New, g_strdup ("cdparanoia"));
	New = g_list_append (New, g_strdup_printf ("[.%d]-[.0]", Elem));
	New = g_list_append (New, g_strdup ("-e"));
	New = g_list_append (New, g_strdup ("-d"));
	New = g_list_append (New, g_strdup (Dev));
	New = g_list_append (New, g_strdup ("-O"));
	New = g_list_append (New, g_strdup ("0"));
	New = g_list_append (New, g_strdup (Dest));
	
	return ((GList *)New);
}








