 /*
 * file      : fileselect.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "support.h"
#include <stdlib.h>
#include <string.h>

#include "global.h"
#include "utils.h"
#include "config_user.h"
#include "win_info.h"
#include "fileselect.h"
#include "file.h"
#include "cd_audio.h"
#include "win_control.h"
#include "poche.h"



/*
*---------------------------------------------------------------------------
* DEFINITIONS
*---------------------------------------------------------------------------
*/

typedef enum {

	_REP_SIMPLE_,
	_REP_MULTIPLE_,
	_FILE_SIMPLE_,
	_FILE_MULTIPLE_,
	_FILE_IMG_SIMPLE_,
	_FILE_IMG_MULTIPLE_

} TYPE_SELECT;


typedef struct {
	gchar		 *Title;
	gchar		**Path;
	TYPE_SELECT	  TypeSelect;
	GtkWidget	 *AdrFileChooser;
	void		  (*Call_Func) (GtkButton *button, gpointer user_data);
	void		  (*Func_Extern) (gchar *string);
} SELECT;


typedef struct {

	GList		*List;
	gboolean	 BoolInitDatas;
	
} VAR_FILESELECT;

VAR_FILESELECT	VarFileSelect = { NULL, FALSE };


/*
*---------------------------------------------------------------------------
* PROTOTYPES
*---------------------------------------------------------------------------
*/

void ON_button_PATH_DESTINATION_CD_clicked (GtkButton *button, gpointer user_data);
void ON_button_PATH_DESTINATION_DVD_clicked (GtkButton *button, gpointer user_data);
void ON_button_PATH_DESTINATION_FILE_clicked (GtkButton *button, gpointer user_data);
void ON_button_PATH_DESTINATION_FILE_WAV_clicked (GtkButton *button, gpointer user_data);
void ON_button_PATH_DESTINATION_FILE_MP3OGG_clicked (GtkButton *button, gpointer user_data);

void ON_button_PATH_DESTINATION_SPLIT_clicked (GtkButton *button, gpointer user_data);

void ON_button_LOAD_FILE_clicked (GtkButton *button, gpointer user_data);
void ON_button_PATH_IMPORT_FILE_WAV_clicked (GtkButton *button, gpointer user_data);
void ON_button_PATH_IMPORT_FILE_MP3OGG_clicked (GtkButton *button, gpointer user_data);
void ON_button_PATH_IMPORT_FILE_SPLIT_clicked (GtkButton *button, gpointer user_data);
void ON_button_PATH_IMPORT_IMAGES_clicked (GtkButton *button, gpointer user_data);

void ON_button_PATH_STOCKE_IMAGES_POCHETTE_clicked (GtkButton *button, gpointer user_data);
void ON_button_PATH_DEST_FILE_POSTSCRIPT_clicked (GtkButton *button, gpointer user_data);
void ON_button_PATH_LOAD_DVD_FROM_DIRECTORY_clicked (GtkButton *button, gpointer user_data);

void ON_button_PATH_TEMP_clicked (GtkButton *button, gpointer user_data);

/*
*---------------------------------------------------------------------------
* DATAS
*---------------------------------------------------------------------------
*/

SELECT Select [ ] =
{
{NULL,
 &Config_User.Path_Destination_CD,              _REP_SIMPLE_,		NULL, ON_button_PATH_DESTINATION_CD_clicked,		NULL},

{NULL,
 &Config_User.Path_Destination_DVD,             _REP_SIMPLE_,		NULL, ON_button_PATH_DESTINATION_DVD_clicked,		NULL},

{NULL,
 &Config_User.Path_Destination_file,            _REP_SIMPLE_,		NULL, ON_button_PATH_DESTINATION_FILE_clicked,		NULL},

{NULL,
 &Config_User.Path_Destination_file_wav,	_REP_SIMPLE_,		NULL, ON_button_PATH_DESTINATION_FILE_WAV_clicked,	NULL},

{NULL,
 &Config_User.Path_Destination_file_mp3ogg,     _REP_SIMPLE_,		NULL, ON_button_PATH_DESTINATION_FILE_MP3OGG_clicked,	NULL},
 
{NULL,
 &Config_User.Path_Destination_split,		_REP_SIMPLE_,		NULL, ON_button_PATH_DESTINATION_SPLIT_clicked,		NULL},

{NULL,
 &Config_User.Path_Load_file,                   _FILE_MULTIPLE_,	NULL, ON_button_LOAD_FILE_clicked,			NULL},

{NULL,
 &Config_User.Path_Import_File_WAV,             _FILE_MULTIPLE_,	NULL, ON_button_PATH_IMPORT_FILE_WAV_clicked,		NULL},

{NULL,
 &Config_User.Path_Import_File_MP3OGG,          _FILE_MULTIPLE_,	NULL, ON_button_PATH_IMPORT_FILE_MP3OGG_clicked,	NULL},

{NULL,
 &Config_User.Path_Import_FileSplit,    	_FILE_MULTIPLE_,	NULL, ON_button_PATH_IMPORT_FILE_SPLIT_clicked,		NULL},

{NULL,
 &Config_User.Path_Load_Images,			_FILE_IMG_MULTIPLE_,	NULL, ON_button_PATH_IMPORT_IMAGES_clicked ,		NULL},

{NULL,
 &Config_User.Path_Stocke_Images_Pochette,      _REP_SIMPLE_,		NULL, ON_button_PATH_STOCKE_IMAGES_POCHETTE_clicked,	NULL},

{NULL,
 &Config_User.Path_Dest_File_PostScript,        _REP_SIMPLE_,		NULL, ON_button_PATH_DEST_FILE_POSTSCRIPT_clicked,	NULL},

{NULL,
 &Config_User.Path_Load_File_DVD,		_REP_SIMPLE_,		NULL, ON_button_PATH_LOAD_DVD_FROM_DIRECTORY_clicked,	NULL},

{NULL,
 &Config_User.Path_TMP,				_REP_SIMPLE_,		NULL, ON_button_PATH_TEMP_clicked,			NULL},

{NULL, NULL, -1}
};



/*  Supprimer le contenu de: VarFileSelect.List
 */ 
void fileselect_clear_glist (void)
{
	GList	*List = NULL;

	if ((List = g_list_first (VarFileSelect.List)) != NULL) {
		while (List) {
			if ((gchar *)List->data != NULL) {
				g_free ((gchar *)List->data);
				List->data = NULL;
			}
			List = g_list_next (List);
		}
		g_list_free (VarFileSelect.List);
	}
	VarFileSelect.List = NULL;
}


/*  Placer le contenu de la GSLIST dans: VarFileSelect.List
 */ 
GList *fileselect_set_glist_from_gslist (GSList *p_gslist)
{
	gchar	*Ptr = NULL;
	
	while (p_gslist) {
		/* Si pointeur non null */
		if ((Ptr = (gchar *)p_gslist->data) != NULL) {
			/* Constructuion GList */
			VarFileSelect.List = g_list_append (VarFileSelect.List, g_strdup ((gchar *)Ptr));
		}
		/* GSList suivante */
		p_gslist = g_slist_next (p_gslist);
	}
	return ((GList *)VarFileSelect.List);
}

GList *fileselect_set_glist_from_str (gchar *p_str)
{
	VarFileSelect.List = g_list_append (VarFileSelect.List, g_strdup ((gchar *)p_str));
	return ((GList *)VarFileSelect.List);
}

GList *fileselect_get_glist (void)
{
	return ((GList *)VarFileSelect.List);
}

/*
*---------------------------------------------------------------------------
* FUNCTIONS
*---------------------------------------------------------------------------
*/
void ON_button_PATH_TEMP_clicked (GtkButton *button, gpointer user_data)
{
	gint    Choice = GPOINTER_TO_INT(user_data);
	gchar  *Path = NULL;

	/* PRINT_FUNC_LF(); */

	Path = gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser));
wincontrol_remove_last ();
	if (Select[ Choice ].Func_Extern) (*Select[ Choice ].Func_Extern) (Path);
	g_free (Path);
	Path = NULL;

	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
}

void ON_button_PATH_LOAD_DVD_FROM_DIRECTORY_clicked (GtkButton *button, gpointer user_data)
{
	gint    Choice = GPOINTER_TO_INT(user_data);
	gchar  *Path = NULL;

	/* PRINT_FUNC_LF(); */

	Path = gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser));
	if (Select[ Choice ].Func_Extern) (*Select[ Choice ].Func_Extern) (Path);
	g_free (Path);
	Path = NULL;

	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
wincontrol_remove_last ();
}

void ON_button_PATH_DEST_FILE_POSTSCRIPT_clicked (GtkButton *button, gpointer user_data)
{
	gint    Choice = GPOINTER_TO_INT(user_data);
	gchar  *Path = NULL;

	/* PRINT_FUNC_LF(); */

	Path = gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser));

	g_free (Config_User.Path_Dest_File_PostScript);
	Config_User.Path_Dest_File_PostScript = NULL;
	Config_User.Path_Dest_File_PostScript = g_strdup (Path);

	if (Select[ Choice ].Func_Extern) (*Select[ Choice ].Func_Extern) (Path);
	g_free (Path);
	Path = NULL;

	/*
	Path = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser));

	if (infosong_file_is_reg (Path)) {
		if (Select[ Choice ].Func_Extern) (*Select[ Choice ].Func_Extern) (Path);
		g_free (Config_User.Path_Dest_File_PostScript);
		Config_User.Path_Dest_File_PostScript = NULL;
		Config_User.Path_Dest_File_PostScript = g_strdup (Path);
	}
	g_free (Path);
	Path = NULL;
	*/
	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
wincontrol_remove_last ();
}

void ON_button_PATH_STOCKE_IMAGES_POCHETTE_clicked (GtkButton *button, gpointer user_data)
{
	gint    Choice = GPOINTER_TO_INT(user_data);
	gchar  *Path = NULL;

	/* PRINT_FUNC_LF(); */

	Path = gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser));

	if (Select[ Choice ].Func_Extern) (*Select[ Choice ].Func_Extern) (Path);
	g_free (Config_User.Path_Stocke_Images_Pochette);
	Config_User.Path_Stocke_Images_Pochette = NULL;
	Config_User.Path_Stocke_Images_Pochette = g_strdup (Path);
	g_free (Path);
	Path = NULL;
	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
wincontrol_remove_last ();
}

void ON_button_PATH_IMPORT_IMAGES_clicked (GtkButton *button, gpointer user_data)
{
	GSList   *LL = NULL, *List = NULL;
	gboolean  Bool_New_Path = FALSE;
	gint	  Choice = GPOINTER_TO_INT(user_data);
	gchar    *Path = NULL;
	gchar    *ptr = NULL;

	/* PRINT_FUNC_LF(); */
	LL = List = gtk_file_chooser_get_filenames (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser));

	if (List == NULL) {
		Path = gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser));
		pochedir_create_glist ((gchar *)Path, TRUE);
		/* nouveau chemin */
		if ((ptr = strrchr (Path, '/'))) {
			/* g_print ("Path = %s\n", Path); */
			*ptr = '\0';
			/* g_print ("Path = %s\n", Path); */
			g_free (Config_User.Path_Load_Images);
			Config_User.Path_Load_Images = NULL;
			Config_User.Path_Load_Images = g_strdup (Path);

		}
		gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
		Select[ Choice ].AdrFileChooser = NULL;
wincontrol_remove_last ();
		g_free (Path);
		Path = NULL;
		if (Select[ Choice ].Func_Extern) (*Select[ Choice ].Func_Extern) (Path);
		return;
	}

	while (List) {
		if (pochedir_create_glist ((gchar *)List->data, TRUE)) Bool_New_Path = TRUE;
		List = g_slist_next (List);
	}
	g_slist_free (LL);
	LL = NULL;

	if (Bool_New_Path == TRUE) {
		g_free (Config_User.Path_Load_Images);
		Config_User.Path_Load_Images = NULL;
		Config_User.Path_Load_Images =
			g_strdup (gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser)));
	}
	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
wincontrol_remove_last ();
	if (Bool_New_Path) {
		if (Select[ Choice ].Func_Extern) (*Select[ Choice ].Func_Extern) (Path);
	}
}

/*
*/
void ON_button_PATH_DESTINATION_CD_clicked (GtkButton *button, gpointer user_data)
{
	gchar  *Path = NULL;
	gint    Choice = GPOINTER_TO_INT(user_data);

	/* PRINT_FUNC_LF(); */

	Path = gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser));

wincontrol_remove_last ();
	if (Select[ Choice ].Func_Extern) (*Select[ Choice ].Func_Extern) (Path);

	g_free (Path);
	Path = NULL;
	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
}

void ON_button_PATH_DESTINATION_DVD_clicked (GtkButton *button, gpointer user_data)
{
	gchar  *Path = NULL;
	gint    Choice = GPOINTER_TO_INT(user_data);

	/* PRINT_FUNC_LF(); */

	Path = gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser));

wincontrol_remove_last ();
	if (Select[ Choice ].Func_Extern) (*Select[ Choice ].Func_Extern) (Path);

	g_free (Path);
	Path = NULL;
	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
}

/*
*/
void ON_button_PATH_DESTINATION_FILE_clicked (GtkButton *button, gpointer user_data)
{
	gint    Choice = GPOINTER_TO_INT(user_data);
	gchar  *Path = NULL;

	/* PRINT_FUNC_LF(); */

	Path = gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser));
wincontrol_remove_last ();
	if (Select[ Choice ].Func_Extern) (*Select[ Choice ].Func_Extern) (Path);
	g_free (Path);
	Path = NULL;

	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
}

void ON_button_PATH_DESTINATION_FILE_WAV_clicked (GtkButton *button, gpointer user_data)
{
	gint    Choice = GPOINTER_TO_INT(user_data);
	gchar  *Path = NULL;

	/* PRINT_FUNC_LF(); */

	Path = gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser));
wincontrol_remove_last ();
	if (Select[ Choice ].Func_Extern) (*Select[ Choice ].Func_Extern) (Path);
	g_free (Path);
	Path = NULL;

	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
}

void ON_button_PATH_DESTINATION_FILE_MP3OGG_clicked (GtkButton *button, gpointer user_data)
{
	gint    Choice = GPOINTER_TO_INT(user_data);
	gchar  *Path = NULL;

	/* PRINT_FUNC_LF(); */

	Path = gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser));
wincontrol_remove_last ();
	if (Select[ Choice ].Func_Extern) (*Select[ Choice ].Func_Extern) (Path);
	g_free (Path);
	Path = NULL;

	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
}

void ON_button_PATH_DESTINATION_SPLIT_clicked (GtkButton *button, gpointer user_data)
{
	gint    Choice = GPOINTER_TO_INT(user_data);
	gchar  *Path = NULL;

	/* PRINT_FUNC_LF(); */

	Path = gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser));
wincontrol_remove_last ();
	if (Select[ Choice ].Func_Extern) (*Select[ Choice ].Func_Extern) (Path);
	g_free (Path);
	Path = NULL;

	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
}

void ON_button_LOAD_FILE_clicked (GtkButton *button, gpointer user_data)
{
	GSList   *List = NULL;
	gint      Choice = GPOINTER_TO_INT(user_data);

	// PRINT_FUNC_LF();
	
	// RECUPERE LA LISTE EN SELECTION
	List = gtk_file_chooser_get_filenames (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser));
	// REMOVE GLIST VarFileSelect.List
	fileselect_clear_glist ();
	// CREATE GLIST VarFileSelect.List WITH GSLIST List
	fileselect_set_glist_from_gslist (List);
	// REMOVE GSLIST List
	g_slist_free (List);
	List = NULL;
	// SAVE PATH
	g_free (Config_User.Path_Load_file);
	Config_User.Path_Load_file = NULL;
	Config_User.Path_Load_file = g_strdup (gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser)));
	// DESTROY WIN-FILESELECT
	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
	wincontrol_remove_last ();
	// ANALYSE AND LOAD LIST-FILE
	fileanalyze_add_file_to_treeview_ (_TREEVIEW_ALL_, TRUE);
	// IF PRESENT PARAMETER TO CALL
	if (Select[ Choice ].Func_Extern) (*Select[ Choice ].Func_Extern) (NULL);
}

/*
*/
void ON_button_PATH_IMPORT_FILE_WAV_clicked (GtkButton *button, gpointer user_data)
{
	GSList   *List = NULL;
	gint      Choice = GPOINTER_TO_INT(user_data);

	// PRINT_FUNC_LF();
	
	// RECUPERE LA LISTE EN SELECTION
	List = gtk_file_chooser_get_filenames (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser));
	// REMOVE GLIST VarFileSelect.List
	fileselect_clear_glist ();
	// CREATE GLIST VarFileSelect.List WITH GSLIST List
	fileselect_set_glist_from_gslist (List);
	// REMOVE GSLIST List
	g_slist_free (List);
	List = NULL;
	// SAVE PATH
	g_free (Config_User.Path_Import_File_WAV);
	Config_User.Path_Import_File_WAV = NULL;
	Config_User.Path_Import_File_WAV = g_strdup (gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser)));
	// DESTROY WIN-FILESELECT
	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
	wincontrol_remove_last ();
	// ANALYSE AND LOAD LIST-FILE
	fileanalyze_add_file_to_treeview_ (_TREEVIEW_ALL_, TRUE);
	// IF PRESENT PARAMETER TO CALL
	if (Select[ Choice ].Func_Extern) (*Select[ Choice ].Func_Extern) (NULL);
}

/*
*/
void ON_button_PATH_IMPORT_FILE_MP3OGG_clicked (GtkButton *button, gpointer user_data)
{
	GSList   *List = NULL;
	gint      Choice = GPOINTER_TO_INT(user_data);

	// PRINT_FUNC_LF();
	
	// RECUPERE LA LISTE EN SELECTION
	List = gtk_file_chooser_get_filenames (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser));
	// REMOVE GLIST VarFileSelect.List
	fileselect_clear_glist ();
	// CREATE GLIST VarFileSelect.List WITH GSLIST List
	fileselect_set_glist_from_gslist (List);
	// REMOVE GSLIST List
	g_slist_free (List);
	List = NULL;
	// SAVE PATH
	g_free (Config_User.Path_Import_File_MP3OGG);
	Config_User.Path_Import_File_MP3OGG = NULL;
	Config_User.Path_Import_File_MP3OGG = g_strdup (gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser)));
	// DESTROY WIN-FILESELECT
	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
	wincontrol_remove_last ();
	// ANALYSE AND LOAD LIST-FILE
	fileanalyze_add_file_to_treeview_ (_TREEVIEW_ALL_, TRUE);
	// IF PRESENT PARAMETER TO CALL
	if (Select[ Choice ].Func_Extern) (*Select[ Choice ].Func_Extern) (NULL);
}

void ON_button_PATH_IMPORT_FILE_SPLIT_clicked (GtkButton *button, gpointer user_data)
{
	GSList   *List = NULL;
	gint      Choice = GPOINTER_TO_INT(user_data);

	// PRINT_FUNC_LF();
	
	// RECUPERE LA LISTE EN SELECTION
	List = gtk_file_chooser_get_filenames (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser));
	// REMOVE GLIST VarFileSelect.List
	fileselect_clear_glist ();
	// CREATE GLIST VarFileSelect.List WITH GSLIST List
	fileselect_set_glist_from_gslist (List);
	// REMOVE GSLIST List
	g_slist_free (List);
	List = NULL;
	// SAVE PATH
	g_free (Config_User.Path_Import_FileSplit);
	Config_User.Path_Import_FileSplit = NULL;
	Config_User.Path_Import_FileSplit = g_strdup (gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (Select[ Choice ].AdrFileChooser)));
	// DESTROY WIN-FILESELECT
	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
	wincontrol_remove_last ();
	// ANALYSE AND LOAD LIST-FILE
	fileanalyze_add_file_to_treeview_ (_TREEVIEW_SPLIT_, TRUE);
	// IF PRESENT PARAMETER TO CALL
	if (Select[ Choice ].Func_Extern) (*Select[ Choice ].Func_Extern) (NULL);
}

/*
*---------------------------------------------------------------------------
* GESTION FILESELECT
*---------------------------------------------------------------------------
*/

/* Demande de destruction de la fenetre
*  --
*  entree :
*      GtkWidget *widget  :
*      GdkEvent *event    :
*      gpointer user_data :
*  retour : -
*/
gboolean fileselect_on_filechooserdialog_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	gint    Choice = GPOINTER_TO_INT(user_data);

	/* PRINT_FUNC_LF(); */
	/*
	g_print ("user_data = %d\n", (gint)user_data);
	g_print ("Choice    = %d\n", Choice);
	*/
	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
wincontrol_remove_last ();
	return FALSE;
}

/* Demande de destruction de la fenetre
*  --
*  entree :
*      GtkWidget *widget  :
*      GdkEvent *event    :
*      gpointer user_data :
*  retour : -
*/
gboolean fileselect_on_filechooserdialog_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	gint    Choice = GPOINTER_TO_INT(user_data);

	/* PRINT_FUNC_LF(); */
	/*
	g_print ("user_data = %d\n", (gint)user_data);
	g_print ("Choice    = %d\n", Choice);
	*/
	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
wincontrol_remove_last ();
	return FALSE;
}

/*
*  --
*  entree :
*      GtkButton *button  :
*      gpointer user_data :
*  retour : -
*/
void fileselect_on_button_cancel_clicked (GtkButton *button, gpointer user_data)
{
	gint    Choice = GPOINTER_TO_INT(user_data);

	/* PRINT_FUNC_LF(); */
	/*
	g_print ("user_data = %d\n", (gint)user_data);
	g_print ("Choice    = %d\n", Choice);
	*/
	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
wincontrol_remove_last ();
}

/*
*  --
*  entree :
*      GtkButton *button  :
*      gpointer user_data :
*  retour : -
*/
void fileselect_on_button_ok_clicked (GtkButton *button, gpointer user_data)
{
	gint    Choice = GPOINTER_TO_INT(user_data);

	/* PRINT_FUNC_LF(); */
	/*
	g_print ("user_data = %d\n", (gint)user_data);
	g_print ("Choice    = %d\n", Choice);
	*/
	gtk_widget_destroy(Select[ Choice ].AdrFileChooser);
	Select[ Choice ].AdrFileChooser = NULL;
wincontrol_remove_last ();
}

/*
http://forum.gtk-fr.org/viewtopic.php?pid=22743
*/
void chooserDialog_preview_update (GtkFileChooser *filechooser, gpointer data)
{
	/*-- WIDGETS --*/
	GtkWidget *preview;
	GdkPixbuf *pixbuf;
	char *filename;
	gboolean have_preview;

	preview = GTK_WIDGET (data);
	filename = gtk_file_chooser_get_preview_filename(filechooser);

	/*
	Lors de l'ouverture d'un repertoire, filename vaut toujours NULL,
	(du moins sous windows).
	Si le test n'est pas fait,
	la seule concequence est un WARNING en console.
	*/
	if (filename != NULL) {
		/*Creation du pixbud de l'image*/
		pixbuf = gdk_pixbuf_new_from_file_at_size(filename, 150, 150, NULL);
		/*Definition de l'etat d'affichage de previsualisation*/
		have_preview = (pixbuf != NULL);

		g_free (filename);

		/*Creation de l'image*/
		gtk_image_set_from_pixbuf (GTK_IMAGE(preview), pixbuf);
		/*if (pixbuf) gdk_pixbuf_unref (pixbuf);*/
		if (pixbuf) g_object_unref(pixbuf);
		
		gtk_file_chooser_set_preview_widget_active(filechooser, have_preview);
	}
}


void fileselect_remove_comment (void)
{
	gint index;
		
	for (index = 0; index < _NB_PATH_; index ++) {
		g_free (Select[ index ].Title);
		Select[ index ].Title = NULL;
	}
}


void fileselect_init_comment (void)
{
	Select[ _PATH_DESTINATION_CD_ ].Title		= g_strdup (_("Destination des extractions"));
	Select[ _PATH_DESTINATION_DVD_ ].Title		= g_strdup (_("Destination des extractions"));
	Select[ _PATH_DESTINATION_FILE_ ].Title		= g_strdup (_("Destination des conversions"));
	Select[ _PATH_DESTINATION_FILE_WAV_ ].Title	= g_strdup (_("Destination des conversions (Wav)"));
	Select[ _PATH_DESTINATION_FILE_MP3OGG_ ].Title	= g_strdup (_("Destination des conversions (Mp3, Ogg)"));
	Select[ _PATH_DESTINATION_SPLIT_ ].Title	= g_strdup (_("Destination SPLIT"));
	Select[ _PATH_LOAD_FILE_ ].Title		= g_strdup (_("Importer des fichier(s)"));
	Select[ _PATH_IMPORT_FILE_WAV_ ].Title		= g_strdup (_("Importer des fichiers WAV"));
	Select[ _PATH_IMPORT_FILE_MP3OGG_ ].Title	= g_strdup (_("Importer des fichiers WAV,OGG,MP3"));
	Select[ _PATH_IMPORT_FILE_SPLIT_ ].Title	= g_strdup (_("SPLIT: Importer fichiers WAV et/ou CUE"));
	Select[ _PATH_IMPORT_IMAGES_ ].Title		= g_strdup (_("Importer des images pour la pochette"));
	Select[ _PATH_STOCKE_IMAGES_POCHETTE_ ].Title	= g_strdup (_("Repertoire de stockage des images pochette"));
	Select[ _PATH_DEST_FILE_POSTSCRIPT_ ].Title	= g_strdup (_("Repertoire de stockage des images pochette"));
	Select[ _PATH_LOAD_DVD_FROM_DIRECTORY_ ].Title	= g_strdup (_("Importer un dossier contenant un DVD"));
	Select[ _PATH_TEMP_ ].Title			= g_strdup (_("Choix d'un dossier temporaire"));

}


/* Demande de creation de la fenetre de selection de fichier(s) ou de repertoire
*  --
*  entree :
*      TYPE_FILESELECTION Choice :
*      void *Func_Extern         :
*  retour : -
*/
void fileselect_create (TYPE_FILESELECTION Choice, void *Func_Extern)
{
	GtkWidget *filechooserdialog;
	GtkWidget *dialog_vbox1;
	GtkWidget *dialog_action_area1;
	GtkWidget *button_cancel;
	GtkWidget *button_ok;
	GtkWidget *preview;
	GtkFileFilter *filter;

	/* PRINT_FUNC_LF(); */
	if (VarFileSelect.BoolInitDatas == FALSE) {
		VarFileSelect.BoolInitDatas = TRUE;
		fileselect_init_comment ();
	}
	
	if (_NB_PATH_ <= 0) return;
	if (Choice < 0 || Choice > _NB_PATH_) return;
	/*if (Choice < _PATH_DESTINATION_CD_ || Choice > _NB_PATH_) return (NULL);*/
	filechooserdialog = Select[ Choice ].AdrFileChooser;

	if (filechooserdialog != NULL) {
		gdk_window_raise (filechooserdialog->window);
		return;
	}

	/* CORRECTIF DU 26 01 2006 */
	Select[ Choice ].Func_Extern = Func_Extern;

	/* CORRECTIF DU 28 05 2006 */
	g_utf8_validate (Select[ Choice ].Title, -1, NULL);

	/*
	typedef enum
	{
	  GTK_FILE_CHOOSER_ACTION_OPEN,
	  GTK_FILE_CHOOSER_ACTION_SAVE,
	  GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
	  GTK_FILE_CHOOSER_ACTION_CREATE_FOLDER
	} GtkFileChooserAction;
	*/
	if (Select[ Choice ].TypeSelect == _REP_SIMPLE_ || Select[ Choice ].TypeSelect == _REP_MULTIPLE_) {
		/* selection de directory */
		filechooserdialog = gtk_file_chooser_dialog_new (Select[ Choice ].Title,
								  NULL,
								  GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
								  /* |
								  GTK_FILE_CHOOSER_ACTION_CREATE_FOLDER,
								  */
								  NULL,
								  NULL);
	}
	else if (Select[ Choice ].TypeSelect == _FILE_SIMPLE_ || Select[ Choice ].TypeSelect == _FILE_MULTIPLE_) {
		/* selection de fichiers(s) */
		filechooserdialog = gtk_file_chooser_dialog_new (Select[ Choice ].Title,
								  NULL,
								  GTK_FILE_CHOOSER_ACTION_OPEN,
								  NULL,
								  NULL);
		if (Choice == _PATH_IMPORT_FILE_WAV_) {
		
			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("WAV (*.wav)"));
			gtk_file_filter_add_pattern (filter, "*.wav");
			gtk_file_filter_add_pattern (filter, "*.WAV");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);
			
			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("All Files (*.*)"));
			gtk_file_filter_add_pattern (filter, "*");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);
		}
		
		else if (Choice == _PATH_IMPORT_FILE_MP3OGG_) {
		
			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("All Files (*.*)"));
			gtk_file_filter_add_pattern (filter, "*.mp3");
			gtk_file_filter_add_pattern (filter, "*.MP3");
			gtk_file_filter_add_pattern (filter, "*.ogg");
			gtk_file_filter_add_pattern (filter, "*.OGG");
			gtk_file_filter_add_pattern (filter, "*.oga");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);

			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("MP3 (*.mp3)"));
			gtk_file_filter_add_pattern (filter, "*.mp3");
			gtk_file_filter_add_pattern (filter, "*.MP3");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);

			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("OGG (*.ogg)"));
			gtk_file_filter_add_pattern (filter, "*.ogg");
			gtk_file_filter_add_pattern (filter, "*.OGG");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);
		}
		
		else if (Choice == _PATH_IMPORT_FILE_SPLIT_) {
		
			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("All Files (*.*)"));
			gtk_file_filter_add_pattern (filter, "*.wav");
			gtk_file_filter_add_pattern (filter, "*.WAV");
			gtk_file_filter_add_pattern (filter, "*.mp3");
			gtk_file_filter_add_pattern (filter, "*.MP3");
			gtk_file_filter_add_pattern (filter, "*.ogg");
			gtk_file_filter_add_pattern (filter, "*.OGG");
			gtk_file_filter_add_pattern (filter, "*.flac");
			gtk_file_filter_add_pattern (filter, "*.FLAC");
			gtk_file_filter_add_pattern (filter, "*.shn");
			gtk_file_filter_add_pattern (filter, "*.SHN");
			gtk_file_filter_add_pattern (filter, "*.wv");
			gtk_file_filter_add_pattern (filter, "*.WV");
			gtk_file_filter_add_pattern (filter, "*.cue");
			gtk_file_filter_add_pattern (filter, "*.CUE");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);

			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("WAV (*.wav)"));
			gtk_file_filter_add_pattern (filter, "*.wav");
			gtk_file_filter_add_pattern (filter, "*.WAV");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);
			
			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("CUE (*.cue)"));
			gtk_file_filter_add_pattern (filter, "*.cue");
			gtk_file_filter_add_pattern (filter, "*.CUE");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);
		}
		
		else {
			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("All Files (*.*)"));
			gtk_file_filter_add_pattern (filter, "*.shn");
			gtk_file_filter_add_pattern (filter, "*.SHN");
			gtk_file_filter_add_pattern (filter, "*.wma");
			gtk_file_filter_add_pattern (filter, "*.WMA");
			gtk_file_filter_add_pattern (filter, "*.mp3");
			gtk_file_filter_add_pattern (filter, "*.MP3");
			gtk_file_filter_add_pattern (filter, "*.mpc");
			gtk_file_filter_add_pattern (filter, "*.MPC");
			gtk_file_filter_add_pattern (filter, "*.m4a");
			gtk_file_filter_add_pattern (filter, "*.M4A");
			gtk_file_filter_add_pattern (filter, "*.aac");
			gtk_file_filter_add_pattern (filter, "*.AAC");
			gtk_file_filter_add_pattern (filter, "*.ogg");
			gtk_file_filter_add_pattern (filter, "*.OGG");
			gtk_file_filter_add_pattern (filter, "*.oga");
			gtk_file_filter_add_pattern (filter, "*.OGA");
			gtk_file_filter_add_pattern (filter, "*.wv");
			gtk_file_filter_add_pattern (filter, "*.WV");
			gtk_file_filter_add_pattern (filter, "*.ape");
			gtk_file_filter_add_pattern (filter, "*.APE");
			gtk_file_filter_add_pattern (filter, "*.flac");
			gtk_file_filter_add_pattern (filter, "*.FLAC");
			gtk_file_filter_add_pattern (filter, "*.wav");
			gtk_file_filter_add_pattern (filter, "*.WAV");
			
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);

			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("SHORTEN (*.shn)"));
			gtk_file_filter_add_pattern (filter, "*.shn");
			gtk_file_filter_add_pattern (filter, "*.SHN");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);

			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("WMA (*.wma)"));
			gtk_file_filter_add_pattern (filter, "*.wma");
			gtk_file_filter_add_pattern (filter, "*.WMA");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);

			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("MP3 (*.mp3)"));
			gtk_file_filter_add_pattern (filter, "*.mp3");
			gtk_file_filter_add_pattern (filter, "*.MP3");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);

			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("MPC (*.mpc)"));
			gtk_file_filter_add_pattern (filter, "*.mpc");
			gtk_file_filter_add_pattern (filter, "*.MPC");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);

			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("M4A (*.m4a)"));
			gtk_file_filter_add_pattern (filter, "*.m4a");
			gtk_file_filter_add_pattern (filter, "*.M4A");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);
			
			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("AAC (*.aac)"));
			gtk_file_filter_add_pattern (filter, "*.aac");
			gtk_file_filter_add_pattern (filter, "*.AAC");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);

			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("OGG (*.ogg)"));
			gtk_file_filter_add_pattern (filter, "*.ogg");
			gtk_file_filter_add_pattern (filter, "*.OGG");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);

			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("WAVPACK (*.wv)"));
			gtk_file_filter_add_pattern (filter, "*.wv");
			gtk_file_filter_add_pattern (filter, "*.WV");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);

			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("APE (*.ape)"));
			gtk_file_filter_add_pattern (filter, "*.ape");
			gtk_file_filter_add_pattern (filter, "*.APE");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);

			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("FLAC (*.flac)"));
			gtk_file_filter_add_pattern (filter, "*.flac");
			gtk_file_filter_add_pattern (filter, "*.FLAC");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);

			filter = gtk_file_filter_new ();
			gtk_file_filter_set_name (filter, _("WAV (*.wav)"));
			gtk_file_filter_add_pattern (filter, "*.wav");
			gtk_file_filter_add_pattern (filter, "*.WAV");
			gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (filechooserdialog), filter);
		}

	}
	else if (Select[ Choice ].TypeSelect == _FILE_IMG_SIMPLE_ || Select[ Choice ].TypeSelect == _FILE_IMG_MULTIPLE_) {
		/* selection de fichiers images avec previsualisation */
		filechooserdialog = gtk_file_chooser_dialog_new (Select[ Choice ].Title,
								  NULL,
								  GTK_FILE_CHOOSER_ACTION_OPEN,
								  /*GTK_STOCK_CANCEL,
								  GTK_RESPONSE_CANCEL,
								  GTK_STOCK_OPEN,
								  GTK_RESPONSE_ACCEPT,*/
								  NULL,
								  NULL);
		preview = gtk_image_new ();
		gtk_widget_set_usize(GTK_WIDGET(preview), 200, 200);
		gtk_file_chooser_set_preview_widget(GTK_FILE_CHOOSER(filechooserdialog),  GTK_WIDGET(preview));
		gtk_file_chooser_set_preview_widget_active (GTK_FILE_CHOOSER (filechooserdialog), TRUE);
		g_signal_connect(GTK_FILE_CHOOSER(filechooserdialog), "update-preview", G_CALLBACK (chooserDialog_preview_update), preview);
	}


	if (Select[ Choice ].TypeSelect == _REP_MULTIPLE_ ||
		Select[ Choice ].TypeSelect == _FILE_MULTIPLE_ ||
		Select[ Choice ].TypeSelect == _FILE_IMG_MULTIPLE_) {
		/* selection 'multiple' */
		g_object_set (filechooserdialog, "select-multiple", TRUE, NULL);
		gtk_file_chooser_set_select_multiple (GTK_FILE_CHOOSER (filechooserdialog), TRUE);
	}

	gtk_window_set_position (GTK_WINDOW (filechooserdialog), GTK_WIN_POS_CENTER);
	/*
	gtk_window_set_transient_for (GTK_WINDOW(filechooserdialog), GTK_WINDOW(wind_main));
	gtk_window_set_modal (GTK_WINDOW (filechooserdialog), TRUE);
	*/
	wincontrol_set_adr (filechooserdialog, "filechooserdialog", TRUE, TRUE);

	if (*Select[ Choice ].Path == NULL || *Select[ Choice ].Path == '\0')
		*Select[ Choice ].Path = g_strdup_printf ("%s", getenv ("HOME"));
	if (*Select[ Choice ].Path != NULL)
		gtk_file_chooser_set_current_folder (
					GTK_FILE_CHOOSER (filechooserdialog),
					*Select[ Choice ].Path);

	Select[ Choice ].AdrFileChooser = filechooserdialog;

	gtk_window_set_type_hint (GTK_WINDOW (filechooserdialog), GDK_WINDOW_TYPE_HINT_DIALOG);

	dialog_vbox1 = GTK_DIALOG (filechooserdialog)->vbox;
	gtk_widget_show (dialog_vbox1);

	dialog_action_area1 = GTK_DIALOG (filechooserdialog)->action_area;
	gtk_widget_show (dialog_action_area1);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

	button_cancel = gtk_button_new_from_stock ("gtk-cancel");
	gtk_widget_show (button_cancel);
	gtk_dialog_add_action_widget (GTK_DIALOG (filechooserdialog), button_cancel, GTK_RESPONSE_CANCEL);
	GTK_WIDGET_SET_FLAGS (button_cancel, GTK_CAN_DEFAULT);

	button_ok = gtk_button_new_from_stock ("gtk-open");
	gtk_widget_show (button_ok);
	gtk_dialog_add_action_widget (GTK_DIALOG (filechooserdialog), button_ok, GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS (button_ok, GTK_CAN_DEFAULT);

	g_signal_connect ((gpointer) filechooserdialog, "delete_event", G_CALLBACK (fileselect_on_filechooserdialog_delete_event), (gpointer)Choice);
	g_signal_connect ((gpointer) filechooserdialog, "destroy_event", G_CALLBACK (fileselect_on_filechooserdialog_destroy_event), (gpointer)Choice);
	g_signal_connect ((gpointer) button_cancel, "clicked", G_CALLBACK (fileselect_on_button_cancel_clicked), (gpointer)Choice);
	g_signal_connect ((gpointer) button_ok, "clicked", G_CALLBACK (Select[ Choice ].Call_Func), (gpointer)Choice);

	/* Store pointers to all widgets, for use by lookup_widget().
	*/
	GLADE_HOOKUP_OBJECT_NO_REF (filechooserdialog, filechooserdialog, "filechooserdialog");
	GLADE_HOOKUP_OBJECT_NO_REF (filechooserdialog, dialog_vbox1, "dialog_vbox1");
	GLADE_HOOKUP_OBJECT_NO_REF (filechooserdialog, dialog_action_area1, "dialog_action_area1");
	GLADE_HOOKUP_OBJECT (filechooserdialog, button_cancel, "button_cancel");
	GLADE_HOOKUP_OBJECT (filechooserdialog, button_ok, "button_ok");

	gtk_widget_grab_default (button_ok);
  	gtk_widget_show (filechooserdialog);
}

