 /*
 * file      : options.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifndef __options_h__
#define __options_h__ 1


typedef enum {
	COLOR_INIT = 0,
	COLOR_NONE,
	
	COLOR_LAME_DEBIT,
	COLOR_LAME_MODE,
	
	COLOR_OGGENC_DEBIT,
	COLOR_OGGENC_MANAGED,
	COLOR_OGGENC_DOWNMIX,
	
	COLOR_FLAC_TAUX_COMPRESSION,
	
	COLOR_MAC_QUALITE,
	
	COLOR_WAVPACK_MODE_HYBRIDE,
	COLOR_WAVPACK_COMPRESSION,
	COLOR_WAVPACK_SOUND,
	COLOR_WAVPACK_FICHIER_CORRECTION,
	COLOR_WAVPACK_COMPRESSION_MAXIMUM,
	COLOR_WAVPACK_SIGNATURE_MD5,
	COLOR_WAVPACK_EXTRA_ENCODING,
	
	COLOR_MUSEPACK_QUALITE,
	
	COLOR_FAAC_CONTENEUR,
	COLOR_FAAC_SET_CHOICE_VBR_ABR,
	
	COLOR_TAG_ARTIST,
	COLOR_TAG_TITLE,
	COLOR_TAG_ALBUM,
	COLOR_TAG_NUMERATE,
	COLOR_TAG_GENRE,
	COLOR_TAG_YEAR,
	COLOR_TAG_COMMENT
	
} COLOR_LINE_COMMAND;

typedef enum {
	_NONE_ = 0,
	_DEBIAN_,
	_TGZ_,
	_RPM_,
	_FPM_
} TYPE_PACKAGE;

typedef struct {
	GtkComboBox   *Adr_Widget_Nice;				/*  */
	GtkComboBox   *Adr_Widget_Lame_bitrate;			/*  */
	GtkComboBox   *Adr_Widget_Lame_abr_cbr_vbr;		/*  */
	gboolean       bool_changed;
		
	GtkComboBox   *Adr_Widget_Lame_Mode;			/*  */
	GtkComboBox   *Adr_Widget_Oggenc_bitrate;		/*  */
	GtkComboBox   *Adr_Widget_Oggenc_managed;		/*  */
	GtkComboBox   *Adr_Widget_Oggenc_downmix;		/*  */
	GtkComboBox   *Adr_Widget_Mppenc;			/*  */
	GtkComboBox   *Adr_Widget_wavpack;			/*  */
	GtkComboBox   *Adr_Widget_wavpack_sound;		/*  */
	GtkComboBox   *Adr_Widget_wavpack_mode_hybride;		/*  */
	GtkComboBox   *Adr_Widget_wavpack_correction_file;	/*  */
	GtkComboBox   *Adr_Widget_wavpack_maximum_compression;	/*  */
	GtkComboBox   *Adr_Widget_wavpack_signature_md5;	/*  */
	GtkComboBox   *Adr_Widget_wavpack_extra_encoding;	/*  */
	
	GtkComboBox   *Adr_Widget_flac_compression;		/*  */
	GtkComboBox   *Adr_Widget_ape_compression;		/*  */

	GtkWidget     *Adr_radiobutton_cdparanoia;		/*  */
	GtkWidget     *Adr_radiobutton_ioctl;			/*  */
	
	GtkWidget     *Adr_radiobutton_extract_with_cdparanoia;	/*  */
	GtkWidget     *Adr_radiobutton_extract_with_cdda2wav;	/*  */
	GtkWidget     *Adr_radiobutton_cdparanoia_mode_expert;	/*  */
	
	GtkWidget     *Adr_label_type_paquege;			/*  */
	TYPE_PACKAGE   Type_Package;				/* 0 none, 1 deb,  2 rpm,  3 tgz */
	
	GtkWidget     *Adr_entry_lame_mp3;
	GtkWidget     *Adr_label_lame_mp3;	
	GtkWidget     *Adr_entry_oggenc_ogg;
	GtkWidget     *Adr_label_oggenc_ogg;	
	GtkWidget     *Adr_entry_flac_flac;
	GtkWidget     *Adr_label_flac_flac;
	GtkWidget     *Adr_entry_mac_ape;
	GtkWidget     *Adr_label_mac_ape;
	GtkWidget     *Adr_entry_wavpack_wv;
	GtkWidget     *Adr_label_wavpack_wv;
	GtkWidget     *Adr_entry_musepack_mpc;
	GtkWidget     *Adr_label_musepack_mpc;
	GtkWidget     *Adr_entry_faac_m4a;
	GtkWidget     *Adr_label_faac_m4a;
	
	GtkWidget      *Adr_checkbutton_artist_tag;
	GtkWidget      *Adr_checkbutton_title_tag;
	GtkWidget      *Adr_checkbutton_album_tag;
	GtkWidget      *Adr_checkbutton_numerate_tag;
	GtkWidget      *Adr_checkbutton_genre_tag;
	GtkWidget      *Adr_checkbutton_year_tag;
	GtkWidget      *Adr_checkbutton_comment_tag;
	
	COLOR_LINE_COMMAND ColorLineCommand;
	
	GtkWidget      *Adr_path_temp;
	
	GtkComboBox   *Adr_Widget_faac_conteneur;
	GtkComboBox   *Adr_Widget_faac_choice_vbr_abr;
	GtkComboBox   *Adr_Widget_faac_set_choice_vbr_abr;
	
	GtkComboBox   *Adr_Widget_aacplusenc_mono;
	GtkComboBox   *Adr_Widget_aacplusenc_stereo;
	
} VAR_OPTIONS;

/*
*---------------------------------------------------------------------------
* OPTIONS.C
*---------------------------------------------------------------------------
*/
extern VAR_OPTIONS var_options;

#include "conv.h"

EXTRACT_WITH	options_extract_by (void);
gchar		*options_extract_by_name (void);
void		options_set_datas_interne (COLOR_LINE_COMMAND ColorLineCommand, GtkWidget *widget, TYPE_CONV type_conv);
void		options_make_combobox_nice (GtkWidget *widget);
gint		options_get_val_nice (void);
gboolean	options_get_readdir_cdaudio_by_ioctl (void);
void		options_button_create_file_xcfa_clicked (void);
void		options_combobox_choix_paquage_realize (GtkWidget *widget);
void		options_set_all_interne (void);
void		options_entry_op_internal_changed (GtkEditable *editable);
void		options_init (void);
gboolean	options_get_entry_is_valid (TYPE_CONV p_verif_conv);
gboolean	options_bool_add_line_command (TYPE_CONV p_type_conv, gchar **entry);
void		options_set_administrator_of_packets (void);
gint		options_get_administrator_of_packets (void);
void		options_button_dossier_de_conversion_realize (GtkWidget *widget);
void		options_button_dossier_de_conversion_clicked (void);
gboolean	options_verif_dossier_is_ok (gchar *path);
void		options_default_values (GtkButton *button);

/*
*---------------------------------------------------------------------------
* OPTIONS_LAME.C 
* mp3
*---------------------------------------------------------------------------
*/
void      optionsLame_combobox_lame_type_bitrate_realize (GtkWidget *widget);
void      optionsLame_combobox_lame_type_bitrate_changed (void);
void      optionsLame_combobox_lame_abr_cbr_vbr_realize (GtkWidget *widget);
void      optionsLame_combobox_lame_abr_cbr_vbr_changed (void);
void      optionsLame_make_combobox_lame_mode_realize (GtkWidget *widget);
void      optionsLame_combobox_lame_mode_changed (void);
gchar    *optionsLame_get_str_val_bitrate_abr_vbr_lame (void);
gchar    *optionsLame_get_str_val_mode_lame (void);
gchar    *optionsLame_get_param_lame (void);

/*
*---------------------------------------------------------------------------
* OPTIONS_MUSEPACK.C
* mpc
*---------------------------------------------------------------------------
*/
void      optionsMusepack_combobox_mppenc_realize (GtkWidget *widget);
gchar    *optionsMusepack_get_quality_mppenc (void);
void      optionsMusepack_combobox_mppenc_changed (void);

/*
*---------------------------------------------------------------------------
* OPTIONS_OGGENC.C
* ogg
*---------------------------------------------------------------------------
*/
void      optionsOggenc_make_combobox_oggenc (GtkWidget *widget);
gchar    *optionsOggenc_get_val_bitrate_oggenc (void);
void      optionsOggenc_combobox_oggenc_bitrate_changed (void);
void      optionsOggenc_combobox_oggenc_managed_realize (GtkWidget *widget);
void      optionsOggenc_combobox_oggenc_managed_changed (void);
void      optionsOggenc_combobox_oggenc_downmix_realize (GtkWidget *widget);
void      optionsOggenc_combobox_oggenc_downmix_changed (void);
gboolean  optionsOggenc_get_bool_managed_oggenc (void);
gboolean  optionsOggenc_get_bool_downmix_oggenc (void);
gchar    *optionsOggenc_get_param_oggenc (void);

/*
*---------------------------------------------------------------------------
* OPTIONS_WAVPACK.C
* wv
*---------------------------------------------------------------------------
*/
void      optionsWavpack_combobox_wavpack_realize (GtkWidget *widget);
gchar    *optionsWavpack_get_wavpack_compression (void);
void      optionsWavpack_combobox_wavpack_sound_realize (GtkWidget *widget);
gchar    *optionsWavpack_get_wavpack_sound (void);
void      optionsWavpack_combobox_wavpack_mode_hybride_changed (void);
void      optionsWavpack_combobox_wavpack_mode_hybride_realize (GtkWidget *widget);
gchar    *optionsWavpac_get_wavpack_hybride (void);
void      optionsWavpack_combobox_wavpack_fichier_de_correction_realize (GtkWidget *widget);
gchar    *optionsWavpack_get_wavpack_correction_file (void);
void      optionsWavpack_combobox_wavpack_compression_maximum_realize (GtkWidget *widget);
gchar    *optionsWavpack_get_wavpack_maximum_compression (void);
void      optionsWavpack_combobox_wavpack_signature_md5_realize (GtkWidget *widget);
gchar    *optionsWavpack_get_wavpack_signature_md5 (void);
void      optionsWavpack_combobox_wavpack_extra_encoding_realize (GtkWidget *widget);
gchar    *optionsWavpack_get_wavpack_extra_encoding (void);
void      optionsWavpack_combobox_wavpack_changed (void);
void      optionsWavpack_combobox_wavpack_sound_changed ();
void      optionsWavpack_combobox_wavpack_fichier_de_correction_changed (void);
void      optionsWavpack_combobox_wavpack_compression_maximum_changed (void);
void      optionsWavpack_combobox_wavpack_signature_md5_changed (void);
void      optionsWavpack_combobox_wavpack_extra_encoding_changed (void);

/*
*---------------------------------------------------------------------------
* OPTIONS_FLAC.C
* flac
*---------------------------------------------------------------------------
*/
void      optionsFlac_combobox_flac_compression_realize (GtkWidget *widget);
gchar    *optionsFlac_get_compression_level_flac (void);
void      optionsFlac_combobox_flac_compression_changed (void);

/*
*---------------------------------------------------------------------------
* OPTIONS_MAC.C
* ape
*---------------------------------------------------------------------------
*/
void      optionsApe_combobox_ape_compression_realize (GtkWidget *widget);
gchar    *optionsApe_get_compression_level_ape (void);
void      optionsApe_combobox_ape_compression_changed (void);

/*
*---------------------------------------------------------------------------
* OPTIONS_FAAC.C
* m4a
*---------------------------------------------------------------------------
*/
void      OptionsFaac_combobox_faac_conteneur_realize (GtkWidget *widget);
void      OptionsFaac_combobox_faac_conteneur_changed (void);
void      OptionsFaac_combobox_faac_choice_vbr_abr_realize (GtkWidget *widget);
void      OptionsFaac_combobox_faac_choice_vbr_abr_changed (void);
void      OptionsFaac_combobox_faac_set_choice_vbr_abr_realize (GtkWidget *widget);
void      OptionsFaac_combobox_faac_set_choice_vbr_abr_changed (void);
gchar    *OptionsFaac_get_faac_conteneur (void);
gboolean  OptionsFaac_bool_get_faac_conteneur (void);
gchar    *OptionsFaac_get_faac_set_choice_vbr_abr (void);

/*
*---------------------------------------------------------------------------
* OPTIONS_AACPLUSENC.C
* aac
*---------------------------------------------------------------------------
*/
void      optionsaacplusenc_combobox_accplusenc_mono_realize (GtkWidget *widget);
void      optionsaacplusenc_combobox_accplusenc_stereo_realize (GtkWidget *widget);
gint      optionsaacplusenc_get_bitrate_mono (void);
gint      optionsaacplusenc_get_bitrate_stereo (void);


/*
*---------------------------------------------------------------------------
* OPTIONS_TAGS.C
*---------------------------------------------------------------------------
*/
/* TAGS */
void     optionstags_checkbutton_artist_tag_realize (GtkWidget *widget);
void     optionstags_checkbutton_title_tag_realize (GtkWidget *widget);
void     optionstags_checkbutton_album_tag_realize (GtkWidget *widget);
void     optionstags_checkbutton_numerate_tag_realize (GtkWidget *widget);
void     optionstags_checkbutton_genre_tag_realize (GtkWidget *widget);
void     optionstags_checkbutton_year_tag_realize (GtkWidget *widget);
void     optionstags_checkbutton_comment_tag_realize (GtkWidget *widget);
/* TAGS ETAT GET->SET */
gboolean optionstags_get_checkbutton_artist_tag (void);
gboolean optionstags_get_checkbutton_title_tag (void);
gboolean optionstags_get_checkbutton_album_tag (void);
gboolean optionstags_get_checkbutton_numerate_tag (void);
gboolean optionstags_get_checkbutton_genre_tag (void);
gboolean optionstags_get_checkbutton_year_tag (void);
gboolean optionstags_get_checkbutton_comment_tag (void);

void     optionstags_checkbutton_tag_clicked (GtkButton *button);

#endif

