 /*
 * file      : options_faac.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>
#include "support.h"
#include <string.h>
#include "global.h"
#include "config_user.h"
#include "cd_audio.h"
#include "utils.h"
#include "options.h"
#include <stdlib.h>
#include <glib.h>
#include <glib/gstdio.h>
#include "info_song.h"

/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

/*
*---------------------------------------------------------------------------
* CODE
*---------------------------------------------------------------------------
*/
void OptionsFaac_combobox_faac_set_choice_vbr_abr_changed_ (void)
{
	if (var_options.Adr_Widget_faac_choice_vbr_abr == NULL) return;
	if (var_options.Adr_Widget_faac_set_choice_vbr_abr == NULL) return;
	
	if (var_options.bool_changed == FALSE) return;
	var_options.bool_changed = FALSE;
	
	utils_clear_elements_combobox (GTK_WIDGET (var_options.Adr_Widget_faac_set_choice_vbr_abr));
	
	switch (gtk_combo_box_get_active (var_options.Adr_Widget_faac_choice_vbr_abr)) {
	
	/* ABR
	 * 56, 64, 80, 96, 128, 152
    	*/
	case 0 :
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "10");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "30");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "50");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "70");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "80");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "90");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "100");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "120");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "150");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "200");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "250");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "300");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "400");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "500");
		
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), Config_User.faac_set_choice_vbr);
		break;
	
	/* VCR
	*  10, 30, 50, 70, 80, 90, 100, 120, 150, 200, 250, 300, 400, 500
	*/
	case 1 :
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "56");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "64");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "80");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "96");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "128");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), "152");
		
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_faac_set_choice_vbr_abr), Config_User.faac_set_choice_abr);
		break;
	}
	var_options.bool_changed = TRUE;
	
}

void OptionsFaac_combobox_faac_conteneur_realize (GtkWidget *widget)
{
	/*PRINT_FUNC_LF();*/
	
	utils_clear_elements_combobox (widget);

	/*
	Titre de l'option = Conteneur
	Choix = Transport Stream (ADTS) - Extension .aac /OU/ MPEG-4 File Format (MP4) - Extension .m4a 
	*/
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Transport Stream (ADTS) - Extension .aac"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("MPEG-4 File Format (MP4) - Extension .m4a"));
	
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.faac_conteneur);
	var_options.Adr_Widget_faac_conteneur = GTK_COMBO_BOX (widget);
	var_options.bool_changed = TRUE;
	OptionsFaac_combobox_faac_set_choice_vbr_abr_changed_ ();
}
void OptionsFaac_combobox_faac_conteneur_changed (void)
{
	/*PRINT_FUNC_LF();*/
	options_set_datas_interne (COLOR_FAAC_CONTENEUR, var_options.Adr_label_faac_m4a, FAAC_WAV_TO_M4A);
}


void OptionsFaac_combobox_faac_choice_vbr_abr_realize (GtkWidget *widget)
{
	/*PRINT_FUNC_LF();*/
	
	utils_clear_elements_combobox (widget);
     	/*
	Titre de l'option = VBR / ABR
	Choix = VBR /OU/ ABR
	*/

	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "VBR");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "ABR");
	
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.faac_choice_vbr_abr);
	var_options.bool_changed = TRUE;
	var_options.Adr_Widget_faac_choice_vbr_abr = GTK_COMBO_BOX (widget);
}
void OptionsFaac_combobox_faac_choice_vbr_abr_changed (void)
{
	/*PRINT_FUNC_LF();*/
	
	OptionsFaac_combobox_faac_set_choice_vbr_abr_changed_ ();
	options_set_datas_interne (COLOR_FAAC_SET_CHOICE_VBR_ABR, var_options.Adr_label_faac_m4a, FAAC_WAV_TO_M4A);
}


void OptionsFaac_combobox_faac_set_choice_vbr_abr_realize (GtkWidget *widget)
{
	/*PRINT_FUNC_LF();*/
	
	utils_clear_elements_combobox (widget);

	var_options.Adr_Widget_faac_set_choice_vbr_abr = GTK_COMBO_BOX (widget);
	var_options.bool_changed = TRUE;
	OptionsFaac_combobox_faac_set_choice_vbr_abr_changed_ ();
}
void OptionsFaac_combobox_faac_set_choice_vbr_abr_changed (void)
{
	if (var_options.bool_changed == FALSE) return;
	if (var_options.Adr_Widget_faac_choice_vbr_abr == NULL) return;
	if (var_options.Adr_Widget_faac_set_choice_vbr_abr == NULL) return;
	
	switch (gtk_combo_box_get_active (var_options.Adr_Widget_faac_choice_vbr_abr)) {
	case 0 :
		Config_User.faac_set_choice_vbr = gtk_combo_box_get_active (var_options.Adr_Widget_faac_set_choice_vbr_abr);
		break;
	case 1 :
		Config_User.faac_set_choice_abr = gtk_combo_box_get_active (var_options.Adr_Widget_faac_set_choice_vbr_abr);
		break;
	}
	
	options_set_datas_interne (COLOR_FAAC_SET_CHOICE_VBR_ABR, var_options.Adr_label_faac_m4a, FAAC_WAV_TO_M4A);
}

gchar *OptionsFaac_get_faac_conteneur (void)
{
	gchar *str_faac_conteneur[] = {
	"",
	"-w"
	};

	if (!var_options.Adr_Widget_faac_conteneur) return ( (gchar *)str_faac_conteneur[ 0 ]);
	return ( (gchar *)str_faac_conteneur[ gtk_combo_box_get_active (var_options.Adr_Widget_faac_conteneur) ]);	
}
gboolean OptionsFaac_bool_get_faac_conteneur (void)
{
	return ( *OptionsFaac_get_faac_conteneur () == '-' ? TRUE : FALSE);
}


gchar *OptionsFaac_get_faac_set_choice_vbr_abr (void)
{
	/* ABR
	 * 56, 64, 80, 96, 128, 152
    	*/
	gchar *str_faac_abr[] = {
	"-b 56",
	"-b 64",
	"-b 80",
	"-b 96",
	"-b 128",
	"-b 152"
	};
	/* VCR
	*  10, 30, 50, 70, 80, 90, 100, 120, 150, 200, 250, 300, 400, 500
	*/
	gchar *str_faac_vbr[] = {
	"-q 10",
	"-q 30",
	"-q 50",
	"-q 70",
	"-q 80",
	"-q 90",
	"-q 100",
	"-q 120",
	"-q 150",
	"-q 200",
	"-q 250",
	"-q 300",
	"-q 400",
	"-q 500"
	};
	
	if (gtk_combo_box_get_active (var_options.Adr_Widget_faac_choice_vbr_abr) == 0) {
		return ( (gchar *)str_faac_vbr[ gtk_combo_box_get_active (var_options.Adr_Widget_faac_set_choice_vbr_abr) ]);
	}
	return ( (gchar *)str_faac_abr[ gtk_combo_box_get_active (var_options.Adr_Widget_faac_set_choice_vbr_abr) ]);
}





