 /*
 * file      : options_tags.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>
#include "support.h"
#include <string.h>
#include "global.h"
#include "config_user.h"
#include "cd_audio.h"
#include "utils.h"
#include "options.h"
#include <stdlib.h>
#include <glib.h>
#include <glib/gstdio.h>
#include "info_song.h"

/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

/*
*---------------------------------------------------------------------------
* CODE
*---------------------------------------------------------------------------
*/

/* TAGS REALIZE */

void optionstags_checkbutton_artist_tag_realize (GtkWidget *widget)
{
	var_options.Adr_checkbutton_artist_tag = widget;
	gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_checkbutton_artist_tag), Config_User.Bool_artist_tag );
}
void optionstags_checkbutton_title_tag_realize (GtkWidget *widget)
{
	var_options.Adr_checkbutton_title_tag = widget;
	gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_checkbutton_title_tag), Config_User.Bool_title_tag );
}
void optionstags_checkbutton_album_tag_realize (GtkWidget *widget)
{
	var_options.Adr_checkbutton_album_tag = widget;
	gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_checkbutton_album_tag), Config_User.Bool_album_tag );
}
void optionstags_checkbutton_numerate_tag_realize (GtkWidget *widget)
{
	var_options.Adr_checkbutton_numerate_tag = widget;
	gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_checkbutton_numerate_tag), Config_User.Bool_numerate_tag );
}
void optionstags_checkbutton_genre_tag_realize (GtkWidget *widget)
{
	var_options.Adr_checkbutton_genre_tag = widget;
	gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_checkbutton_genre_tag), Config_User.Bool_genre_tag );
}
void optionstags_checkbutton_year_tag_realize (GtkWidget *widget)
{
	var_options.Adr_checkbutton_year_tag = widget;
	gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_checkbutton_year_tag), Config_User.Bool_year_tag );
}
void optionstags_checkbutton_comment_tag_realize (GtkWidget *widget)
{
	var_options.Adr_checkbutton_comment_tag = widget;
	gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_checkbutton_comment_tag), Config_User.Bool_comment_tag );
}

/* TAGS ETAT GET->SET */

gboolean optionstags_get_checkbutton_artist_tag (void)
{
	Config_User.Bool_artist_tag = gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_checkbutton_artist_tag));
	return (Config_User.Bool_artist_tag);
}
gboolean optionstags_get_checkbutton_title_tag (void)
{
	Config_User.Bool_title_tag = gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_checkbutton_title_tag));
	return (Config_User.Bool_title_tag);
}
gboolean optionstags_get_checkbutton_album_tag (void)
{
	Config_User.Bool_album_tag = gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_checkbutton_album_tag));
	return (Config_User.Bool_album_tag);
}
gboolean optionstags_get_checkbutton_numerate_tag (void)
{
	Config_User.Bool_numerate_tag = gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_checkbutton_numerate_tag));
	return (Config_User.Bool_numerate_tag);
}
gboolean optionstags_get_checkbutton_genre_tag (void)
{
	Config_User.Bool_genre_tag = gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_checkbutton_genre_tag));
	return (Config_User.Bool_genre_tag);
}
gboolean optionstags_get_checkbutton_year_tag (void)
{
	Config_User.Bool_year_tag = gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_checkbutton_year_tag));
	return (Config_User.Bool_year_tag);
}
gboolean optionstags_get_checkbutton_comment_tag (void)
{
	Config_User.Bool_comment_tag = gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (var_options.Adr_checkbutton_comment_tag));
	return (Config_User.Bool_comment_tag);
}


void optionstags_checkbutton_tag_clicked (GtkButton *button)
{
	COLOR_LINE_COMMAND ColorLineCommand = COLOR_NONE;
	
	/*PRINT_FUNC_LF();*/

	if (GTK_TOGGLE_BUTTON (button) == GTK_TOGGLE_BUTTON (lookup_widget (wind_main, "checkbutton_artist_tag"))) {
		ColorLineCommand = COLOR_TAG_ARTIST;
	} else if (GTK_TOGGLE_BUTTON (button) == GTK_TOGGLE_BUTTON (lookup_widget (wind_main, "checkbutton_title_tag"))) {
		ColorLineCommand = COLOR_TAG_TITLE;
	} else if (GTK_TOGGLE_BUTTON (button) == GTK_TOGGLE_BUTTON (lookup_widget (wind_main, "checkbutton_album_tag"))) {
		ColorLineCommand = COLOR_TAG_ALBUM;
	} else if (GTK_TOGGLE_BUTTON (button) == GTK_TOGGLE_BUTTON (lookup_widget (wind_main, "checkbutton_numerate_tag"))) {
		ColorLineCommand = COLOR_TAG_NUMERATE;
	} else if (GTK_TOGGLE_BUTTON (button) == GTK_TOGGLE_BUTTON (lookup_widget (wind_main, "checkbutton_genre_tag"))) {
		ColorLineCommand = COLOR_TAG_GENRE;
	} else if (GTK_TOGGLE_BUTTON (button) == GTK_TOGGLE_BUTTON (lookup_widget (wind_main, "checkbutton_year_tag"))) {
		ColorLineCommand = COLOR_TAG_YEAR;
	} else if (GTK_TOGGLE_BUTTON (button) == GTK_TOGGLE_BUTTON (lookup_widget (wind_main, "checkbutton_comment_tag"))) {
		ColorLineCommand = COLOR_TAG_COMMENT;
	}
	
	options_set_datas_interne (ColorLineCommand, var_options.Adr_label_lame_mp3, LAME_WAV_TO_MP3);
	options_set_datas_interne (ColorLineCommand, var_options.Adr_label_oggenc_ogg, OGGENC_WAV_TO_OGG);
	options_set_datas_interne (ColorLineCommand, var_options.Adr_label_flac_flac, FLAC_WAV_TO_FLAC);
	options_set_datas_interne (ColorLineCommand, var_options.Adr_label_mac_ape, MAC_WAV_TO_APE);
	options_set_datas_interne (ColorLineCommand, var_options.Adr_label_wavpack_wv, WAVPACK_WAV_TO_WAVPACK);
	options_set_datas_interne (ColorLineCommand, var_options.Adr_label_musepack_mpc, MPPENC_WAV_TO_MPC);
	options_set_datas_interne (ColorLineCommand, var_options.Adr_label_faac_m4a, FAAC_WAV_TO_M4A);
}





