 /*
 * file      : prg_install.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */

 /*
http://download.tuxfamily.org/ubunteros/pour_claude/Slack/
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "support.h"

#include <pthread.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/wait.h>

#include "global.h"
#include "prg_install.h"
#include "prg_init.h"
#include "utils.h"

#include "win_info.h"
#include "win_pulse.h"
#include "poche.h"
#include "info_song.h"
#include "cdtoc.h"
#include "file.h"
#include "cd_audio.h"
#include "options.h"
#include "secu.h"
#include "get.h"
#include "prg_init.h"



typedef struct {
	
	gboolean	 bool_thread_do_install;	/*  */
	guint		 handler_do_install;		/*  */
	pthread_t	 nmr_tid;			/*  */
	GtkComboBox	*Adr_Widget_install;		/*  */
	gint		 CodeErreur;			/*  */
	gint		 TotalPackageToInstall;		/*  */
	gint		 PackageActif;			/*  */
	gchar		 StrPass [ 50 ];
	gint		 Pass;
	
} VAR_INSTALL;

VAR_INSTALL var_install;



void prginstall_create_debian_sh (FILE *fp, TYPE_PACKAGE Type_Package, gchar *name, gboolean BoolMyServer)
{
	gchar *PtrName = NULL;
	
	fprintf (fp, "test_stop_install\n");
	fprintf (fp, "\n");
	
	fprintf (fp, "#######\n");
	fprintf (fp, "# Creation dossier de download\n");
	fprintf (fp, "#\n");
	fprintf (fp, "mkdir -p %s\n", PATH_DOWNLOAD_TO_XCFA);
	fprintf (fp, "cd %s\n", PATH_DOWNLOAD_TO_XCFA);
	fprintf (fp, "\n");

	fprintf (fp, "#######\n");
	fprintf (fp, "# For trace\n");
	fprintf (fp, "#\n");
	fprintf (fp, "cat > %s <<END\n", TMP_FILE_XCFA_INSTALL);
	/*fprintf (fp, "Download: %s\n", name);*/
	fprintf (fp, "[%d / %d] Download: %s\n", var_install.PackageActif, var_install.TotalPackageToInstall, name);
	fprintf (fp, "END\n");
	fprintf (fp, "\n");

	fprintf (fp, "#######\n");
	fprintf (fp, "# Download\n");
	fprintf (fp, "#\n");
	
	if (var_options.Type_Package == _DEBIAN_) {
		fprintf (fp,
		"if (wget --user-agent=\"Mozilla 22.0\" --directory-prefix=/tmp/download_to_xcfa %s)\n", name);
		/*
		http://download.tuxfamily.org/xcfaudio/convertisseurs/amd64/Deb/
		amd64/Deb/shorten_3.6.1-1_amd64.deb
		http://download.tuxfamily.org/xcfaudio/convertisseurs/amd64/Deb/shorten_3.6.1-1_amd64.deb
		*/
		
	}

	if ((PtrName = strrchr (name, '/')) != NULL) 
		PtrName ++;
	else	PtrName = name;
	
	fprintf (fp, "then\n");
	fprintf (fp, "	result_install=$?\n");
	fprintf (fp, "else\n");
	fprintf (fp, "	result_install=$?\n");
	fprintf (fp, "fi\n");
	fprintf (fp, "echo \"wget result_install=\"$result_install\n");
	fprintf (fp, "\n");

	fprintf (fp, "test_erreur_install\n");
	fprintf (fp, "\n");

	fprintf (fp, "test_stop_install\n");
	fprintf (fp, "\n");

	fprintf (fp, "#######\n");
	fprintf (fp, "# For trace\n");
	fprintf (fp, "#\n");
	fprintf (fp, "cat > %s <<END\n", TMP_FILE_XCFA_INSTALL);
	/*fprintf (fp, "Installation: %s\n", name);*/
	fprintf (fp, "[%d / %d] Installation: %s\n", var_install.PackageActif, var_install.TotalPackageToInstall, PtrName);
	fprintf (fp, "END\n");
	fprintf (fp, "\n");

	if (Type_Package == _DEBIAN_) {
		if (options_get_administrator_of_packets () == 0) {
			fprintf (fp, "#######\n");
			fprintf (fp, "# Installation du Download\n");
			fprintf (fp, "#\n");
			fprintf (fp, "if (dpkg --unpack ./%s)\n", PtrName);
			fprintf (fp, "then\n");
			fprintf (fp, "	result_install=$?\n");
			fprintf (fp, "else\n");
			fprintf (fp, "	result_install=$?\n");
			fprintf (fp, "fi\n");
			fprintf (fp, "echo \"result_install=\"$result_install\n");
			fprintf (fp, "\n");

			fprintf (fp, "test_erreur_install\n");
			fprintf (fp, "\n");

			fprintf (fp, "#######\n");
			fprintf (fp, "# For trace\n");
			fprintf (fp, "#\n");
			fprintf (fp, "cat > %s <<END\n", TMP_FILE_XCFA_INSTALL);
			/*fprintf (fp, "Complement d'installation: %s\n", name);*/
			fprintf (fp, "[%d / %d] Complement d'installation: %s\n", var_install.PackageActif, var_install.TotalPackageToInstall, PtrName);
			fprintf (fp, "END\n");
			fprintf (fp, "\n");

			fprintf (fp, "#######\n");
			fprintf (fp, "# Complement d'installation\n");
			fprintf (fp, "#\n");

			fprintf (fp, "if (apt-get install -f)\n");
		} else {
			fprintf (fp, "if (aptitude --assume-yes -y install ./%s)\n", PtrName);
		}
	}
	
	fprintf (fp, "then\n");
	fprintf (fp, "	result_install=$?\n");
	fprintf (fp, "else\n");
	fprintf (fp, "	result_install=$?\n");
	fprintf (fp, "fi\n");
	fprintf (fp, "\n");

	fprintf (fp, "test_erreur_install\n");
	fprintf (fp, "\n");
	
	var_install.PackageActif ++;
}

gboolean prginstall_button_create_file_xcfa_clicked (void)
{
	// GList		*LList = NULL;
	// GList		*list = NULL;
	// gchar		*ptr = NULL;
	FILE		*fp = NULL;
	gchar		*LineCommand = NULL;
	// gboolean	 bool_select = TRUE;
	gint		 index;
	gboolean	 BoolInstallPaquet;
	gchar		*Str;
	
	/* PRINT_FUNC_LF(); */
	
	/* Chercher le nombre total de fichier a installer
	*/
	var_install.TotalPackageToInstall = 0;
	var_install.PackageActif = 1;
	for (index = 0; index < NMR_MAX_TABLEAU; index ++) {
		if (TableauPrgExtern[ index ].Pixbuf == var_prgextern.Pixbuf_Selected) var_install.TotalPackageToInstall ++;
	}
	if (var_install.TotalPackageToInstall == 0) {
		wininfo_create (
			_("Aucune selection  !"),
			_("    Il faut selectionner des fichiers     "),
			  "           \n\n",
			  "");
		return (FALSE);
	}
	
	/* Suppression du fichier precedant si il existe
	*/
	infosong_delete_file (FILE_XCFA_INSTALL);

	fp = fopen (FILE_XCFA_INSTALL, "w");
	if (fp == NULL) {
		g_print ("fp == NULL\n");
		wininfo_create (
			"    Erreur creation: /tmp/xcfa_install.sh    ",
			"    <b><i>Salut,</i></b>,\n\n",
			"    <b>Le fichier '/tmp/xcfa_install.sh' N'a PAS ete cree !!</b>    \n",
			"           \n\n",
			"");
		return (FALSE);
	}
	
	
	
	
	
	
	/* Entete
	*/
	fprintf (fp, "#!/bin/sh\n");
	/*fprintf (fp, "#!/bin/bash\n");*/
	fprintf (fp, "\n");
	fprintf (fp, "set -e\n");
	fprintf (fp, "\n");

	/* Description
	*/
	if (var_options.Type_Package == _DEBIAN_) {
		fprintf (fp, "##\n");
		fprintf (fp, "##  INSTALLATION DES PAQUETS DEBIAN POUR XCFA\n");
		fprintf (fp, "##  INSTALLATION OF PACKAGES DEBIAN FOR XCFA \n");
		fprintf (fp, "##\n");
	}
	
	fprintf (fp, "\n");
	fprintf (fp, "#\n");
	fprintf (fp, "# If mode is not in Super-User, quit\n");
	fprintf (fp, "#\n");
	fprintf (fp, "if [ `id -u` -ne 0 ]\n");
	fprintf (fp, "then\n");
	fprintf (fp, "	echo\n");
	fprintf (fp, "	echo \"Please change to Super-User to continue this installion \"\n");
	fprintf (fp, "	echo \"Utilisez le mode Super-Utilisateur pour continuer cette installation \"\n");
	fprintf (fp, "	echo\n");
	fprintf (fp, "	exit 1\n");
	fprintf (fp, "fi\n");
	fprintf (fp, "\n");
	
	fprintf (fp, "test_stop_install ()\n");
	fprintf (fp, "{\n");
	fprintf (fp, "	if (test -e /tmp/STOP_INSTALL)\n");
	fprintf (fp, "	then\n");
	fprintf (fp, "		echo \"ARRET INSTALLATION PAR UTILISATEUR\";\n");
	fprintf (fp, "		rm -f /tmp/ERROR_INSTALL;\n");
	fprintf (fp, "		rm -rf %s;\n", PATH_DOWNLOAD_TO_XCFA);
	fprintf (fp, "		rm -f %s;\n", TMP_FILE_XCFA_INSTALL);
	fprintf (fp, "		rm -f /tmp/STOP_INSTALL;\n");
	fprintf (fp, "		exit 3;\n");
	fprintf (fp, "	fi\n");
	fprintf (fp, "}\n");
	fprintf (fp, "\n");
	
	fprintf (fp, "test_erreur_install ()\n");
	fprintf (fp, "{\n");
	fprintf (fp, "	if [ \"$result_install\" != \"0\" ]\n");
	fprintf (fp, "	then\n");
	fprintf (fp, "		echo \"PROBLEME A l'INSTALLATION: exit 3;\"\n");
	fprintf (fp, "#		touch /tmp/ERROR_INSTALL;\n");
	fprintf (fp, "#		rm -rf %s;\n", PATH_DOWNLOAD_TO_XCFA);
	fprintf (fp, "#		rm -f %s;\n", TMP_FILE_XCFA_INSTALL);
	fprintf (fp, "#		rm -f /tmp/STOP_INSTALL;\n");
	fprintf (fp, "#		exit 3;\n");
	fprintf (fp, "	fi\n");
	fprintf (fp, "}\n");	
	fprintf (fp, "\n");

	fprintf (fp, "#######\n");
	fprintf (fp, "# Supprimer la trace d'erreur et le dossier de download\n");
	fprintf (fp, "#\n");
	fprintf (fp, "rm -f /tmp/ERROR_INSTALL\n");
	fprintf (fp, "rm -rf %s\n", PATH_DOWNLOAD_TO_XCFA);
	fprintf (fp, "rm -f %s\n",TMP_FILE_XCFA_INSTALL);
	fprintf (fp, "rm -f /tmp/STOP_INSTALL\n");
	fprintf (fp, "\n");

	if (var_options.Type_Package == _DEBIAN_) {
		fprintf (fp, "#######\n");
		fprintf (fp, "# For trace\n");
		fprintf (fp, "#\n");
		fprintf (fp, "cat > %s <<END\n", TMP_FILE_XCFA_INSTALL);
		fprintf (fp, "Update ...\n");
		fprintf (fp, "END\n");
		fprintf (fp, "\n");

		fprintf (fp, "#######\n");
		fprintf (fp, "# Cherche le code de retour pour \"apt-get update\"\n");
		fprintf (fp, "#\n");
		
		if (options_get_administrator_of_packets () == 0) {
			fprintf (fp, "if (apt-get update)\n");
		} else {
			fprintf (fp, "if (aptitude update)\n");
		}
		
		fprintf (fp, "then\n");
		fprintf (fp, "	result_update=$?\n");
		fprintf (fp, "else\n");
		fprintf (fp, "	result_update=$?\n");
		fprintf (fp, "fi\n");
		fprintf (fp, "echo \"result_update=\"$result_update\n");
		fprintf (fp, "\n");
	}
	
	/* Parcours de la liste des fichiers en selection
	*/
	for (index = 0; index < NMR_MAX_TABLEAU; index ++) {
		
		// TEST SI APPLY EST EN SELECTION
		if (prginit_elem_is_ready (index) == FALSE) continue;
		
		// POUR LE MOMENT SUR FALSE
		BoolInstallPaquet = FALSE;
		
		// CPU 64 BITS
		if (HostConf.BoolCpuIs64Bits == TRUE) {
			// DEPOT
			if (strlen (TableauPrgExtern [ index ] . DepotDebian64) > 0) {
				
				Str = g_strdup_printf ("http://download.tuxfamily.org/xcfaudio/convertisseurs/amd64/Deb/%s", TableauPrgExtern [ index ] . DepotDebian64);
				prginstall_create_debian_sh (fp, _DEBIAN_, Str, TRUE);
				g_free (Str);
				Str = NULL;
			}
			// PAQUET
			else {
				BoolInstallPaquet = TRUE;
			}
		// CPU 32 BITS
		} else if (HostConf.BoolCpuIs64Bits == FALSE) {
			// DEPOT
			if (strlen (TableauPrgExtern [ index ] . DepotDebian32) > 0) {
				
				Str = g_strdup_printf ("http://download.tuxfamily.org/xcfaudio/convertisseurs/i386/Deb/%s", TableauPrgExtern [ index ] . DepotDebian32);
				prginstall_create_debian_sh (fp, _DEBIAN_, Str, TRUE);
				g_free (Str);
				Str = NULL;
			}
			// PAQUET
			else {
				BoolInstallPaquet = TRUE;
			}
		}
		
		// INSTALLATION PAQUAGE
		if (BoolInstallPaquet == TRUE) {
			
			fprintf (fp, "test_stop_install\n");
			fprintf (fp, "\n");

			fprintf (fp, "#######\n");
			fprintf (fp, "# For trace\n");
			fprintf (fp, "#\n");
			fprintf (fp, "cat > %s <<END\n", TMP_FILE_XCFA_INSTALL);

			fprintf (fp, "[%d / %d] %s\n", var_install.PackageActif, var_install.TotalPackageToInstall, prginit_get_name (index));
			fprintf (fp, "END\n");
			fprintf (fp, "\n");
			
			fprintf (fp, "#######\n");
			fprintf (fp, "# Installation de %s\n", prginit_get_name (index));
			fprintf (fp, "#\n");
			
			if (options_get_administrator_of_packets () == 0) {
				fprintf (fp, "if (apt-get --force-yes -y install %s)\n", prginit_get_name (index));
			}
			else {
				fprintf (fp, "if (aptitude --assume-yes -y install %s)\n", prginit_get_name (index));
			}

			fprintf (fp, "then\n");
			fprintf (fp, "	result_install=$?\n");
			fprintf (fp, "else\n");
			fprintf (fp, "	result_install=$?\n");
			fprintf (fp, "fi\n");
			fprintf (fp, "echo \"result_install=\"$result_install\n");
			fprintf (fp, "\n");

			fprintf (fp, "test_erreur_install\n");
			fprintf (fp, "\n");
			
			var_install.PackageActif ++;
		}
	}
		
	fprintf (fp, "#######\n");
	fprintf (fp, "# Nettoyage\n");
	fprintf (fp, "#\n");
	fprintf (fp, "rm -rf %s\n", PATH_DOWNLOAD_TO_XCFA);
	fprintf (fp, "rm -f /tmp/ERROR_INSTALL\n");
	fprintf (fp, "rm -f %s\n",TMP_FILE_XCFA_INSTALL);
	fprintf (fp, "rm -f /tmp/STOP_INSTALL\n");
	fprintf (fp, "\n\n");
	fprintf (fp, "exit 0\n");
	fprintf (fp, "\n");
	
	fclose (fp);

	LineCommand = g_strdup_printf ("chmod +x %s", FILE_XCFA_INSTALL);
	system (LineCommand);
	g_free (LineCommand);
	LineCommand = NULL;

	return (TRUE);
}

gint prginstall_in_super_user (void)
{
	return (get_in_super_user ());
}


static void prginstall_do_thread (void *arg)
{
	var_install.bool_thread_do_install = TRUE;
	var_install.CodeErreur = prginstall_in_super_user ();
	var_install.bool_thread_do_install = FALSE;
	pthread_exit (0);
}

static gint prginstall_do_timeout (gpointer data)
{
	if (var_install.bool_thread_do_install == FALSE) {
		
		/* Init des variables */
		prginit_var_default ();
		/* Scan pour prise en compte par Xcfa*/
		prginit_update_glist ();

		/* Close window */
		winpulse_close ();
		
		if (var_install.CodeErreur == 0) {
		// if (infosong_file_is_reg ("/tmp/ERROR_INSTALL")) {
			
			wininfo_create (
				_("        ERREUR PENDANT L'INSTALLATION        "),
				  "\n",
				_("   Un autre gestionnaire de paquage est probablement actif   "),
				  "\n",
				_("   OU"),
				  "\n",
				_("   La connexion internet est mauvaise"),
				  "\n",
				_("   OU"),
				  "\n",
				_("   Aucun depot pour cette application"),
				  "           \n\n",
				  "");
		}
				
		/* Suppression du fichier bash d'installation */
		infosong_delete_file (FILE_XCFA_INSTALL);

		gtk_widget_set_sensitive (GTK_WIDGET (var_prgextern.button_goto_install), prginit_get_bool_install ());
		gtk_widget_set_sensitive (GTK_WIDGET (var_prgextern.button_selection_globale), prginit_is_not_installed ());

		/* end of timeout */
		gtk_timeout_remove (var_install.handler_do_install);

	}
	else {
   		gchar *spinner="|/-\\";
		
		var_install.StrPass [ 24 ] = spinner[ var_install.Pass ++ % 4 ];
		var_install.StrPass [ 25 ] = '\0';
		winpulse_set_labelfile (var_install.StrPass);
		if (winpulse_event_set_close ()) {
			if (infosong_file_is_reg ("/tmp/STOP_INSTALL") == FALSE) {
				FILE *fp = NULL;
				fp = fopen ("/tmp/STOP_INSTALL", "a");
				fclose (fp);
			}
		}
	}
	
	return (TRUE);
}

gboolean prginstall_test_in_super_user (void)
{
	if (utils_scan_by_which (GK_SUDO, NULL) == TRUE) {
		return (TRUE);
	}
	else if (utils_scan_by_which (KDE_SUDO, NULL) == TRUE) {
		return (TRUE);
	}
	else if (utils_scan_by_which (RPM_SUDO, NULL) == TRUE) {
		return (TRUE);
	}
	wininfo_create (
		_("      kdesu et/ou gksu ABSENTS    "),
		  "\n",
		_("   Veuillez installer kdesu et/ou gksu"),
		  "           \n\n",
		  "");
	return  (FALSE);
}

void prginstall_packages (void)
{
	/* Test l'intallation en SuperUtilisateur est ok */
	if (prginstall_test_in_super_user () == TRUE) {	

		if (prginstall_button_create_file_xcfa_clicked ()) {
			
			/* Attente */
			winpulse_create ();
			winpulse_set_title (_("Installation automatique"));
			winpulse_set_init_pulse ();
			winpulse_set_labeltitle (_("Installation automatique"));
			winpulse_set_labelfile (_("Veuillez patienter ..."));
			
			var_install.Pass = -1;
			strcpy (var_install.StrPass, _("Veuillez patienter ...:   "));
			
			/* Thread & Timeout */
			var_install.bool_thread_do_install = TRUE;
			pthread_create (&var_install.nmr_tid, NULL ,(void *)prginstall_do_thread, (void *)NULL);
			var_install.handler_do_install = gtk_timeout_add (100, prginstall_do_timeout, 0);
		}
	}
}

void prginstall_set_label_type_package (GtkWidget *widget)
{
	gchar *New_Str = NULL;
	
	var_options.Adr_label_type_paquege = widget;
	
	if (utils_scan_by_which ("apt-get", NULL) == TRUE || utils_scan_by_which ("aptitude", NULL) == TRUE) {
		if (widget != NULL) {
			New_Str = g_strdup_printf (_(" <b>... les paquets: deb</b> "));
		}
		var_options.Type_Package = _DEBIAN_;
	}
	else if (utils_scan_by_which ("slackpkg", NULL) == TRUE || utils_scan_by_which ("installpkg", NULL) == TRUE) {
		if (widget != NULL) {
			New_Str = g_strdup_printf (_(" <b>... les paquets: tgz</b> "));
		}
		var_options.Type_Package = _TGZ_;
	}
	else if (utils_scan_by_which ("pacman-g2", NULL) == TRUE) {
		if (widget != NULL) {
			New_Str = g_strdup_printf (_(" <b>... les paquets: fpm</b> "));
		}
		var_options.Type_Package = _FPM_;
	}
	else if (utils_scan_by_which ("rpm", NULL) == TRUE || utils_scan_by_which ("urpmi", NULL) == TRUE  || utils_scan_by_which ("zypper", NULL) == TRUE || utils_scan_by_which ("yum", NULL) == TRUE) {
		if (widget != NULL) {
			New_Str = g_strdup_printf (_(" <b>... les paquets: rpm</b> "));
		}
		var_options.Type_Package = _RPM_;
	}
	
	if (widget != NULL && New_Str != NULL) {
		gtk_label_set_markup (GTK_LABEL (var_options.Adr_label_type_paquege), New_Str);
		gtk_label_set_markup (GTK_LABEL (GTK_WIDGET (lookup_widget (wind_main, "label_type_package_without_deb"))), New_Str);
		g_free (New_Str);
		New_Str = NULL;
	}
}

TYPE_PACKAGE prginstall_get_label_type_package (void)
{
	var_options.Type_Package = _NONE_;

	if (utils_scan_by_which ("apt-get", NULL) == TRUE || utils_scan_by_which ("aptitude", NULL) == TRUE) {
		var_options.Type_Package = _DEBIAN_;
	}
	else if (utils_scan_by_which ("slackpkg", NULL) == TRUE || utils_scan_by_which ("installpkg", NULL) == TRUE) {
		var_options.Type_Package = _TGZ_;
	}
	else if (utils_scan_by_which ("pacman-g2", NULL) == TRUE) {
		var_options.Type_Package = _FPM_;
	}
	else if (utils_scan_by_which ("rpm", NULL) == TRUE || utils_scan_by_which ("urpmi", NULL) == TRUE  || utils_scan_by_which ("zypper", NULL) == TRUE || utils_scan_by_which ("yum", NULL) == TRUE) {
		var_options.Type_Package = _RPM_;
	}
	return (var_options.Type_Package);
}

void prginstall_systeme_debian (void)
{
	if (prginit_is_selected () == FALSE) {			
		wininfo_create (
			_("   (Selection partielle) + Installation + Scan      "),
			  "        Il faut au moins selectionner un programme !!!\n"
			  "           \n",
			  "");		
		return;
	}
	prginstall_packages ();
}

