 /*
 * file      : showhide_treeview.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "support.h"
#include "interface.h"

#include <string.h>
#include <stdlib.h>

#include "global.h"
#include "secu.h"
#include "win_control.h"
#include "dvd_audio.h"
#include "cd_audio.h"
#include "file.h"
#include "split.h"
#include "config_user.h"
#include "showhide_treeview.h"



/*
*---------------------------------------------------------------------------
* DATAS
*---------------------------------------------------------------------------
*/

typedef struct {
	GtkWidget	*AdrWin;
	gboolean	 BoolNoEnter;
	guint		 PageNotebook;
} VAR_SHOWHIDE;

VAR_SHOWHIDE ShowHide;


#define MAX_DATAS_STRUCT_RADIOBUTTONS 5
typedef struct {
	gchar			 *NameLeft;
	gchar			 *NameCenter;
	gchar			 *NameRight;
	GtkCellRenderer		**AdrRenderer;
	GtkTreeViewColumn	**AdrTreeViewColumn;
	gint			  Pos;
} TAB_POSNAME;

TAB_POSNAME TabPosName [ MAX_DATAS_STRUCT_RADIOBUTTONS ] = {
	{"radiobutton_nameleft_dvd", "radiobutton_namecenter_dvd", "radiobutton_nameright_dvd",
	&var_dvdaudio.renderer, &var_dvdaudio.Adr_Column_Nom,
	1},
	{"radiobutton_nameleft_cd", "radiobutton_namecenter_cd", "radiobutton_nameright_cd",
	&var_cd.renderer, &var_cd.Adr_Column_Nom,
	1},
	{"radiobutton_nameleft_allfile", "radiobutton_namecenter_allfile", "radiobutton_nameright_allfile",
	&var_file.Adr_ColumnFileAligmentRenderer, &var_file.Adr_ColumnFileName,
	1},
	{"radiobutton_nameleft_wav", "radiobutton_namecenter_wav", "radiobutton_nameright_wav",
	&var_file.Adr_ColumnFileWavAligmentRenderer, &var_file.Adr_ColumnFileWavName,
	1},
	{"radiobutton_nameleft_mp3ogg", "radiobutton_namecenter_mp3ogg", "radiobutton_nameright_mp3ogg",
	&var_file.Adr_ColumnFileMp3OggAligmentRenderer, &var_file.Adr_ColumnFileMp3OggName,
	1}
	// {"radiobutton_nameleft_split", "radiobutton_namecenter_split", "radiobutton_nameright_split",
	// &VarSplit.renderer, &VarSplit.Adr_ColumnSplitName,
	// 1}
	} ;


/*
00 06				DVD		POS_STRUCT_DVD
06 18				CD		POS_STRUCT_CD
18 33				CONVERSIONS	POS_STRUCT_CONVERSIONS
33 40				WAV		POS_STRUCT_WAV
40 46				MP3OGG		POS_STRUCT_MP3OGG
46 61				TAGS		POS_STRUCT_TAGS
61 MAX_DATAS_STRUCT_TREEVIEW	SPLIT		POS_STRUCT_SPLIT

checkbutton_play_wav
checkbutton_play_mp3ogg
*/

#define POS_STRUCT_DVD		00
#define POS_STRUCT_CD		07
#define POS_STRUCT_CONVERSIONS	21
#define POS_STRUCT_WAV		37
#define POS_STRUCT_MP3OGG	45
#define MAX_DATAS_STRUCT_TREEVIEW 52
typedef struct {
	gchar			 *Name;
	GtkWidget		 *AdrCheckButton;
	gboolean		  BoolIsVisible;
	
	gboolean		  BoolPrintDVD;
	gboolean		  BoolPrintCD;
	gboolean		  BoolPrintFILE;
	gboolean		  BoolPrintWAV;
	gboolean		  BoolPrintMP3OGG;
	gboolean		  BoolPrintTAGS;
	gboolean		  BoolPrintSPLIT;
	
	GtkTreeViewColumn	**AdrTreeViewColumn;
} TAB_SHOWHIDE;

TAB_SHOWHIDE TabShowHide [ MAX_DATAS_STRUCT_TREEVIEW ] = {
	/*
	Name					AdrCheckButton
						|     BoolIsVisible
						|     |     BoolPrintDVD
						|     |     |      BoolPrintCD
						|     |     |      |      BoolPrintFILE
						|     |     |      |      |      BoolPrintWAV
						|     |     |      |      |      |      BoolPrintMP3OGG
						|     |     |      |      |      |      |      BoolPrintTAGS
						|     |     |      |      |      |      |      |      BoolPrintSPLIT
						|     |     |      |      |      |      |      |      |      AdrTreeViewColumn
	  POS_STRUCT_DVD                        |     |     |      |      |      |      |      |      |      |                        */
/*0*/	{"checkbutton_titre_dvd",		NULL, TRUE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, &var_dvdaudio.Adr_Column_Titres},
	{"checkbutton_play_dvd",		NULL, TRUE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, &var_dvdaudio.Adr_Column_Play},
	{"checkbutton_temps_dvd",		NULL, TRUE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, &var_dvdaudio.Adr_Column_Temps},
	{"checkbutton_format_dvd",		NULL, TRUE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, &var_dvdaudio.Adr_Column_Format},
	{"checkbutton_choix_dvd",		NULL, TRUE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, &var_dvdaudio.Adr_Column_Choix},
	{"checkbutton_normalise_dvd",		NULL, TRUE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, &var_dvdaudio.Adr_Column_Normalise},
	{"checkbutton_nom_dvd",			NULL, TRUE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, &var_dvdaudio.Adr_Column_Nom},

	/* POS_STRUCT_CD */
/*7*/	{"checkbutton_play_cd",			NULL, TRUE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, &var_cd.Adr_Column_Play},
	{"checkbutton_wav_cd",			NULL, TRUE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, &var_cd.Adr_Column_Wav},
	{"checkbutton_flac_cd",			NULL, TRUE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, &var_cd.Adr_Column_Flac},
	{"checkbutton_ape_cd",			NULL, TRUE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, &var_cd.Adr_Column_Ape},
	{"checkbutton_wavpack_cd",		NULL, TRUE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, &var_cd.Adr_Column_Wavpack},
	{"checkbutton_ogg_cd",			NULL, TRUE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, &var_cd.Adr_Column_Ogg},
	{"checkbutton_m4a_cd",			NULL, TRUE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, &var_cd.Adr_Column_M4a},
	{"checkbutton_aac_cd",			NULL, TRUE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, &var_cd.Adr_Column_Aac},
	{"checkbutton_musepack_cd",		NULL, TRUE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, &var_cd.Adr_Column_Mpc},
	{"checkbutton_mp3_cd",			NULL, TRUE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, &var_cd.Adr_Column_Mp3},
	{"checkbutton_num_cd",			NULL, TRUE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, &var_cd.Adr_Column_Num},
	{"checkbutton_time_cd",			NULL, TRUE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, &var_cd.Adr_Column_Time},
	{"checkbutton_normalise_cd",		NULL, TRUE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, &var_cd.Adr_Column_Normalise},
	{"checkbutton_nom_cd",			NULL, TRUE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE, &var_cd.Adr_Column_Nom},

	/* POS_STRUCT_CONVERSIONS */
/*21*/	{"checkbutton_play_allfile",		NULL, TRUE, FALSE, FALSE, TRUE,  TRUE,  FALSE, FALSE, FALSE, &var_file.Adr_ColumnFilePlay},
	{"checkbutton_trash_allfile",		NULL, TRUE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileTrash},
	{"checkbutton_type_allfile",		NULL, TRUE, FALSE, FALSE, TRUE,  FALSE, FALSE, TRUE,  FALSE, &var_file.Adr_ColumnFileType},
	{"checkbutton_wav_allfile",		NULL, TRUE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileWav},
	{"checkbutton_flac_allfile",		NULL, TRUE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileFlac},
	{"checkbutton_ape_allfile",		NULL, TRUE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileApe},
	{"checkbutton_wavpack_allfile",		NULL, TRUE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileWavPack},
	{"checkbutton_ogg_allfile",		NULL, TRUE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileOgg},
	{"checkbutton_m4a_allfile",		NULL, TRUE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileM4a},
	{"checkbutton_aac_allfile",		NULL, TRUE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileAac},
	{"checkbutton_musepack_allfile",	NULL, TRUE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileMpc},
	{"checkbutton_mp3_allfile",		NULL, TRUE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileMp3},
	{"checkbutton_time_allfile",		NULL, TRUE, FALSE, FALSE, TRUE,  FALSE, FALSE, TRUE,  FALSE, &var_file.Adr_ColumnFileTime},
	{"checkbutton_normalise_allfile",	NULL, TRUE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileNormalize},
	{"checkbutton_replaygain_allfile",	NULL, TRUE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileReplayGain},
	{"checkbutton_nom_allfile",		NULL, TRUE, FALSE, FALSE, TRUE,  FALSE, FALSE, TRUE,  FALSE, &var_file.Adr_ColumnFileName},

	/* POS_STRUCT_WAV */
/*37*/	{"checkbutton_play_wav",		NULL, TRUE, FALSE, FALSE, TRUE,  TRUE,  FALSE, FALSE, FALSE, &var_file.Adr_ColumnFilePlay},
	{"checkbutton_hertz_wav",		NULL, TRUE, FALSE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileWavHertz},
	{"checkbutton_newhertz_wav",		NULL, TRUE, FALSE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileWavNewHertz},
	{"checkbutton_voie_wav",		NULL, TRUE, FALSE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileWavVoie},
	{"checkbutton_newvoie_wav",		NULL, TRUE, FALSE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileWavNewVoie},
	{"checkbutton_bits_wav",		NULL, TRUE, FALSE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileWavBits},
	{"checkbutton_newbits_wav",		NULL, TRUE, FALSE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileWavNewBits},
	{"checkbutton_nom_wav",			NULL, TRUE, FALSE, FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, &var_file.Adr_ColumnFileWavName},

	/* POS_STRUCT_MP3OGG */
/*45*/	{"checkbutton_play_mp3ogg",		NULL, TRUE, FALSE, FALSE, TRUE,  TRUE,  TRUE,  FALSE, FALSE, &var_file.Adr_ColumnFilePlay},
	{"checkbutton_type_mp3ogg",		NULL, TRUE, FALSE, FALSE, FALSE, FALSE, TRUE,  FALSE, FALSE, &var_file.Adr_ColumnFileMp3OggType},
	{"checkbutton_bitrate_mp3ogg",		NULL, TRUE, FALSE, FALSE, FALSE, FALSE, TRUE,  FALSE, FALSE, &var_file.Adr_ColumnFileMp3OggBitrate},
	{"checkbutton_nexbitrate_mp3ogg",	NULL, TRUE, FALSE, FALSE, FALSE, FALSE, TRUE,  FALSE, FALSE, &var_file.Adr_ColumnFileMp3OggNewBitrate},
	{"checkbutton_size_mp3ogg",		NULL, TRUE, FALSE, FALSE, FALSE, FALSE, TRUE,  FALSE, FALSE, &var_file.Adr_ColumnFileMp3OggSize},
	{"checkbutton_time_mp3ogg",		NULL, TRUE, FALSE, FALSE, FALSE, FALSE, TRUE,  FALSE, FALSE, &var_file.Adr_ColumnFileMp3OggTime},
	{"checkbutton_nom_mp3ogg",		NULL, TRUE, FALSE, FALSE, FALSE, FALSE, TRUE,  FALSE, FALSE, &var_file.Adr_ColumnFileMp3OggName}

	/* POS_STRUCT_SPLIT */
/*52*/	// {"checkbutton_nbrcoupes_split",	NULL, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  &VarSplit.Adr_ColumnSplitCoupes},
	// {"checkbutton_type_split",		NULL, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  &VarSplit.Adr_ColumnSplitType},
	// {"checkbutton_temps_split",		NULL, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  &VarSplit.Adr_ColumnSplitTime},
	// {"checkbutton_nom_split",		NULL, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,  &VarSplit.Adr_ColumnSplitName}

	};


void showhidetreeview_set_etat_treeview (gint NotebookGeneral, gint NotebookFichiers)
{
	gint     cpt;
	gboolean Bool;
			
	switch (NotebookGeneral) {
	case NOTEBOOK_DVD_AUDIO :
		for (cpt = POS_STRUCT_DVD; cpt < MAX_DATAS_STRUCT_TREEVIEW; cpt ++) {
			if (*TabShowHide [ cpt ].AdrTreeViewColumn) {
				Bool = 	TabShowHide [ cpt ].BoolIsVisible == TRUE &&
					TabShowHide [ cpt ].BoolPrintDVD == TRUE;
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), Bool);
			}
		}
		break;
	case NOTEBOOK_CD_AUDIO :
		for (cpt = POS_STRUCT_CD; cpt < MAX_DATAS_STRUCT_TREEVIEW; cpt ++) {
			if (*TabShowHide [ cpt ].AdrTreeViewColumn) {
				Bool = 	TabShowHide [ cpt ].BoolIsVisible == TRUE &&
					TabShowHide [ cpt ].BoolPrintCD == TRUE;
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), Bool);
			}
		}
		break;
	case NOTEBOOK_FICHIERS :
		switch (NotebookFichiers) {
		case NOTEBOOK_FICHIERS_CONVERSION :
			for (cpt = POS_STRUCT_CONVERSIONS; cpt < MAX_DATAS_STRUCT_TREEVIEW; cpt ++) {
				if (*TabShowHide [ cpt ].AdrTreeViewColumn) {
					Bool = 	TabShowHide [ cpt ].BoolIsVisible == TRUE &&
						TabShowHide [ cpt ].BoolPrintFILE == TRUE;
					gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), Bool);
				}
			}
			break;
		case NOTEBOOK_FICHIERS_WAV :
			for (cpt = POS_STRUCT_CONVERSIONS; cpt < MAX_DATAS_STRUCT_TREEVIEW; cpt ++) {
				if (*TabShowHide [ cpt ].AdrTreeViewColumn) {
					Bool = 	TabShowHide [ cpt ].BoolIsVisible == TRUE &&
						TabShowHide [ cpt ].BoolPrintWAV == TRUE;
					gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), Bool);
				}
			}
			break;
		case NOTEBOOK_FICHIERS_MP3OGG :
			for (cpt = POS_STRUCT_CONVERSIONS; cpt < MAX_DATAS_STRUCT_TREEVIEW; cpt ++) {
				if (*TabShowHide [ cpt ].AdrTreeViewColumn) {
					Bool = 	TabShowHide [ cpt ].BoolIsVisible == TRUE &&
						TabShowHide [ cpt ].BoolPrintMP3OGG == TRUE;
					gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), Bool);
				}
			}
			break;
		case NOTEBOOK_FICHIERS_TAGS :
			for (cpt = POS_STRUCT_CONVERSIONS; cpt < MAX_DATAS_STRUCT_TREEVIEW; cpt ++) {
				if (*TabShowHide [ cpt ].AdrTreeViewColumn) {
					Bool = 	TabShowHide [ cpt ].BoolIsVisible == TRUE &&
						TabShowHide [ cpt ].BoolPrintTAGS == TRUE;
					gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), Bool);
				}
			}
			break;
		}
		break;
	case NOTEBOOK_SPLIT :
		/*
		for (cpt = POS_STRUCT_SPLIT; cpt < MAX_DATAS_STRUCT_TREEVIEW; cpt ++) {
			if (*TabShowHide [ cpt ].AdrTreeViewColumn) {
				Bool = 	TabShowHide [ cpt ].BoolIsVisible == TRUE &&
					TabShowHide [ cpt ].BoolPrintSPLIT == TRUE;
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), Bool);
			}
		}
		*/
		break;
	}
}

void showhidetreeview_set_etat_fields (void)
{
	gint cpt;

	/* Set 1 is visible else set 0 */
	for (cpt = POS_STRUCT_DVD; cpt < MAX_DATAS_STRUCT_TREEVIEW; cpt ++) {
		TabShowHide [ cpt ].BoolIsVisible = (Config_User.StringBoolFieldsIsVisible [ cpt ] == '0' ? FALSE : TRUE);
	}
}

gint showhidetreeview_get_etat_fields (void)
{
	gint cpt;

	/* Remove string */
	g_free (Config_User.StringBoolFieldsIsVisible);
	Config_User.StringBoolFieldsIsVisible = NULL;

	/* Allocate string */
	Config_User.StringBoolFieldsIsVisible = g_strnfill (MAX_DATAS_STRUCT_TREEVIEW +4, '1');

	/* Set 1 is visible else set 0 */
	for (cpt = POS_STRUCT_DVD; cpt < MAX_DATAS_STRUCT_TREEVIEW; cpt ++) {
		Config_User.StringBoolFieldsIsVisible [ cpt ] = (TabShowHide [ cpt ].BoolIsVisible == FALSE ? '0' : '1');
	}
	Config_User.StringBoolFieldsIsVisible [ cpt ] = '\0';
	/*g_print ("[ %02d champs ] %s\n", cpt, Config_User.StringBoolFieldsIsVisible);*/
	return (cpt);
}

gboolean showhidetreeview_delete_event (void)
{
	gtk_widget_destroy(ShowHide.AdrWin);
	wincontrol_remove_last ();
	return (FALSE);
}
gboolean showhidetreeview_destroy_event (void)
{
	gtk_widget_destroy(ShowHide.AdrWin);
	wincontrol_remove_last ();
	return (FALSE);
}
void showhidetreeview_button_quit_windtreeview_clicked (void)
{
	gtk_widget_destroy(ShowHide.AdrWin);
	wincontrol_remove_last ();
}
void showhidetreeview_notebook_windtreeview_switch_page (guint page_num)
{
	ShowHide.PageNotebook = page_num;

	switch(page_num) {
	case 0 :
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
				NOTEBOOK_DVD_AUDIO);
		break;
	case 1 :
		/*
		Config_User.BoolEtatExpanderCd = TRUE;
		gtk_expander_set_expanded (GTK_EXPANDER (var_cd.Adr_Expander), Config_User.BoolEtatExpanderCd);
		*/
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
				NOTEBOOK_CD_AUDIO);
		break;
	case 2 :
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
				NOTEBOOK_FICHIERS);
			gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_in_file")),
					NOTEBOOK_FICHIERS_CONVERSION);
		break;
	case 3 :
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
				NOTEBOOK_FICHIERS);
			gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_in_file")),
					NOTEBOOK_FICHIERS_WAV);
		break;
	case 4 :
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
				NOTEBOOK_FICHIERS);
			gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_in_file")),
					NOTEBOOK_FICHIERS_MP3OGG);
		break;
	case 5 :
		/*
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
				NOTEBOOK_SPLIT);
		*/
		break;
	}

	if (page_num >= 2 && page_num <= 4) {
		Config_User.BoolEtatExpanderFile = TRUE;
		/*gtk_expander_set_expanded (GTK_EXPANDER (var_file.Adr_Expander), Config_User.BoolEtatExpanderFile);*/
	}
}

void showhidetreeview_get_adr_widget (void)
{
	gint cpt;

	ShowHide.BoolNoEnter = TRUE;

	for (cpt = POS_STRUCT_DVD; cpt < MAX_DATAS_STRUCT_TREEVIEW; cpt ++) {

		/* Prend l'adresse du widget */
		TabShowHide [ cpt ].AdrCheckButton = GTK_WIDGET (lookup_widget (ShowHide.AdrWin, TabShowHide [ cpt ].Name));

		/* Prend l'etat de visibilite */
		TabShowHide [ cpt ].BoolIsVisible = TRUE;
		TabShowHide [ cpt ].BoolIsVisible = (Config_User.StringBoolFieldsIsVisible [ cpt ] == '0' ? FALSE : TRUE);

		/* Place le CheckButton avec cet etat */
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (TabShowHide [ cpt ].AdrCheckButton), TabShowHide [ cpt ].BoolIsVisible);
	}
	ShowHide.BoolNoEnter = FALSE;
}

void showhidetreeview_checkbutton_modif_treeview_clicked (GtkButton *button)
{
	gint cpt;

	if (ShowHide.BoolNoEnter == TRUE) return;

	for (cpt = POS_STRUCT_DVD; cpt < MAX_DATAS_STRUCT_TREEVIEW; cpt ++) {
		if (GTK_BUTTON (button) == GTK_BUTTON (TabShowHide [ cpt ].AdrCheckButton)) {

			TabShowHide [ cpt ].BoolIsVisible = (TabShowHide [ cpt ].BoolIsVisible == TRUE) ? FALSE : TRUE;

			/* Show / Hide la colonne du TreeView */
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), TabShowHide [ cpt ].BoolIsVisible);

			/* sortie */
			break;
		}
	}
	showhidetreeview_get_etat_fields ();
}

void showhidetreeview_button_select_global_windtreeview_clicked (void)
{
	gint	cpt;

	ShowHide.BoolNoEnter = TRUE;

	switch (ShowHide.PageNotebook) {
	case 0 :
		for (cpt = POS_STRUCT_DVD; cpt < POS_STRUCT_CD; cpt ++) {
			TabShowHide [ cpt ].BoolIsVisible = TRUE;
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (TabShowHide [ cpt ].AdrCheckButton), TabShowHide [ cpt ].BoolIsVisible);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), TabShowHide [ cpt ].BoolIsVisible);
		}
		break;
	case 1 :
		for (cpt = POS_STRUCT_CD; cpt < POS_STRUCT_CONVERSIONS; cpt ++) {
			TabShowHide [ cpt ].BoolIsVisible = TRUE;
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (TabShowHide [ cpt ].AdrCheckButton), TabShowHide [ cpt ].BoolIsVisible);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), TabShowHide [ cpt ].BoolIsVisible);
		}
		break;
	case 2 :
		for (cpt = POS_STRUCT_CONVERSIONS; cpt < POS_STRUCT_WAV; cpt ++) {
			TabShowHide [ cpt ].BoolIsVisible = TRUE;
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (TabShowHide [ cpt ].AdrCheckButton), TabShowHide [ cpt ].BoolIsVisible);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), TabShowHide [ cpt ].BoolIsVisible);
		}
		break;
	case 3 :
		for (cpt = POS_STRUCT_WAV; cpt < POS_STRUCT_MP3OGG; cpt ++) {
			TabShowHide [ cpt ].BoolIsVisible = TRUE;
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (TabShowHide [ cpt ].AdrCheckButton), TabShowHide [ cpt ].BoolIsVisible);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), TabShowHide [ cpt ].BoolIsVisible);
		}
		break;
	case 4 :
		for (cpt = POS_STRUCT_MP3OGG; cpt < MAX_DATAS_STRUCT_TREEVIEW; cpt ++) {
			TabShowHide [ cpt ].BoolIsVisible = TRUE;
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (TabShowHide [ cpt ].AdrCheckButton), TabShowHide [ cpt ].BoolIsVisible);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), TabShowHide [ cpt ].BoolIsVisible);
		}
		break;
	case 5 :
		/*
		for (cpt =POS_STRUCT_SPLIT; cpt < MAX_DATAS_STRUCT_TREEVIEW; cpt ++) {
			TabShowHide [ cpt ].BoolIsVisible = TRUE;
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (TabShowHide [ cpt ].AdrCheckButton), TabShowHide [ cpt ].BoolIsVisible);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), TabShowHide [ cpt ].BoolIsVisible);
		}
		*/
		break;
	}
	showhidetreeview_get_etat_fields ();
	ShowHide.BoolNoEnter = FALSE;
}
void showhidetreeview_button_deselect_global_windtreeview_clicked (void)
{
	gint	cpt;

	ShowHide.BoolNoEnter = TRUE;

	switch (ShowHide.PageNotebook) {
	case 0 :
		for (cpt = POS_STRUCT_DVD; cpt < POS_STRUCT_CD; cpt ++) {
			TabShowHide [ cpt ].BoolIsVisible = FALSE;
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (TabShowHide [ cpt ].AdrCheckButton), TabShowHide [ cpt ].BoolIsVisible);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), TabShowHide [ cpt ].BoolIsVisible);
		}
		break;
	case 1 :
		for (cpt = POS_STRUCT_CD; cpt < POS_STRUCT_CONVERSIONS; cpt ++) {
			TabShowHide [ cpt ].BoolIsVisible = FALSE;
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (TabShowHide [ cpt ].AdrCheckButton), TabShowHide [ cpt ].BoolIsVisible);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), TabShowHide [ cpt ].BoolIsVisible);
		}
		break;
	case 2 :
		for (cpt = POS_STRUCT_CONVERSIONS; cpt < POS_STRUCT_WAV; cpt ++) {
			TabShowHide [ cpt ].BoolIsVisible = FALSE;
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (TabShowHide [ cpt ].AdrCheckButton), TabShowHide [ cpt ].BoolIsVisible);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), TabShowHide [ cpt ].BoolIsVisible);
		}
		break;
	case 3 :
		for (cpt = POS_STRUCT_WAV; cpt < POS_STRUCT_MP3OGG; cpt ++) {
			TabShowHide [ cpt ].BoolIsVisible = FALSE;
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (TabShowHide [ cpt ].AdrCheckButton), TabShowHide [ cpt ].BoolIsVisible);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), TabShowHide [ cpt ].BoolIsVisible);
		}
		break;
	case 4 :
		for (cpt = POS_STRUCT_MP3OGG; cpt < MAX_DATAS_STRUCT_TREEVIEW; cpt ++) {
			TabShowHide [ cpt ].BoolIsVisible = FALSE;
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (TabShowHide [ cpt ].AdrCheckButton), TabShowHide [ cpt ].BoolIsVisible);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), TabShowHide [ cpt ].BoolIsVisible);
		}
		break;
	case 5 :
		/*
		for (cpt = POS_STRUCT_SPLIT; cpt < MAX_DATAS_STRUCT_TREEVIEW; cpt ++) {
			TabShowHide [ cpt ].BoolIsVisible = FALSE;
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (TabShowHide [ cpt ].AdrCheckButton), TabShowHide [ cpt ].BoolIsVisible);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN (*TabShowHide [ cpt ].AdrTreeViewColumn), TabShowHide [ cpt ].BoolIsVisible);
		}
		*/
		break;
	}
	showhidetreeview_get_etat_fields ();
	ShowHide.BoolNoEnter = FALSE;
}

void showhidetreeview_set_pos_radiobutton (void)
{
	gint cpt;

	for (cpt = POS_STRUCT_DVD; cpt < MAX_DATAS_STRUCT_RADIOBUTTONS; cpt ++) {

		GtkWidget *Widget = NULL;

		if (TabPosName [ cpt ].Pos == 0) {
			if ((Widget = GTK_WIDGET (lookup_widget (ShowHide.AdrWin, TabPosName [ cpt ].NameLeft))) != NULL)
				gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (Widget), TRUE);
		}
		else if (TabPosName [ cpt ].Pos == 1) {
			if ((Widget = GTK_WIDGET (lookup_widget (ShowHide.AdrWin, TabPosName [ cpt ].NameCenter))) != NULL)
				gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (Widget), TRUE);
		}
		else if (TabPosName [ cpt ].Pos == 2) {
			if ((Widget = GTK_WIDGET (lookup_widget (ShowHide.AdrWin, TabPosName [ cpt ].NameRight))) != NULL)
				gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (Widget), TRUE);
		}
	}
}

void showhidetreeview_open_window (guint OngletGeneral, guint OngletFichier)
{
	ShowHide.AdrWin = create_wind_treeview ();
	wincontrol_set_adr (
		ShowHide.AdrWin,		/* Window adress                */
		"showhide",			/* Window name			*/
		TRUE,				/* gtk_window_set_transient_for */
		TRUE				/* gtk_window_set_modal         */
		);

	switch (OngletGeneral) {
	case NOTEBOOK_DVD_AUDIO :
		gtk_notebook_set_current_page (
				GTK_NOTEBOOK (lookup_widget (ShowHide.AdrWin, "notebook_windtreeview")),
				0);
		break;
	case NOTEBOOK_CD_AUDIO :
		gtk_notebook_set_current_page (
				GTK_NOTEBOOK (lookup_widget (ShowHide.AdrWin, "notebook_windtreeview")),
				1);
		break;
	case NOTEBOOK_FICHIERS :
		switch (OngletFichier) {
		case NOTEBOOK_FICHIERS_CONVERSION :
		case NOTEBOOK_FICHIERS_TAGS :
			gtk_notebook_set_current_page (
					GTK_NOTEBOOK (lookup_widget (ShowHide.AdrWin, "notebook_windtreeview")),
					2);
			break;
		case NOTEBOOK_FICHIERS_WAV :
			gtk_notebook_set_current_page (
					GTK_NOTEBOOK (lookup_widget (ShowHide.AdrWin, "notebook_windtreeview")),
					3);
			break;
		case NOTEBOOK_FICHIERS_MP3OGG :
			gtk_notebook_set_current_page (
					GTK_NOTEBOOK (lookup_widget (ShowHide.AdrWin, "notebook_windtreeview")),
					4);
			break;
		}
		break;
	case NOTEBOOK_SPLIT :
		/*
		gtk_notebook_set_current_page (
				GTK_NOTEBOOK (lookup_widget (ShowHide.AdrWin, "notebook_windtreeview")),
				5);
		*/
		break;
	}
	if (OngletGeneral > 3) {
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
				NOTEBOOK_DVD_AUDIO);
	}

	secu_thread_add ();
	gtk_widget_show_all (ShowHide.AdrWin);
	showhidetreeview_get_adr_widget ();
	showhidetreeview_set_pos_radiobutton ();
}

void showhidetreeview_radiobutton_modif_treeview_clicked (GtkButton *button)
{
	gint cpt;

	for (cpt = POS_STRUCT_DVD; cpt < MAX_DATAS_STRUCT_RADIOBUTTONS; cpt ++) {
		if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (ShowHide.AdrWin, TabPosName [ cpt ].NameLeft)))) {
			Config_User.StringPosFieldsName [ cpt ] = '0';
			TabPosName [ cpt ].Pos = 0;
			gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (*TabPosName [ cpt ].AdrTreeViewColumn), 0.0);
			g_object_set (*TabPosName [ cpt ].AdrRenderer, "xalign", 0.0, NULL);
			break;
		}
		if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (ShowHide.AdrWin, TabPosName [ cpt ].NameCenter)))) {
			Config_User.StringPosFieldsName [ cpt ] = '1';
			TabPosName [ cpt ].Pos = 1;
			gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (*TabPosName [ cpt ].AdrTreeViewColumn), 0.5);
			g_object_set (*TabPosName [ cpt ].AdrRenderer, "xalign", 0.5, NULL);
			break;
		}
		if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (ShowHide.AdrWin, TabPosName [ cpt ].NameRight)))) {
			Config_User.StringPosFieldsName [ cpt ] = '2';
			TabPosName [ cpt ].Pos = 2;
			gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (*TabPosName [ cpt ].AdrTreeViewColumn), 1.0);
			g_object_set (*TabPosName [ cpt ].AdrRenderer, "xalign", 1.0, NULL);
			break;
		}
	}
}

void showhidetreeview_radiobutton_set_PosFieldsName (void)
{
	gint cpt;

	for (cpt = POS_STRUCT_DVD; cpt < MAX_DATAS_STRUCT_RADIOBUTTONS; cpt ++) {
		if (Config_User.StringPosFieldsName [ cpt ] == '0') {
			TabPosName [ cpt ].Pos = 0;
			gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (*TabPosName [ cpt ].AdrTreeViewColumn), 0.0);
			g_object_set (*TabPosName [ cpt ].AdrRenderer, "xalign", 0.0, NULL);
		}
		else if (Config_User.StringPosFieldsName [ cpt ] == '1') {
			TabPosName [ cpt ].Pos = 1;
			gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (*TabPosName [ cpt ].AdrTreeViewColumn), 0.5);
			g_object_set (*TabPosName [ cpt ].AdrRenderer, "xalign", 0.5, NULL);
		}
		else if (Config_User.StringPosFieldsName [ cpt ] == '2') {
			TabPosName [ cpt ].Pos = 2;
			gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (*TabPosName [ cpt ].AdrTreeViewColumn), 1.0);
			g_object_set (*TabPosName [ cpt ].AdrRenderer, "xalign", 1.0, NULL);
		}
	}
}






