 /*
 *  file      : split_shuttle.h
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  OLD ADRESS:
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  NEW ADRESS:
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *  ---
 *
 *  Widget pour la fonction SPLIT de XCFA qui permet la simplification
 *  de selection de debut et de fin de plage pour la decoupe ainsi que
 *  pour l'ecoute audio.
 *  J'ai developpe ce widget car je ne l'ai trouve nulle part !!!
 *
 *  Representation du spectre frequentiel (amplitude des différentes frequences)
 *  d'un fichier de type wav
 *
 *  Documentation:
 *
 *  	1)
 *  	Les secrets des formats de compression audio
 *  	par Saad Bennani
 *  	GNU/Linux Magazine France no 101 page 50
 *
 *  	2)
 *  	Analyse code depuis: wavbreaker
 *  	par Timothy Robinson et Thomas Perl
 *  	http://wavbreaker.sourceforge.net/
 *
 *  	3)
 *	Analyse de Fourier à l'aide d'un script PERL.
 *  	http://perso.ensc-rennes.fr/jimmy.roussel/tice/perl/tuto_FFT.html
 *	par Jimmy ROUSSEL
 *
 */


#ifndef __splitshuttle_h__
#define __splitshuttle_h__ 1

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define SPLIT_TYPE_SHUTTLE		(splitshuttle_get_type ())
#define SPLIT_SHUTTLE(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), SPLIT_TYPE_SHUTTLE, SplitShuttle))
#define SPLIT_SHUTTLE_CLASS(obj)	(G_TYPE_CHECK_CLASS_CAST ((obj), SPLIT_SHUTTLE, SplitShuttleClass))
#define SPLIT_IS_SHUTTLE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPLIT_TYPE_SHUTTLE))
#define SPLIT_IS_SHUTTLE_CLASS(obj)	(G_TYPE_CHECK_CLASS_TYPE ((obj), SPLIT_TYPE_SHUTTLE))
#define SPLIT_SHUTTLE_GET_CLASS		(G_TYPE_INSTANCE_GET_CLASS ((obj), SPLIT_TYPE_SHUTTLE, SplitShuttleClass))


typedef struct _SplitShuttle        SplitShuttle;
typedef struct _SplitShuttleClass   SplitShuttleClass;

struct _SplitShuttle
{
	GtkDrawingArea parent;
};

struct _SplitShuttleClass
{
	GtkDrawingAreaClass parent_class;
	void (* value_changed) (SplitShuttle *wheel);
};


GtkWidget *splitshuttle_new (void);

void       splitshuttle_set_func_begin (void *FuncExternBegin);
void       splitshuttle_set_percent_begin (gdouble Percent);
gdouble    splitshuttle_get_percent_begin (void);

void       splitshuttle_set_func_end (void *FuncExternBegin);
void       splitshuttle_set_percent_end (gdouble Percent);
gdouble    splitshuttle_get_percent_end (void);

void       splitshuttle_set_TimeSongSec (guint TimeSongSec);
gdouble    splitshuttle_get_TimeSongSec (void);

gchar     *splitshuttle_get_time (gdouble Percent, gboolean BoolTag, gboolean BoolPercent, gboolean BoolHours, gboolean BoolMin);
void       splitshuttle_get_time_from_percent (gdouble Percent, gint *H, gint *M, gint *S, gint *C);
gdouble    splitshuttle_get_percent (gint H, gint M, gint S, gint C);

void       splitshuttle_set_ActivePlayPercent (gdouble Percent);
gboolean   splitshuttle_if_play (void);
gdouble    splitshuttle_get_percent_play_begin (void);
gdouble    splitshuttle_get_percent_play_end (void);
void       splitshuttle_set_BoolActivePlayPercent (void);
void       splitshuttle_set_BoolStopPlayPercent (void);
void       splitshuttle_set_func_WaitPlay (void *FuncExternWaitPlay);
void       splitshuttle_set_func_StopPlay (void *FuncExternStopPlay);
void       splitshuttle_set_adr_redraw (GtkWidget *Widget);
void       splitshuttle_reset_play (void);
void       splitshuttle_set_out (void);
gboolean   splitshuttle_read_file_spectre (char *NameFile);
void       splitshuttle_remove_data (void);

void       splitshuttle_force_redraw (void);

G_END_DECLS

#endif

