 /*
 * file    : tags.c
 * project : xcfa
 * with    : Gtk-2
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 * 2003,2004,2005,2006,2007,2008,2009 Claude Bulin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */



#include <gtk/gtk.h>
#include "support.h"

#include <pthread.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "tags.h"
#include "global.h"
#include <taglib/tag_c.h>



/*
*---------------------------------------------------------------------------
* EXTERN
*---------------------------------------------------------------------------
*/


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/


/*
*---------------------------------------------------------------------------
* 
*---------------------------------------------------------------------------
*/
TAGS *tags_alloc (gboolean bool_tag_cd)
{
	TAGS *new = (TAGS *)g_malloc0 (sizeof (TAGS));
	
	/* TRUE  is CD-AUDIO
	*  FALSE is FILE
	*/
	if (new) {
		new->bool_tag_cd = bool_tag_cd;
		new->bool_save = FALSE;
	}
	
	return ((TAGS *)new);
}

TAGS *tags_remove (TAGS *tags)
{
	if (tags) {
		g_free (tags->Album);
		g_free (tags->Artist);
		g_free (tags->Title);
		g_free (tags->Number);
		g_free (tags->Genre);
		g_free (tags->Year);
		g_free (tags->Comment);
		g_free (tags->Description);
		
		g_free (tags);
		tags = NULL;
	}
	return ((TAGS *)NULL);
}

void tags_set_flag_modification (TAGS *tags, gboolean p_flag)
{
	if (tags) tags->bool_save = p_flag;
}
gboolean tags_is_modified (TAGS *tags)
{
	return (tags ? tags->bool_save : FALSE);
}

TAGS *tags_set (gchar *filename, TAGS *tags)
{
	gchar *Ptr = NULL;
	
	if (tags->Artist == NULL) {
		Ptr = strrchr (filename, '/');
		if (Ptr) {
			Ptr ++;
			tags->Artist = g_strdup (Ptr);
			Ptr = strrchr (tags->Artist, '.');
			if (Ptr) *Ptr = '\0';
		}
		else {
			tags->Artist = g_strdup (filename);
		}
	}
	if (tags->Title == NULL) {
		Ptr = strrchr (filename, '/');
		if (Ptr) {
			Ptr ++;
			tags->Title = g_strdup (Ptr);
			Ptr = strrchr (tags->Title, '.');
			if (Ptr) *Ptr = '\0';
		}
		else {
			tags->Title = g_strdup (filename);
		}
	}

	/* Complete l'allocation */
	if (!tags->Album)	tags->Album       = g_strdup ("");
	if (!tags->Artist)	tags->Artist      = g_strdup ("");
	if (!tags->Title)	tags->Title       = g_strdup ("");
	/*
	if (!tags->Number)	tags->Number      = g_strdup ("");
				tags->IntNumber   = 1;
	*/
	if (!tags->Number) {
		tags->Number      = g_strdup ("1");
		tags->IntNumber   = 1;
	} else {
		tags->IntNumber   = atoi (tags->Number);
	}
	
	/*
	if (!tags->Genre)	tags->Genre       = g_strdup ("");
				tags->IntGenre    = 1;
	*/
	if (!tags->Genre) {
		tags->Genre       = g_strdup ("1");
		tags->IntGenre    = 1;
	} else {
		tags->IntGenre    = atoi (tags->Genre);
	}
	
	/*
	if (!tags->Year)	tags->Year        = g_strdup ("1962");
				tags->IntYear     = 1962;
	*/
	if (!tags->Year) {
		tags->Year        = g_strdup ("1962");
		tags->IntYear     = 1962;
	} else {
		tags->IntYear     = atoi (tags->Year);
	}

	if (!tags->Comment)	tags->Comment     = g_strdup ("");
	if (!tags->Description)	tags->Description = g_strdup ("");
	
	return ((TAGS *)tags);
}

gchar *tags_get_time (gchar *namefile)
{
	TagLib_File  *file;
	TagLib_Tag   *tag;
	const TagLib_AudioProperties *properties;
	gint          seconds;
	gint          minutes;
	gchar        *RetTime = NULL;
	
	PRINT_FUNC_LF();
	g_print ("\t%s\n", namefile); 
	
	if ((file = taglib_file_new (namefile))) {
	
		taglib_set_strings_unicode(FALSE);
		tag = taglib_file_tag(file);
		properties = taglib_file_audioproperties(file);
		
		seconds = taglib_audioproperties_length(properties) % 60;
		minutes = (taglib_audioproperties_length(properties) - seconds) / 60;

		RetTime = g_strdup_printf ("%02d:%02d", minutes, seconds);
		
		taglib_tag_free_strings();
		taglib_file_free (file);
	}
	else {
		RetTime = g_strdup ("???");
	}
	return (RetTime);
}

gchar *tags_get_time_wav (gchar *namefile)
{
	INFO_WAV *info = NULL;
	gchar     *ptr = NULL;

	if ((info = tagswav_get_info (NULL, namefile))) {
		ptr = g_strdup (info->time);
		info = tagswav_remove_info (info);
	}
	if (!ptr) ptr = g_strdup ("???");
	return (ptr);
}







