 /*
 * file      : win_choice.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "support.h"
#include "interface.h"

#include "utils.h"
#include "global.h"
#include "win_control.h"
#include "win_choice.h"




typedef struct {
	GtkWidget	*AdrWin;
	void		(*FuncExtern)(void);
} VAR_WINCHOICE;

VAR_WINCHOICE VarWinChoice;




gboolean windchoice_delete_event (void)
{
	wincontrol_remove_last ();
	gtk_widget_destroy(VarWinChoice.AdrWin);
	return (FALSE);
}

gboolean windchoice_destroy_event (void)
{
	wincontrol_remove_last ();
	gtk_widget_destroy(VarWinChoice.AdrWin);
	return (FALSE);
}

void windchoice_button_cancel_wind_choice_clicked (void)
{
	wincontrol_remove_last ();
	gtk_widget_destroy(VarWinChoice.AdrWin);
}

void windchoice_button_ok_wind_choice_clicked (void)
{
	wincontrol_remove_last ();
	gtk_widget_destroy(VarWinChoice.AdrWin);
	if (VarWinChoice.FuncExtern) (*VarWinChoice.FuncExtern)();
}

void windchoice_open (gchar *Title, gchar *Label, gboolean BoolCancel, void *Func_Extern)
{
	VarWinChoice.FuncExtern = Func_Extern;
	VarWinChoice.AdrWin =  create_wind_choice ();
	wincontrol_set_adr (
		VarWinChoice.AdrWin,		/* Window adress                */
		"windchoice",			/* Window name			*/
		TRUE,				/* gtk_window_set_transient_for */
		TRUE				/* gtk_window_set_modal         */
		);
	utils_set_default_icone_xcfa (VarWinChoice.AdrWin);
	gtk_window_set_title (GTK_WINDOW (VarWinChoice.AdrWin), Title);
	gtk_widget_show_all (VarWinChoice.AdrWin);
	gtk_label_set_markup (GTK_LABEL (GTK_WIDGET (lookup_widget (VarWinChoice.AdrWin, "label_wind_choice"))), Label);
	if (BoolCancel == FALSE)
		gtk_widget_hide (GTK_WIDGET (lookup_widget (VarWinChoice.AdrWin, "button_cancel_wind_choice")));
	else
		gtk_widget_show (GTK_WIDGET (lookup_widget (VarWinChoice.AdrWin, "button_cancel_wind_choice")));
}




