 /*
 * file      : win_norm_replay.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>
#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "global.h"
#include "utils.h"
#include "win_control.h"
#include "win_norm_replay.h"

/*
*--------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/
typedef struct {
	GtkWidget       *Adr_Win;
	GtkWidget       *Adr_label_title;
	GtkWidget       *Adr_label_compteur;
	GtkWidget       *Adr_ProgressBar;
	
	gboolean	 Bool_Is_Close;

} VAR_NORM_REPLAY;

VAR_NORM_REPLAY var_normreplay;

/*
*---------------------------------------------------------------------------
* REALIZE WINDOW
*---------------------------------------------------------------------------
*/
void on_label_titre_wind_scan_realize (GtkWidget *widget, gpointer user_data)
{
	var_normreplay.Adr_label_title = widget;
}
void on_label_compteur_wind_scan_realize (GtkWidget *widget, gpointer user_data)
{
	var_normreplay.Adr_label_compteur = widget;
}
void on_progressbar_wind_scan_realize (GtkWidget *widget, gpointer user_data)
{
	var_normreplay.Adr_ProgressBar = widget;
}

/*
*---------------------------------------------------------------------------
* STOP USER
*---------------------------------------------------------------------------
*/
void on_button_cancel_wind_scan_clicked (GtkButton *button, gpointer user_data)
{
	var_normreplay.Bool_Is_Close = TRUE;
}

/*
*---------------------------------------------------------------------------
* END WIN
*---------------------------------------------------------------------------
*/
gboolean on_wind_scan_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	var_normreplay.Bool_Is_Close = TRUE;
	return TRUE;
}
gboolean on_wind_scan_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	var_normreplay.Bool_Is_Close = TRUE;
	return TRUE;
}

/*
*---------------------------------------------------------------------------
* CREATE WINDOW
*---------------------------------------------------------------------------
*/
void create_WinNormReplay (gchar *title)
{
	gchar	*Str = NULL;
	
	var_normreplay.Adr_Win = create_wind_scan ();
	wincontrol_set_adr (var_normreplay.Adr_Win, "var_normreplay.Adr_Win", TRUE, TRUE);
	
	utils_set_default_icone_xcfa (var_normreplay.Adr_Win);
	gtk_widget_show_all (var_normreplay.Adr_Win);

	Str = g_strdup_printf ("<span font_desc=\"sans 15\"><span color=\"black\"><b>%s</b></span></span>", title);
	gtk_label_set_markup (GTK_LABEL (var_normreplay.Adr_label_title), Str);
	g_free (Str);
	Str = NULL;
}


/*
*---------------------------------------------------------------------------
* EXTERNAL
*---------------------------------------------------------------------------
*/

void WinNormReplay_close (void)
{
	var_normreplay.Bool_Is_Close = TRUE;
	gtk_widget_destroy(var_normreplay.Adr_Win);
	wincontrol_remove_last ();
}
gboolean WinNormReplay_is_get_close (void)
{
	return (var_normreplay.Bool_Is_Close);
}

void WinNormReplay_reset_progressBar (void)
{
	/* PRINT_FUNC_LF(); */
	gtk_widget_show (GTK_WIDGET (var_normreplay.Adr_ProgressBar));
	gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (var_normreplay.Adr_ProgressBar), 0.0);
	gtk_progress_bar_set_text (GTK_PROGRESS_BAR (var_normreplay.Adr_ProgressBar), "Waiting ...");
}
void WinNormReplay_set_data_progressBar (double Etat)
{
	gchar     *Total= NULL;
	
	/* PRINT_FUNC_LF(); */

	if (Etat <= 0.0) Etat = 0.0;
	if (Etat >= 1.0) Etat = 1.0;
	
	Total = g_strdup_printf ("%d%%", (int)(Etat*100));
	gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (var_normreplay.Adr_ProgressBar), Etat);
	gtk_progress_bar_set_text (GTK_PROGRESS_BAR (var_normreplay.Adr_ProgressBar), Total);
	g_free (Total);
	Total= NULL;
}

void WinNormReplay_set_compteur (gchar *StrCompteur)
{
	gtk_label_set_justify (GTK_LABEL (var_normreplay.Adr_label_compteur), GTK_JUSTIFY_LEFT);
	gtk_label_set_markup (GTK_LABEL (var_normreplay.Adr_label_compteur), StrCompteur);
}

void WinNormReplay_Create (gchar *title)
{
	var_normreplay.Bool_Is_Close = FALSE;
	create_WinNormReplay (title);
}















